/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "../../node_modules/dompurify/dist/purify.es.mjs":
/*!*******************************************************!*\
  !*** ../../node_modules/dompurify/dist/purify.es.mjs ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ purify)
/* harmony export */ });
/*! @license DOMPurify 3.2.6 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.2.6/LICENSE */

const {
  entries,
  setPrototypeOf,
  isFrozen,
  getPrototypeOf,
  getOwnPropertyDescriptor
} = Object;
let {
  freeze,
  seal,
  create
} = Object; // eslint-disable-line import/no-mutable-exports
let {
  apply,
  construct
} = typeof Reflect !== 'undefined' && Reflect;
if (!freeze) {
  freeze = function freeze(x) {
    return x;
  };
}
if (!seal) {
  seal = function seal(x) {
    return x;
  };
}
if (!apply) {
  apply = function apply(fun, thisValue, args) {
    return fun.apply(thisValue, args);
  };
}
if (!construct) {
  construct = function construct(Func, args) {
    return new Func(...args);
  };
}
const arrayForEach = unapply(Array.prototype.forEach);
const arrayLastIndexOf = unapply(Array.prototype.lastIndexOf);
const arrayPop = unapply(Array.prototype.pop);
const arrayPush = unapply(Array.prototype.push);
const arraySplice = unapply(Array.prototype.splice);
const stringToLowerCase = unapply(String.prototype.toLowerCase);
const stringToString = unapply(String.prototype.toString);
const stringMatch = unapply(String.prototype.match);
const stringReplace = unapply(String.prototype.replace);
const stringIndexOf = unapply(String.prototype.indexOf);
const stringTrim = unapply(String.prototype.trim);
const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
const regExpTest = unapply(RegExp.prototype.test);
const typeErrorCreate = unconstruct(TypeError);
/**
 * Creates a new function that calls the given function with a specified thisArg and arguments.
 *
 * @param func - The function to be wrapped and called.
 * @returns A new function that calls the given function with a specified thisArg and arguments.
 */
function unapply(func) {
  return function (thisArg) {
    if (thisArg instanceof RegExp) {
      thisArg.lastIndex = 0;
    }
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    return apply(func, thisArg, args);
  };
}
/**
 * Creates a new function that constructs an instance of the given constructor function with the provided arguments.
 *
 * @param func - The constructor function to be wrapped and called.
 * @returns A new function that constructs an instance of the given constructor function with the provided arguments.
 */
function unconstruct(func) {
  return function () {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    return construct(func, args);
  };
}
/**
 * Add properties to a lookup table
 *
 * @param set - The set to which elements will be added.
 * @param array - The array containing elements to be added to the set.
 * @param transformCaseFunc - An optional function to transform the case of each element before adding to the set.
 * @returns The modified set with added elements.
 */
function addToSet(set, array) {
  let transformCaseFunc = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : stringToLowerCase;
  if (setPrototypeOf) {
    // Make 'in' and truthy checks like Boolean(set.constructor)
    // independent of any properties defined on Object.prototype.
    // Prevent prototype setters from intercepting set as a this value.
    setPrototypeOf(set, null);
  }
  let l = array.length;
  while (l--) {
    let element = array[l];
    if (typeof element === 'string') {
      const lcElement = transformCaseFunc(element);
      if (lcElement !== element) {
        // Config presets (e.g. tags.js, attrs.js) are immutable.
        if (!isFrozen(array)) {
          array[l] = lcElement;
        }
        element = lcElement;
      }
    }
    set[element] = true;
  }
  return set;
}
/**
 * Clean up an array to harden against CSPP
 *
 * @param array - The array to be cleaned.
 * @returns The cleaned version of the array
 */
function cleanArray(array) {
  for (let index = 0; index < array.length; index++) {
    const isPropertyExist = objectHasOwnProperty(array, index);
    if (!isPropertyExist) {
      array[index] = null;
    }
  }
  return array;
}
/**
 * Shallow clone an object
 *
 * @param object - The object to be cloned.
 * @returns A new object that copies the original.
 */
function clone(object) {
  const newObject = create(null);
  for (const [property, value] of entries(object)) {
    const isPropertyExist = objectHasOwnProperty(object, property);
    if (isPropertyExist) {
      if (Array.isArray(value)) {
        newObject[property] = cleanArray(value);
      } else if (value && typeof value === 'object' && value.constructor === Object) {
        newObject[property] = clone(value);
      } else {
        newObject[property] = value;
      }
    }
  }
  return newObject;
}
/**
 * This method automatically checks if the prop is function or getter and behaves accordingly.
 *
 * @param object - The object to look up the getter function in its prototype chain.
 * @param prop - The property name for which to find the getter function.
 * @returns The getter function found in the prototype chain or a fallback function.
 */
function lookupGetter(object, prop) {
  while (object !== null) {
    const desc = getOwnPropertyDescriptor(object, prop);
    if (desc) {
      if (desc.get) {
        return unapply(desc.get);
      }
      if (typeof desc.value === 'function') {
        return unapply(desc.value);
      }
    }
    object = getPrototypeOf(object);
  }
  function fallbackValue() {
    return null;
  }
  return fallbackValue;
}

const html$1 = freeze(['a', 'abbr', 'acronym', 'address', 'area', 'article', 'aside', 'audio', 'b', 'bdi', 'bdo', 'big', 'blink', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'content', 'data', 'datalist', 'dd', 'decorator', 'del', 'details', 'dfn', 'dialog', 'dir', 'div', 'dl', 'dt', 'element', 'em', 'fieldset', 'figcaption', 'figure', 'font', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meter', 'nav', 'nobr', 'ol', 'optgroup', 'option', 'output', 'p', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'section', 'select', 'shadow', 'small', 'source', 'spacer', 'span', 'strike', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'track', 'tt', 'u', 'ul', 'var', 'video', 'wbr']);
const svg$1 = freeze(['svg', 'a', 'altglyph', 'altglyphdef', 'altglyphitem', 'animatecolor', 'animatemotion', 'animatetransform', 'circle', 'clippath', 'defs', 'desc', 'ellipse', 'filter', 'font', 'g', 'glyph', 'glyphref', 'hkern', 'image', 'line', 'lineargradient', 'marker', 'mask', 'metadata', 'mpath', 'path', 'pattern', 'polygon', 'polyline', 'radialgradient', 'rect', 'stop', 'style', 'switch', 'symbol', 'text', 'textpath', 'title', 'tref', 'tspan', 'view', 'vkern']);
const svgFilters = freeze(['feBlend', 'feColorMatrix', 'feComponentTransfer', 'feComposite', 'feConvolveMatrix', 'feDiffuseLighting', 'feDisplacementMap', 'feDistantLight', 'feDropShadow', 'feFlood', 'feFuncA', 'feFuncB', 'feFuncG', 'feFuncR', 'feGaussianBlur', 'feImage', 'feMerge', 'feMergeNode', 'feMorphology', 'feOffset', 'fePointLight', 'feSpecularLighting', 'feSpotLight', 'feTile', 'feTurbulence']);
// List of SVG elements that are disallowed by default.
// We still need to know them so that we can do namespace
// checks properly in case one wants to add them to
// allow-list.
const svgDisallowed = freeze(['animate', 'color-profile', 'cursor', 'discard', 'font-face', 'font-face-format', 'font-face-name', 'font-face-src', 'font-face-uri', 'foreignobject', 'hatch', 'hatchpath', 'mesh', 'meshgradient', 'meshpatch', 'meshrow', 'missing-glyph', 'script', 'set', 'solidcolor', 'unknown', 'use']);
const mathMl$1 = freeze(['math', 'menclose', 'merror', 'mfenced', 'mfrac', 'mglyph', 'mi', 'mlabeledtr', 'mmultiscripts', 'mn', 'mo', 'mover', 'mpadded', 'mphantom', 'mroot', 'mrow', 'ms', 'mspace', 'msqrt', 'mstyle', 'msub', 'msup', 'msubsup', 'mtable', 'mtd', 'mtext', 'mtr', 'munder', 'munderover', 'mprescripts']);
// Similarly to SVG, we want to know all MathML elements,
// even those that we disallow by default.
const mathMlDisallowed = freeze(['maction', 'maligngroup', 'malignmark', 'mlongdiv', 'mscarries', 'mscarry', 'msgroup', 'mstack', 'msline', 'msrow', 'semantics', 'annotation', 'annotation-xml', 'mprescripts', 'none']);
const text = freeze(['#text']);

const html = freeze(['accept', 'action', 'align', 'alt', 'autocapitalize', 'autocomplete', 'autopictureinpicture', 'autoplay', 'background', 'bgcolor', 'border', 'capture', 'cellpadding', 'cellspacing', 'checked', 'cite', 'class', 'clear', 'color', 'cols', 'colspan', 'controls', 'controlslist', 'coords', 'crossorigin', 'datetime', 'decoding', 'default', 'dir', 'disabled', 'disablepictureinpicture', 'disableremoteplayback', 'download', 'draggable', 'enctype', 'enterkeyhint', 'face', 'for', 'headers', 'height', 'hidden', 'high', 'href', 'hreflang', 'id', 'inputmode', 'integrity', 'ismap', 'kind', 'label', 'lang', 'list', 'loading', 'loop', 'low', 'max', 'maxlength', 'media', 'method', 'min', 'minlength', 'multiple', 'muted', 'name', 'nonce', 'noshade', 'novalidate', 'nowrap', 'open', 'optimum', 'pattern', 'placeholder', 'playsinline', 'popover', 'popovertarget', 'popovertargetaction', 'poster', 'preload', 'pubdate', 'radiogroup', 'readonly', 'rel', 'required', 'rev', 'reversed', 'role', 'rows', 'rowspan', 'spellcheck', 'scope', 'selected', 'shape', 'size', 'sizes', 'span', 'srclang', 'start', 'src', 'srcset', 'step', 'style', 'summary', 'tabindex', 'title', 'translate', 'type', 'usemap', 'valign', 'value', 'width', 'wrap', 'xmlns', 'slot']);
const svg = freeze(['accent-height', 'accumulate', 'additive', 'alignment-baseline', 'amplitude', 'ascent', 'attributename', 'attributetype', 'azimuth', 'basefrequency', 'baseline-shift', 'begin', 'bias', 'by', 'class', 'clip', 'clippathunits', 'clip-path', 'clip-rule', 'color', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'cx', 'cy', 'd', 'dx', 'dy', 'diffuseconstant', 'direction', 'display', 'divisor', 'dur', 'edgemode', 'elevation', 'end', 'exponent', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'filterunits', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'fx', 'fy', 'g1', 'g2', 'glyph-name', 'glyphref', 'gradientunits', 'gradienttransform', 'height', 'href', 'id', 'image-rendering', 'in', 'in2', 'intercept', 'k', 'k1', 'k2', 'k3', 'k4', 'kerning', 'keypoints', 'keysplines', 'keytimes', 'lang', 'lengthadjust', 'letter-spacing', 'kernelmatrix', 'kernelunitlength', 'lighting-color', 'local', 'marker-end', 'marker-mid', 'marker-start', 'markerheight', 'markerunits', 'markerwidth', 'maskcontentunits', 'maskunits', 'max', 'mask', 'media', 'method', 'mode', 'min', 'name', 'numoctaves', 'offset', 'operator', 'opacity', 'order', 'orient', 'orientation', 'origin', 'overflow', 'paint-order', 'path', 'pathlength', 'patterncontentunits', 'patterntransform', 'patternunits', 'points', 'preservealpha', 'preserveaspectratio', 'primitiveunits', 'r', 'rx', 'ry', 'radius', 'refx', 'refy', 'repeatcount', 'repeatdur', 'restart', 'result', 'rotate', 'scale', 'seed', 'shape-rendering', 'slope', 'specularconstant', 'specularexponent', 'spreadmethod', 'startoffset', 'stddeviation', 'stitchtiles', 'stop-color', 'stop-opacity', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke', 'stroke-width', 'style', 'surfacescale', 'systemlanguage', 'tabindex', 'tablevalues', 'targetx', 'targety', 'transform', 'transform-origin', 'text-anchor', 'text-decoration', 'text-rendering', 'textlength', 'type', 'u1', 'u2', 'unicode', 'values', 'viewbox', 'visibility', 'version', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'width', 'word-spacing', 'wrap', 'writing-mode', 'xchannelselector', 'ychannelselector', 'x', 'x1', 'x2', 'xmlns', 'y', 'y1', 'y2', 'z', 'zoomandpan']);
const mathMl = freeze(['accent', 'accentunder', 'align', 'bevelled', 'close', 'columnsalign', 'columnlines', 'columnspan', 'denomalign', 'depth', 'dir', 'display', 'displaystyle', 'encoding', 'fence', 'frame', 'height', 'href', 'id', 'largeop', 'length', 'linethickness', 'lspace', 'lquote', 'mathbackground', 'mathcolor', 'mathsize', 'mathvariant', 'maxsize', 'minsize', 'movablelimits', 'notation', 'numalign', 'open', 'rowalign', 'rowlines', 'rowspacing', 'rowspan', 'rspace', 'rquote', 'scriptlevel', 'scriptminsize', 'scriptsizemultiplier', 'selection', 'separator', 'separators', 'stretchy', 'subscriptshift', 'supscriptshift', 'symmetric', 'voffset', 'width', 'xmlns']);
const xml = freeze(['xlink:href', 'xml:id', 'xlink:title', 'xml:space', 'xmlns:xlink']);

// eslint-disable-next-line unicorn/better-regex
const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm); // Specify template detection regex for SAFE_FOR_TEMPLATES mode
const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
const TMPLIT_EXPR = seal(/\$\{[\w\W]*/gm); // eslint-disable-line unicorn/better-regex
const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]+$/); // eslint-disable-line no-useless-escape
const ARIA_ATTR = seal(/^aria-[\-\w]+$/); // eslint-disable-line no-useless-escape
const IS_ALLOWED_URI = seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp|matrix):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i // eslint-disable-line no-useless-escape
);
const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
const ATTR_WHITESPACE = seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g // eslint-disable-line no-control-regex
);
const DOCTYPE_NAME = seal(/^html$/i);
const CUSTOM_ELEMENT = seal(/^[a-z][.\w]*(-[.\w]+)+$/i);

var EXPRESSIONS = /*#__PURE__*/Object.freeze({
  __proto__: null,
  ARIA_ATTR: ARIA_ATTR,
  ATTR_WHITESPACE: ATTR_WHITESPACE,
  CUSTOM_ELEMENT: CUSTOM_ELEMENT,
  DATA_ATTR: DATA_ATTR,
  DOCTYPE_NAME: DOCTYPE_NAME,
  ERB_EXPR: ERB_EXPR,
  IS_ALLOWED_URI: IS_ALLOWED_URI,
  IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA,
  MUSTACHE_EXPR: MUSTACHE_EXPR,
  TMPLIT_EXPR: TMPLIT_EXPR
});

/* eslint-disable @typescript-eslint/indent */
// https://developer.mozilla.org/en-US/docs/Web/API/Node/nodeType
const NODE_TYPE = {
  element: 1,
  attribute: 2,
  text: 3,
  cdataSection: 4,
  entityReference: 5,
  // Deprecated
  entityNode: 6,
  // Deprecated
  progressingInstruction: 7,
  comment: 8,
  document: 9,
  documentType: 10,
  documentFragment: 11,
  notation: 12 // Deprecated
};
const getGlobal = function getGlobal() {
  return typeof window === 'undefined' ? null : window;
};
/**
 * Creates a no-op policy for internal use only.
 * Don't export this function outside this module!
 * @param trustedTypes The policy factory.
 * @param purifyHostElement The Script element used to load DOMPurify (to determine policy name suffix).
 * @return The policy created (or null, if Trusted Types
 * are not supported or creating the policy failed).
 */
const _createTrustedTypesPolicy = function _createTrustedTypesPolicy(trustedTypes, purifyHostElement) {
  if (typeof trustedTypes !== 'object' || typeof trustedTypes.createPolicy !== 'function') {
    return null;
  }
  // Allow the callers to control the unique policy name
  // by adding a data-tt-policy-suffix to the script element with the DOMPurify.
  // Policy creation with duplicate names throws in Trusted Types.
  let suffix = null;
  const ATTR_NAME = 'data-tt-policy-suffix';
  if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
    suffix = purifyHostElement.getAttribute(ATTR_NAME);
  }
  const policyName = 'dompurify' + (suffix ? '#' + suffix : '');
  try {
    return trustedTypes.createPolicy(policyName, {
      createHTML(html) {
        return html;
      },
      createScriptURL(scriptUrl) {
        return scriptUrl;
      }
    });
  } catch (_) {
    // Policy creation failed (most likely another DOMPurify script has
    // already run). Skip creating the policy, as this will only cause errors
    // if TT are enforced.
    console.warn('TrustedTypes policy ' + policyName + ' could not be created.');
    return null;
  }
};
const _createHooksMap = function _createHooksMap() {
  return {
    afterSanitizeAttributes: [],
    afterSanitizeElements: [],
    afterSanitizeShadowDOM: [],
    beforeSanitizeAttributes: [],
    beforeSanitizeElements: [],
    beforeSanitizeShadowDOM: [],
    uponSanitizeAttribute: [],
    uponSanitizeElement: [],
    uponSanitizeShadowNode: []
  };
};
function createDOMPurify() {
  let window = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : getGlobal();
  const DOMPurify = root => createDOMPurify(root);
  DOMPurify.version = '3.2.6';
  DOMPurify.removed = [];
  if (!window || !window.document || window.document.nodeType !== NODE_TYPE.document || !window.Element) {
    // Not running in a browser, provide a factory function
    // so that you can pass your own Window
    DOMPurify.isSupported = false;
    return DOMPurify;
  }
  let {
    document
  } = window;
  const originalDocument = document;
  const currentScript = originalDocument.currentScript;
  const {
    DocumentFragment,
    HTMLTemplateElement,
    Node,
    Element,
    NodeFilter,
    NamedNodeMap = window.NamedNodeMap || window.MozNamedAttrMap,
    HTMLFormElement,
    DOMParser,
    trustedTypes
  } = window;
  const ElementPrototype = Element.prototype;
  const cloneNode = lookupGetter(ElementPrototype, 'cloneNode');
  const remove = lookupGetter(ElementPrototype, 'remove');
  const getNextSibling = lookupGetter(ElementPrototype, 'nextSibling');
  const getChildNodes = lookupGetter(ElementPrototype, 'childNodes');
  const getParentNode = lookupGetter(ElementPrototype, 'parentNode');
  // As per issue #47, the web-components registry is inherited by a
  // new document created via createHTMLDocument. As per the spec
  // (http://w3c.github.io/webcomponents/spec/custom/#creating-and-passing-registries)
  // a new empty registry is used when creating a template contents owner
  // document, so we use that as our parent document to ensure nothing
  // is inherited.
  if (typeof HTMLTemplateElement === 'function') {
    const template = document.createElement('template');
    if (template.content && template.content.ownerDocument) {
      document = template.content.ownerDocument;
    }
  }
  let trustedTypesPolicy;
  let emptyHTML = '';
  const {
    implementation,
    createNodeIterator,
    createDocumentFragment,
    getElementsByTagName
  } = document;
  const {
    importNode
  } = originalDocument;
  let hooks = _createHooksMap();
  /**
   * Expose whether this browser supports running the full DOMPurify.
   */
  DOMPurify.isSupported = typeof entries === 'function' && typeof getParentNode === 'function' && implementation && implementation.createHTMLDocument !== undefined;
  const {
    MUSTACHE_EXPR,
    ERB_EXPR,
    TMPLIT_EXPR,
    DATA_ATTR,
    ARIA_ATTR,
    IS_SCRIPT_OR_DATA,
    ATTR_WHITESPACE,
    CUSTOM_ELEMENT
  } = EXPRESSIONS;
  let {
    IS_ALLOWED_URI: IS_ALLOWED_URI$1
  } = EXPRESSIONS;
  /**
   * We consider the elements and attributes below to be safe. Ideally
   * don't add any new ones but feel free to remove unwanted ones.
   */
  /* allowed element names */
  let ALLOWED_TAGS = null;
  const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text]);
  /* Allowed attribute names */
  let ALLOWED_ATTR = null;
  const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
  /*
   * Configure how DOMPurify should handle custom elements and their attributes as well as customized built-in elements.
   * @property {RegExp|Function|null} tagNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any custom elements)
   * @property {RegExp|Function|null} attributeNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any attributes not on the allow list)
   * @property {boolean} allowCustomizedBuiltInElements allow custom elements derived from built-ins if they pass CUSTOM_ELEMENT_HANDLING.tagNameCheck. Default: `false`.
   */
  let CUSTOM_ELEMENT_HANDLING = Object.seal(create(null, {
    tagNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    attributeNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    allowCustomizedBuiltInElements: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: false
    }
  }));
  /* Explicitly forbidden tags (overrides ALLOWED_TAGS/ADD_TAGS) */
  let FORBID_TAGS = null;
  /* Explicitly forbidden attributes (overrides ALLOWED_ATTR/ADD_ATTR) */
  let FORBID_ATTR = null;
  /* Decide if ARIA attributes are okay */
  let ALLOW_ARIA_ATTR = true;
  /* Decide if custom data attributes are okay */
  let ALLOW_DATA_ATTR = true;
  /* Decide if unknown protocols are okay */
  let ALLOW_UNKNOWN_PROTOCOLS = false;
  /* Decide if self-closing tags in attributes are allowed.
   * Usually removed due to a mXSS issue in jQuery 3.0 */
  let ALLOW_SELF_CLOSE_IN_ATTR = true;
  /* Output should be safe for common template engines.
   * This means, DOMPurify removes data attributes, mustaches and ERB
   */
  let SAFE_FOR_TEMPLATES = false;
  /* Output should be safe even for XML used within HTML and alike.
   * This means, DOMPurify removes comments when containing risky content.
   */
  let SAFE_FOR_XML = true;
  /* Decide if document with <html>... should be returned */
  let WHOLE_DOCUMENT = false;
  /* Track whether config is already set on this instance of DOMPurify. */
  let SET_CONFIG = false;
  /* Decide if all elements (e.g. style, script) must be children of
   * document.body. By default, browsers might move them to document.head */
  let FORCE_BODY = false;
  /* Decide if a DOM `HTMLBodyElement` should be returned, instead of a html
   * string (or a TrustedHTML object if Trusted Types are supported).
   * If `WHOLE_DOCUMENT` is enabled a `HTMLHtmlElement` will be returned instead
   */
  let RETURN_DOM = false;
  /* Decide if a DOM `DocumentFragment` should be returned, instead of a html
   * string  (or a TrustedHTML object if Trusted Types are supported) */
  let RETURN_DOM_FRAGMENT = false;
  /* Try to return a Trusted Type object instead of a string, return a string in
   * case Trusted Types are not supported  */
  let RETURN_TRUSTED_TYPE = false;
  /* Output should be free from DOM clobbering attacks?
   * This sanitizes markups named with colliding, clobberable built-in DOM APIs.
   */
  let SANITIZE_DOM = true;
  /* Achieve full DOM Clobbering protection by isolating the namespace of named
   * properties and JS variables, mitigating attacks that abuse the HTML/DOM spec rules.
   *
   * HTML/DOM spec rules that enable DOM Clobbering:
   *   - Named Access on Window (§7.3.3)
   *   - DOM Tree Accessors (§3.1.5)
   *   - Form Element Parent-Child Relations (§4.10.3)
   *   - Iframe srcdoc / Nested WindowProxies (§4.8.5)
   *   - HTMLCollection (§4.2.10.2)
   *
   * Namespace isolation is implemented by prefixing `id` and `name` attributes
   * with a constant string, i.e., `user-content-`
   */
  let SANITIZE_NAMED_PROPS = false;
  const SANITIZE_NAMED_PROPS_PREFIX = 'user-content-';
  /* Keep element content when removing element? */
  let KEEP_CONTENT = true;
  /* If a `Node` is passed to sanitize(), then performs sanitization in-place instead
   * of importing it into a new Document and returning a sanitized copy */
  let IN_PLACE = false;
  /* Allow usage of profiles like html, svg and mathMl */
  let USE_PROFILES = {};
  /* Tags to ignore content of when KEEP_CONTENT is true */
  let FORBID_CONTENTS = null;
  const DEFAULT_FORBID_CONTENTS = addToSet({}, ['annotation-xml', 'audio', 'colgroup', 'desc', 'foreignobject', 'head', 'iframe', 'math', 'mi', 'mn', 'mo', 'ms', 'mtext', 'noembed', 'noframes', 'noscript', 'plaintext', 'script', 'style', 'svg', 'template', 'thead', 'title', 'video', 'xmp']);
  /* Tags that are safe for data: URIs */
  let DATA_URI_TAGS = null;
  const DEFAULT_DATA_URI_TAGS = addToSet({}, ['audio', 'video', 'img', 'source', 'image', 'track']);
  /* Attributes safe for values like "javascript:" */
  let URI_SAFE_ATTRIBUTES = null;
  const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ['alt', 'class', 'for', 'id', 'label', 'name', 'pattern', 'placeholder', 'role', 'summary', 'title', 'value', 'style', 'xmlns']);
  const MATHML_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';
  const SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
  const HTML_NAMESPACE = 'http://www.w3.org/1999/xhtml';
  /* Document namespace */
  let NAMESPACE = HTML_NAMESPACE;
  let IS_EMPTY_INPUT = false;
  /* Allowed XHTML+XML namespaces */
  let ALLOWED_NAMESPACES = null;
  const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
  let MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ['mi', 'mo', 'mn', 'ms', 'mtext']);
  let HTML_INTEGRATION_POINTS = addToSet({}, ['annotation-xml']);
  // Certain elements are allowed in both SVG and HTML
  // namespace. We need to specify them explicitly
  // so that they don't get erroneously deleted from
  // HTML namespace.
  const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ['title', 'style', 'font', 'a', 'script']);
  /* Parsing of strict XHTML documents */
  let PARSER_MEDIA_TYPE = null;
  const SUPPORTED_PARSER_MEDIA_TYPES = ['application/xhtml+xml', 'text/html'];
  const DEFAULT_PARSER_MEDIA_TYPE = 'text/html';
  let transformCaseFunc = null;
  /* Keep a reference to config to pass to hooks */
  let CONFIG = null;
  /* Ideally, do not touch anything below this line */
  /* ______________________________________________ */
  const formElement = document.createElement('form');
  const isRegexOrFunction = function isRegexOrFunction(testValue) {
    return testValue instanceof RegExp || testValue instanceof Function;
  };
  /**
   * _parseConfig
   *
   * @param cfg optional config literal
   */
  // eslint-disable-next-line complexity
  const _parseConfig = function _parseConfig() {
    let cfg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (CONFIG && CONFIG === cfg) {
      return;
    }
    /* Shield configuration object from tampering */
    if (!cfg || typeof cfg !== 'object') {
      cfg = {};
    }
    /* Shield configuration object from prototype pollution */
    cfg = clone(cfg);
    PARSER_MEDIA_TYPE =
    // eslint-disable-next-line unicorn/prefer-includes
    SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;
    // HTML tags and attributes are not case-sensitive, converting to lowercase. Keeping XHTML as is.
    transformCaseFunc = PARSER_MEDIA_TYPE === 'application/xhtml+xml' ? stringToString : stringToLowerCase;
    /* Set configuration parameters */
    ALLOWED_TAGS = objectHasOwnProperty(cfg, 'ALLOWED_TAGS') ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
    ALLOWED_ATTR = objectHasOwnProperty(cfg, 'ALLOWED_ATTR') ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
    ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, 'ALLOWED_NAMESPACES') ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
    URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, 'ADD_URI_SAFE_ATTR') ? addToSet(clone(DEFAULT_URI_SAFE_ATTRIBUTES), cfg.ADD_URI_SAFE_ATTR, transformCaseFunc) : DEFAULT_URI_SAFE_ATTRIBUTES;
    DATA_URI_TAGS = objectHasOwnProperty(cfg, 'ADD_DATA_URI_TAGS') ? addToSet(clone(DEFAULT_DATA_URI_TAGS), cfg.ADD_DATA_URI_TAGS, transformCaseFunc) : DEFAULT_DATA_URI_TAGS;
    FORBID_CONTENTS = objectHasOwnProperty(cfg, 'FORBID_CONTENTS') ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
    FORBID_TAGS = objectHasOwnProperty(cfg, 'FORBID_TAGS') ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : clone({});
    FORBID_ATTR = objectHasOwnProperty(cfg, 'FORBID_ATTR') ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : clone({});
    USE_PROFILES = objectHasOwnProperty(cfg, 'USE_PROFILES') ? cfg.USE_PROFILES : false;
    ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false; // Default true
    ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false; // Default true
    ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false; // Default false
    ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false; // Default true
    SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false; // Default false
    SAFE_FOR_XML = cfg.SAFE_FOR_XML !== false; // Default true
    WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false; // Default false
    RETURN_DOM = cfg.RETURN_DOM || false; // Default false
    RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false; // Default false
    RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false; // Default false
    FORCE_BODY = cfg.FORCE_BODY || false; // Default false
    SANITIZE_DOM = cfg.SANITIZE_DOM !== false; // Default true
    SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false; // Default false
    KEEP_CONTENT = cfg.KEEP_CONTENT !== false; // Default true
    IN_PLACE = cfg.IN_PLACE || false; // Default false
    IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
    NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
    MATHML_TEXT_INTEGRATION_POINTS = cfg.MATHML_TEXT_INTEGRATION_POINTS || MATHML_TEXT_INTEGRATION_POINTS;
    HTML_INTEGRATION_POINTS = cfg.HTML_INTEGRATION_POINTS || HTML_INTEGRATION_POINTS;
    CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === 'boolean') {
      CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
    }
    if (SAFE_FOR_TEMPLATES) {
      ALLOW_DATA_ATTR = false;
    }
    if (RETURN_DOM_FRAGMENT) {
      RETURN_DOM = true;
    }
    /* Parse profile info */
    if (USE_PROFILES) {
      ALLOWED_TAGS = addToSet({}, text);
      ALLOWED_ATTR = [];
      if (USE_PROFILES.html === true) {
        addToSet(ALLOWED_TAGS, html$1);
        addToSet(ALLOWED_ATTR, html);
      }
      if (USE_PROFILES.svg === true) {
        addToSet(ALLOWED_TAGS, svg$1);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.svgFilters === true) {
        addToSet(ALLOWED_TAGS, svgFilters);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.mathMl === true) {
        addToSet(ALLOWED_TAGS, mathMl$1);
        addToSet(ALLOWED_ATTR, mathMl);
        addToSet(ALLOWED_ATTR, xml);
      }
    }
    /* Merge configuration parameters */
    if (cfg.ADD_TAGS) {
      if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
        ALLOWED_TAGS = clone(ALLOWED_TAGS);
      }
      addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
    }
    if (cfg.ADD_ATTR) {
      if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
        ALLOWED_ATTR = clone(ALLOWED_ATTR);
      }
      addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
    }
    if (cfg.ADD_URI_SAFE_ATTR) {
      addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
    }
    if (cfg.FORBID_CONTENTS) {
      if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
        FORBID_CONTENTS = clone(FORBID_CONTENTS);
      }
      addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
    }
    /* Add #text in case KEEP_CONTENT is set to true */
    if (KEEP_CONTENT) {
      ALLOWED_TAGS['#text'] = true;
    }
    /* Add html, head and body to ALLOWED_TAGS in case WHOLE_DOCUMENT is true */
    if (WHOLE_DOCUMENT) {
      addToSet(ALLOWED_TAGS, ['html', 'head', 'body']);
    }
    /* Add tbody to ALLOWED_TAGS in case tables are permitted, see #286, #365 */
    if (ALLOWED_TAGS.table) {
      addToSet(ALLOWED_TAGS, ['tbody']);
      delete FORBID_TAGS.tbody;
    }
    if (cfg.TRUSTED_TYPES_POLICY) {
      if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== 'function') {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
      }
      if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== 'function') {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
      }
      // Overwrite existing TrustedTypes policy.
      trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
      // Sign local variables required by `sanitize`.
      emptyHTML = trustedTypesPolicy.createHTML('');
    } else {
      // Uninitialized policy, attempt to initialize the internal dompurify policy.
      if (trustedTypesPolicy === undefined) {
        trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
      }
      // If creating the internal policy succeeded sign internal variables.
      if (trustedTypesPolicy !== null && typeof emptyHTML === 'string') {
        emptyHTML = trustedTypesPolicy.createHTML('');
      }
    }
    // Prevent further manipulation of configuration.
    // Not available in IE8, Safari 5, etc.
    if (freeze) {
      freeze(cfg);
    }
    CONFIG = cfg;
  };
  /* Keep track of all possible SVG and MathML tags
   * so that we can perform the namespace checks
   * correctly. */
  const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
  const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);
  /**
   * @param element a DOM element whose namespace is being checked
   * @returns Return false if the element has a
   *  namespace that a spec-compliant parser would never
   *  return. Return true otherwise.
   */
  const _checkValidNamespace = function _checkValidNamespace(element) {
    let parent = getParentNode(element);
    // In JSDOM, if we're inside shadow DOM, then parentNode
    // can be null. We just simulate parent in this case.
    if (!parent || !parent.tagName) {
      parent = {
        namespaceURI: NAMESPACE,
        tagName: 'template'
      };
    }
    const tagName = stringToLowerCase(element.tagName);
    const parentTagName = stringToLowerCase(parent.tagName);
    if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
      return false;
    }
    if (element.namespaceURI === SVG_NAMESPACE) {
      // The only way to switch from HTML namespace to SVG
      // is via <svg>. If it happens via any other tag, then
      // it should be killed.
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName === 'svg';
      }
      // The only way to switch from MathML to SVG is via`
      // svg if parent is either <annotation-xml> or MathML
      // text integration points.
      if (parent.namespaceURI === MATHML_NAMESPACE) {
        return tagName === 'svg' && (parentTagName === 'annotation-xml' || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
      }
      // We only allow elements that are defined in SVG
      // spec. All others are disallowed in SVG namespace.
      return Boolean(ALL_SVG_TAGS[tagName]);
    }
    if (element.namespaceURI === MATHML_NAMESPACE) {
      // The only way to switch from HTML namespace to MathML
      // is via <math>. If it happens via any other tag, then
      // it should be killed.
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName === 'math';
      }
      // The only way to switch from SVG to MathML is via
      // <math> and HTML integration points
      if (parent.namespaceURI === SVG_NAMESPACE) {
        return tagName === 'math' && HTML_INTEGRATION_POINTS[parentTagName];
      }
      // We only allow elements that are defined in MathML
      // spec. All others are disallowed in MathML namespace.
      return Boolean(ALL_MATHML_TAGS[tagName]);
    }
    if (element.namespaceURI === HTML_NAMESPACE) {
      // The only way to switch from SVG to HTML is via
      // HTML integration points, and from MathML to HTML
      // is via MathML text integration points
      if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      // We disallow tags that are specific for MathML
      // or SVG and should never appear in HTML namespace
      return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
    }
    // For XHTML and XML documents that support custom namespaces
    if (PARSER_MEDIA_TYPE === 'application/xhtml+xml' && ALLOWED_NAMESPACES[element.namespaceURI]) {
      return true;
    }
    // The code should never reach this place (this means
    // that the element somehow got namespace that is not
    // HTML, SVG, MathML or allowed via ALLOWED_NAMESPACES).
    // Return false just in case.
    return false;
  };
  /**
   * _forceRemove
   *
   * @param node a DOM node
   */
  const _forceRemove = function _forceRemove(node) {
    arrayPush(DOMPurify.removed, {
      element: node
    });
    try {
      // eslint-disable-next-line unicorn/prefer-dom-node-remove
      getParentNode(node).removeChild(node);
    } catch (_) {
      remove(node);
    }
  };
  /**
   * _removeAttribute
   *
   * @param name an Attribute name
   * @param element a DOM node
   */
  const _removeAttribute = function _removeAttribute(name, element) {
    try {
      arrayPush(DOMPurify.removed, {
        attribute: element.getAttributeNode(name),
        from: element
      });
    } catch (_) {
      arrayPush(DOMPurify.removed, {
        attribute: null,
        from: element
      });
    }
    element.removeAttribute(name);
    // We void attribute values for unremovable "is" attributes
    if (name === 'is') {
      if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
        try {
          _forceRemove(element);
        } catch (_) {}
      } else {
        try {
          element.setAttribute(name, '');
        } catch (_) {}
      }
    }
  };
  /**
   * _initDocument
   *
   * @param dirty - a string of dirty markup
   * @return a DOM, filled with the dirty markup
   */
  const _initDocument = function _initDocument(dirty) {
    /* Create a HTML document */
    let doc = null;
    let leadingWhitespace = null;
    if (FORCE_BODY) {
      dirty = '<remove></remove>' + dirty;
    } else {
      /* If FORCE_BODY isn't used, leading whitespace needs to be preserved manually */
      const matches = stringMatch(dirty, /^[\r\n\t ]+/);
      leadingWhitespace = matches && matches[0];
    }
    if (PARSER_MEDIA_TYPE === 'application/xhtml+xml' && NAMESPACE === HTML_NAMESPACE) {
      // Root of XHTML doc must contain xmlns declaration (see https://www.w3.org/TR/xhtml1/normative.html#strict)
      dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + '</body></html>';
    }
    const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
    /*
     * Use the DOMParser API by default, fallback later if needs be
     * DOMParser not work for svg when has multiple root element.
     */
    if (NAMESPACE === HTML_NAMESPACE) {
      try {
        doc = new DOMParser().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
      } catch (_) {}
    }
    /* Use createHTMLDocument in case DOMParser is not available */
    if (!doc || !doc.documentElement) {
      doc = implementation.createDocument(NAMESPACE, 'template', null);
      try {
        doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
      } catch (_) {
        // Syntax error if dirtyPayload is invalid xml
      }
    }
    const body = doc.body || doc.documentElement;
    if (dirty && leadingWhitespace) {
      body.insertBefore(document.createTextNode(leadingWhitespace), body.childNodes[0] || null);
    }
    /* Work on whole document or just its body */
    if (NAMESPACE === HTML_NAMESPACE) {
      return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? 'html' : 'body')[0];
    }
    return WHOLE_DOCUMENT ? doc.documentElement : body;
  };
  /**
   * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.
   *
   * @param root The root element or node to start traversing on.
   * @return The created NodeIterator
   */
  const _createNodeIterator = function _createNodeIterator(root) {
    return createNodeIterator.call(root.ownerDocument || root, root,
    // eslint-disable-next-line no-bitwise
    NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT | NodeFilter.SHOW_PROCESSING_INSTRUCTION | NodeFilter.SHOW_CDATA_SECTION, null);
  };
  /**
   * _isClobbered
   *
   * @param element element to check for clobbering attacks
   * @return true if clobbered, false if safe
   */
  const _isClobbered = function _isClobbered(element) {
    return element instanceof HTMLFormElement && (typeof element.nodeName !== 'string' || typeof element.textContent !== 'string' || typeof element.removeChild !== 'function' || !(element.attributes instanceof NamedNodeMap) || typeof element.removeAttribute !== 'function' || typeof element.setAttribute !== 'function' || typeof element.namespaceURI !== 'string' || typeof element.insertBefore !== 'function' || typeof element.hasChildNodes !== 'function');
  };
  /**
   * Checks whether the given object is a DOM node.
   *
   * @param value object to check whether it's a DOM node
   * @return true is object is a DOM node
   */
  const _isNode = function _isNode(value) {
    return typeof Node === 'function' && value instanceof Node;
  };
  function _executeHooks(hooks, currentNode, data) {
    arrayForEach(hooks, hook => {
      hook.call(DOMPurify, currentNode, data, CONFIG);
    });
  }
  /**
   * _sanitizeElements
   *
   * @protect nodeName
   * @protect textContent
   * @protect removeChild
   * @param currentNode to check for permission to exist
   * @return true if node was killed, false if left alive
   */
  const _sanitizeElements = function _sanitizeElements(currentNode) {
    let content = null;
    /* Execute a hook if present */
    _executeHooks(hooks.beforeSanitizeElements, currentNode, null);
    /* Check if element is clobbered or can clobber */
    if (_isClobbered(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    /* Now let's check the element's type and name */
    const tagName = transformCaseFunc(currentNode.nodeName);
    /* Execute a hook if present */
    _executeHooks(hooks.uponSanitizeElement, currentNode, {
      tagName,
      allowedTags: ALLOWED_TAGS
    });
    /* Detect mXSS attempts abusing namespace confusion */
    if (SAFE_FOR_XML && currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w!]/g, currentNode.innerHTML) && regExpTest(/<[/\w!]/g, currentNode.textContent)) {
      _forceRemove(currentNode);
      return true;
    }
    /* Remove any occurrence of processing instructions */
    if (currentNode.nodeType === NODE_TYPE.progressingInstruction) {
      _forceRemove(currentNode);
      return true;
    }
    /* Remove any kind of possibly harmful comments */
    if (SAFE_FOR_XML && currentNode.nodeType === NODE_TYPE.comment && regExpTest(/<[/\w]/g, currentNode.data)) {
      _forceRemove(currentNode);
      return true;
    }
    /* Remove element if anything forbids its presence */
    if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
      /* Check if we have a custom element to handle */
      if (!FORBID_TAGS[tagName] && _isBasicCustomElement(tagName)) {
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) {
          return false;
        }
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) {
          return false;
        }
      }
      /* Keep content except for bad-listed elements */
      if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
        const parentNode = getParentNode(currentNode) || currentNode.parentNode;
        const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
        if (childNodes && parentNode) {
          const childCount = childNodes.length;
          for (let i = childCount - 1; i >= 0; --i) {
            const childClone = cloneNode(childNodes[i], true);
            childClone.__removalCount = (currentNode.__removalCount || 0) + 1;
            parentNode.insertBefore(childClone, getNextSibling(currentNode));
          }
        }
      }
      _forceRemove(currentNode);
      return true;
    }
    /* Check whether element has a valid namespace */
    if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    /* Make sure that older browsers don't get fallback-tag mXSS */
    if ((tagName === 'noscript' || tagName === 'noembed' || tagName === 'noframes') && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
      _forceRemove(currentNode);
      return true;
    }
    /* Sanitize element content to be template-safe */
    if (SAFE_FOR_TEMPLATES && currentNode.nodeType === NODE_TYPE.text) {
      /* Get the element's text content */
      content = currentNode.textContent;
      arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
        content = stringReplace(content, expr, ' ');
      });
      if (currentNode.textContent !== content) {
        arrayPush(DOMPurify.removed, {
          element: currentNode.cloneNode()
        });
        currentNode.textContent = content;
      }
    }
    /* Execute a hook if present */
    _executeHooks(hooks.afterSanitizeElements, currentNode, null);
    return false;
  };
  /**
   * _isValidAttribute
   *
   * @param lcTag Lowercase tag name of containing element.
   * @param lcName Lowercase attribute name.
   * @param value Attribute value.
   * @return Returns true if `value` is valid, otherwise false.
   */
  // eslint-disable-next-line complexity
  const _isValidAttribute = function _isValidAttribute(lcTag, lcName, value) {
    /* Make sure attribute cannot clobber */
    if (SANITIZE_DOM && (lcName === 'id' || lcName === 'name') && (value in document || value in formElement)) {
      return false;
    }
    /* Allow valid data-* attributes: At least one character after "-"
        (https://html.spec.whatwg.org/multipage/dom.html#embedding-custom-non-visible-data-with-the-data-*-attributes)
        XML-compatible (https://html.spec.whatwg.org/multipage/infrastructure.html#xml-compatible and http://www.w3.org/TR/xml/#d0e804)
        We don't need to check the value; it's always URI safe. */
    if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR, lcName)) ; else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR, lcName)) ; else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
      if (
      // First condition does a very basic check if a) it's basically a valid custom element tagname AND
      // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
      // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
      _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) ||
      // Alternative, second condition checks if it's an `is`-attribute, AND
      // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
      lcName === 'is' && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value))) ; else {
        return false;
      }
      /* Check value is safe. First, is attr inert? If so, is safe */
    } else if (URI_SAFE_ATTRIBUTES[lcName]) ; else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE, ''))) ; else if ((lcName === 'src' || lcName === 'xlink:href' || lcName === 'href') && lcTag !== 'script' && stringIndexOf(value, 'data:') === 0 && DATA_URI_TAGS[lcTag]) ; else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA, stringReplace(value, ATTR_WHITESPACE, ''))) ; else if (value) {
      return false;
    } else ;
    return true;
  };
  /**
   * _isBasicCustomElement
   * checks if at least one dash is included in tagName, and it's not the first char
   * for more sophisticated checking see https://github.com/sindresorhus/validate-element-name
   *
   * @param tagName name of the tag of the node to sanitize
   * @returns Returns true if the tag name meets the basic criteria for a custom element, otherwise false.
   */
  const _isBasicCustomElement = function _isBasicCustomElement(tagName) {
    return tagName !== 'annotation-xml' && stringMatch(tagName, CUSTOM_ELEMENT);
  };
  /**
   * _sanitizeAttributes
   *
   * @protect attributes
   * @protect nodeName
   * @protect removeAttribute
   * @protect setAttribute
   *
   * @param currentNode to sanitize
   */
  const _sanitizeAttributes = function _sanitizeAttributes(currentNode) {
    /* Execute a hook if present */
    _executeHooks(hooks.beforeSanitizeAttributes, currentNode, null);
    const {
      attributes
    } = currentNode;
    /* Check if we have attributes; if not we might have a text node */
    if (!attributes || _isClobbered(currentNode)) {
      return;
    }
    const hookEvent = {
      attrName: '',
      attrValue: '',
      keepAttr: true,
      allowedAttributes: ALLOWED_ATTR,
      forceKeepAttr: undefined
    };
    let l = attributes.length;
    /* Go backwards over all attributes; safely remove bad ones */
    while (l--) {
      const attr = attributes[l];
      const {
        name,
        namespaceURI,
        value: attrValue
      } = attr;
      const lcName = transformCaseFunc(name);
      const initValue = attrValue;
      let value = name === 'value' ? initValue : stringTrim(initValue);
      /* Execute a hook if present */
      hookEvent.attrName = lcName;
      hookEvent.attrValue = value;
      hookEvent.keepAttr = true;
      hookEvent.forceKeepAttr = undefined; // Allows developers to see this is a property they can set
      _executeHooks(hooks.uponSanitizeAttribute, currentNode, hookEvent);
      value = hookEvent.attrValue;
      /* Full DOM Clobbering protection via namespace isolation,
       * Prefix id and name attributes with `user-content-`
       */
      if (SANITIZE_NAMED_PROPS && (lcName === 'id' || lcName === 'name')) {
        // Remove the attribute with this value
        _removeAttribute(name, currentNode);
        // Prefix the value and later re-create the attribute with the sanitized value
        value = SANITIZE_NAMED_PROPS_PREFIX + value;
      }
      /* Work around a security issue with comments inside attributes */
      if (SAFE_FOR_XML && regExpTest(/((--!?|])>)|<\/(style|title)/i, value)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      /* Did the hooks approve of the attribute? */
      if (hookEvent.forceKeepAttr) {
        continue;
      }
      /* Did the hooks approve of the attribute? */
      if (!hookEvent.keepAttr) {
        _removeAttribute(name, currentNode);
        continue;
      }
      /* Work around a security issue in jQuery 3.0 */
      if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      /* Sanitize attribute content to be template-safe */
      if (SAFE_FOR_TEMPLATES) {
        arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
          value = stringReplace(value, expr, ' ');
        });
      }
      /* Is `value` valid for this attribute? */
      const lcTag = transformCaseFunc(currentNode.nodeName);
      if (!_isValidAttribute(lcTag, lcName, value)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      /* Handle attributes that require Trusted Types */
      if (trustedTypesPolicy && typeof trustedTypes === 'object' && typeof trustedTypes.getAttributeType === 'function') {
        if (namespaceURI) ; else {
          switch (trustedTypes.getAttributeType(lcTag, lcName)) {
            case 'TrustedHTML':
              {
                value = trustedTypesPolicy.createHTML(value);
                break;
              }
            case 'TrustedScriptURL':
              {
                value = trustedTypesPolicy.createScriptURL(value);
                break;
              }
          }
        }
      }
      /* Handle invalid data-* attribute set by try-catching it */
      if (value !== initValue) {
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name, value);
          } else {
            /* Fallback to setAttribute() for browser-unrecognized namespaces e.g. "x-schema". */
            currentNode.setAttribute(name, value);
          }
          if (_isClobbered(currentNode)) {
            _forceRemove(currentNode);
          } else {
            arrayPop(DOMPurify.removed);
          }
        } catch (_) {
          _removeAttribute(name, currentNode);
        }
      }
    }
    /* Execute a hook if present */
    _executeHooks(hooks.afterSanitizeAttributes, currentNode, null);
  };
  /**
   * _sanitizeShadowDOM
   *
   * @param fragment to iterate over recursively
   */
  const _sanitizeShadowDOM = function _sanitizeShadowDOM(fragment) {
    let shadowNode = null;
    const shadowIterator = _createNodeIterator(fragment);
    /* Execute a hook if present */
    _executeHooks(hooks.beforeSanitizeShadowDOM, fragment, null);
    while (shadowNode = shadowIterator.nextNode()) {
      /* Execute a hook if present */
      _executeHooks(hooks.uponSanitizeShadowNode, shadowNode, null);
      /* Sanitize tags and elements */
      _sanitizeElements(shadowNode);
      /* Check attributes next */
      _sanitizeAttributes(shadowNode);
      /* Deep shadow DOM detected */
      if (shadowNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM(shadowNode.content);
      }
    }
    /* Execute a hook if present */
    _executeHooks(hooks.afterSanitizeShadowDOM, fragment, null);
  };
  // eslint-disable-next-line complexity
  DOMPurify.sanitize = function (dirty) {
    let cfg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    let body = null;
    let importedNode = null;
    let currentNode = null;
    let returnNode = null;
    /* Make sure we have a string to sanitize.
      DO NOT return early, as this will return the wrong type if
      the user has requested a DOM object rather than a string */
    IS_EMPTY_INPUT = !dirty;
    if (IS_EMPTY_INPUT) {
      dirty = '<!-->';
    }
    /* Stringify, in case dirty is an object */
    if (typeof dirty !== 'string' && !_isNode(dirty)) {
      if (typeof dirty.toString === 'function') {
        dirty = dirty.toString();
        if (typeof dirty !== 'string') {
          throw typeErrorCreate('dirty is not a string, aborting');
        }
      } else {
        throw typeErrorCreate('toString is not a function');
      }
    }
    /* Return dirty HTML if DOMPurify cannot run */
    if (!DOMPurify.isSupported) {
      return dirty;
    }
    /* Assign config vars */
    if (!SET_CONFIG) {
      _parseConfig(cfg);
    }
    /* Clean up removed elements */
    DOMPurify.removed = [];
    /* Check if dirty is correctly typed for IN_PLACE */
    if (typeof dirty === 'string') {
      IN_PLACE = false;
    }
    if (IN_PLACE) {
      /* Do some early pre-sanitization to avoid unsafe root nodes */
      if (dirty.nodeName) {
        const tagName = transformCaseFunc(dirty.nodeName);
        if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
          throw typeErrorCreate('root node is forbidden and cannot be sanitized in-place');
        }
      }
    } else if (dirty instanceof Node) {
      /* If dirty is a DOM element, append to an empty document to avoid
         elements being stripped by the parser */
      body = _initDocument('<!---->');
      importedNode = body.ownerDocument.importNode(dirty, true);
      if (importedNode.nodeType === NODE_TYPE.element && importedNode.nodeName === 'BODY') {
        /* Node is already a body, use as is */
        body = importedNode;
      } else if (importedNode.nodeName === 'HTML') {
        body = importedNode;
      } else {
        // eslint-disable-next-line unicorn/prefer-dom-node-append
        body.appendChild(importedNode);
      }
    } else {
      /* Exit directly if we have nothing to do */
      if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT &&
      // eslint-disable-next-line unicorn/prefer-includes
      dirty.indexOf('<') === -1) {
        return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
      }
      /* Initialize the document to work on */
      body = _initDocument(dirty);
      /* Check we have a DOM node from the data */
      if (!body) {
        return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : '';
      }
    }
    /* Remove first element node (ours) if FORCE_BODY is set */
    if (body && FORCE_BODY) {
      _forceRemove(body.firstChild);
    }
    /* Get node iterator */
    const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body);
    /* Now start iterating over the created document */
    while (currentNode = nodeIterator.nextNode()) {
      /* Sanitize tags and elements */
      _sanitizeElements(currentNode);
      /* Check attributes next */
      _sanitizeAttributes(currentNode);
      /* Shadow DOM detected, sanitize it */
      if (currentNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM(currentNode.content);
      }
    }
    /* If we sanitized `dirty` in-place, return it. */
    if (IN_PLACE) {
      return dirty;
    }
    /* Return sanitized string or DOM */
    if (RETURN_DOM) {
      if (RETURN_DOM_FRAGMENT) {
        returnNode = createDocumentFragment.call(body.ownerDocument);
        while (body.firstChild) {
          // eslint-disable-next-line unicorn/prefer-dom-node-append
          returnNode.appendChild(body.firstChild);
        }
      } else {
        returnNode = body;
      }
      if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
        /*
          AdoptNode() is not used because internal state is not reset
          (e.g. the past names map of a HTMLFormElement), this is safe
          in theory but we would rather not risk another attack vector.
          The state that is cloned by importNode() is explicitly defined
          by the specs.
        */
        returnNode = importNode.call(originalDocument, returnNode, true);
      }
      return returnNode;
    }
    let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
    /* Serialize doctype if allowed */
    if (WHOLE_DOCUMENT && ALLOWED_TAGS['!doctype'] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
      serializedHTML = '<!DOCTYPE ' + body.ownerDocument.doctype.name + '>\n' + serializedHTML;
    }
    /* Sanitize final string template-safe */
    if (SAFE_FOR_TEMPLATES) {
      arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
        serializedHTML = stringReplace(serializedHTML, expr, ' ');
      });
    }
    return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
  };
  DOMPurify.setConfig = function () {
    let cfg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    _parseConfig(cfg);
    SET_CONFIG = true;
  };
  DOMPurify.clearConfig = function () {
    CONFIG = null;
    SET_CONFIG = false;
  };
  DOMPurify.isValidAttribute = function (tag, attr, value) {
    /* Initialize shared config vars if necessary. */
    if (!CONFIG) {
      _parseConfig({});
    }
    const lcTag = transformCaseFunc(tag);
    const lcName = transformCaseFunc(attr);
    return _isValidAttribute(lcTag, lcName, value);
  };
  DOMPurify.addHook = function (entryPoint, hookFunction) {
    if (typeof hookFunction !== 'function') {
      return;
    }
    arrayPush(hooks[entryPoint], hookFunction);
  };
  DOMPurify.removeHook = function (entryPoint, hookFunction) {
    if (hookFunction !== undefined) {
      const index = arrayLastIndexOf(hooks[entryPoint], hookFunction);
      return index === -1 ? undefined : arraySplice(hooks[entryPoint], index, 1)[0];
    }
    return arrayPop(hooks[entryPoint]);
  };
  DOMPurify.removeHooks = function (entryPoint) {
    hooks[entryPoint] = [];
  };
  DOMPurify.removeAllHooks = function () {
    hooks = _createHooksMap();
  };
  return DOMPurify;
}
var purify = createDOMPurify();


//# sourceMappingURL=purify.es.mjs.map


/***/ }),

/***/ "../utils/helpers.js":
/*!***************************!*\
  !*** ../utils/helpers.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   classNames: () => (/* binding */ classNames),
/* harmony export */   debounce: () => (/* binding */ debounce),
/* harmony export */   getAstraProTitle: () => (/* binding */ getAstraProTitle),
/* harmony export */   getAstraProTitleFreePage: () => (/* binding */ getAstraProTitleFreePage),
/* harmony export */   getSpinner: () => (/* binding */ getSpinner),
/* harmony export */   handleGetAstraPro: () => (/* binding */ handleGetAstraPro),
/* harmony export */   saveSetting: () => (/* binding */ saveSetting)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! dompurify */ "../../node_modules/dompurify/dist/purify.es.mjs");




/**
 * Returns the class names.
 *
 * @param {...string} classes The class names.
 *
 * @return {string} Returns the class names.
 */
const classNames = (...classes) => classes.filter(Boolean).join(' ');

/**
 * Handles the Astra Pro CTA button click event, opening the upgrade URL in a new tab.
 * This function also handles the display of a spinner during the upgrade process.
 *
 * @param {Event} e - The event object.
 * @param {Object} options - Options for the upgrade process.
 * @param {string} options.url - The URL for the upgrade.
 * @param {string} options.campaign - The UTM campaign parameter.
 * @param {boolean} options.disableSpinner - Optional. Disables the spinner if true.
 * @param {string} options.spinnerPosition - Optional. The position of the spinner.
 */
const handleGetAstraPro = (e, {
  url = astra_admin.upgrade_url,
  campaign = '',
  disableSpinner = false,
  spinnerPosition = 'right'
} = {}) => {
  e.preventDefault();
  e.stopPropagation();
  if (!astra_admin.pro_installed_status) {
    // If a custom campaign is provided, modify the URL
    if (campaign) {
      const urlObj = new URL(url);
      urlObj.searchParams.set('utm_campaign', campaign);
      url = urlObj.toString();
    }
    window.open(url, '_blank');
    return;
  }
  const spinnerHTML = disableSpinner ? '' : getSpinner();
  const buttonHTML = spinnerPosition === 'right' ? `<span class="button-text">${astra_admin.plugin_activating_text}</span>${spinnerHTML}` : `${spinnerHTML}<span class="button-text">${astra_admin.plugin_activating_text}</span>`;
  e.target.innerHTML = dompurify__WEBPACK_IMPORTED_MODULE_2__["default"].sanitize(buttonHTML);
  e.target.disabled = true;
  const formData = new window.FormData();
  formData.append('action', 'astra_recommended_plugin_activate');
  formData.append('security', astra_admin.plugin_manager_nonce);
  formData.append('init', 'astra-addon/astra-addon.php');
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
    url: astra_admin.ajax_url,
    method: 'POST',
    body: formData
  }).then(data => {
    if (data.success) {
      window.open(astra_admin.astra_base_url, '_self');
      return;
    }
  }).catch(error => {
    e.target.innerText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activation failed. Please try again.', 'astra');
    e.target.disabled = false;
    console.error('Error during API request:', error);
    // Optionally, notify the user about the error or handle it appropriately.
  });
};

/**
 * Creates a debounced function that delays its execution until after the specified delay.
 *
 * The debounce() function can also be used from lodash.debounce package in future.
 *
 * @param {Function} func - The function to debounce.
 * @param {number} delay - The delay in milliseconds before the function is executed.
 *
 * @returns {Function} A debounced function.
 */
const debounce = (func, delay) => {
  let timer;
  function debounced(...args) {
    clearTimeout(timer);
    timer = setTimeout(() => func(...args), delay);
  }

  // Attach a `cancel` method to clear the timeout.
  debounced.cancel = () => {
    clearTimeout(timer);
  };
  return debounced;
};

/**
 * Returns the Astra Pro title.
 *
 * @return {string} Returns the Astra Pro title.
 */
const getAstraProTitle = () => {
  return astra_admin.pro_installed_status ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activate Now', 'astra') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Upgrade Now', 'astra');
};

/**
 * Returns the Astra Pro title.
 *
 * @return {string} Returns the Astra Pro title.
 */
const getAstraProTitleFreePage = () => {
  return astra_admin.pro_installed_status ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activate Now', 'astra') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('See all Astra Pro Features', 'astra');
};

/**
 * Returns the spinner SVG text.
 *
 * @return {string} Returns the spinner SVG text..
 */
const getSpinner = () => {
  return `
		<svg class="animate-spin installer-spinner ml-2 inline-block align-middle" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" width="16" height="16">
			<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
			<path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
		</svg>
	`;
};

/**
 * A function to save astra admin settings.
 *
 * @function
 *
 * @param {string}   key                - Settings key.
 * @param {string}   value              - The data to send.
 * @param {Function} dispatch           - The dispatch function.
 * @param {Object}   abortControllerRef - The ref object with to hold abort controller.
 *
 * @return {Promise} Returns a promise representing the processed request.
 */
const saveSetting = debounce(({
  action = 'astra_update_admin_setting',
  security = astra_admin.update_nonce,
  key = '',
  value
}, dispatch, abortControllerRef = {
  current: {}
}) => {
  // Abort any previous request.
  if (abortControllerRef.current[key]) {
    abortControllerRef.current[key]?.abort();
  }

  // Create a new AbortController.
  const abortController = new AbortController();
  abortControllerRef.current[key] = abortController;
  const formData = new window.FormData();
  formData.append('action', action);
  formData.append('security', security);
  formData.append('key', key);
  formData.append('value', value);
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
    url: astra_admin.ajax_url,
    method: 'POST',
    body: formData,
    signal: abortControllerRef.current[key]?.signal // Pass the signal to the fetch request.
  }).then(() => {
    dispatch({
      type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
      payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Successfully saved!', 'astra')
    });
  }).catch(error => {
    // Ignore if it is intentionally aborted.
    if (error.name === 'AbortError') {
      return;
    }
    console.error('Error during API request:', error);
    dispatch({
      type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
      payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An error occurred while saving.', 'astra')
    });
  });
}, 300);


/***/ }),

/***/ "./node_modules/@bsf/force-ui/dist/_commonjsHelpers-DaMA6jEr.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@bsf/force-ui/dist/_commonjsHelpers-DaMA6jEr.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: () => (/* binding */ o),
/* harmony export */   g: () => (/* binding */ l)
/* harmony export */ });
var o = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function l(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}



/***/ }),

/***/ "./node_modules/@bsf/force-ui/dist/force-ui.js":
/*!*****************************************************!*\
  !*** ./node_modules/@bsf/force-ui/dist/force-ui.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

var react__WEBPACK_IMPORTED_MODULE_1___namespace_cache;
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: () => (/* binding */ ake),
/* harmony export */   Alert: () => (/* binding */ nke),
/* harmony export */   AreaChart: () => (/* binding */ uke),
/* harmony export */   Avatar: () => (/* binding */ GEe),
/* harmony export */   Badge: () => (/* binding */ mg),
/* harmony export */   BarChart: () => (/* binding */ ske),
/* harmony export */   Breadcrumb: () => (/* binding */ Xs),
/* harmony export */   Button: () => (/* binding */ Hn),
/* harmony export */   ButtonGroup: () => (/* binding */ XEe),
/* harmony export */   Checkbox: () => (/* binding */ Jw),
/* harmony export */   Container: () => (/* binding */ kR),
/* harmony export */   DatePicker: () => (/* binding */ oke),
/* harmony export */   Dialog: () => (/* binding */ Xo),
/* harmony export */   Drawer: () => (/* binding */ Jo),
/* harmony export */   DropdownMenu: () => (/* binding */ Js),
/* harmony export */   Dropzone: () => (/* binding */ FEe),
/* harmony export */   EditorInput: () => (/* binding */ UQ),
/* harmony export */   HamburgerMenu: () => (/* binding */ zg),
/* harmony export */   Input: () => (/* binding */ fY),
/* harmony export */   Label: () => (/* binding */ to),
/* harmony export */   LineChart: () => (/* binding */ lke),
/* harmony export */   Loader: () => (/* binding */ d1),
/* harmony export */   Menu: () => (/* binding */ Ha),
/* harmony export */   Pagination: () => (/* binding */ Fc),
/* harmony export */   PieChart: () => (/* binding */ cke),
/* harmony export */   ProgressBar: () => (/* binding */ qEe),
/* harmony export */   ProgressSteps: () => (/* binding */ qQ),
/* harmony export */   RadioButton: () => (/* binding */ KEe),
/* harmony export */   SearchBox: () => (/* binding */ Zo),
/* harmony export */   Select: () => (/* binding */ QEe),
/* harmony export */   Sidebar: () => (/* binding */ ike),
/* harmony export */   Skeleton: () => (/* binding */ rke),
/* harmony export */   Switch: () => (/* binding */ J$),
/* harmony export */   Table: () => (/* binding */ ol),
/* harmony export */   Tabs: () => (/* binding */ K1),
/* harmony export */   TextArea: () => (/* binding */ cY),
/* harmony export */   Title: () => (/* binding */ YEe),
/* harmony export */   Toaster: () => (/* binding */ tke),
/* harmony export */   Tooltip: () => (/* binding */ f1),
/* harmony export */   Topbar: () => (/* binding */ _d),
/* harmony export */   toast: () => (/* binding */ eke)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var _commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_commonjsHelpers-DaMA6jEr.js */ "./node_modules/@bsf/force-ui/dist/_commonjsHelpers-DaMA6jEr.js");
"use client";
var nH = Object.defineProperty;
var pT = (e) => {
  throw TypeError(e);
};
var rH = (e, t, n) => t in e ? nH(e, t, { enumerable: !0, configurable: !0, writable: !0, value: n }) : e[t] = n;
var ha = (e, t, n) => rH(e, typeof t != "symbol" ? t + "" : t, n), mT = (e, t, n) => t.has(e) || pT("Cannot " + n);
var Dr = (e, t, n) => (mT(e, t, "read from private field"), n ? n.call(e) : t.get(e)), zv = (e, t, n) => t.has(e) ? pT("Cannot add the same private member more than once") : t instanceof WeakSet ? t.add(e) : t.set(e, n), as = (e, t, n, r) => (mT(e, t, "write to private field"), r ? r.call(e, n) : t.set(e, n), n);






const qw = "-", sH = (e) => {
  const t = cH(e), {
    conflictingClassGroups: n,
    conflictingClassGroupModifiers: r
  } = e;
  return {
    getClassGroupId: (a) => {
      const s = a.split(qw);
      return s[0] === "" && s.length !== 1 && s.shift(), K$(s, t) || lH(a);
    },
    getConflictingClassGroupIds: (a, s) => {
      const l = n[a] || [];
      return s && r[a] ? [...l, ...r[a]] : l;
    }
  };
}, K$ = (e, t) => {
  var a;
  if (e.length === 0)
    return t.classGroupId;
  const n = e[0], r = t.nextPart.get(n), i = r ? K$(e.slice(1), r) : void 0;
  if (i)
    return i;
  if (t.validators.length === 0)
    return;
  const o = e.join(qw);
  return (a = t.validators.find(({
    validator: s
  }) => s(o))) == null ? void 0 : a.classGroupId;
}, gT = /^\[(.+)\]$/, lH = (e) => {
  if (gT.test(e)) {
    const t = gT.exec(e)[1], n = t == null ? void 0 : t.substring(0, t.indexOf(":"));
    if (n)
      return "arbitrary.." + n;
  }
}, cH = (e) => {
  const {
    theme: t,
    prefix: n
  } = e, r = {
    nextPart: /* @__PURE__ */ new Map(),
    validators: []
  };
  return fH(Object.entries(e.classGroups), n).forEach(([o, a]) => {
    u0(a, r, o, t);
  }), r;
}, u0 = (e, t, n, r) => {
  e.forEach((i) => {
    if (typeof i == "string") {
      const o = i === "" ? t : yT(t, i);
      o.classGroupId = n;
      return;
    }
    if (typeof i == "function") {
      if (uH(i)) {
        u0(i(r), t, n, r);
        return;
      }
      t.validators.push({
        validator: i,
        classGroupId: n
      });
      return;
    }
    Object.entries(i).forEach(([o, a]) => {
      u0(a, yT(t, o), n, r);
    });
  });
}, yT = (e, t) => {
  let n = e;
  return t.split(qw).forEach((r) => {
    n.nextPart.has(r) || n.nextPart.set(r, {
      nextPart: /* @__PURE__ */ new Map(),
      validators: []
    }), n = n.nextPart.get(r);
  }), n;
}, uH = (e) => e.isThemeGetter, fH = (e, t) => t ? e.map(([n, r]) => {
  const i = r.map((o) => typeof o == "string" ? t + o : typeof o == "object" ? Object.fromEntries(Object.entries(o).map(([a, s]) => [t + a, s])) : o);
  return [n, i];
}) : e, dH = (e) => {
  if (e < 1)
    return {
      get: () => {
      },
      set: () => {
      }
    };
  let t = 0, n = /* @__PURE__ */ new Map(), r = /* @__PURE__ */ new Map();
  const i = (o, a) => {
    n.set(o, a), t++, t > e && (t = 0, r = n, n = /* @__PURE__ */ new Map());
  };
  return {
    get(o) {
      let a = n.get(o);
      if (a !== void 0)
        return a;
      if ((a = r.get(o)) !== void 0)
        return i(o, a), a;
    },
    set(o, a) {
      n.has(o) ? n.set(o, a) : i(o, a);
    }
  };
}, G$ = "!", hH = (e) => {
  const {
    separator: t,
    experimentalParseClassName: n
  } = e, r = t.length === 1, i = t[0], o = t.length, a = (s) => {
    const l = [];
    let c = 0, f = 0, d;
    for (let v = 0; v < s.length; v++) {
      let x = s[v];
      if (c === 0) {
        if (x === i && (r || s.slice(v, v + o) === t)) {
          l.push(s.slice(f, v)), f = v + o;
          continue;
        }
        if (x === "/") {
          d = v;
          continue;
        }
      }
      x === "[" ? c++ : x === "]" && c--;
    }
    const p = l.length === 0 ? s : s.substring(f), m = p.startsWith(G$), y = m ? p.substring(1) : p, g = d && d > f ? d - f : void 0;
    return {
      modifiers: l,
      hasImportantModifier: m,
      baseClassName: y,
      maybePostfixModifierPosition: g
    };
  };
  return n ? (s) => n({
    className: s,
    parseClassName: a
  }) : a;
}, pH = (e) => {
  if (e.length <= 1)
    return e;
  const t = [];
  let n = [];
  return e.forEach((r) => {
    r[0] === "[" ? (t.push(...n.sort(), r), n = []) : n.push(r);
  }), t.push(...n.sort()), t;
}, mH = (e) => ({
  cache: dH(e.cacheSize),
  parseClassName: hH(e),
  ...sH(e)
}), gH = /\s+/, yH = (e, t) => {
  const {
    parseClassName: n,
    getClassGroupId: r,
    getConflictingClassGroupIds: i
  } = t, o = [], a = e.trim().split(gH);
  let s = "";
  for (let l = a.length - 1; l >= 0; l -= 1) {
    const c = a[l], {
      modifiers: f,
      hasImportantModifier: d,
      baseClassName: p,
      maybePostfixModifierPosition: m
    } = n(c);
    let y = !!m, g = r(y ? p.substring(0, m) : p);
    if (!g) {
      if (!y) {
        s = c + (s.length > 0 ? " " + s : s);
        continue;
      }
      if (g = r(p), !g) {
        s = c + (s.length > 0 ? " " + s : s);
        continue;
      }
      y = !1;
    }
    const v = pH(f).join(":"), x = d ? v + G$ : v, w = x + g;
    if (o.includes(w))
      continue;
    o.push(w);
    const S = i(g, y);
    for (let A = 0; A < S.length; ++A) {
      const _ = S[A];
      o.push(x + _);
    }
    s = c + (s.length > 0 ? " " + s : s);
  }
  return s;
};
function vH() {
  let e = 0, t, n, r = "";
  for (; e < arguments.length; )
    (t = arguments[e++]) && (n = Y$(t)) && (r && (r += " "), r += n);
  return r;
}
const Y$ = (e) => {
  if (typeof e == "string")
    return e;
  let t, n = "";
  for (let r = 0; r < e.length; r++)
    e[r] && (t = Y$(e[r])) && (n && (n += " "), n += t);
  return n;
};
function bH(e, ...t) {
  let n, r, i, o = a;
  function a(l) {
    const c = t.reduce((f, d) => d(f), e());
    return n = mH(c), r = n.cache.get, i = n.cache.set, o = s, s(l);
  }
  function s(l) {
    const c = r(l);
    if (c)
      return c;
    const f = yH(l, n);
    return i(l, f), f;
  }
  return function() {
    return o(vH.apply(null, arguments));
  };
}
const Wt = (e) => {
  const t = (n) => n[e] || [];
  return t.isThemeGetter = !0, t;
}, q$ = /^\[(?:([a-z-]+):)?(.+)\]$/i, xH = /^\d+\/\d+$/, wH = /* @__PURE__ */ new Set(["px", "full", "screen"]), _H = /^(\d+(\.\d+)?)?(xs|sm|md|lg|xl)$/, SH = /\d+(%|px|r?em|[sdl]?v([hwib]|min|max)|pt|pc|in|cm|mm|cap|ch|ex|r?lh|cq(w|h|i|b|min|max))|\b(calc|min|max|clamp)\(.+\)|^0$/, OH = /^(rgba?|hsla?|hwb|(ok)?(lab|lch))\(.+\)$/, AH = /^(inset_)?-?((\d+)?\.?(\d+)[a-z]+|0)_-?((\d+)?\.?(\d+)[a-z]+|0)/, TH = /^(url|image|image-set|cross-fade|element|(repeating-)?(linear|radial|conic)-gradient)\(.+\)$/, bo = (e) => Vl(e) || wH.has(e) || xH.test(e), pa = (e) => Nc(e, "length", DH), Vl = (e) => !!e && !Number.isNaN(Number(e)), Vv = (e) => Nc(e, "number", Vl), bu = (e) => !!e && Number.isInteger(Number(e)), PH = (e) => e.endsWith("%") && Vl(e.slice(0, -1)), Je = (e) => q$.test(e), ma = (e) => _H.test(e), CH = /* @__PURE__ */ new Set(["length", "size", "percentage"]), EH = (e) => Nc(e, CH, X$), kH = (e) => Nc(e, "position", X$), MH = /* @__PURE__ */ new Set(["image", "url"]), NH = (e) => Nc(e, MH, RH), $H = (e) => Nc(e, "", IH), xu = () => !0, Nc = (e, t, n) => {
  const r = q$.exec(e);
  return r ? r[1] ? typeof t == "string" ? r[1] === t : t.has(r[1]) : n(r[2]) : !1;
}, DH = (e) => (
  // `colorFunctionRegex` check is necessary because color functions can have percentages in them which which would be incorrectly classified as lengths.
  // For example, `hsl(0 0% 0%)` would be classified as a length without this check.
  // I could also use lookbehind assertion in `lengthUnitRegex` but that isn't supported widely enough.
  SH.test(e) && !OH.test(e)
), X$ = () => !1, IH = (e) => AH.test(e), RH = (e) => TH.test(e), jH = () => {
  const e = Wt("colors"), t = Wt("spacing"), n = Wt("blur"), r = Wt("brightness"), i = Wt("borderColor"), o = Wt("borderRadius"), a = Wt("borderSpacing"), s = Wt("borderWidth"), l = Wt("contrast"), c = Wt("grayscale"), f = Wt("hueRotate"), d = Wt("invert"), p = Wt("gap"), m = Wt("gradientColorStops"), y = Wt("gradientColorStopPositions"), g = Wt("inset"), v = Wt("margin"), x = Wt("opacity"), w = Wt("padding"), S = Wt("saturate"), A = Wt("scale"), _ = Wt("sepia"), O = Wt("skew"), P = Wt("space"), C = Wt("translate"), k = () => ["auto", "contain", "none"], I = () => ["auto", "hidden", "clip", "visible", "scroll"], $ = () => ["auto", Je, t], N = () => [Je, t], D = () => ["", bo, pa], j = () => ["auto", Vl, Je], F = () => ["bottom", "center", "left", "left-bottom", "left-top", "right", "right-bottom", "right-top", "top"], W = () => ["solid", "dashed", "dotted", "double", "none"], z = () => ["normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity"], H = () => ["start", "end", "center", "between", "around", "evenly", "stretch"], U = () => ["", "0", Je], V = () => ["auto", "avoid", "all", "avoid-page", "page", "left", "right", "column"], Y = () => [Vl, Je];
  return {
    cacheSize: 500,
    separator: ":",
    theme: {
      colors: [xu],
      spacing: [bo, pa],
      blur: ["none", "", ma, Je],
      brightness: Y(),
      borderColor: [e],
      borderRadius: ["none", "", "full", ma, Je],
      borderSpacing: N(),
      borderWidth: D(),
      contrast: Y(),
      grayscale: U(),
      hueRotate: Y(),
      invert: U(),
      gap: N(),
      gradientColorStops: [e],
      gradientColorStopPositions: [PH, pa],
      inset: $(),
      margin: $(),
      opacity: Y(),
      padding: N(),
      saturate: Y(),
      scale: Y(),
      sepia: U(),
      skew: Y(),
      space: N(),
      translate: N()
    },
    classGroups: {
      // Layout
      /**
       * Aspect Ratio
       * @see https://tailwindcss.com/docs/aspect-ratio
       */
      aspect: [{
        aspect: ["auto", "square", "video", Je]
      }],
      /**
       * Container
       * @see https://tailwindcss.com/docs/container
       */
      container: ["container"],
      /**
       * Columns
       * @see https://tailwindcss.com/docs/columns
       */
      columns: [{
        columns: [ma]
      }],
      /**
       * Break After
       * @see https://tailwindcss.com/docs/break-after
       */
      "break-after": [{
        "break-after": V()
      }],
      /**
       * Break Before
       * @see https://tailwindcss.com/docs/break-before
       */
      "break-before": [{
        "break-before": V()
      }],
      /**
       * Break Inside
       * @see https://tailwindcss.com/docs/break-inside
       */
      "break-inside": [{
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column"]
      }],
      /**
       * Box Decoration Break
       * @see https://tailwindcss.com/docs/box-decoration-break
       */
      "box-decoration": [{
        "box-decoration": ["slice", "clone"]
      }],
      /**
       * Box Sizing
       * @see https://tailwindcss.com/docs/box-sizing
       */
      box: [{
        box: ["border", "content"]
      }],
      /**
       * Display
       * @see https://tailwindcss.com/docs/display
       */
      display: ["block", "inline-block", "inline", "flex", "inline-flex", "table", "inline-table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row-group", "table-row", "flow-root", "grid", "inline-grid", "contents", "list-item", "hidden"],
      /**
       * Floats
       * @see https://tailwindcss.com/docs/float
       */
      float: [{
        float: ["right", "left", "none", "start", "end"]
      }],
      /**
       * Clear
       * @see https://tailwindcss.com/docs/clear
       */
      clear: [{
        clear: ["left", "right", "both", "none", "start", "end"]
      }],
      /**
       * Isolation
       * @see https://tailwindcss.com/docs/isolation
       */
      isolation: ["isolate", "isolation-auto"],
      /**
       * Object Fit
       * @see https://tailwindcss.com/docs/object-fit
       */
      "object-fit": [{
        object: ["contain", "cover", "fill", "none", "scale-down"]
      }],
      /**
       * Object Position
       * @see https://tailwindcss.com/docs/object-position
       */
      "object-position": [{
        object: [...F(), Je]
      }],
      /**
       * Overflow
       * @see https://tailwindcss.com/docs/overflow
       */
      overflow: [{
        overflow: I()
      }],
      /**
       * Overflow X
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-x": [{
        "overflow-x": I()
      }],
      /**
       * Overflow Y
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-y": [{
        "overflow-y": I()
      }],
      /**
       * Overscroll Behavior
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      overscroll: [{
        overscroll: k()
      }],
      /**
       * Overscroll Behavior X
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-x": [{
        "overscroll-x": k()
      }],
      /**
       * Overscroll Behavior Y
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-y": [{
        "overscroll-y": k()
      }],
      /**
       * Position
       * @see https://tailwindcss.com/docs/position
       */
      position: ["static", "fixed", "absolute", "relative", "sticky"],
      /**
       * Top / Right / Bottom / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      inset: [{
        inset: [g]
      }],
      /**
       * Right / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-x": [{
        "inset-x": [g]
      }],
      /**
       * Top / Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-y": [{
        "inset-y": [g]
      }],
      /**
       * Start
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      start: [{
        start: [g]
      }],
      /**
       * End
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      end: [{
        end: [g]
      }],
      /**
       * Top
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      top: [{
        top: [g]
      }],
      /**
       * Right
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      right: [{
        right: [g]
      }],
      /**
       * Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      bottom: [{
        bottom: [g]
      }],
      /**
       * Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      left: [{
        left: [g]
      }],
      /**
       * Visibility
       * @see https://tailwindcss.com/docs/visibility
       */
      visibility: ["visible", "invisible", "collapse"],
      /**
       * Z-Index
       * @see https://tailwindcss.com/docs/z-index
       */
      z: [{
        z: ["auto", bu, Je]
      }],
      // Flexbox and Grid
      /**
       * Flex Basis
       * @see https://tailwindcss.com/docs/flex-basis
       */
      basis: [{
        basis: $()
      }],
      /**
       * Flex Direction
       * @see https://tailwindcss.com/docs/flex-direction
       */
      "flex-direction": [{
        flex: ["row", "row-reverse", "col", "col-reverse"]
      }],
      /**
       * Flex Wrap
       * @see https://tailwindcss.com/docs/flex-wrap
       */
      "flex-wrap": [{
        flex: ["wrap", "wrap-reverse", "nowrap"]
      }],
      /**
       * Flex
       * @see https://tailwindcss.com/docs/flex
       */
      flex: [{
        flex: ["1", "auto", "initial", "none", Je]
      }],
      /**
       * Flex Grow
       * @see https://tailwindcss.com/docs/flex-grow
       */
      grow: [{
        grow: U()
      }],
      /**
       * Flex Shrink
       * @see https://tailwindcss.com/docs/flex-shrink
       */
      shrink: [{
        shrink: U()
      }],
      /**
       * Order
       * @see https://tailwindcss.com/docs/order
       */
      order: [{
        order: ["first", "last", "none", bu, Je]
      }],
      /**
       * Grid Template Columns
       * @see https://tailwindcss.com/docs/grid-template-columns
       */
      "grid-cols": [{
        "grid-cols": [xu]
      }],
      /**
       * Grid Column Start / End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start-end": [{
        col: ["auto", {
          span: ["full", bu, Je]
        }, Je]
      }],
      /**
       * Grid Column Start
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start": [{
        "col-start": j()
      }],
      /**
       * Grid Column End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-end": [{
        "col-end": j()
      }],
      /**
       * Grid Template Rows
       * @see https://tailwindcss.com/docs/grid-template-rows
       */
      "grid-rows": [{
        "grid-rows": [xu]
      }],
      /**
       * Grid Row Start / End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start-end": [{
        row: ["auto", {
          span: [bu, Je]
        }, Je]
      }],
      /**
       * Grid Row Start
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start": [{
        "row-start": j()
      }],
      /**
       * Grid Row End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-end": [{
        "row-end": j()
      }],
      /**
       * Grid Auto Flow
       * @see https://tailwindcss.com/docs/grid-auto-flow
       */
      "grid-flow": [{
        "grid-flow": ["row", "col", "dense", "row-dense", "col-dense"]
      }],
      /**
       * Grid Auto Columns
       * @see https://tailwindcss.com/docs/grid-auto-columns
       */
      "auto-cols": [{
        "auto-cols": ["auto", "min", "max", "fr", Je]
      }],
      /**
       * Grid Auto Rows
       * @see https://tailwindcss.com/docs/grid-auto-rows
       */
      "auto-rows": [{
        "auto-rows": ["auto", "min", "max", "fr", Je]
      }],
      /**
       * Gap
       * @see https://tailwindcss.com/docs/gap
       */
      gap: [{
        gap: [p]
      }],
      /**
       * Gap X
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-x": [{
        "gap-x": [p]
      }],
      /**
       * Gap Y
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-y": [{
        "gap-y": [p]
      }],
      /**
       * Justify Content
       * @see https://tailwindcss.com/docs/justify-content
       */
      "justify-content": [{
        justify: ["normal", ...H()]
      }],
      /**
       * Justify Items
       * @see https://tailwindcss.com/docs/justify-items
       */
      "justify-items": [{
        "justify-items": ["start", "end", "center", "stretch"]
      }],
      /**
       * Justify Self
       * @see https://tailwindcss.com/docs/justify-self
       */
      "justify-self": [{
        "justify-self": ["auto", "start", "end", "center", "stretch"]
      }],
      /**
       * Align Content
       * @see https://tailwindcss.com/docs/align-content
       */
      "align-content": [{
        content: ["normal", ...H(), "baseline"]
      }],
      /**
       * Align Items
       * @see https://tailwindcss.com/docs/align-items
       */
      "align-items": [{
        items: ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Align Self
       * @see https://tailwindcss.com/docs/align-self
       */
      "align-self": [{
        self: ["auto", "start", "end", "center", "stretch", "baseline"]
      }],
      /**
       * Place Content
       * @see https://tailwindcss.com/docs/place-content
       */
      "place-content": [{
        "place-content": [...H(), "baseline"]
      }],
      /**
       * Place Items
       * @see https://tailwindcss.com/docs/place-items
       */
      "place-items": [{
        "place-items": ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Place Self
       * @see https://tailwindcss.com/docs/place-self
       */
      "place-self": [{
        "place-self": ["auto", "start", "end", "center", "stretch"]
      }],
      // Spacing
      /**
       * Padding
       * @see https://tailwindcss.com/docs/padding
       */
      p: [{
        p: [w]
      }],
      /**
       * Padding X
       * @see https://tailwindcss.com/docs/padding
       */
      px: [{
        px: [w]
      }],
      /**
       * Padding Y
       * @see https://tailwindcss.com/docs/padding
       */
      py: [{
        py: [w]
      }],
      /**
       * Padding Start
       * @see https://tailwindcss.com/docs/padding
       */
      ps: [{
        ps: [w]
      }],
      /**
       * Padding End
       * @see https://tailwindcss.com/docs/padding
       */
      pe: [{
        pe: [w]
      }],
      /**
       * Padding Top
       * @see https://tailwindcss.com/docs/padding
       */
      pt: [{
        pt: [w]
      }],
      /**
       * Padding Right
       * @see https://tailwindcss.com/docs/padding
       */
      pr: [{
        pr: [w]
      }],
      /**
       * Padding Bottom
       * @see https://tailwindcss.com/docs/padding
       */
      pb: [{
        pb: [w]
      }],
      /**
       * Padding Left
       * @see https://tailwindcss.com/docs/padding
       */
      pl: [{
        pl: [w]
      }],
      /**
       * Margin
       * @see https://tailwindcss.com/docs/margin
       */
      m: [{
        m: [v]
      }],
      /**
       * Margin X
       * @see https://tailwindcss.com/docs/margin
       */
      mx: [{
        mx: [v]
      }],
      /**
       * Margin Y
       * @see https://tailwindcss.com/docs/margin
       */
      my: [{
        my: [v]
      }],
      /**
       * Margin Start
       * @see https://tailwindcss.com/docs/margin
       */
      ms: [{
        ms: [v]
      }],
      /**
       * Margin End
       * @see https://tailwindcss.com/docs/margin
       */
      me: [{
        me: [v]
      }],
      /**
       * Margin Top
       * @see https://tailwindcss.com/docs/margin
       */
      mt: [{
        mt: [v]
      }],
      /**
       * Margin Right
       * @see https://tailwindcss.com/docs/margin
       */
      mr: [{
        mr: [v]
      }],
      /**
       * Margin Bottom
       * @see https://tailwindcss.com/docs/margin
       */
      mb: [{
        mb: [v]
      }],
      /**
       * Margin Left
       * @see https://tailwindcss.com/docs/margin
       */
      ml: [{
        ml: [v]
      }],
      /**
       * Space Between X
       * @see https://tailwindcss.com/docs/space
       */
      "space-x": [{
        "space-x": [P]
      }],
      /**
       * Space Between X Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-x-reverse": ["space-x-reverse"],
      /**
       * Space Between Y
       * @see https://tailwindcss.com/docs/space
       */
      "space-y": [{
        "space-y": [P]
      }],
      /**
       * Space Between Y Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-y-reverse": ["space-y-reverse"],
      // Sizing
      /**
       * Width
       * @see https://tailwindcss.com/docs/width
       */
      w: [{
        w: ["auto", "min", "max", "fit", "svw", "lvw", "dvw", Je, t]
      }],
      /**
       * Min-Width
       * @see https://tailwindcss.com/docs/min-width
       */
      "min-w": [{
        "min-w": [Je, t, "min", "max", "fit"]
      }],
      /**
       * Max-Width
       * @see https://tailwindcss.com/docs/max-width
       */
      "max-w": [{
        "max-w": [Je, t, "none", "full", "min", "max", "fit", "prose", {
          screen: [ma]
        }, ma]
      }],
      /**
       * Height
       * @see https://tailwindcss.com/docs/height
       */
      h: [{
        h: [Je, t, "auto", "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Min-Height
       * @see https://tailwindcss.com/docs/min-height
       */
      "min-h": [{
        "min-h": [Je, t, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Max-Height
       * @see https://tailwindcss.com/docs/max-height
       */
      "max-h": [{
        "max-h": [Je, t, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Size
       * @see https://tailwindcss.com/docs/size
       */
      size: [{
        size: [Je, t, "auto", "min", "max", "fit"]
      }],
      // Typography
      /**
       * Font Size
       * @see https://tailwindcss.com/docs/font-size
       */
      "font-size": [{
        text: ["base", ma, pa]
      }],
      /**
       * Font Smoothing
       * @see https://tailwindcss.com/docs/font-smoothing
       */
      "font-smoothing": ["antialiased", "subpixel-antialiased"],
      /**
       * Font Style
       * @see https://tailwindcss.com/docs/font-style
       */
      "font-style": ["italic", "not-italic"],
      /**
       * Font Weight
       * @see https://tailwindcss.com/docs/font-weight
       */
      "font-weight": [{
        font: ["thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", Vv]
      }],
      /**
       * Font Family
       * @see https://tailwindcss.com/docs/font-family
       */
      "font-family": [{
        font: [xu]
      }],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-normal": ["normal-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-ordinal": ["ordinal"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-slashed-zero": ["slashed-zero"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-figure": ["lining-nums", "oldstyle-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-spacing": ["proportional-nums", "tabular-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-fraction": ["diagonal-fractions", "stacked-fractons"],
      /**
       * Letter Spacing
       * @see https://tailwindcss.com/docs/letter-spacing
       */
      tracking: [{
        tracking: ["tighter", "tight", "normal", "wide", "wider", "widest", Je]
      }],
      /**
       * Line Clamp
       * @see https://tailwindcss.com/docs/line-clamp
       */
      "line-clamp": [{
        "line-clamp": ["none", Vl, Vv]
      }],
      /**
       * Line Height
       * @see https://tailwindcss.com/docs/line-height
       */
      leading: [{
        leading: ["none", "tight", "snug", "normal", "relaxed", "loose", bo, Je]
      }],
      /**
       * List Style Image
       * @see https://tailwindcss.com/docs/list-style-image
       */
      "list-image": [{
        "list-image": ["none", Je]
      }],
      /**
       * List Style Type
       * @see https://tailwindcss.com/docs/list-style-type
       */
      "list-style-type": [{
        list: ["none", "disc", "decimal", Je]
      }],
      /**
       * List Style Position
       * @see https://tailwindcss.com/docs/list-style-position
       */
      "list-style-position": [{
        list: ["inside", "outside"]
      }],
      /**
       * Placeholder Color
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/placeholder-color
       */
      "placeholder-color": [{
        placeholder: [e]
      }],
      /**
       * Placeholder Opacity
       * @see https://tailwindcss.com/docs/placeholder-opacity
       */
      "placeholder-opacity": [{
        "placeholder-opacity": [x]
      }],
      /**
       * Text Alignment
       * @see https://tailwindcss.com/docs/text-align
       */
      "text-alignment": [{
        text: ["left", "center", "right", "justify", "start", "end"]
      }],
      /**
       * Text Color
       * @see https://tailwindcss.com/docs/text-color
       */
      "text-color": [{
        text: [e]
      }],
      /**
       * Text Opacity
       * @see https://tailwindcss.com/docs/text-opacity
       */
      "text-opacity": [{
        "text-opacity": [x]
      }],
      /**
       * Text Decoration
       * @see https://tailwindcss.com/docs/text-decoration
       */
      "text-decoration": ["underline", "overline", "line-through", "no-underline"],
      /**
       * Text Decoration Style
       * @see https://tailwindcss.com/docs/text-decoration-style
       */
      "text-decoration-style": [{
        decoration: [...W(), "wavy"]
      }],
      /**
       * Text Decoration Thickness
       * @see https://tailwindcss.com/docs/text-decoration-thickness
       */
      "text-decoration-thickness": [{
        decoration: ["auto", "from-font", bo, pa]
      }],
      /**
       * Text Underline Offset
       * @see https://tailwindcss.com/docs/text-underline-offset
       */
      "underline-offset": [{
        "underline-offset": ["auto", bo, Je]
      }],
      /**
       * Text Decoration Color
       * @see https://tailwindcss.com/docs/text-decoration-color
       */
      "text-decoration-color": [{
        decoration: [e]
      }],
      /**
       * Text Transform
       * @see https://tailwindcss.com/docs/text-transform
       */
      "text-transform": ["uppercase", "lowercase", "capitalize", "normal-case"],
      /**
       * Text Overflow
       * @see https://tailwindcss.com/docs/text-overflow
       */
      "text-overflow": ["truncate", "text-ellipsis", "text-clip"],
      /**
       * Text Wrap
       * @see https://tailwindcss.com/docs/text-wrap
       */
      "text-wrap": [{
        text: ["wrap", "nowrap", "balance", "pretty"]
      }],
      /**
       * Text Indent
       * @see https://tailwindcss.com/docs/text-indent
       */
      indent: [{
        indent: N()
      }],
      /**
       * Vertical Alignment
       * @see https://tailwindcss.com/docs/vertical-align
       */
      "vertical-align": [{
        align: ["baseline", "top", "middle", "bottom", "text-top", "text-bottom", "sub", "super", Je]
      }],
      /**
       * Whitespace
       * @see https://tailwindcss.com/docs/whitespace
       */
      whitespace: [{
        whitespace: ["normal", "nowrap", "pre", "pre-line", "pre-wrap", "break-spaces"]
      }],
      /**
       * Word Break
       * @see https://tailwindcss.com/docs/word-break
       */
      break: [{
        break: ["normal", "words", "all", "keep"]
      }],
      /**
       * Hyphens
       * @see https://tailwindcss.com/docs/hyphens
       */
      hyphens: [{
        hyphens: ["none", "manual", "auto"]
      }],
      /**
       * Content
       * @see https://tailwindcss.com/docs/content
       */
      content: [{
        content: ["none", Je]
      }],
      // Backgrounds
      /**
       * Background Attachment
       * @see https://tailwindcss.com/docs/background-attachment
       */
      "bg-attachment": [{
        bg: ["fixed", "local", "scroll"]
      }],
      /**
       * Background Clip
       * @see https://tailwindcss.com/docs/background-clip
       */
      "bg-clip": [{
        "bg-clip": ["border", "padding", "content", "text"]
      }],
      /**
       * Background Opacity
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/background-opacity
       */
      "bg-opacity": [{
        "bg-opacity": [x]
      }],
      /**
       * Background Origin
       * @see https://tailwindcss.com/docs/background-origin
       */
      "bg-origin": [{
        "bg-origin": ["border", "padding", "content"]
      }],
      /**
       * Background Position
       * @see https://tailwindcss.com/docs/background-position
       */
      "bg-position": [{
        bg: [...F(), kH]
      }],
      /**
       * Background Repeat
       * @see https://tailwindcss.com/docs/background-repeat
       */
      "bg-repeat": [{
        bg: ["no-repeat", {
          repeat: ["", "x", "y", "round", "space"]
        }]
      }],
      /**
       * Background Size
       * @see https://tailwindcss.com/docs/background-size
       */
      "bg-size": [{
        bg: ["auto", "cover", "contain", EH]
      }],
      /**
       * Background Image
       * @see https://tailwindcss.com/docs/background-image
       */
      "bg-image": [{
        bg: ["none", {
          "gradient-to": ["t", "tr", "r", "br", "b", "bl", "l", "tl"]
        }, NH]
      }],
      /**
       * Background Color
       * @see https://tailwindcss.com/docs/background-color
       */
      "bg-color": [{
        bg: [e]
      }],
      /**
       * Gradient Color Stops From Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from-pos": [{
        from: [y]
      }],
      /**
       * Gradient Color Stops Via Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via-pos": [{
        via: [y]
      }],
      /**
       * Gradient Color Stops To Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to-pos": [{
        to: [y]
      }],
      /**
       * Gradient Color Stops From
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from": [{
        from: [m]
      }],
      /**
       * Gradient Color Stops Via
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via": [{
        via: [m]
      }],
      /**
       * Gradient Color Stops To
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to": [{
        to: [m]
      }],
      // Borders
      /**
       * Border Radius
       * @see https://tailwindcss.com/docs/border-radius
       */
      rounded: [{
        rounded: [o]
      }],
      /**
       * Border Radius Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-s": [{
        "rounded-s": [o]
      }],
      /**
       * Border Radius End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-e": [{
        "rounded-e": [o]
      }],
      /**
       * Border Radius Top
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-t": [{
        "rounded-t": [o]
      }],
      /**
       * Border Radius Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-r": [{
        "rounded-r": [o]
      }],
      /**
       * Border Radius Bottom
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-b": [{
        "rounded-b": [o]
      }],
      /**
       * Border Radius Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-l": [{
        "rounded-l": [o]
      }],
      /**
       * Border Radius Start Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ss": [{
        "rounded-ss": [o]
      }],
      /**
       * Border Radius Start End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-se": [{
        "rounded-se": [o]
      }],
      /**
       * Border Radius End End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ee": [{
        "rounded-ee": [o]
      }],
      /**
       * Border Radius End Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-es": [{
        "rounded-es": [o]
      }],
      /**
       * Border Radius Top Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tl": [{
        "rounded-tl": [o]
      }],
      /**
       * Border Radius Top Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tr": [{
        "rounded-tr": [o]
      }],
      /**
       * Border Radius Bottom Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-br": [{
        "rounded-br": [o]
      }],
      /**
       * Border Radius Bottom Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-bl": [{
        "rounded-bl": [o]
      }],
      /**
       * Border Width
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w": [{
        border: [s]
      }],
      /**
       * Border Width X
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-x": [{
        "border-x": [s]
      }],
      /**
       * Border Width Y
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-y": [{
        "border-y": [s]
      }],
      /**
       * Border Width Start
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-s": [{
        "border-s": [s]
      }],
      /**
       * Border Width End
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-e": [{
        "border-e": [s]
      }],
      /**
       * Border Width Top
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-t": [{
        "border-t": [s]
      }],
      /**
       * Border Width Right
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-r": [{
        "border-r": [s]
      }],
      /**
       * Border Width Bottom
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-b": [{
        "border-b": [s]
      }],
      /**
       * Border Width Left
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-l": [{
        "border-l": [s]
      }],
      /**
       * Border Opacity
       * @see https://tailwindcss.com/docs/border-opacity
       */
      "border-opacity": [{
        "border-opacity": [x]
      }],
      /**
       * Border Style
       * @see https://tailwindcss.com/docs/border-style
       */
      "border-style": [{
        border: [...W(), "hidden"]
      }],
      /**
       * Divide Width X
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x": [{
        "divide-x": [s]
      }],
      /**
       * Divide Width X Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x-reverse": ["divide-x-reverse"],
      /**
       * Divide Width Y
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y": [{
        "divide-y": [s]
      }],
      /**
       * Divide Width Y Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y-reverse": ["divide-y-reverse"],
      /**
       * Divide Opacity
       * @see https://tailwindcss.com/docs/divide-opacity
       */
      "divide-opacity": [{
        "divide-opacity": [x]
      }],
      /**
       * Divide Style
       * @see https://tailwindcss.com/docs/divide-style
       */
      "divide-style": [{
        divide: W()
      }],
      /**
       * Border Color
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color": [{
        border: [i]
      }],
      /**
       * Border Color X
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-x": [{
        "border-x": [i]
      }],
      /**
       * Border Color Y
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-y": [{
        "border-y": [i]
      }],
      /**
       * Border Color S
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-s": [{
        "border-s": [i]
      }],
      /**
       * Border Color E
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-e": [{
        "border-e": [i]
      }],
      /**
       * Border Color Top
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-t": [{
        "border-t": [i]
      }],
      /**
       * Border Color Right
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-r": [{
        "border-r": [i]
      }],
      /**
       * Border Color Bottom
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-b": [{
        "border-b": [i]
      }],
      /**
       * Border Color Left
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-l": [{
        "border-l": [i]
      }],
      /**
       * Divide Color
       * @see https://tailwindcss.com/docs/divide-color
       */
      "divide-color": [{
        divide: [i]
      }],
      /**
       * Outline Style
       * @see https://tailwindcss.com/docs/outline-style
       */
      "outline-style": [{
        outline: ["", ...W()]
      }],
      /**
       * Outline Offset
       * @see https://tailwindcss.com/docs/outline-offset
       */
      "outline-offset": [{
        "outline-offset": [bo, Je]
      }],
      /**
       * Outline Width
       * @see https://tailwindcss.com/docs/outline-width
       */
      "outline-w": [{
        outline: [bo, pa]
      }],
      /**
       * Outline Color
       * @see https://tailwindcss.com/docs/outline-color
       */
      "outline-color": [{
        outline: [e]
      }],
      /**
       * Ring Width
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w": [{
        ring: D()
      }],
      /**
       * Ring Width Inset
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w-inset": ["ring-inset"],
      /**
       * Ring Color
       * @see https://tailwindcss.com/docs/ring-color
       */
      "ring-color": [{
        ring: [e]
      }],
      /**
       * Ring Opacity
       * @see https://tailwindcss.com/docs/ring-opacity
       */
      "ring-opacity": [{
        "ring-opacity": [x]
      }],
      /**
       * Ring Offset Width
       * @see https://tailwindcss.com/docs/ring-offset-width
       */
      "ring-offset-w": [{
        "ring-offset": [bo, pa]
      }],
      /**
       * Ring Offset Color
       * @see https://tailwindcss.com/docs/ring-offset-color
       */
      "ring-offset-color": [{
        "ring-offset": [e]
      }],
      // Effects
      /**
       * Box Shadow
       * @see https://tailwindcss.com/docs/box-shadow
       */
      shadow: [{
        shadow: ["", "inner", "none", ma, $H]
      }],
      /**
       * Box Shadow Color
       * @see https://tailwindcss.com/docs/box-shadow-color
       */
      "shadow-color": [{
        shadow: [xu]
      }],
      /**
       * Opacity
       * @see https://tailwindcss.com/docs/opacity
       */
      opacity: [{
        opacity: [x]
      }],
      /**
       * Mix Blend Mode
       * @see https://tailwindcss.com/docs/mix-blend-mode
       */
      "mix-blend": [{
        "mix-blend": [...z(), "plus-lighter", "plus-darker"]
      }],
      /**
       * Background Blend Mode
       * @see https://tailwindcss.com/docs/background-blend-mode
       */
      "bg-blend": [{
        "bg-blend": z()
      }],
      // Filters
      /**
       * Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/filter
       */
      filter: [{
        filter: ["", "none"]
      }],
      /**
       * Blur
       * @see https://tailwindcss.com/docs/blur
       */
      blur: [{
        blur: [n]
      }],
      /**
       * Brightness
       * @see https://tailwindcss.com/docs/brightness
       */
      brightness: [{
        brightness: [r]
      }],
      /**
       * Contrast
       * @see https://tailwindcss.com/docs/contrast
       */
      contrast: [{
        contrast: [l]
      }],
      /**
       * Drop Shadow
       * @see https://tailwindcss.com/docs/drop-shadow
       */
      "drop-shadow": [{
        "drop-shadow": ["", "none", ma, Je]
      }],
      /**
       * Grayscale
       * @see https://tailwindcss.com/docs/grayscale
       */
      grayscale: [{
        grayscale: [c]
      }],
      /**
       * Hue Rotate
       * @see https://tailwindcss.com/docs/hue-rotate
       */
      "hue-rotate": [{
        "hue-rotate": [f]
      }],
      /**
       * Invert
       * @see https://tailwindcss.com/docs/invert
       */
      invert: [{
        invert: [d]
      }],
      /**
       * Saturate
       * @see https://tailwindcss.com/docs/saturate
       */
      saturate: [{
        saturate: [S]
      }],
      /**
       * Sepia
       * @see https://tailwindcss.com/docs/sepia
       */
      sepia: [{
        sepia: [_]
      }],
      /**
       * Backdrop Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/backdrop-filter
       */
      "backdrop-filter": [{
        "backdrop-filter": ["", "none"]
      }],
      /**
       * Backdrop Blur
       * @see https://tailwindcss.com/docs/backdrop-blur
       */
      "backdrop-blur": [{
        "backdrop-blur": [n]
      }],
      /**
       * Backdrop Brightness
       * @see https://tailwindcss.com/docs/backdrop-brightness
       */
      "backdrop-brightness": [{
        "backdrop-brightness": [r]
      }],
      /**
       * Backdrop Contrast
       * @see https://tailwindcss.com/docs/backdrop-contrast
       */
      "backdrop-contrast": [{
        "backdrop-contrast": [l]
      }],
      /**
       * Backdrop Grayscale
       * @see https://tailwindcss.com/docs/backdrop-grayscale
       */
      "backdrop-grayscale": [{
        "backdrop-grayscale": [c]
      }],
      /**
       * Backdrop Hue Rotate
       * @see https://tailwindcss.com/docs/backdrop-hue-rotate
       */
      "backdrop-hue-rotate": [{
        "backdrop-hue-rotate": [f]
      }],
      /**
       * Backdrop Invert
       * @see https://tailwindcss.com/docs/backdrop-invert
       */
      "backdrop-invert": [{
        "backdrop-invert": [d]
      }],
      /**
       * Backdrop Opacity
       * @see https://tailwindcss.com/docs/backdrop-opacity
       */
      "backdrop-opacity": [{
        "backdrop-opacity": [x]
      }],
      /**
       * Backdrop Saturate
       * @see https://tailwindcss.com/docs/backdrop-saturate
       */
      "backdrop-saturate": [{
        "backdrop-saturate": [S]
      }],
      /**
       * Backdrop Sepia
       * @see https://tailwindcss.com/docs/backdrop-sepia
       */
      "backdrop-sepia": [{
        "backdrop-sepia": [_]
      }],
      // Tables
      /**
       * Border Collapse
       * @see https://tailwindcss.com/docs/border-collapse
       */
      "border-collapse": [{
        border: ["collapse", "separate"]
      }],
      /**
       * Border Spacing
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing": [{
        "border-spacing": [a]
      }],
      /**
       * Border Spacing X
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-x": [{
        "border-spacing-x": [a]
      }],
      /**
       * Border Spacing Y
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-y": [{
        "border-spacing-y": [a]
      }],
      /**
       * Table Layout
       * @see https://tailwindcss.com/docs/table-layout
       */
      "table-layout": [{
        table: ["auto", "fixed"]
      }],
      /**
       * Caption Side
       * @see https://tailwindcss.com/docs/caption-side
       */
      caption: [{
        caption: ["top", "bottom"]
      }],
      // Transitions and Animation
      /**
       * Tranisition Property
       * @see https://tailwindcss.com/docs/transition-property
       */
      transition: [{
        transition: ["none", "all", "", "colors", "opacity", "shadow", "transform", Je]
      }],
      /**
       * Transition Duration
       * @see https://tailwindcss.com/docs/transition-duration
       */
      duration: [{
        duration: Y()
      }],
      /**
       * Transition Timing Function
       * @see https://tailwindcss.com/docs/transition-timing-function
       */
      ease: [{
        ease: ["linear", "in", "out", "in-out", Je]
      }],
      /**
       * Transition Delay
       * @see https://tailwindcss.com/docs/transition-delay
       */
      delay: [{
        delay: Y()
      }],
      /**
       * Animation
       * @see https://tailwindcss.com/docs/animation
       */
      animate: [{
        animate: ["none", "spin", "ping", "pulse", "bounce", Je]
      }],
      // Transforms
      /**
       * Transform
       * @see https://tailwindcss.com/docs/transform
       */
      transform: [{
        transform: ["", "gpu", "none"]
      }],
      /**
       * Scale
       * @see https://tailwindcss.com/docs/scale
       */
      scale: [{
        scale: [A]
      }],
      /**
       * Scale X
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-x": [{
        "scale-x": [A]
      }],
      /**
       * Scale Y
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-y": [{
        "scale-y": [A]
      }],
      /**
       * Rotate
       * @see https://tailwindcss.com/docs/rotate
       */
      rotate: [{
        rotate: [bu, Je]
      }],
      /**
       * Translate X
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-x": [{
        "translate-x": [C]
      }],
      /**
       * Translate Y
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-y": [{
        "translate-y": [C]
      }],
      /**
       * Skew X
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-x": [{
        "skew-x": [O]
      }],
      /**
       * Skew Y
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-y": [{
        "skew-y": [O]
      }],
      /**
       * Transform Origin
       * @see https://tailwindcss.com/docs/transform-origin
       */
      "transform-origin": [{
        origin: ["center", "top", "top-right", "right", "bottom-right", "bottom", "bottom-left", "left", "top-left", Je]
      }],
      // Interactivity
      /**
       * Accent Color
       * @see https://tailwindcss.com/docs/accent-color
       */
      accent: [{
        accent: ["auto", e]
      }],
      /**
       * Appearance
       * @see https://tailwindcss.com/docs/appearance
       */
      appearance: [{
        appearance: ["none", "auto"]
      }],
      /**
       * Cursor
       * @see https://tailwindcss.com/docs/cursor
       */
      cursor: [{
        cursor: ["auto", "default", "pointer", "wait", "text", "move", "help", "not-allowed", "none", "context-menu", "progress", "cell", "crosshair", "vertical-text", "alias", "copy", "no-drop", "grab", "grabbing", "all-scroll", "col-resize", "row-resize", "n-resize", "e-resize", "s-resize", "w-resize", "ne-resize", "nw-resize", "se-resize", "sw-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "zoom-in", "zoom-out", Je]
      }],
      /**
       * Caret Color
       * @see https://tailwindcss.com/docs/just-in-time-mode#caret-color-utilities
       */
      "caret-color": [{
        caret: [e]
      }],
      /**
       * Pointer Events
       * @see https://tailwindcss.com/docs/pointer-events
       */
      "pointer-events": [{
        "pointer-events": ["none", "auto"]
      }],
      /**
       * Resize
       * @see https://tailwindcss.com/docs/resize
       */
      resize: [{
        resize: ["none", "y", "x", ""]
      }],
      /**
       * Scroll Behavior
       * @see https://tailwindcss.com/docs/scroll-behavior
       */
      "scroll-behavior": [{
        scroll: ["auto", "smooth"]
      }],
      /**
       * Scroll Margin
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-m": [{
        "scroll-m": N()
      }],
      /**
       * Scroll Margin X
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mx": [{
        "scroll-mx": N()
      }],
      /**
       * Scroll Margin Y
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-my": [{
        "scroll-my": N()
      }],
      /**
       * Scroll Margin Start
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ms": [{
        "scroll-ms": N()
      }],
      /**
       * Scroll Margin End
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-me": [{
        "scroll-me": N()
      }],
      /**
       * Scroll Margin Top
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mt": [{
        "scroll-mt": N()
      }],
      /**
       * Scroll Margin Right
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mr": [{
        "scroll-mr": N()
      }],
      /**
       * Scroll Margin Bottom
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mb": [{
        "scroll-mb": N()
      }],
      /**
       * Scroll Margin Left
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ml": [{
        "scroll-ml": N()
      }],
      /**
       * Scroll Padding
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-p": [{
        "scroll-p": N()
      }],
      /**
       * Scroll Padding X
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-px": [{
        "scroll-px": N()
      }],
      /**
       * Scroll Padding Y
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-py": [{
        "scroll-py": N()
      }],
      /**
       * Scroll Padding Start
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-ps": [{
        "scroll-ps": N()
      }],
      /**
       * Scroll Padding End
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pe": [{
        "scroll-pe": N()
      }],
      /**
       * Scroll Padding Top
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pt": [{
        "scroll-pt": N()
      }],
      /**
       * Scroll Padding Right
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pr": [{
        "scroll-pr": N()
      }],
      /**
       * Scroll Padding Bottom
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pb": [{
        "scroll-pb": N()
      }],
      /**
       * Scroll Padding Left
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pl": [{
        "scroll-pl": N()
      }],
      /**
       * Scroll Snap Align
       * @see https://tailwindcss.com/docs/scroll-snap-align
       */
      "snap-align": [{
        snap: ["start", "end", "center", "align-none"]
      }],
      /**
       * Scroll Snap Stop
       * @see https://tailwindcss.com/docs/scroll-snap-stop
       */
      "snap-stop": [{
        snap: ["normal", "always"]
      }],
      /**
       * Scroll Snap Type
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-type": [{
        snap: ["none", "x", "y", "both"]
      }],
      /**
       * Scroll Snap Type Strictness
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-strictness": [{
        snap: ["mandatory", "proximity"]
      }],
      /**
       * Touch Action
       * @see https://tailwindcss.com/docs/touch-action
       */
      touch: [{
        touch: ["auto", "none", "manipulation"]
      }],
      /**
       * Touch Action X
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-x": [{
        "touch-pan": ["x", "left", "right"]
      }],
      /**
       * Touch Action Y
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-y": [{
        "touch-pan": ["y", "up", "down"]
      }],
      /**
       * Touch Action Pinch Zoom
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-pz": ["touch-pinch-zoom"],
      /**
       * User Select
       * @see https://tailwindcss.com/docs/user-select
       */
      select: [{
        select: ["none", "text", "all", "auto"]
      }],
      /**
       * Will Change
       * @see https://tailwindcss.com/docs/will-change
       */
      "will-change": [{
        "will-change": ["auto", "scroll", "contents", "transform", Je]
      }],
      // SVG
      /**
       * Fill
       * @see https://tailwindcss.com/docs/fill
       */
      fill: [{
        fill: [e, "none"]
      }],
      /**
       * Stroke Width
       * @see https://tailwindcss.com/docs/stroke-width
       */
      "stroke-w": [{
        stroke: [bo, pa, Vv]
      }],
      /**
       * Stroke
       * @see https://tailwindcss.com/docs/stroke
       */
      stroke: [{
        stroke: [e, "none"]
      }],
      // Accessibility
      /**
       * Screen Readers
       * @see https://tailwindcss.com/docs/screen-readers
       */
      sr: ["sr-only", "not-sr-only"],
      /**
       * Forced Color Adjust
       * @see https://tailwindcss.com/docs/forced-color-adjust
       */
      "forced-color-adjust": [{
        "forced-color-adjust": ["auto", "none"]
      }]
    },
    conflictingClassGroups: {
      overflow: ["overflow-x", "overflow-y"],
      overscroll: ["overscroll-x", "overscroll-y"],
      inset: ["inset-x", "inset-y", "start", "end", "top", "right", "bottom", "left"],
      "inset-x": ["right", "left"],
      "inset-y": ["top", "bottom"],
      flex: ["basis", "grow", "shrink"],
      gap: ["gap-x", "gap-y"],
      p: ["px", "py", "ps", "pe", "pt", "pr", "pb", "pl"],
      px: ["pr", "pl"],
      py: ["pt", "pb"],
      m: ["mx", "my", "ms", "me", "mt", "mr", "mb", "ml"],
      mx: ["mr", "ml"],
      my: ["mt", "mb"],
      size: ["w", "h"],
      "font-size": ["leading"],
      "fvn-normal": ["fvn-ordinal", "fvn-slashed-zero", "fvn-figure", "fvn-spacing", "fvn-fraction"],
      "fvn-ordinal": ["fvn-normal"],
      "fvn-slashed-zero": ["fvn-normal"],
      "fvn-figure": ["fvn-normal"],
      "fvn-spacing": ["fvn-normal"],
      "fvn-fraction": ["fvn-normal"],
      "line-clamp": ["display", "overflow"],
      rounded: ["rounded-s", "rounded-e", "rounded-t", "rounded-r", "rounded-b", "rounded-l", "rounded-ss", "rounded-se", "rounded-ee", "rounded-es", "rounded-tl", "rounded-tr", "rounded-br", "rounded-bl"],
      "rounded-s": ["rounded-ss", "rounded-es"],
      "rounded-e": ["rounded-se", "rounded-ee"],
      "rounded-t": ["rounded-tl", "rounded-tr"],
      "rounded-r": ["rounded-tr", "rounded-br"],
      "rounded-b": ["rounded-br", "rounded-bl"],
      "rounded-l": ["rounded-tl", "rounded-bl"],
      "border-spacing": ["border-spacing-x", "border-spacing-y"],
      "border-w": ["border-w-s", "border-w-e", "border-w-t", "border-w-r", "border-w-b", "border-w-l"],
      "border-w-x": ["border-w-r", "border-w-l"],
      "border-w-y": ["border-w-t", "border-w-b"],
      "border-color": ["border-color-s", "border-color-e", "border-color-t", "border-color-r", "border-color-b", "border-color-l"],
      "border-color-x": ["border-color-r", "border-color-l"],
      "border-color-y": ["border-color-t", "border-color-b"],
      "scroll-m": ["scroll-mx", "scroll-my", "scroll-ms", "scroll-me", "scroll-mt", "scroll-mr", "scroll-mb", "scroll-ml"],
      "scroll-mx": ["scroll-mr", "scroll-ml"],
      "scroll-my": ["scroll-mt", "scroll-mb"],
      "scroll-p": ["scroll-px", "scroll-py", "scroll-ps", "scroll-pe", "scroll-pt", "scroll-pr", "scroll-pb", "scroll-pl"],
      "scroll-px": ["scroll-pr", "scroll-pl"],
      "scroll-py": ["scroll-pt", "scroll-pb"],
      touch: ["touch-x", "touch-y", "touch-pz"],
      "touch-x": ["touch"],
      "touch-y": ["touch"],
      "touch-pz": ["touch"]
    },
    conflictingClassGroupModifiers: {
      "font-size": ["leading"]
    }
  };
}, LH = /* @__PURE__ */ bH(jH);
function Z$(e) {
  var t, n, r = "";
  if (typeof e == "string" || typeof e == "number") r += e;
  else if (typeof e == "object") if (Array.isArray(e)) {
    var i = e.length;
    for (t = 0; t < i; t++) e[t] && (n = Z$(e[t])) && (r && (r += " "), r += n);
  } else for (n in e) e[n] && (r && (r += " "), r += n);
  return r;
}
function Xe() {
  for (var e, t, n = 0, r = "", i = arguments.length; n < i; n++) (e = arguments[n]) && (t = Z$(e)) && (r && (r += " "), r += t);
  return r;
}
const K = (...e) => LH(Xe(...e)), cf = (...e) => (...t) => e.forEach((n) => n == null ? void 0 : n(...t)), Jm = (e) => {
  const t = {
    0: "gap-0",
    xxs: "gap-1",
    xs: "gap-2",
    sm: "gap-3",
    md: "gap-4",
    lg: "gap-5",
    xl: "gap-6",
    "2xl": "gap-8"
  };
  return t[e] || t.md;
}, BH = {
  1: "grid-cols-1",
  2: "grid-cols-2",
  3: "grid-cols-3",
  4: "grid-cols-4",
  5: "grid-cols-5",
  6: "grid-cols-6",
  7: "grid-cols-7",
  8: "grid-cols-8",
  9: "grid-cols-9",
  10: "grid-cols-10",
  11: "grid-cols-11",
  12: "grid-cols-12"
}, FH = () => {
  var i, o;
  const e = ((o = (i = window.navigator) == null ? void 0 : i.userAgentData) == null ? void 0 : o.platform) || window.navigator.platform, t = [
    "macOS",
    "Macintosh",
    "MacIntel",
    "MacPPC",
    "Mac68K"
  ], n = ["Win32", "Win64", "Windows", "WinCE"];
  let r = "null";
  return t.includes(e) ? r = "Mac OS" : n.includes(e) && (r = "Windows"), r;
}, WH = (e) => e < 1024 ? `${e} bytes` : e < 1024 * 1024 ? `${(e / 1024).toFixed(2)} KB` : e < 1024 * 1024 * 1024 ? `${(e / (1024 * 1024)).toFixed(2)} MB` : `${(e / (1024 * 1024 * 1024)).toFixed(2)} GB`, ju = {
  set: (e, t) => {
    if (!(typeof window > "u"))
      try {
        localStorage.setItem(e, JSON.stringify(t));
      } catch (n) {
        console.error(n);
      }
  },
  get: (e) => {
    if (typeof window > "u")
      return null;
    try {
      const t = localStorage.getItem(e);
      return t ? JSON.parse(t) : null;
    } catch (t) {
      return console.error(t), null;
    }
  },
  remove: (e) => {
    if (!(typeof window > "u"))
      try {
        localStorage.removeItem(e);
      } catch (t) {
        console.error(t);
      }
  }
}, Hn = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  (e, t) => {
    const {
      variant: n = "primary",
      // primary, secondary, outline, ghost, link
      size: r = "md",
      // xs, sm, md, lg
      type: i = "button",
      tag: o = "button",
      className: a,
      children: s,
      disabled: l = !1,
      destructive: c = !1,
      // true, false
      icon: f = null,
      // icon component
      iconPosition: d = "left",
      // left, right,
      loading: p = !1,
      ...m
    } = e, y = "outline outline-1 border-none cursor-pointer transition-colors duration-300 ease-in-out text-xs font-semibold focus:ring-2 focus:ring-toggle-on focus:ring-offset-2 disabled:text-text-disabled", g = p ? "opacity-50 disabled:cursor-not-allowed" : "", v = {
      primary: "text-text-on-color bg-button-primary hover:bg-button-primary-hover outline-button-primary hover:outline-button-primary-hover disabled:bg-button-disabled disabled:outline-button-disabled",
      secondary: "text-text-on-color bg-button-secondary hover:bg-button-secondary-hover outline-button-secondary hover:outline-button-secondary-hover disabled:bg-button-disabled disabled:outline-button-disabled",
      outline: "text-button-tertiary-color outline-border-subtle bg-button-tertiary hover:bg-button-tertiary-hover hover:outline-border-subtle disabled:bg-button-tertiary disabled:outline-border-disabled",
      ghost: "text-text-primary bg-transparent outline-transparent hover:bg-button-tertiary-hover",
      link: "outline-none text-link-primary bg-transparent hover:text-link-primary-hover hover:underline p-0 border-0 leading-none"
    }[n], x = c && !l ? {
      primary: "bg-button-danger hover:bg-button-danger-hover outline-button-danger hover:outline-button-danger-hover",
      secondary: "bg-button-danger hover:bg-button-danger-hover outline-button-danger hover:outline-button-danger-hover",
      outline: "text-button-danger outline outline-1 outline-button-danger hover:outline-button-danger bg-button-tertiary hover:bg-field-background-error",
      ghost: "text-button-danger hover:bg-field-background-error",
      link: "text-button-danger hover:text-button-danger-secondary"
    }[n] : "", w = {
      xs: "p-1 rounded [&>svg]:size-4",
      sm: "p-2 rounded [&>svg]:size-4 gap-0.5",
      md: "p-2.5 rounded-md text-sm [&>svg]:size-5 gap-1",
      lg: "p-3 rounded-lg text-base [&>svg]:size-6 gap-1"
    }[r];
    let S, A = null, _ = "";
    return f && (_ = "flex items-center justify-center", d === "left" ? S = f : A = f), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      o,
      {
        ref: t,
        type: i,
        className: K(
          _,
          y,
          w,
          v,
          x,
          g,
          {
            "cursor-default": l
          },
          a
        ),
        disabled: l,
        ...m,
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: S }, "left-icon"),
          s ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "px-1", children: s }) : null,
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: A }, "right-icon")
        ]
      }
    );
  }
);
Hn.displayName = "Button";
const zH = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
let io = (e = 21) => {
  let t = "", n = crypto.getRandomValues(new Uint8Array(e));
  for (; e--; )
    t += zH[n[e] & 63];
  return t;
};
const to = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    children: e = null,
    tag: t = "label",
    size: n = "sm",
    // xs, sm, md
    className: r = "",
    variant: i = "neutral",
    // neutral, help, error, disabled
    required: o = !1,
    ...a
  }, s) => {
    const l = "font-medium text-field-label flex items-center gap-0.5", c = {
      xs: "text-xs [&>*]:text-xs [&>svg]:h-3 [&>svg]:w-3",
      sm: "text-sm [&>*]:text-sm [&>svg]:h-4 [&>svg]:w-4",
      md: "text-base [&>*]:text-base [&>svg]:h-5 [&>svg]:w-5"
    }, f = {
      neutral: "text-field-label [&>*]:text-field-label",
      help: "text-field-helper [&>*]:text-field-helper",
      error: "text-support-error [&>*]:text-support-error",
      disabled: "text-field-color-disabled disabled cursor-not-allowed [&>*]:text-field-color-disabled"
    }, d = {
      neutral: "",
      help: "font-normal",
      error: "font-normal",
      disabled: ""
    };
    if (!e)
      return null;
    let p = "";
    return o && (p = "after:content-['*'] after:text-field-required after:ml-0.5"), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      t,
      {
        ref: s,
        className: K(
          l,
          c[n],
          f[i],
          p,
          d == null ? void 0 : d[i],
          r
        ),
        ...a,
        children: e
      }
    );
  }
);
to.displayName = "Label";
const VH = ({
  label: e,
  switchId: t,
  disabled: n = !1,
  children: r,
  size: i
}) => {
  const o = {
    sm: "text-sm leading-5 font-medium",
    md: "text-base leading-6 font-medium"
  }, a = {
    sm: "text-sm leading-5 font-normal",
    md: "text-sm leading-5 font-normal"
  }, s = {
    sm: "space-y-0.5",
    md: "space-y-1"
  };
  if ((0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e))
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        className: K("inline-flex items-center gap-3", "items-start"),
        children: [
          r,
          e
        ]
      }
    );
  const c = () => {
    const { heading: p = "", description: m = "" } = e || {};
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("space-y-0.5", s[i]), children: [
      p && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        to,
        {
          htmlFor: t,
          className: K("m-0", o[i]),
          ...n && { variant: "disabled" },
          children: p
        }
      ),
      m && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        to,
        {
          tag: "p",
          variant: "help",
          className: K(
            "text-sm font-normal leading-5 m-0",
            a[i]
          ),
          ...n && { variant: "disabled" },
          children: m
        }
      )
    ] });
  }, f = !(e != null && e.heading) && !(e != null && e.description), d = !(e != null && e.heading) || !(e != null && e.description) ? "items-center" : "items-start";
  return f ? r : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("inline-flex", d, "gap-3"), children: [
    r,
    c()
  ] });
}, UH = ({
  id: e,
  onChange: t,
  value: n,
  defaultValue: r = !1,
  size: i = "sm",
  disabled: o = !1,
  label: a = { heading: "", description: "" },
  name: s,
  className: l,
  ...c
}, f) => {
  const d = i === "lg" ? "md" : i, p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof n < "u", [n]), m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `switch-${io()}`, []), [y, g] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(r), v = "primary", x = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    () => p ? n : y,
    [p, n, y]
  ), w = (C) => {
    if (o)
      return;
    const k = C.target.checked;
    p || g(k), typeof t == "function" && t(k);
  }, S = {
    primary: {
      input: "bg-toggle-off checked:bg-toggle-on focus:ring focus:ring-toggle-on focus:ring-offset-2 border border-solid border-toggle-off-border checked:border-toggle-on-border shadow-toggleContainer focus:outline-none checked:focus:border-toggle-on-border focus:border-toggle-off-border",
      toggleDial: "bg-toggle-dial-background shadow-toggleDial"
    }
  }, A = {
    primary: {
      input: "group-hover/switch:bg-toggle-off-hover checked:group-hover/switch:bg-toggle-on-hover checked:group-hover/switch:border-toggle-on-border"
    }
  }, _ = {
    md: {
      container: "w-11 h-6",
      toggleDial: "size-4 peer-checked:translate-x-5"
    },
    sm: {
      container: "w-10 h-5",
      toggleDial: "size-3 peer-checked:translate-x-5"
    }
  }, O = {
    md: "group-hover/switch:size-5 group-focus-within/switch:size-5 group-focus-within/switch:left-0.5 group-hover/switch:left-0.5",
    sm: "group-hover/switch:size-4 group-focus-within/switch:size-4 group-focus-within/switch:left-0.5 group-hover/switch:left-0.5"
  }, P = {
    input: "bg-toggle-off-disabled disabled:border-transparent shadow-none disabled:cursor-not-allowed checked:disabled:bg-toggle-on-disabled",
    toggleDial: "peer-disabled:cursor-not-allowed"
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    VH,
    {
      label: a,
      switchId: m,
      disabled: o,
      size: d,
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
        "div",
        {
          className: K(
            "relative group/switch inline-block cursor-pointer rounded-full shrink-0",
            _[d].container,
            l
          ),
          children: [
            /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              "input",
              {
                ref: f,
                id: m,
                type: "checkbox",
                className: K(
                  "peer appearance-none absolute rounded-full cursor-pointer transition-colors duration-300 h-full w-full  before:content-[''] checked:before:content-[''] m-0 checked:[background-image:none]",
                  S[v].input,
                  o && P.input,
                  !o && A[v].input
                ),
                checked: x(),
                onChange: w,
                disabled: o,
                name: s,
                ...c
              }
            ),
            /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              "label",
              {
                htmlFor: m,
                className: K(
                  "peer/toggle-dial bg-white border rounded-full absolute cursor-pointer shadow-md before:content[''] before:transition-opacity before:opacity-0 hover:before:opacity-10 before:hidden border-none transition-all duration-300 top-2/4 left-1 -translate-y-2/4 before:w-10 before:h-10 before:rounded-full before:absolute before:top-2/4 before:left-2/4 before:-translate-y-2/4 before:-translate-x-2/4",
                  _[d].toggleDial,
                  S[v].toggleDial,
                  o && P.toggleDial,
                  !o && O[d]
                )
              }
            )
          ]
        }
      )
    }
  );
}, J$ = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(UH);
J$.displayName = "Switch";
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const HH = (e) => e.replace(/([a-z0-9])([A-Z])/g, "$1-$2").toLowerCase(), Q$ = (...e) => e.filter((t, n, r) => !!t && r.indexOf(t) === n).join(" ");
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
var KH = {
  xmlns: "http://www.w3.org/2000/svg",
  width: 24,
  height: 24,
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: 2,
  strokeLinecap: "round",
  strokeLinejoin: "round"
};
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const GH = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    color: e = "currentColor",
    size: t = 24,
    strokeWidth: n = 2,
    absoluteStrokeWidth: r,
    className: i = "",
    children: o,
    iconNode: a,
    ...s
  }, l) => (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(
    "svg",
    {
      ref: l,
      ...KH,
      width: t,
      height: t,
      stroke: e,
      strokeWidth: r ? Number(n) * 24 / Number(t) : n,
      className: Q$("lucide", i),
      ...s
    },
    [
      ...a.map(([c, f]) => (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(c, f)),
      ...Array.isArray(o) ? o : [o]
    ]
  )
);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const on = (e, t) => {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
    ({ className: r, ...i }, o) => (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(GH, {
      ref: o,
      iconNode: t,
      className: Q$(`lucide-${HH(e)}`, r),
      ...i
    })
  );
  return n.displayName = `${e}`, n;
};
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const sd = on("Check", [["path", { d: "M20 6 9 17l-5-5", key: "1gmf2c" }]]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Xw = on("ChevronDown", [
  ["path", { d: "m6 9 6 6 6-6", key: "qrunsl" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const eD = on("ChevronLeft", [
  ["path", { d: "m15 18-6-6 6-6", key: "1wnfg3" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Zw = on("ChevronRight", [
  ["path", { d: "m9 18 6-6-6-6", key: "mthhwq" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const YH = on("ChevronsUpDown", [
  ["path", { d: "m7 15 5 5 5-5", key: "1hf1tw" }],
  ["path", { d: "m7 9 5-5 5 5", key: "sgt6xg" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const qH = on("CloudUpload", [
  ["path", { d: "M4 14.899A7 7 0 1 1 15.71 8h1.79a4.5 4.5 0 0 1 2.5 8.242", key: "1pljnt" }],
  ["path", { d: "M12 12v9", key: "192myk" }],
  ["path", { d: "m16 16-4-4-4 4", key: "119tzi" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const XH = on("Ellipsis", [
  ["circle", { cx: "12", cy: "12", r: "1", key: "41hilf" }],
  ["circle", { cx: "19", cy: "12", r: "1", key: "1wjl8i" }],
  ["circle", { cx: "5", cy: "12", r: "1", key: "1pcz8c" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ZH = on("File", [
  ["path", { d: "M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z", key: "1rqfz7" }],
  ["path", { d: "M14 2v4a2 2 0 0 0 2 2h4", key: "tnqrlb" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const JH = on("ImageOff", [
  ["line", { x1: "2", x2: "22", y1: "2", y2: "22", key: "a6p6uj" }],
  ["path", { d: "M10.41 10.41a2 2 0 1 1-2.83-2.83", key: "1bzlo9" }],
  ["line", { x1: "13.5", x2: "6", y1: "13.5", y2: "21", key: "1q0aeu" }],
  ["line", { x1: "18", x2: "21", y1: "12", y2: "15", key: "5mozeu" }],
  [
    "path",
    {
      d: "M3.59 3.59A1.99 1.99 0 0 0 3 5v14a2 2 0 0 0 2 2h14c.55 0 1.052-.22 1.41-.59",
      key: "mmje98"
    }
  ],
  ["path", { d: "M21 15V5a2 2 0 0 0-2-2H9", key: "43el77" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const f0 = on("Info", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M12 16v-4", key: "1dtifu" }],
  ["path", { d: "M12 8h.01", key: "e9boi3" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const QH = on("LoaderCircle", [
  ["path", { d: "M21 12a9 9 0 1 1-6.219-8.56", key: "13zald" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const tD = on("Minus", [["path", { d: "M5 12h14", key: "1ays0h" }]]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const eK = on("PanelLeftClose", [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", key: "afitv7" }],
  ["path", { d: "M9 3v18", key: "fh3hqa" }],
  ["path", { d: "m16 15-3-3 3-3", key: "14y99z" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const tK = on("PanelLeftOpen", [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", key: "afitv7" }],
  ["path", { d: "M9 3v18", key: "fh3hqa" }],
  ["path", { d: "m14 9 3 3-3 3", key: "8010ee" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const nD = on("Plus", [
  ["path", { d: "M5 12h14", key: "1ays0h" }],
  ["path", { d: "M12 5v14", key: "s699le" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const rD = on("Search", [
  ["circle", { cx: "11", cy: "11", r: "8", key: "4ej97u" }],
  ["path", { d: "m21 21-4.3-4.3", key: "1qie3q" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const nK = on("Trash2", [
  ["path", { d: "M3 6h18", key: "d0wm0j" }],
  ["path", { d: "M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6", key: "4alrt4" }],
  ["path", { d: "M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2", key: "v07s0e" }],
  ["line", { x1: "10", x2: "10", y1: "11", y2: "17", key: "1uufr5" }],
  ["line", { x1: "14", x2: "14", y1: "11", y2: "17", key: "xtxkd" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const rK = on("Trash", [
  ["path", { d: "M3 6h18", key: "d0wm0j" }],
  ["path", { d: "M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6", key: "4alrt4" }],
  ["path", { d: "M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2", key: "v07s0e" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const iK = on("TriangleAlert", [
  [
    "path",
    {
      d: "m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3",
      key: "wmoenq"
    }
  ],
  ["path", { d: "M12 9v4", key: "juzpu7" }],
  ["path", { d: "M12 17h.01", key: "p32p05" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const vT = on("Upload", [
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["polyline", { points: "17 8 12 3 7 8", key: "t8dd8p" }],
  ["line", { x1: "12", x2: "12", y1: "3", y2: "15", key: "widbto" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const oK = on("User", [
  ["path", { d: "M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2", key: "975kel" }],
  ["circle", { cx: "12", cy: "7", r: "4", key: "17ys0d" }]
]);
/**
 * @license lucide-react v0.417.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const $a = on("X", [
  ["path", { d: "M18 6 6 18", key: "1bl5f8" }],
  ["path", { d: "m6 6 12 12", key: "d8bk6v" }]
]), aK = ({
  id: e,
  label: t,
  defaultChecked: n = !1,
  checked: r,
  onChange: i,
  indeterminate: o,
  disabled: a,
  size: s = "md",
  className: l,
  ...c
}, f) => {
  var O, P;
  const d = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `checkbox-${io()}`, [e]), p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => typeof r < "u",
    [r]
  ), [m, y] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(n || !1), g = "primary", v = {
    sm: {
      checkbox: "size-4 rounded gap-1",
      icon: "size-3",
      text: "text-sm",
      // text class for sm
      description: "text-sm",
      gap: "gap-0.5"
    },
    md: {
      checkbox: "size-5 rounded gap-1",
      icon: "size-4",
      text: "text-base",
      // text class for md
      description: "text-sm",
      gap: "gap-1"
    }
  }, x = {
    primary: {
      checkbox: "border-border-strong hover:border-border-interactive checked:border-border-interactive bg-white checked:bg-toggle-on checked:hover:bg-toggle-on-hover checked:hover:border-toggle-on-hover focus:ring-2 focus:ring-offset-2 focus:ring-focus",
      icon: "text-white"
    }
  }, w = {
    checkbox: "cursor-not-allowed disabled:bg-white checked:disabled:bg-white disabled:border-border-disabled checked:disabled:border-border-disabled",
    icon: "cursor-not-allowed peer-disabled:text-border-disabled"
  }, S = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    () => p ? r : m,
    [p, r, m]
  ), A = (C) => {
    if (a)
      return;
    const k = C.target.checked;
    p || y(k), typeof i == "function" && i(k);
  }, _ = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(t) ? t : !(t != null && t.heading) && !(t != null && t.description) ? null : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: v[s].gap, children: [
    (t == null ? void 0 : t.heading) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      to,
      {
        className: K(
          "text-text-primary font-medium leading-4 m-0",
          v[s].text,
          v[s].gap,
          a && "text-text-disabled"
        ),
        htmlFor: d,
        children: t == null ? void 0 : t.heading
      }
    ),
    (t == null ? void 0 : t.description) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      to,
      {
        tag: "p",
        className: K(
          "font-normal leading-5 m-0",
          v[s].description,
          a && "text-text-disabled"
        ),
        variant: "help",
        children: t == null ? void 0 : t.description
      }
    )
  ] }), [t, s, a]);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        "inline-flex items-center justify-center gap-2",
        !!t && "items-start",
        a && "cursor-not-allowed"
      ),
      children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
          "label",
          {
            className: K(
              "relative flex items-center justify-center rounded-full p-0.5",
              !a && "cursor-pointer"
            ),
            htmlFor: d,
            children: [
              /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                "input",
                {
                  ref: f,
                  id: d,
                  type: "checkbox",
                  className: K(
                    "peer relative cursor-pointer appearance-none transition-all m-0 before:content-[''] checked:before:content-[''] checked:before:hidden before:hidden !border-1.5 border-solid",
                    x[g].checkbox,
                    v[s].checkbox,
                    a && w.checkbox,
                    l
                  ),
                  checked: S(),
                  onChange: A,
                  disabled: a,
                  ...c
                }
              ),
              /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                "span",
                {
                  className: K(
                    "pointer-events-none inline-flex items-center absolute top-2/4 left-2/4 -translate-y-2/4 -translate-x-2/4 text-white opacity-0 transition-opacity peer-checked:opacity-100",
                    x[g].icon,
                    a && w.icon
                  ),
                  children: o ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(tD, { className: K((O = v[s]) == null ? void 0 : O.icon) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(sd, { className: K((P = v[s]) == null ? void 0 : P.icon) })
                }
              )
            ]
          }
        ),
        !!t && _()
      ]
    }
  );
}, Jw = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(aK);
Jw.displayName = "Checkbox";
const bT = {
  primary: {
    checkbox: "border-border-strong hover:border-border-interactive checked:border-border-interactive bg-white checked:bg-toggle-on checked:hover:bg-toggle-on-hover checked:hover:border-toggle-on-hover focus:ring-2 focus:ring-offset-2 focus:ring-focus",
    icon: "text-white"
  }
}, xT = {
  checkbox: "disabled:bg-white checked:disabled:bg-white disabled:border-border-disabled checked:disabled:border-border-disabled cursor-not-allowed",
  icon: "peer-disabled:text-border-disabled cursor-not-allowed"
}, sK = {
  sm: "text-sm leading-5",
  md: "text-base leading-6"
}, Uv = {
  sm: {
    checkbox: "size-4",
    icon: "size-1.5",
    info: "size-4"
  },
  md: {
    checkbox: "size-5",
    icon: "size-2",
    info: "size-5"
  }
}, wT = {
  sm: {
    switch: "mt-1",
    radio: "mt-0.5"
  },
  md: {
    switch: "mt-0.5",
    radio: "mt-px"
  }
}, lK = {
  xs: "py-1 px-1 text-sm gap-0.5 [&>svg]:size-4",
  sm: "py-1 px-1.5 text-base gap-1 [&>svg]:size-4",
  md: "py-2 px-2.5 text-base gap-1 [&>svg]:size-5",
  lg: "py-2.5 px-3 text-base gap-1 [&>svg]:size-6"
}, cK = "border-0 border-r border-border-subtle border-solid", uK = "bg-background-primary text-primary cursor-pointer flex items-center justify-center", fK = "hover:bg-button-tertiary-hover", dK = "focus:outline-none";
function Qm() {
  return typeof window < "u";
}
function za(e) {
  return iD(e) ? (e.nodeName || "").toLowerCase() : "#document";
}
function Or(e) {
  var t;
  return (e == null || (t = e.ownerDocument) == null ? void 0 : t.defaultView) || window;
}
function oo(e) {
  var t;
  return (t = (iD(e) ? e.ownerDocument : e.document) || window.document) == null ? void 0 : t.documentElement;
}
function iD(e) {
  return Qm() ? e instanceof Node || e instanceof Or(e).Node : !1;
}
function Ct(e) {
  return Qm() ? e instanceof Element || e instanceof Or(e).Element : !1;
}
function pn(e) {
  return Qm() ? e instanceof HTMLElement || e instanceof Or(e).HTMLElement : !1;
}
function d0(e) {
  return !Qm() || typeof ShadowRoot > "u" ? !1 : e instanceof ShadowRoot || e instanceof Or(e).ShadowRoot;
}
function ld(e) {
  const {
    overflow: t,
    overflowX: n,
    overflowY: r,
    display: i
  } = Hr(e);
  return /auto|scroll|overlay|hidden|clip/.test(t + r + n) && !["inline", "contents"].includes(i);
}
function hK(e) {
  return ["table", "td", "th"].includes(za(e));
}
function eg(e) {
  return [":popover-open", ":modal"].some((t) => {
    try {
      return e.matches(t);
    } catch {
      return !1;
    }
  });
}
function Qw(e) {
  const t = tg(), n = Ct(e) ? Hr(e) : e;
  return n.transform !== "none" || n.perspective !== "none" || (n.containerType ? n.containerType !== "normal" : !1) || !t && (n.backdropFilter ? n.backdropFilter !== "none" : !1) || !t && (n.filter ? n.filter !== "none" : !1) || ["transform", "perspective", "filter"].some((r) => (n.willChange || "").includes(r)) || ["paint", "layout", "strict", "content"].some((r) => (n.contain || "").includes(r));
}
function pK(e) {
  let t = Fo(e);
  for (; pn(t) && !Da(t); ) {
    if (Qw(t))
      return t;
    if (eg(t))
      return null;
    t = Fo(t);
  }
  return null;
}
function tg() {
  return typeof CSS > "u" || !CSS.supports ? !1 : CSS.supports("-webkit-backdrop-filter", "none");
}
function Da(e) {
  return ["html", "body", "#document"].includes(za(e));
}
function Hr(e) {
  return Or(e).getComputedStyle(e);
}
function ng(e) {
  return Ct(e) ? {
    scrollLeft: e.scrollLeft,
    scrollTop: e.scrollTop
  } : {
    scrollLeft: e.scrollX,
    scrollTop: e.scrollY
  };
}
function Fo(e) {
  if (za(e) === "html")
    return e;
  const t = (
    // Step into the shadow DOM of the parent of a slotted node.
    e.assignedSlot || // DOM Element detected.
    e.parentNode || // ShadowRoot detected.
    d0(e) && e.host || // Fallback.
    oo(e)
  );
  return d0(t) ? t.host : t;
}
function oD(e) {
  const t = Fo(e);
  return Da(t) ? e.ownerDocument ? e.ownerDocument.body : e.body : pn(t) && ld(t) ? t : oD(t);
}
function Ca(e, t, n) {
  var r;
  t === void 0 && (t = []), n === void 0 && (n = !0);
  const i = oD(e), o = i === ((r = e.ownerDocument) == null ? void 0 : r.body), a = Or(i);
  if (o) {
    const s = h0(a);
    return t.concat(a, a.visualViewport || [], ld(i) ? i : [], s && n ? Ca(s) : []);
  }
  return t.concat(i, Ca(i, [], n));
}
function h0(e) {
  return e.parent && Object.getPrototypeOf(e.parent) ? e.frameElement : null;
}
function Pi(e) {
  let t = e.activeElement;
  for (; ((n = t) == null || (n = n.shadowRoot) == null ? void 0 : n.activeElement) != null; ) {
    var n;
    t = t.shadowRoot.activeElement;
  }
  return t;
}
function hn(e, t) {
  if (!e || !t)
    return !1;
  const n = t.getRootNode == null ? void 0 : t.getRootNode();
  if (e.contains(t))
    return !0;
  if (n && d0(n)) {
    let r = t;
    for (; r; ) {
      if (e === r)
        return !0;
      r = r.parentNode || r.host;
    }
  }
  return !1;
}
function aD() {
  const e = navigator.userAgentData;
  return e != null && e.platform ? e.platform : navigator.platform;
}
function sD() {
  const e = navigator.userAgentData;
  return e && Array.isArray(e.brands) ? e.brands.map((t) => {
    let {
      brand: n,
      version: r
    } = t;
    return n + "/" + r;
  }).join(" ") : navigator.userAgent;
}
function lD(e) {
  return e.mozInputSource === 0 && e.isTrusted ? !0 : p0() && e.pointerType ? e.type === "click" && e.buttons === 1 : e.detail === 0 && !e.pointerType;
}
function e1(e) {
  return mK() ? !1 : !p0() && e.width === 0 && e.height === 0 || p0() && e.width === 1 && e.height === 1 && e.pressure === 0 && e.detail === 0 && e.pointerType === "mouse" || // iOS VoiceOver returns 0.333• for width/height.
  e.width < 1 && e.height < 1 && e.pressure === 0 && e.detail === 0 && e.pointerType === "touch";
}
function t1() {
  return /apple/i.test(navigator.vendor);
}
function p0() {
  const e = /android/i;
  return e.test(aD()) || e.test(sD());
}
function cD() {
  return aD().toLowerCase().startsWith("mac") && !navigator.maxTouchPoints;
}
function mK() {
  return sD().includes("jsdom/");
}
function uf(e, t) {
  const n = ["mouse", "pen"];
  return t || n.push("", void 0), n.includes(e);
}
function gK(e) {
  return "nativeEvent" in e;
}
function yK(e) {
  return e.matches("html,body");
}
function Kn(e) {
  return (e == null ? void 0 : e.ownerDocument) || document;
}
function Hv(e, t) {
  if (t == null)
    return !1;
  if ("composedPath" in e)
    return e.composedPath().includes(t);
  const n = e;
  return n.target != null && t.contains(n.target);
}
function Ao(e) {
  return "composedPath" in e ? e.composedPath()[0] : e.target;
}
const vK = "input:not([type='hidden']):not([disabled]),[contenteditable]:not([contenteditable='false']),textarea:not([disabled])";
function n1(e) {
  return pn(e) && e.matches(vK);
}
function Un(e) {
  e.preventDefault(), e.stopPropagation();
}
function m0(e) {
  return e ? e.getAttribute("role") === "combobox" && n1(e) : !1;
}
const Ia = Math.min, Br = Math.max, hp = Math.round, kl = Math.floor, Ki = (e) => ({
  x: e,
  y: e
}), bK = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
}, xK = {
  start: "end",
  end: "start"
};
function g0(e, t, n) {
  return Br(e, Ia(t, n));
}
function $c(e, t) {
  return typeof e == "function" ? e(t) : e;
}
function Ra(e) {
  return e.split("-")[0];
}
function Dc(e) {
  return e.split("-")[1];
}
function uD(e) {
  return e === "x" ? "y" : "x";
}
function r1(e) {
  return e === "y" ? "height" : "width";
}
function Is(e) {
  return ["top", "bottom"].includes(Ra(e)) ? "y" : "x";
}
function i1(e) {
  return uD(Is(e));
}
function wK(e, t, n) {
  n === void 0 && (n = !1);
  const r = Dc(e), i = i1(e), o = r1(i);
  let a = i === "x" ? r === (n ? "end" : "start") ? "right" : "left" : r === "start" ? "bottom" : "top";
  return t.reference[o] > t.floating[o] && (a = pp(a)), [a, pp(a)];
}
function _K(e) {
  const t = pp(e);
  return [y0(e), t, y0(t)];
}
function y0(e) {
  return e.replace(/start|end/g, (t) => xK[t]);
}
function SK(e, t, n) {
  const r = ["left", "right"], i = ["right", "left"], o = ["top", "bottom"], a = ["bottom", "top"];
  switch (e) {
    case "top":
    case "bottom":
      return n ? t ? i : r : t ? r : i;
    case "left":
    case "right":
      return t ? o : a;
    default:
      return [];
  }
}
function OK(e, t, n, r) {
  const i = Dc(e);
  let o = SK(Ra(e), n === "start", r);
  return i && (o = o.map((a) => a + "-" + i), t && (o = o.concat(o.map(y0)))), o;
}
function pp(e) {
  return e.replace(/left|right|bottom|top/g, (t) => bK[t]);
}
function AK(e) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...e
  };
}
function fD(e) {
  return typeof e != "number" ? AK(e) : {
    top: e,
    right: e,
    bottom: e,
    left: e
  };
}
function mp(e) {
  const {
    x: t,
    y: n,
    width: r,
    height: i
  } = e;
  return {
    width: r,
    height: i,
    top: n,
    left: t,
    right: t + r,
    bottom: n + i,
    x: t,
    y: n
  };
}
/*!
* tabbable 6.2.0
* @license MIT, https://github.com/focus-trap/tabbable/blob/master/LICENSE
*/
var TK = ["input:not([inert])", "select:not([inert])", "textarea:not([inert])", "a[href]:not([inert])", "button:not([inert])", "[tabindex]:not(slot):not([inert])", "audio[controls]:not([inert])", "video[controls]:not([inert])", '[contenteditable]:not([contenteditable="false"]):not([inert])', "details>summary:first-of-type:not([inert])", "details:not([inert])"], gp = /* @__PURE__ */ TK.join(","), dD = typeof Element > "u", Jl = dD ? function() {
} : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector, yp = !dD && Element.prototype.getRootNode ? function(e) {
  var t;
  return e == null || (t = e.getRootNode) === null || t === void 0 ? void 0 : t.call(e);
} : function(e) {
  return e == null ? void 0 : e.ownerDocument;
}, vp = function e(t, n) {
  var r;
  n === void 0 && (n = !0);
  var i = t == null || (r = t.getAttribute) === null || r === void 0 ? void 0 : r.call(t, "inert"), o = i === "" || i === "true", a = o || n && t && e(t.parentNode);
  return a;
}, PK = function(t) {
  var n, r = t == null || (n = t.getAttribute) === null || n === void 0 ? void 0 : n.call(t, "contenteditable");
  return r === "" || r === "true";
}, CK = function(t, n, r) {
  if (vp(t))
    return [];
  var i = Array.prototype.slice.apply(t.querySelectorAll(gp));
  return n && Jl.call(t, gp) && i.unshift(t), i = i.filter(r), i;
}, EK = function e(t, n, r) {
  for (var i = [], o = Array.from(t); o.length; ) {
    var a = o.shift();
    if (!vp(a, !1))
      if (a.tagName === "SLOT") {
        var s = a.assignedElements(), l = s.length ? s : a.children, c = e(l, !0, r);
        r.flatten ? i.push.apply(i, c) : i.push({
          scopeParent: a,
          candidates: c
        });
      } else {
        var f = Jl.call(a, gp);
        f && r.filter(a) && (n || !t.includes(a)) && i.push(a);
        var d = a.shadowRoot || // check for an undisclosed shadow
        typeof r.getShadowRoot == "function" && r.getShadowRoot(a), p = !vp(d, !1) && (!r.shadowRootFilter || r.shadowRootFilter(a));
        if (d && p) {
          var m = e(d === !0 ? a.children : d.children, !0, r);
          r.flatten ? i.push.apply(i, m) : i.push({
            scopeParent: a,
            candidates: m
          });
        } else
          o.unshift.apply(o, a.children);
      }
  }
  return i;
}, hD = function(t) {
  return !isNaN(parseInt(t.getAttribute("tabindex"), 10));
}, pD = function(t) {
  if (!t)
    throw new Error("No node provided");
  return t.tabIndex < 0 && (/^(AUDIO|VIDEO|DETAILS)$/.test(t.tagName) || PK(t)) && !hD(t) ? 0 : t.tabIndex;
}, kK = function(t, n) {
  var r = pD(t);
  return r < 0 && n && !hD(t) ? 0 : r;
}, MK = function(t, n) {
  return t.tabIndex === n.tabIndex ? t.documentOrder - n.documentOrder : t.tabIndex - n.tabIndex;
}, mD = function(t) {
  return t.tagName === "INPUT";
}, NK = function(t) {
  return mD(t) && t.type === "hidden";
}, $K = function(t) {
  var n = t.tagName === "DETAILS" && Array.prototype.slice.apply(t.children).some(function(r) {
    return r.tagName === "SUMMARY";
  });
  return n;
}, DK = function(t, n) {
  for (var r = 0; r < t.length; r++)
    if (t[r].checked && t[r].form === n)
      return t[r];
}, IK = function(t) {
  if (!t.name)
    return !0;
  var n = t.form || yp(t), r = function(s) {
    return n.querySelectorAll('input[type="radio"][name="' + s + '"]');
  }, i;
  if (typeof window < "u" && typeof window.CSS < "u" && typeof window.CSS.escape == "function")
    i = r(window.CSS.escape(t.name));
  else
    try {
      i = r(t.name);
    } catch (a) {
      return console.error("Looks like you have a radio button with a name attribute containing invalid CSS selector characters and need the CSS.escape polyfill: %s", a.message), !1;
    }
  var o = DK(i, t.form);
  return !o || o === t;
}, RK = function(t) {
  return mD(t) && t.type === "radio";
}, jK = function(t) {
  return RK(t) && !IK(t);
}, LK = function(t) {
  var n, r = t && yp(t), i = (n = r) === null || n === void 0 ? void 0 : n.host, o = !1;
  if (r && r !== t) {
    var a, s, l;
    for (o = !!((a = i) !== null && a !== void 0 && (s = a.ownerDocument) !== null && s !== void 0 && s.contains(i) || t != null && (l = t.ownerDocument) !== null && l !== void 0 && l.contains(t)); !o && i; ) {
      var c, f, d;
      r = yp(i), i = (c = r) === null || c === void 0 ? void 0 : c.host, o = !!((f = i) !== null && f !== void 0 && (d = f.ownerDocument) !== null && d !== void 0 && d.contains(i));
    }
  }
  return o;
}, _T = function(t) {
  var n = t.getBoundingClientRect(), r = n.width, i = n.height;
  return r === 0 && i === 0;
}, BK = function(t, n) {
  var r = n.displayCheck, i = n.getShadowRoot;
  if (getComputedStyle(t).visibility === "hidden")
    return !0;
  var o = Jl.call(t, "details>summary:first-of-type"), a = o ? t.parentElement : t;
  if (Jl.call(a, "details:not([open]) *"))
    return !0;
  if (!r || r === "full" || r === "legacy-full") {
    if (typeof i == "function") {
      for (var s = t; t; ) {
        var l = t.parentElement, c = yp(t);
        if (l && !l.shadowRoot && i(l) === !0)
          return _T(t);
        t.assignedSlot ? t = t.assignedSlot : !l && c !== t.ownerDocument ? t = c.host : t = l;
      }
      t = s;
    }
    if (LK(t))
      return !t.getClientRects().length;
    if (r !== "legacy-full")
      return !0;
  } else if (r === "non-zero-area")
    return _T(t);
  return !1;
}, FK = function(t) {
  if (/^(INPUT|BUTTON|SELECT|TEXTAREA)$/.test(t.tagName))
    for (var n = t.parentElement; n; ) {
      if (n.tagName === "FIELDSET" && n.disabled) {
        for (var r = 0; r < n.children.length; r++) {
          var i = n.children.item(r);
          if (i.tagName === "LEGEND")
            return Jl.call(n, "fieldset[disabled] *") ? !0 : !i.contains(t);
        }
        return !0;
      }
      n = n.parentElement;
    }
  return !1;
}, WK = function(t, n) {
  return !(n.disabled || // we must do an inert look up to filter out any elements inside an inert ancestor
  //  because we're limited in the type of selectors we can use in JSDom (see related
  //  note related to `candidateSelectors`)
  vp(n) || NK(n) || BK(n, t) || // For a details element with a summary, the summary element gets the focus
  $K(n) || FK(n));
}, v0 = function(t, n) {
  return !(jK(n) || pD(n) < 0 || !WK(t, n));
}, zK = function(t) {
  var n = parseInt(t.getAttribute("tabindex"), 10);
  return !!(isNaN(n) || n >= 0);
}, VK = function e(t) {
  var n = [], r = [];
  return t.forEach(function(i, o) {
    var a = !!i.scopeParent, s = a ? i.scopeParent : i, l = kK(s, a), c = a ? e(i.candidates) : s;
    l === 0 ? a ? n.push.apply(n, c) : n.push(s) : r.push({
      documentOrder: o,
      tabIndex: l,
      item: i,
      isScope: a,
      content: c
    });
  }), r.sort(MK).reduce(function(i, o) {
    return o.isScope ? i.push.apply(i, o.content) : i.push(o.content), i;
  }, []).concat(n);
}, rg = function(t, n) {
  n = n || {};
  var r;
  return n.getShadowRoot ? r = EK([t], n.includeContainer, {
    filter: v0.bind(null, n),
    flatten: !1,
    getShadowRoot: n.getShadowRoot,
    shadowRootFilter: zK
  }) : r = CK(t, n.includeContainer, v0.bind(null, n)), VK(r);
}, UK = function(t, n) {
  if (n = n || {}, !t)
    throw new Error("No node provided");
  return Jl.call(t, gp) === !1 ? !1 : v0(n, t);
};
function ST(e, t, n) {
  let {
    reference: r,
    floating: i
  } = e;
  const o = Is(t), a = i1(t), s = r1(a), l = Ra(t), c = o === "y", f = r.x + r.width / 2 - i.width / 2, d = r.y + r.height / 2 - i.height / 2, p = r[s] / 2 - i[s] / 2;
  let m;
  switch (l) {
    case "top":
      m = {
        x: f,
        y: r.y - i.height
      };
      break;
    case "bottom":
      m = {
        x: f,
        y: r.y + r.height
      };
      break;
    case "right":
      m = {
        x: r.x + r.width,
        y: d
      };
      break;
    case "left":
      m = {
        x: r.x - i.width,
        y: d
      };
      break;
    default:
      m = {
        x: r.x,
        y: r.y
      };
  }
  switch (Dc(t)) {
    case "start":
      m[a] -= p * (n && c ? -1 : 1);
      break;
    case "end":
      m[a] += p * (n && c ? -1 : 1);
      break;
  }
  return m;
}
const HK = async (e, t, n) => {
  const {
    placement: r = "bottom",
    strategy: i = "absolute",
    middleware: o = [],
    platform: a
  } = n, s = o.filter(Boolean), l = await (a.isRTL == null ? void 0 : a.isRTL(t));
  let c = await a.getElementRects({
    reference: e,
    floating: t,
    strategy: i
  }), {
    x: f,
    y: d
  } = ST(c, r, l), p = r, m = {}, y = 0;
  for (let g = 0; g < s.length; g++) {
    const {
      name: v,
      fn: x
    } = s[g], {
      x: w,
      y: S,
      data: A,
      reset: _
    } = await x({
      x: f,
      y: d,
      initialPlacement: r,
      placement: p,
      strategy: i,
      middlewareData: m,
      rects: c,
      platform: a,
      elements: {
        reference: e,
        floating: t
      }
    });
    f = w ?? f, d = S ?? d, m = {
      ...m,
      [v]: {
        ...m[v],
        ...A
      }
    }, _ && y <= 50 && (y++, typeof _ == "object" && (_.placement && (p = _.placement), _.rects && (c = _.rects === !0 ? await a.getElementRects({
      reference: e,
      floating: t,
      strategy: i
    }) : _.rects), {
      x: f,
      y: d
    } = ST(c, p, l)), g = -1);
  }
  return {
    x: f,
    y: d,
    placement: p,
    strategy: i,
    middlewareData: m
  };
};
async function o1(e, t) {
  var n;
  t === void 0 && (t = {});
  const {
    x: r,
    y: i,
    platform: o,
    rects: a,
    elements: s,
    strategy: l
  } = e, {
    boundary: c = "clippingAncestors",
    rootBoundary: f = "viewport",
    elementContext: d = "floating",
    altBoundary: p = !1,
    padding: m = 0
  } = $c(t, e), y = fD(m), v = s[p ? d === "floating" ? "reference" : "floating" : d], x = mp(await o.getClippingRect({
    element: (n = await (o.isElement == null ? void 0 : o.isElement(v))) == null || n ? v : v.contextElement || await (o.getDocumentElement == null ? void 0 : o.getDocumentElement(s.floating)),
    boundary: c,
    rootBoundary: f,
    strategy: l
  })), w = d === "floating" ? {
    x: r,
    y: i,
    width: a.floating.width,
    height: a.floating.height
  } : a.reference, S = await (o.getOffsetParent == null ? void 0 : o.getOffsetParent(s.floating)), A = await (o.isElement == null ? void 0 : o.isElement(S)) ? await (o.getScale == null ? void 0 : o.getScale(S)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  }, _ = mp(o.convertOffsetParentRelativeRectToViewportRelativeRect ? await o.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements: s,
    rect: w,
    offsetParent: S,
    strategy: l
  }) : w);
  return {
    top: (x.top - _.top + y.top) / A.y,
    bottom: (_.bottom - x.bottom + y.bottom) / A.y,
    left: (x.left - _.left + y.left) / A.x,
    right: (_.right - x.right + y.right) / A.x
  };
}
const KK = (e) => ({
  name: "arrow",
  options: e,
  async fn(t) {
    const {
      x: n,
      y: r,
      placement: i,
      rects: o,
      platform: a,
      elements: s,
      middlewareData: l
    } = t, {
      element: c,
      padding: f = 0
    } = $c(e, t) || {};
    if (c == null)
      return {};
    const d = fD(f), p = {
      x: n,
      y: r
    }, m = i1(i), y = r1(m), g = await a.getDimensions(c), v = m === "y", x = v ? "top" : "left", w = v ? "bottom" : "right", S = v ? "clientHeight" : "clientWidth", A = o.reference[y] + o.reference[m] - p[m] - o.floating[y], _ = p[m] - o.reference[m], O = await (a.getOffsetParent == null ? void 0 : a.getOffsetParent(c));
    let P = O ? O[S] : 0;
    (!P || !await (a.isElement == null ? void 0 : a.isElement(O))) && (P = s.floating[S] || o.floating[y]);
    const C = A / 2 - _ / 2, k = P / 2 - g[y] / 2 - 1, I = Ia(d[x], k), $ = Ia(d[w], k), N = I, D = P - g[y] - $, j = P / 2 - g[y] / 2 + C, F = g0(N, j, D), W = !l.arrow && Dc(i) != null && j !== F && o.reference[y] / 2 - (j < N ? I : $) - g[y] / 2 < 0, z = W ? j < N ? j - N : j - D : 0;
    return {
      [m]: p[m] + z,
      data: {
        [m]: F,
        centerOffset: j - F - z,
        ...W && {
          alignmentOffset: z
        }
      },
      reset: W
    };
  }
}), GK = function(e) {
  return e === void 0 && (e = {}), {
    name: "flip",
    options: e,
    async fn(t) {
      var n, r;
      const {
        placement: i,
        middlewareData: o,
        rects: a,
        initialPlacement: s,
        platform: l,
        elements: c
      } = t, {
        mainAxis: f = !0,
        crossAxis: d = !0,
        fallbackPlacements: p,
        fallbackStrategy: m = "bestFit",
        fallbackAxisSideDirection: y = "none",
        flipAlignment: g = !0,
        ...v
      } = $c(e, t);
      if ((n = o.arrow) != null && n.alignmentOffset)
        return {};
      const x = Ra(i), w = Is(s), S = Ra(s) === s, A = await (l.isRTL == null ? void 0 : l.isRTL(c.floating)), _ = p || (S || !g ? [pp(s)] : _K(s)), O = y !== "none";
      !p && O && _.push(...OK(s, g, y, A));
      const P = [s, ..._], C = await o1(t, v), k = [];
      let I = ((r = o.flip) == null ? void 0 : r.overflows) || [];
      if (f && k.push(C[x]), d) {
        const j = wK(i, a, A);
        k.push(C[j[0]], C[j[1]]);
      }
      if (I = [...I, {
        placement: i,
        overflows: k
      }], !k.every((j) => j <= 0)) {
        var $, N;
        const j = ((($ = o.flip) == null ? void 0 : $.index) || 0) + 1, F = P[j];
        if (F)
          return {
            data: {
              index: j,
              overflows: I
            },
            reset: {
              placement: F
            }
          };
        let W = (N = I.filter((z) => z.overflows[0] <= 0).sort((z, H) => z.overflows[1] - H.overflows[1])[0]) == null ? void 0 : N.placement;
        if (!W)
          switch (m) {
            case "bestFit": {
              var D;
              const z = (D = I.filter((H) => {
                if (O) {
                  const U = Is(H.placement);
                  return U === w || // Create a bias to the `y` side axis due to horizontal
                  // reading directions favoring greater width.
                  U === "y";
                }
                return !0;
              }).map((H) => [H.placement, H.overflows.filter((U) => U > 0).reduce((U, V) => U + V, 0)]).sort((H, U) => H[1] - U[1])[0]) == null ? void 0 : D[0];
              z && (W = z);
              break;
            }
            case "initialPlacement":
              W = s;
              break;
          }
        if (i !== W)
          return {
            reset: {
              placement: W
            }
          };
      }
      return {};
    }
  };
};
async function YK(e, t) {
  const {
    placement: n,
    platform: r,
    elements: i
  } = e, o = await (r.isRTL == null ? void 0 : r.isRTL(i.floating)), a = Ra(n), s = Dc(n), l = Is(n) === "y", c = ["left", "top"].includes(a) ? -1 : 1, f = o && l ? -1 : 1, d = $c(t, e);
  let {
    mainAxis: p,
    crossAxis: m,
    alignmentAxis: y
  } = typeof d == "number" ? {
    mainAxis: d,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: d.mainAxis || 0,
    crossAxis: d.crossAxis || 0,
    alignmentAxis: d.alignmentAxis
  };
  return s && typeof y == "number" && (m = s === "end" ? y * -1 : y), l ? {
    x: m * f,
    y: p * c
  } : {
    x: p * c,
    y: m * f
  };
}
const qK = function(e) {
  return e === void 0 && (e = 0), {
    name: "offset",
    options: e,
    async fn(t) {
      var n, r;
      const {
        x: i,
        y: o,
        placement: a,
        middlewareData: s
      } = t, l = await YK(t, e);
      return a === ((n = s.offset) == null ? void 0 : n.placement) && (r = s.arrow) != null && r.alignmentOffset ? {} : {
        x: i + l.x,
        y: o + l.y,
        data: {
          ...l,
          placement: a
        }
      };
    }
  };
}, XK = function(e) {
  return e === void 0 && (e = {}), {
    name: "shift",
    options: e,
    async fn(t) {
      const {
        x: n,
        y: r,
        placement: i
      } = t, {
        mainAxis: o = !0,
        crossAxis: a = !1,
        limiter: s = {
          fn: (v) => {
            let {
              x,
              y: w
            } = v;
            return {
              x,
              y: w
            };
          }
        },
        ...l
      } = $c(e, t), c = {
        x: n,
        y: r
      }, f = await o1(t, l), d = Is(Ra(i)), p = uD(d);
      let m = c[p], y = c[d];
      if (o) {
        const v = p === "y" ? "top" : "left", x = p === "y" ? "bottom" : "right", w = m + f[v], S = m - f[x];
        m = g0(w, m, S);
      }
      if (a) {
        const v = d === "y" ? "top" : "left", x = d === "y" ? "bottom" : "right", w = y + f[v], S = y - f[x];
        y = g0(w, y, S);
      }
      const g = s.fn({
        ...t,
        [p]: m,
        [d]: y
      });
      return {
        ...g,
        data: {
          x: g.x - n,
          y: g.y - r,
          enabled: {
            [p]: o,
            [d]: a
          }
        }
      };
    }
  };
}, ZK = function(e) {
  return e === void 0 && (e = {}), {
    name: "size",
    options: e,
    async fn(t) {
      var n, r;
      const {
        placement: i,
        rects: o,
        platform: a,
        elements: s
      } = t, {
        apply: l = () => {
        },
        ...c
      } = $c(e, t), f = await o1(t, c), d = Ra(i), p = Dc(i), m = Is(i) === "y", {
        width: y,
        height: g
      } = o.floating;
      let v, x;
      d === "top" || d === "bottom" ? (v = d, x = p === (await (a.isRTL == null ? void 0 : a.isRTL(s.floating)) ? "start" : "end") ? "left" : "right") : (x = d, v = p === "end" ? "top" : "bottom");
      const w = g - f.top - f.bottom, S = y - f.left - f.right, A = Ia(g - f[v], w), _ = Ia(y - f[x], S), O = !t.middlewareData.shift;
      let P = A, C = _;
      if ((n = t.middlewareData.shift) != null && n.enabled.x && (C = S), (r = t.middlewareData.shift) != null && r.enabled.y && (P = w), O && !p) {
        const I = Br(f.left, 0), $ = Br(f.right, 0), N = Br(f.top, 0), D = Br(f.bottom, 0);
        m ? C = y - 2 * (I !== 0 || $ !== 0 ? I + $ : Br(f.left, f.right)) : P = g - 2 * (N !== 0 || D !== 0 ? N + D : Br(f.top, f.bottom));
      }
      await l({
        ...t,
        availableWidth: C,
        availableHeight: P
      });
      const k = await a.getDimensions(s.floating);
      return y !== k.width || g !== k.height ? {
        reset: {
          rects: !0
        }
      } : {};
    }
  };
};
function gD(e) {
  const t = Hr(e);
  let n = parseFloat(t.width) || 0, r = parseFloat(t.height) || 0;
  const i = pn(e), o = i ? e.offsetWidth : n, a = i ? e.offsetHeight : r, s = hp(n) !== o || hp(r) !== a;
  return s && (n = o, r = a), {
    width: n,
    height: r,
    $: s
  };
}
function a1(e) {
  return Ct(e) ? e : e.contextElement;
}
function Ul(e) {
  const t = a1(e);
  if (!pn(t))
    return Ki(1);
  const n = t.getBoundingClientRect(), {
    width: r,
    height: i,
    $: o
  } = gD(t);
  let a = (o ? hp(n.width) : n.width) / r, s = (o ? hp(n.height) : n.height) / i;
  return (!a || !Number.isFinite(a)) && (a = 1), (!s || !Number.isFinite(s)) && (s = 1), {
    x: a,
    y: s
  };
}
const JK = /* @__PURE__ */ Ki(0);
function yD(e) {
  const t = Or(e);
  return !tg() || !t.visualViewport ? JK : {
    x: t.visualViewport.offsetLeft,
    y: t.visualViewport.offsetTop
  };
}
function QK(e, t, n) {
  return t === void 0 && (t = !1), !n || t && n !== Or(e) ? !1 : t;
}
function Rs(e, t, n, r) {
  t === void 0 && (t = !1), n === void 0 && (n = !1);
  const i = e.getBoundingClientRect(), o = a1(e);
  let a = Ki(1);
  t && (r ? Ct(r) && (a = Ul(r)) : a = Ul(e));
  const s = QK(o, n, r) ? yD(o) : Ki(0);
  let l = (i.left + s.x) / a.x, c = (i.top + s.y) / a.y, f = i.width / a.x, d = i.height / a.y;
  if (o) {
    const p = Or(o), m = r && Ct(r) ? Or(r) : r;
    let y = p, g = h0(y);
    for (; g && r && m !== y; ) {
      const v = Ul(g), x = g.getBoundingClientRect(), w = Hr(g), S = x.left + (g.clientLeft + parseFloat(w.paddingLeft)) * v.x, A = x.top + (g.clientTop + parseFloat(w.paddingTop)) * v.y;
      l *= v.x, c *= v.y, f *= v.x, d *= v.y, l += S, c += A, y = Or(g), g = h0(y);
    }
  }
  return mp({
    width: f,
    height: d,
    x: l,
    y: c
  });
}
function s1(e, t) {
  const n = ng(e).scrollLeft;
  return t ? t.left + n : Rs(oo(e)).left + n;
}
function vD(e, t, n) {
  n === void 0 && (n = !1);
  const r = e.getBoundingClientRect(), i = r.left + t.scrollLeft - (n ? 0 : (
    // RTL <body> scrollbar.
    s1(e, r)
  )), o = r.top + t.scrollTop;
  return {
    x: i,
    y: o
  };
}
function eG(e) {
  let {
    elements: t,
    rect: n,
    offsetParent: r,
    strategy: i
  } = e;
  const o = i === "fixed", a = oo(r), s = t ? eg(t.floating) : !1;
  if (r === a || s && o)
    return n;
  let l = {
    scrollLeft: 0,
    scrollTop: 0
  }, c = Ki(1);
  const f = Ki(0), d = pn(r);
  if ((d || !d && !o) && ((za(r) !== "body" || ld(a)) && (l = ng(r)), pn(r))) {
    const m = Rs(r);
    c = Ul(r), f.x = m.x + r.clientLeft, f.y = m.y + r.clientTop;
  }
  const p = a && !d && !o ? vD(a, l, !0) : Ki(0);
  return {
    width: n.width * c.x,
    height: n.height * c.y,
    x: n.x * c.x - l.scrollLeft * c.x + f.x + p.x,
    y: n.y * c.y - l.scrollTop * c.y + f.y + p.y
  };
}
function tG(e) {
  return Array.from(e.getClientRects());
}
function nG(e) {
  const t = oo(e), n = ng(e), r = e.ownerDocument.body, i = Br(t.scrollWidth, t.clientWidth, r.scrollWidth, r.clientWidth), o = Br(t.scrollHeight, t.clientHeight, r.scrollHeight, r.clientHeight);
  let a = -n.scrollLeft + s1(e);
  const s = -n.scrollTop;
  return Hr(r).direction === "rtl" && (a += Br(t.clientWidth, r.clientWidth) - i), {
    width: i,
    height: o,
    x: a,
    y: s
  };
}
function rG(e, t) {
  const n = Or(e), r = oo(e), i = n.visualViewport;
  let o = r.clientWidth, a = r.clientHeight, s = 0, l = 0;
  if (i) {
    o = i.width, a = i.height;
    const c = tg();
    (!c || c && t === "fixed") && (s = i.offsetLeft, l = i.offsetTop);
  }
  return {
    width: o,
    height: a,
    x: s,
    y: l
  };
}
function iG(e, t) {
  const n = Rs(e, !0, t === "fixed"), r = n.top + e.clientTop, i = n.left + e.clientLeft, o = pn(e) ? Ul(e) : Ki(1), a = e.clientWidth * o.x, s = e.clientHeight * o.y, l = i * o.x, c = r * o.y;
  return {
    width: a,
    height: s,
    x: l,
    y: c
  };
}
function OT(e, t, n) {
  let r;
  if (t === "viewport")
    r = rG(e, n);
  else if (t === "document")
    r = nG(oo(e));
  else if (Ct(t))
    r = iG(t, n);
  else {
    const i = yD(e);
    r = {
      x: t.x - i.x,
      y: t.y - i.y,
      width: t.width,
      height: t.height
    };
  }
  return mp(r);
}
function bD(e, t) {
  const n = Fo(e);
  return n === t || !Ct(n) || Da(n) ? !1 : Hr(n).position === "fixed" || bD(n, t);
}
function oG(e, t) {
  const n = t.get(e);
  if (n)
    return n;
  let r = Ca(e, [], !1).filter((s) => Ct(s) && za(s) !== "body"), i = null;
  const o = Hr(e).position === "fixed";
  let a = o ? Fo(e) : e;
  for (; Ct(a) && !Da(a); ) {
    const s = Hr(a), l = Qw(a);
    !l && s.position === "fixed" && (i = null), (o ? !l && !i : !l && s.position === "static" && !!i && ["absolute", "fixed"].includes(i.position) || ld(a) && !l && bD(e, a)) ? r = r.filter((f) => f !== a) : i = s, a = Fo(a);
  }
  return t.set(e, r), r;
}
function aG(e) {
  let {
    element: t,
    boundary: n,
    rootBoundary: r,
    strategy: i
  } = e;
  const a = [...n === "clippingAncestors" ? eg(t) ? [] : oG(t, this._c) : [].concat(n), r], s = a[0], l = a.reduce((c, f) => {
    const d = OT(t, f, i);
    return c.top = Br(d.top, c.top), c.right = Ia(d.right, c.right), c.bottom = Ia(d.bottom, c.bottom), c.left = Br(d.left, c.left), c;
  }, OT(t, s, i));
  return {
    width: l.right - l.left,
    height: l.bottom - l.top,
    x: l.left,
    y: l.top
  };
}
function sG(e) {
  const {
    width: t,
    height: n
  } = gD(e);
  return {
    width: t,
    height: n
  };
}
function lG(e, t, n) {
  const r = pn(t), i = oo(t), o = n === "fixed", a = Rs(e, !0, o, t);
  let s = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const l = Ki(0);
  if (r || !r && !o)
    if ((za(t) !== "body" || ld(i)) && (s = ng(t)), r) {
      const p = Rs(t, !0, o, t);
      l.x = p.x + t.clientLeft, l.y = p.y + t.clientTop;
    } else i && (l.x = s1(i));
  const c = i && !r && !o ? vD(i, s) : Ki(0), f = a.left + s.scrollLeft - l.x - c.x, d = a.top + s.scrollTop - l.y - c.y;
  return {
    x: f,
    y: d,
    width: a.width,
    height: a.height
  };
}
function Kv(e) {
  return Hr(e).position === "static";
}
function AT(e, t) {
  if (!pn(e) || Hr(e).position === "fixed")
    return null;
  if (t)
    return t(e);
  let n = e.offsetParent;
  return oo(e) === n && (n = n.ownerDocument.body), n;
}
function xD(e, t) {
  const n = Or(e);
  if (eg(e))
    return n;
  if (!pn(e)) {
    let i = Fo(e);
    for (; i && !Da(i); ) {
      if (Ct(i) && !Kv(i))
        return i;
      i = Fo(i);
    }
    return n;
  }
  let r = AT(e, t);
  for (; r && hK(r) && Kv(r); )
    r = AT(r, t);
  return r && Da(r) && Kv(r) && !Qw(r) ? n : r || pK(e) || n;
}
const cG = async function(e) {
  const t = this.getOffsetParent || xD, n = this.getDimensions, r = await n(e.floating);
  return {
    reference: lG(e.reference, await t(e.floating), e.strategy),
    floating: {
      x: 0,
      y: 0,
      width: r.width,
      height: r.height
    }
  };
};
function uG(e) {
  return Hr(e).direction === "rtl";
}
const fG = {
  convertOffsetParentRelativeRectToViewportRelativeRect: eG,
  getDocumentElement: oo,
  getClippingRect: aG,
  getOffsetParent: xD,
  getElementRects: cG,
  getClientRects: tG,
  getDimensions: sG,
  getScale: Ul,
  isElement: Ct,
  isRTL: uG
};
function dG(e, t) {
  let n = null, r;
  const i = oo(e);
  function o() {
    var s;
    clearTimeout(r), (s = n) == null || s.disconnect(), n = null;
  }
  function a(s, l) {
    s === void 0 && (s = !1), l === void 0 && (l = 1), o();
    const {
      left: c,
      top: f,
      width: d,
      height: p
    } = e.getBoundingClientRect();
    if (s || t(), !d || !p)
      return;
    const m = kl(f), y = kl(i.clientWidth - (c + d)), g = kl(i.clientHeight - (f + p)), v = kl(c), w = {
      rootMargin: -m + "px " + -y + "px " + -g + "px " + -v + "px",
      threshold: Br(0, Ia(1, l)) || 1
    };
    let S = !0;
    function A(_) {
      const O = _[0].intersectionRatio;
      if (O !== l) {
        if (!S)
          return a();
        O ? a(!1, O) : r = setTimeout(() => {
          a(!1, 1e-7);
        }, 1e3);
      }
      S = !1;
    }
    try {
      n = new IntersectionObserver(A, {
        ...w,
        // Handle <iframe>s
        root: i.ownerDocument
      });
    } catch {
      n = new IntersectionObserver(A, w);
    }
    n.observe(e);
  }
  return a(!0), o;
}
function ig(e, t, n, r) {
  r === void 0 && (r = {});
  const {
    ancestorScroll: i = !0,
    ancestorResize: o = !0,
    elementResize: a = typeof ResizeObserver == "function",
    layoutShift: s = typeof IntersectionObserver == "function",
    animationFrame: l = !1
  } = r, c = a1(e), f = i || o ? [...c ? Ca(c) : [], ...Ca(t)] : [];
  f.forEach((x) => {
    i && x.addEventListener("scroll", n, {
      passive: !0
    }), o && x.addEventListener("resize", n);
  });
  const d = c && s ? dG(c, n) : null;
  let p = -1, m = null;
  a && (m = new ResizeObserver((x) => {
    let [w] = x;
    w && w.target === c && m && (m.unobserve(t), cancelAnimationFrame(p), p = requestAnimationFrame(() => {
      var S;
      (S = m) == null || S.observe(t);
    })), n();
  }), c && !l && m.observe(c), m.observe(t));
  let y, g = l ? Rs(e) : null;
  l && v();
  function v() {
    const x = Rs(e);
    g && (x.x !== g.x || x.y !== g.y || x.width !== g.width || x.height !== g.height) && n(), g = x, y = requestAnimationFrame(v);
  }
  return n(), () => {
    var x;
    f.forEach((w) => {
      i && w.removeEventListener("scroll", n), o && w.removeEventListener("resize", n);
    }), d == null || d(), (x = m) == null || x.disconnect(), m = null, l && cancelAnimationFrame(y);
  };
}
const hG = qK, pG = XK, mG = GK, gG = ZK, TT = KK, yG = (e, t, n) => {
  const r = /* @__PURE__ */ new Map(), i = {
    platform: fG,
    ...n
  }, o = {
    ...i.platform,
    _c: r
  };
  return HK(e, t, {
    ...i,
    platform: o
  });
};
var rp = typeof document < "u" ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function bp(e, t) {
  if (e === t)
    return !0;
  if (typeof e != typeof t)
    return !1;
  if (typeof e == "function" && e.toString() === t.toString())
    return !0;
  let n, r, i;
  if (e && t && typeof e == "object") {
    if (Array.isArray(e)) {
      if (n = e.length, n !== t.length) return !1;
      for (r = n; r-- !== 0; )
        if (!bp(e[r], t[r]))
          return !1;
      return !0;
    }
    if (i = Object.keys(e), n = i.length, n !== Object.keys(t).length)
      return !1;
    for (r = n; r-- !== 0; )
      if (!{}.hasOwnProperty.call(t, i[r]))
        return !1;
    for (r = n; r-- !== 0; ) {
      const o = i[r];
      if (!(o === "_owner" && e.$$typeof) && !bp(e[o], t[o]))
        return !1;
    }
    return !0;
  }
  return e !== e && t !== t;
}
function wD(e) {
  return typeof window > "u" ? 1 : (e.ownerDocument.defaultView || window).devicePixelRatio || 1;
}
function PT(e, t) {
  const n = wD(e);
  return Math.round(t * n) / n;
}
function Gv(e) {
  const t = react__WEBPACK_IMPORTED_MODULE_1__.useRef(e);
  return rp(() => {
    t.current = e;
  }), t;
}
function vG(e) {
  e === void 0 && (e = {});
  const {
    placement: t = "bottom",
    strategy: n = "absolute",
    middleware: r = [],
    platform: i,
    elements: {
      reference: o,
      floating: a
    } = {},
    transform: s = !0,
    whileElementsMounted: l,
    open: c
  } = e, [f, d] = react__WEBPACK_IMPORTED_MODULE_1__.useState({
    x: 0,
    y: 0,
    strategy: n,
    placement: t,
    middlewareData: {},
    isPositioned: !1
  }), [p, m] = react__WEBPACK_IMPORTED_MODULE_1__.useState(r);
  bp(p, r) || m(r);
  const [y, g] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), [v, x] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), w = react__WEBPACK_IMPORTED_MODULE_1__.useCallback((H) => {
    H !== O.current && (O.current = H, g(H));
  }, []), S = react__WEBPACK_IMPORTED_MODULE_1__.useCallback((H) => {
    H !== P.current && (P.current = H, x(H));
  }, []), A = o || y, _ = a || v, O = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), P = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), C = react__WEBPACK_IMPORTED_MODULE_1__.useRef(f), k = l != null, I = Gv(l), $ = Gv(i), N = Gv(c), D = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(() => {
    if (!O.current || !P.current)
      return;
    const H = {
      placement: t,
      strategy: n,
      middleware: p
    };
    $.current && (H.platform = $.current), yG(O.current, P.current, H).then((U) => {
      const V = {
        ...U,
        // The floating element's position may be recomputed while it's closed
        // but still mounted (such as when transitioning out). To ensure
        // `isPositioned` will be `false` initially on the next open, avoid
        // setting it to `true` when `open === false` (must be specified).
        isPositioned: N.current !== !1
      };
      j.current && !bp(C.current, V) && (C.current = V, react_dom__WEBPACK_IMPORTED_MODULE_2__.flushSync(() => {
        d(V);
      }));
    });
  }, [p, t, n, $, N]);
  rp(() => {
    c === !1 && C.current.isPositioned && (C.current.isPositioned = !1, d((H) => ({
      ...H,
      isPositioned: !1
    })));
  }, [c]);
  const j = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1);
  rp(() => (j.current = !0, () => {
    j.current = !1;
  }), []), rp(() => {
    if (A && (O.current = A), _ && (P.current = _), A && _) {
      if (I.current)
        return I.current(A, _, D);
      D();
    }
  }, [A, _, D, I, k]);
  const F = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    reference: O,
    floating: P,
    setReference: w,
    setFloating: S
  }), [w, S]), W = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    reference: A,
    floating: _
  }), [A, _]), z = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => {
    const H = {
      position: n,
      left: 0,
      top: 0
    };
    if (!W.floating)
      return H;
    const U = PT(W.floating, f.x), V = PT(W.floating, f.y);
    return s ? {
      ...H,
      transform: "translate(" + U + "px, " + V + "px)",
      ...wD(W.floating) >= 1.5 && {
        willChange: "transform"
      }
    } : {
      position: n,
      left: U,
      top: V
    };
  }, [n, s, W.floating, f.x, f.y]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    ...f,
    update: D,
    refs: F,
    elements: W,
    floatingStyles: z
  }), [f, D, F, W, z]);
}
const bG = (e) => {
  function t(n) {
    return {}.hasOwnProperty.call(n, "current");
  }
  return {
    name: "arrow",
    options: e,
    fn(n) {
      const {
        element: r,
        padding: i
      } = typeof e == "function" ? e(n) : e;
      return r && t(r) ? r.current != null ? TT({
        element: r.current,
        padding: i
      }).fn(n) : {} : r ? TT({
        element: r,
        padding: i
      }).fn(n) : {};
    }
  };
}, og = (e, t) => ({
  ...hG(e),
  options: [e, t]
}), _D = (e, t) => ({
  ...pG(e),
  options: [e, t]
}), ag = (e, t) => ({
  ...mG(e),
  options: [e, t]
}), SD = (e, t) => ({
  ...gG(e),
  options: [e, t]
}), xG = (e, t) => ({
  ...bG(e),
  options: [e, t]
}), OD = {
  .../*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_1___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_1___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_1__, 2)))
}, wG = OD.useInsertionEffect, _G = wG || ((e) => e());
function Nn(e) {
  const t = react__WEBPACK_IMPORTED_MODULE_1__.useRef(() => {
    if (true)
      throw new Error("Cannot call an event handler while rendering.");
  });
  return _G(() => {
    t.current = e;
  }), react__WEBPACK_IMPORTED_MODULE_1__.useCallback(function() {
    for (var n = arguments.length, r = new Array(n), i = 0; i < n; i++)
      r[i] = arguments[i];
    return t.current == null ? void 0 : t.current(...r);
  }, []);
}
const l1 = "ArrowUp", cd = "ArrowDown", Ea = "ArrowLeft", ka = "ArrowRight";
function Th(e, t, n) {
  return Math.floor(e / t) !== n;
}
function Uu(e, t) {
  return t < 0 || t >= e.current.length;
}
function Yv(e, t) {
  return Qn(e, {
    disabledIndices: t
  });
}
function CT(e, t) {
  return Qn(e, {
    decrement: !0,
    startingIndex: e.current.length,
    disabledIndices: t
  });
}
function Qn(e, t) {
  let {
    startingIndex: n = -1,
    decrement: r = !1,
    disabledIndices: i,
    amount: o = 1
  } = t === void 0 ? {} : t;
  const a = e.current;
  let s = n;
  do
    s += r ? -o : o;
  while (s >= 0 && s <= a.length - 1 && ip(a, s, i));
  return s;
}
function SG(e, t) {
  let {
    event: n,
    orientation: r,
    loop: i,
    rtl: o,
    cols: a,
    disabledIndices: s,
    minIndex: l,
    maxIndex: c,
    prevIndex: f,
    stopEvent: d = !1
  } = t, p = f;
  if (n.key === l1) {
    if (d && Un(n), f === -1)
      p = c;
    else if (p = Qn(e, {
      startingIndex: p,
      amount: a,
      decrement: !0,
      disabledIndices: s
    }), i && (f - a < l || p < 0)) {
      const m = f % a, y = c % a, g = c - (y - m);
      y === m ? p = c : p = y > m ? g : g - a;
    }
    Uu(e, p) && (p = f);
  }
  if (n.key === cd && (d && Un(n), f === -1 ? p = l : (p = Qn(e, {
    startingIndex: f,
    amount: a,
    disabledIndices: s
  }), i && f + a > c && (p = Qn(e, {
    startingIndex: f % a - a,
    amount: a,
    disabledIndices: s
  }))), Uu(e, p) && (p = f)), r === "both") {
    const m = kl(f / a);
    n.key === (o ? Ea : ka) && (d && Un(n), f % a !== a - 1 ? (p = Qn(e, {
      startingIndex: f,
      disabledIndices: s
    }), i && Th(p, a, m) && (p = Qn(e, {
      startingIndex: f - f % a - 1,
      disabledIndices: s
    }))) : i && (p = Qn(e, {
      startingIndex: f - f % a - 1,
      disabledIndices: s
    })), Th(p, a, m) && (p = f)), n.key === (o ? ka : Ea) && (d && Un(n), f % a !== 0 ? (p = Qn(e, {
      startingIndex: f,
      decrement: !0,
      disabledIndices: s
    }), i && Th(p, a, m) && (p = Qn(e, {
      startingIndex: f + (a - f % a),
      decrement: !0,
      disabledIndices: s
    }))) : i && (p = Qn(e, {
      startingIndex: f + (a - f % a),
      decrement: !0,
      disabledIndices: s
    })), Th(p, a, m) && (p = f));
    const y = kl(c / a) === m;
    Uu(e, p) && (i && y ? p = n.key === (o ? ka : Ea) ? c : Qn(e, {
      startingIndex: f - f % a - 1,
      disabledIndices: s
    }) : p = f);
  }
  return p;
}
function OG(e, t, n) {
  const r = [];
  let i = 0;
  return e.forEach((o, a) => {
    let {
      width: s,
      height: l
    } = o;
    if (s > t && "development" !== "production")
      throw new Error("[Floating UI]: Invalid grid - item width at index " + a + " is greater than grid columns");
    let c = !1;
    for (n && (i = 0); !c; ) {
      const f = [];
      for (let d = 0; d < s; d++)
        for (let p = 0; p < l; p++)
          f.push(i + d + p * t);
      i % t + s <= t && f.every((d) => r[d] == null) ? (f.forEach((d) => {
        r[d] = a;
      }), c = !0) : i++;
    }
  }), [...r];
}
function AG(e, t, n, r, i) {
  if (e === -1) return -1;
  const o = n.indexOf(e), a = t[e];
  switch (i) {
    case "tl":
      return o;
    case "tr":
      return a ? o + a.width - 1 : o;
    case "bl":
      return a ? o + (a.height - 1) * r : o;
    case "br":
      return n.lastIndexOf(e);
  }
}
function TG(e, t) {
  return t.flatMap((n, r) => e.includes(n) ? [r] : []);
}
function ip(e, t, n) {
  if (n)
    return n.includes(t);
  const r = e[t];
  return r == null || r.hasAttribute("disabled") || r.getAttribute("aria-disabled") === "true";
}
var Nt = typeof document < "u" ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function ff() {
  return ff = Object.assign ? Object.assign.bind() : function(e) {
    for (var t = 1; t < arguments.length; t++) {
      var n = arguments[t];
      for (var r in n)
        Object.prototype.hasOwnProperty.call(n, r) && (e[r] = n[r]);
    }
    return e;
  }, ff.apply(this, arguments);
}
let ET = !1, PG = 0;
const kT = () => (
  // Ensure the id is unique with multiple independent versions of Floating UI
  // on <React 18
  "floating-ui-" + Math.random().toString(36).slice(2, 6) + PG++
);
function CG() {
  const [e, t] = react__WEBPACK_IMPORTED_MODULE_1__.useState(() => ET ? kT() : void 0);
  return Nt(() => {
    e == null && t(kT());
  }, []), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    ET = !0;
  }, []), e;
}
const EG = OD.useId, sg = EG || CG;
let df;
 true && (df = /* @__PURE__ */ new Set());
function op() {
  for (var e, t = arguments.length, n = new Array(t), r = 0; r < t; r++)
    n[r] = arguments[r];
  const i = "Floating UI: " + n.join(" ");
  if (!((e = df) != null && e.has(i))) {
    var o;
    (o = df) == null || o.add(i), console.warn(i);
  }
}
function kG() {
  for (var e, t = arguments.length, n = new Array(t), r = 0; r < t; r++)
    n[r] = arguments[r];
  const i = "Floating UI: " + n.join(" ");
  if (!((e = df) != null && e.has(i))) {
    var o;
    (o = df) == null || o.add(i), console.error(i);
  }
}
const MG = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.forwardRef(function(t, n) {
  const {
    context: {
      placement: r,
      elements: {
        floating: i
      },
      middlewareData: {
        arrow: o,
        shift: a
      }
    },
    width: s = 14,
    height: l = 7,
    tipRadius: c = 0,
    strokeWidth: f = 0,
    staticOffset: d,
    stroke: p,
    d: m,
    style: {
      transform: y,
      ...g
    } = {},
    ...v
  } = t;
   true && (n || op("The `ref` prop is required for `FloatingArrow`."));
  const x = sg(), [w, S] = react__WEBPACK_IMPORTED_MODULE_1__.useState(!1);
  if (Nt(() => {
    if (!i) return;
    Hr(i).direction === "rtl" && S(!0);
  }, [i]), !i)
    return null;
  const [A, _] = r.split("-"), O = A === "top" || A === "bottom";
  let P = d;
  (O && a != null && a.x || !O && a != null && a.y) && (P = null);
  const C = f * 2, k = C / 2, I = s / 2 * (c / -8 + 1), $ = l / 2 * c / 4, N = !!m, D = P && _ === "end" ? "bottom" : "top";
  let j = P && _ === "end" ? "right" : "left";
  P && w && (j = _ === "end" ? "left" : "right");
  const F = (o == null ? void 0 : o.x) != null ? P || o.x : "", W = (o == null ? void 0 : o.y) != null ? P || o.y : "", z = m || "M0,0" + (" H" + s) + (" L" + (s - I) + "," + (l - $)) + (" Q" + s / 2 + "," + l + " " + I + "," + (l - $)) + " Z", H = {
    top: N ? "rotate(180deg)" : "",
    left: N ? "rotate(90deg)" : "rotate(-90deg)",
    bottom: N ? "" : "rotate(180deg)",
    right: N ? "rotate(-90deg)" : "rotate(90deg)"
  }[A];
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("svg", ff({}, v, {
    "aria-hidden": !0,
    ref: n,
    width: N ? s : s + C,
    height: s,
    viewBox: "0 0 " + s + " " + (l > s ? l : s),
    style: {
      position: "absolute",
      pointerEvents: "none",
      [j]: F,
      [D]: W,
      [A]: O || N ? "100%" : "calc(100% - " + C / 2 + "px)",
      transform: [H, y].filter((U) => !!U).join(" "),
      ...g
    }
  }), C > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("path", {
    clipPath: "url(#" + x + ")",
    fill: "none",
    stroke: p,
    strokeWidth: C + (m ? 0 : 1),
    d: z
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("path", {
    stroke: C && !m ? v.fill : "none",
    d: z
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("clipPath", {
    id: x
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("rect", {
    x: -k,
    y: k * (N ? -1 : 1),
    width: s + C,
    height: s
  })));
});
function NG() {
  const e = /* @__PURE__ */ new Map();
  return {
    emit(t, n) {
      var r;
      (r = e.get(t)) == null || r.forEach((i) => i(n));
    },
    on(t, n) {
      e.set(t, [...e.get(t) || [], n]);
    },
    off(t, n) {
      var r;
      e.set(t, ((r = e.get(t)) == null ? void 0 : r.filter((i) => i !== n)) || []);
    }
  };
}
const $G = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createContext(null), DG = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createContext(null), lg = () => {
  var e;
  return ((e = react__WEBPACK_IMPORTED_MODULE_1__.useContext($G)) == null ? void 0 : e.id) || null;
}, ud = () => react__WEBPACK_IMPORTED_MODULE_1__.useContext(DG);
function js(e) {
  return "data-floating-ui-" + e;
}
function Yn(e) {
  const t = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(e);
  return Nt(() => {
    t.current = e;
  }), t;
}
const MT = /* @__PURE__ */ js("safe-polygon");
function qv(e, t, n) {
  return n && !uf(n) ? 0 : typeof e == "number" ? e : e == null ? void 0 : e[t];
}
function IG(e, t) {
  t === void 0 && (t = {});
  const {
    open: n,
    onOpenChange: r,
    dataRef: i,
    events: o,
    elements: a
  } = e, {
    enabled: s = !0,
    delay: l = 0,
    handleClose: c = null,
    mouseOnly: f = !1,
    restMs: d = 0,
    move: p = !0
  } = t, m = ud(), y = lg(), g = Yn(c), v = Yn(l), x = Yn(n), w = react__WEBPACK_IMPORTED_MODULE_1__.useRef(), S = react__WEBPACK_IMPORTED_MODULE_1__.useRef(-1), A = react__WEBPACK_IMPORTED_MODULE_1__.useRef(), _ = react__WEBPACK_IMPORTED_MODULE_1__.useRef(-1), O = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!0), P = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), C = react__WEBPACK_IMPORTED_MODULE_1__.useRef(() => {
  }), k = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), I = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(() => {
    var z;
    const H = (z = i.current.openEvent) == null ? void 0 : z.type;
    return (H == null ? void 0 : H.includes("mouse")) && H !== "mousedown";
  }, [i]);
  react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!s) return;
    function z(H) {
      let {
        open: U
      } = H;
      U || (clearTimeout(S.current), clearTimeout(_.current), O.current = !0, k.current = !1);
    }
    return o.on("openchange", z), () => {
      o.off("openchange", z);
    };
  }, [s, o]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!s || !g.current || !n) return;
    function z(U) {
      I() && r(!1, U, "hover");
    }
    const H = Kn(a.floating).documentElement;
    return H.addEventListener("mouseleave", z), () => {
      H.removeEventListener("mouseleave", z);
    };
  }, [a.floating, n, r, s, g, I]);
  const $ = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(function(z, H, U) {
    H === void 0 && (H = !0), U === void 0 && (U = "hover");
    const V = qv(v.current, "close", w.current);
    V && !A.current ? (clearTimeout(S.current), S.current = window.setTimeout(() => r(!1, z, U), V)) : H && (clearTimeout(S.current), r(!1, z, U));
  }, [v, r]), N = Nn(() => {
    C.current(), A.current = void 0;
  }), D = Nn(() => {
    if (P.current) {
      const z = Kn(a.floating).body;
      z.style.pointerEvents = "", z.removeAttribute(MT), P.current = !1;
    }
  }), j = Nn(() => i.current.openEvent ? ["click", "mousedown"].includes(i.current.openEvent.type) : !1);
  react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!s) return;
    function z(Y) {
      if (clearTimeout(S.current), O.current = !1, f && !uf(w.current) || d > 0 && !qv(v.current, "open"))
        return;
      const Q = qv(v.current, "open", w.current);
      Q ? S.current = window.setTimeout(() => {
        x.current || r(!0, Y, "hover");
      }, Q) : n || r(!0, Y, "hover");
    }
    function H(Y) {
      if (j()) return;
      C.current();
      const Q = Kn(a.floating);
      if (clearTimeout(_.current), k.current = !1, g.current && i.current.floatingContext) {
        n || clearTimeout(S.current), A.current = g.current({
          ...i.current.floatingContext,
          tree: m,
          x: Y.clientX,
          y: Y.clientY,
          onClose() {
            D(), N(), j() || $(Y, !0, "safe-polygon");
          }
        });
        const re = A.current;
        Q.addEventListener("mousemove", re), C.current = () => {
          Q.removeEventListener("mousemove", re);
        };
        return;
      }
      (w.current === "touch" ? !hn(a.floating, Y.relatedTarget) : !0) && $(Y);
    }
    function U(Y) {
      j() || i.current.floatingContext && (g.current == null || g.current({
        ...i.current.floatingContext,
        tree: m,
        x: Y.clientX,
        y: Y.clientY,
        onClose() {
          D(), N(), j() || $(Y);
        }
      })(Y));
    }
    if (Ct(a.domReference)) {
      var V;
      const Y = a.domReference;
      return n && Y.addEventListener("mouseleave", U), (V = a.floating) == null || V.addEventListener("mouseleave", U), p && Y.addEventListener("mousemove", z, {
        once: !0
      }), Y.addEventListener("mouseenter", z), Y.addEventListener("mouseleave", H), () => {
        var Q;
        n && Y.removeEventListener("mouseleave", U), (Q = a.floating) == null || Q.removeEventListener("mouseleave", U), p && Y.removeEventListener("mousemove", z), Y.removeEventListener("mouseenter", z), Y.removeEventListener("mouseleave", H);
      };
    }
  }, [a, s, e, f, d, p, $, N, D, r, n, x, m, v, g, i, j]), Nt(() => {
    var z;
    if (s && n && (z = g.current) != null && z.__options.blockPointerEvents && I()) {
      P.current = !0;
      const U = a.floating;
      if (Ct(a.domReference) && U) {
        var H;
        const V = Kn(a.floating).body;
        V.setAttribute(MT, "");
        const Y = a.domReference, Q = m == null || (H = m.nodesRef.current.find((ne) => ne.id === y)) == null || (H = H.context) == null ? void 0 : H.elements.floating;
        return Q && (Q.style.pointerEvents = ""), V.style.pointerEvents = "none", Y.style.pointerEvents = "auto", U.style.pointerEvents = "auto", () => {
          V.style.pointerEvents = "", Y.style.pointerEvents = "", U.style.pointerEvents = "";
        };
      }
    }
  }, [s, n, y, a, m, g, I]), Nt(() => {
    n || (w.current = void 0, k.current = !1, N(), D());
  }, [n, N, D]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => () => {
    N(), clearTimeout(S.current), clearTimeout(_.current), D();
  }, [s, a.domReference, N, D]);
  const F = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => {
    function z(H) {
      w.current = H.pointerType;
    }
    return {
      onPointerDown: z,
      onPointerEnter: z,
      onMouseMove(H) {
        const {
          nativeEvent: U
        } = H;
        function V() {
          !O.current && !x.current && r(!0, U, "hover");
        }
        f && !uf(w.current) || n || d === 0 || k.current && H.movementX ** 2 + H.movementY ** 2 < 2 || (clearTimeout(_.current), w.current === "touch" ? V() : (k.current = !0, _.current = window.setTimeout(V, d)));
      }
    };
  }, [f, r, n, x, d]), W = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onMouseEnter() {
      clearTimeout(S.current);
    },
    onMouseLeave(z) {
      j() || $(z.nativeEvent, !1);
    }
  }), [$, j]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => s ? {
    reference: F,
    floating: W
  } : {}, [s, F, W]);
}
let NT = 0;
function xa(e, t) {
  t === void 0 && (t = {});
  const {
    preventScroll: n = !1,
    cancelPrevious: r = !0,
    sync: i = !1
  } = t;
  r && cancelAnimationFrame(NT);
  const o = () => e == null ? void 0 : e.focus({
    preventScroll: n
  });
  i ? o() : NT = requestAnimationFrame(o);
}
function RG(e, t) {
  var n;
  let r = [], i = (n = e.find((o) => o.id === t)) == null ? void 0 : n.parentId;
  for (; i; ) {
    const o = e.find((a) => a.id === i);
    i = o == null ? void 0 : o.parentId, o && (r = r.concat(o));
  }
  return r;
}
function Cs(e, t) {
  let n = e.filter((i) => {
    var o;
    return i.parentId === t && ((o = i.context) == null ? void 0 : o.open);
  }), r = n;
  for (; r.length; )
    r = e.filter((i) => {
      var o;
      return (o = r) == null ? void 0 : o.some((a) => {
        var s;
        return i.parentId === a.id && ((s = i.context) == null ? void 0 : s.open);
      });
    }), n = n.concat(r);
  return n;
}
function jG(e, t) {
  let n, r = -1;
  function i(o, a) {
    a > r && (n = o, r = a), Cs(e, o).forEach((l) => {
      i(l.id, a + 1);
    });
  }
  return i(t, 0), e.find((o) => o.id === n);
}
let xl = /* @__PURE__ */ new WeakMap(), Ph = /* @__PURE__ */ new WeakSet(), Ch = {}, Xv = 0;
const LG = () => typeof HTMLElement < "u" && "inert" in HTMLElement.prototype, AD = (e) => e && (e.host || AD(e.parentNode)), BG = (e, t) => t.map((n) => {
  if (e.contains(n))
    return n;
  const r = AD(n);
  return e.contains(r) ? r : null;
}).filter((n) => n != null);
function FG(e, t, n, r) {
  const i = "data-floating-ui-inert", o = r ? "inert" : n ? "aria-hidden" : null, a = BG(t, e), s = /* @__PURE__ */ new Set(), l = new Set(a), c = [];
  Ch[i] || (Ch[i] = /* @__PURE__ */ new WeakMap());
  const f = Ch[i];
  a.forEach(d), p(t), s.clear();
  function d(m) {
    !m || s.has(m) || (s.add(m), m.parentNode && d(m.parentNode));
  }
  function p(m) {
    !m || l.has(m) || [].forEach.call(m.children, (y) => {
      if (za(y) !== "script")
        if (s.has(y))
          p(y);
        else {
          const g = o ? y.getAttribute(o) : null, v = g !== null && g !== "false", x = (xl.get(y) || 0) + 1, w = (f.get(y) || 0) + 1;
          xl.set(y, x), f.set(y, w), c.push(y), x === 1 && v && Ph.add(y), w === 1 && y.setAttribute(i, ""), !v && o && y.setAttribute(o, "true");
        }
    });
  }
  return Xv++, () => {
    c.forEach((m) => {
      const y = (xl.get(m) || 0) - 1, g = (f.get(m) || 0) - 1;
      xl.set(m, y), f.set(m, g), y || (!Ph.has(m) && o && m.removeAttribute(o), Ph.delete(m)), g || m.removeAttribute(i);
    }), Xv--, Xv || (xl = /* @__PURE__ */ new WeakMap(), xl = /* @__PURE__ */ new WeakMap(), Ph = /* @__PURE__ */ new WeakSet(), Ch = {});
  };
}
function $T(e, t, n) {
  t === void 0 && (t = !1), n === void 0 && (n = !1);
  const r = Kn(e[0]).body;
  return FG(e.concat(Array.from(r.querySelectorAll("[aria-live]"))), r, t, n);
}
const hf = () => ({
  getShadowRoot: !0,
  displayCheck: (
    // JSDOM does not support the `tabbable` library. To solve this we can
    // check if `ResizeObserver` is a real function (not polyfilled), which
    // determines if the current environment is JSDOM-like.
    typeof ResizeObserver == "function" && ResizeObserver.toString().includes("[native code]") ? "full" : "none"
  )
});
function TD(e, t) {
  const n = rg(e, hf());
  t === "prev" && n.reverse();
  const r = n.indexOf(Pi(Kn(e)));
  return n.slice(r + 1)[0];
}
function PD() {
  return TD(document.body, "next");
}
function CD() {
  return TD(document.body, "prev");
}
function Hu(e, t) {
  const n = t || e.currentTarget, r = e.relatedTarget;
  return !r || !hn(n, r);
}
function WG(e) {
  rg(e, hf()).forEach((n) => {
    n.dataset.tabindex = n.getAttribute("tabindex") || "", n.setAttribute("tabindex", "-1");
  });
}
function DT(e) {
  e.querySelectorAll("[data-tabindex]").forEach((n) => {
    const r = n.dataset.tabindex;
    delete n.dataset.tabindex, r ? n.setAttribute("tabindex", r) : n.removeAttribute("tabindex");
  });
}
const cg = {
  border: 0,
  clip: "rect(0 0 0 0)",
  height: "1px",
  margin: "-1px",
  overflow: "hidden",
  padding: 0,
  position: "fixed",
  whiteSpace: "nowrap",
  width: "1px",
  top: 0,
  left: 0
};
let zG;
function IT(e) {
  e.key === "Tab" && (e.target, clearTimeout(zG));
}
const xp = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.forwardRef(function(t, n) {
  const [r, i] = react__WEBPACK_IMPORTED_MODULE_1__.useState();
  Nt(() => (t1() && i("button"), document.addEventListener("keydown", IT), () => {
    document.removeEventListener("keydown", IT);
  }), []);
  const o = {
    ref: n,
    tabIndex: 0,
    // Role is only for VoiceOver
    role: r,
    "aria-hidden": r ? void 0 : !0,
    [js("focus-guard")]: "",
    style: cg
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", ff({}, t, o));
}), ED = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createContext(null), RT = /* @__PURE__ */ js("portal");
function VG(e) {
  e === void 0 && (e = {});
  const {
    id: t,
    root: n
  } = e, r = sg(), i = kD(), [o, a] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), s = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null);
  return Nt(() => () => {
    o == null || o.remove(), queueMicrotask(() => {
      s.current = null;
    });
  }, [o]), Nt(() => {
    if (!r || s.current) return;
    const l = t ? document.getElementById(t) : null;
    if (!l) return;
    const c = document.createElement("div");
    c.id = r, c.setAttribute(RT, ""), l.appendChild(c), s.current = c, a(c);
  }, [t, r]), Nt(() => {
    if (n === null || !r || s.current) return;
    let l = n || (i == null ? void 0 : i.portalNode);
    l && !Ct(l) && (l = l.current), l = l || document.body;
    let c = null;
    t && (c = document.createElement("div"), c.id = t, l.appendChild(c));
    const f = document.createElement("div");
    f.id = r, f.setAttribute(RT, ""), l = c || l, l.appendChild(f), s.current = f, a(f);
  }, [t, n, r, i]), o;
}
function ug(e) {
  const {
    children: t,
    id: n,
    root: r,
    preserveTabOrder: i = !0
  } = e, o = VG({
    id: n,
    root: r
  }), [a, s] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), l = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), c = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), f = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), d = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), p = a == null ? void 0 : a.modal, m = a == null ? void 0 : a.open, y = (
    // The FocusManager and therefore floating element are currently open/
    // rendered.
    !!a && // Guards are only for non-modal focus management.
    !a.modal && // Don't render if unmount is transitioning.
    a.open && i && !!(r || o)
  );
  return react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!o || !i || p)
      return;
    function g(v) {
      o && Hu(v) && (v.type === "focusin" ? DT : WG)(o);
    }
    return o.addEventListener("focusin", g, !0), o.addEventListener("focusout", g, !0), () => {
      o.removeEventListener("focusin", g, !0), o.removeEventListener("focusout", g, !0);
    };
  }, [o, i, p]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    o && (m || DT(o));
  }, [m, o]), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(ED.Provider, {
    value: react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
      preserveTabOrder: i,
      beforeOutsideRef: l,
      afterOutsideRef: c,
      beforeInsideRef: f,
      afterInsideRef: d,
      portalNode: o,
      setFocusManagerState: s
    }), [i, o])
  }, y && o && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(xp, {
    "data-type": "outside",
    ref: l,
    onFocus: (g) => {
      if (Hu(g, o)) {
        var v;
        (v = f.current) == null || v.focus();
      } else {
        const x = CD() || (a == null ? void 0 : a.refs.domReference.current);
        x == null || x.focus();
      }
    }
  }), y && o && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", {
    "aria-owns": o.id,
    style: cg
  }), o && /* @__PURE__ */ react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal(t, o), y && o && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(xp, {
    "data-type": "outside",
    ref: c,
    onFocus: (g) => {
      if (Hu(g, o)) {
        var v;
        (v = d.current) == null || v.focus();
      } else {
        const x = PD() || (a == null ? void 0 : a.refs.domReference.current);
        x == null || x.focus(), a != null && a.closeOnFocusOut && (a == null || a.onOpenChange(!1, g.nativeEvent, "focus-out"));
      }
    }
  }));
}
const kD = () => react__WEBPACK_IMPORTED_MODULE_1__.useContext(ED), b0 = "data-floating-ui-focusable";
function MD(e) {
  return e ? e.hasAttribute(b0) ? e : e.querySelector("[" + b0 + "]") || e : null;
}
const jT = 20;
let hs = [];
function Zv(e) {
  hs = hs.filter((n) => n.isConnected);
  let t = e;
  if (!(!t || za(t) === "body")) {
    if (!UK(t, hf())) {
      const n = rg(t, hf())[0];
      n && (t = n);
    }
    hs.push(t), hs.length > jT && (hs = hs.slice(-jT));
  }
}
function LT() {
  return hs.slice().reverse().find((e) => e.isConnected);
}
const UG = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.forwardRef(function(t, n) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement("button", ff({}, t, {
    type: "button",
    ref: n,
    tabIndex: -1,
    style: cg
  }));
});
function HG(e) {
  const {
    context: t,
    children: n,
    disabled: r = !1,
    order: i = ["content"],
    guards: o = !0,
    initialFocus: a = 0,
    returnFocus: s = !0,
    restoreFocus: l = !1,
    modal: c = !0,
    visuallyHiddenDismiss: f = !1,
    closeOnFocusOut: d = !0
  } = e, {
    open: p,
    refs: m,
    nodeId: y,
    onOpenChange: g,
    events: v,
    dataRef: x,
    floatingId: w,
    elements: {
      domReference: S,
      floating: A
    }
  } = t, _ = typeof a == "number" && a < 0, O = m0(S) && _, P = LG() ? o : !0, C = Yn(i), k = Yn(a), I = Yn(s), $ = ud(), N = kD(), D = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), j = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), F = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), W = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), z = react__WEBPACK_IMPORTED_MODULE_1__.useRef(-1), H = N != null, U = MD(A), V = Nn(function(re) {
    return re === void 0 && (re = U), re ? rg(re, hf()) : [];
  }), Y = Nn((re) => {
    const ce = V(re);
    return C.current.map((oe) => S && oe === "reference" ? S : U && oe === "floating" ? U : ce).filter(Boolean).flat();
  });
  react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (r || !c) return;
    function re(oe) {
      if (oe.key === "Tab") {
        hn(U, Pi(Kn(U))) && V().length === 0 && !O && Un(oe);
        const fe = Y(), ae = Ao(oe);
        C.current[0] === "reference" && ae === S && (Un(oe), oe.shiftKey ? xa(fe[fe.length - 1]) : xa(fe[1])), C.current[1] === "floating" && ae === U && oe.shiftKey && (Un(oe), xa(fe[0]));
      }
    }
    const ce = Kn(U);
    return ce.addEventListener("keydown", re), () => {
      ce.removeEventListener("keydown", re);
    };
  }, [r, S, U, c, C, O, V, Y]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (r || !A) return;
    function re(ce) {
      const oe = Ao(ce), ae = V().indexOf(oe);
      ae !== -1 && (z.current = ae);
    }
    return A.addEventListener("focusin", re), () => {
      A.removeEventListener("focusin", re);
    };
  }, [r, A, V]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (r || !d) return;
    function re() {
      W.current = !0, setTimeout(() => {
        W.current = !1;
      });
    }
    function ce(oe) {
      const fe = oe.relatedTarget;
      queueMicrotask(() => {
        const ae = !(hn(S, fe) || hn(A, fe) || hn(fe, A) || hn(N == null ? void 0 : N.portalNode, fe) || fe != null && fe.hasAttribute(js("focus-guard")) || $ && (Cs($.nodesRef.current, y).find((ee) => {
          var se, ge;
          return hn((se = ee.context) == null ? void 0 : se.elements.floating, fe) || hn((ge = ee.context) == null ? void 0 : ge.elements.domReference, fe);
        }) || RG($.nodesRef.current, y).find((ee) => {
          var se, ge;
          return ((se = ee.context) == null ? void 0 : se.elements.floating) === fe || ((ge = ee.context) == null ? void 0 : ge.elements.domReference) === fe;
        })));
        if (l && ae && Pi(Kn(U)) === Kn(U).body) {
          pn(U) && U.focus();
          const ee = z.current, se = V(), ge = se[ee] || se[se.length - 1] || U;
          pn(ge) && ge.focus();
        }
        (O || !c) && fe && ae && !W.current && // Fix React 18 Strict Mode returnFocus due to double rendering.
        fe !== LT() && (F.current = !0, g(!1, oe, "focus-out"));
      });
    }
    if (A && pn(S))
      return S.addEventListener("focusout", ce), S.addEventListener("pointerdown", re), A.addEventListener("focusout", ce), () => {
        S.removeEventListener("focusout", ce), S.removeEventListener("pointerdown", re), A.removeEventListener("focusout", ce);
      };
  }, [r, S, A, U, c, y, $, N, g, d, l, V, O]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    var re;
    if (r) return;
    const ce = Array.from((N == null || (re = N.portalNode) == null ? void 0 : re.querySelectorAll("[" + js("portal") + "]")) || []);
    if (A) {
      const oe = [A, ...ce, D.current, j.current, C.current.includes("reference") || O ? S : null].filter((ae) => ae != null), fe = c || O ? $T(oe, P, !P) : $T(oe);
      return () => {
        fe();
      };
    }
  }, [r, S, A, c, C, N, O, P]), Nt(() => {
    if (r || !pn(U)) return;
    const re = Kn(U), ce = Pi(re);
    queueMicrotask(() => {
      const oe = Y(U), fe = k.current, ae = (typeof fe == "number" ? oe[fe] : fe.current) || U, ee = hn(U, ce);
      !_ && !ee && p && xa(ae, {
        preventScroll: ae === U
      });
    });
  }, [r, p, U, _, Y, k]), Nt(() => {
    if (r || !U) return;
    let re = !1;
    const ce = Kn(U), oe = Pi(ce);
    let ae = x.current.openEvent;
    Zv(oe);
    function ee(X) {
      let {
        open: $e,
        reason: de,
        event: ke,
        nested: it
      } = X;
      $e && (ae = ke), de === "escape-key" && m.domReference.current && Zv(m.domReference.current), de === "hover" && ke.type === "mouseleave" && (F.current = !0), de === "outside-press" && (it ? (F.current = !1, re = !0) : F.current = !(lD(ke) || e1(ke)));
    }
    v.on("openchange", ee);
    const se = ce.createElement("span");
    se.setAttribute("tabindex", "-1"), se.setAttribute("aria-hidden", "true"), Object.assign(se.style, cg), H && S && S.insertAdjacentElement("afterend", se);
    function ge() {
      return typeof I.current == "boolean" ? LT() || se : I.current.current || se;
    }
    return () => {
      v.off("openchange", ee);
      const X = Pi(ce), $e = hn(A, X) || $ && Cs($.nodesRef.current, y).some((it) => {
        var lt;
        return hn((lt = it.context) == null ? void 0 : lt.elements.floating, X);
      });
      ($e || ae && ["click", "mousedown"].includes(ae.type)) && m.domReference.current && Zv(m.domReference.current);
      const ke = ge();
      queueMicrotask(() => {
        // eslint-disable-next-line react-hooks/exhaustive-deps
        I.current && !F.current && pn(ke) && // If the focus moved somewhere else after mount, avoid returning focus
        // since it likely entered a different element which should be
        // respected: https://github.com/floating-ui/floating-ui/issues/2607
        (!(ke !== X && X !== ce.body) || $e) && ke.focus({
          preventScroll: re
        }), se.remove();
      });
    };
  }, [r, A, U, I, x, m, v, $, y, H, S]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    queueMicrotask(() => {
      F.current = !1;
    });
  }, [r]), Nt(() => {
    if (!r && N)
      return N.setFocusManagerState({
        modal: c,
        closeOnFocusOut: d,
        open: p,
        onOpenChange: g,
        refs: m
      }), () => {
        N.setFocusManagerState(null);
      };
  }, [r, N, c, p, g, m, d]), Nt(() => {
    if (r || !U || typeof MutationObserver != "function" || _) return;
    const re = () => {
      const oe = U.getAttribute("tabindex"), fe = V(), ae = Pi(Kn(A)), ee = fe.indexOf(ae);
      ee !== -1 && (z.current = ee), C.current.includes("floating") || ae !== m.domReference.current && fe.length === 0 ? oe !== "0" && U.setAttribute("tabindex", "0") : oe !== "-1" && U.setAttribute("tabindex", "-1");
    };
    re();
    const ce = new MutationObserver(re);
    return ce.observe(U, {
      childList: !0,
      subtree: !0,
      attributes: !0
    }), () => {
      ce.disconnect();
    };
  }, [r, A, U, m, C, V, _]);
  function Q(re) {
    return r || !f || !c ? null : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(UG, {
      ref: re === "start" ? D : j,
      onClick: (ce) => g(!1, ce.nativeEvent)
    }, typeof f == "string" ? f : "Dismiss");
  }
  const ne = !r && P && (c ? !O : !0) && (H || c);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, ne && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(xp, {
    "data-type": "inside",
    ref: N == null ? void 0 : N.beforeInsideRef,
    onFocus: (re) => {
      if (c) {
        const oe = Y();
        xa(i[0] === "reference" ? oe[0] : oe[oe.length - 1]);
      } else if (N != null && N.preserveTabOrder && N.portalNode)
        if (F.current = !1, Hu(re, N.portalNode)) {
          const oe = PD() || S;
          oe == null || oe.focus();
        } else {
          var ce;
          (ce = N.beforeOutsideRef.current) == null || ce.focus();
        }
    }
  }), !O && Q("start"), n, Q("end"), ne && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(xp, {
    "data-type": "inside",
    ref: N == null ? void 0 : N.afterInsideRef,
    onFocus: (re) => {
      if (c)
        xa(Y()[0]);
      else if (N != null && N.preserveTabOrder && N.portalNode)
        if (d && (F.current = !0), Hu(re, N.portalNode)) {
          const oe = CD() || S;
          oe == null || oe.focus();
        } else {
          var ce;
          (ce = N.afterOutsideRef.current) == null || ce.focus();
        }
    }
  }));
}
function BT(e) {
  return pn(e.target) && e.target.tagName === "BUTTON";
}
function FT(e) {
  return n1(e);
}
function c1(e, t) {
  t === void 0 && (t = {});
  const {
    open: n,
    onOpenChange: r,
    dataRef: i,
    elements: {
      domReference: o
    }
  } = e, {
    enabled: a = !0,
    event: s = "click",
    toggle: l = !0,
    ignoreMouse: c = !1,
    keyboardHandlers: f = !0,
    stickIfOpen: d = !0
  } = t, p = react__WEBPACK_IMPORTED_MODULE_1__.useRef(), m = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), y = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onPointerDown(g) {
      p.current = g.pointerType;
    },
    onMouseDown(g) {
      const v = p.current;
      g.button === 0 && s !== "click" && (uf(v, !0) && c || (n && l && (!(i.current.openEvent && d) || i.current.openEvent.type === "mousedown") ? r(!1, g.nativeEvent, "click") : (g.preventDefault(), r(!0, g.nativeEvent, "click"))));
    },
    onClick(g) {
      const v = p.current;
      if (s === "mousedown" && p.current) {
        p.current = void 0;
        return;
      }
      uf(v, !0) && c || (n && l && (!(i.current.openEvent && d) || i.current.openEvent.type === "click") ? r(!1, g.nativeEvent, "click") : r(!0, g.nativeEvent, "click"));
    },
    onKeyDown(g) {
      p.current = void 0, !(g.defaultPrevented || !f || BT(g)) && (g.key === " " && !FT(o) && (g.preventDefault(), m.current = !0), g.key === "Enter" && r(!(n && l), g.nativeEvent, "click"));
    },
    onKeyUp(g) {
      g.defaultPrevented || !f || BT(g) || FT(o) || g.key === " " && m.current && (m.current = !1, r(!(n && l), g.nativeEvent, "click"));
    }
  }), [i, o, s, c, f, r, n, d, l]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => a ? {
    reference: y
  } : {}, [a, y]);
}
const KG = {
  pointerdown: "onPointerDown",
  mousedown: "onMouseDown",
  click: "onClick"
}, GG = {
  pointerdown: "onPointerDownCapture",
  mousedown: "onMouseDownCapture",
  click: "onClickCapture"
}, WT = (e) => {
  var t, n;
  return {
    escapeKey: typeof e == "boolean" ? e : (t = e == null ? void 0 : e.escapeKey) != null ? t : !1,
    outsidePress: typeof e == "boolean" ? e : (n = e == null ? void 0 : e.outsidePress) != null ? n : !0
  };
};
function fg(e, t) {
  t === void 0 && (t = {});
  const {
    open: n,
    onOpenChange: r,
    elements: i,
    dataRef: o
  } = e, {
    enabled: a = !0,
    escapeKey: s = !0,
    outsidePress: l = !0,
    outsidePressEvent: c = "pointerdown",
    referencePress: f = !1,
    referencePressEvent: d = "pointerdown",
    ancestorScroll: p = !1,
    bubbles: m,
    capture: y
  } = t, g = ud(), v = Nn(typeof l == "function" ? l : () => !1), x = typeof l == "function" ? v : l, w = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), S = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), {
    escapeKey: A,
    outsidePress: _
  } = WT(m), {
    escapeKey: O,
    outsidePress: P
  } = WT(y), C = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), k = Nn((F) => {
    var W;
    if (!n || !a || !s || F.key !== "Escape" || C.current)
      return;
    const z = (W = o.current.floatingContext) == null ? void 0 : W.nodeId, H = g ? Cs(g.nodesRef.current, z) : [];
    if (!A && (F.stopPropagation(), H.length > 0)) {
      let U = !0;
      if (H.forEach((V) => {
        var Y;
        if ((Y = V.context) != null && Y.open && !V.context.dataRef.current.__escapeKeyBubbles) {
          U = !1;
          return;
        }
      }), !U)
        return;
    }
    r(!1, gK(F) ? F.nativeEvent : F, "escape-key");
  }), I = Nn((F) => {
    var W;
    const z = () => {
      var H;
      k(F), (H = Ao(F)) == null || H.removeEventListener("keydown", z);
    };
    (W = Ao(F)) == null || W.addEventListener("keydown", z);
  }), $ = Nn((F) => {
    var W;
    const z = w.current;
    w.current = !1;
    const H = S.current;
    if (S.current = !1, c === "click" && H || z || typeof x == "function" && !x(F))
      return;
    const U = Ao(F), V = "[" + js("inert") + "]", Y = Kn(i.floating).querySelectorAll(V);
    let Q = Ct(U) ? U : null;
    for (; Q && !Da(Q); ) {
      const oe = Fo(Q);
      if (Da(oe) || !Ct(oe))
        break;
      Q = oe;
    }
    if (Y.length && Ct(U) && !yK(U) && // Clicked on a direct ancestor (e.g. FloatingOverlay).
    !hn(U, i.floating) && // If the target root element contains none of the markers, then the
    // element was injected after the floating element rendered.
    Array.from(Y).every((oe) => !hn(Q, oe)))
      return;
    if (pn(U) && j) {
      const oe = U.clientWidth > 0 && U.scrollWidth > U.clientWidth, fe = U.clientHeight > 0 && U.scrollHeight > U.clientHeight;
      let ae = fe && F.offsetX > U.clientWidth;
      if (fe && Hr(U).direction === "rtl" && (ae = F.offsetX <= U.offsetWidth - U.clientWidth), ae || oe && F.offsetY > U.clientHeight)
        return;
    }
    const ne = (W = o.current.floatingContext) == null ? void 0 : W.nodeId, re = g && Cs(g.nodesRef.current, ne).some((oe) => {
      var fe;
      return Hv(F, (fe = oe.context) == null ? void 0 : fe.elements.floating);
    });
    if (Hv(F, i.floating) || Hv(F, i.domReference) || re)
      return;
    const ce = g ? Cs(g.nodesRef.current, ne) : [];
    if (ce.length > 0) {
      let oe = !0;
      if (ce.forEach((fe) => {
        var ae;
        if ((ae = fe.context) != null && ae.open && !fe.context.dataRef.current.__outsidePressBubbles) {
          oe = !1;
          return;
        }
      }), !oe)
        return;
    }
    r(!1, F, "outside-press");
  }), N = Nn((F) => {
    var W;
    const z = () => {
      var H;
      $(F), (H = Ao(F)) == null || H.removeEventListener(c, z);
    };
    (W = Ao(F)) == null || W.addEventListener(c, z);
  });
  react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!n || !a)
      return;
    o.current.__escapeKeyBubbles = A, o.current.__outsidePressBubbles = _;
    let F = -1;
    function W(Y) {
      r(!1, Y, "ancestor-scroll");
    }
    function z() {
      window.clearTimeout(F), C.current = !0;
    }
    function H() {
      F = window.setTimeout(
        () => {
          C.current = !1;
        },
        // 0ms or 1ms don't work in Safari. 5ms appears to consistently work.
        // Only apply to WebKit for the test to remain 0ms.
        tg() ? 5 : 0
      );
    }
    const U = Kn(i.floating);
    s && (U.addEventListener("keydown", O ? I : k, O), U.addEventListener("compositionstart", z), U.addEventListener("compositionend", H)), x && U.addEventListener(c, P ? N : $, P);
    let V = [];
    return p && (Ct(i.domReference) && (V = Ca(i.domReference)), Ct(i.floating) && (V = V.concat(Ca(i.floating))), !Ct(i.reference) && i.reference && i.reference.contextElement && (V = V.concat(Ca(i.reference.contextElement)))), V = V.filter((Y) => {
      var Q;
      return Y !== ((Q = U.defaultView) == null ? void 0 : Q.visualViewport);
    }), V.forEach((Y) => {
      Y.addEventListener("scroll", W, {
        passive: !0
      });
    }), () => {
      s && (U.removeEventListener("keydown", O ? I : k, O), U.removeEventListener("compositionstart", z), U.removeEventListener("compositionend", H)), x && U.removeEventListener(c, P ? N : $, P), V.forEach((Y) => {
        Y.removeEventListener("scroll", W);
      }), window.clearTimeout(F);
    };
  }, [o, i, s, x, c, n, r, p, a, A, _, k, O, I, $, P, N]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    w.current = !1;
  }, [x, c]);
  const D = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onKeyDown: k,
    [KG[d]]: (F) => {
      f && r(!1, F.nativeEvent, "reference-press");
    }
  }), [k, r, f, d]), j = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onKeyDown: k,
    onMouseDown() {
      S.current = !0;
    },
    onMouseUp() {
      S.current = !0;
    },
    [GG[c]]: () => {
      w.current = !0;
    }
  }), [k, c]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => a ? {
    reference: D,
    floating: j
  } : {}, [a, D, j]);
}
function YG(e) {
  const {
    open: t = !1,
    onOpenChange: n,
    elements: r
  } = e, i = sg(), o = react__WEBPACK_IMPORTED_MODULE_1__.useRef({}), [a] = react__WEBPACK_IMPORTED_MODULE_1__.useState(() => NG()), s = lg() != null;
  if (true) {
    const m = r.reference;
    m && !Ct(m) && kG("Cannot pass a virtual element to the `elements.reference` option,", "as it must be a real DOM element. Use `refs.setPositionReference()`", "instead.");
  }
  const [l, c] = react__WEBPACK_IMPORTED_MODULE_1__.useState(r.reference), f = Nn((m, y, g) => {
    o.current.openEvent = m ? y : void 0, a.emit("openchange", {
      open: m,
      event: y,
      reason: g,
      nested: s
    }), n == null || n(m, y, g);
  }), d = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    setPositionReference: c
  }), []), p = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    reference: l || r.reference || null,
    floating: r.floating || null,
    domReference: r.reference
  }), [l, r.reference, r.floating]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    dataRef: o,
    open: t,
    onOpenChange: f,
    elements: p,
    events: a,
    floatingId: i,
    refs: d
  }), [t, f, p, a, i, d]);
}
function dg(e) {
  e === void 0 && (e = {});
  const {
    nodeId: t
  } = e, n = YG({
    ...e,
    elements: {
      reference: null,
      floating: null,
      ...e.elements
    }
  }), r = e.rootContext || n, i = r.elements, [o, a] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), [s, l] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null), f = (i == null ? void 0 : i.domReference) || o, d = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), p = ud();
  Nt(() => {
    f && (d.current = f);
  }, [f]);
  const m = vG({
    ...e,
    elements: {
      ...i,
      ...s && {
        reference: s
      }
    }
  }), y = react__WEBPACK_IMPORTED_MODULE_1__.useCallback((S) => {
    const A = Ct(S) ? {
      getBoundingClientRect: () => S.getBoundingClientRect(),
      contextElement: S
    } : S;
    l(A), m.refs.setReference(A);
  }, [m.refs]), g = react__WEBPACK_IMPORTED_MODULE_1__.useCallback((S) => {
    (Ct(S) || S === null) && (d.current = S, a(S)), (Ct(m.refs.reference.current) || m.refs.reference.current === null || // Don't allow setting virtual elements using the old technique back to
    // `null` to support `positionReference` + an unstable `reference`
    // callback ref.
    S !== null && !Ct(S)) && m.refs.setReference(S);
  }, [m.refs]), v = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    ...m.refs,
    setReference: g,
    setPositionReference: y,
    domReference: d
  }), [m.refs, g, y]), x = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    ...m.elements,
    domReference: f
  }), [m.elements, f]), w = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    ...m,
    ...r,
    refs: v,
    elements: x,
    nodeId: t
  }), [m, v, x, t, r]);
  return Nt(() => {
    r.dataRef.current.floatingContext = w;
    const S = p == null ? void 0 : p.nodesRef.current.find((A) => A.id === t);
    S && (S.context = w);
  }), react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    ...m,
    context: w,
    refs: v,
    elements: x
  }), [m, v, x, w]);
}
function qG(e, t) {
  t === void 0 && (t = {});
  const {
    open: n,
    onOpenChange: r,
    events: i,
    dataRef: o,
    elements: a
  } = e, {
    enabled: s = !0,
    visibleOnly: l = !0
  } = t, c = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), f = react__WEBPACK_IMPORTED_MODULE_1__.useRef(), d = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!0);
  react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!s) return;
    const m = Or(a.domReference);
    function y() {
      !n && pn(a.domReference) && a.domReference === Pi(Kn(a.domReference)) && (c.current = !0);
    }
    function g() {
      d.current = !0;
    }
    return m.addEventListener("blur", y), m.addEventListener("keydown", g, !0), () => {
      m.removeEventListener("blur", y), m.removeEventListener("keydown", g, !0);
    };
  }, [a.domReference, n, s]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!s) return;
    function m(y) {
      let {
        reason: g
      } = y;
      (g === "reference-press" || g === "escape-key") && (c.current = !0);
    }
    return i.on("openchange", m), () => {
      i.off("openchange", m);
    };
  }, [i, s]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => () => {
    clearTimeout(f.current);
  }, []);
  const p = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onPointerDown(m) {
      e1(m.nativeEvent) || (d.current = !1);
    },
    onMouseLeave() {
      c.current = !1;
    },
    onFocus(m) {
      if (c.current) return;
      const y = Ao(m.nativeEvent);
      if (l && Ct(y))
        try {
          if (t1() && cD()) throw Error();
          if (!y.matches(":focus-visible")) return;
        } catch {
          if (!d.current && !n1(y))
            return;
        }
      r(!0, m.nativeEvent, "focus");
    },
    onBlur(m) {
      c.current = !1;
      const y = m.relatedTarget, g = m.nativeEvent, v = Ct(y) && y.hasAttribute(js("focus-guard")) && y.getAttribute("data-type") === "outside";
      f.current = window.setTimeout(() => {
        var x;
        const w = Pi(a.domReference ? a.domReference.ownerDocument : document);
        !y && w === a.domReference || hn((x = o.current.floatingContext) == null ? void 0 : x.refs.floating.current, w) || hn(a.domReference, w) || v || r(!1, g, "focus");
      });
    }
  }), [o, a.domReference, r, l]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => s ? {
    reference: p
  } : {}, [s, p]);
}
const zT = "active", VT = "selected";
function Jv(e, t, n) {
  const r = /* @__PURE__ */ new Map(), i = n === "item";
  let o = e;
  if (i && e) {
    const {
      [zT]: a,
      [VT]: s,
      ...l
    } = e;
    o = l;
  }
  return {
    ...n === "floating" && {
      tabIndex: -1,
      [b0]: ""
    },
    ...o,
    ...t.map((a) => {
      const s = a ? a[n] : null;
      return typeof s == "function" ? e ? s(e) : null : s;
    }).concat(e).reduce((a, s) => (s && Object.entries(s).forEach((l) => {
      let [c, f] = l;
      if (!(i && [zT, VT].includes(c)))
        if (c.indexOf("on") === 0) {
          if (r.has(c) || r.set(c, []), typeof f == "function") {
            var d;
            (d = r.get(c)) == null || d.push(f), a[c] = function() {
              for (var p, m = arguments.length, y = new Array(m), g = 0; g < m; g++)
                y[g] = arguments[g];
              return (p = r.get(c)) == null ? void 0 : p.map((v) => v(...y)).find((v) => v !== void 0);
            };
          }
        } else
          a[c] = f;
    }), a), {})
  };
}
function hg(e) {
  e === void 0 && (e = []);
  const t = e.map((s) => s == null ? void 0 : s.reference), n = e.map((s) => s == null ? void 0 : s.floating), r = e.map((s) => s == null ? void 0 : s.item), i = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(
    (s) => Jv(s, e, "reference"),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    t
  ), o = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(
    (s) => Jv(s, e, "floating"),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    n
  ), a = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(
    (s) => Jv(s, e, "item"),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    r
  );
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    getReferenceProps: i,
    getFloatingProps: o,
    getItemProps: a
  }), [i, o, a]);
}
let UT = !1;
function pg(e, t, n) {
  switch (e) {
    case "vertical":
      return t;
    case "horizontal":
      return n;
    default:
      return t || n;
  }
}
function HT(e, t) {
  return pg(t, e === l1 || e === cd, e === Ea || e === ka);
}
function Qv(e, t, n) {
  return pg(t, e === cd, n ? e === Ea : e === ka) || e === "Enter" || e === " " || e === "";
}
function XG(e, t, n) {
  return pg(t, n ? e === Ea : e === ka, e === cd);
}
function KT(e, t, n) {
  return pg(t, n ? e === ka : e === Ea, e === l1);
}
function ZG(e, t) {
  const {
    open: n,
    onOpenChange: r,
    elements: i
  } = e, {
    listRef: o,
    activeIndex: a,
    onNavigate: s = () => {
    },
    enabled: l = !0,
    selectedIndex: c = null,
    allowEscape: f = !1,
    loop: d = !1,
    nested: p = !1,
    rtl: m = !1,
    virtual: y = !1,
    focusItemOnOpen: g = "auto",
    focusItemOnHover: v = !0,
    openOnArrowKeyDown: x = !0,
    disabledIndices: w = void 0,
    orientation: S = "vertical",
    cols: A = 1,
    scrollItemIntoView: _ = !0,
    virtualItemRef: O,
    itemSizes: P,
    dense: C = !1
  } = t;
   true && (f && (d || op("`useListNavigation` looping must be enabled to allow escaping."), y || op("`useListNavigation` must be virtual to allow escaping.")), S === "vertical" && A > 1 && op("In grid list navigation mode (`cols` > 1), the `orientation` should", 'be either "horizontal" or "both".'));
  const k = MD(i.floating), I = Yn(k), $ = lg(), N = ud(), D = Nn(s), j = m0(i.domReference), F = react__WEBPACK_IMPORTED_MODULE_1__.useRef(g), W = react__WEBPACK_IMPORTED_MODULE_1__.useRef(c ?? -1), z = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), H = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!0), U = react__WEBPACK_IMPORTED_MODULE_1__.useRef(D), V = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!!i.floating), Y = react__WEBPACK_IMPORTED_MODULE_1__.useRef(n), Q = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), ne = react__WEBPACK_IMPORTED_MODULE_1__.useRef(!1), re = Yn(w), ce = Yn(n), oe = Yn(_), fe = Yn(c), [ae, ee] = react__WEBPACK_IMPORTED_MODULE_1__.useState(), [se, ge] = react__WEBPACK_IMPORTED_MODULE_1__.useState(), X = Nn(function(Ie, ct, Oe) {
    Oe === void 0 && (Oe = !1);
    function Ge(mt) {
      y ? (ee(mt.id), N == null || N.events.emit("virtualfocus", mt), O && (O.current = mt)) : xa(mt, {
        preventScroll: !0,
        // Mac Safari does not move the virtual cursor unless the focus call
        // is sync. However, for the very first focus call, we need to wait
        // for the position to be ready in order to prevent unwanted
        // scrolling. This means the virtual cursor will not move to the first
        // item when first opening the floating element, but will on
        // subsequent calls. `preventScroll` is supported in modern Safari,
        // so we can use that instead.
        // iOS Safari must be async or the first item will not be focused.
        sync: cD() && t1() ? UT || Q.current : !1
      });
    }
    const Zt = Ie.current[ct.current];
    Zt && Ge(Zt), requestAnimationFrame(() => {
      const mt = Ie.current[ct.current] || Zt;
      if (!mt) return;
      Zt || Ge(mt);
      const en = oe.current;
      en && de && (Oe || !H.current) && (mt.scrollIntoView == null || mt.scrollIntoView(typeof en == "boolean" ? {
        block: "nearest",
        inline: "nearest"
      } : en));
    });
  });
  Nt(() => {
    document.createElement("div").focus({
      get preventScroll() {
        return UT = !0, !1;
      }
    });
  }, []), Nt(() => {
    l && (n && i.floating ? F.current && c != null && (ne.current = !0, W.current = c, D(c)) : V.current && (W.current = -1, U.current(null)));
  }, [l, n, i.floating, c, D]), Nt(() => {
    if (l && n && i.floating)
      if (a == null) {
        if (Q.current = !1, fe.current != null)
          return;
        if (V.current && (W.current = -1, X(o, W)), (!Y.current || !V.current) && F.current && (z.current != null || F.current === !0 && z.current == null)) {
          let Ie = 0;
          const ct = () => {
            o.current[0] == null ? (Ie < 2 && (Ie ? requestAnimationFrame : queueMicrotask)(ct), Ie++) : (W.current = z.current == null || Qv(z.current, S, m) || p ? Yv(o, re.current) : CT(o, re.current), z.current = null, D(W.current));
          };
          ct();
        }
      } else Uu(o, a) || (W.current = a, X(o, W, ne.current), ne.current = !1);
  }, [l, n, i.floating, a, fe, p, o, S, m, D, X, re]), Nt(() => {
    var Ie;
    if (!l || i.floating || !N || y || !V.current)
      return;
    const ct = N.nodesRef.current, Oe = (Ie = ct.find((mt) => mt.id === $)) == null || (Ie = Ie.context) == null ? void 0 : Ie.elements.floating, Ge = Pi(Kn(i.floating)), Zt = ct.some((mt) => mt.context && hn(mt.context.elements.floating, Ge));
    Oe && !Zt && H.current && Oe.focus({
      preventScroll: !0
    });
  }, [l, i.floating, N, $, y]), Nt(() => {
    if (!l || !N || !y || $) return;
    function Ie(ct) {
      ge(ct.id), O && (O.current = ct);
    }
    return N.events.on("virtualfocus", Ie), () => {
      N.events.off("virtualfocus", Ie);
    };
  }, [l, N, y, $, O]), Nt(() => {
    U.current = D, V.current = !!i.floating;
  }), Nt(() => {
    n || (z.current = null);
  }, [n]), Nt(() => {
    Y.current = n;
  }, [n]);
  const $e = a != null, de = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => {
    function Ie(Oe) {
      if (!n) return;
      const Ge = o.current.indexOf(Oe);
      Ge !== -1 && D(Ge);
    }
    return {
      onFocus(Oe) {
        let {
          currentTarget: Ge
        } = Oe;
        Ie(Ge);
      },
      onClick: (Oe) => {
        let {
          currentTarget: Ge
        } = Oe;
        return Ge.focus({
          preventScroll: !0
        });
      },
      // Safari
      ...v && {
        onMouseMove(Oe) {
          let {
            currentTarget: Ge
          } = Oe;
          Ie(Ge);
        },
        onPointerLeave(Oe) {
          let {
            pointerType: Ge
          } = Oe;
          !H.current || Ge === "touch" || (W.current = -1, X(o, W), D(null), y || xa(I.current, {
            preventScroll: !0
          }));
        }
      }
    };
  }, [n, I, X, v, o, D, y]), ke = Nn((Ie) => {
    if (H.current = !1, Q.current = !0, Ie.which === 229 || !ce.current && Ie.currentTarget === I.current)
      return;
    if (p && KT(Ie.key, S, m)) {
      Un(Ie), r(!1, Ie.nativeEvent, "list-navigation"), pn(i.domReference) && (y ? N == null || N.events.emit("virtualfocus", i.domReference) : i.domReference.focus());
      return;
    }
    const ct = W.current, Oe = Yv(o, w), Ge = CT(o, w);
    if (j || (Ie.key === "Home" && (Un(Ie), W.current = Oe, D(W.current)), Ie.key === "End" && (Un(Ie), W.current = Ge, D(W.current))), A > 1) {
      const Zt = P || Array.from({
        length: o.current.length
      }, () => ({
        width: 1,
        height: 1
      })), mt = OG(Zt, A, C), en = mt.findIndex((yn) => yn != null && !ip(o.current, yn, w)), Yr = mt.reduce((yn, mr, tt) => mr != null && !ip(o.current, mr, w) ? tt : yn, -1), Cn = mt[SG({
        current: mt.map((yn) => yn != null ? o.current[yn] : null)
      }, {
        event: Ie,
        orientation: S,
        loop: d,
        rtl: m,
        cols: A,
        // treat undefined (empty grid spaces) as disabled indices so we
        // don't end up in them
        disabledIndices: TG([...w || o.current.map((yn, mr) => ip(o.current, mr) ? mr : void 0), void 0], mt),
        minIndex: en,
        maxIndex: Yr,
        prevIndex: AG(
          W.current > Ge ? Oe : W.current,
          Zt,
          mt,
          A,
          // use a corner matching the edge closest to the direction
          // we're moving in so we don't end up in the same item. Prefer
          // top/left over bottom/right.
          Ie.key === cd ? "bl" : Ie.key === (m ? Ea : ka) ? "tr" : "tl"
        ),
        stopEvent: !0
      })];
      if (Cn != null && (W.current = Cn, D(W.current)), S === "both")
        return;
    }
    if (HT(Ie.key, S)) {
      if (Un(Ie), n && !y && Pi(Ie.currentTarget.ownerDocument) === Ie.currentTarget) {
        W.current = Qv(Ie.key, S, m) ? Oe : Ge, D(W.current);
        return;
      }
      Qv(Ie.key, S, m) ? d ? W.current = ct >= Ge ? f && ct !== o.current.length ? -1 : Oe : Qn(o, {
        startingIndex: ct,
        disabledIndices: w
      }) : W.current = Math.min(Ge, Qn(o, {
        startingIndex: ct,
        disabledIndices: w
      })) : d ? W.current = ct <= Oe ? f && ct !== -1 ? o.current.length : Ge : Qn(o, {
        startingIndex: ct,
        decrement: !0,
        disabledIndices: w
      }) : W.current = Math.max(Oe, Qn(o, {
        startingIndex: ct,
        decrement: !0,
        disabledIndices: w
      })), Uu(o, W.current) ? D(null) : D(W.current);
    }
  }), it = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => y && n && $e && {
    "aria-activedescendant": se || ae
  }, [y, n, $e, se, ae]), lt = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    "aria-orientation": S === "both" ? void 0 : S,
    ...!m0(i.domReference) && it,
    onKeyDown: ke,
    onPointerMove() {
      H.current = !0;
    }
  }), [it, ke, i.domReference, S]), Xn = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => {
    function Ie(Oe) {
      g === "auto" && lD(Oe.nativeEvent) && (F.current = !0);
    }
    function ct(Oe) {
      F.current = g, g === "auto" && e1(Oe.nativeEvent) && (F.current = !0);
    }
    return {
      ...it,
      onKeyDown(Oe) {
        H.current = !1;
        const Ge = Oe.key.startsWith("Arrow"), Zt = ["Home", "End"].includes(Oe.key), mt = Ge || Zt, en = XG(Oe.key, S, m), Yr = KT(Oe.key, S, m), Cn = HT(Oe.key, S), yn = (p ? en : Cn) || Oe.key === "Enter" || Oe.key.trim() === "";
        if (y && n) {
          const St = N == null ? void 0 : N.nodesRef.current.find((qr) => qr.parentId == null), jn = N && St ? jG(N.nodesRef.current, St.id) : null;
          if (mt && jn && O) {
            const qr = new KeyboardEvent("keydown", {
              key: Oe.key,
              bubbles: !0
            });
            if (en || Yr) {
              var mr, tt;
              const lo = ((mr = jn.context) == null ? void 0 : mr.elements.domReference) === Oe.currentTarget, un = Yr && !lo ? (tt = jn.context) == null ? void 0 : tt.elements.domReference : en ? o.current.find((Pr) => (Pr == null ? void 0 : Pr.id) === ae) : null;
              un && (Un(Oe), un.dispatchEvent(qr), ge(void 0));
            }
            if ((Cn || Zt) && jn.context && jn.context.open && jn.parentId && Oe.currentTarget !== jn.context.elements.domReference) {
              var Kt;
              Un(Oe), (Kt = jn.context.elements.domReference) == null || Kt.dispatchEvent(qr);
              return;
            }
          }
          return ke(Oe);
        }
        if (!(!n && !x && Ge)) {
          if (yn && (z.current = p && Cn ? null : Oe.key), p) {
            en && (Un(Oe), n ? (W.current = Yv(o, re.current), D(W.current)) : r(!0, Oe.nativeEvent, "list-navigation"));
            return;
          }
          Cn && (c != null && (W.current = c), Un(Oe), !n && x ? r(!0, Oe.nativeEvent, "list-navigation") : ke(Oe), n && D(W.current));
        }
      },
      onFocus() {
        n && !y && D(null);
      },
      onPointerDown: ct,
      onMouseDown: Ie,
      onClick: Ie
    };
  }, [ae, it, ke, re, g, o, p, D, r, n, x, S, m, c, N, y, O]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => l ? {
    reference: Xn,
    floating: lt,
    item: de
  } : {}, [l, Xn, lt, de]);
}
const JG = /* @__PURE__ */ new Map([["select", "listbox"], ["combobox", "listbox"], ["label", !1]]);
function u1(e, t) {
  var n;
  t === void 0 && (t = {});
  const {
    open: r,
    floatingId: i
  } = e, {
    enabled: o = !0,
    role: a = "dialog"
  } = t, s = (n = JG.get(a)) != null ? n : a, l = sg(), f = lg() != null, d = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => s === "tooltip" || a === "label" ? {
    ["aria-" + (a === "label" ? "labelledby" : "describedby")]: r ? i : void 0
  } : {
    "aria-expanded": r ? "true" : "false",
    "aria-haspopup": s === "alertdialog" ? "dialog" : s,
    "aria-controls": r ? i : void 0,
    ...s === "listbox" && {
      role: "combobox"
    },
    ...s === "menu" && {
      id: l
    },
    ...s === "menu" && f && {
      role: "menuitem"
    },
    ...a === "select" && {
      "aria-autocomplete": "none"
    },
    ...a === "combobox" && {
      "aria-autocomplete": "list"
    }
  }, [s, i, f, r, l, a]), p = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => {
    const y = {
      id: i,
      ...s && {
        role: s
      }
    };
    return s === "tooltip" || a === "label" ? y : {
      ...y,
      ...s === "menu" && {
        "aria-labelledby": l
      }
    };
  }, [s, i, l, a]), m = react__WEBPACK_IMPORTED_MODULE_1__.useCallback((y) => {
    let {
      active: g,
      selected: v
    } = y;
    const x = {
      role: "option",
      ...g && {
        id: i + "-option"
      }
    };
    switch (a) {
      case "select":
        return {
          ...x,
          "aria-selected": g && v
        };
      case "combobox":
        return {
          ...x,
          ...g && {
            "aria-selected": !0
          }
        };
    }
    return {};
  }, [i, a]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => o ? {
    reference: d,
    floating: p,
    item: m
  } : {}, [o, d, p, m]);
}
const GT = (e) => e.replace(/[A-Z]+(?![a-z])|[A-Z]/g, (t, n) => (n ? "-" : "") + t.toLowerCase());
function wl(e, t) {
  return typeof e == "function" ? e(t) : e;
}
function QG(e, t) {
  const [n, r] = react__WEBPACK_IMPORTED_MODULE_1__.useState(e);
  return e && !n && r(!0), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    if (!e && n) {
      const i = setTimeout(() => r(!1), t);
      return () => clearTimeout(i);
    }
  }, [e, n, t]), n;
}
function eY(e, t) {
  t === void 0 && (t = {});
  const {
    open: n,
    elements: {
      floating: r
    }
  } = e, {
    duration: i = 250
  } = t, a = (typeof i == "number" ? i : i.close) || 0, [s, l] = react__WEBPACK_IMPORTED_MODULE_1__.useState("unmounted"), c = QG(n, a);
  return !c && s === "close" && l("unmounted"), Nt(() => {
    if (r) {
      if (n) {
        l("initial");
        const f = requestAnimationFrame(() => {
          l("open");
        });
        return () => {
          cancelAnimationFrame(f);
        };
      }
      l("close");
    }
  }, [n, r]), {
    isMounted: c,
    status: s
  };
}
function ND(e, t) {
  t === void 0 && (t = {});
  const {
    initial: n = {
      opacity: 0
    },
    open: r,
    close: i,
    common: o,
    duration: a = 250
  } = t, s = e.placement, l = s.split("-")[0], c = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    side: l,
    placement: s
  }), [l, s]), f = typeof a == "number", d = (f ? a : a.open) || 0, p = (f ? a : a.close) || 0, [m, y] = react__WEBPACK_IMPORTED_MODULE_1__.useState(() => ({
    ...wl(o, c),
    ...wl(n, c)
  })), {
    isMounted: g,
    status: v
  } = eY(e, {
    duration: a
  }), x = Yn(n), w = Yn(r), S = Yn(i), A = Yn(o);
  return Nt(() => {
    const _ = wl(x.current, c), O = wl(S.current, c), P = wl(A.current, c), C = wl(w.current, c) || Object.keys(_).reduce((k, I) => (k[I] = "", k), {});
    if (v === "initial" && y((k) => ({
      transitionProperty: k.transitionProperty,
      ...P,
      ..._
    })), v === "open" && y({
      transitionProperty: Object.keys(C).map(GT).join(","),
      transitionDuration: d + "ms",
      ...P,
      ...C
    }), v === "close") {
      const k = O || _;
      y({
        transitionProperty: Object.keys(k).map(GT).join(","),
        transitionDuration: p + "ms",
        ...P,
        ...k
      });
    }
  }, [p, S, x, w, A, d, v, c]), {
    isMounted: g,
    styles: m
  };
}
function tY(e, t) {
  var n;
  const {
    open: r,
    dataRef: i
  } = e, {
    listRef: o,
    activeIndex: a,
    onMatch: s,
    onTypingChange: l,
    enabled: c = !0,
    findMatch: f = null,
    resetMs: d = 750,
    ignoreKeys: p = [],
    selectedIndex: m = null
  } = t, y = react__WEBPACK_IMPORTED_MODULE_1__.useRef(), g = react__WEBPACK_IMPORTED_MODULE_1__.useRef(""), v = react__WEBPACK_IMPORTED_MODULE_1__.useRef((n = m ?? a) != null ? n : -1), x = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null), w = Nn(s), S = Nn(l), A = Yn(f), _ = Yn(p);
  Nt(() => {
    r && (clearTimeout(y.current), x.current = null, g.current = "");
  }, [r]), Nt(() => {
    if (r && g.current === "") {
      var I;
      v.current = (I = m ?? a) != null ? I : -1;
    }
  }, [r, m, a]);
  const O = Nn((I) => {
    I ? i.current.typing || (i.current.typing = I, S(I)) : i.current.typing && (i.current.typing = I, S(I));
  }), P = Nn((I) => {
    function $(W, z, H) {
      const U = A.current ? A.current(z, H) : z.find((V) => (V == null ? void 0 : V.toLocaleLowerCase().indexOf(H.toLocaleLowerCase())) === 0);
      return U ? W.indexOf(U) : -1;
    }
    const N = o.current;
    if (g.current.length > 0 && g.current[0] !== " " && ($(N, N, g.current) === -1 ? O(!1) : I.key === " " && Un(I)), N == null || _.current.includes(I.key) || // Character key.
    I.key.length !== 1 || // Modifier key.
    I.ctrlKey || I.metaKey || I.altKey)
      return;
    r && I.key !== " " && (Un(I), O(!0)), N.every((W) => {
      var z, H;
      return W ? ((z = W[0]) == null ? void 0 : z.toLocaleLowerCase()) !== ((H = W[1]) == null ? void 0 : H.toLocaleLowerCase()) : !0;
    }) && g.current === I.key && (g.current = "", v.current = x.current), g.current += I.key, clearTimeout(y.current), y.current = setTimeout(() => {
      g.current = "", v.current = x.current, O(!1);
    }, d);
    const j = v.current, F = $(N, [...N.slice((j || 0) + 1), ...N.slice(0, (j || 0) + 1)], g.current);
    F !== -1 ? (w(F), x.current = F) : I.key !== " " && (g.current = "", O(!1));
  }), C = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onKeyDown: P
  }), [P]), k = react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => ({
    onKeyDown: P,
    onKeyUp(I) {
      I.key === " " && O(!1);
    }
  }), [P, O]);
  return react__WEBPACK_IMPORTED_MODULE_1__.useMemo(() => c ? {
    reference: C,
    floating: k
  } : {}, [c, C, k]);
}
function YT(e, t) {
  const [n, r] = e;
  let i = !1;
  const o = t.length;
  for (let a = 0, s = o - 1; a < o; s = a++) {
    const [l, c] = t[a] || [0, 0], [f, d] = t[s] || [0, 0];
    c >= r != d >= r && n <= (f - l) * (r - c) / (d - c) + l && (i = !i);
  }
  return i;
}
function nY(e, t) {
  return e[0] >= t.x && e[0] <= t.x + t.width && e[1] >= t.y && e[1] <= t.y + t.height;
}
function rY(e) {
  e === void 0 && (e = {});
  const {
    buffer: t = 0.5,
    blockPointerEvents: n = !1,
    requireIntent: r = !0
  } = e;
  let i, o = !1, a = null, s = null, l = performance.now();
  function c(d, p) {
    const m = performance.now(), y = m - l;
    if (a === null || s === null || y === 0)
      return a = d, s = p, l = m, null;
    const g = d - a, v = p - s, w = Math.sqrt(g * g + v * v) / y;
    return a = d, s = p, l = m, w;
  }
  const f = (d) => {
    let {
      x: p,
      y: m,
      placement: y,
      elements: g,
      onClose: v,
      nodeId: x,
      tree: w
    } = d;
    return function(A) {
      function _() {
        clearTimeout(i), v();
      }
      if (clearTimeout(i), !g.domReference || !g.floating || y == null || p == null || m == null)
        return;
      const {
        clientX: O,
        clientY: P
      } = A, C = [O, P], k = Ao(A), I = A.type === "mouseleave", $ = hn(g.floating, k), N = hn(g.domReference, k), D = g.domReference.getBoundingClientRect(), j = g.floating.getBoundingClientRect(), F = y.split("-")[0], W = p > j.right - j.width / 2, z = m > j.bottom - j.height / 2, H = nY(C, D), U = j.width > D.width, V = j.height > D.height, Y = (U ? D : j).left, Q = (U ? D : j).right, ne = (V ? D : j).top, re = (V ? D : j).bottom;
      if ($ && (o = !0, !I))
        return;
      if (N && (o = !1), N && !I) {
        o = !0;
        return;
      }
      if (I && Ct(A.relatedTarget) && hn(g.floating, A.relatedTarget) || w && Cs(w.nodesRef.current, x).some((fe) => {
        let {
          context: ae
        } = fe;
        return ae == null ? void 0 : ae.open;
      }))
        return;
      if (F === "top" && m >= D.bottom - 1 || F === "bottom" && m <= D.top + 1 || F === "left" && p >= D.right - 1 || F === "right" && p <= D.left + 1)
        return _();
      let ce = [];
      switch (F) {
        case "top":
          ce = [[Y, D.top + 1], [Y, j.bottom - 1], [Q, j.bottom - 1], [Q, D.top + 1]];
          break;
        case "bottom":
          ce = [[Y, j.top + 1], [Y, D.bottom - 1], [Q, D.bottom - 1], [Q, j.top + 1]];
          break;
        case "left":
          ce = [[j.right - 1, re], [j.right - 1, ne], [D.left + 1, ne], [D.left + 1, re]];
          break;
        case "right":
          ce = [[D.right - 1, re], [D.right - 1, ne], [j.left + 1, ne], [j.left + 1, re]];
          break;
      }
      function oe(fe) {
        let [ae, ee] = fe;
        switch (F) {
          case "top": {
            const se = [U ? ae + t / 2 : W ? ae + t * 4 : ae - t * 4, ee + t + 1], ge = [U ? ae - t / 2 : W ? ae + t * 4 : ae - t * 4, ee + t + 1], X = [[j.left, W || U ? j.bottom - t : j.top], [j.right, W ? U ? j.bottom - t : j.top : j.bottom - t]];
            return [se, ge, ...X];
          }
          case "bottom": {
            const se = [U ? ae + t / 2 : W ? ae + t * 4 : ae - t * 4, ee - t], ge = [U ? ae - t / 2 : W ? ae + t * 4 : ae - t * 4, ee - t], X = [[j.left, W || U ? j.top + t : j.bottom], [j.right, W ? U ? j.top + t : j.bottom : j.top + t]];
            return [se, ge, ...X];
          }
          case "left": {
            const se = [ae + t + 1, V ? ee + t / 2 : z ? ee + t * 4 : ee - t * 4], ge = [ae + t + 1, V ? ee - t / 2 : z ? ee + t * 4 : ee - t * 4];
            return [...[[z || V ? j.right - t : j.left, j.top], [z ? V ? j.right - t : j.left : j.right - t, j.bottom]], se, ge];
          }
          case "right": {
            const se = [ae - t, V ? ee + t / 2 : z ? ee + t * 4 : ee - t * 4], ge = [ae - t, V ? ee - t / 2 : z ? ee + t * 4 : ee - t * 4], X = [[z || V ? j.left + t : j.right, j.top], [z ? V ? j.left + t : j.right : j.left + t, j.bottom]];
            return [se, ge, ...X];
          }
        }
      }
      if (!YT([O, P], ce)) {
        if (o && !H)
          return _();
        if (!I && r) {
          const fe = c(A.clientX, A.clientY);
          if (fe !== null && fe < 0.1)
            return _();
        }
        YT([O, P], oe([p, m])) ? !o && r && (i = window.setTimeout(_, 40)) : _();
      }
    };
  };
  return f.__options = {
    blockPointerEvents: n
  }, f;
}
const fd = "light", $D = "neutral", iY = "button", oY = ({
  theme: e = fd,
  variant: t = $D
}) => {
  let n = e === "light" ? "text-icon-secondary" : "text-icon-inverse";
  return n = {
    info: e === "light" ? "text-support-info" : "text-support-info-inverse",
    success: e === "light" ? "text-support-success" : "text-support-success-inverse",
    warning: e === "light" ? "text-support-warning" : "text-support-warning-inverse",
    error: e === "light" ? "text-support-error" : "text-support-error-inverse"
  }[t] || n, n;
}, wp = ({
  icon: e,
  theme: t = fd,
  variant: n = $D
}) => {
  var a;
  const r = "[&>svg]:h-5 [&>svg]:w-5", i = oY({ theme: t, variant: n });
  if (e && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e))
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(e, {
      className: K(
        r,
        i,
        ((a = e == null ? void 0 : e.props) == null ? void 0 : a.className) ?? ""
      )
    });
  const o = {
    neutral: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(f0, { className: K(r, i) }),
    info: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(f0, { className: K(r, i) }),
    success: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(sd, { className: K(r, i) }),
    warning: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(iK, { className: K(r, i) }),
    error: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(nK, { className: K(r, i) })
  };
  return o[n] || o.neutral;
}, x0 = ({
  actionType: e = iY,
  onAction: t = () => {
  },
  actionLabel: n = "",
  theme: r = fd
}) => {
  const i = "focus:ring-0 focus:ring-offset-0 ring-offset-0 focus:outline-none";
  let o = "text-button-primary border-button-primary hover:border-button-primary hover:text-button-primary-hover";
  switch (r === "dark" && (o = "text-text-inverse border-text-inverse hover:border-text-inverse hover:text-text-inverse"), e) {
    case "button":
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        Hn,
        {
          variant: "outline",
          size: "xs",
          onClick: t,
          className: K(
            "rounded",
            i,
            o,
            r === "dark" ? "bg-transparent hover:bg-transparent" : "bg-white hover:bg-white"
          ),
          children: n
        }
      );
    case "link":
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        Hn,
        {
          variant: "link",
          size: "xs",
          onClick: t,
          className: K(i, o),
          children: n
        }
      );
    default:
      return null;
  }
}, _p = ({
  theme: e = fd,
  title: t = "",
  inline: n = !1
}) => t ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "span",
  {
    className: K(
      "block",
      {
        light: "text-text-primary",
        dark: "text-text-inverse"
      }[e],
      "text-sm leading-5 font-semibold",
      n ? "inline" : "block"
    ),
    children: t
  }
) : null, Sp = ({
  theme: e = fd,
  content: t = "",
  inline: n = !1
}) => t ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "span",
  {
    className: K(
      {
        light: "text-text-primary",
        dark: "text-text-inverse"
      }[e],
      "block text-sm [&_*]:text-sm leading-5 [&_*]:leading-5 font-normal",
      n ? "inline" : "block"
    ),
    children: t
  }
) : null, w0 = (...e) => (t) => {
  e.forEach((n) => {
    typeof n == "function" ? n(t) : n && (n.current = t);
  });
}, f1 = ({
  variant: e = "dark",
  // 'light' | 'dark';
  placement: t = "bottom",
  //  | 'top' | 'top-start' | 'top-end' | 'right' | 'right-start' | 'right-end' | 'bottom' | 'bottom-start' | 'bottom-end' | 'left' | 'left-start' | 'left-end';
  title: n = "",
  content: r,
  arrow: i = !1,
  open: o,
  setOpen: a,
  children: s,
  className: l,
  tooltipPortalRoot: c,
  // Root element where the dropdown will be rendered.
  tooltipPortalId: f,
  // Id of the dropdown portal where the dropdown will be rendered.
  boundary: d = "clippingAncestors",
  strategy: p = "fixed",
  // 'fixed' | 'absolute';
  offset: m = 8,
  // Offset option or number value. Default is 8.
  triggers: y = ["hover", "focus"],
  // 'click' | 'hover' | 'focus';
  interactive: g = !1
}) => {
  const v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => typeof o == "boolean" && typeof a == "function",
    [o, a]
  ), [x, w] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), S = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), { refs: A, floatingStyles: _, context: O } = dg({
    open: v ? o : x,
    onOpenChange: v ? a : w,
    placement: t,
    strategy: p,
    middleware: [
      og(m),
      ag({ boundary: d }),
      // Ensure this is correctly cast
      _D({ boundary: d }),
      // Ensure this is correctly cast
      xG({ element: S })
    ],
    whileElementsMounted: ig
  }), P = c1(O, {
    enabled: !v && y.includes("click")
  }), C = IG(O, {
    move: !1,
    enabled: !v && y.includes("hover"),
    ...g && { handleClose: rY() }
  }), k = qG(O, {
    enabled: !v && y.includes("focus")
  }), I = fg(O), $ = u1(O, { role: "tooltip" }), { getReferenceProps: N, getFloatingProps: D } = hg([
    P,
    C,
    k,
    I,
    $
  ]), { isMounted: j, styles: F } = ND(O, {
    duration: 150,
    initial: { opacity: 0 },
    open: { opacity: 1 },
    close: { opacity: 0 }
  }), W = "absolute z-20 py-2 px-3 rounded-md text-xs leading-4 shadow-soft-shadow-lg", z = {
    light: "bg-tooltip-background-light text-text-primary",
    dark: "bg-tooltip-background-dark text-text-on-color"
  }[e], H = e === "dark" ? "text-tooltip-background-dark" : "text-tooltip-background-light";
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: [
    (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(s) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(s, {
      ref: w0(
        s.ref,
        A.setReference
      ),
      className: K(s.props.className),
      ...N()
    }) }, "tooltip-reference"),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ug, { id: f, root: c, children: j && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        className: K(
          W,
          z,
          "max-w-80 w-fit",
          l
        ),
        ref: A.setFloating,
        style: {
          ..._,
          ...F
        },
        ...D(),
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [
            !!n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              "span",
              {
                className: "font-semibold",
                children: n
              },
              "tooltip-title"
            ),
            !!r && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              "div",
              {
                className: "font-normal",
                children: r
              },
              "tooltip-content"
            )
          ] }),
          i && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            MG,
            {
              ref: S,
              context: O,
              className: K("fill-current", H)
            }
          )
        ]
      }
    ) })
  ] });
};
f1.displayName = "Tooltip";
const DD = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), ID = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(DD), RD = ({
  children: e,
  name: t,
  style: n = "simple",
  size: r = "md",
  value: i,
  defaultValue: o,
  by: a = "id",
  as: s = "div",
  onChange: l,
  className: c,
  disableGroup: f = !1,
  vertical: d = !1,
  columns: p = 4,
  multiSelection: m = !1,
  gapClassName: y = "gap-2"
}) => {
  const g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof i < "u", [i]), v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => t || `radio-button-group-${io()}`,
    [t]
  );
  let x;
  g ? x = i : m ? x = o ?? [] : x = o;
  const [w, S] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(x), A = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (P) => {
      if (m)
        S((C) => {
          const k = Array.isArray(C) && typeof P == "string" && C.includes(P);
          let I;
          return k ? I = C.filter(
            ($) => $ !== P
          ) : I = [
            ...Array.isArray(C) ? C : [],
            ...typeof P == "string" ? [P] : []
          ], typeof l == "function" && l(I), I;
        });
      else {
        if (g || S(P), typeof l != "function")
          return;
        l(P);
      }
    },
    [l]
  );
  c = K(
    "grid grid-cols-4",
    BH[p],
    y,
    n === "tile" && "gap-0",
    d && "grid-cols-1",
    c
  );
  const _ = K(
    n === "tile" ? "border border-border-subtle border-solid rounded-md shadow-sm" : "gap-6",
    c
  ), O = () => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    DD.Provider,
    {
      value: {
        name: v,
        value: g ? i : w,
        by: a,
        onChange: A,
        isControlled: g,
        disableAll: f,
        style: n,
        columns: p,
        multiSelection: m,
        size: r
      },
      children: react__WEBPACK_IMPORTED_MODULE_1__.Children.map(e, (P) => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(P) ? P : null)
    }
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: n === "tile" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _, children: O() }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(s, { ...s === react__WEBPACK_IMPORTED_MODULE_1__.Fragment ? {} : { className: c }, children: O() }) });
};
RD.displayName = "RadioButton.Group";
const aY = ({
  id: e,
  label: t,
  value: n,
  children: r,
  disabled: i,
  icon: o = null,
  inlineIcon: a = !1,
  hideSelection: s = !1,
  reversePosition: l = !1,
  borderOn: c = !1,
  borderOnActive: f = !0,
  badgeItem: d = null,
  useSwitch: p = !1,
  info: m = void 0,
  minWidth: y = !0,
  ...g
}, v) => {
  var H, U;
  const { buttonWrapperClasses: x, ...w } = g, S = ID(), {
    name: A,
    value: _,
    by: O,
    onChange: P,
    disableAll: C,
    checked: k,
    multiSelection: I,
    size: $ = "md"
    // Default size to 'md' if not provided
  } = S, N = "primary", D = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `radio-button-${io()}`, [e]), j = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => C || i,
    [C, i]
  ), F = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => I ? Array.isArray(_) && _.includes(n) : typeof k < "u" ? k : typeof _ != typeof n ? !1 : typeof _ == "string" ? _ === n : Array.isArray(_) ? _.includes(n) : _[O] === n[O], [_, n, k]), W = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(t) ? t : t != null && t.heading ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        !a && "space-y-1.5 mt-[2px]",
        l && (p ? "ml-10" : "ml-4"),
        a && "flex gap-2",
        a && !t.description && "items-center"
      ),
      children: [
        o && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: o }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("space-y-1.5"), children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "p",
            {
              className: K(
                "text-text-primary font-medium m-0",
                sK[$],
                i && "text-text-disabled cursor-not-allowed"
              ),
              children: t.heading
            }
          ),
          t.description && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { className: "text-text-tertiary text-sm font-normal leading-5 m-0", children: t.description })
        ] })
      ]
    }
  ) : null, [t]);
  if (S.style === "tile")
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      sY,
      {
        id: e,
        label: t,
        value: n,
        disabled: i,
        size: $,
        children: r
      }
    );
  const z = () => {
    j || (I ? p && P(n, !F) : P(n));
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "label",
    {
      className: K(
        "inline-flex items-center relative cursor-pointer transition-all duration-300",
        !!t && "items-start justify-between",
        y && "min-w-[180px]",
        c && "border border-border-subtle border-solid rounded-md shadow-sm hover:ring-2 hover:ring-border-interactive",
        f && c && F && "ring-2 ring-border-interactive",
        $ === "sm" ? "px-3 py-3" : "px-4 py-4",
        "pr-12",
        j && "cursor-not-allowed opacity-40",
        x
      ),
      htmlFor: D,
      onClick: z,
      children: [
        !!t && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "label",
          {
            className: K(
              "cursor-pointer",
              j && "cursor-not-allowed"
            ),
            htmlFor: D,
            children: W()
          }
        ),
        !!m && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "absolute mr-0.5 bottom-1.5 right-3", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(f1, { title: m == null ? void 0 : m.heading, content: m == null ? void 0 : m.description, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          f0,
          {
            className: K(
              "text-text-primary",
              (H = Uv[$]) == null ? void 0 : H.info
            )
          }
        ) }) }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
          "label",
          {
            className: K(
              "absolute mr-0.5 right-3 flex items-center cursor-pointer rounded-full gap-2",
              l && "left-0",
              j && "cursor-not-allowed",
              a && "mr-3",
              p ? wT[$].switch : wT[$].radio
            ),
            onClick: z,
            children: [
              !!d && d,
              !s && (p ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                J$,
                {
                  defaultValue: !1,
                  size: $,
                  onChange: () => {
                    I ? P(n, !F) : P(n);
                  },
                  checked: F,
                  ...w,
                  "aria-label": (t == null ? void 0 : t.heading) ?? "Switch"
                }
              ) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: "relative p-0.5", children: [
                /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                  "input",
                  {
                    ref: v,
                    id: D,
                    type: I ? "checkbox" : "radio",
                    className: K(
                      "peer flex relative cursor-pointer appearance-none transition-all m-0 before:content-[''] checked:before:content-[''] checked:before:hidden before:hidden !border-1.5 border-solid",
                      !I && "rounded-full",
                      bT[N].checkbox,
                      Uv[$].checkbox,
                      j && xT.checkbox
                    ),
                    name: A,
                    value: n,
                    onChange: (V) => P(V.target.value),
                    checked: F,
                    disabled: j,
                    ...w
                  }
                ),
                /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                  "span",
                  {
                    className: K(
                      "inline-flex items-center absolute top-2/4 left-2/4 -translate-y-2/4 -translate-x-2/4 text-white opacity-0 transition-opacity peer-checked:opacity-100",
                      bT[N].icon,
                      j && xT.icon
                    ),
                    children: I ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                      sd,
                      {
                        className: $ === "sm" ? "size-3" : "size-4"
                      }
                    ) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                      "div",
                      {
                        className: K(
                          "rounded-full bg-current",
                          $ === "sm" && "mt-[0.5px]",
                          (U = Uv[$]) == null ? void 0 : U.icon
                        )
                      }
                    )
                  }
                )
              ] }))
            ]
          }
        )
      ]
    }
  );
}, _0 = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(aY);
_0.displayName = "RadioButton.Button";
const sY = ({
  id: e,
  children: t,
  value: n,
  disabled: r,
  size: i = "md",
  ...o
}) => {
  const a = ID(), {
    name: s,
    value: l,
    by: c,
    onChange: f,
    disableAll: d,
    checked: p
  } = a || {}, m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `radio-button-${io()}`, [e]), y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => d || r,
    [d, r]
  ), g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof p < "u" ? p : typeof l != typeof n ? !1 : typeof l == "string" ? l === n : Array.isArray(l) ? l.includes(n) : l && c ? l[c] === n[c] : !1, [l, n, p, c]), v = () => {
    f && f(n);
  }, w = K(
    uK,
    fK,
    dK,
    y ? "text-text-disabled cursor-not-allowed" : "",
    lK[i],
    cK
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "button",
    {
      type: "button",
      id: m,
      "aria-label": "Radio Button",
      className: K(
        w,
        "first:rounded-tl first:rounded-bl first:border-0 first:border-r first:border-border-subtle last:rounded-tr last:rounded-br last:border-0",
        g && "bg-button-disabled"
      ),
      onClick: v,
      disabled: y,
      ...o,
      children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "input",
          {
            type: "hidden",
            value: n,
            name: s,
            checked: g,
            onChange: (S) => f == null ? void 0 : f(S.target.value)
          }
        ),
        t
      ]
    }
  ) });
}, KEe = Object.assign(_0, {
  Group: RD,
  Button: _0
}), mg = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    label: e = "",
    size: t = "sm",
    // xxs, xs, sm, md, lg
    className: n = "",
    type: r = "pill",
    // pill, rounded
    variant: i = "neutral",
    // neutral, red, yellow, green, blue, inverse
    icon: o = null,
    disabled: a = !1,
    onClose: s = () => {
    },
    closable: l = !1,
    onMouseDown: c = () => {
    },
    disableHover: f = !1
  }, d) => {
    const p = "font-medium border-badge-border-gray flex items-center justify-center border border-solid box-border max-w-full transition-colors duration-150 ease-in-out", m = {
      xxs: "py-0.5 px-0.5 text-xs h-4",
      xs: "py-0.5 px-1 text-xs h-5",
      sm: "py-1 px-1.5 text-xs h-6",
      md: "py-1 px-1.5 text-sm h-7",
      lg: "py-1 px-1.5 text-base h-8"
    }, y = {
      pill: "rounded-full",
      rounded: "rounded"
    }, g = {
      neutral: "hover:bg-badge-hover-gray",
      red: "hover:bg-badge-hover-red",
      yellow: "hover:bg-badge-hover-yellow",
      green: "hover:bg-badge-hover-green",
      blue: "hover:bg-badge-hover-sky",
      inverse: "hover:bg-badge-hover-inverse",
      disabled: "hover:bg-badge-hover-disabled"
    }, v = {
      neutral: "bg-badge-background-gray text-badge-color-gray border-badge-border-gray",
      red: "bg-badge-background-red text-badge-color-red border-badge-border-red",
      yellow: "bg-badge-background-yellow text-badge-color-yellow border-badge-border-yellow",
      green: "bg-badge-background-green text-badge-color-green border-badge-border-green",
      blue: "bg-badge-background-sky text-badge-color-sky border-badge-border-sky",
      inverse: "bg-background-inverse text-text-inverse border-background-inverse",
      disabled: "bg-badge-background-disabled text-badge-color-disabled border-badge-border-disabled disabled cursor-not-allowed"
    };
    let x = "", w = "group relative justify-center flex items-center cursor-pointer";
    const S = {
      xxs: "[&>svg]:size-3",
      xs: "[&>svg]:size-3",
      sm: "[&>svg]:size-3",
      md: "[&>svg]:size-4",
      lg: "[&>svg]:size-5"
    };
    return a ? (x = v.disabled, w += " cursor-not-allowed disabled") : x = v[i], e ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "span",
      {
        className: K(
          p,
          m[t],
          y[r],
          "gap-0.5",
          x,
          !f && g[i],
          n
        ),
        ref: d,
        children: [
          o ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "span",
            {
              className: K(
                "justify-center flex items-center",
                S[t]
              ),
              children: o
            }
          ) : null,
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "px-1 truncate inline-block", children: e }),
          l && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
            "span",
            {
              className: K(w, S[t]),
              onMouseDown: c,
              role: "button",
              tabIndex: 0,
              ...!a && {
                onClick: s
              },
              children: [
                /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "sr-only", children: `Remove ${e}` }),
                /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {}),
                /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "absolute -inset-1" })
              ]
            }
          )
        ]
      }
    ) : null;
  }
);
mg.displayName = "Badge";
const lY = ({
  id: e,
  defaultValue: t = "",
  value: n,
  size: r = "sm",
  // sm, md, lg
  className: i = "",
  disabled: o = !1,
  onChange: a = () => {
  },
  error: s = !1,
  onError: l = () => {
  },
  ...c
}, f) => {
  const d = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `input-textarea-${io()}`, [e]), p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof n < "u", [n]), [m, y] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(t), g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    () => p ? n : m,
    [p, n, m]
  ), v = (P) => {
    if (o)
      return;
    const C = P.target.value;
    p || y(C), typeof a == "function" && a(C);
  }, x = "py-2 rounded border border-solid border-border-subtle bg-field-secondary-background font-normal placeholder-text-tertiary text-text-primary focus:outline-none", w = {
    sm: "px-3 rounded text-xs",
    md: "px-3 rounded-md text-sm",
    lg: "px-4 rounded-lg text-base"
  }, S = o ? "hover:border-border-disabled" : "hover:border-border-strong", A = "focus:border-focus-border focus:ring-2 focus:ring-toggle-on focus:ring-offset-2", _ = s ? "focus:border-focus-error-border focus:ring-field-color-error border-focus-error-border" : "";
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "textarea",
    {
      ref: f,
      id: d,
      className: K(
        x,
        o ? "border-border-disabled bg-field-background-disabled cursor-not-allowed text-text-disabled" : "",
        w[r],
        A,
        S,
        _,
        i
      ),
      disabled: o,
      onChange: v,
      onInvalid: l,
      value: g(),
      ...c
    }
  );
}, cY = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(lY);
cY.displayName = "TextArea";
const GEe = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    variant: e = "primary",
    size: t = "md",
    border: n = "subtle",
    src: r,
    alt: i,
    children: o,
    className: a,
    ...s
  }, l) => {
    const [c, f] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), d = r && n === "none" ? "subtle" : n, p = "rounded-full overflow-hidden flex items-center justify-center", m = {
      white: "text-text-primary bg-background-primary",
      gray: "text-text-primary bg-background-secondary",
      primary: "text-text-on-color bg-background-brand",
      "primary-light": "text-text-primary bg-brand-background-50",
      dark: "text-text-on-color bg-button-secondary"
    }[e], y = {
      xxs: "size-5 [&>svg]:size-3 text-xs",
      xs: "size-6 [&>svg]:size-4 text-sm",
      sm: "size-8 [&>svg]:size-5 text-base",
      md: "size-10 [&>svg]:size-6 text-lg",
      lg: "size-12 [&>svg]:size-12 text-lg"
    }[t], g = {
      none: "",
      subtle: "ring-1 ring-border-transparent-subtle",
      ring: "ring ring-border-subtle"
    }[d], v = r ? "object-cover object-center" : "", x = () => {
      var _, O, P;
      if (r && c) {
        if (i && typeof i == "string")
          return (_ = i == null ? void 0 : i[0]) == null ? void 0 : _.toUpperCase();
        if (o && typeof o == "string")
          return (O = o == null ? void 0 : o[0]) == null ? void 0 : O.toUpperCase();
        if (!o && !i)
          return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(oK, {});
      }
      return o ? typeof o == "string" ? (P = o == null ? void 0 : o[0]) == null ? void 0 : P.toUpperCase() : o : null;
    }, w = () => {
      f(!0);
    }, S = !r || c, A = S ? "div" : "img";
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      f(!1);
    }, [r]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      A,
      {
        ref: l,
        className: K(
          p,
          S && m,
          y,
          g,
          v,
          a
        ),
        ...S ? { children: x() } : { src: r, alt: i, onError: w },
        ...s
      }
    );
  }
), uY = ({
  id: e,
  type: t = "text",
  defaultValue: n = "",
  value: r,
  size: i = "sm",
  // sm, md, lg
  className: o = "",
  disabled: a = !1,
  onChange: s = () => {
  },
  error: l = !1,
  onError: c = () => {
  },
  prefix: f = null,
  suffix: d = null,
  label: p = "",
  ...m
}, y) => {
  const g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `input-${t}-${io()}`, [e]), x = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof r < "u", [r]), [w, S] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(n), [A, _] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), O = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    () => x ? r : w,
    [x, r, w]
  ), P = (ae) => {
    if (a)
      return;
    let ee;
    t === "file" ? (ee = ae.target.files, ee && ee.length > 0 ? _(ee[0].name) : _(null)) : ee = ae.target.value, !x && t !== "file" && S(ee), typeof s == "function" && s(ee);
  }, C = () => {
    _(null), g.current && (g.current.value = ""), s(null);
  }, k = "bg-field-secondary-background font-normal placeholder-text-tertiary text-text-primary w-full outline outline-1 outline-border-subtle border-none transition-[color,box-shadow,outline] duration-200", I = {
    xs: "px-2 py-1 rounded",
    sm: "p-3 py-2 rounded",
    md: "p-3.5 py-2.5 rounded-md",
    lg: "p-4 py-3 rounded-lg"
  }, $ = {
    xs: "text-xs font-medium",
    sm: "text-sm font-medium",
    md: "text-sm font-medium",
    lg: "text-base font-medium"
  }, N = {
    xs: "text-xs",
    sm: "text-xs",
    md: "text-sm",
    lg: "text-base"
  }, D = {
    sm: f ? "pl-8" : "",
    md: f ? "pl-9" : "",
    lg: f ? "pl-10" : ""
  }, j = {
    sm: d ? "pr-8" : "",
    md: d ? "pr-9" : "",
    lg: d ? "pr-10" : ""
  }, F = a ? "hover:outline-border-disabled" : "hover:outline-border-strong", W = "focus:outline-focus-border focus:ring-2 focus:ring-toggle-on focus:ring-offset-2", z = l ? "focus:outline-focus-error-border focus:ring-field-color-error outline-focus-error-border" : "", H = l ? "focus:outline-focus-error-border focus:ring-field-color-error outline-focus-error-border" : "", U = a ? "outline-border-disabled bg-field-background-disabled cursor-not-allowed text-text-disabled" : "", V = a ? "outline-border-disabled cursor-not-allowed text-text-disabled file:text-text-tertiary" : "", Y = "font-normal placeholder-text-tertiary text-text-primary pointer-events-none absolute inset-y-0 flex flex-1 items-center [&>svg]:h-4 [&>svg]:w-4", Q = a ? "font-normal placeholder-text-tertiary text-icon-disabled pointer-events-none absolute inset-y-0 flex flex-1 items-center" : "font-normal placeholder-text-tertiary text-field-placeholder pointer-events-none absolute inset-y-0 flex flex-1 items-center", ne = {
    xs: "[&>svg]:size-4",
    sm: "[&>svg]:size-4",
    md: "[&>svg]:size-5",
    lg: "[&>svg]:size-6"
  }, re = () => f ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K(Y, "left-0 pl-3", N[i]), children: f }) : null, ce = () => t === "file" ? A ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        Q,
        "right-0 pr-3 cursor-pointer z-20 pointer-events-auto",
        ne[i]
      ),
      onClick: C,
      role: "button",
      tabIndex: 0,
      onKeyDown: (ae) => {
        (ae.key === "Enter" || ae.key === " ") && C();
      },
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {})
    }
  ) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        Q,
        "right-0 pr-3",
        ne[i]
      ),
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(vT, {})
    }
  ) : d ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K(Y, "right-0 pr-3", N[i]), children: d }) : null, oe = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => p ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    to,
    {
      className: K($[i]),
      htmlFor: v,
      ...(m == null ? void 0 : m.required) && { required: !0 },
      children: p
    }
  ) : null, [p, i, v]), fe = A ? "file:border-0 file:bg-transparent pr-10" : "text-text-tertiary file:border-0 file:bg-transparent pr-10";
  return t === "file" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex flex-col items-start gap-1.5 [&_*]:box-border box-border", children: [
    oe,
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        className: K(
          "w-full relative flex focus-within:z-10",
          o
        ),
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "input",
            {
              ref: w0(g, y),
              id: v,
              type: "file",
              className: K(
                k,
                V,
                I[i],
                N[i],
                W,
                F,
                H,
                fe
              ),
              disabled: a,
              onChange: P,
              onInvalid: c,
              ...m
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "div",
            {
              className: K(
                Q,
                "right-0 pr-3",
                ne[i]
              ),
              children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(vT, {})
            }
          )
        ]
      }
    )
  ] }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex flex-col items-start gap-1.5 [&_*]:box-border box-border", children: [
    oe,
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        className: K(
          "w-full relative flex focus-within:z-10",
          o
        ),
        children: [
          re(),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "input",
            {
              ref: w0(g, y),
              id: v,
              type: t,
              className: K(
                k,
                U,
                I[i],
                N[i],
                D[i],
                j[i],
                W,
                F,
                z
              ),
              disabled: a,
              onChange: P,
              onInvalid: c,
              value: O(),
              ...m
            }
          ),
          ce()
        ]
      }
    )
  ] });
}, fY = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(uY);
fY.displayName = "Input";
const YEe = ({
  title: e = "",
  description: t = "",
  icon: n = null,
  iconPosition: r = "right",
  // left, right
  tag: i = "h2",
  // h1, h2, h3, h4, h5, h6
  size: o = "sm",
  // xs, sm, md, lg
  className: a = ""
}) => {
  const s = {
    xs: "gap-1 [&>svg]:size-3.5",
    sm: "gap-1 [&>svg]:size-4",
    md: "gap-1.5 [&>svg]:size-5",
    lg: "gap-1.5 [&>svg]:size-5"
  };
  if (!e)
    return null;
  const l = () => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(i, { className: K("font-semibold p-0 m-0", {
    xs: "text-base [&>*]:text-base gap-1",
    sm: "text-lg [&>*]:text-lg gap-1",
    md: "text-xl [&>*]:text-xl gap-1.5",
    lg: "text-2xl [&>*]:text-2xl gap-1.5"
  }[o]), children: e }), c = () => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "p",
    {
      className: K(
        "text-text-secondary font-normal my-0",
        {
          xs: "text-sm",
          sm: "text-sm",
          md: "text-base",
          lg: "text-base"
        }[o]
      ),
      children: t
    }
  );
  return t ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: a, children: [
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [
      n && r === "left" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("flex items-center", s[o]), children: [
        n,
        l()
      ] }),
      n && r === "right" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("flex items-center", s[o]), children: [
        l(),
        n
      ] }),
      !n && l()
    ] }),
    c()
  ] }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: a, children: [
    n && r === "left" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("flex items-center", s[o]), children: [
      n,
      l()
    ] }),
    n && r === "right" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("flex items-center", s[o]), children: [
      l(),
      n
    ] }),
    !n && l()
  ] });
}, d1 = ({
  variant: e = "primary",
  // primary, secondary
  size: t = "md",
  // sm, md, lg, xl,
  icon: n = null,
  className: r = ""
}) => {
  const i = {
    primary: "text-brand-primary-600",
    secondary: "text-background-primary"
  }[e], o = {
    sm: "[&>svg]:size-4",
    md: "[&>svg]:size-5",
    lg: "[&>svg]:size-6",
    xl: "[&>svg]:size-8"
  }[t];
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "span",
    {
      className: K("flex", o, i, r),
      children: n || /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(QH, { className: "animate-spin shrink-0" })
    }
  );
}, qEe = ({
  progress: e = 0,
  // 0-100
  speed: t = 200,
  className: n = ""
}) => {
  let r = e;
  e < 0 && (r = 0), e > 100 && (r = 100);
  const i = `translateX(-${100 - r}%)`, o = `h-2 rounded-full bg-background-brand absolute left-0 top-0 w-full bottom-0 origin-left transition-transform duration-${t} ease-linear`;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "h-2 rounded-full bg-misc-progress-background overflow-hidden relative",
        n
      ),
      role: "progressbar",
      "aria-valuenow": r,
      "aria-valuemin": 0,
      "aria-valuemax": 100,
      "aria-label": "Progress Bar",
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          className: o,
          style: {
            transform: i
          }
        }
      )
    }
  );
}, jD = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
  activeItem: null,
  onChange: () => {
  },
  size: "md",
  iconPosition: "left"
}), dY = ({
  children: e,
  activeItem: t = null,
  onChange: n,
  className: r,
  size: i = "md",
  iconPosition: o = "left"
}) => {
  const a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (l) => {
      n && n(l);
    },
    [n]
  ), s = K(
    "box-border flex border border-border-subtle border-solid rounded",
    r
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: s, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    jD.Provider,
    {
      value: {
        activeItem: t,
        onChange: a,
        size: i,
        iconPosition: o
      },
      children: react__WEBPACK_IMPORTED_MODULE_1__.Children.map(e, (l, c) => {
        if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(l))
          return null;
        const f = c === 0, d = c === react__WEBPACK_IMPORTED_MODULE_1__.Children.count(e) - 1;
        return react__WEBPACK_IMPORTED_MODULE_1__.cloneElement(l, {
          ...l.props,
          index: c,
          isFirstChild: f,
          isLastChild: d
        });
      })
    }
  ) });
}, hY = ({
  slug: e,
  text: t,
  icon: n,
  className: r,
  disabled: i = !1,
  isFirstChild: o,
  isLastChild: a,
  ...s
}, l) => {
  const c = react__WEBPACK_IMPORTED_MODULE_1__.useContext(jD);
  if (!c)
    throw new Error("Button should be used inside Button Group");
  const { activeItem: f, onChange: d, size: p, iconPosition: m } = c, y = {
    xs: "py-1 px-1 text-sm gap-0.5 [&>svg]:size-4",
    sm: "py-2 px-2 text-base gap-1 [&>svg]:size-4",
    md: "py-2.5 px-2.5 text-base gap-1 [&>svg]:size-5"
  }, g = "bg-background-primary text-primary cursor-pointer flex items-center justify-center", v = "hover:bg-button-tertiary-hover", x = "focus:outline-none", w = i ? "text-text-disabled cursor-not-allowed" : "", S = o ? "rounded-tl rounded-bl border-0 border-r border-border-subtle" : "", A = a ? "rounded-tr rounded-br border-0" : "", _ = "border-0 border-r border-border-subtle border-solid", O = f === e ? "bg-button-disabled" : "", P = K(
    g,
    v,
    x,
    w,
    y[p],
    _,
    O,
    S,
    A,
    r
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "button",
    {
      ref: l,
      className: P,
      disabled: i,
      onClick: (k) => {
        d({ event: k, value: { slug: e, text: t } });
      },
      ...s,
      children: [
        m === "left" && n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "mr-1", children: n }),
        t,
        m === "right" && n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "ml-1", children: n })
      ]
    }
  );
}, LD = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(hY);
LD.displayName = "Button";
const XEe = {
  Group: dY,
  Button: LD
}, qT = /* @__PURE__ */ new Set();
function gg(e, t, n) {
  e || qT.has(t) || (console.warn(t), qT.add(t));
}
function pY(e) {
  if (typeof Proxy > "u")
    return e;
  const t = /* @__PURE__ */ new Map(), n = (...r) => ( true && gg(!1, "motion() is deprecated. Use motion.create() instead."), e(...r));
  return new Proxy(n, {
    /**
     * Called when `motion` is referenced with a prop: `motion.div`, `motion.input` etc.
     * The prop name is passed through as `key` and we can use that to generate a `motion`
     * DOM component with that name.
     */
    get: (r, i) => i === "create" ? e : (t.has(i) || t.set(i, e(i)), t.get(i))
  });
}
function yg(e) {
  return e !== null && typeof e == "object" && typeof e.start == "function";
}
const S0 = (e) => Array.isArray(e);
function BD(e, t) {
  if (!Array.isArray(t))
    return !1;
  const n = t.length;
  if (n !== e.length)
    return !1;
  for (let r = 0; r < n; r++)
    if (t[r] !== e[r])
      return !1;
  return !0;
}
function pf(e) {
  return typeof e == "string" || Array.isArray(e);
}
function XT(e) {
  const t = [{}, {}];
  return e == null || e.values.forEach((n, r) => {
    t[0][r] = n.get(), t[1][r] = n.getVelocity();
  }), t;
}
function h1(e, t, n, r) {
  if (typeof t == "function") {
    const [i, o] = XT(r);
    t = t(n !== void 0 ? n : e.custom, i, o);
  }
  if (typeof t == "string" && (t = e.variants && e.variants[t]), typeof t == "function") {
    const [i, o] = XT(r);
    t = t(n !== void 0 ? n : e.custom, i, o);
  }
  return t;
}
function vg(e, t, n) {
  const r = e.getProps();
  return h1(r, t, n !== void 0 ? n : r.custom, e);
}
const p1 = [
  "animate",
  "whileInView",
  "whileFocus",
  "whileHover",
  "whileTap",
  "whileDrag",
  "exit"
], m1 = ["initial", ...p1], dd = [
  "transformPerspective",
  "x",
  "y",
  "z",
  "translateX",
  "translateY",
  "translateZ",
  "scale",
  "scaleX",
  "scaleY",
  "rotate",
  "rotateX",
  "rotateY",
  "rotateZ",
  "skew",
  "skewX",
  "skewY"
], Gs = new Set(dd), Gi = (e) => e * 1e3, No = (e) => e / 1e3, mY = {
  type: "spring",
  stiffness: 500,
  damping: 25,
  restSpeed: 10
}, gY = (e) => ({
  type: "spring",
  stiffness: 550,
  damping: e === 0 ? 2 * Math.sqrt(550) : 30,
  restSpeed: 10
}), yY = {
  type: "keyframes",
  duration: 0.8
}, vY = {
  type: "keyframes",
  ease: [0.25, 0.1, 0.35, 1],
  duration: 0.3
}, bY = (e, { keyframes: t }) => t.length > 2 ? yY : Gs.has(e) ? e.startsWith("scale") ? gY(t[1]) : mY : vY;
function g1(e, t) {
  return e ? e[t] || e.default || e : void 0;
}
const xY = {
  skipAnimations: !1,
  useManualTiming: !1
}, wY = (e) => e !== null;
function bg(e, { repeat: t, repeatType: n = "loop" }, r) {
  const i = e.filter(wY), o = t && n !== "loop" && t % 2 === 1 ? 0 : i.length - 1;
  return !o || r === void 0 ? i[o] : r;
}
const qn = (e) => e;
function _Y(e) {
  let t = /* @__PURE__ */ new Set(), n = /* @__PURE__ */ new Set(), r = !1, i = !1;
  const o = /* @__PURE__ */ new WeakSet();
  let a = {
    delta: 0,
    timestamp: 0,
    isProcessing: !1
  };
  function s(c) {
    o.has(c) && (l.schedule(c), e()), c(a);
  }
  const l = {
    /**
     * Schedule a process to run on the next frame.
     */
    schedule: (c, f = !1, d = !1) => {
      const m = d && r ? t : n;
      return f && o.add(c), m.has(c) || m.add(c), c;
    },
    /**
     * Cancel the provided callback from running on the next frame.
     */
    cancel: (c) => {
      n.delete(c), o.delete(c);
    },
    /**
     * Execute all schedule callbacks.
     */
    process: (c) => {
      if (a = c, r) {
        i = !0;
        return;
      }
      r = !0, [t, n] = [n, t], n.clear(), t.forEach(s), r = !1, i && (i = !1, l.process(c));
    }
  };
  return l;
}
const Eh = [
  "read",
  // Read
  "resolveKeyframes",
  // Write/Read/Write/Read
  "update",
  // Compute
  "preRender",
  // Compute
  "render",
  // Write
  "postRender"
  // Compute
], SY = 40;
function FD(e, t) {
  let n = !1, r = !0;
  const i = {
    delta: 0,
    timestamp: 0,
    isProcessing: !1
  }, o = () => n = !0, a = Eh.reduce((x, w) => (x[w] = _Y(o), x), {}), { read: s, resolveKeyframes: l, update: c, preRender: f, render: d, postRender: p } = a, m = () => {
    const x = performance.now();
    n = !1, i.delta = r ? 1e3 / 60 : Math.max(Math.min(x - i.timestamp, SY), 1), i.timestamp = x, i.isProcessing = !0, s.process(i), l.process(i), c.process(i), f.process(i), d.process(i), p.process(i), i.isProcessing = !1, n && t && (r = !1, e(m));
  }, y = () => {
    n = !0, r = !0, i.isProcessing || e(m);
  };
  return { schedule: Eh.reduce((x, w) => {
    const S = a[w];
    return x[w] = (A, _ = !1, O = !1) => (n || y(), S.schedule(A, _, O)), x;
  }, {}), cancel: (x) => {
    for (let w = 0; w < Eh.length; w++)
      a[Eh[w]].cancel(x);
  }, state: i, steps: a };
}
const { schedule: Tt, cancel: ja, state: zn, steps: eb } = FD(typeof requestAnimationFrame < "u" ? requestAnimationFrame : qn, !0), WD = (e, t, n) => (((1 - 3 * n + 3 * t) * e + (3 * n - 6 * t)) * e + 3 * t) * e, OY = 1e-7, AY = 12;
function TY(e, t, n, r, i) {
  let o, a, s = 0;
  do
    a = t + (n - t) / 2, o = WD(a, r, i) - e, o > 0 ? n = a : t = a;
  while (Math.abs(o) > OY && ++s < AY);
  return a;
}
function hd(e, t, n, r) {
  if (e === t && n === r)
    return qn;
  const i = (o) => TY(o, 0, 1, e, n);
  return (o) => o === 0 || o === 1 ? o : WD(i(o), t, r);
}
const zD = (e) => (t) => t <= 0.5 ? e(2 * t) / 2 : (2 - e(2 * (1 - t))) / 2, VD = (e) => (t) => 1 - e(1 - t), UD = /* @__PURE__ */ hd(0.33, 1.53, 0.69, 0.99), y1 = /* @__PURE__ */ VD(UD), HD = /* @__PURE__ */ zD(y1), KD = (e) => (e *= 2) < 1 ? 0.5 * y1(e) : 0.5 * (2 - Math.pow(2, -10 * (e - 1))), v1 = (e) => 1 - Math.sin(Math.acos(e)), GD = VD(v1), YD = zD(v1), qD = (e) => /^0[^.\s]+$/u.test(e);
function PY(e) {
  return typeof e == "number" ? e === 0 : e !== null ? e === "none" || e === "0" || qD(e) : !0;
}
let Ic = qn, Wo = qn;
 true && (Ic = (e, t) => {
  !e && typeof console < "u" && console.warn(t);
}, Wo = (e, t) => {
  if (!e)
    throw new Error(t);
});
const XD = (e) => /^-?(?:\d+(?:\.\d+)?|\.\d+)$/u.test(e), ZD = (e) => (t) => typeof t == "string" && t.startsWith(e), JD = /* @__PURE__ */ ZD("--"), CY = /* @__PURE__ */ ZD("var(--"), b1 = (e) => CY(e) ? EY.test(e.split("/*")[0].trim()) : !1, EY = /var\(--(?:[\w-]+\s*|[\w-]+\s*,(?:\s*[^)(\s]|\s*\((?:[^)(]|\([^)(]*\))*\))+\s*)\)$/iu, kY = (
  // eslint-disable-next-line redos-detector/no-unsafe-regex -- false positive, as it can match a lot of words
  /^var\(--(?:([\w-]+)|([\w-]+), ?([a-zA-Z\d ()%#.,-]+))\)/u
);
function MY(e) {
  const t = kY.exec(e);
  if (!t)
    return [,];
  const [, n, r, i] = t;
  return [`--${n ?? r}`, i];
}
const NY = 4;
function QD(e, t, n = 1) {
  Wo(n <= NY, `Max CSS variable fallback depth detected in property "${e}". This may indicate a circular fallback dependency.`);
  const [r, i] = MY(e);
  if (!r)
    return;
  const o = window.getComputedStyle(t).getPropertyValue(r);
  if (o) {
    const a = o.trim();
    return XD(a) ? parseFloat(a) : a;
  }
  return b1(i) ? QD(i, t, n + 1) : i;
}
const La = (e, t, n) => n > t ? t : n < e ? e : n, Rc = {
  test: (e) => typeof e == "number",
  parse: parseFloat,
  transform: (e) => e
}, mf = {
  ...Rc,
  transform: (e) => La(0, 1, e)
}, kh = {
  ...Rc,
  default: 1
}, pd = (e) => ({
  test: (t) => typeof t == "string" && t.endsWith(e) && t.split(" ").length === 1,
  parse: parseFloat,
  transform: (t) => `${t}${e}`
}), va = /* @__PURE__ */ pd("deg"), Yi = /* @__PURE__ */ pd("%"), Be = /* @__PURE__ */ pd("px"), $Y = /* @__PURE__ */ pd("vh"), DY = /* @__PURE__ */ pd("vw"), ZT = {
  ...Yi,
  parse: (e) => Yi.parse(e) / 100,
  transform: (e) => Yi.transform(e * 100)
}, IY = /* @__PURE__ */ new Set([
  "width",
  "height",
  "top",
  "left",
  "right",
  "bottom",
  "x",
  "y",
  "translateX",
  "translateY"
]), JT = (e) => e === Rc || e === Be, QT = (e, t) => parseFloat(e.split(", ")[t]), eP = (e, t) => (n, { transform: r }) => {
  if (r === "none" || !r)
    return 0;
  const i = r.match(/^matrix3d\((.+)\)$/u);
  if (i)
    return QT(i[1], t);
  {
    const o = r.match(/^matrix\((.+)\)$/u);
    return o ? QT(o[1], e) : 0;
  }
}, RY = /* @__PURE__ */ new Set(["x", "y", "z"]), jY = dd.filter((e) => !RY.has(e));
function LY(e) {
  const t = [];
  return jY.forEach((n) => {
    const r = e.getValue(n);
    r !== void 0 && (t.push([n, r.get()]), r.set(n.startsWith("scale") ? 1 : 0));
  }), t;
}
const Ql = {
  // Dimensions
  width: ({ x: e }, { paddingLeft: t = "0", paddingRight: n = "0" }) => e.max - e.min - parseFloat(t) - parseFloat(n),
  height: ({ y: e }, { paddingTop: t = "0", paddingBottom: n = "0" }) => e.max - e.min - parseFloat(t) - parseFloat(n),
  top: (e, { top: t }) => parseFloat(t),
  left: (e, { left: t }) => parseFloat(t),
  bottom: ({ y: e }, { top: t }) => parseFloat(t) + (e.max - e.min),
  right: ({ x: e }, { left: t }) => parseFloat(t) + (e.max - e.min),
  // Transform
  x: eP(4, 13),
  y: eP(5, 14)
};
Ql.translateX = Ql.x;
Ql.translateY = Ql.y;
const eI = (e) => (t) => t.test(e), BY = {
  test: (e) => e === "auto",
  parse: (e) => e
}, tI = [Rc, Be, Yi, va, DY, $Y, BY], tP = (e) => tI.find(eI(e)), Es = /* @__PURE__ */ new Set();
let O0 = !1, A0 = !1;
function nI() {
  if (A0) {
    const e = Array.from(Es).filter((r) => r.needsMeasurement), t = new Set(e.map((r) => r.element)), n = /* @__PURE__ */ new Map();
    t.forEach((r) => {
      const i = LY(r);
      i.length && (n.set(r, i), r.render());
    }), e.forEach((r) => r.measureInitialState()), t.forEach((r) => {
      r.render();
      const i = n.get(r);
      i && i.forEach(([o, a]) => {
        var s;
        (s = r.getValue(o)) === null || s === void 0 || s.set(a);
      });
    }), e.forEach((r) => r.measureEndState()), e.forEach((r) => {
      r.suspendedScrollY !== void 0 && window.scrollTo(0, r.suspendedScrollY);
    });
  }
  A0 = !1, O0 = !1, Es.forEach((e) => e.complete()), Es.clear();
}
function rI() {
  Es.forEach((e) => {
    e.readKeyframes(), e.needsMeasurement && (A0 = !0);
  });
}
function FY() {
  rI(), nI();
}
class x1 {
  constructor(t, n, r, i, o, a = !1) {
    this.isComplete = !1, this.isAsync = !1, this.needsMeasurement = !1, this.isScheduled = !1, this.unresolvedKeyframes = [...t], this.onComplete = n, this.name = r, this.motionValue = i, this.element = o, this.isAsync = a;
  }
  scheduleResolve() {
    this.isScheduled = !0, this.isAsync ? (Es.add(this), O0 || (O0 = !0, Tt.read(rI), Tt.resolveKeyframes(nI))) : (this.readKeyframes(), this.complete());
  }
  readKeyframes() {
    const { unresolvedKeyframes: t, name: n, element: r, motionValue: i } = this;
    for (let o = 0; o < t.length; o++)
      if (t[o] === null)
        if (o === 0) {
          const a = i == null ? void 0 : i.get(), s = t[t.length - 1];
          if (a !== void 0)
            t[0] = a;
          else if (r && n) {
            const l = r.readValue(n, s);
            l != null && (t[0] = l);
          }
          t[0] === void 0 && (t[0] = s), i && a === void 0 && i.set(t[0]);
        } else
          t[o] = t[o - 1];
  }
  setFinalKeyframe() {
  }
  measureInitialState() {
  }
  renderEndStyles() {
  }
  measureEndState() {
  }
  complete() {
    this.isComplete = !0, this.onComplete(this.unresolvedKeyframes, this.finalKeyframe), Es.delete(this);
  }
  cancel() {
    this.isComplete || (this.isScheduled = !1, Es.delete(this));
  }
  resume() {
    this.isComplete || this.scheduleResolve();
  }
}
const Ku = (e) => Math.round(e * 1e5) / 1e5, w1 = /-?(?:\d+(?:\.\d+)?|\.\d+)/gu;
function WY(e) {
  return e == null;
}
const zY = /^(?:#[\da-f]{3,8}|(?:rgb|hsl)a?\((?:-?[\d.]+%?[,\s]+){2}-?[\d.]+%?\s*(?:[,/]\s*)?(?:\b\d+(?:\.\d+)?|\.\d+)?%?\))$/iu, _1 = (e, t) => (n) => !!(typeof n == "string" && zY.test(n) && n.startsWith(e) || t && !WY(n) && Object.prototype.hasOwnProperty.call(n, t)), iI = (e, t, n) => (r) => {
  if (typeof r != "string")
    return r;
  const [i, o, a, s] = r.match(w1);
  return {
    [e]: parseFloat(i),
    [t]: parseFloat(o),
    [n]: parseFloat(a),
    alpha: s !== void 0 ? parseFloat(s) : 1
  };
}, VY = (e) => La(0, 255, e), tb = {
  ...Rc,
  transform: (e) => Math.round(VY(e))
}, ws = {
  test: /* @__PURE__ */ _1("rgb", "red"),
  parse: /* @__PURE__ */ iI("red", "green", "blue"),
  transform: ({ red: e, green: t, blue: n, alpha: r = 1 }) => "rgba(" + tb.transform(e) + ", " + tb.transform(t) + ", " + tb.transform(n) + ", " + Ku(mf.transform(r)) + ")"
};
function UY(e) {
  let t = "", n = "", r = "", i = "";
  return e.length > 5 ? (t = e.substring(1, 3), n = e.substring(3, 5), r = e.substring(5, 7), i = e.substring(7, 9)) : (t = e.substring(1, 2), n = e.substring(2, 3), r = e.substring(3, 4), i = e.substring(4, 5), t += t, n += n, r += r, i += i), {
    red: parseInt(t, 16),
    green: parseInt(n, 16),
    blue: parseInt(r, 16),
    alpha: i ? parseInt(i, 16) / 255 : 1
  };
}
const T0 = {
  test: /* @__PURE__ */ _1("#"),
  parse: UY,
  transform: ws.transform
}, Ml = {
  test: /* @__PURE__ */ _1("hsl", "hue"),
  parse: /* @__PURE__ */ iI("hue", "saturation", "lightness"),
  transform: ({ hue: e, saturation: t, lightness: n, alpha: r = 1 }) => "hsla(" + Math.round(e) + ", " + Yi.transform(Ku(t)) + ", " + Yi.transform(Ku(n)) + ", " + Ku(mf.transform(r)) + ")"
}, er = {
  test: (e) => ws.test(e) || T0.test(e) || Ml.test(e),
  parse: (e) => ws.test(e) ? ws.parse(e) : Ml.test(e) ? Ml.parse(e) : T0.parse(e),
  transform: (e) => typeof e == "string" ? e : e.hasOwnProperty("red") ? ws.transform(e) : Ml.transform(e)
}, HY = /(?:#[\da-f]{3,8}|(?:rgb|hsl)a?\((?:-?[\d.]+%?[,\s]+){2}-?[\d.]+%?\s*(?:[,/]\s*)?(?:\b\d+(?:\.\d+)?|\.\d+)?%?\))/giu;
function KY(e) {
  var t, n;
  return isNaN(e) && typeof e == "string" && (((t = e.match(w1)) === null || t === void 0 ? void 0 : t.length) || 0) + (((n = e.match(HY)) === null || n === void 0 ? void 0 : n.length) || 0) > 0;
}
const oI = "number", aI = "color", GY = "var", YY = "var(", nP = "${}", qY = /var\s*\(\s*--(?:[\w-]+\s*|[\w-]+\s*,(?:\s*[^)(\s]|\s*\((?:[^)(]|\([^)(]*\))*\))+\s*)\)|#[\da-f]{3,8}|(?:rgb|hsl)a?\((?:-?[\d.]+%?[,\s]+){2}-?[\d.]+%?\s*(?:[,/]\s*)?(?:\b\d+(?:\.\d+)?|\.\d+)?%?\)|-?(?:\d+(?:\.\d+)?|\.\d+)/giu;
function gf(e) {
  const t = e.toString(), n = [], r = {
    color: [],
    number: [],
    var: []
  }, i = [];
  let o = 0;
  const s = t.replace(qY, (l) => (er.test(l) ? (r.color.push(o), i.push(aI), n.push(er.parse(l))) : l.startsWith(YY) ? (r.var.push(o), i.push(GY), n.push(l)) : (r.number.push(o), i.push(oI), n.push(parseFloat(l))), ++o, nP)).split(nP);
  return { values: n, split: s, indexes: r, types: i };
}
function sI(e) {
  return gf(e).values;
}
function lI(e) {
  const { split: t, types: n } = gf(e), r = t.length;
  return (i) => {
    let o = "";
    for (let a = 0; a < r; a++)
      if (o += t[a], i[a] !== void 0) {
        const s = n[a];
        s === oI ? o += Ku(i[a]) : s === aI ? o += er.transform(i[a]) : o += i[a];
      }
    return o;
  };
}
const XY = (e) => typeof e == "number" ? 0 : e;
function ZY(e) {
  const t = sI(e);
  return lI(e)(t.map(XY));
}
const Ba = {
  test: KY,
  parse: sI,
  createTransformer: lI,
  getAnimatableNone: ZY
}, JY = /* @__PURE__ */ new Set(["brightness", "contrast", "saturate", "opacity"]);
function QY(e) {
  const [t, n] = e.slice(0, -1).split("(");
  if (t === "drop-shadow")
    return e;
  const [r] = n.match(w1) || [];
  if (!r)
    return e;
  const i = n.replace(r, "");
  let o = JY.has(t) ? 1 : 0;
  return r !== n && (o *= 100), t + "(" + o + i + ")";
}
const eq = /\b([a-z-]*)\(.*?\)/gu, P0 = {
  ...Ba,
  getAnimatableNone: (e) => {
    const t = e.match(eq);
    return t ? t.map(QY).join(" ") : e;
  }
}, tq = {
  // Border props
  borderWidth: Be,
  borderTopWidth: Be,
  borderRightWidth: Be,
  borderBottomWidth: Be,
  borderLeftWidth: Be,
  borderRadius: Be,
  radius: Be,
  borderTopLeftRadius: Be,
  borderTopRightRadius: Be,
  borderBottomRightRadius: Be,
  borderBottomLeftRadius: Be,
  // Positioning props
  width: Be,
  maxWidth: Be,
  height: Be,
  maxHeight: Be,
  top: Be,
  right: Be,
  bottom: Be,
  left: Be,
  // Spacing props
  padding: Be,
  paddingTop: Be,
  paddingRight: Be,
  paddingBottom: Be,
  paddingLeft: Be,
  margin: Be,
  marginTop: Be,
  marginRight: Be,
  marginBottom: Be,
  marginLeft: Be,
  // Misc
  backgroundPositionX: Be,
  backgroundPositionY: Be
}, nq = {
  rotate: va,
  rotateX: va,
  rotateY: va,
  rotateZ: va,
  scale: kh,
  scaleX: kh,
  scaleY: kh,
  scaleZ: kh,
  skew: va,
  skewX: va,
  skewY: va,
  distance: Be,
  translateX: Be,
  translateY: Be,
  translateZ: Be,
  x: Be,
  y: Be,
  z: Be,
  perspective: Be,
  transformPerspective: Be,
  opacity: mf,
  originX: ZT,
  originY: ZT,
  originZ: Be
}, rP = {
  ...Rc,
  transform: Math.round
}, S1 = {
  ...tq,
  ...nq,
  zIndex: rP,
  size: Be,
  // SVG
  fillOpacity: mf,
  strokeOpacity: mf,
  numOctaves: rP
}, rq = {
  ...S1,
  // Color props
  color: er,
  backgroundColor: er,
  outlineColor: er,
  fill: er,
  stroke: er,
  // Border props
  borderColor: er,
  borderTopColor: er,
  borderRightColor: er,
  borderBottomColor: er,
  borderLeftColor: er,
  filter: P0,
  WebkitFilter: P0
}, O1 = (e) => rq[e];
function cI(e, t) {
  let n = O1(e);
  return n !== P0 && (n = Ba), n.getAnimatableNone ? n.getAnimatableNone(t) : void 0;
}
const iq = /* @__PURE__ */ new Set(["auto", "none", "0"]);
function oq(e, t, n) {
  let r = 0, i;
  for (; r < e.length && !i; ) {
    const o = e[r];
    typeof o == "string" && !iq.has(o) && gf(o).values.length && (i = e[r]), r++;
  }
  if (i && n)
    for (const o of t)
      e[o] = cI(n, i);
}
class uI extends x1 {
  constructor(t, n, r, i, o) {
    super(t, n, r, i, o, !0);
  }
  readKeyframes() {
    const { unresolvedKeyframes: t, element: n, name: r } = this;
    if (!n || !n.current)
      return;
    super.readKeyframes();
    for (let l = 0; l < t.length; l++) {
      let c = t[l];
      if (typeof c == "string" && (c = c.trim(), b1(c))) {
        const f = QD(c, n.current);
        f !== void 0 && (t[l] = f), l === t.length - 1 && (this.finalKeyframe = c);
      }
    }
    if (this.resolveNoneKeyframes(), !IY.has(r) || t.length !== 2)
      return;
    const [i, o] = t, a = tP(i), s = tP(o);
    if (a !== s)
      if (JT(a) && JT(s))
        for (let l = 0; l < t.length; l++) {
          const c = t[l];
          typeof c == "string" && (t[l] = parseFloat(c));
        }
      else
        this.needsMeasurement = !0;
  }
  resolveNoneKeyframes() {
    const { unresolvedKeyframes: t, name: n } = this, r = [];
    for (let i = 0; i < t.length; i++)
      PY(t[i]) && r.push(i);
    r.length && oq(t, r, n);
  }
  measureInitialState() {
    const { element: t, unresolvedKeyframes: n, name: r } = this;
    if (!t || !t.current)
      return;
    r === "height" && (this.suspendedScrollY = window.pageYOffset), this.measuredOrigin = Ql[r](t.measureViewportBox(), window.getComputedStyle(t.current)), n[0] = this.measuredOrigin;
    const i = n[n.length - 1];
    i !== void 0 && t.getValue(r, i).jump(i, !1);
  }
  measureEndState() {
    var t;
    const { element: n, name: r, unresolvedKeyframes: i } = this;
    if (!n || !n.current)
      return;
    const o = n.getValue(r);
    o && o.jump(this.measuredOrigin, !1);
    const a = i.length - 1, s = i[a];
    i[a] = Ql[r](n.measureViewportBox(), window.getComputedStyle(n.current)), s !== null && this.finalKeyframe === void 0 && (this.finalKeyframe = s), !((t = this.removedTransforms) === null || t === void 0) && t.length && this.removedTransforms.forEach(([l, c]) => {
      n.getValue(l).set(c);
    }), this.resolveNoneKeyframes();
  }
}
function A1(e) {
  return typeof e == "function";
}
let ap;
function aq() {
  ap = void 0;
}
const qi = {
  now: () => (ap === void 0 && qi.set(zn.isProcessing || xY.useManualTiming ? zn.timestamp : performance.now()), ap),
  set: (e) => {
    ap = e, queueMicrotask(aq);
  }
}, iP = (e, t) => t === "zIndex" ? !1 : !!(typeof e == "number" || Array.isArray(e) || typeof e == "string" && // It's animatable if we have a string
(Ba.test(e) || e === "0") && // And it contains numbers and/or colors
!e.startsWith("url("));
function sq(e) {
  const t = e[0];
  if (e.length === 1)
    return !0;
  for (let n = 0; n < e.length; n++)
    if (e[n] !== t)
      return !0;
}
function lq(e, t, n, r) {
  const i = e[0];
  if (i === null)
    return !1;
  if (t === "display" || t === "visibility")
    return !0;
  const o = e[e.length - 1], a = iP(i, t), s = iP(o, t);
  return Ic(a === s, `You are trying to animate ${t} from "${i}" to "${o}". ${i} is not an animatable value - to enable this animation set ${i} to a value animatable to ${o} via the \`style\` property.`), !a || !s ? !1 : sq(e) || (n === "spring" || A1(n)) && r;
}
const cq = 40;
class fI {
  constructor({ autoplay: t = !0, delay: n = 0, type: r = "keyframes", repeat: i = 0, repeatDelay: o = 0, repeatType: a = "loop", ...s }) {
    this.isStopped = !1, this.hasAttemptedResolve = !1, this.createdAt = qi.now(), this.options = {
      autoplay: t,
      delay: n,
      type: r,
      repeat: i,
      repeatDelay: o,
      repeatType: a,
      ...s
    }, this.updateFinishedPromise();
  }
  /**
   * This method uses the createdAt and resolvedAt to calculate the
   * animation startTime. *Ideally*, we would use the createdAt time as t=0
   * as the following frame would then be the first frame of the animation in
   * progress, which would feel snappier.
   *
   * However, if there's a delay (main thread work) between the creation of
   * the animation and the first commited frame, we prefer to use resolvedAt
   * to avoid a sudden jump into the animation.
   */
  calcStartTime() {
    return this.resolvedAt ? this.resolvedAt - this.createdAt > cq ? this.resolvedAt : this.createdAt : this.createdAt;
  }
  /**
   * A getter for resolved data. If keyframes are not yet resolved, accessing
   * this.resolved will synchronously flush all pending keyframe resolvers.
   * This is a deoptimisation, but at its worst still batches read/writes.
   */
  get resolved() {
    return !this._resolved && !this.hasAttemptedResolve && FY(), this._resolved;
  }
  /**
   * A method to be called when the keyframes resolver completes. This method
   * will check if its possible to run the animation and, if not, skip it.
   * Otherwise, it will call initPlayback on the implementing class.
   */
  onKeyframesResolved(t, n) {
    this.resolvedAt = qi.now(), this.hasAttemptedResolve = !0;
    const { name: r, type: i, velocity: o, delay: a, onComplete: s, onUpdate: l, isGenerator: c } = this.options;
    if (!c && !lq(t, r, i, o))
      if (a)
        this.options.duration = 0;
      else {
        l == null || l(bg(t, this.options, n)), s == null || s(), this.resolveFinishedPromise();
        return;
      }
    const f = this.initPlayback(t, n);
    f !== !1 && (this._resolved = {
      keyframes: t,
      finalKeyframe: n,
      ...f
    }, this.onPostResolved());
  }
  onPostResolved() {
  }
  /**
   * Allows the returned animation to be awaited or promise-chained. Currently
   * resolves when the animation finishes at all but in a future update could/should
   * reject if its cancels.
   */
  then(t, n) {
    return this.currentFinishedPromise.then(t, n);
  }
  flatten() {
    this.options.type = "keyframes", this.options.ease = "linear";
  }
  updateFinishedPromise() {
    this.currentFinishedPromise = new Promise((t) => {
      this.resolveFinishedPromise = t;
    });
  }
}
function dI(e, t) {
  return t ? e * (1e3 / t) : 0;
}
const uq = 5;
function hI(e, t, n) {
  const r = Math.max(t - uq, 0);
  return dI(n - e(r), t - r);
}
const nb = 1e-3, fq = 0.01, oP = 10, dq = 0.05, hq = 1;
function pq({ duration: e = 800, bounce: t = 0.25, velocity: n = 0, mass: r = 1 }) {
  let i, o;
  Ic(e <= Gi(oP), "Spring duration must be 10 seconds or less");
  let a = 1 - t;
  a = La(dq, hq, a), e = La(fq, oP, No(e)), a < 1 ? (i = (c) => {
    const f = c * a, d = f * e, p = f - n, m = C0(c, a), y = Math.exp(-d);
    return nb - p / m * y;
  }, o = (c) => {
    const d = c * a * e, p = d * n + n, m = Math.pow(a, 2) * Math.pow(c, 2) * e, y = Math.exp(-d), g = C0(Math.pow(c, 2), a);
    return (-i(c) + nb > 0 ? -1 : 1) * ((p - m) * y) / g;
  }) : (i = (c) => {
    const f = Math.exp(-c * e), d = (c - n) * e + 1;
    return -nb + f * d;
  }, o = (c) => {
    const f = Math.exp(-c * e), d = (n - c) * (e * e);
    return f * d;
  });
  const s = 5 / e, l = gq(i, o, s);
  if (e = Gi(e), isNaN(l))
    return {
      stiffness: 100,
      damping: 10,
      duration: e
    };
  {
    const c = Math.pow(l, 2) * r;
    return {
      stiffness: c,
      damping: a * 2 * Math.sqrt(r * c),
      duration: e
    };
  }
}
const mq = 12;
function gq(e, t, n) {
  let r = n;
  for (let i = 1; i < mq; i++)
    r = r - e(r) / t(r);
  return r;
}
function C0(e, t) {
  return e * Math.sqrt(1 - t * t);
}
const yq = ["duration", "bounce"], vq = ["stiffness", "damping", "mass"];
function aP(e, t) {
  return t.some((n) => e[n] !== void 0);
}
function bq(e) {
  let t = {
    velocity: 0,
    stiffness: 100,
    damping: 10,
    mass: 1,
    isResolvedFromDuration: !1,
    ...e
  };
  if (!aP(e, vq) && aP(e, yq)) {
    const n = pq(e);
    t = {
      ...t,
      ...n,
      mass: 1
    }, t.isResolvedFromDuration = !0;
  }
  return t;
}
function pI({ keyframes: e, restDelta: t, restSpeed: n, ...r }) {
  const i = e[0], o = e[e.length - 1], a = { done: !1, value: i }, { stiffness: s, damping: l, mass: c, duration: f, velocity: d, isResolvedFromDuration: p } = bq({
    ...r,
    velocity: -No(r.velocity || 0)
  }), m = d || 0, y = l / (2 * Math.sqrt(s * c)), g = o - i, v = No(Math.sqrt(s / c)), x = Math.abs(g) < 5;
  n || (n = x ? 0.01 : 2), t || (t = x ? 5e-3 : 0.5);
  let w;
  if (y < 1) {
    const S = C0(v, y);
    w = (A) => {
      const _ = Math.exp(-y * v * A);
      return o - _ * ((m + y * v * g) / S * Math.sin(S * A) + g * Math.cos(S * A));
    };
  } else if (y === 1)
    w = (S) => o - Math.exp(-v * S) * (g + (m + v * g) * S);
  else {
    const S = v * Math.sqrt(y * y - 1);
    w = (A) => {
      const _ = Math.exp(-y * v * A), O = Math.min(S * A, 300);
      return o - _ * ((m + y * v * g) * Math.sinh(O) + S * g * Math.cosh(O)) / S;
    };
  }
  return {
    calculatedDuration: p && f || null,
    next: (S) => {
      const A = w(S);
      if (p)
        a.done = S >= f;
      else {
        let _ = 0;
        y < 1 && (_ = S === 0 ? Gi(m) : hI(w, S, A));
        const O = Math.abs(_) <= n, P = Math.abs(o - A) <= t;
        a.done = O && P;
      }
      return a.value = a.done ? o : A, a;
    }
  };
}
function sP({ keyframes: e, velocity: t = 0, power: n = 0.8, timeConstant: r = 325, bounceDamping: i = 10, bounceStiffness: o = 500, modifyTarget: a, min: s, max: l, restDelta: c = 0.5, restSpeed: f }) {
  const d = e[0], p = {
    done: !1,
    value: d
  }, m = (C) => s !== void 0 && C < s || l !== void 0 && C > l, y = (C) => s === void 0 ? l : l === void 0 || Math.abs(s - C) < Math.abs(l - C) ? s : l;
  let g = n * t;
  const v = d + g, x = a === void 0 ? v : a(v);
  x !== v && (g = x - d);
  const w = (C) => -g * Math.exp(-C / r), S = (C) => x + w(C), A = (C) => {
    const k = w(C), I = S(C);
    p.done = Math.abs(k) <= c, p.value = p.done ? x : I;
  };
  let _, O;
  const P = (C) => {
    m(p.value) && (_ = C, O = pI({
      keyframes: [p.value, y(p.value)],
      velocity: hI(S, C, p.value),
      // TODO: This should be passing * 1000
      damping: i,
      stiffness: o,
      restDelta: c,
      restSpeed: f
    }));
  };
  return P(0), {
    calculatedDuration: null,
    next: (C) => {
      let k = !1;
      return !O && _ === void 0 && (k = !0, A(C), P(C)), _ !== void 0 && C >= _ ? O.next(C - _) : (!k && A(C), p);
    }
  };
}
const xq = /* @__PURE__ */ hd(0.42, 0, 1, 1), wq = /* @__PURE__ */ hd(0, 0, 0.58, 1), mI = /* @__PURE__ */ hd(0.42, 0, 0.58, 1), _q = (e) => Array.isArray(e) && typeof e[0] != "number", T1 = (e) => Array.isArray(e) && typeof e[0] == "number", lP = {
  linear: qn,
  easeIn: xq,
  easeInOut: mI,
  easeOut: wq,
  circIn: v1,
  circInOut: YD,
  circOut: GD,
  backIn: y1,
  backInOut: HD,
  backOut: UD,
  anticipate: KD
}, cP = (e) => {
  if (T1(e)) {
    Wo(e.length === 4, "Cubic bezier arrays must contain four numerical values.");
    const [t, n, r, i] = e;
    return hd(t, n, r, i);
  } else if (typeof e == "string")
    return Wo(lP[e] !== void 0, `Invalid easing type '${e}'`), lP[e];
  return e;
}, Sq = (e, t) => (n) => t(e(n)), $o = (...e) => e.reduce(Sq), ec = (e, t, n) => {
  const r = t - e;
  return r === 0 ? 1 : (n - e) / r;
}, Qt = (e, t, n) => e + (t - e) * n;
function rb(e, t, n) {
  return n < 0 && (n += 1), n > 1 && (n -= 1), n < 1 / 6 ? e + (t - e) * 6 * n : n < 1 / 2 ? t : n < 2 / 3 ? e + (t - e) * (2 / 3 - n) * 6 : e;
}
function Oq({ hue: e, saturation: t, lightness: n, alpha: r }) {
  e /= 360, t /= 100, n /= 100;
  let i = 0, o = 0, a = 0;
  if (!t)
    i = o = a = n;
  else {
    const s = n < 0.5 ? n * (1 + t) : n + t - n * t, l = 2 * n - s;
    i = rb(l, s, e + 1 / 3), o = rb(l, s, e), a = rb(l, s, e - 1 / 3);
  }
  return {
    red: Math.round(i * 255),
    green: Math.round(o * 255),
    blue: Math.round(a * 255),
    alpha: r
  };
}
function Op(e, t) {
  return (n) => n > 0 ? t : e;
}
const ib = (e, t, n) => {
  const r = e * e, i = n * (t * t - r) + r;
  return i < 0 ? 0 : Math.sqrt(i);
}, Aq = [T0, ws, Ml], Tq = (e) => Aq.find((t) => t.test(e));
function uP(e) {
  const t = Tq(e);
  if (Ic(!!t, `'${e}' is not an animatable color. Use the equivalent color code instead.`), !t)
    return !1;
  let n = t.parse(e);
  return t === Ml && (n = Oq(n)), n;
}
const fP = (e, t) => {
  const n = uP(e), r = uP(t);
  if (!n || !r)
    return Op(e, t);
  const i = { ...n };
  return (o) => (i.red = ib(n.red, r.red, o), i.green = ib(n.green, r.green, o), i.blue = ib(n.blue, r.blue, o), i.alpha = Qt(n.alpha, r.alpha, o), ws.transform(i));
}, E0 = /* @__PURE__ */ new Set(["none", "hidden"]);
function Pq(e, t) {
  return E0.has(e) ? (n) => n <= 0 ? e : t : (n) => n >= 1 ? t : e;
}
function Cq(e, t) {
  return (n) => Qt(e, t, n);
}
function P1(e) {
  return typeof e == "number" ? Cq : typeof e == "string" ? b1(e) ? Op : er.test(e) ? fP : Mq : Array.isArray(e) ? gI : typeof e == "object" ? er.test(e) ? fP : Eq : Op;
}
function gI(e, t) {
  const n = [...e], r = n.length, i = e.map((o, a) => P1(o)(o, t[a]));
  return (o) => {
    for (let a = 0; a < r; a++)
      n[a] = i[a](o);
    return n;
  };
}
function Eq(e, t) {
  const n = { ...e, ...t }, r = {};
  for (const i in n)
    e[i] !== void 0 && t[i] !== void 0 && (r[i] = P1(e[i])(e[i], t[i]));
  return (i) => {
    for (const o in r)
      n[o] = r[o](i);
    return n;
  };
}
function kq(e, t) {
  var n;
  const r = [], i = { color: 0, var: 0, number: 0 };
  for (let o = 0; o < t.values.length; o++) {
    const a = t.types[o], s = e.indexes[a][i[a]], l = (n = e.values[s]) !== null && n !== void 0 ? n : 0;
    r[o] = l, i[a]++;
  }
  return r;
}
const Mq = (e, t) => {
  const n = Ba.createTransformer(t), r = gf(e), i = gf(t);
  return r.indexes.var.length === i.indexes.var.length && r.indexes.color.length === i.indexes.color.length && r.indexes.number.length >= i.indexes.number.length ? E0.has(e) && !i.values.length || E0.has(t) && !r.values.length ? Pq(e, t) : $o(gI(kq(r, i), i.values), n) : (Ic(!0, `Complex values '${e}' and '${t}' too different to mix. Ensure all colors are of the same type, and that each contains the same quantity of number and color values. Falling back to instant transition.`), Op(e, t));
};
function yI(e, t, n) {
  return typeof e == "number" && typeof t == "number" && typeof n == "number" ? Qt(e, t, n) : P1(e)(e, t);
}
function Nq(e, t, n) {
  const r = [], i = n || yI, o = e.length - 1;
  for (let a = 0; a < o; a++) {
    let s = i(e[a], e[a + 1]);
    if (t) {
      const l = Array.isArray(t) ? t[a] || qn : t;
      s = $o(l, s);
    }
    r.push(s);
  }
  return r;
}
function $q(e, t, { clamp: n = !0, ease: r, mixer: i } = {}) {
  const o = e.length;
  if (Wo(o === t.length, "Both input and output ranges must be the same length"), o === 1)
    return () => t[0];
  if (o === 2 && e[0] === e[1])
    return () => t[1];
  e[0] > e[o - 1] && (e = [...e].reverse(), t = [...t].reverse());
  const a = Nq(t, r, i), s = a.length, l = (c) => {
    let f = 0;
    if (s > 1)
      for (; f < e.length - 2 && !(c < e[f + 1]); f++)
        ;
    const d = ec(e[f], e[f + 1], c);
    return a[f](d);
  };
  return n ? (c) => l(La(e[0], e[o - 1], c)) : l;
}
function Dq(e, t) {
  const n = e[e.length - 1];
  for (let r = 1; r <= t; r++) {
    const i = ec(0, t, r);
    e.push(Qt(n, 1, i));
  }
}
function Iq(e) {
  const t = [0];
  return Dq(t, e.length - 1), t;
}
function Rq(e, t) {
  return e.map((n) => n * t);
}
function jq(e, t) {
  return e.map(() => t || mI).splice(0, e.length - 1);
}
function Ap({ duration: e = 300, keyframes: t, times: n, ease: r = "easeInOut" }) {
  const i = _q(r) ? r.map(cP) : cP(r), o = {
    done: !1,
    value: t[0]
  }, a = Rq(
    // Only use the provided offsets if they're the correct length
    // TODO Maybe we should warn here if there's a length mismatch
    n && n.length === t.length ? n : Iq(t),
    e
  ), s = $q(a, t, {
    ease: Array.isArray(i) ? i : jq(t, i)
  });
  return {
    calculatedDuration: e,
    next: (l) => (o.value = s(l), o.done = l >= e, o)
  };
}
const dP = 2e4;
function Lq(e) {
  let t = 0;
  const n = 50;
  let r = e.next(t);
  for (; !r.done && t < dP; )
    t += n, r = e.next(t);
  return t >= dP ? 1 / 0 : t;
}
const Bq = (e) => {
  const t = ({ timestamp: n }) => e(n);
  return {
    start: () => Tt.update(t, !0),
    stop: () => ja(t),
    /**
     * If we're processing this frame we can use the
     * framelocked timestamp to keep things in sync.
     */
    now: () => zn.isProcessing ? zn.timestamp : qi.now()
  };
}, Fq = {
  decay: sP,
  inertia: sP,
  tween: Ap,
  keyframes: Ap,
  spring: pI
}, Wq = (e) => e / 100;
class C1 extends fI {
  constructor(t) {
    super(t), this.holdTime = null, this.cancelTime = null, this.currentTime = 0, this.playbackSpeed = 1, this.pendingPlayState = "running", this.startTime = null, this.state = "idle", this.stop = () => {
      if (this.resolver.cancel(), this.isStopped = !0, this.state === "idle")
        return;
      this.teardown();
      const { onStop: l } = this.options;
      l && l();
    };
    const { name: n, motionValue: r, element: i, keyframes: o } = this.options, a = (i == null ? void 0 : i.KeyframeResolver) || x1, s = (l, c) => this.onKeyframesResolved(l, c);
    this.resolver = new a(o, s, n, r, i), this.resolver.scheduleResolve();
  }
  flatten() {
    super.flatten(), this._resolved && Object.assign(this._resolved, this.initPlayback(this._resolved.keyframes));
  }
  initPlayback(t) {
    const { type: n = "keyframes", repeat: r = 0, repeatDelay: i = 0, repeatType: o, velocity: a = 0 } = this.options, s = A1(n) ? n : Fq[n] || Ap;
    let l, c;
    s !== Ap && typeof t[0] != "number" && ( true && Wo(t.length === 2, `Only two keyframes currently supported with spring and inertia animations. Trying to animate ${t}`), l = $o(Wq, yI(t[0], t[1])), t = [0, 100]);
    const f = s({ ...this.options, keyframes: t });
    o === "mirror" && (c = s({
      ...this.options,
      keyframes: [...t].reverse(),
      velocity: -a
    })), f.calculatedDuration === null && (f.calculatedDuration = Lq(f));
    const { calculatedDuration: d } = f, p = d + i, m = p * (r + 1) - i;
    return {
      generator: f,
      mirroredGenerator: c,
      mapPercentToKeyframes: l,
      calculatedDuration: d,
      resolvedDuration: p,
      totalDuration: m
    };
  }
  onPostResolved() {
    const { autoplay: t = !0 } = this.options;
    this.play(), this.pendingPlayState === "paused" || !t ? this.pause() : this.state = this.pendingPlayState;
  }
  tick(t, n = !1) {
    const { resolved: r } = this;
    if (!r) {
      const { keyframes: C } = this.options;
      return { done: !0, value: C[C.length - 1] };
    }
    const { finalKeyframe: i, generator: o, mirroredGenerator: a, mapPercentToKeyframes: s, keyframes: l, calculatedDuration: c, totalDuration: f, resolvedDuration: d } = r;
    if (this.startTime === null)
      return o.next(0);
    const { delay: p, repeat: m, repeatType: y, repeatDelay: g, onUpdate: v } = this.options;
    this.speed > 0 ? this.startTime = Math.min(this.startTime, t) : this.speed < 0 && (this.startTime = Math.min(t - f / this.speed, this.startTime)), n ? this.currentTime = t : this.holdTime !== null ? this.currentTime = this.holdTime : this.currentTime = Math.round(t - this.startTime) * this.speed;
    const x = this.currentTime - p * (this.speed >= 0 ? 1 : -1), w = this.speed >= 0 ? x < 0 : x > f;
    this.currentTime = Math.max(x, 0), this.state === "finished" && this.holdTime === null && (this.currentTime = f);
    let S = this.currentTime, A = o;
    if (m) {
      const C = Math.min(this.currentTime, f) / d;
      let k = Math.floor(C), I = C % 1;
      !I && C >= 1 && (I = 1), I === 1 && k--, k = Math.min(k, m + 1), !!(k % 2) && (y === "reverse" ? (I = 1 - I, g && (I -= g / d)) : y === "mirror" && (A = a)), S = La(0, 1, I) * d;
    }
    const _ = w ? { done: !1, value: l[0] } : A.next(S);
    s && (_.value = s(_.value));
    let { done: O } = _;
    !w && c !== null && (O = this.speed >= 0 ? this.currentTime >= f : this.currentTime <= 0);
    const P = this.holdTime === null && (this.state === "finished" || this.state === "running" && O);
    return P && i !== void 0 && (_.value = bg(l, this.options, i)), v && v(_.value), P && this.finish(), _;
  }
  get duration() {
    const { resolved: t } = this;
    return t ? No(t.calculatedDuration) : 0;
  }
  get time() {
    return No(this.currentTime);
  }
  set time(t) {
    t = Gi(t), this.currentTime = t, this.holdTime !== null || this.speed === 0 ? this.holdTime = t : this.driver && (this.startTime = this.driver.now() - t / this.speed);
  }
  get speed() {
    return this.playbackSpeed;
  }
  set speed(t) {
    const n = this.playbackSpeed !== t;
    this.playbackSpeed = t, n && (this.time = No(this.currentTime));
  }
  play() {
    if (this.resolver.isScheduled || this.resolver.resume(), !this._resolved) {
      this.pendingPlayState = "running";
      return;
    }
    if (this.isStopped)
      return;
    const { driver: t = Bq, onPlay: n, startTime: r } = this.options;
    this.driver || (this.driver = t((o) => this.tick(o))), n && n();
    const i = this.driver.now();
    this.holdTime !== null ? this.startTime = i - this.holdTime : this.startTime ? this.state === "finished" && (this.startTime = i) : this.startTime = r ?? this.calcStartTime(), this.state === "finished" && this.updateFinishedPromise(), this.cancelTime = this.startTime, this.holdTime = null, this.state = "running", this.driver.start();
  }
  pause() {
    var t;
    if (!this._resolved) {
      this.pendingPlayState = "paused";
      return;
    }
    this.state = "paused", this.holdTime = (t = this.currentTime) !== null && t !== void 0 ? t : 0;
  }
  complete() {
    this.state !== "running" && this.play(), this.pendingPlayState = this.state = "finished", this.holdTime = null;
  }
  finish() {
    this.teardown(), this.state = "finished";
    const { onComplete: t } = this.options;
    t && t();
  }
  cancel() {
    this.cancelTime !== null && this.tick(this.cancelTime), this.teardown(), this.updateFinishedPromise();
  }
  teardown() {
    this.state = "idle", this.stopDriver(), this.resolveFinishedPromise(), this.updateFinishedPromise(), this.startTime = this.cancelTime = null, this.resolver.cancel();
  }
  stopDriver() {
    this.driver && (this.driver.stop(), this.driver = void 0);
  }
  sample(t) {
    return this.startTime = 0, this.tick(t, !0);
  }
}
const zq = /* @__PURE__ */ new Set([
  "opacity",
  "clipPath",
  "filter",
  "transform"
  // TODO: Can be accelerated but currently disabled until https://issues.chromium.org/issues/41491098 is resolved
  // or until we implement support for linear() easing.
  // "background-color"
]), Vq = 10, Uq = (e, t) => {
  let n = "";
  const r = Math.max(Math.round(t / Vq), 2);
  for (let i = 0; i < r; i++)
    n += e(ec(0, r - 1, i)) + ", ";
  return `linear(${n.substring(0, n.length - 2)})`;
};
function E1(e) {
  let t;
  return () => (t === void 0 && (t = e()), t);
}
const Hq = {
  linearEasing: void 0
};
function Kq(e, t) {
  const n = E1(e);
  return () => {
    var r;
    return (r = Hq[t]) !== null && r !== void 0 ? r : n();
  };
}
const Tp = /* @__PURE__ */ Kq(() => {
  try {
    document.createElement("div").animate({ opacity: 0 }, { easing: "linear(0, 1)" });
  } catch {
    return !1;
  }
  return !0;
}, "linearEasing");
function vI(e) {
  return !!(typeof e == "function" && Tp() || !e || typeof e == "string" && (e in k0 || Tp()) || T1(e) || Array.isArray(e) && e.every(vI));
}
const Lu = ([e, t, n, r]) => `cubic-bezier(${e}, ${t}, ${n}, ${r})`, k0 = {
  linear: "linear",
  ease: "ease",
  easeIn: "ease-in",
  easeOut: "ease-out",
  easeInOut: "ease-in-out",
  circIn: /* @__PURE__ */ Lu([0, 0.65, 0.55, 1]),
  circOut: /* @__PURE__ */ Lu([0.55, 0, 1, 0.45]),
  backIn: /* @__PURE__ */ Lu([0.31, 0.01, 0.66, -0.59]),
  backOut: /* @__PURE__ */ Lu([0.33, 1.53, 0.69, 0.99])
};
function bI(e, t) {
  if (e)
    return typeof e == "function" && Tp() ? Uq(e, t) : T1(e) ? Lu(e) : Array.isArray(e) ? e.map((n) => bI(n, t) || k0.easeOut) : k0[e];
}
function Gq(e, t, n, { delay: r = 0, duration: i = 300, repeat: o = 0, repeatType: a = "loop", ease: s = "easeInOut", times: l } = {}) {
  const c = { [t]: n };
  l && (c.offset = l);
  const f = bI(s, i);
  return Array.isArray(f) && (c.easing = f), e.animate(c, {
    delay: r,
    duration: i,
    easing: Array.isArray(f) ? "linear" : f,
    fill: "both",
    iterations: o + 1,
    direction: a === "reverse" ? "alternate" : "normal"
  });
}
function hP(e, t) {
  e.timeline = t, e.onfinish = null;
}
const Yq = /* @__PURE__ */ E1(() => Object.hasOwnProperty.call(Element.prototype, "animate")), Pp = 10, qq = 2e4;
function Xq(e) {
  return A1(e.type) || e.type === "spring" || !vI(e.ease);
}
function Zq(e, t) {
  const n = new C1({
    ...t,
    keyframes: e,
    repeat: 0,
    delay: 0,
    isGenerator: !0
  });
  let r = { done: !1, value: e[0] };
  const i = [];
  let o = 0;
  for (; !r.done && o < qq; )
    r = n.sample(o), i.push(r.value), o += Pp;
  return {
    times: void 0,
    keyframes: i,
    duration: o - Pp,
    ease: "linear"
  };
}
const xI = {
  anticipate: KD,
  backInOut: HD,
  circInOut: YD
};
function Jq(e) {
  return e in xI;
}
class pP extends fI {
  constructor(t) {
    super(t);
    const { name: n, motionValue: r, element: i, keyframes: o } = this.options;
    this.resolver = new uI(o, (a, s) => this.onKeyframesResolved(a, s), n, r, i), this.resolver.scheduleResolve();
  }
  initPlayback(t, n) {
    var r;
    let { duration: i = 300, times: o, ease: a, type: s, motionValue: l, name: c, startTime: f } = this.options;
    if (!(!((r = l.owner) === null || r === void 0) && r.current))
      return !1;
    if (typeof a == "string" && Tp() && Jq(a) && (a = xI[a]), Xq(this.options)) {
      const { onComplete: p, onUpdate: m, motionValue: y, element: g, ...v } = this.options, x = Zq(t, v);
      t = x.keyframes, t.length === 1 && (t[1] = t[0]), i = x.duration, o = x.times, a = x.ease, s = "keyframes";
    }
    const d = Gq(l.owner.current, c, t, { ...this.options, duration: i, times: o, ease: a });
    return d.startTime = f ?? this.calcStartTime(), this.pendingTimeline ? (hP(d, this.pendingTimeline), this.pendingTimeline = void 0) : d.onfinish = () => {
      const { onComplete: p } = this.options;
      l.set(bg(t, this.options, n)), p && p(), this.cancel(), this.resolveFinishedPromise();
    }, {
      animation: d,
      duration: i,
      times: o,
      type: s,
      ease: a,
      keyframes: t
    };
  }
  get duration() {
    const { resolved: t } = this;
    if (!t)
      return 0;
    const { duration: n } = t;
    return No(n);
  }
  get time() {
    const { resolved: t } = this;
    if (!t)
      return 0;
    const { animation: n } = t;
    return No(n.currentTime || 0);
  }
  set time(t) {
    const { resolved: n } = this;
    if (!n)
      return;
    const { animation: r } = n;
    r.currentTime = Gi(t);
  }
  get speed() {
    const { resolved: t } = this;
    if (!t)
      return 1;
    const { animation: n } = t;
    return n.playbackRate;
  }
  set speed(t) {
    const { resolved: n } = this;
    if (!n)
      return;
    const { animation: r } = n;
    r.playbackRate = t;
  }
  get state() {
    const { resolved: t } = this;
    if (!t)
      return "idle";
    const { animation: n } = t;
    return n.playState;
  }
  get startTime() {
    const { resolved: t } = this;
    if (!t)
      return null;
    const { animation: n } = t;
    return n.startTime;
  }
  /**
   * Replace the default DocumentTimeline with another AnimationTimeline.
   * Currently used for scroll animations.
   */
  attachTimeline(t) {
    if (!this._resolved)
      this.pendingTimeline = t;
    else {
      const { resolved: n } = this;
      if (!n)
        return qn;
      const { animation: r } = n;
      hP(r, t);
    }
    return qn;
  }
  play() {
    if (this.isStopped)
      return;
    const { resolved: t } = this;
    if (!t)
      return;
    const { animation: n } = t;
    n.playState === "finished" && this.updateFinishedPromise(), n.play();
  }
  pause() {
    const { resolved: t } = this;
    if (!t)
      return;
    const { animation: n } = t;
    n.pause();
  }
  stop() {
    if (this.resolver.cancel(), this.isStopped = !0, this.state === "idle")
      return;
    this.resolveFinishedPromise(), this.updateFinishedPromise();
    const { resolved: t } = this;
    if (!t)
      return;
    const { animation: n, keyframes: r, duration: i, type: o, ease: a, times: s } = t;
    if (n.playState === "idle" || n.playState === "finished")
      return;
    if (this.time) {
      const { motionValue: c, onUpdate: f, onComplete: d, element: p, ...m } = this.options, y = new C1({
        ...m,
        keyframes: r,
        duration: i,
        type: o,
        ease: a,
        times: s,
        isGenerator: !0
      }), g = Gi(this.time);
      c.setWithVelocity(y.sample(g - Pp).value, y.sample(g).value, Pp);
    }
    const { onStop: l } = this.options;
    l && l(), this.cancel();
  }
  complete() {
    const { resolved: t } = this;
    t && t.animation.finish();
  }
  cancel() {
    const { resolved: t } = this;
    t && t.animation.cancel();
  }
  static supports(t) {
    const { motionValue: n, name: r, repeatDelay: i, repeatType: o, damping: a, type: s } = t;
    return Yq() && r && zq.has(r) && n && n.owner && n.owner.current instanceof HTMLElement && /**
     * If we're outputting values to onUpdate then we can't use WAAPI as there's
     * no way to read the value from WAAPI every frame.
     */
    !n.owner.getProps().onUpdate && !i && o !== "mirror" && a !== 0 && s !== "inertia";
  }
}
const Qq = E1(() => window.ScrollTimeline !== void 0);
class e9 {
  constructor(t) {
    this.stop = () => this.runAll("stop"), this.animations = t.filter(Boolean);
  }
  then(t, n) {
    return Promise.all(this.animations).then(t).catch(n);
  }
  /**
   * TODO: Filter out cancelled or stopped animations before returning
   */
  getAll(t) {
    return this.animations[0][t];
  }
  setAll(t, n) {
    for (let r = 0; r < this.animations.length; r++)
      this.animations[r][t] = n;
  }
  attachTimeline(t, n) {
    const r = this.animations.map((i) => Qq() && i.attachTimeline ? i.attachTimeline(t) : n(i));
    return () => {
      r.forEach((i, o) => {
        i && i(), this.animations[o].stop();
      });
    };
  }
  get time() {
    return this.getAll("time");
  }
  set time(t) {
    this.setAll("time", t);
  }
  get speed() {
    return this.getAll("speed");
  }
  set speed(t) {
    this.setAll("speed", t);
  }
  get startTime() {
    return this.getAll("startTime");
  }
  get duration() {
    let t = 0;
    for (let n = 0; n < this.animations.length; n++)
      t = Math.max(t, this.animations[n].duration);
    return t;
  }
  runAll(t) {
    this.animations.forEach((n) => n[t]());
  }
  flatten() {
    this.runAll("flatten");
  }
  play() {
    this.runAll("play");
  }
  pause() {
    this.runAll("pause");
  }
  cancel() {
    this.runAll("cancel");
  }
  complete() {
    this.runAll("complete");
  }
}
function t9({ when: e, delay: t, delayChildren: n, staggerChildren: r, staggerDirection: i, repeat: o, repeatType: a, repeatDelay: s, from: l, elapsed: c, ...f }) {
  return !!Object.keys(f).length;
}
const k1 = (e, t, n, r = {}, i, o) => (a) => {
  const s = g1(r, e) || {}, l = s.delay || r.delay || 0;
  let { elapsed: c = 0 } = r;
  c = c - Gi(l);
  let f = {
    keyframes: Array.isArray(n) ? n : [null, n],
    ease: "easeOut",
    velocity: t.getVelocity(),
    ...s,
    delay: -c,
    onUpdate: (p) => {
      t.set(p), s.onUpdate && s.onUpdate(p);
    },
    onComplete: () => {
      a(), s.onComplete && s.onComplete();
    },
    name: e,
    motionValue: t,
    element: o ? void 0 : i
  };
  t9(s) || (f = {
    ...f,
    ...bY(e, f)
  }), f.duration && (f.duration = Gi(f.duration)), f.repeatDelay && (f.repeatDelay = Gi(f.repeatDelay)), f.from !== void 0 && (f.keyframes[0] = f.from);
  let d = !1;
  if ((f.type === !1 || f.duration === 0 && !f.repeatDelay) && (f.duration = 0, f.delay === 0 && (d = !0)), d && !o && t.get() !== void 0) {
    const p = bg(f.keyframes, s);
    if (p !== void 0)
      return Tt.update(() => {
        f.onUpdate(p), f.onComplete();
      }), new e9([]);
  }
  return !o && pP.supports(f) ? new pP(f) : new C1(f);
}, n9 = (e) => !!(e && typeof e == "object" && e.mix && e.toValue), r9 = (e) => S0(e) ? e[e.length - 1] || 0 : e;
function M1(e, t) {
  e.indexOf(t) === -1 && e.push(t);
}
function N1(e, t) {
  const n = e.indexOf(t);
  n > -1 && e.splice(n, 1);
}
class $1 {
  constructor() {
    this.subscriptions = [];
  }
  add(t) {
    return M1(this.subscriptions, t), () => N1(this.subscriptions, t);
  }
  notify(t, n, r) {
    const i = this.subscriptions.length;
    if (i)
      if (i === 1)
        this.subscriptions[0](t, n, r);
      else
        for (let o = 0; o < i; o++) {
          const a = this.subscriptions[o];
          a && a(t, n, r);
        }
  }
  getSize() {
    return this.subscriptions.length;
  }
  clear() {
    this.subscriptions.length = 0;
  }
}
const mP = 30, i9 = (e) => !isNaN(parseFloat(e));
class o9 {
  /**
   * @param init - The initiating value
   * @param config - Optional configuration options
   *
   * -  `transformer`: A function to transform incoming values with.
   *
   * @internal
   */
  constructor(t, n = {}) {
    this.version = "11.11.17", this.canTrackVelocity = null, this.events = {}, this.updateAndNotify = (r, i = !0) => {
      const o = qi.now();
      this.updatedAt !== o && this.setPrevFrameValue(), this.prev = this.current, this.setCurrent(r), this.current !== this.prev && this.events.change && this.events.change.notify(this.current), i && this.events.renderRequest && this.events.renderRequest.notify(this.current);
    }, this.hasAnimated = !1, this.setCurrent(t), this.owner = n.owner;
  }
  setCurrent(t) {
    this.current = t, this.updatedAt = qi.now(), this.canTrackVelocity === null && t !== void 0 && (this.canTrackVelocity = i9(this.current));
  }
  setPrevFrameValue(t = this.current) {
    this.prevFrameValue = t, this.prevUpdatedAt = this.updatedAt;
  }
  /**
   * Adds a function that will be notified when the `MotionValue` is updated.
   *
   * It returns a function that, when called, will cancel the subscription.
   *
   * When calling `onChange` inside a React component, it should be wrapped with the
   * `useEffect` hook. As it returns an unsubscribe function, this should be returned
   * from the `useEffect` function to ensure you don't add duplicate subscribers..
   *
   * ```jsx
   * export const MyComponent = () => {
   *   const x = useMotionValue(0)
   *   const y = useMotionValue(0)
   *   const opacity = useMotionValue(1)
   *
   *   useEffect(() => {
   *     function updateOpacity() {
   *       const maxXY = Math.max(x.get(), y.get())
   *       const newOpacity = transform(maxXY, [0, 100], [1, 0])
   *       opacity.set(newOpacity)
   *     }
   *
   *     const unsubscribeX = x.on("change", updateOpacity)
   *     const unsubscribeY = y.on("change", updateOpacity)
   *
   *     return () => {
   *       unsubscribeX()
   *       unsubscribeY()
   *     }
   *   }, [])
   *
   *   return <motion.div style={{ x }} />
   * }
   * ```
   *
   * @param subscriber - A function that receives the latest value.
   * @returns A function that, when called, will cancel this subscription.
   *
   * @deprecated
   */
  onChange(t) {
    return  true && gg(!1, 'value.onChange(callback) is deprecated. Switch to value.on("change", callback).'), this.on("change", t);
  }
  on(t, n) {
    this.events[t] || (this.events[t] = new $1());
    const r = this.events[t].add(n);
    return t === "change" ? () => {
      r(), Tt.read(() => {
        this.events.change.getSize() || this.stop();
      });
    } : r;
  }
  clearListeners() {
    for (const t in this.events)
      this.events[t].clear();
  }
  /**
   * Attaches a passive effect to the `MotionValue`.
   *
   * @internal
   */
  attach(t, n) {
    this.passiveEffect = t, this.stopPassiveEffect = n;
  }
  /**
   * Sets the state of the `MotionValue`.
   *
   * @remarks
   *
   * ```jsx
   * const x = useMotionValue(0)
   * x.set(10)
   * ```
   *
   * @param latest - Latest value to set.
   * @param render - Whether to notify render subscribers. Defaults to `true`
   *
   * @public
   */
  set(t, n = !0) {
    !n || !this.passiveEffect ? this.updateAndNotify(t, n) : this.passiveEffect(t, this.updateAndNotify);
  }
  setWithVelocity(t, n, r) {
    this.set(n), this.prev = void 0, this.prevFrameValue = t, this.prevUpdatedAt = this.updatedAt - r;
  }
  /**
   * Set the state of the `MotionValue`, stopping any active animations,
   * effects, and resets velocity to `0`.
   */
  jump(t, n = !0) {
    this.updateAndNotify(t), this.prev = t, this.prevUpdatedAt = this.prevFrameValue = void 0, n && this.stop(), this.stopPassiveEffect && this.stopPassiveEffect();
  }
  /**
   * Returns the latest state of `MotionValue`
   *
   * @returns - The latest state of `MotionValue`
   *
   * @public
   */
  get() {
    return this.current;
  }
  /**
   * @public
   */
  getPrevious() {
    return this.prev;
  }
  /**
   * Returns the latest velocity of `MotionValue`
   *
   * @returns - The latest velocity of `MotionValue`. Returns `0` if the state is non-numerical.
   *
   * @public
   */
  getVelocity() {
    const t = qi.now();
    if (!this.canTrackVelocity || this.prevFrameValue === void 0 || t - this.updatedAt > mP)
      return 0;
    const n = Math.min(this.updatedAt - this.prevUpdatedAt, mP);
    return dI(parseFloat(this.current) - parseFloat(this.prevFrameValue), n);
  }
  /**
   * Registers a new animation to control this `MotionValue`. Only one
   * animation can drive a `MotionValue` at one time.
   *
   * ```jsx
   * value.start()
   * ```
   *
   * @param animation - A function that starts the provided animation
   *
   * @internal
   */
  start(t) {
    return this.stop(), new Promise((n) => {
      this.hasAnimated = !0, this.animation = t(n), this.events.animationStart && this.events.animationStart.notify();
    }).then(() => {
      this.events.animationComplete && this.events.animationComplete.notify(), this.clearAnimation();
    });
  }
  /**
   * Stop the currently active animation.
   *
   * @public
   */
  stop() {
    this.animation && (this.animation.stop(), this.events.animationCancel && this.events.animationCancel.notify()), this.clearAnimation();
  }
  /**
   * Returns `true` if this value is currently animating.
   *
   * @public
   */
  isAnimating() {
    return !!this.animation;
  }
  clearAnimation() {
    delete this.animation;
  }
  /**
   * Destroy and clean up subscribers to this `MotionValue`.
   *
   * The `MotionValue` hooks like `useMotionValue` and `useTransform` automatically
   * handle the lifecycle of the returned `MotionValue`, so this method is only necessary if you've manually
   * created a `MotionValue` via the `motionValue` function.
   *
   * @public
   */
  destroy() {
    this.clearListeners(), this.stop(), this.stopPassiveEffect && this.stopPassiveEffect();
  }
}
function yf(e, t) {
  return new o9(e, t);
}
function a9(e, t, n) {
  e.hasValue(t) ? e.getValue(t).set(n) : e.addValue(t, yf(n));
}
function s9(e, t) {
  const n = vg(e, t);
  let { transitionEnd: r = {}, transition: i = {}, ...o } = n || {};
  o = { ...o, ...r };
  for (const a in o) {
    const s = r9(o[a]);
    a9(e, a, s);
  }
}
const D1 = (e) => e.replace(/([a-z])([A-Z])/gu, "$1-$2").toLowerCase(), l9 = "framerAppearId", wI = "data-" + D1(l9);
function _I(e) {
  return e.props[wI];
}
const rr = (e) => !!(e && e.getVelocity);
function c9(e) {
  return !!(rr(e) && e.add);
}
function M0(e, t) {
  const n = e.getValue("willChange");
  if (c9(n))
    return n.add(t);
}
function u9({ protectedKeys: e, needsAnimating: t }, n) {
  const r = e.hasOwnProperty(n) && t[n] !== !0;
  return t[n] = !1, r;
}
function SI(e, t, { delay: n = 0, transitionOverride: r, type: i } = {}) {
  var o;
  let { transition: a = e.getDefaultTransition(), transitionEnd: s, ...l } = t;
  r && (a = r);
  const c = [], f = i && e.animationState && e.animationState.getState()[i];
  for (const d in l) {
    const p = e.getValue(d, (o = e.latestValues[d]) !== null && o !== void 0 ? o : null), m = l[d];
    if (m === void 0 || f && u9(f, d))
      continue;
    const y = {
      delay: n,
      ...g1(a || {}, d)
    };
    let g = !1;
    if (window.MotionHandoffAnimation) {
      const x = _I(e);
      if (x) {
        const w = window.MotionHandoffAnimation(x, d, Tt);
        w !== null && (y.startTime = w, g = !0);
      }
    }
    M0(e, d), p.start(k1(d, p, m, e.shouldReduceMotion && Gs.has(d) ? { type: !1 } : y, e, g));
    const v = p.animation;
    v && c.push(v);
  }
  return s && Promise.all(c).then(() => {
    Tt.update(() => {
      s && s9(e, s);
    });
  }), c;
}
function N0(e, t, n = {}) {
  var r;
  const i = vg(e, t, n.type === "exit" ? (r = e.presenceContext) === null || r === void 0 ? void 0 : r.custom : void 0);
  let { transition: o = e.getDefaultTransition() || {} } = i || {};
  n.transitionOverride && (o = n.transitionOverride);
  const a = i ? () => Promise.all(SI(e, i, n)) : () => Promise.resolve(), s = e.variantChildren && e.variantChildren.size ? (c = 0) => {
    const { delayChildren: f = 0, staggerChildren: d, staggerDirection: p } = o;
    return f9(e, t, f + c, d, p, n);
  } : () => Promise.resolve(), { when: l } = o;
  if (l) {
    const [c, f] = l === "beforeChildren" ? [a, s] : [s, a];
    return c().then(() => f());
  } else
    return Promise.all([a(), s(n.delay)]);
}
function f9(e, t, n = 0, r = 0, i = 1, o) {
  const a = [], s = (e.variantChildren.size - 1) * r, l = i === 1 ? (c = 0) => c * r : (c = 0) => s - c * r;
  return Array.from(e.variantChildren).sort(d9).forEach((c, f) => {
    c.notify("AnimationStart", t), a.push(N0(c, t, {
      ...o,
      delay: n + l(f)
    }).then(() => c.notify("AnimationComplete", t)));
  }), Promise.all(a);
}
function d9(e, t) {
  return e.sortNodePosition(t);
}
function h9(e, t, n = {}) {
  e.notify("AnimationStart", t);
  let r;
  if (Array.isArray(t)) {
    const i = t.map((o) => N0(e, o, n));
    r = Promise.all(i);
  } else if (typeof t == "string")
    r = N0(e, t, n);
  else {
    const i = typeof t == "function" ? vg(e, t, n.custom) : t;
    r = Promise.all(SI(e, i, n));
  }
  return r.then(() => {
    e.notify("AnimationComplete", t);
  });
}
const p9 = m1.length;
function OI(e) {
  if (!e)
    return;
  if (!e.isControllingVariants) {
    const n = e.parent ? OI(e.parent) || {} : {};
    return e.props.initial !== void 0 && (n.initial = e.props.initial), n;
  }
  const t = {};
  for (let n = 0; n < p9; n++) {
    const r = m1[n], i = e.props[r];
    (pf(i) || i === !1) && (t[r] = i);
  }
  return t;
}
const m9 = [...p1].reverse(), g9 = p1.length;
function y9(e) {
  return (t) => Promise.all(t.map(({ animation: n, options: r }) => h9(e, n, r)));
}
function v9(e) {
  let t = y9(e), n = gP(), r = !0;
  const i = (l) => (c, f) => {
    var d;
    const p = vg(e, f, l === "exit" ? (d = e.presenceContext) === null || d === void 0 ? void 0 : d.custom : void 0);
    if (p) {
      const { transition: m, transitionEnd: y, ...g } = p;
      c = { ...c, ...g, ...y };
    }
    return c;
  };
  function o(l) {
    t = l(e);
  }
  function a(l) {
    const { props: c } = e, f = OI(e.parent) || {}, d = [], p = /* @__PURE__ */ new Set();
    let m = {}, y = 1 / 0;
    for (let v = 0; v < g9; v++) {
      const x = m9[v], w = n[x], S = c[x] !== void 0 ? c[x] : f[x], A = pf(S), _ = x === l ? w.isActive : null;
      _ === !1 && (y = v);
      let O = S === f[x] && S !== c[x] && A;
      if (O && r && e.manuallyAnimateOnMount && (O = !1), w.protectedKeys = { ...m }, // If it isn't active and hasn't *just* been set as inactive
      !w.isActive && _ === null || // If we didn't and don't have any defined prop for this animation type
      !S && !w.prevProp || // Or if the prop doesn't define an animation
      yg(S) || typeof S == "boolean")
        continue;
      const P = b9(w.prevProp, S);
      let C = P || // If we're making this variant active, we want to always make it active
      x === l && w.isActive && !O && A || // If we removed a higher-priority variant (i is in reverse order)
      v > y && A, k = !1;
      const I = Array.isArray(S) ? S : [S];
      let $ = I.reduce(i(x), {});
      _ === !1 && ($ = {});
      const { prevResolvedValues: N = {} } = w, D = {
        ...N,
        ...$
      }, j = (z) => {
        C = !0, p.has(z) && (k = !0, p.delete(z)), w.needsAnimating[z] = !0;
        const H = e.getValue(z);
        H && (H.liveStyle = !1);
      };
      for (const z in D) {
        const H = $[z], U = N[z];
        if (m.hasOwnProperty(z))
          continue;
        let V = !1;
        S0(H) && S0(U) ? V = !BD(H, U) : V = H !== U, V ? H != null ? j(z) : p.add(z) : H !== void 0 && p.has(z) ? j(z) : w.protectedKeys[z] = !0;
      }
      w.prevProp = S, w.prevResolvedValues = $, w.isActive && (m = { ...m, ...$ }), r && e.blockInitialAnimation && (C = !1), C && (!(O && P) || k) && d.push(...I.map((z) => ({
        animation: z,
        options: { type: x }
      })));
    }
    if (p.size) {
      const v = {};
      p.forEach((x) => {
        const w = e.getBaseTarget(x), S = e.getValue(x);
        S && (S.liveStyle = !0), v[x] = w ?? null;
      }), d.push({ animation: v });
    }
    let g = !!d.length;
    return r && (c.initial === !1 || c.initial === c.animate) && !e.manuallyAnimateOnMount && (g = !1), r = !1, g ? t(d) : Promise.resolve();
  }
  function s(l, c) {
    var f;
    if (n[l].isActive === c)
      return Promise.resolve();
    (f = e.variantChildren) === null || f === void 0 || f.forEach((p) => {
      var m;
      return (m = p.animationState) === null || m === void 0 ? void 0 : m.setActive(l, c);
    }), n[l].isActive = c;
    const d = a(l);
    for (const p in n)
      n[p].protectedKeys = {};
    return d;
  }
  return {
    animateChanges: a,
    setActive: s,
    setAnimateFunction: o,
    getState: () => n,
    reset: () => {
      n = gP(), r = !0;
    }
  };
}
function b9(e, t) {
  return typeof t == "string" ? t !== e : Array.isArray(t) ? !BD(t, e) : !1;
}
function ss(e = !1) {
  return {
    isActive: e,
    protectedKeys: {},
    needsAnimating: {},
    prevResolvedValues: {}
  };
}
function gP() {
  return {
    animate: ss(!0),
    whileInView: ss(),
    whileHover: ss(),
    whileTap: ss(),
    whileDrag: ss(),
    whileFocus: ss(),
    exit: ss()
  };
}
class Va {
  constructor(t) {
    this.isMounted = !1, this.node = t;
  }
  update() {
  }
}
class x9 extends Va {
  /**
   * We dynamically generate the AnimationState manager as it contains a reference
   * to the underlying animation library. We only want to load that if we load this,
   * so people can optionally code split it out using the `m` component.
   */
  constructor(t) {
    super(t), t.animationState || (t.animationState = v9(t));
  }
  updateAnimationControlsSubscription() {
    const { animate: t } = this.node.getProps();
    yg(t) && (this.unmountControls = t.subscribe(this.node));
  }
  /**
   * Subscribe any provided AnimationControls to the component's VisualElement
   */
  mount() {
    this.updateAnimationControlsSubscription();
  }
  update() {
    const { animate: t } = this.node.getProps(), { animate: n } = this.node.prevProps || {};
    t !== n && this.updateAnimationControlsSubscription();
  }
  unmount() {
    var t;
    this.node.animationState.reset(), (t = this.unmountControls) === null || t === void 0 || t.call(this);
  }
}
let w9 = 0;
class _9 extends Va {
  constructor() {
    super(...arguments), this.id = w9++;
  }
  update() {
    if (!this.node.presenceContext)
      return;
    const { isPresent: t, onExitComplete: n } = this.node.presenceContext, { isPresent: r } = this.node.prevPresenceContext || {};
    if (!this.node.animationState || t === r)
      return;
    const i = this.node.animationState.setActive("exit", !t);
    n && !t && i.then(() => n(this.id));
  }
  mount() {
    const { register: t } = this.node.presenceContext || {};
    t && (this.unmount = t(this.id));
  }
  unmount() {
  }
}
const S9 = {
  animation: {
    Feature: x9
  },
  exit: {
    Feature: _9
  }
}, AI = (e) => e.pointerType === "mouse" ? typeof e.button != "number" || e.button <= 0 : e.isPrimary !== !1;
function xg(e, t = "page") {
  return {
    point: {
      x: e[`${t}X`],
      y: e[`${t}Y`]
    }
  };
}
const O9 = (e) => (t) => AI(t) && e(t, xg(t));
function To(e, t, n, r = { passive: !0 }) {
  return e.addEventListener(t, n, r), () => e.removeEventListener(t, n);
}
function Do(e, t, n, r) {
  return To(e, t, O9(n), r);
}
const yP = (e, t) => Math.abs(e - t);
function A9(e, t) {
  const n = yP(e.x, t.x), r = yP(e.y, t.y);
  return Math.sqrt(n ** 2 + r ** 2);
}
class TI {
  constructor(t, n, { transformPagePoint: r, contextWindow: i, dragSnapToOrigin: o = !1 } = {}) {
    if (this.startEvent = null, this.lastMoveEvent = null, this.lastMoveEventInfo = null, this.handlers = {}, this.contextWindow = window, this.updatePoint = () => {
      if (!(this.lastMoveEvent && this.lastMoveEventInfo))
        return;
      const d = ab(this.lastMoveEventInfo, this.history), p = this.startEvent !== null, m = A9(d.offset, { x: 0, y: 0 }) >= 3;
      if (!p && !m)
        return;
      const { point: y } = d, { timestamp: g } = zn;
      this.history.push({ ...y, timestamp: g });
      const { onStart: v, onMove: x } = this.handlers;
      p || (v && v(this.lastMoveEvent, d), this.startEvent = this.lastMoveEvent), x && x(this.lastMoveEvent, d);
    }, this.handlePointerMove = (d, p) => {
      this.lastMoveEvent = d, this.lastMoveEventInfo = ob(p, this.transformPagePoint), Tt.update(this.updatePoint, !0);
    }, this.handlePointerUp = (d, p) => {
      this.end();
      const { onEnd: m, onSessionEnd: y, resumeAnimation: g } = this.handlers;
      if (this.dragSnapToOrigin && g && g(), !(this.lastMoveEvent && this.lastMoveEventInfo))
        return;
      const v = ab(d.type === "pointercancel" ? this.lastMoveEventInfo : ob(p, this.transformPagePoint), this.history);
      this.startEvent && m && m(d, v), y && y(d, v);
    }, !AI(t))
      return;
    this.dragSnapToOrigin = o, this.handlers = n, this.transformPagePoint = r, this.contextWindow = i || window;
    const a = xg(t), s = ob(a, this.transformPagePoint), { point: l } = s, { timestamp: c } = zn;
    this.history = [{ ...l, timestamp: c }];
    const { onSessionStart: f } = n;
    f && f(t, ab(s, this.history)), this.removeListeners = $o(Do(this.contextWindow, "pointermove", this.handlePointerMove), Do(this.contextWindow, "pointerup", this.handlePointerUp), Do(this.contextWindow, "pointercancel", this.handlePointerUp));
  }
  updateHandlers(t) {
    this.handlers = t;
  }
  end() {
    this.removeListeners && this.removeListeners(), ja(this.updatePoint);
  }
}
function ob(e, t) {
  return t ? { point: t(e.point) } : e;
}
function vP(e, t) {
  return { x: e.x - t.x, y: e.y - t.y };
}
function ab({ point: e }, t) {
  return {
    point: e,
    delta: vP(e, PI(t)),
    offset: vP(e, T9(t)),
    velocity: P9(t, 0.1)
  };
}
function T9(e) {
  return e[0];
}
function PI(e) {
  return e[e.length - 1];
}
function P9(e, t) {
  if (e.length < 2)
    return { x: 0, y: 0 };
  let n = e.length - 1, r = null;
  const i = PI(e);
  for (; n >= 0 && (r = e[n], !(i.timestamp - r.timestamp > Gi(t))); )
    n--;
  if (!r)
    return { x: 0, y: 0 };
  const o = No(i.timestamp - r.timestamp);
  if (o === 0)
    return { x: 0, y: 0 };
  const a = {
    x: (i.x - r.x) / o,
    y: (i.y - r.y) / o
  };
  return a.x === 1 / 0 && (a.x = 0), a.y === 1 / 0 && (a.y = 0), a;
}
function CI(e) {
  let t = null;
  return () => {
    const n = () => {
      t = null;
    };
    return t === null ? (t = e, n) : !1;
  };
}
const bP = CI("dragHorizontal"), xP = CI("dragVertical");
function EI(e) {
  let t = !1;
  if (e === "y")
    t = xP();
  else if (e === "x")
    t = bP();
  else {
    const n = bP(), r = xP();
    n && r ? t = () => {
      n(), r();
    } : (n && n(), r && r());
  }
  return t;
}
function kI() {
  const e = EI(!0);
  return e ? (e(), !1) : !0;
}
function Nl(e) {
  return e && typeof e == "object" && Object.prototype.hasOwnProperty.call(e, "current");
}
const MI = 1e-4, C9 = 1 - MI, E9 = 1 + MI, NI = 0.01, k9 = 0 - NI, M9 = 0 + NI;
function Kr(e) {
  return e.max - e.min;
}
function N9(e, t, n) {
  return Math.abs(e - t) <= n;
}
function wP(e, t, n, r = 0.5) {
  e.origin = r, e.originPoint = Qt(t.min, t.max, e.origin), e.scale = Kr(n) / Kr(t), e.translate = Qt(n.min, n.max, e.origin) - e.originPoint, (e.scale >= C9 && e.scale <= E9 || isNaN(e.scale)) && (e.scale = 1), (e.translate >= k9 && e.translate <= M9 || isNaN(e.translate)) && (e.translate = 0);
}
function Gu(e, t, n, r) {
  wP(e.x, t.x, n.x, r ? r.originX : void 0), wP(e.y, t.y, n.y, r ? r.originY : void 0);
}
function _P(e, t, n) {
  e.min = n.min + t.min, e.max = e.min + Kr(t);
}
function $9(e, t, n) {
  _P(e.x, t.x, n.x), _P(e.y, t.y, n.y);
}
function SP(e, t, n) {
  e.min = t.min - n.min, e.max = e.min + Kr(t);
}
function Yu(e, t, n) {
  SP(e.x, t.x, n.x), SP(e.y, t.y, n.y);
}
function D9(e, { min: t, max: n }, r) {
  return t !== void 0 && e < t ? e = r ? Qt(t, e, r.min) : Math.max(e, t) : n !== void 0 && e > n && (e = r ? Qt(n, e, r.max) : Math.min(e, n)), e;
}
function OP(e, t, n) {
  return {
    min: t !== void 0 ? e.min + t : void 0,
    max: n !== void 0 ? e.max + n - (e.max - e.min) : void 0
  };
}
function I9(e, { top: t, left: n, bottom: r, right: i }) {
  return {
    x: OP(e.x, n, i),
    y: OP(e.y, t, r)
  };
}
function AP(e, t) {
  let n = t.min - e.min, r = t.max - e.max;
  return t.max - t.min < e.max - e.min && ([n, r] = [r, n]), { min: n, max: r };
}
function R9(e, t) {
  return {
    x: AP(e.x, t.x),
    y: AP(e.y, t.y)
  };
}
function j9(e, t) {
  let n = 0.5;
  const r = Kr(e), i = Kr(t);
  return i > r ? n = ec(t.min, t.max - r, e.min) : r > i && (n = ec(e.min, e.max - i, t.min)), La(0, 1, n);
}
function L9(e, t) {
  const n = {};
  return t.min !== void 0 && (n.min = t.min - e.min), t.max !== void 0 && (n.max = t.max - e.min), n;
}
const $0 = 0.35;
function B9(e = $0) {
  return e === !1 ? e = 0 : e === !0 && (e = $0), {
    x: TP(e, "left", "right"),
    y: TP(e, "top", "bottom")
  };
}
function TP(e, t, n) {
  return {
    min: PP(e, t),
    max: PP(e, n)
  };
}
function PP(e, t) {
  return typeof e == "number" ? e : e[t] || 0;
}
const CP = () => ({
  translate: 0,
  scale: 1,
  origin: 0,
  originPoint: 0
}), $l = () => ({
  x: CP(),
  y: CP()
}), EP = () => ({ min: 0, max: 0 }), ln = () => ({
  x: EP(),
  y: EP()
});
function ci(e) {
  return [e("x"), e("y")];
}
function $I({ top: e, left: t, right: n, bottom: r }) {
  return {
    x: { min: t, max: n },
    y: { min: e, max: r }
  };
}
function F9({ x: e, y: t }) {
  return { top: t.min, right: e.max, bottom: t.max, left: e.min };
}
function W9(e, t) {
  if (!t)
    return e;
  const n = t({ x: e.left, y: e.top }), r = t({ x: e.right, y: e.bottom });
  return {
    top: n.y,
    left: n.x,
    bottom: r.y,
    right: r.x
  };
}
function sb(e) {
  return e === void 0 || e === 1;
}
function D0({ scale: e, scaleX: t, scaleY: n }) {
  return !sb(e) || !sb(t) || !sb(n);
}
function ps(e) {
  return D0(e) || DI(e) || e.z || e.rotate || e.rotateX || e.rotateY || e.skewX || e.skewY;
}
function DI(e) {
  return kP(e.x) || kP(e.y);
}
function kP(e) {
  return e && e !== "0%";
}
function Cp(e, t, n) {
  const r = e - n, i = t * r;
  return n + i;
}
function MP(e, t, n, r, i) {
  return i !== void 0 && (e = Cp(e, i, r)), Cp(e, n, r) + t;
}
function I0(e, t = 0, n = 1, r, i) {
  e.min = MP(e.min, t, n, r, i), e.max = MP(e.max, t, n, r, i);
}
function II(e, { x: t, y: n }) {
  I0(e.x, t.translate, t.scale, t.originPoint), I0(e.y, n.translate, n.scale, n.originPoint);
}
const NP = 0.999999999999, $P = 1.0000000000001;
function z9(e, t, n, r = !1) {
  const i = n.length;
  if (!i)
    return;
  t.x = t.y = 1;
  let o, a;
  for (let s = 0; s < i; s++) {
    o = n[s], a = o.projectionDelta;
    const { visualElement: l } = o.options;
    l && l.props.style && l.props.style.display === "contents" || (r && o.options.layoutScroll && o.scroll && o !== o.root && Il(e, {
      x: -o.scroll.offset.x,
      y: -o.scroll.offset.y
    }), a && (t.x *= a.x.scale, t.y *= a.y.scale, II(e, a)), r && ps(o.latestValues) && Il(e, o.latestValues));
  }
  t.x < $P && t.x > NP && (t.x = 1), t.y < $P && t.y > NP && (t.y = 1);
}
function Dl(e, t) {
  e.min = e.min + t, e.max = e.max + t;
}
function DP(e, t, n, r, i = 0.5) {
  const o = Qt(e.min, e.max, i);
  I0(e, t, n, o, r);
}
function Il(e, t) {
  DP(e.x, t.x, t.scaleX, t.scale, t.originX), DP(e.y, t.y, t.scaleY, t.scale, t.originY);
}
function RI(e, t) {
  return $I(W9(e.getBoundingClientRect(), t));
}
function V9(e, t, n) {
  const r = RI(e, n), { scroll: i } = t;
  return i && (Dl(r.x, i.offset.x), Dl(r.y, i.offset.y)), r;
}
const jI = ({ current: e }) => e ? e.ownerDocument.defaultView : null, U9 = /* @__PURE__ */ new WeakMap();
class H9 {
  constructor(t) {
    this.openGlobalLock = null, this.isDragging = !1, this.currentDirection = null, this.originPoint = { x: 0, y: 0 }, this.constraints = !1, this.hasMutatedConstraints = !1, this.elastic = ln(), this.visualElement = t;
  }
  start(t, { snapToCursor: n = !1 } = {}) {
    const { presenceContext: r } = this.visualElement;
    if (r && r.isPresent === !1)
      return;
    const i = (f) => {
      const { dragSnapToOrigin: d } = this.getProps();
      d ? this.pauseAnimation() : this.stopAnimation(), n && this.snapToCursor(xg(f, "page").point);
    }, o = (f, d) => {
      const { drag: p, dragPropagation: m, onDragStart: y } = this.getProps();
      if (p && !m && (this.openGlobalLock && this.openGlobalLock(), this.openGlobalLock = EI(p), !this.openGlobalLock))
        return;
      this.isDragging = !0, this.currentDirection = null, this.resolveConstraints(), this.visualElement.projection && (this.visualElement.projection.isAnimationBlocked = !0, this.visualElement.projection.target = void 0), ci((v) => {
        let x = this.getAxisMotionValue(v).get() || 0;
        if (Yi.test(x)) {
          const { projection: w } = this.visualElement;
          if (w && w.layout) {
            const S = w.layout.layoutBox[v];
            S && (x = Kr(S) * (parseFloat(x) / 100));
          }
        }
        this.originPoint[v] = x;
      }), y && Tt.postRender(() => y(f, d)), M0(this.visualElement, "transform");
      const { animationState: g } = this.visualElement;
      g && g.setActive("whileDrag", !0);
    }, a = (f, d) => {
      const { dragPropagation: p, dragDirectionLock: m, onDirectionLock: y, onDrag: g } = this.getProps();
      if (!p && !this.openGlobalLock)
        return;
      const { offset: v } = d;
      if (m && this.currentDirection === null) {
        this.currentDirection = K9(v), this.currentDirection !== null && y && y(this.currentDirection);
        return;
      }
      this.updateAxis("x", d.point, v), this.updateAxis("y", d.point, v), this.visualElement.render(), g && g(f, d);
    }, s = (f, d) => this.stop(f, d), l = () => ci((f) => {
      var d;
      return this.getAnimationState(f) === "paused" && ((d = this.getAxisMotionValue(f).animation) === null || d === void 0 ? void 0 : d.play());
    }), { dragSnapToOrigin: c } = this.getProps();
    this.panSession = new TI(t, {
      onSessionStart: i,
      onStart: o,
      onMove: a,
      onSessionEnd: s,
      resumeAnimation: l
    }, {
      transformPagePoint: this.visualElement.getTransformPagePoint(),
      dragSnapToOrigin: c,
      contextWindow: jI(this.visualElement)
    });
  }
  stop(t, n) {
    const r = this.isDragging;
    if (this.cancel(), !r)
      return;
    const { velocity: i } = n;
    this.startAnimation(i);
    const { onDragEnd: o } = this.getProps();
    o && Tt.postRender(() => o(t, n));
  }
  cancel() {
    this.isDragging = !1;
    const { projection: t, animationState: n } = this.visualElement;
    t && (t.isAnimationBlocked = !1), this.panSession && this.panSession.end(), this.panSession = void 0;
    const { dragPropagation: r } = this.getProps();
    !r && this.openGlobalLock && (this.openGlobalLock(), this.openGlobalLock = null), n && n.setActive("whileDrag", !1);
  }
  updateAxis(t, n, r) {
    const { drag: i } = this.getProps();
    if (!r || !Mh(t, i, this.currentDirection))
      return;
    const o = this.getAxisMotionValue(t);
    let a = this.originPoint[t] + r[t];
    this.constraints && this.constraints[t] && (a = D9(a, this.constraints[t], this.elastic[t])), o.set(a);
  }
  resolveConstraints() {
    var t;
    const { dragConstraints: n, dragElastic: r } = this.getProps(), i = this.visualElement.projection && !this.visualElement.projection.layout ? this.visualElement.projection.measure(!1) : (t = this.visualElement.projection) === null || t === void 0 ? void 0 : t.layout, o = this.constraints;
    n && Nl(n) ? this.constraints || (this.constraints = this.resolveRefConstraints()) : n && i ? this.constraints = I9(i.layoutBox, n) : this.constraints = !1, this.elastic = B9(r), o !== this.constraints && i && this.constraints && !this.hasMutatedConstraints && ci((a) => {
      this.constraints !== !1 && this.getAxisMotionValue(a) && (this.constraints[a] = L9(i.layoutBox[a], this.constraints[a]));
    });
  }
  resolveRefConstraints() {
    const { dragConstraints: t, onMeasureDragConstraints: n } = this.getProps();
    if (!t || !Nl(t))
      return !1;
    const r = t.current;
    Wo(r !== null, "If `dragConstraints` is set as a React ref, that ref must be passed to another component's `ref` prop.");
    const { projection: i } = this.visualElement;
    if (!i || !i.layout)
      return !1;
    const o = V9(r, i.root, this.visualElement.getTransformPagePoint());
    let a = R9(i.layout.layoutBox, o);
    if (n) {
      const s = n(F9(a));
      this.hasMutatedConstraints = !!s, s && (a = $I(s));
    }
    return a;
  }
  startAnimation(t) {
    const { drag: n, dragMomentum: r, dragElastic: i, dragTransition: o, dragSnapToOrigin: a, onDragTransitionEnd: s } = this.getProps(), l = this.constraints || {}, c = ci((f) => {
      if (!Mh(f, n, this.currentDirection))
        return;
      let d = l && l[f] || {};
      a && (d = { min: 0, max: 0 });
      const p = i ? 200 : 1e6, m = i ? 40 : 1e7, y = {
        type: "inertia",
        velocity: r ? t[f] : 0,
        bounceStiffness: p,
        bounceDamping: m,
        timeConstant: 750,
        restDelta: 1,
        restSpeed: 10,
        ...o,
        ...d
      };
      return this.startAxisValueAnimation(f, y);
    });
    return Promise.all(c).then(s);
  }
  startAxisValueAnimation(t, n) {
    const r = this.getAxisMotionValue(t);
    return M0(this.visualElement, t), r.start(k1(t, r, 0, n, this.visualElement, !1));
  }
  stopAnimation() {
    ci((t) => this.getAxisMotionValue(t).stop());
  }
  pauseAnimation() {
    ci((t) => {
      var n;
      return (n = this.getAxisMotionValue(t).animation) === null || n === void 0 ? void 0 : n.pause();
    });
  }
  getAnimationState(t) {
    var n;
    return (n = this.getAxisMotionValue(t).animation) === null || n === void 0 ? void 0 : n.state;
  }
  /**
   * Drag works differently depending on which props are provided.
   *
   * - If _dragX and _dragY are provided, we output the gesture delta directly to those motion values.
   * - Otherwise, we apply the delta to the x/y motion values.
   */
  getAxisMotionValue(t) {
    const n = `_drag${t.toUpperCase()}`, r = this.visualElement.getProps(), i = r[n];
    return i || this.visualElement.getValue(t, (r.initial ? r.initial[t] : void 0) || 0);
  }
  snapToCursor(t) {
    ci((n) => {
      const { drag: r } = this.getProps();
      if (!Mh(n, r, this.currentDirection))
        return;
      const { projection: i } = this.visualElement, o = this.getAxisMotionValue(n);
      if (i && i.layout) {
        const { min: a, max: s } = i.layout.layoutBox[n];
        o.set(t[n] - Qt(a, s, 0.5));
      }
    });
  }
  /**
   * When the viewport resizes we want to check if the measured constraints
   * have changed and, if so, reposition the element within those new constraints
   * relative to where it was before the resize.
   */
  scalePositionWithinConstraints() {
    if (!this.visualElement.current)
      return;
    const { drag: t, dragConstraints: n } = this.getProps(), { projection: r } = this.visualElement;
    if (!Nl(n) || !r || !this.constraints)
      return;
    this.stopAnimation();
    const i = { x: 0, y: 0 };
    ci((a) => {
      const s = this.getAxisMotionValue(a);
      if (s && this.constraints !== !1) {
        const l = s.get();
        i[a] = j9({ min: l, max: l }, this.constraints[a]);
      }
    });
    const { transformTemplate: o } = this.visualElement.getProps();
    this.visualElement.current.style.transform = o ? o({}, "") : "none", r.root && r.root.updateScroll(), r.updateLayout(), this.resolveConstraints(), ci((a) => {
      if (!Mh(a, t, null))
        return;
      const s = this.getAxisMotionValue(a), { min: l, max: c } = this.constraints[a];
      s.set(Qt(l, c, i[a]));
    });
  }
  addListeners() {
    if (!this.visualElement.current)
      return;
    U9.set(this.visualElement, this);
    const t = this.visualElement.current, n = Do(t, "pointerdown", (l) => {
      const { drag: c, dragListener: f = !0 } = this.getProps();
      c && f && this.start(l);
    }), r = () => {
      const { dragConstraints: l } = this.getProps();
      Nl(l) && l.current && (this.constraints = this.resolveRefConstraints());
    }, { projection: i } = this.visualElement, o = i.addEventListener("measure", r);
    i && !i.layout && (i.root && i.root.updateScroll(), i.updateLayout()), Tt.read(r);
    const a = To(window, "resize", () => this.scalePositionWithinConstraints()), s = i.addEventListener("didUpdate", ({ delta: l, hasLayoutChanged: c }) => {
      this.isDragging && c && (ci((f) => {
        const d = this.getAxisMotionValue(f);
        d && (this.originPoint[f] += l[f].translate, d.set(d.get() + l[f].translate));
      }), this.visualElement.render());
    });
    return () => {
      a(), n(), o(), s && s();
    };
  }
  getProps() {
    const t = this.visualElement.getProps(), { drag: n = !1, dragDirectionLock: r = !1, dragPropagation: i = !1, dragConstraints: o = !1, dragElastic: a = $0, dragMomentum: s = !0 } = t;
    return {
      ...t,
      drag: n,
      dragDirectionLock: r,
      dragPropagation: i,
      dragConstraints: o,
      dragElastic: a,
      dragMomentum: s
    };
  }
}
function Mh(e, t, n) {
  return (t === !0 || t === e) && (n === null || n === e);
}
function K9(e, t = 10) {
  let n = null;
  return Math.abs(e.y) > t ? n = "y" : Math.abs(e.x) > t && (n = "x"), n;
}
class G9 extends Va {
  constructor(t) {
    super(t), this.removeGroupControls = qn, this.removeListeners = qn, this.controls = new H9(t);
  }
  mount() {
    const { dragControls: t } = this.node.getProps();
    t && (this.removeGroupControls = t.subscribe(this.controls)), this.removeListeners = this.controls.addListeners() || qn;
  }
  unmount() {
    this.removeGroupControls(), this.removeListeners();
  }
}
const IP = (e) => (t, n) => {
  e && Tt.postRender(() => e(t, n));
};
class Y9 extends Va {
  constructor() {
    super(...arguments), this.removePointerDownListener = qn;
  }
  onPointerDown(t) {
    this.session = new TI(t, this.createPanHandlers(), {
      transformPagePoint: this.node.getTransformPagePoint(),
      contextWindow: jI(this.node)
    });
  }
  createPanHandlers() {
    const { onPanSessionStart: t, onPanStart: n, onPan: r, onPanEnd: i } = this.node.getProps();
    return {
      onSessionStart: IP(t),
      onStart: IP(n),
      onMove: r,
      onEnd: (o, a) => {
        delete this.session, i && Tt.postRender(() => i(o, a));
      }
    };
  }
  mount() {
    this.removePointerDownListener = Do(this.node.current, "pointerdown", (t) => this.onPointerDown(t));
  }
  update() {
    this.session && this.session.updateHandlers(this.createPanHandlers());
  }
  unmount() {
    this.removePointerDownListener(), this.session && this.session.end();
  }
}
const wg = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null);
function q9() {
  const e = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wg);
  if (e === null)
    return [!0, null];
  const { isPresent: t, onExitComplete: n, register: r } = e, i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => r(i), []);
  const o = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => n && n(i), [i, n]);
  return !t && n ? [!1, o] : [!0];
}
const vf = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), LI = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), sp = {
  /**
   * Global flag as to whether the tree has animated since the last time
   * we resized the window
   */
  hasAnimatedSinceResize: !0,
  /**
   * We set this to true once, on the first update. Any nodes added to the tree beyond that
   * update will be given a `data-projection-id` attribute.
   */
  hasEverUpdated: !1
};
function RP(e, t) {
  return t.max === t.min ? 0 : e / (t.max - t.min) * 100;
}
const wu = {
  correct: (e, t) => {
    if (!t.target)
      return e;
    if (typeof e == "string")
      if (Be.test(e))
        e = parseFloat(e);
      else
        return e;
    const n = RP(e, t.target.x), r = RP(e, t.target.y);
    return `${n}% ${r}%`;
  }
}, X9 = {
  correct: (e, { treeScale: t, projectionDelta: n }) => {
    const r = e, i = Ba.parse(e);
    if (i.length > 5)
      return r;
    const o = Ba.createTransformer(e), a = typeof i[0] != "number" ? 1 : 0, s = n.x.scale * t.x, l = n.y.scale * t.y;
    i[0 + a] /= s, i[1 + a] /= l;
    const c = Qt(s, l, 0.5);
    return typeof i[2 + a] == "number" && (i[2 + a] /= c), typeof i[3 + a] == "number" && (i[3 + a] /= c), o(i);
  }
}, Ep = {};
function Z9(e) {
  Object.assign(Ep, e);
}
const { schedule: I1, cancel: ZEe } = FD(queueMicrotask, !1);
class J9 extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
  /**
   * This only mounts projection nodes for components that
   * need measuring, we might want to do it for all components
   * in order to incorporate transforms
   */
  componentDidMount() {
    const { visualElement: t, layoutGroup: n, switchLayoutGroup: r, layoutId: i } = this.props, { projection: o } = t;
    Z9(Q9), o && (n.group && n.group.add(o), r && r.register && i && r.register(o), o.root.didUpdate(), o.addEventListener("animationComplete", () => {
      this.safeToRemove();
    }), o.setOptions({
      ...o.options,
      onExitComplete: () => this.safeToRemove()
    })), sp.hasEverUpdated = !0;
  }
  getSnapshotBeforeUpdate(t) {
    const { layoutDependency: n, visualElement: r, drag: i, isPresent: o } = this.props, a = r.projection;
    return a && (a.isPresent = o, i || t.layoutDependency !== n || n === void 0 ? a.willUpdate() : this.safeToRemove(), t.isPresent !== o && (o ? a.promote() : a.relegate() || Tt.postRender(() => {
      const s = a.getStack();
      (!s || !s.members.length) && this.safeToRemove();
    }))), null;
  }
  componentDidUpdate() {
    const { projection: t } = this.props.visualElement;
    t && (t.root.didUpdate(), I1.postRender(() => {
      !t.currentAnimation && t.isLead() && this.safeToRemove();
    }));
  }
  componentWillUnmount() {
    const { visualElement: t, layoutGroup: n, switchLayoutGroup: r } = this.props, { projection: i } = t;
    i && (i.scheduleCheckAfterUnmount(), n && n.group && n.group.remove(i), r && r.deregister && r.deregister(i));
  }
  safeToRemove() {
    const { safeToRemove: t } = this.props;
    t && t();
  }
  render() {
    return null;
  }
}
function BI(e) {
  const [t, n] = q9(), r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(vf);
  return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(J9, { ...e, layoutGroup: r, switchLayoutGroup: (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(LI), isPresent: t, safeToRemove: n });
}
const Q9 = {
  borderRadius: {
    ...wu,
    applyTo: [
      "borderTopLeftRadius",
      "borderTopRightRadius",
      "borderBottomLeftRadius",
      "borderBottomRightRadius"
    ]
  },
  borderTopLeftRadius: wu,
  borderTopRightRadius: wu,
  borderBottomLeftRadius: wu,
  borderBottomRightRadius: wu,
  boxShadow: X9
}, FI = ["TopLeft", "TopRight", "BottomLeft", "BottomRight"], e7 = FI.length, jP = (e) => typeof e == "string" ? parseFloat(e) : e, LP = (e) => typeof e == "number" || Be.test(e);
function t7(e, t, n, r, i, o) {
  i ? (e.opacity = Qt(
    0,
    // TODO Reinstate this if only child
    n.opacity !== void 0 ? n.opacity : 1,
    n7(r)
  ), e.opacityExit = Qt(t.opacity !== void 0 ? t.opacity : 1, 0, r7(r))) : o && (e.opacity = Qt(t.opacity !== void 0 ? t.opacity : 1, n.opacity !== void 0 ? n.opacity : 1, r));
  for (let a = 0; a < e7; a++) {
    const s = `border${FI[a]}Radius`;
    let l = BP(t, s), c = BP(n, s);
    if (l === void 0 && c === void 0)
      continue;
    l || (l = 0), c || (c = 0), l === 0 || c === 0 || LP(l) === LP(c) ? (e[s] = Math.max(Qt(jP(l), jP(c), r), 0), (Yi.test(c) || Yi.test(l)) && (e[s] += "%")) : e[s] = c;
  }
  (t.rotate || n.rotate) && (e.rotate = Qt(t.rotate || 0, n.rotate || 0, r));
}
function BP(e, t) {
  return e[t] !== void 0 ? e[t] : e.borderRadius;
}
const n7 = /* @__PURE__ */ WI(0, 0.5, GD), r7 = /* @__PURE__ */ WI(0.5, 0.95, qn);
function WI(e, t, n) {
  return (r) => r < e ? 0 : r > t ? 1 : n(ec(e, t, r));
}
function FP(e, t) {
  e.min = t.min, e.max = t.max;
}
function oi(e, t) {
  FP(e.x, t.x), FP(e.y, t.y);
}
function WP(e, t) {
  e.translate = t.translate, e.scale = t.scale, e.originPoint = t.originPoint, e.origin = t.origin;
}
function zP(e, t, n, r, i) {
  return e -= t, e = Cp(e, 1 / n, r), i !== void 0 && (e = Cp(e, 1 / i, r)), e;
}
function i7(e, t = 0, n = 1, r = 0.5, i, o = e, a = e) {
  if (Yi.test(t) && (t = parseFloat(t), t = Qt(a.min, a.max, t / 100) - a.min), typeof t != "number")
    return;
  let s = Qt(o.min, o.max, r);
  e === o && (s -= t), e.min = zP(e.min, t, n, s, i), e.max = zP(e.max, t, n, s, i);
}
function VP(e, t, [n, r, i], o, a) {
  i7(e, t[n], t[r], t[i], t.scale, o, a);
}
const o7 = ["x", "scaleX", "originX"], a7 = ["y", "scaleY", "originY"];
function UP(e, t, n, r) {
  VP(e.x, t, o7, n ? n.x : void 0, r ? r.x : void 0), VP(e.y, t, a7, n ? n.y : void 0, r ? r.y : void 0);
}
function HP(e) {
  return e.translate === 0 && e.scale === 1;
}
function zI(e) {
  return HP(e.x) && HP(e.y);
}
function KP(e, t) {
  return e.min === t.min && e.max === t.max;
}
function s7(e, t) {
  return KP(e.x, t.x) && KP(e.y, t.y);
}
function GP(e, t) {
  return Math.round(e.min) === Math.round(t.min) && Math.round(e.max) === Math.round(t.max);
}
function VI(e, t) {
  return GP(e.x, t.x) && GP(e.y, t.y);
}
function YP(e) {
  return Kr(e.x) / Kr(e.y);
}
function qP(e, t) {
  return e.translate === t.translate && e.scale === t.scale && e.originPoint === t.originPoint;
}
class l7 {
  constructor() {
    this.members = [];
  }
  add(t) {
    M1(this.members, t), t.scheduleRender();
  }
  remove(t) {
    if (N1(this.members, t), t === this.prevLead && (this.prevLead = void 0), t === this.lead) {
      const n = this.members[this.members.length - 1];
      n && this.promote(n);
    }
  }
  relegate(t) {
    const n = this.members.findIndex((i) => t === i);
    if (n === 0)
      return !1;
    let r;
    for (let i = n; i >= 0; i--) {
      const o = this.members[i];
      if (o.isPresent !== !1) {
        r = o;
        break;
      }
    }
    return r ? (this.promote(r), !0) : !1;
  }
  promote(t, n) {
    const r = this.lead;
    if (t !== r && (this.prevLead = r, this.lead = t, t.show(), r)) {
      r.instance && r.scheduleRender(), t.scheduleRender(), t.resumeFrom = r, n && (t.resumeFrom.preserveOpacity = !0), r.snapshot && (t.snapshot = r.snapshot, t.snapshot.latestValues = r.animationValues || r.latestValues), t.root && t.root.isUpdating && (t.isLayoutDirty = !0);
      const { crossfade: i } = t.options;
      i === !1 && r.hide();
    }
  }
  exitAnimationComplete() {
    this.members.forEach((t) => {
      const { options: n, resumingFrom: r } = t;
      n.onExitComplete && n.onExitComplete(), r && r.options.onExitComplete && r.options.onExitComplete();
    });
  }
  scheduleRender() {
    this.members.forEach((t) => {
      t.instance && t.scheduleRender(!1);
    });
  }
  /**
   * Clear any leads that have been removed this render to prevent them from being
   * used in future animations and to prevent memory leaks
   */
  removeLeadSnapshot() {
    this.lead && this.lead.snapshot && (this.lead.snapshot = void 0);
  }
}
function c7(e, t, n) {
  let r = "";
  const i = e.x.translate / t.x, o = e.y.translate / t.y, a = (n == null ? void 0 : n.z) || 0;
  if ((i || o || a) && (r = `translate3d(${i}px, ${o}px, ${a}px) `), (t.x !== 1 || t.y !== 1) && (r += `scale(${1 / t.x}, ${1 / t.y}) `), n) {
    const { transformPerspective: c, rotate: f, rotateX: d, rotateY: p, skewX: m, skewY: y } = n;
    c && (r = `perspective(${c}px) ${r}`), f && (r += `rotate(${f}deg) `), d && (r += `rotateX(${d}deg) `), p && (r += `rotateY(${p}deg) `), m && (r += `skewX(${m}deg) `), y && (r += `skewY(${y}deg) `);
  }
  const s = e.x.scale * t.x, l = e.y.scale * t.y;
  return (s !== 1 || l !== 1) && (r += `scale(${s}, ${l})`), r || "none";
}
const u7 = (e, t) => e.depth - t.depth;
class f7 {
  constructor() {
    this.children = [], this.isDirty = !1;
  }
  add(t) {
    M1(this.children, t), this.isDirty = !0;
  }
  remove(t) {
    N1(this.children, t), this.isDirty = !0;
  }
  forEach(t) {
    this.isDirty && this.children.sort(u7), this.isDirty = !1, this.children.forEach(t);
  }
}
function lp(e) {
  const t = rr(e) ? e.get() : e;
  return n9(t) ? t.toValue() : t;
}
function d7(e, t) {
  const n = qi.now(), r = ({ timestamp: i }) => {
    const o = i - n;
    o >= t && (ja(r), e(o - t));
  };
  return Tt.read(r, !0), () => ja(r);
}
function h7(e) {
  return e instanceof SVGElement && e.tagName !== "svg";
}
function p7(e, t, n) {
  const r = rr(e) ? e : yf(e);
  return r.start(k1("", r, t, n)), r.animation;
}
const ms = {
  type: "projectionFrame",
  totalNodes: 0,
  resolvedTargetDeltas: 0,
  recalculatedProjection: 0
}, Bu = typeof window < "u" && window.MotionDebug !== void 0, lb = ["", "X", "Y", "Z"], m7 = { visibility: "hidden" }, XP = 1e3;
let g7 = 0;
function cb(e, t, n, r) {
  const { latestValues: i } = t;
  i[e] && (n[e] = i[e], t.setStaticValue(e, 0), r && (r[e] = 0));
}
function UI(e) {
  if (e.hasCheckedOptimisedAppear = !0, e.root === e)
    return;
  const { visualElement: t } = e.options;
  if (!t)
    return;
  const n = _I(t);
  if (window.MotionHasOptimisedAnimation(n, "transform")) {
    const { layout: i, layoutId: o } = e.options;
    window.MotionCancelOptimisedAnimation(n, "transform", Tt, !(i || o));
  }
  const { parent: r } = e;
  r && !r.hasCheckedOptimisedAppear && UI(r);
}
function HI({ attachResizeListener: e, defaultParent: t, measureScroll: n, checkIsScrollRoot: r, resetTransform: i }) {
  return class {
    constructor(a = {}, s = t == null ? void 0 : t()) {
      this.id = g7++, this.animationId = 0, this.children = /* @__PURE__ */ new Set(), this.options = {}, this.isTreeAnimating = !1, this.isAnimationBlocked = !1, this.isLayoutDirty = !1, this.isProjectionDirty = !1, this.isSharedProjectionDirty = !1, this.isTransformDirty = !1, this.updateManuallyBlocked = !1, this.updateBlockedByResize = !1, this.isUpdating = !1, this.isSVG = !1, this.needsReset = !1, this.shouldResetTransform = !1, this.hasCheckedOptimisedAppear = !1, this.treeScale = { x: 1, y: 1 }, this.eventHandlers = /* @__PURE__ */ new Map(), this.hasTreeAnimated = !1, this.updateScheduled = !1, this.scheduleUpdate = () => this.update(), this.projectionUpdateScheduled = !1, this.checkUpdateFailed = () => {
        this.isUpdating && (this.isUpdating = !1, this.clearAllSnapshots());
      }, this.updateProjection = () => {
        this.projectionUpdateScheduled = !1, Bu && (ms.totalNodes = ms.resolvedTargetDeltas = ms.recalculatedProjection = 0), this.nodes.forEach(b7), this.nodes.forEach(O7), this.nodes.forEach(A7), this.nodes.forEach(x7), Bu && window.MotionDebug.record(ms);
      }, this.resolvedRelativeTargetAt = 0, this.hasProjected = !1, this.isVisible = !0, this.animationProgress = 0, this.sharedNodes = /* @__PURE__ */ new Map(), this.latestValues = a, this.root = s ? s.root || s : this, this.path = s ? [...s.path, s] : [], this.parent = s, this.depth = s ? s.depth + 1 : 0;
      for (let l = 0; l < this.path.length; l++)
        this.path[l].shouldResetTransform = !0;
      this.root === this && (this.nodes = new f7());
    }
    addEventListener(a, s) {
      return this.eventHandlers.has(a) || this.eventHandlers.set(a, new $1()), this.eventHandlers.get(a).add(s);
    }
    notifyListeners(a, ...s) {
      const l = this.eventHandlers.get(a);
      l && l.notify(...s);
    }
    hasListeners(a) {
      return this.eventHandlers.has(a);
    }
    /**
     * Lifecycles
     */
    mount(a, s = this.root.hasTreeAnimated) {
      if (this.instance)
        return;
      this.isSVG = h7(a), this.instance = a;
      const { layoutId: l, layout: c, visualElement: f } = this.options;
      if (f && !f.current && f.mount(a), this.root.nodes.add(this), this.parent && this.parent.children.add(this), s && (c || l) && (this.isLayoutDirty = !0), e) {
        let d;
        const p = () => this.root.updateBlockedByResize = !1;
        e(a, () => {
          this.root.updateBlockedByResize = !0, d && d(), d = d7(p, 250), sp.hasAnimatedSinceResize && (sp.hasAnimatedSinceResize = !1, this.nodes.forEach(JP));
        });
      }
      l && this.root.registerSharedNode(l, this), this.options.animate !== !1 && f && (l || c) && this.addEventListener("didUpdate", ({ delta: d, hasLayoutChanged: p, hasRelativeTargetChanged: m, layout: y }) => {
        if (this.isTreeAnimationBlocked()) {
          this.target = void 0, this.relativeTarget = void 0;
          return;
        }
        const g = this.options.transition || f.getDefaultTransition() || k7, { onLayoutAnimationStart: v, onLayoutAnimationComplete: x } = f.getProps(), w = !this.targetLayout || !VI(this.targetLayout, y) || m, S = !p && m;
        if (this.options.layoutRoot || this.resumeFrom && this.resumeFrom.instance || S || p && (w || !this.currentAnimation)) {
          this.resumeFrom && (this.resumingFrom = this.resumeFrom, this.resumingFrom.resumingFrom = void 0), this.setAnimationOrigin(d, S);
          const A = {
            ...g1(g, "layout"),
            onPlay: v,
            onComplete: x
          };
          (f.shouldReduceMotion || this.options.layoutRoot) && (A.delay = 0, A.type = !1), this.startAnimation(A);
        } else
          p || JP(this), this.isLead() && this.options.onExitComplete && this.options.onExitComplete();
        this.targetLayout = y;
      });
    }
    unmount() {
      this.options.layoutId && this.willUpdate(), this.root.nodes.remove(this);
      const a = this.getStack();
      a && a.remove(this), this.parent && this.parent.children.delete(this), this.instance = void 0, ja(this.updateProjection);
    }
    // only on the root
    blockUpdate() {
      this.updateManuallyBlocked = !0;
    }
    unblockUpdate() {
      this.updateManuallyBlocked = !1;
    }
    isUpdateBlocked() {
      return this.updateManuallyBlocked || this.updateBlockedByResize;
    }
    isTreeAnimationBlocked() {
      return this.isAnimationBlocked || this.parent && this.parent.isTreeAnimationBlocked() || !1;
    }
    // Note: currently only running on root node
    startUpdate() {
      this.isUpdateBlocked() || (this.isUpdating = !0, this.nodes && this.nodes.forEach(T7), this.animationId++);
    }
    getTransformTemplate() {
      const { visualElement: a } = this.options;
      return a && a.getProps().transformTemplate;
    }
    willUpdate(a = !0) {
      if (this.root.hasTreeAnimated = !0, this.root.isUpdateBlocked()) {
        this.options.onExitComplete && this.options.onExitComplete();
        return;
      }
      if (window.MotionCancelOptimisedAnimation && !this.hasCheckedOptimisedAppear && UI(this), !this.root.isUpdating && this.root.startUpdate(), this.isLayoutDirty)
        return;
      this.isLayoutDirty = !0;
      for (let f = 0; f < this.path.length; f++) {
        const d = this.path[f];
        d.shouldResetTransform = !0, d.updateScroll("snapshot"), d.options.layoutRoot && d.willUpdate(!1);
      }
      const { layoutId: s, layout: l } = this.options;
      if (s === void 0 && !l)
        return;
      const c = this.getTransformTemplate();
      this.prevTransformTemplateValue = c ? c(this.latestValues, "") : void 0, this.updateSnapshot(), a && this.notifyListeners("willUpdate");
    }
    update() {
      if (this.updateScheduled = !1, this.isUpdateBlocked()) {
        this.unblockUpdate(), this.clearAllSnapshots(), this.nodes.forEach(ZP);
        return;
      }
      this.isUpdating || this.nodes.forEach(_7), this.isUpdating = !1, this.nodes.forEach(S7), this.nodes.forEach(y7), this.nodes.forEach(v7), this.clearAllSnapshots();
      const s = qi.now();
      zn.delta = La(0, 1e3 / 60, s - zn.timestamp), zn.timestamp = s, zn.isProcessing = !0, eb.update.process(zn), eb.preRender.process(zn), eb.render.process(zn), zn.isProcessing = !1;
    }
    didUpdate() {
      this.updateScheduled || (this.updateScheduled = !0, I1.read(this.scheduleUpdate));
    }
    clearAllSnapshots() {
      this.nodes.forEach(w7), this.sharedNodes.forEach(P7);
    }
    scheduleUpdateProjection() {
      this.projectionUpdateScheduled || (this.projectionUpdateScheduled = !0, Tt.preRender(this.updateProjection, !1, !0));
    }
    scheduleCheckAfterUnmount() {
      Tt.postRender(() => {
        this.isLayoutDirty ? this.root.didUpdate() : this.root.checkUpdateFailed();
      });
    }
    /**
     * Update measurements
     */
    updateSnapshot() {
      this.snapshot || !this.instance || (this.snapshot = this.measure());
    }
    updateLayout() {
      if (!this.instance || (this.updateScroll(), !(this.options.alwaysMeasureLayout && this.isLead()) && !this.isLayoutDirty))
        return;
      if (this.resumeFrom && !this.resumeFrom.instance)
        for (let l = 0; l < this.path.length; l++)
          this.path[l].updateScroll();
      const a = this.layout;
      this.layout = this.measure(!1), this.layoutCorrected = ln(), this.isLayoutDirty = !1, this.projectionDelta = void 0, this.notifyListeners("measure", this.layout.layoutBox);
      const { visualElement: s } = this.options;
      s && s.notify("LayoutMeasure", this.layout.layoutBox, a ? a.layoutBox : void 0);
    }
    updateScroll(a = "measure") {
      let s = !!(this.options.layoutScroll && this.instance);
      if (this.scroll && this.scroll.animationId === this.root.animationId && this.scroll.phase === a && (s = !1), s) {
        const l = r(this.instance);
        this.scroll = {
          animationId: this.root.animationId,
          phase: a,
          isRoot: l,
          offset: n(this.instance),
          wasRoot: this.scroll ? this.scroll.isRoot : l
        };
      }
    }
    resetTransform() {
      if (!i)
        return;
      const a = this.isLayoutDirty || this.shouldResetTransform || this.options.alwaysMeasureLayout, s = this.projectionDelta && !zI(this.projectionDelta), l = this.getTransformTemplate(), c = l ? l(this.latestValues, "") : void 0, f = c !== this.prevTransformTemplateValue;
      a && (s || ps(this.latestValues) || f) && (i(this.instance, c), this.shouldResetTransform = !1, this.scheduleRender());
    }
    measure(a = !0) {
      const s = this.measurePageBox();
      let l = this.removeElementScroll(s);
      return a && (l = this.removeTransform(l)), M7(l), {
        animationId: this.root.animationId,
        measuredBox: s,
        layoutBox: l,
        latestValues: {},
        source: this.id
      };
    }
    measurePageBox() {
      var a;
      const { visualElement: s } = this.options;
      if (!s)
        return ln();
      const l = s.measureViewportBox();
      if (!(((a = this.scroll) === null || a === void 0 ? void 0 : a.wasRoot) || this.path.some(N7))) {
        const { scroll: f } = this.root;
        f && (Dl(l.x, f.offset.x), Dl(l.y, f.offset.y));
      }
      return l;
    }
    removeElementScroll(a) {
      var s;
      const l = ln();
      if (oi(l, a), !((s = this.scroll) === null || s === void 0) && s.wasRoot)
        return l;
      for (let c = 0; c < this.path.length; c++) {
        const f = this.path[c], { scroll: d, options: p } = f;
        f !== this.root && d && p.layoutScroll && (d.wasRoot && oi(l, a), Dl(l.x, d.offset.x), Dl(l.y, d.offset.y));
      }
      return l;
    }
    applyTransform(a, s = !1) {
      const l = ln();
      oi(l, a);
      for (let c = 0; c < this.path.length; c++) {
        const f = this.path[c];
        !s && f.options.layoutScroll && f.scroll && f !== f.root && Il(l, {
          x: -f.scroll.offset.x,
          y: -f.scroll.offset.y
        }), ps(f.latestValues) && Il(l, f.latestValues);
      }
      return ps(this.latestValues) && Il(l, this.latestValues), l;
    }
    removeTransform(a) {
      const s = ln();
      oi(s, a);
      for (let l = 0; l < this.path.length; l++) {
        const c = this.path[l];
        if (!c.instance || !ps(c.latestValues))
          continue;
        D0(c.latestValues) && c.updateSnapshot();
        const f = ln(), d = c.measurePageBox();
        oi(f, d), UP(s, c.latestValues, c.snapshot ? c.snapshot.layoutBox : void 0, f);
      }
      return ps(this.latestValues) && UP(s, this.latestValues), s;
    }
    setTargetDelta(a) {
      this.targetDelta = a, this.root.scheduleUpdateProjection(), this.isProjectionDirty = !0;
    }
    setOptions(a) {
      this.options = {
        ...this.options,
        ...a,
        crossfade: a.crossfade !== void 0 ? a.crossfade : !0
      };
    }
    clearMeasurements() {
      this.scroll = void 0, this.layout = void 0, this.snapshot = void 0, this.prevTransformTemplateValue = void 0, this.targetDelta = void 0, this.target = void 0, this.isLayoutDirty = !1;
    }
    forceRelativeParentToResolveTarget() {
      this.relativeParent && this.relativeParent.resolvedRelativeTargetAt !== zn.timestamp && this.relativeParent.resolveTargetDelta(!0);
    }
    resolveTargetDelta(a = !1) {
      var s;
      const l = this.getLead();
      this.isProjectionDirty || (this.isProjectionDirty = l.isProjectionDirty), this.isTransformDirty || (this.isTransformDirty = l.isTransformDirty), this.isSharedProjectionDirty || (this.isSharedProjectionDirty = l.isSharedProjectionDirty);
      const c = !!this.resumingFrom || this !== l;
      if (!(a || c && this.isSharedProjectionDirty || this.isProjectionDirty || !((s = this.parent) === null || s === void 0) && s.isProjectionDirty || this.attemptToResolveRelativeTarget || this.root.updateBlockedByResize))
        return;
      const { layout: d, layoutId: p } = this.options;
      if (!(!this.layout || !(d || p))) {
        if (this.resolvedRelativeTargetAt = zn.timestamp, !this.targetDelta && !this.relativeTarget) {
          const m = this.getClosestProjectingParent();
          m && m.layout && this.animationProgress !== 1 ? (this.relativeParent = m, this.forceRelativeParentToResolveTarget(), this.relativeTarget = ln(), this.relativeTargetOrigin = ln(), Yu(this.relativeTargetOrigin, this.layout.layoutBox, m.layout.layoutBox), oi(this.relativeTarget, this.relativeTargetOrigin)) : this.relativeParent = this.relativeTarget = void 0;
        }
        if (!(!this.relativeTarget && !this.targetDelta)) {
          if (this.target || (this.target = ln(), this.targetWithTransforms = ln()), this.relativeTarget && this.relativeTargetOrigin && this.relativeParent && this.relativeParent.target ? (this.forceRelativeParentToResolveTarget(), $9(this.target, this.relativeTarget, this.relativeParent.target)) : this.targetDelta ? (this.resumingFrom ? this.target = this.applyTransform(this.layout.layoutBox) : oi(this.target, this.layout.layoutBox), II(this.target, this.targetDelta)) : oi(this.target, this.layout.layoutBox), this.attemptToResolveRelativeTarget) {
            this.attemptToResolveRelativeTarget = !1;
            const m = this.getClosestProjectingParent();
            m && !!m.resumingFrom == !!this.resumingFrom && !m.options.layoutScroll && m.target && this.animationProgress !== 1 ? (this.relativeParent = m, this.forceRelativeParentToResolveTarget(), this.relativeTarget = ln(), this.relativeTargetOrigin = ln(), Yu(this.relativeTargetOrigin, this.target, m.target), oi(this.relativeTarget, this.relativeTargetOrigin)) : this.relativeParent = this.relativeTarget = void 0;
          }
          Bu && ms.resolvedTargetDeltas++;
        }
      }
    }
    getClosestProjectingParent() {
      if (!(!this.parent || D0(this.parent.latestValues) || DI(this.parent.latestValues)))
        return this.parent.isProjecting() ? this.parent : this.parent.getClosestProjectingParent();
    }
    isProjecting() {
      return !!((this.relativeTarget || this.targetDelta || this.options.layoutRoot) && this.layout);
    }
    calcProjection() {
      var a;
      const s = this.getLead(), l = !!this.resumingFrom || this !== s;
      let c = !0;
      if ((this.isProjectionDirty || !((a = this.parent) === null || a === void 0) && a.isProjectionDirty) && (c = !1), l && (this.isSharedProjectionDirty || this.isTransformDirty) && (c = !1), this.resolvedRelativeTargetAt === zn.timestamp && (c = !1), c)
        return;
      const { layout: f, layoutId: d } = this.options;
      if (this.isTreeAnimating = !!(this.parent && this.parent.isTreeAnimating || this.currentAnimation || this.pendingAnimation), this.isTreeAnimating || (this.targetDelta = this.relativeTarget = void 0), !this.layout || !(f || d))
        return;
      oi(this.layoutCorrected, this.layout.layoutBox);
      const p = this.treeScale.x, m = this.treeScale.y;
      z9(this.layoutCorrected, this.treeScale, this.path, l), s.layout && !s.target && (this.treeScale.x !== 1 || this.treeScale.y !== 1) && (s.target = s.layout.layoutBox, s.targetWithTransforms = ln());
      const { target: y } = s;
      if (!y) {
        this.prevProjectionDelta && (this.createProjectionDeltas(), this.scheduleRender());
        return;
      }
      !this.projectionDelta || !this.prevProjectionDelta ? this.createProjectionDeltas() : (WP(this.prevProjectionDelta.x, this.projectionDelta.x), WP(this.prevProjectionDelta.y, this.projectionDelta.y)), Gu(this.projectionDelta, this.layoutCorrected, y, this.latestValues), (this.treeScale.x !== p || this.treeScale.y !== m || !qP(this.projectionDelta.x, this.prevProjectionDelta.x) || !qP(this.projectionDelta.y, this.prevProjectionDelta.y)) && (this.hasProjected = !0, this.scheduleRender(), this.notifyListeners("projectionUpdate", y)), Bu && ms.recalculatedProjection++;
    }
    hide() {
      this.isVisible = !1;
    }
    show() {
      this.isVisible = !0;
    }
    scheduleRender(a = !0) {
      var s;
      if ((s = this.options.visualElement) === null || s === void 0 || s.scheduleRender(), a) {
        const l = this.getStack();
        l && l.scheduleRender();
      }
      this.resumingFrom && !this.resumingFrom.instance && (this.resumingFrom = void 0);
    }
    createProjectionDeltas() {
      this.prevProjectionDelta = $l(), this.projectionDelta = $l(), this.projectionDeltaWithTransform = $l();
    }
    setAnimationOrigin(a, s = !1) {
      const l = this.snapshot, c = l ? l.latestValues : {}, f = { ...this.latestValues }, d = $l();
      (!this.relativeParent || !this.relativeParent.options.layoutRoot) && (this.relativeTarget = this.relativeTargetOrigin = void 0), this.attemptToResolveRelativeTarget = !s;
      const p = ln(), m = l ? l.source : void 0, y = this.layout ? this.layout.source : void 0, g = m !== y, v = this.getStack(), x = !v || v.members.length <= 1, w = !!(g && !x && this.options.crossfade === !0 && !this.path.some(E7));
      this.animationProgress = 0;
      let S;
      this.mixTargetDelta = (A) => {
        const _ = A / 1e3;
        QP(d.x, a.x, _), QP(d.y, a.y, _), this.setTargetDelta(d), this.relativeTarget && this.relativeTargetOrigin && this.layout && this.relativeParent && this.relativeParent.layout && (Yu(p, this.layout.layoutBox, this.relativeParent.layout.layoutBox), C7(this.relativeTarget, this.relativeTargetOrigin, p, _), S && s7(this.relativeTarget, S) && (this.isProjectionDirty = !1), S || (S = ln()), oi(S, this.relativeTarget)), g && (this.animationValues = f, t7(f, c, this.latestValues, _, w, x)), this.root.scheduleUpdateProjection(), this.scheduleRender(), this.animationProgress = _;
      }, this.mixTargetDelta(this.options.layoutRoot ? 1e3 : 0);
    }
    startAnimation(a) {
      this.notifyListeners("animationStart"), this.currentAnimation && this.currentAnimation.stop(), this.resumingFrom && this.resumingFrom.currentAnimation && this.resumingFrom.currentAnimation.stop(), this.pendingAnimation && (ja(this.pendingAnimation), this.pendingAnimation = void 0), this.pendingAnimation = Tt.update(() => {
        sp.hasAnimatedSinceResize = !0, this.currentAnimation = p7(0, XP, {
          ...a,
          onUpdate: (s) => {
            this.mixTargetDelta(s), a.onUpdate && a.onUpdate(s);
          },
          onComplete: () => {
            a.onComplete && a.onComplete(), this.completeAnimation();
          }
        }), this.resumingFrom && (this.resumingFrom.currentAnimation = this.currentAnimation), this.pendingAnimation = void 0;
      });
    }
    completeAnimation() {
      this.resumingFrom && (this.resumingFrom.currentAnimation = void 0, this.resumingFrom.preserveOpacity = void 0);
      const a = this.getStack();
      a && a.exitAnimationComplete(), this.resumingFrom = this.currentAnimation = this.animationValues = void 0, this.notifyListeners("animationComplete");
    }
    finishAnimation() {
      this.currentAnimation && (this.mixTargetDelta && this.mixTargetDelta(XP), this.currentAnimation.stop()), this.completeAnimation();
    }
    applyTransformsToTarget() {
      const a = this.getLead();
      let { targetWithTransforms: s, target: l, layout: c, latestValues: f } = a;
      if (!(!s || !l || !c)) {
        if (this !== a && this.layout && c && KI(this.options.animationType, this.layout.layoutBox, c.layoutBox)) {
          l = this.target || ln();
          const d = Kr(this.layout.layoutBox.x);
          l.x.min = a.target.x.min, l.x.max = l.x.min + d;
          const p = Kr(this.layout.layoutBox.y);
          l.y.min = a.target.y.min, l.y.max = l.y.min + p;
        }
        oi(s, l), Il(s, f), Gu(this.projectionDeltaWithTransform, this.layoutCorrected, s, f);
      }
    }
    registerSharedNode(a, s) {
      this.sharedNodes.has(a) || this.sharedNodes.set(a, new l7()), this.sharedNodes.get(a).add(s);
      const c = s.options.initialPromotionConfig;
      s.promote({
        transition: c ? c.transition : void 0,
        preserveFollowOpacity: c && c.shouldPreserveFollowOpacity ? c.shouldPreserveFollowOpacity(s) : void 0
      });
    }
    isLead() {
      const a = this.getStack();
      return a ? a.lead === this : !0;
    }
    getLead() {
      var a;
      const { layoutId: s } = this.options;
      return s ? ((a = this.getStack()) === null || a === void 0 ? void 0 : a.lead) || this : this;
    }
    getPrevLead() {
      var a;
      const { layoutId: s } = this.options;
      return s ? (a = this.getStack()) === null || a === void 0 ? void 0 : a.prevLead : void 0;
    }
    getStack() {
      const { layoutId: a } = this.options;
      if (a)
        return this.root.sharedNodes.get(a);
    }
    promote({ needsReset: a, transition: s, preserveFollowOpacity: l } = {}) {
      const c = this.getStack();
      c && c.promote(this, l), a && (this.projectionDelta = void 0, this.needsReset = !0), s && this.setOptions({ transition: s });
    }
    relegate() {
      const a = this.getStack();
      return a ? a.relegate(this) : !1;
    }
    resetSkewAndRotation() {
      const { visualElement: a } = this.options;
      if (!a)
        return;
      let s = !1;
      const { latestValues: l } = a;
      if ((l.z || l.rotate || l.rotateX || l.rotateY || l.rotateZ || l.skewX || l.skewY) && (s = !0), !s)
        return;
      const c = {};
      l.z && cb("z", a, c, this.animationValues);
      for (let f = 0; f < lb.length; f++)
        cb(`rotate${lb[f]}`, a, c, this.animationValues), cb(`skew${lb[f]}`, a, c, this.animationValues);
      a.render();
      for (const f in c)
        a.setStaticValue(f, c[f]), this.animationValues && (this.animationValues[f] = c[f]);
      a.scheduleRender();
    }
    getProjectionStyles(a) {
      var s, l;
      if (!this.instance || this.isSVG)
        return;
      if (!this.isVisible)
        return m7;
      const c = {
        visibility: ""
      }, f = this.getTransformTemplate();
      if (this.needsReset)
        return this.needsReset = !1, c.opacity = "", c.pointerEvents = lp(a == null ? void 0 : a.pointerEvents) || "", c.transform = f ? f(this.latestValues, "") : "none", c;
      const d = this.getLead();
      if (!this.projectionDelta || !this.layout || !d.target) {
        const g = {};
        return this.options.layoutId && (g.opacity = this.latestValues.opacity !== void 0 ? this.latestValues.opacity : 1, g.pointerEvents = lp(a == null ? void 0 : a.pointerEvents) || ""), this.hasProjected && !ps(this.latestValues) && (g.transform = f ? f({}, "") : "none", this.hasProjected = !1), g;
      }
      const p = d.animationValues || d.latestValues;
      this.applyTransformsToTarget(), c.transform = c7(this.projectionDeltaWithTransform, this.treeScale, p), f && (c.transform = f(p, c.transform));
      const { x: m, y } = this.projectionDelta;
      c.transformOrigin = `${m.origin * 100}% ${y.origin * 100}% 0`, d.animationValues ? c.opacity = d === this ? (l = (s = p.opacity) !== null && s !== void 0 ? s : this.latestValues.opacity) !== null && l !== void 0 ? l : 1 : this.preserveOpacity ? this.latestValues.opacity : p.opacityExit : c.opacity = d === this ? p.opacity !== void 0 ? p.opacity : "" : p.opacityExit !== void 0 ? p.opacityExit : 0;
      for (const g in Ep) {
        if (p[g] === void 0)
          continue;
        const { correct: v, applyTo: x } = Ep[g], w = c.transform === "none" ? p[g] : v(p[g], d);
        if (x) {
          const S = x.length;
          for (let A = 0; A < S; A++)
            c[x[A]] = w;
        } else
          c[g] = w;
      }
      return this.options.layoutId && (c.pointerEvents = d === this ? lp(a == null ? void 0 : a.pointerEvents) || "" : "none"), c;
    }
    clearSnapshot() {
      this.resumeFrom = this.snapshot = void 0;
    }
    // Only run on root
    resetTree() {
      this.root.nodes.forEach((a) => {
        var s;
        return (s = a.currentAnimation) === null || s === void 0 ? void 0 : s.stop();
      }), this.root.nodes.forEach(ZP), this.root.sharedNodes.clear();
    }
  };
}
function y7(e) {
  e.updateLayout();
}
function v7(e) {
  var t;
  const n = ((t = e.resumeFrom) === null || t === void 0 ? void 0 : t.snapshot) || e.snapshot;
  if (e.isLead() && e.layout && n && e.hasListeners("didUpdate")) {
    const { layoutBox: r, measuredBox: i } = e.layout, { animationType: o } = e.options, a = n.source !== e.layout.source;
    o === "size" ? ci((d) => {
      const p = a ? n.measuredBox[d] : n.layoutBox[d], m = Kr(p);
      p.min = r[d].min, p.max = p.min + m;
    }) : KI(o, n.layoutBox, r) && ci((d) => {
      const p = a ? n.measuredBox[d] : n.layoutBox[d], m = Kr(r[d]);
      p.max = p.min + m, e.relativeTarget && !e.currentAnimation && (e.isProjectionDirty = !0, e.relativeTarget[d].max = e.relativeTarget[d].min + m);
    });
    const s = $l();
    Gu(s, r, n.layoutBox);
    const l = $l();
    a ? Gu(l, e.applyTransform(i, !0), n.measuredBox) : Gu(l, r, n.layoutBox);
    const c = !zI(s);
    let f = !1;
    if (!e.resumeFrom) {
      const d = e.getClosestProjectingParent();
      if (d && !d.resumeFrom) {
        const { snapshot: p, layout: m } = d;
        if (p && m) {
          const y = ln();
          Yu(y, n.layoutBox, p.layoutBox);
          const g = ln();
          Yu(g, r, m.layoutBox), VI(y, g) || (f = !0), d.options.layoutRoot && (e.relativeTarget = g, e.relativeTargetOrigin = y, e.relativeParent = d);
        }
      }
    }
    e.notifyListeners("didUpdate", {
      layout: r,
      snapshot: n,
      delta: l,
      layoutDelta: s,
      hasLayoutChanged: c,
      hasRelativeTargetChanged: f
    });
  } else if (e.isLead()) {
    const { onExitComplete: r } = e.options;
    r && r();
  }
  e.options.transition = void 0;
}
function b7(e) {
  Bu && ms.totalNodes++, e.parent && (e.isProjecting() || (e.isProjectionDirty = e.parent.isProjectionDirty), e.isSharedProjectionDirty || (e.isSharedProjectionDirty = !!(e.isProjectionDirty || e.parent.isProjectionDirty || e.parent.isSharedProjectionDirty)), e.isTransformDirty || (e.isTransformDirty = e.parent.isTransformDirty));
}
function x7(e) {
  e.isProjectionDirty = e.isSharedProjectionDirty = e.isTransformDirty = !1;
}
function w7(e) {
  e.clearSnapshot();
}
function ZP(e) {
  e.clearMeasurements();
}
function _7(e) {
  e.isLayoutDirty = !1;
}
function S7(e) {
  const { visualElement: t } = e.options;
  t && t.getProps().onBeforeLayoutMeasure && t.notify("BeforeLayoutMeasure"), e.resetTransform();
}
function JP(e) {
  e.finishAnimation(), e.targetDelta = e.relativeTarget = e.target = void 0, e.isProjectionDirty = !0;
}
function O7(e) {
  e.resolveTargetDelta();
}
function A7(e) {
  e.calcProjection();
}
function T7(e) {
  e.resetSkewAndRotation();
}
function P7(e) {
  e.removeLeadSnapshot();
}
function QP(e, t, n) {
  e.translate = Qt(t.translate, 0, n), e.scale = Qt(t.scale, 1, n), e.origin = t.origin, e.originPoint = t.originPoint;
}
function eC(e, t, n, r) {
  e.min = Qt(t.min, n.min, r), e.max = Qt(t.max, n.max, r);
}
function C7(e, t, n, r) {
  eC(e.x, t.x, n.x, r), eC(e.y, t.y, n.y, r);
}
function E7(e) {
  return e.animationValues && e.animationValues.opacityExit !== void 0;
}
const k7 = {
  duration: 0.45,
  ease: [0.4, 0, 0.1, 1]
}, tC = (e) => typeof navigator < "u" && navigator.userAgent && navigator.userAgent.toLowerCase().includes(e), nC = tC("applewebkit/") && !tC("chrome/") ? Math.round : qn;
function rC(e) {
  e.min = nC(e.min), e.max = nC(e.max);
}
function M7(e) {
  rC(e.x), rC(e.y);
}
function KI(e, t, n) {
  return e === "position" || e === "preserve-aspect" && !N9(YP(t), YP(n), 0.2);
}
function N7(e) {
  var t;
  return e !== e.root && ((t = e.scroll) === null || t === void 0 ? void 0 : t.wasRoot);
}
const $7 = HI({
  attachResizeListener: (e, t) => To(e, "resize", t),
  measureScroll: () => ({
    x: document.documentElement.scrollLeft || document.body.scrollLeft,
    y: document.documentElement.scrollTop || document.body.scrollTop
  }),
  checkIsScrollRoot: () => !0
}), ub = {
  current: void 0
}, GI = HI({
  measureScroll: (e) => ({
    x: e.scrollLeft,
    y: e.scrollTop
  }),
  defaultParent: () => {
    if (!ub.current) {
      const e = new $7({});
      e.mount(window), e.setOptions({ layoutScroll: !0 }), ub.current = e;
    }
    return ub.current;
  },
  resetTransform: (e, t) => {
    e.style.transform = t !== void 0 ? t : "none";
  },
  checkIsScrollRoot: (e) => window.getComputedStyle(e).position === "fixed"
}), D7 = {
  pan: {
    Feature: Y9
  },
  drag: {
    Feature: G9,
    ProjectionNode: GI,
    MeasureLayout: BI
  }
};
function iC(e, t) {
  const n = t ? "pointerenter" : "pointerleave", r = t ? "onHoverStart" : "onHoverEnd", i = (o, a) => {
    if (o.pointerType === "touch" || kI())
      return;
    const s = e.getProps();
    e.animationState && s.whileHover && e.animationState.setActive("whileHover", t);
    const l = s[r];
    l && Tt.postRender(() => l(o, a));
  };
  return Do(e.current, n, i, {
    passive: !e.getProps()[r]
  });
}
class I7 extends Va {
  mount() {
    this.unmount = $o(iC(this.node, !0), iC(this.node, !1));
  }
  unmount() {
  }
}
class R7 extends Va {
  constructor() {
    super(...arguments), this.isActive = !1;
  }
  onFocus() {
    let t = !1;
    try {
      t = this.node.current.matches(":focus-visible");
    } catch {
      t = !0;
    }
    !t || !this.node.animationState || (this.node.animationState.setActive("whileFocus", !0), this.isActive = !0);
  }
  onBlur() {
    !this.isActive || !this.node.animationState || (this.node.animationState.setActive("whileFocus", !1), this.isActive = !1);
  }
  mount() {
    this.unmount = $o(To(this.node.current, "focus", () => this.onFocus()), To(this.node.current, "blur", () => this.onBlur()));
  }
  unmount() {
  }
}
const YI = (e, t) => t ? e === t ? !0 : YI(e, t.parentElement) : !1;
function fb(e, t) {
  if (!t)
    return;
  const n = new PointerEvent("pointer" + e);
  t(n, xg(n));
}
class j7 extends Va {
  constructor() {
    super(...arguments), this.removeStartListeners = qn, this.removeEndListeners = qn, this.removeAccessibleListeners = qn, this.startPointerPress = (t, n) => {
      if (this.isPressing)
        return;
      this.removeEndListeners();
      const r = this.node.getProps(), o = Do(window, "pointerup", (s, l) => {
        if (!this.checkPressEnd())
          return;
        const { onTap: c, onTapCancel: f, globalTapTarget: d } = this.node.getProps(), p = !d && !YI(this.node.current, s.target) ? f : c;
        p && Tt.update(() => p(s, l));
      }, {
        passive: !(r.onTap || r.onPointerUp)
      }), a = Do(window, "pointercancel", (s, l) => this.cancelPress(s, l), {
        passive: !(r.onTapCancel || r.onPointerCancel)
      });
      this.removeEndListeners = $o(o, a), this.startPress(t, n);
    }, this.startAccessiblePress = () => {
      const t = (o) => {
        if (o.key !== "Enter" || this.isPressing)
          return;
        const a = (s) => {
          s.key !== "Enter" || !this.checkPressEnd() || fb("up", (l, c) => {
            const { onTap: f } = this.node.getProps();
            f && Tt.postRender(() => f(l, c));
          });
        };
        this.removeEndListeners(), this.removeEndListeners = To(this.node.current, "keyup", a), fb("down", (s, l) => {
          this.startPress(s, l);
        });
      }, n = To(this.node.current, "keydown", t), r = () => {
        this.isPressing && fb("cancel", (o, a) => this.cancelPress(o, a));
      }, i = To(this.node.current, "blur", r);
      this.removeAccessibleListeners = $o(n, i);
    };
  }
  startPress(t, n) {
    this.isPressing = !0;
    const { onTapStart: r, whileTap: i } = this.node.getProps();
    i && this.node.animationState && this.node.animationState.setActive("whileTap", !0), r && Tt.postRender(() => r(t, n));
  }
  checkPressEnd() {
    return this.removeEndListeners(), this.isPressing = !1, this.node.getProps().whileTap && this.node.animationState && this.node.animationState.setActive("whileTap", !1), !kI();
  }
  cancelPress(t, n) {
    if (!this.checkPressEnd())
      return;
    const { onTapCancel: r } = this.node.getProps();
    r && Tt.postRender(() => r(t, n));
  }
  mount() {
    const t = this.node.getProps(), n = Do(t.globalTapTarget ? window : this.node.current, "pointerdown", this.startPointerPress, {
      passive: !(t.onTapStart || t.onPointerStart)
    }), r = To(this.node.current, "focus", this.startAccessiblePress);
    this.removeStartListeners = $o(n, r);
  }
  unmount() {
    this.removeStartListeners(), this.removeEndListeners(), this.removeAccessibleListeners();
  }
}
const R0 = /* @__PURE__ */ new WeakMap(), db = /* @__PURE__ */ new WeakMap(), L7 = (e) => {
  const t = R0.get(e.target);
  t && t(e);
}, B7 = (e) => {
  e.forEach(L7);
};
function F7({ root: e, ...t }) {
  const n = e || document;
  db.has(n) || db.set(n, {});
  const r = db.get(n), i = JSON.stringify(t);
  return r[i] || (r[i] = new IntersectionObserver(B7, { root: e, ...t })), r[i];
}
function W7(e, t, n) {
  const r = F7(t);
  return R0.set(e, n), r.observe(e), () => {
    R0.delete(e), r.unobserve(e);
  };
}
const z7 = {
  some: 0,
  all: 1
};
class V7 extends Va {
  constructor() {
    super(...arguments), this.hasEnteredView = !1, this.isInView = !1;
  }
  startObserver() {
    this.unmount();
    const { viewport: t = {} } = this.node.getProps(), { root: n, margin: r, amount: i = "some", once: o } = t, a = {
      root: n ? n.current : void 0,
      rootMargin: r,
      threshold: typeof i == "number" ? i : z7[i]
    }, s = (l) => {
      const { isIntersecting: c } = l;
      if (this.isInView === c || (this.isInView = c, o && !c && this.hasEnteredView))
        return;
      c && (this.hasEnteredView = !0), this.node.animationState && this.node.animationState.setActive("whileInView", c);
      const { onViewportEnter: f, onViewportLeave: d } = this.node.getProps(), p = c ? f : d;
      p && p(l);
    };
    return W7(this.node.current, a, s);
  }
  mount() {
    this.startObserver();
  }
  update() {
    if (typeof IntersectionObserver > "u")
      return;
    const { props: t, prevProps: n } = this.node;
    ["amount", "margin", "root"].some(U7(t, n)) && this.startObserver();
  }
  unmount() {
  }
}
function U7({ viewport: e = {} }, { viewport: t = {} } = {}) {
  return (n) => e[n] !== t[n];
}
const H7 = {
  inView: {
    Feature: V7
  },
  tap: {
    Feature: j7
  },
  focus: {
    Feature: R7
  },
  hover: {
    Feature: I7
  }
}, K7 = {
  layout: {
    ProjectionNode: GI,
    MeasureLayout: BI
  }
}, R1 = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
  transformPagePoint: (e) => e,
  isStatic: !1,
  reducedMotion: "never"
}), _g = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), j1 = typeof window < "u", L1 = j1 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect, qI = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({ strict: !1 });
function G7(e, t, n, r, i) {
  var o, a;
  const { visualElement: s } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_g), l = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(qI), c = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wg), f = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(R1).reducedMotion, d = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  r = r || l.renderer, !d.current && r && (d.current = r(e, {
    visualState: t,
    parent: s,
    props: n,
    presenceContext: c,
    blockInitialAnimation: c ? c.initial === !1 : !1,
    reducedMotionConfig: f
  }));
  const p = d.current, m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(LI);
  p && !p.projection && i && (p.type === "html" || p.type === "svg") && Y7(d.current, n, i, m);
  const y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!1);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useInsertionEffect)(() => {
    p && y.current && p.update(n, c);
  });
  const g = n[wI], v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!!g && !(!((o = window.MotionHandoffIsComplete) === null || o === void 0) && o.call(window, g)) && ((a = window.MotionHasOptimisedAnimation) === null || a === void 0 ? void 0 : a.call(window, g)));
  return L1(() => {
    p && (y.current = !0, window.MotionIsMounted = !0, p.updateFeatures(), I1.render(p.render), v.current && p.animationState && p.animationState.animateChanges());
  }), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    p && (!v.current && p.animationState && p.animationState.animateChanges(), v.current && (queueMicrotask(() => {
      var x;
      (x = window.MotionHandoffMarkAsComplete) === null || x === void 0 || x.call(window, g);
    }), v.current = !1));
  }), p;
}
function Y7(e, t, n, r) {
  const { layoutId: i, layout: o, drag: a, dragConstraints: s, layoutScroll: l, layoutRoot: c } = t;
  e.projection = new n(e.latestValues, t["data-framer-portal-id"] ? void 0 : XI(e.parent)), e.projection.setOptions({
    layoutId: i,
    layout: o,
    alwaysMeasureLayout: !!a || s && Nl(s),
    visualElement: e,
    /**
     * TODO: Update options in an effect. This could be tricky as it'll be too late
     * to update by the time layout animations run.
     * We also need to fix this safeToRemove by linking it up to the one returned by usePresence,
     * ensuring it gets called if there's no potential layout animations.
     *
     */
    animationType: typeof o == "string" ? o : "both",
    initialPromotionConfig: r,
    layoutScroll: l,
    layoutRoot: c
  });
}
function XI(e) {
  if (e)
    return e.options.allowProjection !== !1 ? e.projection : XI(e.parent);
}
function q7(e, t, n) {
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (r) => {
      r && e.mount && e.mount(r), t && (r ? t.mount(r) : t.unmount()), n && (typeof n == "function" ? n(r) : Nl(n) && (n.current = r));
    },
    /**
     * Only pass a new ref callback to React if we've received a visual element
     * factory. Otherwise we'll be mounting/remounting every time externalRef
     * or other dependencies change.
     */
    [t]
  );
}
function Sg(e) {
  return yg(e.animate) || m1.some((t) => pf(e[t]));
}
function ZI(e) {
  return !!(Sg(e) || e.variants);
}
function X7(e, t) {
  if (Sg(e)) {
    const { initial: n, animate: r } = e;
    return {
      initial: n === !1 || pf(n) ? n : void 0,
      animate: pf(r) ? r : void 0
    };
  }
  return e.inherit !== !1 ? t : {};
}
function Z7(e) {
  const { initial: t, animate: n } = X7(e, (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_g));
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({ initial: t, animate: n }), [oC(t), oC(n)]);
}
function oC(e) {
  return Array.isArray(e) ? e.join(" ") : e;
}
const aC = {
  animation: [
    "animate",
    "variants",
    "whileHover",
    "whileTap",
    "exit",
    "whileInView",
    "whileFocus",
    "whileDrag"
  ],
  exit: ["exit"],
  drag: ["drag", "dragControls"],
  focus: ["whileFocus"],
  hover: ["whileHover", "onHoverStart", "onHoverEnd"],
  tap: ["whileTap", "onTap", "onTapStart", "onTapCancel"],
  pan: ["onPan", "onPanStart", "onPanSessionStart", "onPanEnd"],
  inView: ["whileInView", "onViewportEnter", "onViewportLeave"],
  layout: ["layout", "layoutId"]
}, tc = {};
for (const e in aC)
  tc[e] = {
    isEnabled: (t) => aC[e].some((n) => !!t[n])
  };
function J7(e) {
  for (const t in e)
    tc[t] = {
      ...tc[t],
      ...e[t]
    };
}
const Q7 = Symbol.for("motionComponentSymbol");
function eX({ preloadedFeatures: e, createVisualElement: t, useRender: n, useVisualState: r, Component: i }) {
  e && J7(e);
  function o(s, l) {
    let c;
    const f = {
      ...(0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(R1),
      ...s,
      layoutId: tX(s)
    }, { isStatic: d } = f, p = Z7(s), m = r(s, d);
    if (!d && j1) {
      nX(f, e);
      const y = rX(f);
      c = y.MeasureLayout, p.visualElement = G7(i, m, f, t, y.ProjectionNode);
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_g.Provider, { value: p, children: [c && p.visualElement ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(c, { visualElement: p.visualElement, ...f }) : null, n(i, s, q7(m, p.visualElement, l), m, d, p.visualElement)] });
  }
  const a = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(o);
  return a[Q7] = i, a;
}
function tX({ layoutId: e }) {
  const t = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(vf).id;
  return t && e !== void 0 ? t + "-" + e : e;
}
function nX(e, t) {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(qI).strict;
  if ( true && t && n) {
    const r = "You have rendered a `motion` component within a `LazyMotion` component. This will break tree shaking. Import and render a `m` component instead.";
    e.ignoreStrict ? Ic(!1, r) : Wo(!1, r);
  }
}
function rX(e) {
  const { drag: t, layout: n } = tc;
  if (!t && !n)
    return {};
  const r = { ...t, ...n };
  return {
    MeasureLayout: t != null && t.isEnabled(e) || n != null && n.isEnabled(e) ? r.MeasureLayout : void 0,
    ProjectionNode: r.ProjectionNode
  };
}
const iX = [
  "animate",
  "circle",
  "defs",
  "desc",
  "ellipse",
  "g",
  "image",
  "line",
  "filter",
  "marker",
  "mask",
  "metadata",
  "path",
  "pattern",
  "polygon",
  "polyline",
  "rect",
  "stop",
  "switch",
  "symbol",
  "svg",
  "text",
  "tspan",
  "use",
  "view"
];
function B1(e) {
  return (
    /**
     * If it's not a string, it's a custom React component. Currently we only support
     * HTML custom React components.
     */
    typeof e != "string" || /**
     * If it contains a dash, the element is a custom HTML webcomponent.
     */
    e.includes("-") ? !1 : (
      /**
       * If it's in our list of lowercase SVG tags, it's an SVG component
       */
      !!(iX.indexOf(e) > -1 || /**
       * If it contains a capital letter, it's an SVG component
       */
      /[A-Z]/u.test(e))
    )
  );
}
function JI(e, { style: t, vars: n }, r, i) {
  Object.assign(e.style, t, i && i.getProjectionStyles(r));
  for (const o in n)
    e.style.setProperty(o, n[o]);
}
const QI = /* @__PURE__ */ new Set([
  "baseFrequency",
  "diffuseConstant",
  "kernelMatrix",
  "kernelUnitLength",
  "keySplines",
  "keyTimes",
  "limitingConeAngle",
  "markerHeight",
  "markerWidth",
  "numOctaves",
  "targetX",
  "targetY",
  "surfaceScale",
  "specularConstant",
  "specularExponent",
  "stdDeviation",
  "tableValues",
  "viewBox",
  "gradientTransform",
  "pathLength",
  "startOffset",
  "textLength",
  "lengthAdjust"
]);
function eR(e, t, n, r) {
  JI(e, t, void 0, r);
  for (const i in t.attrs)
    e.setAttribute(QI.has(i) ? i : D1(i), t.attrs[i]);
}
function tR(e, { layout: t, layoutId: n }) {
  return Gs.has(e) || e.startsWith("origin") || (t || n !== void 0) && (!!Ep[e] || e === "opacity");
}
function F1(e, t, n) {
  var r;
  const { style: i } = e, o = {};
  for (const a in i)
    (rr(i[a]) || t.style && rr(t.style[a]) || tR(a, e) || ((r = n == null ? void 0 : n.getValue(a)) === null || r === void 0 ? void 0 : r.liveStyle) !== void 0) && (o[a] = i[a]);
  return o;
}
function nR(e, t, n) {
  const r = F1(e, t, n);
  for (const i in e)
    if (rr(e[i]) || rr(t[i])) {
      const o = dd.indexOf(i) !== -1 ? "attr" + i.charAt(0).toUpperCase() + i.substring(1) : i;
      r[o] = e[i];
    }
  return r;
}
function W1(e) {
  const t = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
  return t.current === null && (t.current = e()), t.current;
}
function oX({ scrapeMotionValuesFromProps: e, createRenderState: t, onMount: n }, r, i, o) {
  const a = {
    latestValues: aX(r, i, o, e),
    renderState: t()
  };
  return n && (a.mount = (s) => n(r, s, a)), a;
}
const rR = (e) => (t, n) => {
  const r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_g), i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wg), o = () => oX(e, t, r, i);
  return n ? o() : W1(o);
};
function aX(e, t, n, r) {
  const i = {}, o = r(e, {});
  for (const p in o)
    i[p] = lp(o[p]);
  let { initial: a, animate: s } = e;
  const l = Sg(e), c = ZI(e);
  t && c && !l && e.inherit !== !1 && (a === void 0 && (a = t.initial), s === void 0 && (s = t.animate));
  let f = n ? n.initial === !1 : !1;
  f = f || a === !1;
  const d = f ? s : a;
  if (d && typeof d != "boolean" && !yg(d)) {
    const p = Array.isArray(d) ? d : [d];
    for (let m = 0; m < p.length; m++) {
      const y = h1(e, p[m]);
      if (y) {
        const { transitionEnd: g, transition: v, ...x } = y;
        for (const w in x) {
          let S = x[w];
          if (Array.isArray(S)) {
            const A = f ? S.length - 1 : 0;
            S = S[A];
          }
          S !== null && (i[w] = S);
        }
        for (const w in g)
          i[w] = g[w];
      }
    }
  }
  return i;
}
const z1 = () => ({
  style: {},
  transform: {},
  transformOrigin: {},
  vars: {}
}), iR = () => ({
  ...z1(),
  attrs: {}
}), oR = (e, t) => t && typeof e == "number" ? t.transform(e) : e, sX = {
  x: "translateX",
  y: "translateY",
  z: "translateZ",
  transformPerspective: "perspective"
}, lX = dd.length;
function cX(e, t, n) {
  let r = "", i = !0;
  for (let o = 0; o < lX; o++) {
    const a = dd[o], s = e[a];
    if (s === void 0)
      continue;
    let l = !0;
    if (typeof s == "number" ? l = s === (a.startsWith("scale") ? 1 : 0) : l = parseFloat(s) === 0, !l || n) {
      const c = oR(s, S1[a]);
      if (!l) {
        i = !1;
        const f = sX[a] || a;
        r += `${f}(${c}) `;
      }
      n && (t[a] = c);
    }
  }
  return r = r.trim(), n ? r = n(t, i ? "" : r) : i && (r = "none"), r;
}
function V1(e, t, n) {
  const { style: r, vars: i, transformOrigin: o } = e;
  let a = !1, s = !1;
  for (const l in t) {
    const c = t[l];
    if (Gs.has(l)) {
      a = !0;
      continue;
    } else if (JD(l)) {
      i[l] = c;
      continue;
    } else {
      const f = oR(c, S1[l]);
      l.startsWith("origin") ? (s = !0, o[l] = f) : r[l] = f;
    }
  }
  if (t.transform || (a || n ? r.transform = cX(t, e.transform, n) : r.transform && (r.transform = "none")), s) {
    const { originX: l = "50%", originY: c = "50%", originZ: f = 0 } = o;
    r.transformOrigin = `${l} ${c} ${f}`;
  }
}
function sC(e, t, n) {
  return typeof e == "string" ? e : Be.transform(t + n * e);
}
function uX(e, t, n) {
  const r = sC(t, e.x, e.width), i = sC(n, e.y, e.height);
  return `${r} ${i}`;
}
const fX = {
  offset: "stroke-dashoffset",
  array: "stroke-dasharray"
}, dX = {
  offset: "strokeDashoffset",
  array: "strokeDasharray"
};
function hX(e, t, n = 1, r = 0, i = !0) {
  e.pathLength = 1;
  const o = i ? fX : dX;
  e[o.offset] = Be.transform(-r);
  const a = Be.transform(t), s = Be.transform(n);
  e[o.array] = `${a} ${s}`;
}
function U1(e, {
  attrX: t,
  attrY: n,
  attrScale: r,
  originX: i,
  originY: o,
  pathLength: a,
  pathSpacing: s = 1,
  pathOffset: l = 0,
  // This is object creation, which we try to avoid per-frame.
  ...c
}, f, d) {
  if (V1(e, c, d), f) {
    e.style.viewBox && (e.attrs.viewBox = e.style.viewBox);
    return;
  }
  e.attrs = e.style, e.style = {};
  const { attrs: p, style: m, dimensions: y } = e;
  p.transform && (y && (m.transform = p.transform), delete p.transform), y && (i !== void 0 || o !== void 0 || m.transform) && (m.transformOrigin = uX(y, i !== void 0 ? i : 0.5, o !== void 0 ? o : 0.5)), t !== void 0 && (p.x = t), n !== void 0 && (p.y = n), r !== void 0 && (p.scale = r), a !== void 0 && hX(p, a, s, l, !1);
}
const H1 = (e) => typeof e == "string" && e.toLowerCase() === "svg", pX = {
  useVisualState: rR({
    scrapeMotionValuesFromProps: nR,
    createRenderState: iR,
    onMount: (e, t, { renderState: n, latestValues: r }) => {
      Tt.read(() => {
        try {
          n.dimensions = typeof t.getBBox == "function" ? t.getBBox() : t.getBoundingClientRect();
        } catch {
          n.dimensions = {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          };
        }
      }), Tt.render(() => {
        U1(n, r, H1(t.tagName), e.transformTemplate), eR(t, n);
      });
    }
  })
}, mX = {
  useVisualState: rR({
    scrapeMotionValuesFromProps: F1,
    createRenderState: z1
  })
};
function aR(e, t, n) {
  for (const r in t)
    !rr(t[r]) && !tR(r, n) && (e[r] = t[r]);
}
function gX({ transformTemplate: e }, t) {
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const n = z1();
    return V1(n, t, e), Object.assign({}, n.vars, n.style);
  }, [t]);
}
function yX(e, t) {
  const n = e.style || {}, r = {};
  return aR(r, n, e), Object.assign(r, gX(e, t)), r;
}
function vX(e, t) {
  const n = {}, r = yX(e, t);
  return e.drag && e.dragListener !== !1 && (n.draggable = !1, r.userSelect = r.WebkitUserSelect = r.WebkitTouchCallout = "none", r.touchAction = e.drag === !0 ? "none" : `pan-${e.drag === "x" ? "y" : "x"}`), e.tabIndex === void 0 && (e.onTap || e.onTapStart || e.whileTap) && (n.tabIndex = 0), n.style = r, n;
}
const bX = /* @__PURE__ */ new Set([
  "animate",
  "exit",
  "variants",
  "initial",
  "style",
  "values",
  "variants",
  "transition",
  "transformTemplate",
  "custom",
  "inherit",
  "onBeforeLayoutMeasure",
  "onAnimationStart",
  "onAnimationComplete",
  "onUpdate",
  "onDragStart",
  "onDrag",
  "onDragEnd",
  "onMeasureDragConstraints",
  "onDirectionLock",
  "onDragTransitionEnd",
  "_dragX",
  "_dragY",
  "onHoverStart",
  "onHoverEnd",
  "onViewportEnter",
  "onViewportLeave",
  "globalTapTarget",
  "ignoreStrict",
  "viewport"
]);
function kp(e) {
  return e.startsWith("while") || e.startsWith("drag") && e !== "draggable" || e.startsWith("layout") || e.startsWith("onTap") || e.startsWith("onPan") || e.startsWith("onLayout") || bX.has(e);
}
let sR = (e) => !kp(e);
function xX(e) {
  e && (sR = (t) => t.startsWith("on") ? !kp(t) : e(t));
}
try {
  xX(require("@emotion/is-prop-valid").default);
} catch {
}
function wX(e, t, n) {
  const r = {};
  for (const i in e)
    i === "values" && typeof e.values == "object" || (sR(i) || n === !0 && kp(i) || !t && !kp(i) || // If trying to use native HTML drag events, forward drag listeners
    e.draggable && i.startsWith("onDrag")) && (r[i] = e[i]);
  return r;
}
function _X(e, t, n, r) {
  const i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const o = iR();
    return U1(o, t, H1(r), e.transformTemplate), {
      ...o.attrs,
      style: { ...o.style }
    };
  }, [t]);
  if (e.style) {
    const o = {};
    aR(o, e.style, e), i.style = { ...o, ...i.style };
  }
  return i;
}
function SX(e = !1) {
  return (n, r, i, { latestValues: o }, a) => {
    const l = (B1(n) ? _X : vX)(r, o, a, n), c = wX(r, typeof n == "string", e), f = n !== react__WEBPACK_IMPORTED_MODULE_1__.Fragment ? { ...c, ...l, ref: i } : {}, { children: d } = r, p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => rr(d) ? d.get() : d, [d]);
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(n, {
      ...f,
      children: p
    });
  };
}
function OX(e, t) {
  return function(r, { forwardMotionProps: i } = { forwardMotionProps: !1 }) {
    const a = {
      ...B1(r) ? pX : mX,
      preloadedFeatures: e,
      useRender: SX(i),
      createVisualElement: t,
      Component: r
    };
    return eX(a);
  };
}
const j0 = { current: null }, lR = { current: !1 };
function AX() {
  if (lR.current = !0, !!j1)
    if (window.matchMedia) {
      const e = window.matchMedia("(prefers-reduced-motion)"), t = () => j0.current = e.matches;
      e.addListener(t), t();
    } else
      j0.current = !1;
}
function TX(e, t, n) {
  for (const r in t) {
    const i = t[r], o = n[r];
    if (rr(i))
      e.addValue(r, i),  true && gg(i.version === "11.11.17", `Attempting to mix Motion versions ${i.version} with 11.11.17 may not work as expected.`);
    else if (rr(o))
      e.addValue(r, yf(i, { owner: e }));
    else if (o !== i)
      if (e.hasValue(r)) {
        const a = e.getValue(r);
        a.liveStyle === !0 ? a.jump(i) : a.hasAnimated || a.set(i);
      } else {
        const a = e.getStaticValue(r);
        e.addValue(r, yf(a !== void 0 ? a : i, { owner: e }));
      }
  }
  for (const r in n)
    t[r] === void 0 && e.removeValue(r);
  return t;
}
const lC = /* @__PURE__ */ new WeakMap(), PX = [...tI, er, Ba], CX = (e) => PX.find(eI(e)), cC = [
  "AnimationStart",
  "AnimationComplete",
  "Update",
  "BeforeLayoutMeasure",
  "LayoutMeasure",
  "LayoutAnimationStart",
  "LayoutAnimationComplete"
];
class EX {
  /**
   * This method takes React props and returns found MotionValues. For example, HTML
   * MotionValues will be found within the style prop, whereas for Three.js within attribute arrays.
   *
   * This isn't an abstract method as it needs calling in the constructor, but it is
   * intended to be one.
   */
  scrapeMotionValuesFromProps(t, n, r) {
    return {};
  }
  constructor({ parent: t, props: n, presenceContext: r, reducedMotionConfig: i, blockInitialAnimation: o, visualState: a }, s = {}) {
    this.current = null, this.children = /* @__PURE__ */ new Set(), this.isVariantNode = !1, this.isControllingVariants = !1, this.shouldReduceMotion = null, this.values = /* @__PURE__ */ new Map(), this.KeyframeResolver = x1, this.features = {}, this.valueSubscriptions = /* @__PURE__ */ new Map(), this.prevMotionValues = {}, this.events = {}, this.propEventSubscriptions = {}, this.notifyUpdate = () => this.notify("Update", this.latestValues), this.render = () => {
      this.current && (this.triggerBuild(), this.renderInstance(this.current, this.renderState, this.props.style, this.projection));
    }, this.renderScheduledAt = 0, this.scheduleRender = () => {
      const p = qi.now();
      this.renderScheduledAt < p && (this.renderScheduledAt = p, Tt.render(this.render, !1, !0));
    };
    const { latestValues: l, renderState: c } = a;
    this.latestValues = l, this.baseTarget = { ...l }, this.initialValues = n.initial ? { ...l } : {}, this.renderState = c, this.parent = t, this.props = n, this.presenceContext = r, this.depth = t ? t.depth + 1 : 0, this.reducedMotionConfig = i, this.options = s, this.blockInitialAnimation = !!o, this.isControllingVariants = Sg(n), this.isVariantNode = ZI(n), this.isVariantNode && (this.variantChildren = /* @__PURE__ */ new Set()), this.manuallyAnimateOnMount = !!(t && t.current);
    const { willChange: f, ...d } = this.scrapeMotionValuesFromProps(n, {}, this);
    for (const p in d) {
      const m = d[p];
      l[p] !== void 0 && rr(m) && m.set(l[p], !1);
    }
  }
  mount(t) {
    this.current = t, lC.set(t, this), this.projection && !this.projection.instance && this.projection.mount(t), this.parent && this.isVariantNode && !this.isControllingVariants && (this.removeFromVariantTree = this.parent.addVariantChild(this)), this.values.forEach((n, r) => this.bindToMotionValue(r, n)), lR.current || AX(), this.shouldReduceMotion = this.reducedMotionConfig === "never" ? !1 : this.reducedMotionConfig === "always" ? !0 : j0.current,  true && gg(this.shouldReduceMotion !== !0, "You have Reduced Motion enabled on your device. Animations may not appear as expected."), this.parent && this.parent.children.add(this), this.update(this.props, this.presenceContext);
  }
  unmount() {
    lC.delete(this.current), this.projection && this.projection.unmount(), ja(this.notifyUpdate), ja(this.render), this.valueSubscriptions.forEach((t) => t()), this.valueSubscriptions.clear(), this.removeFromVariantTree && this.removeFromVariantTree(), this.parent && this.parent.children.delete(this);
    for (const t in this.events)
      this.events[t].clear();
    for (const t in this.features) {
      const n = this.features[t];
      n && (n.unmount(), n.isMounted = !1);
    }
    this.current = null;
  }
  bindToMotionValue(t, n) {
    this.valueSubscriptions.has(t) && this.valueSubscriptions.get(t)();
    const r = Gs.has(t), i = n.on("change", (s) => {
      this.latestValues[t] = s, this.props.onUpdate && Tt.preRender(this.notifyUpdate), r && this.projection && (this.projection.isTransformDirty = !0);
    }), o = n.on("renderRequest", this.scheduleRender);
    let a;
    window.MotionCheckAppearSync && (a = window.MotionCheckAppearSync(this, t, n)), this.valueSubscriptions.set(t, () => {
      i(), o(), a && a(), n.owner && n.stop();
    });
  }
  sortNodePosition(t) {
    return !this.current || !this.sortInstanceNodePosition || this.type !== t.type ? 0 : this.sortInstanceNodePosition(this.current, t.current);
  }
  updateFeatures() {
    let t = "animation";
    for (t in tc) {
      const n = tc[t];
      if (!n)
        continue;
      const { isEnabled: r, Feature: i } = n;
      if (!this.features[t] && i && r(this.props) && (this.features[t] = new i(this)), this.features[t]) {
        const o = this.features[t];
        o.isMounted ? o.update() : (o.mount(), o.isMounted = !0);
      }
    }
  }
  triggerBuild() {
    this.build(this.renderState, this.latestValues, this.props);
  }
  /**
   * Measure the current viewport box with or without transforms.
   * Only measures axis-aligned boxes, rotate and skew must be manually
   * removed with a re-render to work.
   */
  measureViewportBox() {
    return this.current ? this.measureInstanceViewportBox(this.current, this.props) : ln();
  }
  getStaticValue(t) {
    return this.latestValues[t];
  }
  setStaticValue(t, n) {
    this.latestValues[t] = n;
  }
  /**
   * Update the provided props. Ensure any newly-added motion values are
   * added to our map, old ones removed, and listeners updated.
   */
  update(t, n) {
    (t.transformTemplate || this.props.transformTemplate) && this.scheduleRender(), this.prevProps = this.props, this.props = t, this.prevPresenceContext = this.presenceContext, this.presenceContext = n;
    for (let r = 0; r < cC.length; r++) {
      const i = cC[r];
      this.propEventSubscriptions[i] && (this.propEventSubscriptions[i](), delete this.propEventSubscriptions[i]);
      const o = "on" + i, a = t[o];
      a && (this.propEventSubscriptions[i] = this.on(i, a));
    }
    this.prevMotionValues = TX(this, this.scrapeMotionValuesFromProps(t, this.prevProps, this), this.prevMotionValues), this.handleChildMotionValue && this.handleChildMotionValue();
  }
  getProps() {
    return this.props;
  }
  /**
   * Returns the variant definition with a given name.
   */
  getVariant(t) {
    return this.props.variants ? this.props.variants[t] : void 0;
  }
  /**
   * Returns the defined default transition on this component.
   */
  getDefaultTransition() {
    return this.props.transition;
  }
  getTransformPagePoint() {
    return this.props.transformPagePoint;
  }
  getClosestVariantNode() {
    return this.isVariantNode ? this : this.parent ? this.parent.getClosestVariantNode() : void 0;
  }
  /**
   * Add a child visual element to our set of children.
   */
  addVariantChild(t) {
    const n = this.getClosestVariantNode();
    if (n)
      return n.variantChildren && n.variantChildren.add(t), () => n.variantChildren.delete(t);
  }
  /**
   * Add a motion value and bind it to this visual element.
   */
  addValue(t, n) {
    const r = this.values.get(t);
    n !== r && (r && this.removeValue(t), this.bindToMotionValue(t, n), this.values.set(t, n), this.latestValues[t] = n.get());
  }
  /**
   * Remove a motion value and unbind any active subscriptions.
   */
  removeValue(t) {
    this.values.delete(t);
    const n = this.valueSubscriptions.get(t);
    n && (n(), this.valueSubscriptions.delete(t)), delete this.latestValues[t], this.removeValueFromRenderState(t, this.renderState);
  }
  /**
   * Check whether we have a motion value for this key
   */
  hasValue(t) {
    return this.values.has(t);
  }
  getValue(t, n) {
    if (this.props.values && this.props.values[t])
      return this.props.values[t];
    let r = this.values.get(t);
    return r === void 0 && n !== void 0 && (r = yf(n === null ? void 0 : n, { owner: this }), this.addValue(t, r)), r;
  }
  /**
   * If we're trying to animate to a previously unencountered value,
   * we need to check for it in our state and as a last resort read it
   * directly from the instance (which might have performance implications).
   */
  readValue(t, n) {
    var r;
    let i = this.latestValues[t] !== void 0 || !this.current ? this.latestValues[t] : (r = this.getBaseTargetFromProps(this.props, t)) !== null && r !== void 0 ? r : this.readValueFromInstance(this.current, t, this.options);
    return i != null && (typeof i == "string" && (XD(i) || qD(i)) ? i = parseFloat(i) : !CX(i) && Ba.test(n) && (i = cI(t, n)), this.setBaseTarget(t, rr(i) ? i.get() : i)), rr(i) ? i.get() : i;
  }
  /**
   * Set the base target to later animate back to. This is currently
   * only hydrated on creation and when we first read a value.
   */
  setBaseTarget(t, n) {
    this.baseTarget[t] = n;
  }
  /**
   * Find the base target for a value thats been removed from all animation
   * props.
   */
  getBaseTarget(t) {
    var n;
    const { initial: r } = this.props;
    let i;
    if (typeof r == "string" || typeof r == "object") {
      const a = h1(this.props, r, (n = this.presenceContext) === null || n === void 0 ? void 0 : n.custom);
      a && (i = a[t]);
    }
    if (r && i !== void 0)
      return i;
    const o = this.getBaseTargetFromProps(this.props, t);
    return o !== void 0 && !rr(o) ? o : this.initialValues[t] !== void 0 && i === void 0 ? void 0 : this.baseTarget[t];
  }
  on(t, n) {
    return this.events[t] || (this.events[t] = new $1()), this.events[t].add(n);
  }
  notify(t, ...n) {
    this.events[t] && this.events[t].notify(...n);
  }
}
class cR extends EX {
  constructor() {
    super(...arguments), this.KeyframeResolver = uI;
  }
  sortInstanceNodePosition(t, n) {
    return t.compareDocumentPosition(n) & 2 ? 1 : -1;
  }
  getBaseTargetFromProps(t, n) {
    return t.style ? t.style[n] : void 0;
  }
  removeValueFromRenderState(t, { vars: n, style: r }) {
    delete n[t], delete r[t];
  }
}
function kX(e) {
  return window.getComputedStyle(e);
}
class MX extends cR {
  constructor() {
    super(...arguments), this.type = "html", this.renderInstance = JI;
  }
  readValueFromInstance(t, n) {
    if (Gs.has(n)) {
      const r = O1(n);
      return r && r.default || 0;
    } else {
      const r = kX(t), i = (JD(n) ? r.getPropertyValue(n) : r[n]) || 0;
      return typeof i == "string" ? i.trim() : i;
    }
  }
  measureInstanceViewportBox(t, { transformPagePoint: n }) {
    return RI(t, n);
  }
  build(t, n, r) {
    V1(t, n, r.transformTemplate);
  }
  scrapeMotionValuesFromProps(t, n, r) {
    return F1(t, n, r);
  }
  handleChildMotionValue() {
    this.childSubscription && (this.childSubscription(), delete this.childSubscription);
    const { children: t } = this.props;
    rr(t) && (this.childSubscription = t.on("change", (n) => {
      this.current && (this.current.textContent = `${n}`);
    }));
  }
}
class NX extends cR {
  constructor() {
    super(...arguments), this.type = "svg", this.isSVGTag = !1, this.measureInstanceViewportBox = ln;
  }
  getBaseTargetFromProps(t, n) {
    return t[n];
  }
  readValueFromInstance(t, n) {
    if (Gs.has(n)) {
      const r = O1(n);
      return r && r.default || 0;
    }
    return n = QI.has(n) ? n : D1(n), t.getAttribute(n);
  }
  scrapeMotionValuesFromProps(t, n, r) {
    return nR(t, n, r);
  }
  build(t, n, r) {
    U1(t, n, this.isSVGTag, r.transformTemplate);
  }
  renderInstance(t, n, r, i) {
    eR(t, n, r, i);
  }
  mount(t) {
    this.isSVGTag = H1(t.tagName), super.mount(t);
  }
}
const $X = (e, t) => B1(e) ? new NX(t) : new MX(t, {
  allowProjection: e !== react__WEBPACK_IMPORTED_MODULE_1__.Fragment
}), DX = /* @__PURE__ */ OX({
  ...S9,
  ...H7,
  ...D7,
  ...K7
}, $X), An = /* @__PURE__ */ pY(DX);
class IX extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
  getSnapshotBeforeUpdate(t) {
    const n = this.props.childRef.current;
    if (n && t.isPresent && !this.props.isPresent) {
      const r = this.props.sizeRef.current;
      r.height = n.offsetHeight || 0, r.width = n.offsetWidth || 0, r.top = n.offsetTop, r.left = n.offsetLeft;
    }
    return null;
  }
  /**
   * Required with getSnapshotBeforeUpdate to stop React complaining.
   */
  componentDidUpdate() {
  }
  render() {
    return this.props.children;
  }
}
function RX({ children: e, isPresent: t }) {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)(), r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)({
    width: 0,
    height: 0,
    top: 0,
    left: 0
  }), { nonce: o } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(R1);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useInsertionEffect)(() => {
    const { width: a, height: s, top: l, left: c } = i.current;
    if (t || !r.current || !a || !s)
      return;
    r.current.dataset.motionPopId = n;
    const f = document.createElement("style");
    return o && (f.nonce = o), document.head.appendChild(f), f.sheet && f.sheet.insertRule(`
          [data-motion-pop-id="${n}"] {
            position: absolute !important;
            width: ${a}px !important;
            height: ${s}px !important;
            top: ${l}px !important;
            left: ${c}px !important;
          }
        `), () => {
      document.head.removeChild(f);
    };
  }, [t]), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IX, { isPresent: t, childRef: r, sizeRef: i, children: react__WEBPACK_IMPORTED_MODULE_1__.cloneElement(e, { ref: r }) });
}
const jX = ({ children: e, initial: t, isPresent: n, onExitComplete: r, custom: i, presenceAffectsLayout: o, mode: a }) => {
  const s = W1(LX), l = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)(), c = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((d) => {
    s.set(d, !0);
    for (const p of s.values())
      if (!p)
        return;
    r && r();
  }, [s, r]), f = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => ({
      id: l,
      initial: t,
      isPresent: n,
      custom: i,
      onExitComplete: c,
      register: (d) => (s.set(d, !1), () => s.delete(d))
    }),
    /**
     * If the presence of a child affects the layout of the components around it,
     * we want to make a new context value to ensure they get re-rendered
     * so they can detect that layout change.
     */
    o ? [Math.random(), c] : [n, c]
  );
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    s.forEach((d, p) => s.set(p, !1));
  }, [n]), react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    !n && !s.size && r && r();
  }, [n]), a === "popLayout" && (e = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RX, { isPresent: n, children: e })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(wg.Provider, { value: f, children: e });
};
function LX() {
  return /* @__PURE__ */ new Map();
}
const Nh = (e) => e.key || "";
function uC(e) {
  const t = [];
  return react__WEBPACK_IMPORTED_MODULE_1__.Children.forEach(e, (n) => {
    (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(n) && t.push(n);
  }), t;
}
const Ys = ({ children: e, exitBeforeEnter: t, custom: n, initial: r = !0, onExitComplete: i, presenceAffectsLayout: o = !0, mode: a = "sync" }) => {
  Wo(!t, "Replace exitBeforeEnter with mode='wait'");
  const s = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => uC(e), [e]), l = s.map(Nh), c = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!0), f = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(s), d = W1(() => /* @__PURE__ */ new Map()), [p, m] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(s), [y, g] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(s);
  L1(() => {
    c.current = !1, f.current = s;
    for (let w = 0; w < y.length; w++) {
      const S = Nh(y[w]);
      l.includes(S) ? d.delete(S) : d.get(S) !== !0 && d.set(S, !1);
    }
  }, [y, l.length, l.join("-")]);
  const v = [];
  if (s !== p) {
    let w = [...s];
    for (let S = 0; S < y.length; S++) {
      const A = y[S], _ = Nh(A);
      l.includes(_) || (w.splice(S, 0, A), v.push(A));
    }
    a === "wait" && v.length && (w = v), g(uC(w)), m(s);
    return;
  }
   true && a === "wait" && y.length > 1 && console.warn(`You're attempting to animate multiple children within AnimatePresence, but its mode is set to "wait". This will lead to odd visual behaviour.`);
  const { forceRender: x } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(vf);
  return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: y.map((w) => {
    const S = Nh(w), A = s === y || l.includes(S), _ = () => {
      if (d.has(S))
        d.set(S, !0);
      else
        return;
      let O = !0;
      d.forEach((P) => {
        P || (O = !1);
      }), O && (x == null || x(), g(f.current), i && i());
    };
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(jX, { isPresent: A, initial: !c.current || r ? void 0 : !1, custom: A ? void 0 : n, presenceAffectsLayout: o, mode: a, onExitComplete: A ? void 0 : _, children: w }, S);
  }) });
}, BX = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null);
function FX() {
  const e = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!1);
  return L1(() => (e.current = !0, () => {
    e.current = !1;
  }), []), e;
}
function WX() {
  const e = FX(), [t, n] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(0), r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    e.current && n(t + 1);
  }, [t]);
  return [(0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => Tt.postRender(r), [r]), t];
}
const zX = (e) => !e.isLayoutDirty && e.willUpdate(!1);
function fC() {
  const e = /* @__PURE__ */ new Set(), t = /* @__PURE__ */ new WeakMap(), n = () => e.forEach(zX);
  return {
    add: (r) => {
      e.add(r), t.set(r, r.addEventListener("willUpdate", n));
    },
    remove: (r) => {
      e.delete(r);
      const i = t.get(r);
      i && (i(), t.delete(r)), n();
    },
    dirty: n
  };
}
const uR = (e) => e === !0, VX = (e) => uR(e === !0) || e === "id", UX = ({ children: e, id: t, inherit: n = !0 }) => {
  const r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(vf), i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(BX), [o, a] = WX(), s = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), l = r.id || i;
  s.current === null && (VX(n) && l && (t = t ? l + "-" + t : l), s.current = {
    id: t,
    group: uR(n) && r.group || fC()
  });
  const c = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({ ...s.current, forceRender: o }), [a]);
  return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(vf.Provider, { value: c, children: e });
}, HX = (e, t, n) => {
  const r = t - e;
  return ((n - e) % r + r) % r + e;
};
function KX(...e) {
  const t = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(0), [n, r] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(e[t.current]), i = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (o) => {
      t.current = typeof o != "number" ? HX(0, e.length, t.current + 1) : o, r(e[t.current]);
    },
    // The array will change on each call, but by putting items.length at
    // the front of this array, we guarantee the dependency comparison will match up
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [e.length, ...e]
  );
  return [n, i];
}
const fR = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), dR = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(fR), hR = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null), GX = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(hR), pR = ({
  children: e,
  activeItem: t = null,
  // The currently active item in the group.
  onChange: n,
  // Callback when the active item changes.
  className: r,
  // Additional class names for styling.
  size: i = "sm",
  // Size of the tabs in the group ('xs', 'sm', 'md', 'lg').
  orientation: o = "horizontal",
  // Orientation of the tabs ('horizontal', 'vertical').
  variant: a = "pill",
  // Style variant of the tabs ('pill', 'rounded', 'underline').
  iconPosition: s = "left",
  // Position of the icon in the tab ('left' or 'right').
  width: l = "full"
  // Width of the tabs ('auto' or 'full').
}) => {
  const c = io(), f = dR(), d = (f == null ? void 0 : f.activeItem) || t, p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (O, P) => {
      n && n({ event: O, value: P });
    },
    [n]
  );
  let m = "rounded-full", y = "p-1", g, v = "ring-1 ring-tab-border";
  o === "vertical" ? g = "gap-0.5" : (a === "rounded" || a === "pill") && (i === "xs" || i === "sm" ? g = "gap-0.5" : (i === "md" || i === "lg") && (g = "gap-1")), a === "rounded" || o === "vertical" ? m = "rounded-md" : a === "underline" && (m = "rounded-none", y = "p-0", v = "border-t-0 border-r-0 border-l-0 border-b border-solid border-tab-border", i === "xs" ? g = "gap-0" : i === "sm" ? g = "gap-2.5" : (i === "md" || i === "lg") && (g = "gap-3"));
  const _ = K(
    `box-border [&>*]:box-border flex items-center ${l === "full" ? "w-full" : ""} ${o === "vertical" ? "flex-col" : ""}`,
    m,
    y,
    g,
    v,
    a !== "underline" ? "bg-tab-background" : "",
    r
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    hR.Provider,
    {
      value: {
        activeItem: d,
        onChange: p,
        size: i,
        variant: a,
        orientation: o,
        iconPosition: s,
        width: l
      },
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UX, { id: c, children: react__WEBPACK_IMPORTED_MODULE_1__.Children.map(e, (O) => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(O) ? react__WEBPACK_IMPORTED_MODULE_1__.cloneElement(O) : null) })
    }
  ) });
};
pR.displayName = "Tabs.Group";
const mR = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    slug: e,
    text: t,
    icon: n,
    className: r,
    disabled: i = !1,
    badge: o = null,
    ...a
  }, s) => {
    const l = GX();
    if (!l)
      throw new Error("Tab should be used inside Tabs Group");
    const {
      activeItem: c,
      onChange: f,
      size: d,
      variant: p,
      orientation: m,
      iconPosition: y,
      width: g
    } = l, v = {
      xs: "px-1.5 py-0.5 text-xs [&_svg]:size-3",
      sm: p === "underline" ? "py-1.5 text-sm [&_svg]:size-4" : "px-3 py-1.5 text-sm [&_svg]:size-4",
      md: p === "underline" ? "py-2 text-base [&_svg]:size-5" : "px-3.5 py-1.5 text-base [&_svg]:size-5",
      lg: p === "underline" ? "p-2.5 text-lg [&_svg]:size-6" : "px-3.5 py-1.5 text-lg [&_svg]:size-6"
    }[d], S = K(
      "relative border-none bg-transparent text-text-secondary cursor-pointer flex items-center justify-center transition-[box-shadow,color,background-color] duration-200",
      g === "full" ? "flex-1" : "",
      m === "vertical" ? "w-full justify-between" : ""
    ), A = "border-none";
    let _ = "rounded-full";
    p === "rounded" ? _ = "rounded-md" : p === "underline" && (_ = "rounded-none");
    const I = K(
      S,
      A,
      _,
      "hover:text-text-primary group",
      "focus:outline-none",
      v,
      c === e ? "bg-background-primary text-text-primary shadow-sm" : "",
      i ? "text-text-disabled cursor-not-allowed hover:text-text-disabled" : "",
      r
    ), $ = K(
      "flex items-center gap-1 group-hover:text-text-primary",
      i && "group-hover:text-text-disabled"
    ), N = (D) => {
      f(D, { slug: e, text: t });
    };
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      An.button,
      {
        ref: s,
        className: I,
        disabled: i,
        onClick: N,
        ...a,
        layoutRoot: !0,
        children: [
          c === e && p === "underline" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            An.span,
            {
              layoutId: "underline",
              layoutDependency: c,
              className: "absolute right-0 left-0 -bottom-px h-px bg-border-interactive"
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: $, children: [
            y === "left" && n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "mr-1 contents center-center transition duration-150", children: n }),
            t,
            y === "right" && n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "ml-1 contents center-center transition duration-150", children: n })
          ] }),
          o && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(o) && o
        ]
      }
    );
  }
);
mR.displayName = "Tabs.Tab";
const K1 = ({ activeItem: e, children: t }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(fR.Provider, { value: { activeItem: e }, children: t }), gR = ({ slug: e, children: t }) => {
  const n = dR();
  if (!n)
    throw new Error("TabPanel should be used inside Tabs");
  return e === n.activeItem ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: t }) : null;
};
gR.displayName = "Tabs.Panel";
K1.Group = pR;
K1.Tab = mR;
K1.Panel = gR;
const ui = {
  sm: {
    icon: "[&>svg]:size-4",
    searchIcon: "[&>svg]:size-4",
    selectButton: "px-2.5 py-2 rounded text-sm font-medium leading-4 min-h-[2rem]",
    multiSelect: "pl-2 pr-2 py-1.5",
    displaySelected: "text-sm font-normal",
    dropdown: "rounded-md",
    dropdownItemsWrapper: "p-1.5",
    searchbarWrapper: "p-3 flex items-center gap-0.5",
    searchbar: "font-medium text-sm",
    searchbarIcon: "size-4",
    label: "text-sm font-medium"
  },
  md: {
    icon: "[&>svg]:size-5",
    searchIcon: "[&>svg]:size-5",
    selectButton: "px-3.5 py-2.5 rounded-md text-xs font-medium leading-4 min-h-[2.5rem]",
    multiSelect: "pl-2 pr-2.5 py-2",
    displaySelected: "text-sm font-normal",
    dropdown: "rounded-lg",
    dropdownItemsWrapper: "p-2",
    searchbarWrapper: "p-2.5 flex items-center gap-1",
    searchbar: "font-medium text-sm",
    searchbarIcon: "size-5",
    label: "text-sm font-medium"
  },
  lg: {
    icon: "[&>svg]:size-6",
    searchIcon: "[&>svg]:size-5",
    selectButton: "px-4 py-3 rounded-lg text-sm font-medium leading-5 min-h-[3rem]",
    multiSelect: "pl-2.5 pr-3 py-2.5",
    displaySelected: "text-base font-normal",
    dropdown: "rounded-lg",
    dropdownItemsWrapper: "p-2",
    searchbarWrapper: "p-2.5 flex items-center gap-1",
    searchbar: "font-medium text-sm",
    searchbarIcon: "size-5",
    label: "text-base font-medium"
  }
}, $h = {
  selectButton: "group disabled:outline-field-border-disabled [&:hover:has(:disabled)]:outline-field-border-disabled disabled:cursor-default",
  icon: "group-disabled:text-icon-disabled",
  text: "group-disabled:text-field-color-disabled"
}, YX = "h-px my-2 w-full border-border-subtle border-b border-t-0 border-solid", qX = {
  sm: "w-[calc(100%+0.75rem)] translate-x-[-0.375rem]",
  md: "w-[calc(100%+1rem)] translate-x-[-0.5rem]",
  lg: "w-[calc(100%+1rem)] translate-x-[-0.5rem]"
}, cp = (e) => {
  var t;
  return typeof e == "string" ? e : typeof e == "object" && "textContent" in e ? ((t = e.textContent) == null ? void 0 : t.toString().toLowerCase()) || "" : typeof e == "object" && "children" in e ? cp(e.children) : "";
}, XX = (e, t = 500) => {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (...r) => {
      n.current && clearTimeout(n.current), n.current = setTimeout(
        () => e(...r),
        t
      );
    },
    [e, t]
  );
}, yR = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(
  {}
), Og = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(yR);
function vR({
  children: e,
  icon: t = null,
  // Icon to show in the select button.
  placeholder: n = "Select an option",
  // Placeholder text.
  optionIcon: r = null,
  // Icon to show in the selected option.
  render: i,
  label: o,
  // Label for the select component.
  className: a,
  ...s
}) {
  var k, I;
  const {
    sizeValue: l,
    getReferenceProps: c,
    getValues: f,
    selectId: d,
    refs: p,
    isOpen: m,
    multiple: y,
    combobox: g,
    setSelected: v,
    onChange: x,
    isControlled: w,
    disabled: S,
    by: A
  } = Og(), _ = {
    sm: "xs",
    md: "sm",
    lg: "md"
  }[l], O = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    if (t)
      return t;
    const $ = "text-field-placeholder " + $h.icon;
    return g ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(YH, { className: $ }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Xw, { className: $ });
  }, [t]), P = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    const $ = f();
    if (!$)
      return null;
    if (y)
      return $.map(
        (D, j) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          mg,
          {
            className: "cursor-default",
            icon: r,
            type: "rounded",
            size: _,
            onMouseDown: C(D),
            label: typeof i == "function" ? i(D) : D.toString(),
            closable: !0,
            disabled: S
          },
          j
        )
      );
    let N = typeof $ == "string" ? $ : "";
    if (typeof i == "function" && (N = i($)), typeof e == "function" && typeof i != "function") {
      const D = {
        value: $,
        ...y ? {
          onClose: C(
            $
          )
        } : {}
      };
      N = e(D);
    }
    return ((0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e) || typeof e == "string") && typeof i != "function" && (N = e), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "span",
      {
        className: K(
          "truncate",
          ui[l].displaySelected,
          $h.text
        ),
        children: N
      }
    );
  }, [f, S]), C = ($) => (N) => {
    N == null || N.preventDefault(), N == null || N.stopPropagation();
    const D = [
      ...f() ?? []
    ], j = D.findIndex((F) => F !== null && $ !== null && typeof F == "object" ? F[A] === $[A] : F === $);
    j !== -1 && (D.splice(j, 1), w || v(D), typeof x == "function" && x(D));
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "w-full flex flex-col items-start gap-1.5 [&_*]:box-border box-border", children: [
    !!o && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "label",
      {
        className: K(
          (k = ui[l]) == null ? void 0 : k.label,
          "text-field-label"
        ),
        htmlFor: d,
        children: o
      }
    ),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "button",
      {
        id: d,
        ref: p.setReference,
        className: K(
          "flex items-center justify-between w-full box-border transition-[outline,background-color,color,box-shadow] duration-200 bg-white",
          "outline outline-1 outline-field-border border-none cursor-pointer",
          !m && "focus:ring-2 focus:ring-offset-2 focus:outline-focus-border focus:ring-focus [&:hover:not(:focus):not(:disabled)]:outline-border-strong",
          ui[l].selectButton,
          y && ui[l].multiSelect,
          $h.selectButton,
          a
        ),
        tabIndex: 0,
        disabled: S,
        ...s,
        ...c(),
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
            "div",
            {
              className: K(
                "flex-1 grid items-center justify-start gap-1.5 overflow-hidden",
                f() && "flex flex-wrap"
              ),
              children: [
                P(),
                (y ? !((I = f()) != null && I.length) : !f()) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                  "div",
                  {
                    className: K(
                      "[grid-area:1/1/2/3] text-field-input px-1",
                      ui[l].displaySelected,
                      $h.text
                    ),
                    children: n
                  }
                )
              ]
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "div",
            {
              className: K(
                "flex items-center [&>svg]:shrink-0",
                ui[l].icon
              ),
              children: O()
            }
          )
        ]
      }
    )
  ] });
}
function Rl({
  label: e,
  children: t,
  className: n,
  ...r
}) {
  const { index: i, totalGroups: o } = r, { sizeValue: a } = Og();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: [
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex flex-col", role: "group", "aria-label": e, children: [
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          className: K(
            "p-2 font-normal text-text-tertiary",
            {
              sm: "text-xs",
              md: "text-xs",
              lg: "text-sm"
            }[a],
            n
          ),
          id: `group-${e == null ? void 0 : e.toLowerCase().replace(/\s+/g, "-")}`,
          children: e
        }
      ),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          className: "flex flex-col",
          role: "presentation",
          "aria-labelledby": `group-${e == null ? void 0 : e.toLowerCase().replace(/\s+/g, "-")}`,
          children: t
        }
      )
    ] }),
    i < o && !!(t && react__WEBPACK_IMPORTED_MODULE_1__.Children.count(t) > 0) && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "hr",
      {
        className: K(
          YX,
          qX[a]
        )
      }
    )
  ] });
}
function bR({
  children: e,
  className: t
  // Additional class name for the dropdown.
}) {
  const {
    isOpen: n,
    context: r,
    refs: i,
    combobox: o,
    floatingStyles: a,
    getFloatingProps: s,
    sizeValue: l,
    setSearchKeyword: c,
    setActiveIndex: f,
    setSelectedIndex: d,
    value: p,
    selected: m,
    getValues: y,
    searchKeyword: g,
    listContentRef: v,
    by: x,
    searchPlaceholder: w,
    activeIndex: S,
    searchFn: A,
    debounceDelay: _
  } = Og(), O = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const D = y();
    let j = -1;
    if (D) {
      let F = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(e);
      F.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(F[0]) && F[0].type === Rl && (F = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(e).map(
        (W) => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(W) ? react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(W.props.children) : []
      ).flat()), j = F.findIndex((W) => {
        if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(W))
          return !1;
        const z = W.props.value;
        return typeof z == "object" && typeof D == "object" ? z[x] === D[x] : z === D;
      });
    }
    return j;
  }, [p, m, e, x]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect)(() => {
    n || (f(O), d(O));
  }, [O, n]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect)(() => {
    n && (o && [-1, null].includes(S) || f(-1));
  }, [g, n]);
  const P = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    let D = 0, j = 0;
    react__WEBPACK_IMPORTED_MODULE_1__.Children.forEach(e, (H) => {
      (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(H) && H.type === Rl && react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(
        H.props.children
      ).some((V) => {
        var Y;
        if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(V))
          return !1;
        if (g && !A) {
          const Q = (Y = cp(
            V.props.children
          )) == null ? void 0 : Y.toLowerCase(), ne = g.toLowerCase();
          return Q.includes(ne);
        }
        return !0;
      }) && D++;
    }), j = Math.max(0, D - 1);
    let F = 0, W = 0;
    const z = (H) => {
      var U, V;
      if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(H))
        return null;
      if (H.type === Rl) {
        const Y = react__WEBPACK_IMPORTED_MODULE_1__.Children.map(
          H.props.children,
          z
        );
        if (!(Y == null ? void 0 : Y.some((re) => re !== null)))
          return null;
        const ne = {
          ...H.props,
          children: Y,
          index: W,
          totalGroups: j
        };
        return W++, (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(H, ne);
      }
      if (g && !A) {
        const Y = (V = cp(
          (U = H.props) == null ? void 0 : U.children
        )) == null ? void 0 : V.toLowerCase(), Q = g.toLowerCase();
        if (!(Y == null ? void 0 : Y.includes(Q)))
          return null;
      }
      return (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(H, {
        ...H.props,
        index: F++
      });
    };
    return react__WEBPACK_IMPORTED_MODULE_1__.Children.map(e, z);
  }, [g, p, m, e, A]), C = react__WEBPACK_IMPORTED_MODULE_1__.Children.count(P);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    v.current = [];
    let D = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(e);
    D && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(D[0]) && D[0].type === Rl && (D = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(D).map(
      (j) => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(j) ? j.props.children : null
    ).filter(Boolean)), react__WEBPACK_IMPORTED_MODULE_1__.Children.forEach(D, (j) => {
      var W, z;
      if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(j))
        return;
      const F = (z = cp(
        (W = j.props) == null ? void 0 : W.children
      )) == null ? void 0 : z.toLowerCase();
      if (g && !A) {
        const H = g.toLowerCase();
        if (!(F == null ? void 0 : F.includes(H)))
          return;
      }
      v.current.push(F);
    });
  }, [g, A]);
  const [k, I] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), $ = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async () => {
    if (!(!A || typeof A != "function" || k)) {
      I(!0);
      try {
        await A(g);
      } catch (D) {
        console.error(D);
      } finally {
        I(!1);
      }
    }
  }, [g]), N = XX($, _);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    typeof A == "function" && N();
  }, [N]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HG, { context: r, modal: !1, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      ref: i.setFloating,
      className: K(
        "box-border [&_*]:box-border w-full bg-white outline-none shadow-lg outline outline-1 outline-border-subtle",
        o && "grid grid-cols-1 grid-rows-[auto_1fr] divide-y divide-x-0 divide-solid divide-border-subtle",
        ui[l].dropdown,
        !o && "h-auto",
        o ? "overflow-hidden" : "overflow-y-auto overflow-x-hidden",
        t
      ),
      style: {
        ...a
      },
      ...s(),
      children: [
        o && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
          "div",
          {
            className: K(
              ui[l].searchbarWrapper
            ),
            children: [
              k ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                d1,
                {
                  className: ui[l].searchbarIcon
                }
              ) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                rD,
                {
                  className: K(
                    "text-icon-secondary shrink-0",
                    ui[l].searchbarIcon
                  )
                }
              ),
              /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                "input",
                {
                  className: K(
                    "px-1 w-full placeholder:text-field-placeholder border-0 focus:outline-none focus:shadow-none",
                    ui[l].searchbar
                  ),
                  type: "search",
                  name: "keyword",
                  placeholder: w,
                  onChange: (D) => c(D.target.value),
                  value: g,
                  autoComplete: "off"
                }
              )
            ]
          }
        ),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
          "div",
          {
            className: K(
              "overflow-y-auto overflow-x-hidden",
              !o && "w-full h-full",
              ui[l].dropdownItemsWrapper
            ),
            children: [
              !!C && P,
              !C && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "p-2 text-center text-base font-medium text-field-placeholder", children: "No items found" })
            ]
          }
        )
      ]
    }
  ) }) }) });
}
function xR({ children: e, root: t, id: n }) {
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ug, { id: n, root: t, children: e });
}
function wR({
  value: e,
  selected: t,
  children: n,
  className: r,
  ...i
}) {
  const {
    sizeValue: o,
    getItemProps: a,
    onKeyDownItem: s,
    onClickItem: l,
    activeIndex: c,
    selectedIndex: f,
    updateListRef: d,
    getValues: p,
    by: m,
    multiple: y
  } = Og(), { index: g } = i, v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(g), x = {
    sm: "py-1.5 px-2 text-sm font-normal",
    md: "p-2 text-sm font-normal",
    lg: "p-2 text-base font-normal"
  }, w = {
    sm: "size-4",
    md: "size-4",
    lg: "size-5"
  }, S = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    if (!y)
      return !1;
    const _ = p();
    return _ ? _.some((O) => O !== null && e !== null && typeof O == "object" ? O[m] === e[m] : O === e) : !1;
  }, [e, p]), A = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof t == "boolean" ? t : y ? S : g === f, [S, f, t]);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        "w-full flex items-center justify-between text-text-primary hover:bg-button-tertiary-hover rounded-md transition-all duration-150 cursor-pointer focus:outline-none focus-within:outline-none outline-none",
        x[o],
        g === c && "bg-button-tertiary-hover",
        r
      ),
      ref: (_) => {
        d(g, _);
      },
      role: "option",
      tabIndex: g === c ? 0 : -1,
      "aria-selected": A && g === c,
      ...a({
        // Handle pointer select.
        onClick() {
          l(v.current, e);
        },
        // Handle keyboard select.
        onKeyDown(_) {
          s(
            _,
            v.current,
            e
          );
        }
      }),
      children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "w-full truncate", children: n }),
        A && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          sd,
          {
            className: K(
              "text-icon-on-color-disabled",
              w[o]
            )
          }
        )
      ]
    }
  );
}
const _R = ({
  id: e,
  size: t = "md",
  // sm, md, lg
  value: n,
  // Value of the select (for controlled component).
  defaultValue: r,
  // Default value of the select (for uncontrolled component).
  onChange: i,
  // Callback function to handle the change event.
  by: o = "id",
  // Used to identify the select component. Default is 'id'.
  children: a,
  multiple: s = !1,
  // If true, it will allow multiple selection.
  combobox: l = !1,
  // If true, it will show a search box.
  disabled: c = !1,
  // If true, it will disable the select component.
  searchPlaceholder: f = "Search...",
  // Placeholder text for search box.
  searchFn: d,
  // Function to handle the search.
  debounceDelay: p = 500
  // Debounce delay for the search.
}) => {
  const m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e || `select-${io()}`, [e]), y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => typeof n < "u", [n]), [g, v] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(r), [x, w] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(""), S = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => y ? n : g, [y, n, g]), [A, _] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), [O, P] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), [C, k] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), I = {
    sm: l ? 256 : 172,
    md: l ? 256 : 216,
    lg: l ? 256 : 216
  }, { refs: $, floatingStyles: N, context: D } = dg({
    placement: "bottom-start",
    open: A,
    onOpenChange: _,
    whileElementsMounted: ig,
    middleware: [
      og(5),
      ag({ padding: 10 }),
      SD({
        apply({ rects: se, elements: ge, availableHeight: X }) {
          Object.assign(ge.floating.style, {
            maxHeight: `min(${X}px, ${I[t]}px)`,
            maxWidth: `${se.reference.width}px`
          });
        },
        padding: 10
      })
    ]
  }), j = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)([]), F = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)([]), W = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!1), z = c1(D, { event: "mousedown" }), H = fg(D), U = u1(D, { role: "listbox" }), V = ZG(D, {
    listRef: j,
    activeIndex: O,
    selectedIndex: C,
    onNavigate: P,
    // This is a large list, allow looping.
    loop: !0
  }), Y = tY(D, {
    listRef: F,
    activeIndex: O,
    selectedIndex: C,
    onMatch: A ? P : k,
    onTypingChange(se) {
      W.current = se;
    }
  }), { getReferenceProps: Q, getFloatingProps: ne, getItemProps: re } = hg([
    H,
    U,
    V,
    z,
    ...l ? [] : [Y]
  ]), ce = (se, ge) => {
    const X = [
      ...S() ?? []
    ];
    X.findIndex((de) => de !== null && ge !== null && typeof de == "object" ? de[o] === ge[o] : de === ge) === -1 && (X.push(ge), y || v(X), k(se), $.reference.current.focus(), _(!1), w(""), typeof i == "function" && i(X));
  }, oe = (se, ge) => {
    if (s)
      return ce(se, ge);
    k(se), y || v(ge), $.reference.current.focus(), _(!1), w(""), typeof i == "function" && i(ge);
  }, fe = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((se, ge) => {
    j.current[se] = ge;
  }, []), ae = (se, ge) => {
    oe(se, ge);
  }, ee = (se, ge, X) => {
    se.key === "Enter" && (se.preventDefault(), oe(ge, X)), se.key === " " && !W.current && (se.preventDefault(), oe(ge, X));
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    yR.Provider,
    {
      value: {
        selectedIndex: C,
        setSelectedIndex: k,
        activeIndex: O,
        setActiveIndex: P,
        selected: g,
        setSelected: v,
        handleSelect: oe,
        combobox: l,
        sizeValue: t,
        multiple: s,
        onChange: i,
        isTypingRef: W,
        getItemProps: re,
        onClickItem: ae,
        onKeyDownItem: ee,
        getValues: S,
        selectId: m,
        getReferenceProps: Q,
        isOpen: A,
        value: n,
        updateListRef: fe,
        refs: $,
        listContentRef: F,
        by: o,
        getFloatingProps: ne,
        floatingStyles: N,
        context: D,
        searchKeyword: x,
        setSearchKeyword: w,
        disabled: c,
        isControlled: y,
        searchPlaceholder: f,
        searchFn: d,
        debounceDelay: p
      },
      children: a
    }
  );
};
_R.displayName = "Select";
const QEe = Object.assign((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(_R), {
  Portal: (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(xR),
  Button: (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(vR),
  Options: (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(bR),
  Option: (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(wR),
  OptionGroup: (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Rl)
});
xR.displayName = "Select.Portal";
vR.displayName = "Select.Button";
bR.displayName = "Select.Options";
wR.displayName = "Select.Option";
Rl.displayName = "Select.OptionGroup";
let ZX = 1;
var xr, Fi;
class JX {
  constructor() {
    zv(this, xr);
    zv(this, Fi);
    as(this, xr, []), as(this, Fi, []);
  }
  // Subscriber pattern.
  subscribe(t) {
    return Dr(this, Fi).push(t), () => {
      as(this, Fi, Dr(this, Fi).filter(
        (n) => n !== t
      ));
    };
  }
  // Publish a new toast.
  publish(t) {
    Dr(this, Fi).forEach((n) => n(t));
  }
  // Add a new toast.
  add(t) {
    Dr(this, xr).push(t), this.publish(t);
  }
  // Remove a toast.
  remove(t) {
    return as(this, xr, Dr(this, xr).filter((n) => n.id !== t)), t;
  }
  // Create a new toast.
  create(t) {
    const {
      id: n = void 0,
      message: r = "",
      jsx: i = void 0,
      ...o
    } = t;
    if (!r && typeof i != "function")
      return;
    const a = typeof n == "number" ? n : ZX++;
    return Dr(this, xr).find((l) => l.id === a) && as(this, xr, Dr(this, xr).map((l) => l.id === a ? (this.publish({
      ...l,
      title: r,
      jsx: i,
      ...o
    }), { ...l, title: r, jsx: i, ...o }) : l)), this.add({ id: a, title: r, jsx: i, ...o }), a;
  }
  // Update a toast.
  update(t, n) {
    const { render: r = void 0 } = n;
    let i = n;
    switch (typeof r) {
      case "function":
        i = {
          jsx: r,
          ...n
        };
        break;
      case "string":
        i = {
          title: r,
          ...n
        };
        break;
    }
    as(this, xr, Dr(this, xr).map((o) => o.id === t ? (this.publish({ ...o, ...i }), { ...o, ...i }) : o));
  }
  // Dismiss toast.
  dismiss(t) {
    return t || Dr(this, xr).forEach(
      (n) => Dr(this, Fi).forEach(
        (r) => r({ id: n.id, dismiss: !0 })
      )
    ), Dr(this, Fi).forEach(
      (n) => n({ id: t, dismiss: !0 })
    ), t;
  }
  // History of toasts.
  history() {
    return Dr(this, xr);
  }
  // Types of toasts.
  // Default toast.
  default(t = "", n = {}) {
    return this.create({ message: t, type: "neutral", ...n });
  }
  // Success toast.
  success(t = "", n = {}) {
    return this.create({ message: t, type: "success", ...n });
  }
  // Error toast.
  error(t = "", n = {}) {
    return this.create({ message: t, type: "error", ...n });
  }
  // Warning toast.
  warning(t = "", n = {}) {
    return this.create({ message: t, type: "warning", ...n });
  }
  // Info toast
  info(t = "", n = {}) {
    return this.create({ message: t, type: "info", ...n });
  }
  // Custom toast.
  custom(t, n = {}) {
    return this.create({
      jsx: t,
      type: "custom",
      ...n
    });
  }
}
xr = new WeakMap(), Fi = new WeakMap();
const kn = new JX(), QX = (e, t) => kn.default(e, t), eke = Object.seal(
  Object.assign(
    QX,
    {
      success: kn.success.bind(kn),
      error: kn.error.bind(kn),
      warning: kn.warning.bind(kn),
      info: kn.info.bind(kn),
      custom: kn.custom.bind(kn),
      dismiss: kn.dismiss.bind(kn),
      update: kn.update.bind(kn)
    },
    {
      getHistory: kn.history.bind(kn)
    }
  )
);
let dC = !1;
const eZ = (e) => (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)((n) => {
  const r = n.singleTon;
  return dC && r ? null : (dC = !0, /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(e, { ...n }));
}), hC = {
  "top-left": "top-0 bottom-0 left-0 justify-start items-start",
  "top-right": "top-0 bottom-0 right-0 justify-start items-end",
  "bottom-left": "top-0 bottom-0 left-0 justify-end items-start",
  "bottom-right": "top-0 bottom-0 right-0 justify-end items-end"
}, pC = {
  stack: "w-[22.5rem]",
  inline: "lg:w-[47.5rem] w-full"
}, Dh = {
  light: {
    neutral: "border-alert-border-neutral bg-alert-background-neutral",
    custom: "border-alert-border-neutral bg-alert-background-neutral",
    info: "border-alert-border-info bg-alert-background-info",
    success: "border-alert-border-green bg-alert-background-green",
    warning: "border-alert-border-warning bg-alert-background-warning",
    error: "border-alert-border-danger bg-alert-background-danger"
  },
  dark: "bg-background-inverse border-background-inverse"
}, Ih = {
  light: "text-icon-secondary",
  dark: "text-icon-inverse"
}, tZ = ({
  position: e = "top-right",
  // top-right/top-left/bottom-right/bottom-left
  design: t = "stack",
  // stack/inline
  theme: n = "light",
  // light/dark
  className: r = "",
  autoDismiss: i = !0,
  // Auto dismiss the toast after a certain time.
  dismissAfter: o = 5e3
  // Time in milliseconds after which the toast will be dismissed.
}) => {
  const [a, s] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    kn.subscribe((c) => {
      if (c != null && c.dismiss) {
        s(
          (f) => f.map(
            (d) => d.id === c.id ? { ...d, dismiss: !0 } : d
          )
        );
        return;
      }
      setTimeout(() => {
        (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.flushSync)(
          () => s((f) => f.findIndex(
            (p) => p.id === c.id
          ) !== -1 ? f.map((p) => p.id === c.id ? { ...p, ...c } : p) : [...f, c])
        );
      });
    });
  }, []);
  const l = (c) => {
    s((f) => f.filter((d) => d.id !== c));
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "ul",
    {
      className: K(
        "fixed flex flex-col list-none z-20 p-10 pointer-events-none [&>li]:pointer-events-auto gap-3",
        hC[e] ?? hC["top-right"],
        r
      ),
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { initial: !1, children: a.map((c) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        An.li,
        {
          initial: { opacity: 0, y: 50, scale: 0.7 },
          animate: { opacity: 1, y: 0, scale: 1 },
          exit: {
            opacity: 0,
            scale: 0.6,
            transition: { duration: 0.15 }
          },
          layoutId: `toast-${c.id}`,
          children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            nZ,
            {
              toastItem: c,
              title: c.title,
              content: c == null ? void 0 : c.description,
              icon: (c == null ? void 0 : c.icon) ?? void 0,
              design: (c == null ? void 0 : c.design) ?? t,
              autoDismiss: (c == null ? void 0 : c.autoDismiss) ?? i,
              dismissAfter: (c == null ? void 0 : c.dismissAfter) ?? o,
              removeToast: l,
              variant: c.type,
              theme: (c == null ? void 0 : c.theme) ?? n
            }
          )
        },
        c.id
      )) })
    }
  );
}, nZ = ({
  toastItem: e,
  title: t = "",
  content: n = "",
  autoDismiss: r = !0,
  dismissAfter: i = 5e3,
  theme: o = "light",
  // light/dark
  design: a = "stack",
  // inline/stack
  icon: s,
  variant: l = "neutral",
  // neutral/info/success/warning/danger
  removeToast: c
  // Function to remove the toast.
}) => {
  var w, S, A, _, O, P, C;
  const f = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(0), d = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(0), p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(), m = (k, I = i) => {
    if (!(!r || i < 0))
      return f.current = (/* @__PURE__ */ new Date()).getTime(), setTimeout(() => {
        typeof c == "function" && c(k.id);
      }, I);
  }, y = () => {
    clearTimeout(p.current), d.current = (/* @__PURE__ */ new Date()).getTime();
  }, g = () => {
    p.current = m(
      e,
      i - (d.current - f.current)
    );
  };
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const k = i;
    return p.current = m(e, k), () => {
      clearTimeout(p.current);
    };
  }, []), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    !(e != null && e.dismiss) || typeof c != "function" || c(e.id);
  }, [e]);
  const v = () => {
    var k, I;
    typeof c == "function" && ((I = (k = e == null ? void 0 : e.action) == null ? void 0 : k.onClick) == null || I.call(k, () => c(e.id)));
  };
  let x = null;
  return a === "stack" && (x = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex items-center justify-start p-4 gap-2 relative border border-solid rounded-md shadow-lg",
        o === "dark" ? Dh.dark : (w = Dh.light) == null ? void 0 : w[l],
        pC.stack
      ),
      onMouseEnter: y,
      onMouseLeave: g,
      children: e.type !== "custom" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "self-start flex items-center justify-center [&_svg]:size-5 shrink-0", children: wp({ variant: l, icon: s, theme: o }) }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex flex-col items-start justify-start gap-0.5 mr-6", children: [
          _p({ title: t, theme: o }),
          Sp({ content: n, theme: o }),
          ((S = e == null ? void 0 : e.action) == null ? void 0 : S.label) && typeof ((A = e == null ? void 0 : e.action) == null ? void 0 : A.onClick) == "function" && /* eslint-disable */
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "mt-2.5", children: x0({
            actionLabel: (_ = e == null ? void 0 : e.action) == null ? void 0 : _.label,
            actionType: ((O = e == null ? void 0 : e.action) == null ? void 0 : O.type) ?? "button",
            onAction: v,
            theme: o
          }) })
        ] }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "absolute right-4 top-4 [&_svg]:size-5", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "button",
          {
            className: K(
              "bg-transparent m-0 p-0 border-none focus:outline-none active:outline-none cursor-pointer",
              Ih[o] ?? Ih.light
            ),
            onClick: () => {
              typeof c == "function" && c(e.id);
            },
            children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {})
          }
        ) })
      ] }) : (P = e == null ? void 0 : e.jsx) == null ? void 0 : P.call(e, {
        close: () => c(e.id),
        action: e != null && e.action ? { ...e == null ? void 0 : e.action, onClick: v } : null
      })
    }
  )), a === "inline" && (x = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        "flex items-center justify-start p-3 gap-2 relative border border-solid rounded-md shadow-lg",
        o === "dark" ? Dh.dark : (C = Dh.light) == null ? void 0 : C[l],
        pC.inline
      ),
      children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "self-start flex items-center justify-center [&_svg]:size-5 shrink-0", children: wp({ variant: l, icon: s, theme: o }) }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex items-start justify-start gap-1 mr-10 [&>span:first-child]:shrink-0", children: [
          _p({ title: t, theme: o }),
          Sp({ content: n, theme: o })
        ] }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "absolute right-3 top-3 [&_svg]:size-5", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "button",
          {
            className: K(
              "bg-transparent m-0 p-0 border-none focus:outline-none active:outline-none cursor-pointer",
              Ih[o] ?? Ih.light
            ),
            onClick: () => c(e.id),
            children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {})
          }
        ) })
      ]
    }
  )), x;
}, tke = eZ(tZ), rZ = {
  sm: {
    1: "grid-cols-1",
    2: "grid-cols-2",
    3: "grid-cols-3",
    4: "grid-cols-4",
    5: "grid-cols-5",
    6: "grid-cols-6",
    7: "grid-cols-7",
    8: "grid-cols-8",
    9: "grid-cols-9",
    10: "grid-cols-10",
    11: "grid-cols-11",
    12: "grid-cols-12"
  },
  md: {
    1: "md:grid-cols-1",
    2: "md:grid-cols-2",
    3: "md:grid-cols-3",
    4: "md:grid-cols-4",
    5: "md:grid-cols-5",
    6: "md:grid-cols-6",
    7: "md:grid-cols-7",
    8: "md:grid-cols-8",
    9: "md:grid-cols-9",
    10: "md:grid-cols-10",
    11: "md:grid-cols-11",
    12: "md:grid-cols-12"
  },
  lg: {
    1: "lg:grid-cols-1",
    2: "lg:grid-cols-2",
    3: "lg:grid-cols-3",
    4: "lg:grid-cols-4",
    5: "lg:grid-cols-5",
    6: "lg:grid-cols-6",
    7: "lg:grid-cols-7",
    8: "lg:grid-cols-8",
    9: "lg:grid-cols-9",
    10: "lg:grid-cols-10",
    11: "lg:grid-cols-11",
    12: "lg:grid-cols-12"
  }
}, SR = {
  sm: {
    xs: "gap-2",
    sm: "gap-4",
    md: "gap-5",
    lg: "gap-6",
    xl: "gap-6",
    "2xl": "gap-8"
  },
  md: {
    xs: "md:gap-2",
    sm: "md:gap-4",
    md: "md:gap-5",
    lg: "md:gap-6",
    xl: "md:gap-6",
    "2xl": "md:gap-8"
  },
  lg: {
    xs: "lg:gap-2",
    sm: "lg:gap-4",
    md: "lg:gap-5",
    lg: "lg:gap-6",
    xl: "lg:gap-6",
    "2xl": "lg:gap-8"
  }
}, OR = {
  sm: {
    xs: "gap-x-2",
    sm: "gap-x-4",
    md: "gap-x-5",
    lg: "gap-x-6",
    xl: "gap-x-6",
    "2xl": "gap-x-8"
  },
  md: {
    xs: "md:gap-x-2",
    sm: "md:gap-x-4",
    md: "md:gap-x-5",
    lg: "md:gap-x-6",
    xl: "md:gap-x-6",
    "2xl": "md:gap-x-8"
  },
  lg: {
    xs: "lg:gap-x-2",
    sm: "lg:gap-x-4",
    md: "lg:gap-x-5",
    lg: "lg:gap-x-6",
    xl: "lg:gap-x-6",
    "2xl": "lg:gap-x-8"
  }
}, AR = {
  sm: {
    xs: "gap-y-2",
    sm: "gap-y-4",
    md: "gap-y-5",
    lg: "gap-y-6",
    xl: "gap-y-6",
    "2xl": "gap-y-8"
  },
  md: {
    xs: "md:gap-y-2",
    sm: "md:gap-y-4",
    md: "md:gap-y-5",
    lg: "md:gap-y-6",
    xl: "md:gap-y-6",
    "2xl": "md:gap-y-8"
  },
  lg: {
    xs: "lg:gap-y-2",
    sm: "lg:gap-y-4",
    md: "lg:gap-y-5",
    lg: "lg:gap-y-6",
    xl: "lg:gap-y-6",
    "2xl": "lg:gap-y-8"
  }
}, iZ = {
  sm: {
    1: "col-span-1",
    2: "col-span-2",
    3: "col-span-3",
    4: "col-span-4",
    5: "col-span-5",
    6: "col-span-6",
    7: "col-span-7",
    8: "col-span-8",
    9: "col-span-9",
    10: "col-span-10",
    11: "col-span-11",
    12: "col-span-12"
  },
  md: {
    1: "md:col-span-1",
    2: "md:col-span-2",
    3: "md:col-span-3",
    4: "md:col-span-4",
    5: "md:col-span-5",
    6: "md:col-span-6",
    7: "md:col-span-7",
    8: "md:col-span-8",
    9: "md:col-span-9",
    10: "md:col-span-10",
    11: "md:col-span-11",
    12: "md:col-span-12"
  },
  lg: {
    1: "lg:col-span-1",
    2: "lg:col-span-2",
    3: "lg:col-span-3",
    4: "lg:col-span-4",
    5: "lg:col-span-5",
    6: "lg:col-span-6",
    7: "lg:col-span-7",
    8: "lg:col-span-8",
    9: "lg:col-span-9",
    10: "lg:col-span-10",
    11: "lg:col-span-11",
    12: "lg:col-span-12"
  }
}, oZ = {
  sm: {
    1: "col-start-1",
    2: "col-start-2",
    3: "col-start-3",
    4: "col-start-4",
    5: "col-start-5",
    6: "col-start-6",
    7: "col-start-7",
    8: "col-start-8",
    9: "col-start-9",
    10: "col-start-10",
    11: "col-start-11",
    12: "col-start-12"
  },
  md: {
    1: "md:col-start-1",
    2: "md:col-start-2",
    3: "md:col-start-3",
    4: "md:col-start-4",
    5: "md:col-start-5",
    6: "md:col-start-6",
    7: "md:col-start-7",
    8: "md:col-start-8",
    9: "md:col-start-9",
    10: "md:col-start-10",
    11: "md:col-start-11",
    12: "md:col-start-12"
  },
  lg: {
    1: "lg:col-start-1",
    2: "lg:col-start-2",
    3: "lg:col-start-3",
    4: "lg:col-start-4",
    5: "lg:col-start-5",
    6: "lg:col-start-6",
    7: "lg:col-start-7",
    8: "lg:col-start-8",
    9: "lg:col-start-9",
    10: "lg:col-start-10",
    11: "lg:col-start-11",
    12: "lg:col-start-12"
  }
}, aZ = {
  sm: {
    row: "grid-flow-row",
    column: "grid-flow-col",
    "row-dense": "grid-flow-row-dense",
    "column-dense": "grid-flow-col-dense"
  },
  md: {
    row: "md:grid-flow-row",
    column: "md:grid-flow-col",
    "row-dense": "md:grid-flow-row-dense",
    "column-dense": "md:grid-flow-col-dense"
  },
  lg: {
    row: "lg:grid-flow-row",
    column: "lg:grid-flow-col",
    "row-dense": "lg:grid-flow-row-dense",
    "column-dense": "lg:grid-flow-col-dense"
  }
}, TR = {
  sm: {
    normal: "justify-normal",
    start: "justify-start",
    end: "justify-end",
    center: "justify-center",
    between: "justify-between",
    around: "justify-around",
    evenly: "justify-evenly",
    stretch: "justify-stretch"
  },
  md: {
    normal: "md:justify-normal",
    start: "md:justify-start",
    end: "md:justify-end",
    center: "md:justify-center",
    between: "md:justify-between",
    around: "md:justify-around",
    evenly: "md:justify-evenly",
    stretch: "md:justify-stretch"
  },
  lg: {
    normal: "lg:justify-normal",
    start: "lg:justify-start",
    end: "lg:justify-end",
    center: "lg:justify-center",
    between: "lg:justify-between",
    around: "lg:justify-around",
    evenly: "lg:justify-evenly",
    stretch: "lg:justify-stretch"
  }
}, PR = {
  sm: {
    start: "items-start",
    end: "items-end",
    center: "items-center",
    baseline: "items-baseline",
    stretch: "items-stretch"
  },
  md: {
    start: "md:items-start",
    end: "md:items-end",
    center: "md:items-center",
    baseline: "md:items-baseline",
    stretch: "md:items-stretch"
  },
  lg: {
    start: "lg:items-start",
    end: "lg:items-end",
    center: "lg:items-center",
    baseline: "lg:items-baseline",
    stretch: "lg:items-stretch"
  }
}, CR = {
  sm: {
    start: "self-start",
    end: "self-end",
    center: "self-center",
    baseline: "self-baseline",
    stretch: "self-stretch"
  },
  md: {
    start: "md:self-start",
    end: "md:self-end",
    center: "md:self-center",
    baseline: "md:self-baseline",
    stretch: "md:self-stretch"
  },
  lg: {
    start: "lg:self-start",
    end: "lg:self-end",
    center: "lg:self-center",
    baseline: "lg:self-baseline",
    stretch: "lg:self-stretch"
  }
}, ER = {
  sm: {
    auto: "justify-self-auto",
    start: "justify-self-start",
    end: "justify-self-end",
    center: "justify-self-center",
    baseline: "justify-self-baseline",
    stretch: "justify-self-stretch"
  },
  md: {
    auto: "md:justify-self-auto",
    start: "md:justify-self-start",
    end: "md:justify-self-end",
    center: "md:justify-self-center",
    baseline: "md:justify-self-baseline",
    stretch: "md:justify-self-stretch"
  },
  lg: {
    auto: "lg:justify-self-auto",
    start: "lg:justify-self-start",
    end: "lg:justify-self-end",
    center: "lg:justify-self-center",
    baseline: "lg:justify-self-baseline",
    stretch: "lg:justify-self-stretch"
  }
}, sZ = {
  sm: {
    row: "flex-row",
    "row-reverse": "flex-row-reverse",
    column: "flex-col",
    "column-reverse": "flex-col-reverse"
  },
  md: {
    row: "md:flex-row",
    "row-reverse": "md:flex-row-reverse",
    column: "md:flex-col",
    "column-reverse": "md:flex-col-reverse"
  },
  lg: {
    row: "lg:flex-row",
    "row-reverse": "lg:flex-row-reverse",
    column: "lg:flex-col",
    "column-reverse": "lg:flex-col-reverse"
  }
}, lZ = {
  sm: {
    wrap: "flex-wrap",
    "wrap-reverse": "flex-wrap-reverse",
    nowrap: "flex-nowrap"
  },
  md: {
    wrap: "md:flex-wrap",
    "wrap-reverse": "md:flex-wrap-reverse",
    nowrap: "md:flex-nowrap"
  },
  lg: {
    wrap: "lg:flex-wrap",
    "wrap-reverse": "lg:flex-wrap-reverse",
    nowrap: "lg:flex-nowrap"
  }
}, cZ = {
  sm: {
    1: "w-full",
    2: "w-1/2",
    3: "w-1/3",
    4: "w-1/4",
    5: "w-1/5",
    6: "w-1/6",
    7: "w-1/7",
    8: "w-1/8",
    9: "w-1/9",
    10: "w-1/10",
    11: "w-1/11",
    12: "w-1/12"
  },
  md: {
    1: "md:w-full",
    2: "md:w-1/2",
    3: "md:w-1/3",
    4: "md:w-1/4",
    5: "md:w-1/5",
    6: "md:w-1/6",
    7: "md:w-1/7",
    8: "md:w-1/8",
    9: "md:w-1/9",
    10: "md:w-1/10",
    11: "md:w-1/11",
    12: "md:w-1/12"
  },
  lg: {
    1: "lg:w-full",
    2: "lg:w-1/2",
    3: "lg:w-1/3",
    4: "lg:w-1/4",
    5: "lg:w-1/5",
    6: "lg:w-1/6",
    7: "lg:w-1/7",
    8: "lg:w-1/8",
    9: "lg:w-1/9",
    10: "lg:w-1/10",
    11: "lg:w-1/11",
    12: "lg:w-1/12"
  }
}, uZ = {
  sm: {
    1: "order-1",
    2: "order-2",
    3: "order-3",
    4: "order-4",
    5: "order-5",
    6: "order-6",
    7: "order-7",
    8: "order-8",
    9: "order-9",
    10: "order-10",
    11: "order-11",
    12: "order-12",
    first: "order-first",
    last: "order-last",
    none: "order-none"
  },
  md: {
    1: "md:order-1",
    2: "md:order-2",
    3: "md:order-3",
    4: "md:order-4",
    5: "md:order-5",
    6: "md:order-6",
    7: "md:order-7",
    8: "md:order-8",
    9: "md:order-9",
    10: "md:order-10",
    11: "md:order-11",
    12: "md:order-12",
    first: "md:order-first",
    last: "md:order-last",
    none: "md:order-none"
  },
  lg: {
    1: "lg:order-1",
    2: "lg:order-2",
    3: "lg:order-3",
    4: "lg:order-4",
    5: "lg:order-5",
    6: "lg:order-6",
    7: "lg:order-7",
    8: "lg:order-8",
    9: "lg:order-9",
    10: "lg:order-10",
    11: "lg:order-11",
    12: "lg:order-12",
    first: "lg:order-first",
    last: "lg:order-last",
    none: "lg:order-none"
  }
}, fZ = {
  sm: {
    0: "grow-0",
    1: "grow"
  },
  md: {
    0: "md:grow-0",
    1: "md:grow"
  },
  lg: {
    0: "lg:grow-0",
    1: "lg:grow"
  }
}, dZ = {
  sm: {
    0: "shrink-0",
    1: "shrink"
  },
  md: {
    0: "md:shrink-0",
    1: "md:shrink"
  },
  lg: {
    0: "lg:shrink-0",
    1: "lg:shrink"
  }
}, qt = (e, t, n, r = "sm") => {
  var o, a, s, l, c;
  const i = [];
  switch (typeof e) {
    case "object":
      for (const [d, p] of Object.entries(e))
        t[d] && i.push(
          ((o = t == null ? void 0 : t[d]) == null ? void 0 : o[p]) ?? ((a = t == null ? void 0 : t[d]) == null ? void 0 : a[n == null ? void 0 : n[d]]) ?? ""
        );
      break;
    case "string":
    case "number":
      const f = r;
      i.push(
        ((s = t == null ? void 0 : t[f]) == null ? void 0 : s[e]) ?? ((l = t == null ? void 0 : t[f]) == null ? void 0 : l[n == null ? void 0 : n[f]]) ?? ""
      );
      break;
    default:
      if (e === void 0)
        break;
      i.push(
        ((c = t == null ? void 0 : t[r]) == null ? void 0 : c[n]) ?? ""
      );
      break;
  }
  return i.join(" ");
}, Mp = ({
  className: e,
  cols: t,
  gap: n,
  gapX: r,
  gapY: i,
  align: o,
  justify: a,
  gridFlow: s,
  colsSubGrid: l = !1,
  rowsSubGrid: c = !1,
  autoRows: f = !1,
  autoCols: d = !1,
  children: p,
  ...m
}) => {
  const y = qt(t, rZ, 1), g = qt(n, SR, "sm"), v = qt(r, OR, ""), x = qt(i, AR, ""), w = qt(o, PR, ""), S = qt(a, TR, ""), A = qt(s, aZ, "");
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "grid",
        {
          "grid-cols-subgrid": l,
          "grid-rows-subgrid": c,
          "auto-cols-auto": d,
          "auto-rows-auto": f
        },
        y,
        g,
        v,
        x,
        w,
        S,
        A,
        e
      ),
      ...m,
      children: p
    }
  );
}, hZ = ({
  className: e,
  children: t,
  colSpan: n,
  colStart: r,
  alignSelf: i,
  justifySelf: o,
  ...a
}) => {
  const s = qt(n, iZ, 0), l = qt(
    r,
    oZ,
    0
  ), c = qt(
    i,
    CR,
    ""
  ), f = qt(
    o,
    ER,
    ""
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        s,
        l,
        c,
        f,
        e
      ),
      ...a,
      children: t
    }
  );
};
Mp.Item = hZ;
const L0 = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), pZ = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(L0), kR = ({
  containerType: e = "flex",
  // flex, (grid - functionality not implemented)
  gap: t = "sm",
  // xs, sm, md, lg, xl, 2xl
  gapX: n,
  gapY: r,
  direction: i,
  // row, row-reverse, column, column reverse
  justify: o,
  // justify-content (normal, start, end, center, between, around, evenly, stretch)
  align: a,
  // align-items (start, end, center, baseline, stretch)
  wrap: s,
  // nowrap, wrap, wrap-reverse
  cols: l,
  className: c,
  children: f,
  ...d
}) => {
  if (e === "grid")
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      L0.Provider,
      {
        value: {
          containerType: e
        },
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          Mp,
          {
            className: c,
            gap: t,
            gapX: n,
            gapY: r,
            cols: l,
            children: f,
            align: a,
            justify: o,
            ...d
          }
        )
      }
    );
  const p = qt(s, lZ, ""), m = qt(t, SR, "sm"), y = qt(n, OR, ""), g = qt(r, AR, ""), v = qt(
    i,
    sZ,
    ""
  ), x = qt(
    o,
    TR,
    ""
  ), w = qt(a, PR, ""), S = K(
    "flex",
    p,
    m,
    y,
    g,
    v,
    x,
    w,
    c
  ), A = () => e === "flex" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: S, children: f }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    Mp,
    {
      className: c,
      gap: t,
      gapX: n,
      gapY: r,
      cols: l,
      children: f,
      align: a,
      justify: o,
      ...d
    }
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    L0.Provider,
    {
      value: {
        containerType: e,
        cols: l
      },
      children: A()
    }
  );
}, MR = ({
  grow: e,
  shrink: t,
  order: n,
  alignSelf: r,
  justifySelf: i,
  className: o,
  children: a,
  ...s
}) => {
  const { containerType: l, cols: c } = pZ();
  if (l === "grid")
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      Mp.Item,
      {
        className: o,
        alignSelf: r,
        justifySelf: i,
        children: a,
        ...s
      }
    );
  const f = qt(
    r,
    CR,
    ""
  ), d = qt(
    i,
    ER,
    ""
  ), p = qt(e, fZ, 0), m = qt(t, dZ, 0), y = qt(n, uZ, 0), g = qt(c, cZ, 1);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "box-border",
        p,
        m,
        y,
        f,
        d,
        g,
        o
      ),
      children: a
    }
  );
};
kR.Item = MR;
kR.displayName = "Container";
MR.displayName = "Container.Item";
const nke = ({
  design: e = "inline",
  // stack/inline
  theme: t = "light",
  // light/dark
  variant: n = "neutral",
  className: r = "",
  title: i = "",
  content: o = "",
  icon: a = null,
  onClose: s,
  action: l = {
    label: "",
    onClick: () => {
    },
    type: "link"
  }
}) => {
  var m, y;
  const c = () => {
    typeof s == "function" && s();
  }, f = {
    light: {
      neutral: "ring-alert-border-neutral bg-alert-background-neutral",
      custom: "ring-alert-border-neutral bg-alert-background-neutral",
      info: "ring-alert-border-info bg-alert-background-info",
      success: "ring-alert-border-green bg-alert-background-green",
      warning: "ring-alert-border-warning bg-alert-background-warning",
      error: "ring-alert-border-danger bg-alert-background-danger"
    },
    dark: "bg-background-inverse ring-background-inverse"
  }, d = {
    light: "text-icon-secondary",
    dark: "text-icon-inverse"
  }, p = () => {
    var g;
    (g = l == null ? void 0 : l.onClick) == null || g.call(l, c);
  };
  return e === "stack" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex items-center justify-start p-4 gap-2 relative ring-1 rounded-md shadow-lg",
        t === "dark" ? f.dark : (m = f.light) == null ? void 0 : m[n],
        r
      ),
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "self-start flex items-center justify-center [&_svg]:size-5 shrink-0", children: wp({ variant: n, icon: a, theme: t }) }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex flex-col items-start justify-start gap-0.5 mr-7", children: [
          _p({ title: i, theme: t }),
          Sp({ content: o, theme: t }),
          (l == null ? void 0 : l.label) && typeof (l == null ? void 0 : l.onClick) == "function" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "mt-2.5", children: x0({
            actionLabel: l == null ? void 0 : l.label,
            actionType: (l == null ? void 0 : l.type) ?? "button",
            onAction: p,
            theme: t
          }) })
        ] }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "absolute right-4 top-4 [&_svg]:size-5", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "button",
          {
            className: K(
              "bg-transparent m-0 p-0 border-none focus:outline-none active:outline-none cursor-pointer",
              d[t] ?? d.light
            ),
            onClick: () => c(),
            "aria-label": "Close alert",
            children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {})
          }
        ) })
      ] })
    }
  ) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        "flex items-center justify-between p-3 gap-2 relative ring-1 rounded-lg shadow-lg",
        t === "dark" ? f.dark : (y = f.light) == null ? void 0 : y[n],
        r
      ),
      children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex items-center justify-start gap-2", children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "self-start flex items-center justify-center [&_svg]:size-5 shrink-0", children: wp({ variant: n, icon: a, theme: t }) }),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", { className: "content-start space-x-1 my-0 mr-10 px-1", children: [
            _p({ title: i, theme: t, inline: !0 }),
            Sp({ content: o, theme: t, inline: !0 })
          ] })
        ] }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "flex h-full justify-start gap-4 [&_svg]:size-4", children: [
          (l == null ? void 0 : l.label) && typeof (l == null ? void 0 : l.onClick) == "function" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "self-center flex h-5", children: x0({
            actionLabel: l == null ? void 0 : l.label,
            actionType: (l == null ? void 0 : l.type) ?? "button",
            onAction: p,
            theme: t
          }) }),
          typeof s == "function" && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "button",
            {
              className: K(
                "self-start bg-transparent m-0 border-none p-0.5 focus:outline-none active:outline-none cursor-pointer size-5",
                d[t] ?? d.light
              ),
              onClick: () => c(),
              "aria-label": "Close alert",
              children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, {})
            }
          )
        ] })
      ]
    }
  );
};
function mZ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
var gZ = mZ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
const NR = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null);
function yZ(e, t) {
  return { getTheme: function() {
    return t ?? null;
  } };
}
function Gr() {
  const e = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(NR);
  return e == null && gZ(8), e;
}
function vZ({ defaultSelection: e }) {
  const [t] = Gr();
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    t.focus(() => {
      const n = document.activeElement, r = t.getRootElement();
      r === null || n !== null && r.contains(n) || r.focus({ preventScroll: !0 });
    }, { defaultSelection: e });
  }, [e, t]), null;
}
function bZ(e) {
  return {};
}
const G1 = {}, xZ = {}, ks = {}, Hl = {}, B0 = {}, Kl = {}, Y1 = {}, F0 = {}, bf = {}, xf = {}, _s = {}, q1 = {}, X1 = {}, $R = {}, Z1 = {}, wZ = {}, J1 = {}, _Z = {}, DR = {}, IR = {}, wf = {}, SZ = {}, Q1 = {}, RR = {}, jR = {}, LR = {}, BR = {}, FR = {}, OZ = {}, AZ = {}, e_ = {}, t_ = {}, W0 = {}, TZ = {}, PZ = {}, Rh = {}, jh = {}, CZ = {}, EZ = {}, kZ = {}, Di = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0, MZ = Di && "documentMode" in document ? document.documentMode : null, _i = Di && /Mac|iPod|iPhone|iPad/.test(navigator.platform), Ma = Di && /^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent), Np = !(!Di || !("InputEvent" in window) || MZ) && "getTargetRanges" in new window.InputEvent("input"), n_ = Di && /Version\/[\d.]+.*Safari/.test(navigator.userAgent), Ag = Di && /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream, NZ = Di && /Android/.test(navigator.userAgent), WR = Di && /^(?=.*Chrome).*/i.test(navigator.userAgent), $Z = Di && NZ && WR, r_ = Di && /AppleWebKit\/[\d.]+/.test(navigator.userAgent) && !WR, md = 1, Ua = 3, Ls = 0, zR = 1, nc = 2, DZ = 0, IZ = 1, RZ = 2, $p = 4, Dp = 8, i_ = 128, jZ = 112 | (3 | $p | Dp) | i_, o_ = 1, a_ = 2, s_ = 3, l_ = 4, c_ = 5, u_ = 6, Tg = n_ || Ag || r_ ? " " : "​", zo = `

`, LZ = Ma ? " " : Tg, VR = "֑-߿יִ-﷽ﹰ-ﻼ", UR = "A-Za-zÀ-ÖØ-öø-ʸ̀-֐ࠀ-῿‎Ⰰ-﬜︀-﹯﻽-￿", BZ = new RegExp("^[^" + UR + "]*[" + VR + "]"), FZ = new RegExp("^[^" + VR + "]*[" + UR + "]"), Io = { bold: 1, code: 16, highlight: i_, italic: 2, strikethrough: $p, subscript: 32, superscript: 64, underline: Dp }, WZ = { directionless: 1, unmergeable: 2 }, mC = { center: a_, end: u_, justify: l_, left: o_, right: s_, start: c_ }, zZ = { [a_]: "center", [u_]: "end", [l_]: "justify", [o_]: "left", [s_]: "right", [c_]: "start" }, VZ = { normal: 0, segmented: 2, token: 1 }, UZ = { [DZ]: "normal", [RZ]: "segmented", [IZ]: "token" };
function HZ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
var _e = HZ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
function Ip(...e) {
  const t = [];
  for (const n of e) if (n && typeof n == "string") for (const [r] of n.matchAll(/\S+/g)) t.push(r);
  return t;
}
const KZ = 100;
let z0 = !1, f_ = 0;
function GZ(e) {
  f_ = e.timeStamp;
}
function hb(e, t, n) {
  return t.__lexicalLineBreak === e || e[`__lexicalKey_${n._key}`] !== void 0;
}
function YZ(e, t, n) {
  const r = no(n._window);
  let i = null, o = null;
  r !== null && r.anchorNode === e && (i = r.anchorOffset, o = r.focusOffset);
  const a = e.nodeValue;
  a !== null && m_(t, a, i, o, !1);
}
function qZ(e, t, n) {
  if (we(e)) {
    const r = e.anchor.getNode();
    if (r.is(n) && e.format !== r.getFormat()) return !1;
  }
  return t.nodeType === Ua && n.isAttached();
}
function HR(e, t, n) {
  z0 = !0;
  const r = performance.now() - f_ > KZ;
  try {
    Fr(e, () => {
      const i = Ne() || function(p) {
        return p.getEditorState().read(() => {
          const m = Ne();
          return m !== null ? m.clone() : null;
        });
      }(e), o = /* @__PURE__ */ new Map(), a = e.getRootElement(), s = e._editorState, l = e._blockCursorElement;
      let c = !1, f = "";
      for (let p = 0; p < t.length; p++) {
        const m = t[p], y = m.type, g = m.target;
        let v = Eg(g, s);
        if (!(v === null && g !== a || Ht(v))) {
          if (y === "characterData") r && Se(v) && qZ(i, g, v) && YZ(g, v, e);
          else if (y === "childList") {
            c = !0;
            const x = m.addedNodes;
            for (let A = 0; A < x.length; A++) {
              const _ = x[A], O = XR(_), P = _.parentNode;
              if (P != null && _ !== l && O === null && (_.nodeName !== "BR" || !hb(_, P, e))) {
                if (Ma) {
                  const C = _.innerText || _.nodeValue;
                  C && (f += C);
                }
                P.removeChild(_);
              }
            }
            const w = m.removedNodes, S = w.length;
            if (S > 0) {
              let A = 0;
              for (let _ = 0; _ < S; _++) {
                const O = w[_];
                (O.nodeName === "BR" && hb(O, g, e) || l === O) && (g.appendChild(O), A++);
              }
              S !== A && (g === a && (v = JR(s)), o.set(g, v));
            }
          }
        }
      }
      if (o.size > 0) for (const [p, m] of o) if (ve(m)) {
        const y = m.getChildrenKeys();
        let g = p.firstChild;
        for (let v = 0; v < y.length; v++) {
          const x = y[v], w = e.getElementByKey(x);
          w !== null && (g == null ? (p.appendChild(w), g = w) : g !== w && p.replaceChild(w, g), g = g.nextSibling);
        }
      } else Se(m) && m.markDirty();
      const d = n.takeRecords();
      if (d.length > 0) {
        for (let p = 0; p < d.length; p++) {
          const m = d[p], y = m.addedNodes, g = m.target;
          for (let v = 0; v < y.length; v++) {
            const x = y[v], w = x.parentNode;
            w == null || x.nodeName !== "BR" || hb(x, g, e) || w.removeChild(x);
          }
        }
        n.takeRecords();
      }
      i !== null && (c && (i.dirty = !0, Vo(i)), Ma && n2(e) && i.insertRawText(f));
    });
  } finally {
    z0 = !1;
  }
}
function KR(e) {
  const t = e._observer;
  t !== null && HR(e, t.takeRecords(), t);
}
function GR(e) {
  (function(t) {
    f_ === 0 && Ng(t).addEventListener("textInput", GZ, !0);
  })(e), e._observer = new MutationObserver((t, n) => {
    HR(e, t, n);
  });
}
function gC(e, t) {
  const n = e.__mode, r = e.__format, i = e.__style, o = t.__mode, a = t.__format, s = t.__style;
  return !(n !== null && n !== o || r !== null && r !== a || i !== null && i !== s);
}
function yC(e, t) {
  const n = e.mergeWithSibling(t), r = mn()._normalizedNodes;
  return r.add(e.__key), r.add(t.__key), n;
}
function vC(e) {
  let t, n, r = e;
  if (r.__text !== "" || !r.isSimpleText() || r.isUnmergeable()) {
    for (; (t = r.getPreviousSibling()) !== null && Se(t) && t.isSimpleText() && !t.isUnmergeable(); ) {
      if (t.__text !== "") {
        if (gC(t, r)) {
          r = yC(t, r);
          break;
        }
        break;
      }
      t.remove();
    }
    for (; (n = r.getNextSibling()) !== null && Se(n) && n.isSimpleText() && !n.isUnmergeable(); ) {
      if (n.__text !== "") {
        if (gC(r, n)) {
          r = yC(r, n);
          break;
        }
        break;
      }
      n.remove();
    }
  } else r.remove();
}
function XZ(e) {
  return bC(e.anchor), bC(e.focus), e;
}
function bC(e) {
  for (; e.type === "element"; ) {
    const t = e.getNode(), n = e.offset;
    let r, i;
    if (n === t.getChildrenSize() ? (r = t.getChildAtIndex(n - 1), i = !0) : (r = t.getChildAtIndex(n), i = !1), Se(r)) {
      e.set(r.__key, i ? r.getTextContentSize() : 0, "text");
      break;
    }
    if (!ve(r)) break;
    e.set(r.__key, i ? r.getChildrenSize() : 0, "element");
  }
}
let ZZ = 1;
const JZ = typeof queueMicrotask == "function" ? queueMicrotask : (e) => {
  Promise.resolve().then(e);
};
function YR(e) {
  const t = document.activeElement;
  if (t === null) return !1;
  const n = t.nodeName;
  return Ht(Eg(e)) && (n === "INPUT" || n === "TEXTAREA" || t.contentEditable === "true" && Cg(t) == null);
}
function Pg(e, t, n) {
  const r = e.getRootElement();
  try {
    return r !== null && r.contains(t) && r.contains(n) && t !== null && !YR(t) && qR(t) === e;
  } catch {
    return !1;
  }
}
function d_(e) {
  return e instanceof Fg;
}
function qR(e) {
  let t = e;
  for (; t != null; ) {
    const n = Cg(t);
    if (d_(n)) return n;
    t = Mg(t);
  }
  return null;
}
function Cg(e) {
  return e ? e.__lexicalEditor : null;
}
function Pl(e) {
  return e.isToken() || e.isSegmented();
}
function QZ(e) {
  return e.nodeType === Ua;
}
function Rp(e) {
  let t = e;
  for (; t != null; ) {
    if (QZ(t)) return t;
    t = t.firstChild;
  }
  return null;
}
function V0(e, t, n) {
  const r = Io[t];
  if (n !== null && (e & r) == (n & r)) return e;
  let i = e ^ r;
  return t === "subscript" ? i &= ~Io.superscript : t === "superscript" && (i &= ~Io.subscript), i;
}
function eJ(e, t) {
  if (t != null) return void (e.__key = t);
  wr(), A2();
  const n = mn(), r = qo(), i = "" + ZZ++;
  r._nodeMap.set(i, e), ve(e) ? n._dirtyElements.set(i, !0) : n._dirtyLeaves.add(i), n._cloneNotNeeded.add(i), n._dirtyType = zR, e.__key = i;
}
function Ms(e) {
  const t = e.getParent();
  if (t !== null) {
    const n = e.getWritable(), r = t.getWritable(), i = e.getPreviousSibling(), o = e.getNextSibling();
    if (i === null) if (o !== null) {
      const a = o.getWritable();
      r.__first = o.__key, a.__prev = null;
    } else r.__first = null;
    else {
      const a = i.getWritable();
      if (o !== null) {
        const s = o.getWritable();
        s.__prev = a.__key, a.__next = s.__key;
      } else a.__next = null;
      n.__prev = null;
    }
    if (o === null) if (i !== null) {
      const a = i.getWritable();
      r.__last = i.__key, a.__next = null;
    } else r.__last = null;
    else {
      const a = o.getWritable();
      if (i !== null) {
        const s = i.getWritable();
        s.__next = a.__key, a.__prev = s.__key;
      } else a.__prev = null;
      n.__next = null;
    }
    r.__size--, n.__parent = null;
  }
}
function jp(e) {
  A2();
  const t = e.getLatest(), n = t.__parent, r = qo(), i = mn(), o = r._nodeMap, a = i._dirtyElements;
  n !== null && function(l, c, f) {
    let d = l;
    for (; d !== null; ) {
      if (f.has(d)) return;
      const p = c.get(d);
      if (p === void 0) break;
      f.set(d, !1), d = p.__parent;
    }
  }(n, o, a);
  const s = t.__key;
  i._dirtyType = zR, ve(e) ? a.set(s, !0) : i._dirtyLeaves.add(s);
}
function Gn(e) {
  wr();
  const t = mn(), n = t._compositionKey;
  if (e !== n) {
    if (t._compositionKey = e, n !== null) {
      const r = $n(n);
      r !== null && r.getWritable();
    }
    if (e !== null) {
      const r = $n(e);
      r !== null && r.getWritable();
    }
  }
}
function Oa() {
  return bd() ? null : mn()._compositionKey;
}
function $n(e, t) {
  const n = (t || qo())._nodeMap.get(e);
  return n === void 0 ? null : n;
}
function XR(e, t) {
  const n = e[`__lexicalKey_${mn()._key}`];
  return n !== void 0 ? $n(n, t) : null;
}
function Eg(e, t) {
  let n = e;
  for (; n != null; ) {
    const r = XR(n, t);
    if (r !== null) return r;
    n = Mg(n);
  }
  return null;
}
function ZR(e) {
  const t = e._decorators, n = Object.assign({}, t);
  return e._pendingDecorators = n, n;
}
function xC(e) {
  return e.read(() => ir().getTextContent());
}
function ir() {
  return JR(qo());
}
function JR(e) {
  return e._nodeMap.get("root");
}
function Vo(e) {
  wr();
  const t = qo();
  e !== null && (e.dirty = !0, e.setCachedNodes(null)), t._selection = e;
}
function jl(e) {
  const t = mn(), n = function(r, i) {
    let o = r;
    for (; o != null; ) {
      const a = o[`__lexicalKey_${i._key}`];
      if (a !== void 0) return a;
      o = Mg(o);
    }
    return null;
  }(e, t);
  return n === null ? e === t.getRootElement() ? $n("root") : null : $n(n);
}
function wC(e, t) {
  return t ? e.getTextContentSize() : 0;
}
function QR(e) {
  return /[\uD800-\uDBFF][\uDC00-\uDFFF]/g.test(e);
}
function h_(e) {
  const t = [];
  let n = e;
  for (; n !== null; ) t.push(n), n = n._parentEditor;
  return t;
}
function e2() {
  return Math.random().toString(36).replace(/[^a-z]+/g, "").substr(0, 5);
}
function t2(e) {
  return e.nodeType === Ua ? e.nodeValue : null;
}
function p_(e, t, n) {
  const r = no(t._window);
  if (r === null) return;
  const i = r.anchorNode;
  let { anchorOffset: o, focusOffset: a } = r;
  if (i !== null) {
    let s = t2(i);
    const l = Eg(i);
    if (s !== null && Se(l)) {
      if (s === Tg && n) {
        const c = n.length;
        s = n, o = c, a = c;
      }
      s !== null && m_(l, s, o, a, e);
    }
  }
}
function m_(e, t, n, r, i) {
  let o = e;
  if (o.isAttached() && (i || !o.isDirty())) {
    const a = o.isComposing();
    let s = t;
    (a || i) && t[t.length - 1] === Tg && (s = t.slice(0, -1));
    const l = o.getTextContent();
    if (i || s !== l) {
      if (s === "") {
        if (Gn(null), n_ || Ag || r_) o.remove();
        else {
          const g = mn();
          setTimeout(() => {
            g.update(() => {
              o.isAttached() && o.remove();
            });
          }, 20);
        }
        return;
      }
      const c = o.getParent(), f = jg(), d = o.getTextContentSize(), p = Oa(), m = o.getKey();
      if (o.isToken() || p !== null && m === p && !a || we(f) && (c !== null && !c.canInsertTextBefore() && f.anchor.offset === 0 || f.anchor.key === e.__key && f.anchor.offset === 0 && !o.canInsertTextBefore() && !a || f.focus.key === e.__key && f.focus.offset === d && !o.canInsertTextAfter() && !a)) return void o.markDirty();
      const y = Ne();
      if (!we(y) || n === null || r === null) return void o.setTextContent(s);
      if (y.setTextNodeRange(o, n, o, r), o.isSegmented()) {
        const g = Vn(o.getTextContent());
        o.replace(g), o = g;
      }
      o.setTextContent(s);
    }
  }
}
function tJ(e, t) {
  if (t.isSegmented()) return !0;
  if (!e.isCollapsed()) return !1;
  const n = e.anchor.offset, r = t.getParentOrThrow(), i = t.isToken();
  return n === 0 ? !t.canInsertTextBefore() || !r.canInsertTextBefore() && !t.isComposing() || i || function(o) {
    const a = o.getPreviousSibling();
    return (Se(a) || ve(a) && a.isInline()) && !a.canInsertTextAfter();
  }(t) : n === t.getTextContentSize() && (!t.canInsertTextAfter() || !r.canInsertTextAfter() && !t.isComposing() || i);
}
function _C(e) {
  return e === "ArrowLeft";
}
function SC(e) {
  return e === "ArrowRight";
}
function Fu(e, t) {
  return _i ? e : t;
}
function OC(e) {
  return e === "Enter";
}
function _u(e) {
  return e === "Backspace";
}
function Su(e) {
  return e === "Delete";
}
function AC(e, t, n) {
  return e.toLowerCase() === "a" && Fu(t, n);
}
function nJ() {
  const e = ir();
  Vo(XZ(e.select(0, e.getChildrenSize())));
}
function qu(e, t) {
  e.__lexicalClassNameCache === void 0 && (e.__lexicalClassNameCache = {});
  const n = e.__lexicalClassNameCache, r = n[t];
  if (r !== void 0) return r;
  const i = e[t];
  if (typeof i == "string") {
    const o = Ip(i);
    return n[t] = o, o;
  }
  return i;
}
function g_(e, t, n, r, i) {
  if (n.size === 0) return;
  const o = r.__type, a = r.__key, s = t.get(o);
  s === void 0 && _e(33, o);
  const l = s.klass;
  let c = e.get(l);
  c === void 0 && (c = /* @__PURE__ */ new Map(), e.set(l, c));
  const f = c.get(a), d = f === "destroyed" && i === "created";
  (f === void 0 || d) && c.set(a, d ? "updated" : i);
}
function TC(e, t, n) {
  const r = e.getParent();
  let i = n, o = e;
  return r !== null && (t && n === 0 ? (i = o.getIndexWithinParent(), o = r) : t || n !== o.getChildrenSize() || (i = o.getIndexWithinParent() + 1, o = r)), o.getChildAtIndex(t ? i - 1 : i);
}
function U0(e, t) {
  const n = e.offset;
  if (e.type === "element")
    return TC(e.getNode(), t, n);
  {
    const r = e.getNode();
    if (t && n === 0 || !t && n === r.getTextContentSize()) {
      const i = t ? r.getPreviousSibling() : r.getNextSibling();
      return i === null ? TC(r.getParentOrThrow(), t, r.getIndexWithinParent() + (t ? 0 : 1)) : i;
    }
  }
  return null;
}
function n2(e) {
  const t = Ng(e).event, n = t && t.inputType;
  return n === "insertFromPaste" || n === "insertFromPasteAsQuotation";
}
function Ae(e, t, n) {
  return C2(e, t, n);
}
function kg(e) {
  return !ur(e) && !e.isLastChild() && !e.isInline();
}
function Lp(e, t) {
  const n = e._keyToDOMMap.get(t);
  return n === void 0 && _e(75, t), n;
}
function Mg(e) {
  const t = e.assignedSlot || e.parentElement;
  return t !== null && t.nodeType === 11 ? t.host : t;
}
function H0(e, t) {
  let n = e.getParent();
  for (; n !== null; ) {
    if (n.is(t)) return !0;
    n = n.getParent();
  }
  return !1;
}
function Ng(e) {
  const t = e._window;
  return t === null && _e(78), t;
}
function rJ(e) {
  let t = e.getParentOrThrow();
  for (; t !== null; ) {
    if (gd(t)) return t;
    t = t.getParentOrThrow();
  }
  return t;
}
function gd(e) {
  return ur(e) || ve(e) && e.isShadowRoot();
}
function $g(e) {
  const t = mn(), n = e.constructor.getType(), r = t._nodes.get(n);
  r === void 0 && _e(97);
  const i = r.replace;
  if (i !== null) {
    const o = i(e);
    return o instanceof e.constructor || _e(98), o;
  }
  return e;
}
function pb(e, t) {
  !ur(e.getParent()) || ve(t) || Ht(t) || _e(99);
}
function mb(e) {
  return (Ht(e) || ve(e) && !e.canBeEmpty()) && !e.isInline();
}
function y_(e, t, n) {
  n.style.removeProperty("caret-color"), t._blockCursorElement = null;
  const r = e.parentElement;
  r !== null && r.removeChild(e);
}
function iJ(e, t, n) {
  let r = e._blockCursorElement;
  if (we(n) && n.isCollapsed() && n.anchor.type === "element" && t.contains(document.activeElement)) {
    const i = n.anchor, o = i.getNode(), a = i.offset;
    let s = !1, l = null;
    if (a === o.getChildrenSize())
      mb(o.getChildAtIndex(a - 1)) && (s = !0);
    else {
      const c = o.getChildAtIndex(a);
      if (mb(c)) {
        const f = c.getPreviousSibling();
        (f === null || mb(f)) && (s = !0, l = e.getElementByKey(c.__key));
      }
    }
    if (s) {
      const c = e.getElementByKey(o.__key);
      return r === null && (e._blockCursorElement = r = function(f) {
        const d = f.theme, p = document.createElement("div");
        p.contentEditable = "false", p.setAttribute("data-lexical-cursor", "true");
        let m = d.blockCursor;
        if (m !== void 0) {
          if (typeof m == "string") {
            const y = Ip(m);
            m = d.blockCursor = y;
          }
          m !== void 0 && p.classList.add(...m);
        }
        return p;
      }(e._config)), t.style.caretColor = "transparent", void (l === null ? c.appendChild(r) : c.insertBefore(r, l));
    }
  }
  r !== null && y_(r, e, t);
}
function no(e) {
  return Di ? (e || window).getSelection() : null;
}
function v_(e) {
  return e.nodeType === 1;
}
function oJ(e) {
  const t = new RegExp(/^(a|abbr|acronym|b|cite|code|del|em|i|ins|kbd|label|output|q|ruby|s|samp|span|strong|sub|sup|time|u|tt|var|#text)$/, "i");
  return e.nodeName.match(t) !== null;
}
function PC(e) {
  const t = new RegExp(/^(address|article|aside|blockquote|canvas|dd|div|dl|dt|fieldset|figcaption|figure|footer|form|h1|h2|h3|h4|h5|h6|header|hr|li|main|nav|noscript|ol|p|pre|section|table|td|tfoot|ul|video)$/, "i");
  return e.nodeName.match(t) !== null;
}
function Cl(e) {
  if (ur(e) || Ht(e) && !e.isInline()) return !0;
  if (!ve(e) || gd(e)) return !1;
  const t = e.getFirstChild(), n = t === null || Ju(t) || Se(t) || t.isInline();
  return !e.isInline() && e.canBeEmpty() !== !1 && n;
}
function gb(e, t) {
  let n = e;
  for (; n !== null && n.getParent() !== null && !t(n); ) n = n.getParentOrThrow();
  return t(n) ? n : null;
}
const CC = /* @__PURE__ */ new WeakMap(), aJ = /* @__PURE__ */ new Map();
function sJ(e) {
  if (!e._readOnly && e.isEmpty()) return aJ;
  e._readOnly || _e(192);
  let t = CC.get(e);
  if (!t) {
    t = /* @__PURE__ */ new Map(), CC.set(e, t);
    for (const [n, r] of e._nodeMap) {
      const i = r.__type;
      let o = t.get(i);
      o || (o = /* @__PURE__ */ new Map(), t.set(i, o)), o.set(n, r);
    }
  }
  return t;
}
function r2(e) {
  const t = e.constructor.clone(e);
  return t.afterCloneFrom(e), t;
}
function i2(e, t, n, r, i, o) {
  let a = e.getFirstChild();
  for (; a !== null; ) {
    const s = a.__key;
    a.__parent === t && (ve(a) && i2(a, s, n, r, i, o), n.has(s) || o.delete(s), i.push(s)), a = a.getNextSibling();
  }
}
let Fa, pr, _f, Dg, K0, G0, Bs, ki, Y0, Sf, wn = "", cr = "", Bi = null, Si = "", So = "", o2 = !1, Of = !1, up = null;
function Bp(e, t) {
  const n = Bs.get(e);
  if (t !== null) {
    const r = Z0(e);
    r.parentNode === t && t.removeChild(r);
  }
  if (ki.has(e) || pr._keyToDOMMap.delete(e), ve(n)) {
    const r = Wp(n, Bs);
    q0(r, 0, r.length - 1, null);
  }
  n !== void 0 && g_(Sf, _f, Dg, n, "destroyed");
}
function q0(e, t, n, r) {
  let i = t;
  for (; i <= n; ++i) {
    const o = e[i];
    o !== void 0 && Bp(o, r);
  }
}
function ls(e, t) {
  e.setProperty("text-align", t);
}
const lJ = "40px";
function a2(e, t) {
  const n = Fa.theme.indent;
  if (typeof n == "string") {
    const i = e.classList.contains(n);
    t > 0 && !i ? e.classList.add(n) : t < 1 && i && e.classList.remove(n);
  }
  const r = getComputedStyle(e).getPropertyValue("--lexical-indent-base-value") || lJ;
  e.style.setProperty("padding-inline-start", t === 0 ? "" : `calc(${t} * ${r})`);
}
function s2(e, t) {
  const n = e.style;
  t === 0 ? ls(n, "") : t === o_ ? ls(n, "left") : t === a_ ? ls(n, "center") : t === s_ ? ls(n, "right") : t === l_ ? ls(n, "justify") : t === c_ ? ls(n, "start") : t === u_ && ls(n, "end");
}
function Fp(e, t, n) {
  const r = ki.get(e);
  r === void 0 && _e(60);
  const i = r.createDOM(Fa, pr);
  if (function(o, a, s) {
    const l = s._keyToDOMMap;
    a["__lexicalKey_" + s._key] = o, l.set(o, a);
  }(e, i, pr), Se(r) ? i.setAttribute("data-lexical-text", "true") : Ht(r) && i.setAttribute("data-lexical-decorator", "true"), ve(r)) {
    const o = r.__indent, a = r.__size;
    if (o !== 0 && a2(i, o), a !== 0) {
      const l = a - 1;
      (function(c, f, d, p) {
        const m = cr;
        cr = "", X0(c, d, 0, f, p, null), c2(d, p), cr = m;
      })(Wp(r, ki), l, r, i);
    }
    const s = r.__format;
    s !== 0 && s2(i, s), r.isInline() || l2(null, r, i), kg(r) && (wn += zo, So += zo);
  } else {
    const o = r.getTextContent();
    if (Ht(r)) {
      const a = r.decorate(pr, Fa);
      a !== null && u2(e, a), i.contentEditable = "false";
    } else Se(r) && (r.isDirectionless() || (cr += o));
    wn += o, So += o;
  }
  if (t !== null) if (n != null) t.insertBefore(i, n);
  else {
    const o = t.__lexicalLineBreak;
    o != null ? t.insertBefore(i, o) : t.appendChild(i);
  }
  return g_(Sf, _f, Dg, r, "created"), i;
}
function X0(e, t, n, r, i, o) {
  const a = wn;
  wn = "";
  let s = n;
  for (; s <= r; ++s) {
    Fp(e[s], i, o);
    const l = ki.get(e[s]);
    l !== null && Se(l) && (Bi === null && (Bi = l.getFormat()), Si === "" && (Si = l.getStyle()));
  }
  kg(t) && (wn += zo), i.__lexicalTextContent = wn, wn = a + wn;
}
function EC(e, t) {
  const n = t.get(e);
  return Ju(n) || Ht(n) && n.isInline();
}
function l2(e, t, n) {
  const r = e !== null && (e.__size === 0 || EC(e.__last, Bs)), i = t.__size === 0 || EC(t.__last, ki);
  if (r) {
    if (!i) {
      const o = n.__lexicalLineBreak;
      if (o != null) try {
        n.removeChild(o);
      } catch (a) {
        if (typeof a == "object" && a != null) {
          const s = `${a.toString()} Parent: ${n.tagName}, child: ${o.tagName}.`;
          throw new Error(s);
        }
        throw a;
      }
      n.__lexicalLineBreak = null;
    }
  } else if (i) {
    const o = document.createElement("br");
    n.__lexicalLineBreak = o, n.appendChild(o);
  }
}
function c2(e, t) {
  const n = t.__lexicalDirTextContent, r = t.__lexicalDir;
  if (n !== cr || r !== up) {
    const o = cr === "", a = o ? up : (i = cr, BZ.test(i) ? "rtl" : FZ.test(i) ? "ltr" : null);
    if (a !== r) {
      const s = t.classList, l = Fa.theme;
      let c = r !== null ? l[r] : void 0, f = a !== null ? l[a] : void 0;
      if (c !== void 0) {
        if (typeof c == "string") {
          const d = Ip(c);
          c = l[r] = d;
        }
        s.remove(...c);
      }
      if (a === null || o && a === "ltr") t.removeAttribute("dir");
      else {
        if (f !== void 0) {
          if (typeof f == "string") {
            const d = Ip(f);
            f = l[a] = d;
          }
          f !== void 0 && s.add(...f);
        }
        t.dir = a;
      }
      Of || (e.getWritable().__dir = a);
    }
    up = a, t.__lexicalDirTextContent = cr, t.__lexicalDir = a;
  }
  var i;
}
function cJ(e, t, n) {
  const r = cr;
  var i;
  cr = "", Bi = null, Si = "", function(o, a, s) {
    const l = wn, c = o.__size, f = a.__size;
    if (wn = "", c === 1 && f === 1) {
      const d = o.__first, p = a.__first;
      if (d === p) Wu(d, s);
      else {
        const y = Z0(d), g = Fp(p, null, null);
        try {
          s.replaceChild(g, y);
        } catch (v) {
          if (typeof v == "object" && v != null) {
            const x = `${v.toString()} Parent: ${s.tagName}, new child: {tag: ${g.tagName} key: ${p}}, old child: {tag: ${y.tagName}, key: ${d}}.`;
            throw new Error(x);
          }
          throw v;
        }
        Bp(d, null);
      }
      const m = ki.get(p);
      Se(m) && (Bi === null && (Bi = m.getFormat()), Si === "" && (Si = m.getStyle()));
    } else {
      const d = Wp(o, Bs), p = Wp(a, ki);
      if (c === 0) f !== 0 && X0(p, a, 0, f - 1, s, null);
      else if (f === 0) {
        if (c !== 0) {
          const m = s.__lexicalLineBreak == null;
          q0(d, 0, c - 1, m ? null : s), m && (s.textContent = "");
        }
      } else (function(m, y, g, v, x, w) {
        const S = v - 1, A = x - 1;
        let _, O, P = (I = w, I.firstChild), C = 0, k = 0;
        for (var I; C <= S && k <= A; ) {
          const D = y[C], j = g[k];
          if (D === j) P = yb(Wu(j, w)), C++, k++;
          else {
            _ === void 0 && (_ = new Set(y)), O === void 0 && (O = new Set(g));
            const W = O.has(D), z = _.has(j);
            if (W) if (z) {
              const H = Lp(pr, j);
              H === P ? P = yb(Wu(j, w)) : (P != null ? w.insertBefore(H, P) : w.appendChild(H), Wu(j, w)), C++, k++;
            } else Fp(j, w, P), k++;
            else P = yb(Z0(D)), Bp(D, w), C++;
          }
          const F = ki.get(j);
          F !== null && Se(F) && (Bi === null && (Bi = F.getFormat()), Si === "" && (Si = F.getStyle()));
        }
        const $ = C > S, N = k > A;
        if ($ && !N) {
          const D = g[A + 1];
          X0(g, m, k, A, w, D === void 0 ? null : pr.getElementByKey(D));
        } else N && !$ && q0(y, C, S, w);
      })(a, d, p, c, f, s);
    }
    kg(a) && (wn += zo), s.__lexicalTextContent = wn, wn = l + wn;
  }(e, t, n), c2(t, n), ix(i = t) && Bi != null && Bi !== i.__textFormat && !Of && (i.setTextFormat(Bi), i.setTextStyle(Si)), function(o) {
    ix(o) && Si !== "" && Si !== o.__textStyle && !Of && o.setTextStyle(Si);
  }(t), cr = r;
}
function Wp(e, t) {
  const n = [];
  let r = e.__first;
  for (; r !== null; ) {
    const i = t.get(r);
    i === void 0 && _e(101), n.push(r), r = i.__next;
  }
  return n;
}
function Wu(e, t) {
  const n = Bs.get(e);
  let r = ki.get(e);
  n !== void 0 && r !== void 0 || _e(61);
  const i = o2 || G0.has(e) || K0.has(e), o = Lp(pr, e);
  if (n === r && !i) {
    if (ve(n)) {
      const a = o.__lexicalTextContent;
      a !== void 0 && (wn += a, So += a);
      const s = o.__lexicalDirTextContent;
      s !== void 0 && (cr += s);
    } else {
      const a = n.getTextContent();
      Se(n) && !n.isDirectionless() && (cr += a), So += a, wn += a;
    }
    return o;
  }
  if (n !== r && i && g_(Sf, _f, Dg, r, "updated"), r.updateDOM(n, o, Fa)) {
    const a = Fp(e, null, null);
    return t === null && _e(62), t.replaceChild(a, o), Bp(e, null), a;
  }
  if (ve(n) && ve(r)) {
    const a = r.__indent;
    a !== n.__indent && a2(o, a);
    const s = r.__format;
    s !== n.__format && s2(o, s), i && (cJ(n, r, o), ur(r) || r.isInline() || l2(n, r, o)), kg(r) && (wn += zo, So += zo);
  } else {
    const a = r.getTextContent();
    if (Ht(r)) {
      const s = r.decorate(pr, Fa);
      s !== null && u2(e, s);
    } else Se(r) && !r.isDirectionless() && (cr += a);
    wn += a, So += a;
  }
  if (!Of && ur(r) && r.__cachedText !== So) {
    const a = r.getWritable();
    a.__cachedText = So, r = a;
  }
  return o;
}
function u2(e, t) {
  let n = pr._pendingDecorators;
  const r = pr._decorators;
  if (n === null) {
    if (r[e] === t) return;
    n = ZR(pr);
  }
  n[e] = t;
}
function yb(e) {
  let t = e.nextSibling;
  return t !== null && t === pr._blockCursorElement && (t = t.nextSibling), t;
}
function uJ(e, t, n, r, i, o) {
  wn = "", So = "", cr = "", o2 = r === nc, up = null, pr = n, Fa = n._config, _f = n._nodes, Dg = pr._listeners.mutation, K0 = i, G0 = o, Bs = e._nodeMap, ki = t._nodeMap, Of = t._readOnly, Y0 = new Map(n._keyToDOMMap);
  const a = /* @__PURE__ */ new Map();
  return Sf = a, Wu("root", null), pr = void 0, _f = void 0, K0 = void 0, G0 = void 0, Bs = void 0, ki = void 0, Fa = void 0, Y0 = void 0, Sf = void 0, a;
}
function Z0(e) {
  const t = Y0.get(e);
  return t === void 0 && _e(75, e), t;
}
const xo = Object.freeze({}), J0 = 30, Q0 = [["keydown", function(e, t) {
  if (Xu = e.timeStamp, f2 = e.key, t.isComposing()) return;
  const { key: n, shiftKey: r, ctrlKey: i, metaKey: o, altKey: a } = e;
  Ae(t, $R, e) || n != null && (function(s, l, c, f) {
    return SC(s) && !l && !f && !c;
  }(n, i, a, o) ? Ae(t, Z1, e) : function(s, l, c, f, d) {
    return SC(s) && !f && !c && (l || d);
  }(n, i, r, a, o) ? Ae(t, wZ, e) : function(s, l, c, f) {
    return _C(s) && !l && !f && !c;
  }(n, i, a, o) ? Ae(t, J1, e) : function(s, l, c, f, d) {
    return _C(s) && !f && !c && (l || d);
  }(n, i, r, a, o) ? Ae(t, _Z, e) : /* @__PURE__ */ function(s, l, c) {
    return /* @__PURE__ */ function(f) {
      return f === "ArrowUp";
    }(s) && !l && !c;
  }(n, i, o) ? Ae(t, DR, e) : /* @__PURE__ */ function(s, l, c) {
    return /* @__PURE__ */ function(f) {
      return f === "ArrowDown";
    }(s) && !l && !c;
  }(n, i, o) ? Ae(t, IR, e) : function(s, l) {
    return OC(s) && l;
  }(n, r) ? (Zu = !0, Ae(t, wf, e)) : /* @__PURE__ */ function(s) {
    return s === " ";
  }(n) ? Ae(t, SZ, e) : function(s, l) {
    return _i && l && s.toLowerCase() === "o";
  }(n, i) ? (e.preventDefault(), Zu = !0, Ae(t, Hl, !0)) : function(s, l) {
    return OC(s) && !l;
  }(n, r) ? (Zu = !1, Ae(t, wf, e)) : function(s, l, c, f) {
    return _i ? !l && !c && (_u(s) || s.toLowerCase() === "h" && f) : !(f || l || c) && _u(s);
  }(n, a, o, i) ? _u(n) ? Ae(t, Q1, e) : (e.preventDefault(), Ae(t, ks, !0)) : /* @__PURE__ */ function(s) {
    return s === "Escape";
  }(n) ? Ae(t, RR, e) : function(s, l, c, f, d) {
    return _i ? !(c || f || d) && (Su(s) || s.toLowerCase() === "d" && l) : !(l || f || d) && Su(s);
  }(n, i, r, a, o) ? Su(n) ? Ae(t, jR, e) : (e.preventDefault(), Ae(t, ks, !1)) : function(s, l, c) {
    return _u(s) && (_i ? l : c);
  }(n, a, i) ? (e.preventDefault(), Ae(t, bf, !0)) : function(s, l, c) {
    return Su(s) && (_i ? l : c);
  }(n, a, i) ? (e.preventDefault(), Ae(t, bf, !1)) : function(s, l) {
    return _i && l && _u(s);
  }(n, o) ? (e.preventDefault(), Ae(t, xf, !0)) : function(s, l) {
    return _i && l && Su(s);
  }(n, o) ? (e.preventDefault(), Ae(t, xf, !1)) : function(s, l, c, f) {
    return s.toLowerCase() === "b" && !l && Fu(c, f);
  }(n, a, o, i) ? (e.preventDefault(), Ae(t, _s, "bold")) : function(s, l, c, f) {
    return s.toLowerCase() === "u" && !l && Fu(c, f);
  }(n, a, o, i) ? (e.preventDefault(), Ae(t, _s, "underline")) : function(s, l, c, f) {
    return s.toLowerCase() === "i" && !l && Fu(c, f);
  }(n, a, o, i) ? (e.preventDefault(), Ae(t, _s, "italic")) : /* @__PURE__ */ function(s, l, c, f) {
    return s === "Tab" && !l && !c && !f;
  }(n, a, i, o) ? Ae(t, LR, e) : function(s, l, c, f) {
    return s.toLowerCase() === "z" && !l && Fu(c, f);
  }(n, r, o, i) ? (e.preventDefault(), Ae(t, q1, void 0)) : function(s, l, c, f) {
    return _i ? s.toLowerCase() === "z" && c && l : s.toLowerCase() === "y" && f || s.toLowerCase() === "z" && f && l;
  }(n, r, o, i) ? (e.preventDefault(), Ae(t, X1, void 0)) : Rg(t._editorState._selection) ? function(s, l, c, f) {
    return !l && s.toLowerCase() === "c" && (_i ? c : f);
  }(n, r, o, i) ? (e.preventDefault(), Ae(t, e_, e)) : function(s, l, c, f) {
    return !l && s.toLowerCase() === "x" && (_i ? c : f);
  }(n, r, o, i) ? (e.preventDefault(), Ae(t, t_, e)) : AC(n, o, i) && (e.preventDefault(), Ae(t, W0, e)) : !Ma && AC(n, o, i) && (e.preventDefault(), Ae(t, W0, e)), /* @__PURE__ */ function(s, l, c, f) {
    return s || l || c || f;
  }(i, r, a, o) && Ae(t, kZ, e));
}], ["pointerdown", function(e, t) {
  const n = e.target, r = e.pointerType;
  n instanceof Node && r !== "touch" && Fr(t, () => {
    Ht(Eg(n)) || (tx = !0);
  });
}], ["compositionstart", function(e, t) {
  Fr(t, () => {
    const n = Ne();
    if (we(n) && !t.isComposing()) {
      const r = n.anchor, i = n.anchor.getNode();
      Gn(r.key), (e.timeStamp < Xu + J0 || r.type === "element" || !n.isCollapsed() || i.getFormat() !== n.format || Se(i) && i.getStyle() !== n.style) && Ae(t, Kl, LZ);
    }
  });
}], ["compositionend", function(e, t) {
  Ma ? Ou = !0 : Fr(t, () => {
    vb(t, e.data);
  });
}], ["input", function(e, t) {
  e.stopPropagation(), Fr(t, () => {
    const n = Ne(), r = e.data, i = m2(e);
    if (r != null && we(n) && p2(n, i, r, e.timeStamp, !1)) {
      Ou && (vb(t, r), Ou = !1);
      const o = n.anchor.getNode(), a = no(t._window);
      if (a === null) return;
      const s = n.isBackward(), l = s ? n.anchor.offset : n.focus.offset, c = s ? n.focus.offset : n.anchor.offset;
      Np && !n.isCollapsed() && Se(o) && a.anchorNode !== null && o.getTextContent().slice(0, l) + r + o.getTextContent().slice(l + c) === t2(a.anchorNode) || Ae(t, Kl, r);
      const f = r.length;
      Ma && f > 1 && e.inputType === "insertCompositionText" && !t.isComposing() && (n.anchor.offset -= f), n_ || Ag || r_ || !t.isComposing() || (Xu = 0, Gn(null));
    } else
      p_(!1, t, r !== null ? r : void 0), Ou && (vb(t, r || void 0), Ou = !1);
    wr(), KR(mn());
  }), El = null;
}], ["click", function(e, t) {
  Fr(t, () => {
    const n = Ne(), r = no(t._window), i = jg();
    if (r) {
      if (we(n)) {
        const o = n.anchor, a = o.getNode();
        o.type === "element" && o.offset === 0 && n.isCollapsed() && !ur(a) && ir().getChildrenSize() === 1 && a.getTopLevelElementOrThrow().isEmpty() && i !== null && n.is(i) ? (r.removeAllRanges(), n.dirty = !0) : e.detail === 3 && !n.isCollapsed() && a !== n.focus.getNode() && (ve(a) ? a.select(0) : a.getParentOrThrow().select(0));
      } else if (e.pointerType === "touch") {
        const o = r.anchorNode;
        if (o !== null) {
          const a = o.nodeType;
          (a === md || a === Ua) && Vo(w_(i, r, t, e));
        }
      }
    }
    Ae(t, xZ, e);
  });
}], ["cut", xo], ["copy", xo], ["dragstart", xo], ["dragover", xo], ["dragend", xo], ["paste", xo], ["focus", xo], ["blur", xo], ["drop", xo]];
Np && Q0.push(["beforeinput", (e, t) => function(n, r) {
  const i = n.inputType, o = m2(n);
  i === "deleteCompositionText" || Ma && n2(r) || i !== "insertCompositionText" && Fr(r, () => {
    const a = Ne();
    if (i === "deleteContentBackward") {
      if (a === null) {
        const m = jg();
        if (!we(m)) return;
        Vo(m.clone());
      }
      if (we(a)) {
        const m = a.anchor.key === a.focus.key;
        if (s = n.timeStamp, f2 === "MediaLast" && s < Xu + J0 && r.isComposing() && m) {
          if (Gn(null), Xu = 0, setTimeout(() => {
            Fr(r, () => {
              Gn(null);
            });
          }, J0), we(a)) {
            const y = a.anchor.getNode();
            y.markDirty(), a.format = y.getFormat(), Se(y) || _e(142), a.style = y.getStyle();
          }
        } else {
          Gn(null), n.preventDefault();
          const y = a.anchor.getNode().getTextContent(), g = a.anchor.offset === 0 && a.focus.offset === y.length;
          $Z && m && !g || Ae(r, ks, !0);
        }
        return;
      }
    }
    var s;
    if (!we(a)) return;
    const l = n.data;
    El !== null && p_(!1, r, El), a.dirty && El === null || !a.isCollapsed() || ur(a.anchor.getNode()) || o === null || a.applyDOMRange(o), El = null;
    const c = a.anchor, f = a.focus, d = c.getNode(), p = f.getNode();
    if (i !== "insertText" && i !== "insertTranspose") switch (n.preventDefault(), i) {
      case "insertFromYank":
      case "insertFromDrop":
      case "insertReplacementText":
        Ae(r, Kl, n);
        break;
      case "insertFromComposition":
        Gn(null), Ae(r, Kl, n);
        break;
      case "insertLineBreak":
        Gn(null), Ae(r, Hl, !1);
        break;
      case "insertParagraph":
        Gn(null), Zu && !Ag ? (Zu = !1, Ae(r, Hl, !1)) : Ae(r, B0, void 0);
        break;
      case "insertFromPaste":
      case "insertFromPasteAsQuotation":
        Ae(r, Y1, n);
        break;
      case "deleteByComposition":
        (function(m, y) {
          return m !== y || ve(m) || ve(y) || !m.isToken() || !y.isToken();
        })(d, p) && Ae(r, F0, n);
        break;
      case "deleteByDrag":
      case "deleteByCut":
        Ae(r, F0, n);
        break;
      case "deleteContent":
        Ae(r, ks, !1);
        break;
      case "deleteWordBackward":
        Ae(r, bf, !0);
        break;
      case "deleteWordForward":
        Ae(r, bf, !1);
        break;
      case "deleteHardLineBackward":
      case "deleteSoftLineBackward":
        Ae(r, xf, !0);
        break;
      case "deleteContentForward":
      case "deleteHardLineForward":
      case "deleteSoftLineForward":
        Ae(r, xf, !1);
        break;
      case "formatStrikeThrough":
        Ae(r, _s, "strikethrough");
        break;
      case "formatBold":
        Ae(r, _s, "bold");
        break;
      case "formatItalic":
        Ae(r, _s, "italic");
        break;
      case "formatUnderline":
        Ae(r, _s, "underline");
        break;
      case "historyUndo":
        Ae(r, q1, void 0);
        break;
      case "historyRedo":
        Ae(r, X1, void 0);
    }
    else {
      if (l === `
`) n.preventDefault(), Ae(r, Hl, !1);
      else if (l === zo) n.preventDefault(), Ae(r, B0, void 0);
      else if (l == null && n.dataTransfer) {
        const m = n.dataTransfer.getData("text/plain");
        n.preventDefault(), a.insertRawText(m);
      } else l != null && p2(a, o, l, n.timeStamp, !0) ? (n.preventDefault(), Ae(r, Kl, l)) : El = l;
      d2 = n.timeStamp;
    }
  });
}(e, t)]);
let Xu = 0, f2 = null, d2 = 0, El = null;
const zp = /* @__PURE__ */ new WeakMap();
let ex = !1, tx = !1, Zu = !1, Ou = !1, h2 = [0, "", 0, "root", 0];
function p2(e, t, n, r, i) {
  const o = e.anchor, a = e.focus, s = o.getNode(), l = mn(), c = no(l._window), f = c !== null ? c.anchorNode : null, d = o.key, p = l.getElementByKey(d), m = n.length;
  return d !== a.key || !Se(s) || (!i && (!Np || d2 < r + 50) || s.isDirty() && m < 2 || QR(n)) && o.offset !== a.offset && !s.isComposing() || Pl(s) || s.isDirty() && m > 1 || (i || !Np) && p !== null && !s.isComposing() && f !== Rp(p) || c !== null && t !== null && (!t.collapsed || t.startContainer !== c.anchorNode || t.startOffset !== c.anchorOffset) || s.getFormat() !== e.format || s.getStyle() !== e.style || tJ(e, s);
}
function kC(e, t) {
  return e !== null && e.nodeValue !== null && e.nodeType === Ua && t !== 0 && t !== e.nodeValue.length;
}
function MC(e, t, n) {
  const { anchorNode: r, anchorOffset: i, focusNode: o, focusOffset: a } = e;
  ex && (ex = !1, kC(r, i) && kC(o, a)) || Fr(t, () => {
    if (!n) return void Vo(null);
    if (!Pg(t, r, o)) return;
    const s = Ne();
    if (we(s)) {
      const l = s.anchor, c = l.getNode();
      if (s.isCollapsed()) {
        e.type === "Range" && e.anchorNode === e.focusNode && (s.dirty = !0);
        const f = Ng(t).event, d = f ? f.timeStamp : performance.now(), [p, m, y, g, v] = h2, x = ir(), w = t.isComposing() === !1 && x.getTextContent() === "";
        if (d < v + 200 && l.offset === y && l.key === g) s.format = p, s.style = m;
        else if (l.type === "text") Se(c) || _e(141), s.format = c.getFormat(), s.style = c.getStyle();
        else if (l.type === "element" && !w) {
          const S = l.getNode();
          s.style = "", S instanceof Lc && S.getChildrenSize() === 0 ? (s.format = S.getTextFormat(), s.style = S.getTextStyle()) : s.format = 0;
        }
      } else {
        const f = l.key, d = s.focus.key, p = s.getNodes(), m = p.length, y = s.isBackward(), g = y ? a : i, v = y ? i : a, x = y ? d : f, w = y ? f : d;
        let S = jZ, A = !1;
        for (let _ = 0; _ < m; _++) {
          const O = p[_], P = O.getTextContentSize();
          if (Se(O) && P !== 0 && !(_ === 0 && O.__key === x && g === P || _ === m - 1 && O.__key === w && v === 0) && (A = !0, S &= O.getFormat(), S === 0)) break;
        }
        s.format = A ? S : 0;
      }
    }
    Ae(t, G1, void 0);
  });
}
function m2(e) {
  if (!e.getTargetRanges) return null;
  const t = e.getTargetRanges();
  return t.length === 0 ? null : t[0];
}
function vb(e, t) {
  const n = e._compositionKey;
  if (Gn(null), n !== null && t != null) {
    if (t === "") {
      const r = $n(n), i = Rp(e.getElementByKey(n));
      return void (i !== null && i.nodeValue !== null && Se(r) && m_(r, i.nodeValue, null, null, !0));
    }
    if (t[t.length - 1] === `
`) {
      const r = Ne();
      if (we(r)) {
        const i = r.focus;
        return r.anchor.set(i.key, i.offset, i.type), void Ae(e, wf, null);
      }
    }
  }
  p_(!0, e, t);
}
function g2(e) {
  let t = e.__lexicalEventHandles;
  return t === void 0 && (t = [], e.__lexicalEventHandles = t), t;
}
const Gl = /* @__PURE__ */ new Map();
function y2(e) {
  const t = e.target, n = no(t == null ? null : t.nodeType === 9 ? t.defaultView : t.ownerDocument.defaultView);
  if (n === null) return;
  const r = qR(n.anchorNode);
  if (r === null) return;
  tx && (tx = !1, Fr(r, () => {
    const c = jg(), f = n.anchorNode;
    if (f === null) return;
    const d = f.nodeType;
    d !== md && d !== Ua || Vo(w_(c, n, r, e));
  }));
  const i = h_(r), o = i[i.length - 1], a = o._key, s = Gl.get(a), l = s || o;
  l !== r && MC(n, l, !1), MC(n, r, !0), r !== o ? Gl.set(a, r) : s && Gl.delete(a);
}
function NC(e) {
  e._lexicalHandled = !0;
}
function $C(e) {
  return e._lexicalHandled === !0;
}
function fJ(e) {
  const t = e.ownerDocument, n = zp.get(t);
  n === void 0 && _e(162);
  const r = n - 1;
  r >= 0 || _e(164), zp.set(t, r), r === 0 && t.removeEventListener("selectionchange", y2);
  const i = Cg(e);
  d_(i) ? (function(a) {
    if (a._parentEditor !== null) {
      const s = h_(a), l = s[s.length - 1]._key;
      Gl.get(l) === a && Gl.delete(l);
    } else Gl.delete(a._key);
  }(i), e.__lexicalEditor = null) : i && _e(198);
  const o = g2(e);
  for (let a = 0; a < o.length; a++) o[a]();
  e.__lexicalEventHandles = [];
}
function nx(e, t, n) {
  wr();
  const r = e.__key, i = e.getParent();
  if (i === null) return;
  const o = function(s) {
    const l = Ne();
    if (!we(l) || !ve(s)) return l;
    const { anchor: c, focus: f } = l, d = c.getNode(), p = f.getNode();
    return H0(d, s) && c.set(s.__key, 0, "element"), H0(p, s) && f.set(s.__key, 0, "element"), l;
  }(e);
  let a = !1;
  if (we(o) && t) {
    const s = o.anchor, l = o.focus;
    s.key === r && (Up(s, e, i, e.getPreviousSibling(), e.getNextSibling()), a = !0), l.key === r && (Up(l, e, i, e.getPreviousSibling(), e.getNextSibling()), a = !0);
  } else Rg(o) && t && e.isSelected() && e.selectPrevious();
  if (we(o) && t && !a) {
    const s = e.getIndexWithinParent();
    Ms(e), Vp(o, i, s, -1);
  } else Ms(e);
  n || gd(i) || i.canBeEmpty() || !i.isEmpty() || nx(i, t), t && ur(i) && i.isEmpty() && i.selectEnd();
}
class Ig {
  static getType() {
    _e(64, this.name);
  }
  static clone(t) {
    _e(65, this.name);
  }
  afterCloneFrom(t) {
    this.__parent = t.__parent, this.__next = t.__next, this.__prev = t.__prev;
  }
  constructor(t) {
    this.__type = this.constructor.getType(), this.__parent = null, this.__prev = null, this.__next = null, eJ(this, t);
  }
  getType() {
    return this.__type;
  }
  isInline() {
    _e(137, this.constructor.name);
  }
  isAttached() {
    let t = this.__key;
    for (; t !== null; ) {
      if (t === "root") return !0;
      const n = $n(t);
      if (n === null) break;
      t = n.__parent;
    }
    return !1;
  }
  isSelected(t) {
    const n = t || Ne();
    if (n == null) return !1;
    const r = n.getNodes().some((i) => i.__key === this.__key);
    if (Se(this)) return r;
    if (we(n) && n.anchor.type === "element" && n.focus.type === "element") {
      if (n.isCollapsed()) return !1;
      const i = this.getParent();
      if (Ht(this) && this.isInline() && i) {
        const o = n.isBackward() ? n.focus : n.anchor, a = o.getNode();
        if (o.offset === a.getChildrenSize() && a.is(i) && a.getLastChildOrThrow().is(this)) return !1;
      }
    }
    return r;
  }
  getKey() {
    return this.__key;
  }
  getIndexWithinParent() {
    const t = this.getParent();
    if (t === null) return -1;
    let n = t.getFirstChild(), r = 0;
    for (; n !== null; ) {
      if (this.is(n)) return r;
      r++, n = n.getNextSibling();
    }
    return -1;
  }
  getParent() {
    const t = this.getLatest().__parent;
    return t === null ? null : $n(t);
  }
  getParentOrThrow() {
    const t = this.getParent();
    return t === null && _e(66, this.__key), t;
  }
  getTopLevelElement() {
    let t = this;
    for (; t !== null; ) {
      const n = t.getParent();
      if (gd(n)) return ve(t) || t === this && Ht(t) || _e(194), t;
      t = n;
    }
    return null;
  }
  getTopLevelElementOrThrow() {
    const t = this.getTopLevelElement();
    return t === null && _e(67, this.__key), t;
  }
  getParents() {
    const t = [];
    let n = this.getParent();
    for (; n !== null; ) t.push(n), n = n.getParent();
    return t;
  }
  getParentKeys() {
    const t = [];
    let n = this.getParent();
    for (; n !== null; ) t.push(n.__key), n = n.getParent();
    return t;
  }
  getPreviousSibling() {
    const t = this.getLatest().__prev;
    return t === null ? null : $n(t);
  }
  getPreviousSiblings() {
    const t = [], n = this.getParent();
    if (n === null) return t;
    let r = n.getFirstChild();
    for (; r !== null && !r.is(this); ) t.push(r), r = r.getNextSibling();
    return t;
  }
  getNextSibling() {
    const t = this.getLatest().__next;
    return t === null ? null : $n(t);
  }
  getNextSiblings() {
    const t = [];
    let n = this.getNextSibling();
    for (; n !== null; ) t.push(n), n = n.getNextSibling();
    return t;
  }
  getCommonAncestor(t) {
    const n = this.getParents(), r = t.getParents();
    ve(this) && n.unshift(this), ve(t) && r.unshift(t);
    const i = n.length, o = r.length;
    if (i === 0 || o === 0 || n[i - 1] !== r[o - 1]) return null;
    const a = new Set(r);
    for (let s = 0; s < i; s++) {
      const l = n[s];
      if (a.has(l)) return l;
    }
    return null;
  }
  is(t) {
    return t != null && this.__key === t.__key;
  }
  isBefore(t) {
    if (this === t) return !1;
    if (t.isParentOf(this)) return !0;
    if (this.isParentOf(t)) return !1;
    const n = this.getCommonAncestor(t);
    let r = 0, i = 0, o = this;
    for (; ; ) {
      const a = o.getParentOrThrow();
      if (a === n) {
        r = o.getIndexWithinParent();
        break;
      }
      o = a;
    }
    for (o = t; ; ) {
      const a = o.getParentOrThrow();
      if (a === n) {
        i = o.getIndexWithinParent();
        break;
      }
      o = a;
    }
    return r < i;
  }
  isParentOf(t) {
    const n = this.__key;
    if (n === t.__key) return !1;
    let r = t;
    for (; r !== null; ) {
      if (r.__key === n) return !0;
      r = r.getParent();
    }
    return !1;
  }
  getNodesBetween(t) {
    const n = this.isBefore(t), r = [], i = /* @__PURE__ */ new Set();
    let o = this;
    for (; o !== null; ) {
      const a = o.__key;
      if (i.has(a) || (i.add(a), r.push(o)), o === t) break;
      const s = ve(o) ? n ? o.getFirstChild() : o.getLastChild() : null;
      if (s !== null) {
        o = s;
        continue;
      }
      const l = n ? o.getNextSibling() : o.getPreviousSibling();
      if (l !== null) {
        o = l;
        continue;
      }
      const c = o.getParentOrThrow();
      if (i.has(c.__key) || r.push(c), c === t) break;
      let f = null, d = c;
      do {
        if (d === null && _e(68), f = n ? d.getNextSibling() : d.getPreviousSibling(), d = d.getParent(), d === null) break;
        f !== null || i.has(d.__key) || r.push(d);
      } while (f === null);
      o = f;
    }
    return n || r.reverse(), r;
  }
  isDirty() {
    const t = mn()._dirtyLeaves;
    return t !== null && t.has(this.__key);
  }
  getLatest() {
    const t = $n(this.__key);
    return t === null && _e(113), t;
  }
  getWritable() {
    wr();
    const t = qo(), n = mn(), r = t._nodeMap, i = this.__key, o = this.getLatest(), a = n._cloneNotNeeded, s = Ne();
    if (s !== null && s.setCachedNodes(null), a.has(i)) return jp(o), o;
    const l = r2(o);
    return a.add(i), jp(l), r.set(i, l), l;
  }
  getTextContent() {
    return "";
  }
  getTextContentSize() {
    return this.getTextContent().length;
  }
  createDOM(t, n) {
    _e(70);
  }
  updateDOM(t, n, r) {
    _e(71);
  }
  exportDOM(t) {
    return { element: this.createDOM(t._config, t) };
  }
  exportJSON() {
    _e(72);
  }
  static importJSON(t) {
    _e(18, this.name);
  }
  static transform() {
    return null;
  }
  remove(t) {
    nx(this, !0, t);
  }
  replace(t, n) {
    wr();
    let r = Ne();
    r !== null && (r = r.clone()), pb(this, t);
    const i = this.getLatest(), o = this.__key, a = t.__key, s = t.getWritable(), l = this.getParentOrThrow().getWritable(), c = l.__size;
    Ms(s);
    const f = i.getPreviousSibling(), d = i.getNextSibling(), p = i.__prev, m = i.__next, y = i.__parent;
    if (nx(i, !1, !0), f === null ? l.__first = a : f.getWritable().__next = a, s.__prev = p, d === null ? l.__last = a : d.getWritable().__prev = a, s.__next = m, s.__parent = y, l.__size = c, n && (ve(this) && ve(s) || _e(139), this.getChildren().forEach((g) => {
      s.append(g);
    })), we(r)) {
      Vo(r);
      const g = r.anchor, v = r.focus;
      g.key === o && jC(g, s), v.key === o && jC(v, s);
    }
    return Oa() === o && Gn(a), s;
  }
  insertAfter(t, n = !0) {
    wr(), pb(this, t);
    const r = this.getWritable(), i = t.getWritable(), o = i.getParent(), a = Ne();
    let s = !1, l = !1;
    if (o !== null) {
      const m = t.getIndexWithinParent();
      if (Ms(i), we(a)) {
        const y = o.__key, g = a.anchor, v = a.focus;
        s = g.type === "element" && g.key === y && g.offset === m + 1, l = v.type === "element" && v.key === y && v.offset === m + 1;
      }
    }
    const c = this.getNextSibling(), f = this.getParentOrThrow().getWritable(), d = i.__key, p = r.__next;
    if (c === null ? f.__last = d : c.getWritable().__prev = d, f.__size++, r.__next = d, i.__next = p, i.__prev = r.__key, i.__parent = r.__parent, n && we(a)) {
      const m = this.getIndexWithinParent();
      Vp(a, f, m + 1);
      const y = f.__key;
      s && a.anchor.set(y, m + 2, "element"), l && a.focus.set(y, m + 2, "element");
    }
    return t;
  }
  insertBefore(t, n = !0) {
    wr(), pb(this, t);
    const r = this.getWritable(), i = t.getWritable(), o = i.__key;
    Ms(i);
    const a = this.getPreviousSibling(), s = this.getParentOrThrow().getWritable(), l = r.__prev, c = this.getIndexWithinParent();
    a === null ? s.__first = o : a.getWritable().__next = o, s.__size++, r.__prev = o, i.__prev = l, i.__next = r.__key, i.__parent = r.__parent;
    const f = Ne();
    return n && we(f) && Vp(f, this.getParentOrThrow(), c), t;
  }
  isParentRequired() {
    return !1;
  }
  createParentElementNode() {
    return Ro();
  }
  selectStart() {
    return this.selectPrevious();
  }
  selectEnd() {
    return this.selectNext(0, 0);
  }
  selectPrevious(t, n) {
    wr();
    const r = this.getPreviousSibling(), i = this.getParentOrThrow();
    if (r === null) return i.select(0, 0);
    if (ve(r)) return r.select();
    if (!Se(r)) {
      const o = r.getIndexWithinParent() + 1;
      return i.select(o, o);
    }
    return r.select(t, n);
  }
  selectNext(t, n) {
    wr();
    const r = this.getNextSibling(), i = this.getParentOrThrow();
    if (r === null) return i.select();
    if (ve(r)) return r.select(0, 0);
    if (!Se(r)) {
      const o = r.getIndexWithinParent();
      return i.select(o, o);
    }
    return r.select(t, n);
  }
  markDirty() {
    this.getWritable();
  }
}
class yd extends Ig {
  static getType() {
    return "linebreak";
  }
  static clone(t) {
    return new yd(t.__key);
  }
  constructor(t) {
    super(t);
  }
  getTextContent() {
    return `
`;
  }
  createDOM() {
    return document.createElement("br");
  }
  updateDOM() {
    return !1;
  }
  static importDOM() {
    return { br: (t) => function(n) {
      const r = n.parentElement;
      if (r !== null && PC(r)) {
        const i = r.firstChild;
        if (i === n || i.nextSibling === n && Lh(i)) {
          const o = r.lastChild;
          if (o === n || o.previousSibling === n && Lh(o)) return !0;
        }
      }
      return !1;
    }(t) || function(n) {
      const r = n.parentElement;
      if (r !== null && PC(r)) {
        const i = r.firstChild;
        if (i === n || i.nextSibling === n && Lh(i)) return !1;
        const o = r.lastChild;
        if (o === n || o.previousSibling === n && Lh(o)) return !0;
      }
      return !1;
    }(t) ? null : { conversion: dJ, priority: 0 } };
  }
  static importJSON(t) {
    return Af();
  }
  exportJSON() {
    return { type: "linebreak", version: 1 };
  }
}
function dJ(e) {
  return { node: Af() };
}
function Af() {
  return $g(new yd());
}
function Ju(e) {
  return e instanceof yd;
}
function Lh(e) {
  return e.nodeType === Ua && /^( |\t|\r?\n)+$/.test(e.textContent || "");
}
function bb(e, t) {
  return 16 & t ? "code" : t & i_ ? "mark" : 32 & t ? "sub" : 64 & t ? "sup" : null;
}
function xb(e, t) {
  return 1 & t ? "strong" : 2 & t ? "em" : "span";
}
function v2(e, t, n, r, i) {
  const o = r.classList;
  let a = qu(i, "base");
  a !== void 0 && o.add(...a), a = qu(i, "underlineStrikethrough");
  let s = !1;
  const l = t & Dp && t & $p;
  a !== void 0 && (n & Dp && n & $p ? (s = !0, l || o.add(...a)) : l && o.remove(...a));
  for (const c in Io) {
    const f = Io[c];
    if (a = qu(i, c), a !== void 0) if (n & f) {
      if (s && (c === "underline" || c === "strikethrough")) {
        t & f && o.remove(...a);
        continue;
      }
      t & f && (!l || c !== "underline") && c !== "strikethrough" || o.add(...a);
    } else t & f && o.remove(...a);
  }
}
function b2(e, t, n) {
  const r = t.firstChild, i = n.isComposing(), o = e + (i ? Tg : "");
  if (r == null) t.textContent = o;
  else {
    const a = r.nodeValue;
    if (a !== o) if (i || Ma) {
      const [s, l, c] = function(f, d) {
        const p = f.length, m = d.length;
        let y = 0, g = 0;
        for (; y < p && y < m && f[y] === d[y]; ) y++;
        for (; g + y < p && g + y < m && f[p - g - 1] === d[m - g - 1]; ) g++;
        return [y, p - y - g, d.slice(y, m - g)];
      }(a, o);
      l !== 0 && r.deleteData(s, l), r.insertData(s, c);
    } else r.nodeValue = o;
  }
}
function DC(e, t, n, r, i, o) {
  b2(i, e, t);
  const a = o.theme.text;
  a !== void 0 && v2(0, 0, r, e, a);
}
function Bh(e, t) {
  const n = document.createElement(t);
  return n.appendChild(e), n;
}
class jc extends Ig {
  static getType() {
    return "text";
  }
  static clone(t) {
    return new jc(t.__text, t.__key);
  }
  afterCloneFrom(t) {
    super.afterCloneFrom(t), this.__format = t.__format, this.__style = t.__style, this.__mode = t.__mode, this.__detail = t.__detail;
  }
  constructor(t, n) {
    super(n), this.__text = t, this.__format = 0, this.__style = "", this.__mode = 0, this.__detail = 0;
  }
  getFormat() {
    return this.getLatest().__format;
  }
  getDetail() {
    return this.getLatest().__detail;
  }
  getMode() {
    const t = this.getLatest();
    return UZ[t.__mode];
  }
  getStyle() {
    return this.getLatest().__style;
  }
  isToken() {
    return this.getLatest().__mode === 1;
  }
  isComposing() {
    return this.__key === Oa();
  }
  isSegmented() {
    return this.getLatest().__mode === 2;
  }
  isDirectionless() {
    return !!(1 & this.getLatest().__detail);
  }
  isUnmergeable() {
    return !!(2 & this.getLatest().__detail);
  }
  hasFormat(t) {
    const n = Io[t];
    return !!(this.getFormat() & n);
  }
  isSimpleText() {
    return this.__type === "text" && this.__mode === 0;
  }
  getTextContent() {
    return this.getLatest().__text;
  }
  getFormatFlags(t, n) {
    return V0(this.getLatest().__format, t, n);
  }
  canHaveFormat() {
    return !0;
  }
  createDOM(t, n) {
    const r = this.__format, i = bb(0, r), o = xb(0, r), a = i === null ? o : i, s = document.createElement(a);
    let l = s;
    this.hasFormat("code") && s.setAttribute("spellcheck", "false"), i !== null && (l = document.createElement(o), s.appendChild(l)), DC(l, this, 0, r, this.__text, t);
    const c = this.__style;
    return c !== "" && (s.style.cssText = c), s;
  }
  updateDOM(t, n, r) {
    const i = this.__text, o = t.__format, a = this.__format, s = bb(0, o), l = bb(0, a), c = xb(0, o), f = xb(0, a);
    if ((s === null ? c : s) !== (l === null ? f : l)) return !0;
    if (s === l && c !== f) {
      const g = n.firstChild;
      g == null && _e(48);
      const v = document.createElement(f);
      return DC(v, this, 0, a, i, r), n.replaceChild(v, g), !1;
    }
    let d = n;
    l !== null && s !== null && (d = n.firstChild, d == null && _e(49)), b2(i, d, this);
    const p = r.theme.text;
    p !== void 0 && o !== a && v2(0, o, a, d, p);
    const m = t.__style, y = this.__style;
    return m !== y && (n.style.cssText = y), !1;
  }
  static importDOM() {
    return { "#text": () => ({ conversion: gJ, priority: 0 }), b: () => ({ conversion: pJ, priority: 0 }), code: () => ({ conversion: ga, priority: 0 }), em: () => ({ conversion: ga, priority: 0 }), i: () => ({ conversion: ga, priority: 0 }), s: () => ({ conversion: ga, priority: 0 }), span: () => ({ conversion: hJ, priority: 0 }), strong: () => ({ conversion: ga, priority: 0 }), sub: () => ({ conversion: ga, priority: 0 }), sup: () => ({ conversion: ga, priority: 0 }), u: () => ({ conversion: ga, priority: 0 }) };
  }
  static importJSON(t) {
    const n = Vn(t.text);
    return n.setFormat(t.format), n.setDetail(t.detail), n.setMode(t.mode), n.setStyle(t.style), n;
  }
  exportDOM(t) {
    let { element: n } = super.exportDOM(t);
    return n !== null && v_(n) || _e(132), n.style.whiteSpace = "pre-wrap", this.hasFormat("bold") && (n = Bh(n, "b")), this.hasFormat("italic") && (n = Bh(n, "i")), this.hasFormat("strikethrough") && (n = Bh(n, "s")), this.hasFormat("underline") && (n = Bh(n, "u")), { element: n };
  }
  exportJSON() {
    return { detail: this.getDetail(), format: this.getFormat(), mode: this.getMode(), style: this.getStyle(), text: this.getTextContent(), type: "text", version: 1 };
  }
  selectionTransform(t, n) {
  }
  setFormat(t) {
    const n = this.getWritable();
    return n.__format = typeof t == "string" ? Io[t] : t, n;
  }
  setDetail(t) {
    const n = this.getWritable();
    return n.__detail = typeof t == "string" ? WZ[t] : t, n;
  }
  setStyle(t) {
    const n = this.getWritable();
    return n.__style = t, n;
  }
  toggleFormat(t) {
    const n = V0(this.getFormat(), t, null);
    return this.setFormat(n);
  }
  toggleDirectionless() {
    const t = this.getWritable();
    return t.__detail ^= 1, t;
  }
  toggleUnmergeable() {
    const t = this.getWritable();
    return t.__detail ^= 2, t;
  }
  setMode(t) {
    const n = VZ[t];
    if (this.__mode === n) return this;
    const r = this.getWritable();
    return r.__mode = n, r;
  }
  setTextContent(t) {
    if (this.__text === t) return this;
    const n = this.getWritable();
    return n.__text = t, n;
  }
  select(t, n) {
    wr();
    let r = t, i = n;
    const o = Ne(), a = this.getTextContent(), s = this.__key;
    if (typeof a == "string") {
      const l = a.length;
      r === void 0 && (r = l), i === void 0 && (i = l);
    } else r = 0, i = 0;
    if (!we(o)) return O2(s, r, s, i, "text", "text");
    {
      const l = Oa();
      l !== o.anchor.key && l !== o.focus.key || Gn(s), o.setTextNodeRange(this, r, this, i);
    }
    return o;
  }
  selectStart() {
    return this.select(0, 0);
  }
  selectEnd() {
    const t = this.getTextContentSize();
    return this.select(t, t);
  }
  spliceText(t, n, r, i) {
    const o = this.getWritable(), a = o.__text, s = r.length;
    let l = t;
    l < 0 && (l = s + l, l < 0 && (l = 0));
    const c = Ne();
    if (i && we(c)) {
      const d = t + s;
      c.setTextNodeRange(o, d, o, d);
    }
    const f = a.slice(0, l) + r + a.slice(l + n);
    return o.__text = f, o;
  }
  canInsertTextBefore() {
    return !0;
  }
  canInsertTextAfter() {
    return !0;
  }
  splitText(...t) {
    wr();
    const n = this.getLatest(), r = n.getTextContent(), i = n.__key, o = Oa(), a = new Set(t), s = [], l = r.length;
    let c = "";
    for (let _ = 0; _ < l; _++) c !== "" && a.has(_) && (s.push(c), c = ""), c += r[_];
    c !== "" && s.push(c);
    const f = s.length;
    if (f === 0) return [];
    if (s[0] === r) return [n];
    const d = s[0], p = n.getParent();
    let m;
    const y = n.getFormat(), g = n.getStyle(), v = n.__detail;
    let x = !1;
    n.isSegmented() ? (m = Vn(d), m.__format = y, m.__style = g, m.__detail = v, x = !0) : (m = n.getWritable(), m.__text = d);
    const w = Ne(), S = [m];
    let A = d.length;
    for (let _ = 1; _ < f; _++) {
      const O = s[_], P = O.length, C = Vn(O).getWritable();
      C.__format = y, C.__style = g, C.__detail = v;
      const k = C.__key, I = A + P;
      if (we(w)) {
        const $ = w.anchor, N = w.focus;
        $.key === i && $.type === "text" && $.offset > A && $.offset <= I && ($.key = k, $.offset -= A, w.dirty = !0), N.key === i && N.type === "text" && N.offset > A && N.offset <= I && (N.key = k, N.offset -= A, w.dirty = !0);
      }
      o === i && Gn(k), A = I, S.push(C);
    }
    if (p !== null) {
      (function(P) {
        const C = P.getPreviousSibling(), k = P.getNextSibling();
        C !== null && jp(C), k !== null && jp(k);
      })(this);
      const _ = p.getWritable(), O = this.getIndexWithinParent();
      x ? (_.splice(O, 0, S), this.remove()) : _.splice(O, 1, S), we(w) && Vp(w, p, O, f - 1);
    }
    return S;
  }
  mergeWithSibling(t) {
    const n = t === this.getPreviousSibling();
    n || t === this.getNextSibling() || _e(50);
    const r = this.__key, i = t.__key, o = this.__text, a = o.length;
    Oa() === i && Gn(r);
    const s = Ne();
    if (we(s)) {
      const d = s.anchor, p = s.focus;
      d !== null && d.key === i && (UC(d, n, r, t, a), s.dirty = !0), p !== null && p.key === i && (UC(p, n, r, t, a), s.dirty = !0);
    }
    const l = t.__text, c = n ? l + o : o + l;
    this.setTextContent(c);
    const f = this.getWritable();
    return t.remove(), f;
  }
  isTextEntity() {
    return !1;
  }
}
function hJ(e) {
  return { forChild: b_(e.style), node: null };
}
function pJ(e) {
  const t = e, n = t.style.fontWeight === "normal";
  return { forChild: b_(t.style, n ? void 0 : "bold"), node: null };
}
const IC = /* @__PURE__ */ new WeakMap();
function mJ(e) {
  return e.nodeName === "PRE" || e.nodeType === md && e.style !== void 0 && e.style.whiteSpace !== void 0 && e.style.whiteSpace.startsWith("pre");
}
function gJ(e) {
  const t = e;
  e.parentElement === null && _e(129);
  let n = t.textContent || "";
  if (function(r) {
    let i, o = r.parentNode;
    const a = [r];
    for (; o !== null && (i = IC.get(o)) === void 0 && !mJ(o); ) a.push(o), o = o.parentNode;
    const s = i === void 0 ? o : i;
    for (let l = 0; l < a.length; l++) IC.set(a[l], s);
    return s;
  }(t) !== null) {
    const r = n.split(/(\r?\n|\t)/), i = [], o = r.length;
    for (let a = 0; a < o; a++) {
      const s = r[a];
      s === `
` || s === `\r
` ? i.push(Af()) : s === "	" ? i.push(x_()) : s !== "" && i.push(Vn(s));
    }
    return { node: i };
  }
  if (n = n.replace(/\r/g, "").replace(/[ \t\n]+/g, " "), n === "") return { node: null };
  if (n[0] === " ") {
    let r = t, i = !0;
    for (; r !== null && (r = RC(r, !1)) !== null; ) {
      const o = r.textContent || "";
      if (o.length > 0) {
        /[ \t\n]$/.test(o) && (n = n.slice(1)), i = !1;
        break;
      }
    }
    i && (n = n.slice(1));
  }
  if (n[n.length - 1] === " ") {
    let r = t, i = !0;
    for (; r !== null && (r = RC(r, !0)) !== null; )
      if ((r.textContent || "").replace(/^( |\t|\r?\n)+/, "").length > 0) {
        i = !1;
        break;
      }
    i && (n = n.slice(0, n.length - 1));
  }
  return n === "" ? { node: null } : { node: Vn(n) };
}
function RC(e, t) {
  let n = e;
  for (; ; ) {
    let r;
    for (; (r = t ? n.nextSibling : n.previousSibling) === null; ) {
      const o = n.parentElement;
      if (o === null) return null;
      n = o;
    }
    if (n = r, n.nodeType === md) {
      const o = n.style.display;
      if (o === "" && !oJ(n) || o !== "" && !o.startsWith("inline")) return null;
    }
    let i = n;
    for (; (i = t ? n.firstChild : n.lastChild) !== null; ) n = i;
    if (n.nodeType === Ua) return n;
    if (n.nodeName === "BR") return null;
  }
}
const yJ = { code: "code", em: "italic", i: "italic", s: "strikethrough", strong: "bold", sub: "subscript", sup: "superscript", u: "underline" };
function ga(e) {
  const t = yJ[e.nodeName.toLowerCase()];
  return t === void 0 ? { node: null } : { forChild: b_(e.style, t), node: null };
}
function Vn(e = "") {
  return $g(new jc(e));
}
function Se(e) {
  return e instanceof jc;
}
function b_(e, t) {
  const n = e.fontWeight, r = e.textDecoration.split(" "), i = n === "700" || n === "bold", o = r.includes("line-through"), a = e.fontStyle === "italic", s = r.includes("underline"), l = e.verticalAlign;
  return (c) => (Se(c) && (i && !c.hasFormat("bold") && c.toggleFormat("bold"), o && !c.hasFormat("strikethrough") && c.toggleFormat("strikethrough"), a && !c.hasFormat("italic") && c.toggleFormat("italic"), s && !c.hasFormat("underline") && c.toggleFormat("underline"), l !== "sub" || c.hasFormat("subscript") || c.toggleFormat("subscript"), l !== "super" || c.hasFormat("superscript") || c.toggleFormat("superscript"), t && !c.hasFormat(t) && c.toggleFormat(t)), c);
}
class vd extends jc {
  static getType() {
    return "tab";
  }
  static clone(t) {
    return new vd(t.__key);
  }
  afterCloneFrom(t) {
    super.afterCloneFrom(t), this.__text = t.__text;
  }
  constructor(t) {
    super("	", t), this.__detail = 2;
  }
  static importDOM() {
    return null;
  }
  static importJSON(t) {
    const n = x_();
    return n.setFormat(t.format), n.setStyle(t.style), n;
  }
  exportJSON() {
    return { ...super.exportJSON(), type: "tab", version: 1 };
  }
  setTextContent(t) {
    _e(126);
  }
  setDetail(t) {
    _e(127);
  }
  setMode(t) {
    _e(128);
  }
  canInsertTextBefore() {
    return !1;
  }
  canInsertTextAfter() {
    return !1;
  }
}
function x_() {
  return $g(new vd());
}
function vJ(e) {
  return e instanceof vd;
}
class bJ {
  constructor(t, n, r) {
    this._selection = null, this.key = t, this.offset = n, this.type = r;
  }
  is(t) {
    return this.key === t.key && this.offset === t.offset && this.type === t.type;
  }
  isBefore(t) {
    let n = this.getNode(), r = t.getNode();
    const i = this.offset, o = t.offset;
    if (ve(n)) {
      const a = n.getDescendantByIndex(i);
      n = a ?? n;
    }
    if (ve(r)) {
      const a = r.getDescendantByIndex(o);
      r = a ?? r;
    }
    return n === r ? i < o : n.isBefore(r);
  }
  getNode() {
    const t = $n(this.key);
    return t === null && _e(20), t;
  }
  set(t, n, r) {
    const i = this._selection, o = this.key;
    this.key = t, this.offset = n, this.type = r, bd() || (Oa() === o && Gn(t), i !== null && (i.setCachedNodes(null), i.dirty = !0));
  }
}
function Wa(e, t, n) {
  return new bJ(e, t, n);
}
function wb(e, t) {
  let n = t.__key, r = e.offset, i = "element";
  if (Se(t)) {
    i = "text";
    const o = t.getTextContentSize();
    r > o && (r = o);
  } else if (!ve(t)) {
    const o = t.getNextSibling();
    if (Se(o)) n = o.__key, r = 0, i = "text";
    else {
      const a = t.getParent();
      a && (n = a.__key, r = t.getIndexWithinParent() + 1);
    }
  }
  e.set(n, r, i);
}
function jC(e, t) {
  if (ve(t)) {
    const n = t.getLastDescendant();
    ve(n) || Se(n) ? wb(e, n) : wb(e, t);
  } else wb(e, t);
}
function wa(e, t, n, r) {
  e.key = t, e.offset = n, e.type = r;
}
let x2 = class w2 {
  constructor(t) {
    this._cachedNodes = null, this._nodes = t, this.dirty = !1;
  }
  getCachedNodes() {
    return this._cachedNodes;
  }
  setCachedNodes(t) {
    this._cachedNodes = t;
  }
  is(t) {
    if (!Rg(t)) return !1;
    const n = this._nodes, r = t._nodes;
    return n.size === r.size && Array.from(n).every((i) => r.has(i));
  }
  isCollapsed() {
    return !1;
  }
  isBackward() {
    return !1;
  }
  getStartEndPoints() {
    return null;
  }
  add(t) {
    this.dirty = !0, this._nodes.add(t), this._cachedNodes = null;
  }
  delete(t) {
    this.dirty = !0, this._nodes.delete(t), this._cachedNodes = null;
  }
  clear() {
    this.dirty = !0, this._nodes.clear(), this._cachedNodes = null;
  }
  has(t) {
    return this._nodes.has(t);
  }
  clone() {
    return new w2(new Set(this._nodes));
  }
  extract() {
    return this.getNodes();
  }
  insertRawText(t) {
  }
  insertText() {
  }
  insertNodes(t) {
    const n = this.getNodes(), r = n.length, i = n[r - 1];
    let o;
    if (Se(i)) o = i.select();
    else {
      const a = i.getIndexWithinParent() + 1;
      o = i.getParentOrThrow().select(a, a);
    }
    o.insertNodes(t);
    for (let a = 0; a < r; a++) n[a].remove();
  }
  getNodes() {
    const t = this._cachedNodes;
    if (t !== null) return t;
    const n = this._nodes, r = [];
    for (const i of n) {
      const o = $n(i);
      o !== null && r.push(o);
    }
    return bd() || (this._cachedNodes = r), r;
  }
  getTextContent() {
    const t = this.getNodes();
    let n = "";
    for (let r = 0; r < t.length; r++) n += t[r].getTextContent();
    return n;
  }
};
function we(e) {
  return e instanceof qs;
}
class qs {
  constructor(t, n, r, i) {
    this.anchor = t, this.focus = n, t._selection = this, n._selection = this, this._cachedNodes = null, this.format = r, this.style = i, this.dirty = !1;
  }
  getCachedNodes() {
    return this._cachedNodes;
  }
  setCachedNodes(t) {
    this._cachedNodes = t;
  }
  is(t) {
    return !!we(t) && this.anchor.is(t.anchor) && this.focus.is(t.focus) && this.format === t.format && this.style === t.style;
  }
  isCollapsed() {
    return this.anchor.is(this.focus);
  }
  getNodes() {
    const t = this._cachedNodes;
    if (t !== null) return t;
    const n = this.anchor, r = this.focus, i = n.isBefore(r), o = i ? n : r, a = i ? r : n;
    let s = o.getNode(), l = a.getNode();
    const c = o.offset, f = a.offset;
    if (ve(s)) {
      const p = s.getDescendantByIndex(c);
      s = p ?? s;
    }
    if (ve(l)) {
      let p = l.getDescendantByIndex(f);
      p !== null && p !== s && l.getChildAtIndex(f) === p && (p = p.getPreviousSibling()), l = p ?? l;
    }
    let d;
    return d = s.is(l) ? ve(s) && s.getChildrenSize() > 0 ? [] : [s] : s.getNodesBetween(l), bd() || (this._cachedNodes = d), d;
  }
  setTextNodeRange(t, n, r, i) {
    wa(this.anchor, t.__key, n, "text"), wa(this.focus, r.__key, i, "text"), this._cachedNodes = null, this.dirty = !0;
  }
  getTextContent() {
    const t = this.getNodes();
    if (t.length === 0) return "";
    const n = t[0], r = t[t.length - 1], i = this.anchor, o = this.focus, a = i.isBefore(o), [s, l] = rx(this);
    let c = "", f = !0;
    for (let d = 0; d < t.length; d++) {
      const p = t[d];
      if (ve(p) && !p.isInline()) f || (c += `
`), f = !p.isEmpty();
      else if (f = !1, Se(p)) {
        let m = p.getTextContent();
        p === n ? p === r ? i.type === "element" && o.type === "element" && o.offset !== i.offset || (m = s < l ? m.slice(s, l) : m.slice(l, s)) : m = a ? m.slice(s) : m.slice(l) : p === r && (m = a ? m.slice(0, l) : m.slice(0, s)), c += m;
      } else !Ht(p) && !Ju(p) || p === r && this.isCollapsed() || (c += p.getTextContent());
    }
    return c;
  }
  applyDOMRange(t) {
    const n = mn(), r = n.getEditorState()._selection, i = S2(t.startContainer, t.startOffset, t.endContainer, t.endOffset, n, r);
    if (i === null) return;
    const [o, a] = i;
    wa(this.anchor, o.key, o.offset, o.type), wa(this.focus, a.key, a.offset, a.type), this._cachedNodes = null;
  }
  clone() {
    const t = this.anchor, n = this.focus;
    return new qs(Wa(t.key, t.offset, t.type), Wa(n.key, n.offset, n.type), this.format, this.style);
  }
  toggleFormat(t) {
    this.format = V0(this.format, t, null), this.dirty = !0;
  }
  setStyle(t) {
    this.style = t, this.dirty = !0;
  }
  hasFormat(t) {
    const n = Io[t];
    return !!(this.format & n);
  }
  insertRawText(t) {
    const n = t.split(/(\r?\n|\t)/), r = [], i = n.length;
    for (let o = 0; o < i; o++) {
      const a = n[o];
      a === `
` || a === `\r
` ? r.push(Af()) : a === "	" ? r.push(x_()) : r.push(Vn(a));
    }
    this.insertNodes(r);
  }
  insertText(t) {
    const n = this.anchor, r = this.focus, i = this.format, o = this.style;
    let a = n, s = r;
    !this.isCollapsed() && r.isBefore(n) && (a = r, s = n), a.type === "element" && function(v, x, w, S) {
      const A = v.getNode(), _ = A.getChildAtIndex(v.offset), O = Vn(), P = ur(A) ? Ro().append(O) : O;
      O.setFormat(w), O.setStyle(S), _ === null ? A.append(P) : _.insertBefore(P), v.is(x) && x.set(O.__key, 0, "text"), v.set(O.__key, 0, "text");
    }(a, s, i, o);
    const l = a.offset;
    let c = s.offset;
    const f = this.getNodes(), d = f.length;
    let p = f[0];
    Se(p) || _e(26);
    const m = p.getTextContent().length, y = p.getParentOrThrow();
    let g = f[d - 1];
    if (d === 1 && s.type === "element" && (c = m, s.set(a.key, c, "text")), this.isCollapsed() && l === m && (p.isSegmented() || p.isToken() || !p.canInsertTextAfter() || !y.canInsertTextAfter() && p.getNextSibling() === null)) {
      let v = p.getNextSibling();
      if (Se(v) && v.canInsertTextBefore() && !Pl(v) || (v = Vn(), v.setFormat(i), v.setStyle(o), y.canInsertTextAfter() ? p.insertAfter(v) : y.insertAfter(v)), v.select(0, 0), p = v, t !== "") return void this.insertText(t);
    } else if (this.isCollapsed() && l === 0 && (p.isSegmented() || p.isToken() || !p.canInsertTextBefore() || !y.canInsertTextBefore() && p.getPreviousSibling() === null)) {
      let v = p.getPreviousSibling();
      if (Se(v) && !Pl(v) || (v = Vn(), v.setFormat(i), y.canInsertTextBefore() ? p.insertBefore(v) : y.insertBefore(v)), v.select(), p = v, t !== "") return void this.insertText(t);
    } else if (p.isSegmented() && l !== m) {
      const v = Vn(p.getTextContent());
      v.setFormat(i), p.replace(v), p = v;
    } else if (!this.isCollapsed() && t !== "") {
      const v = g.getParent();
      if (!y.canInsertTextBefore() || !y.canInsertTextAfter() || ve(v) && (!v.canInsertTextBefore() || !v.canInsertTextAfter())) return this.insertText(""), _2(this.anchor, this.focus, null), void this.insertText(t);
    }
    if (d === 1) {
      if (p.isToken()) {
        const S = Vn(t);
        return S.select(), void p.replace(S);
      }
      const v = p.getFormat(), x = p.getStyle();
      if (l !== c || v === i && x === o) {
        if (vJ(p)) {
          const S = Vn(t);
          return S.setFormat(i), S.setStyle(o), S.select(), void p.replace(S);
        }
      } else {
        if (p.getTextContent() !== "") {
          const S = Vn(t);
          if (S.setFormat(i), S.setStyle(o), S.select(), l === 0) p.insertBefore(S, !1);
          else {
            const [A] = p.splitText(l);
            A.insertAfter(S, !1);
          }
          return void (S.isComposing() && this.anchor.type === "text" && (this.anchor.offset -= t.length));
        }
        p.setFormat(i), p.setStyle(o);
      }
      const w = c - l;
      p = p.spliceText(l, w, t, !0), p.getTextContent() === "" ? p.remove() : this.anchor.type === "text" && (p.isComposing() ? this.anchor.offset -= t.length : (this.format = v, this.style = x));
    } else {
      const v = /* @__PURE__ */ new Set([...p.getParentKeys(), ...g.getParentKeys()]), x = ve(p) ? p : p.getParentOrThrow();
      let w = ve(g) ? g : g.getParentOrThrow(), S = g;
      if (!x.is(w) && w.isInline()) do
        S = w, w = w.getParentOrThrow();
      while (w.isInline());
      if (s.type === "text" && (c !== 0 || g.getTextContent() === "") || s.type === "element" && g.getIndexWithinParent() < c) if (Se(g) && !g.isToken() && c !== g.getTextContentSize()) {
        if (g.isSegmented()) {
          const C = Vn(g.getTextContent());
          g.replace(C), g = C;
        }
        ur(s.getNode()) || s.type !== "text" || (g = g.spliceText(0, c, "")), v.add(g.__key);
      } else {
        const C = g.getParentOrThrow();
        C.canBeEmpty() || C.getChildrenSize() !== 1 ? g.remove() : C.remove();
      }
      else v.add(g.__key);
      const A = w.getChildren(), _ = new Set(f), O = x.is(w), P = x.isInline() && p.getNextSibling() === null ? x : p;
      for (let C = A.length - 1; C >= 0; C--) {
        const k = A[C];
        if (k.is(p) || ve(k) && k.isParentOf(p)) break;
        k.isAttached() && (!_.has(k) || k.is(S) ? O || P.insertAfter(k, !1) : k.remove());
      }
      if (!O) {
        let C = w, k = null;
        for (; C !== null; ) {
          const I = C.getChildren(), $ = I.length;
          ($ === 0 || I[$ - 1].is(k)) && (v.delete(C.__key), k = C), C = C.getParent();
        }
      }
      if (p.isToken()) if (l === m) p.select();
      else {
        const C = Vn(t);
        C.select(), p.replace(C);
      }
      else p = p.spliceText(l, m - l, t, !0), p.getTextContent() === "" ? p.remove() : p.isComposing() && this.anchor.type === "text" && (this.anchor.offset -= t.length);
      for (let C = 1; C < d; C++) {
        const k = f[C], I = k.__key;
        v.has(I) || k.remove();
      }
    }
  }
  removeText() {
    this.insertText("");
  }
  formatText(t) {
    if (this.isCollapsed()) return this.toggleFormat(t), void Gn(null);
    const n = this.getNodes(), r = [];
    for (const w of n) Se(w) && r.push(w);
    const i = r.length;
    if (i === 0) return this.toggleFormat(t), void Gn(null);
    const o = this.anchor, a = this.focus, s = this.isBackward(), l = s ? a : o, c = s ? o : a;
    let f = 0, d = r[0], p = l.type === "element" ? 0 : l.offset;
    if (l.type === "text" && p === d.getTextContentSize() && (f = 1, d = r[1], p = 0), d == null) return;
    const m = d.getFormatFlags(t, null), y = i - 1;
    let g = r[y];
    const v = c.type === "text" ? c.offset : g.getTextContentSize();
    if (d.is(g)) {
      if (p === v) return;
      if (Pl(d) || p === 0 && v === d.getTextContentSize()) d.setFormat(m);
      else {
        const w = d.splitText(p, v), S = p === 0 ? w[0] : w[1];
        S.setFormat(m), l.type === "text" && l.set(S.__key, 0, "text"), c.type === "text" && c.set(S.__key, v - p, "text");
      }
      return void (this.format = m);
    }
    p === 0 || Pl(d) || ([, d] = d.splitText(p), p = 0), d.setFormat(m);
    const x = g.getFormatFlags(t, m);
    v > 0 && (v === g.getTextContentSize() || Pl(g) || ([g] = g.splitText(v)), g.setFormat(x));
    for (let w = f + 1; w < y; w++) {
      const S = r[w], A = S.getFormatFlags(t, x);
      S.setFormat(A);
    }
    l.type === "text" && l.set(d.__key, p, "text"), c.type === "text" && c.set(g.__key, v, "text"), this.format = m | x;
  }
  insertNodes(t) {
    if (t.length === 0) return;
    if (this.anchor.key === "root") {
      this.insertParagraph();
      const m = Ne();
      return we(m) || _e(134), m.insertNodes(t);
    }
    const n = gb((this.isBackward() ? this.focus : this.anchor).getNode(), Cl), r = t[t.length - 1];
    if ("__language" in n && ve(n)) {
      if ("__language" in t[0]) this.insertText(t[0].getTextContent());
      else {
        const m = _b(this);
        n.splice(m, 0, t), r.selectEnd();
      }
      return;
    }
    if (!t.some((m) => (ve(m) || Ht(m)) && !m.isInline())) {
      ve(n) || _e(135);
      const m = _b(this);
      return n.splice(m, 0, t), void r.selectEnd();
    }
    const i = function(m) {
      const y = Ro();
      let g = null;
      for (let v = 0; v < m.length; v++) {
        const x = m[v], w = Ju(x);
        if (w || Ht(x) && x.isInline() || ve(x) && x.isInline() || Se(x) || x.isParentRequired()) {
          if (g === null && (g = x.createParentElementNode(), y.append(g), w)) continue;
          g !== null && g.append(x);
        } else y.append(x), g = null;
      }
      return y;
    }(t), o = i.getLastDescendant(), a = i.getChildren(), s = !ve(n) || !n.isEmpty() ? this.insertParagraph() : null, l = a[a.length - 1];
    let c = a[0];
    var f;
    ve(f = c) && Cl(f) && !f.isEmpty() && ve(n) && (!n.isEmpty() || n.canMergeWhenEmpty()) && (ve(n) || _e(135), n.append(...c.getChildren()), c = a[1]), c && function(m, y, g) {
      const v = y.getParentOrThrow().getLastChild();
      let x = y;
      const w = [y];
      for (; x !== v; ) x.getNextSibling() || _e(140), x = x.getNextSibling(), w.push(x);
      let S = m;
      for (const A of w) S = S.insertAfter(A);
    }(n, c);
    const d = gb(o, Cl);
    s && ve(d) && (s.canMergeWhenEmpty() || Cl(l)) && (d.append(...s.getChildren()), s.remove()), ve(n) && n.isEmpty() && n.remove(), o.selectEnd();
    const p = ve(n) ? n.getLastChild() : null;
    Ju(p) && d !== n && p.remove();
  }
  insertParagraph() {
    if (this.anchor.key === "root") {
      const a = Ro();
      return ir().splice(this.anchor.offset, 0, [a]), a.select(), a;
    }
    const t = _b(this), n = gb(this.anchor.getNode(), Cl);
    ve(n) || _e(136);
    const r = n.getChildAtIndex(t), i = r ? [r, ...r.getNextSiblings()] : [], o = n.insertNewAfter(this, !1);
    return o ? (o.append(...i), o.selectStart(), o) : null;
  }
  insertLineBreak(t) {
    const n = Af();
    if (this.insertNodes([n]), t) {
      const r = n.getParentOrThrow(), i = n.getIndexWithinParent();
      r.select(i, i);
    }
  }
  extract() {
    const t = this.getNodes(), n = t.length, r = n - 1, i = this.anchor, o = this.focus;
    let a = t[0], s = t[r];
    const [l, c] = rx(this);
    if (n === 0) return [];
    if (n === 1) {
      if (Se(a) && !this.isCollapsed()) {
        const d = l > c ? c : l, p = l > c ? l : c, m = a.splitText(d, p), y = d === 0 ? m[0] : m[1];
        return y != null ? [y] : [];
      }
      return [a];
    }
    const f = i.isBefore(o);
    if (Se(a)) {
      const d = f ? l : c;
      d === a.getTextContentSize() ? t.shift() : d !== 0 && ([, a] = a.splitText(d), t[0] = a);
    }
    if (Se(s)) {
      const d = s.getTextContent().length, p = f ? c : l;
      p === 0 ? t.pop() : p !== d && ([s] = s.splitText(p), t[r] = s);
    }
    return t;
  }
  modify(t, n, r) {
    const i = this.focus, o = this.anchor, a = t === "move", s = U0(i, n);
    if (Ht(s) && !s.isIsolated()) {
      if (a && s.isKeyboardSelectable()) {
        const m = zC();
        return m.add(s.__key), void Vo(m);
      }
      const p = n ? s.getPreviousSibling() : s.getNextSibling();
      if (Se(p)) {
        const m = p.__key, y = n ? p.getTextContent().length : 0;
        return i.set(m, y, "text"), void (a && o.set(m, y, "text"));
      }
      {
        const m = s.getParentOrThrow();
        let y, g;
        return ve(p) ? (g = p.__key, y = n ? p.getChildrenSize() : 0) : (y = s.getIndexWithinParent(), g = m.__key, n || y++), i.set(g, y, "element"), void (a && o.set(g, y, "element"));
      }
    }
    const l = mn(), c = no(l._window);
    if (!c) return;
    const f = l._blockCursorElement, d = l._rootElement;
    if (d === null || f === null || !ve(s) || s.isInline() || s.canBeEmpty() || y_(f, l, d), function(p, m, y, g) {
      p.modify(m, y, g);
    }(c, t, n ? "backward" : "forward", r), c.rangeCount > 0) {
      const p = c.getRangeAt(0), m = this.anchor.getNode(), y = ur(m) ? m : rJ(m);
      if (this.applyDOMRange(p), this.dirty = !0, !a) {
        const g = this.getNodes(), v = [];
        let x = !1;
        for (let w = 0; w < g.length; w++) {
          const S = g[w];
          H0(S, y) ? v.push(S) : x = !0;
        }
        if (x && v.length > 0) if (n) {
          const w = v[0];
          ve(w) ? w.selectStart() : w.getParentOrThrow().selectStart();
        } else {
          const w = v[v.length - 1];
          ve(w) ? w.selectEnd() : w.getParentOrThrow().selectEnd();
        }
        c.anchorNode === p.startContainer && c.anchorOffset === p.startOffset || function(w) {
          const S = w.focus, A = w.anchor, _ = A.key, O = A.offset, P = A.type;
          wa(A, S.key, S.offset, S.type), wa(S, _, O, P), w._cachedNodes = null;
        }(this);
      }
    }
  }
  forwardDeletion(t, n, r) {
    if (!r && (t.type === "element" && ve(n) && t.offset === n.getChildrenSize() || t.type === "text" && t.offset === n.getTextContentSize())) {
      const i = n.getParent(), o = n.getNextSibling() || (i === null ? null : i.getNextSibling());
      if (ve(o) && o.isShadowRoot()) return !0;
    }
    return !1;
  }
  deleteCharacter(t) {
    const n = this.isCollapsed();
    if (this.isCollapsed()) {
      const r = this.anchor;
      let i = r.getNode();
      if (this.forwardDeletion(r, i, t)) return;
      const o = this.focus, a = U0(o, t);
      if (Ht(a) && !a.isIsolated()) {
        if (a.isKeyboardSelectable() && ve(i) && i.getChildrenSize() === 0) {
          i.remove();
          const s = zC();
          s.add(a.__key), Vo(s);
        } else
          a.remove(), mn().dispatchCommand(G1, void 0);
        return;
      }
      if (!t && ve(a) && ve(i) && i.isEmpty()) return i.remove(), void a.selectStart();
      if (this.modify("extend", t, "character"), this.isCollapsed()) {
        if (t && r.offset === 0 && (r.type === "element" ? r.getNode() : r.getNode().getParentOrThrow()).collapseAtStart(this))
          return;
      } else {
        const s = o.type === "text" ? o.getNode() : null;
        if (i = r.type === "text" ? r.getNode() : null, s !== null && s.isSegmented()) {
          const l = o.offset, c = s.getTextContentSize();
          if (s.is(i) || t && l !== c || !t && l !== 0) return void BC(s, t, l);
        } else if (i !== null && i.isSegmented()) {
          const l = r.offset, c = i.getTextContentSize();
          if (i.is(s) || t && l !== 0 || !t && l !== c) return void BC(i, t, l);
        }
        (function(l, c) {
          const f = l.anchor, d = l.focus, p = f.getNode(), m = d.getNode();
          if (p === m && f.type === "text" && d.type === "text") {
            const y = f.offset, g = d.offset, v = y < g, x = v ? y : g, w = v ? g : y, S = w - 1;
            x !== S && (QR(p.getTextContent().slice(x, w)) || (c ? d.offset = S : f.offset = S));
          }
        })(this, t);
      }
    }
    if (this.removeText(), t && !n && this.isCollapsed() && this.anchor.type === "element" && this.anchor.offset === 0) {
      const r = this.anchor.getNode();
      r.isEmpty() && ur(r.getParent()) && r.getIndexWithinParent() === 0 && r.collapseAtStart(this);
    }
  }
  deleteLine(t) {
    if (this.isCollapsed()) {
      const n = this.anchor.type === "element";
      if (n && this.insertText(" "), this.modify("extend", t, "lineboundary"), (t ? this.focus : this.anchor).offset === 0 && this.modify("extend", t, "character"), n) {
        const r = t ? this.anchor : this.focus;
        r.set(r.key, r.offset + 1, r.type);
      }
    }
    this.removeText();
  }
  deleteWord(t) {
    if (this.isCollapsed()) {
      const n = this.anchor, r = n.getNode();
      if (this.forwardDeletion(n, r, t)) return;
      this.modify("extend", t, "word");
    }
    this.removeText();
  }
  isBackward() {
    return this.focus.isBefore(this.anchor);
  }
  getStartEndPoints() {
    return [this.anchor, this.focus];
  }
}
function Rg(e) {
  return e instanceof x2;
}
function LC(e) {
  const t = e.offset;
  if (e.type === "text") return t;
  const n = e.getNode();
  return t === n.getChildrenSize() ? n.getTextContent().length : 0;
}
function rx(e) {
  const t = e.getStartEndPoints();
  if (t === null) return [0, 0];
  const [n, r] = t;
  return n.type === "element" && r.type === "element" && n.key === r.key && n.offset === r.offset ? [0, 0] : [LC(n), LC(r)];
}
function BC(e, t, n) {
  const r = e, i = r.getTextContent().split(/(?=\s)/g), o = i.length;
  let a = 0, s = 0;
  for (let c = 0; c < o; c++) {
    const f = c === o - 1;
    if (s = a, a += i[c].length, t && a === n || a > n || f) {
      i.splice(c, 1), f && (s = void 0);
      break;
    }
  }
  const l = i.join("").trim();
  l === "" ? r.remove() : (r.setTextContent(l), r.select(s, s));
}
function FC(e, t, n, r) {
  let i, o = t;
  if (e.nodeType === md) {
    let a = !1;
    const s = e.childNodes, l = s.length, c = r._blockCursorElement;
    o === l && (a = !0, o = l - 1);
    let f = s[o], d = !1;
    if (f === c) f = s[o + 1], d = !0;
    else if (c !== null) {
      const p = c.parentNode;
      e === p && t > Array.prototype.indexOf.call(p.children, c) && o--;
    }
    if (i = jl(f), Se(i)) o = wC(i, a);
    else {
      let p = jl(e);
      if (p === null) return null;
      if (ve(p)) {
        o = Math.min(p.getChildrenSize(), o);
        let m = p.getChildAtIndex(o);
        if (ve(m) && function(y, g, v) {
          const x = y.getParent();
          return v === null || x === null || !x.canBeEmpty() || x !== v.getNode();
        }(m, 0, n)) {
          const y = a ? m.getLastDescendant() : m.getFirstDescendant();
          y === null ? p = m : (m = y, p = ve(m) ? m : m.getParentOrThrow()), o = 0;
        }
        Se(m) ? (i = m, p = null, o = wC(m, a)) : m !== p && a && !d && o++;
      } else {
        const m = p.getIndexWithinParent();
        o = t === 0 && Ht(p) && jl(e) === p ? m : m + 1, p = p.getParentOrThrow();
      }
      if (ve(p)) return Wa(p.__key, o, "element");
    }
  } else i = jl(e);
  return Se(i) ? Wa(i.__key, o, "text") : null;
}
function WC(e, t, n) {
  const r = e.offset, i = e.getNode();
  if (r === 0) {
    const o = i.getPreviousSibling(), a = i.getParent();
    if (t) {
      if ((n || !t) && o === null && ve(a) && a.isInline()) {
        const s = a.getPreviousSibling();
        Se(s) && (e.key = s.__key, e.offset = s.getTextContent().length);
      }
    } else ve(o) && !n && o.isInline() ? (e.key = o.__key, e.offset = o.getChildrenSize(), e.type = "element") : Se(o) && (e.key = o.__key, e.offset = o.getTextContent().length);
  } else if (r === i.getTextContent().length) {
    const o = i.getNextSibling(), a = i.getParent();
    if (t && ve(o) && o.isInline()) e.key = o.__key, e.offset = 0, e.type = "element";
    else if ((n || t) && o === null && ve(a) && a.isInline() && !a.canInsertTextAfter()) {
      const s = a.getNextSibling();
      Se(s) && (e.key = s.__key, e.offset = 0);
    }
  }
}
function _2(e, t, n) {
  if (e.type === "text" && t.type === "text") {
    const r = e.isBefore(t), i = e.is(t);
    WC(e, r, i), WC(t, !r, i), i && (t.key = e.key, t.offset = e.offset, t.type = e.type);
    const o = mn();
    if (o.isComposing() && o._compositionKey !== e.key && we(n)) {
      const a = n.anchor, s = n.focus;
      wa(e, a.key, a.offset, a.type), wa(t, s.key, s.offset, s.type);
    }
  }
}
function S2(e, t, n, r, i, o) {
  if (e === null || n === null || !Pg(i, e, n)) return null;
  const a = FC(e, t, we(o) ? o.anchor : null, i);
  if (a === null) return null;
  const s = FC(n, r, we(o) ? o.focus : null, i);
  if (s === null) return null;
  if (a.type === "element" && s.type === "element") {
    const l = jl(e), c = jl(n);
    if (Ht(l) && Ht(c)) return null;
  }
  return _2(a, s, o), [a, s];
}
function O2(e, t, n, r, i, o) {
  const a = qo(), s = new qs(Wa(e, t, i), Wa(n, r, o), 0, "");
  return s.dirty = !0, a._selection = s, s;
}
function zC() {
  return new x2(/* @__PURE__ */ new Set());
}
function w_(e, t, n, r) {
  const i = n._window;
  if (i === null) return null;
  const o = r || i.event, a = o ? o.type : void 0, s = a === "selectionchange", l = !z0 && (s || a === "beforeinput" || a === "compositionstart" || a === "compositionend" || a === "click" && o && o.detail === 3 || a === "drop" || a === void 0);
  let c, f, d, p;
  if (we(e) && !l) return e.clone();
  if (t === null) return null;
  if (c = t.anchorNode, f = t.focusNode, d = t.anchorOffset, p = t.focusOffset, s && we(e) && !Pg(n, c, f)) return e.clone();
  const m = S2(c, d, f, p, n, e);
  if (m === null) return null;
  const [y, g] = m;
  return new qs(y, g, we(e) ? e.format : 0, we(e) ? e.style : "");
}
function Ne() {
  return qo()._selection;
}
function jg() {
  return mn()._editorState._selection;
}
function Vp(e, t, n, r = 1) {
  const i = e.anchor, o = e.focus, a = i.getNode(), s = o.getNode();
  if (!t.is(a) && !t.is(s)) return;
  const l = t.__key;
  if (e.isCollapsed()) {
    const c = i.offset;
    if (n <= c && r > 0 || n < c && r < 0) {
      const f = Math.max(0, c + r);
      i.set(l, f, "element"), o.set(l, f, "element"), VC(e);
    }
  } else {
    const c = e.isBackward(), f = c ? o : i, d = f.getNode(), p = c ? i : o, m = p.getNode();
    if (t.is(d)) {
      const y = f.offset;
      (n <= y && r > 0 || n < y && r < 0) && f.set(l, Math.max(0, y + r), "element");
    }
    if (t.is(m)) {
      const y = p.offset;
      (n <= y && r > 0 || n < y && r < 0) && p.set(l, Math.max(0, y + r), "element");
    }
  }
  VC(e);
}
function VC(e) {
  const t = e.anchor, n = t.offset, r = e.focus, i = r.offset, o = t.getNode(), a = r.getNode();
  if (e.isCollapsed()) {
    if (!ve(o)) return;
    const s = o.getChildrenSize(), l = n >= s, c = l ? o.getChildAtIndex(s - 1) : o.getChildAtIndex(n);
    if (Se(c)) {
      let f = 0;
      l && (f = c.getTextContentSize()), t.set(c.__key, f, "text"), r.set(c.__key, f, "text");
    }
  } else {
    if (ve(o)) {
      const s = o.getChildrenSize(), l = n >= s, c = l ? o.getChildAtIndex(s - 1) : o.getChildAtIndex(n);
      if (Se(c)) {
        let f = 0;
        l && (f = c.getTextContentSize()), t.set(c.__key, f, "text");
      }
    }
    if (ve(a)) {
      const s = a.getChildrenSize(), l = i >= s, c = l ? a.getChildAtIndex(s - 1) : a.getChildAtIndex(i);
      if (Se(c)) {
        let f = 0;
        l && (f = c.getTextContentSize()), r.set(c.__key, f, "text");
      }
    }
  }
}
function Up(e, t, n, r, i) {
  let o = null, a = 0, s = null;
  r !== null ? (o = r.__key, Se(r) ? (a = r.getTextContentSize(), s = "text") : ve(r) && (a = r.getChildrenSize(), s = "element")) : i !== null && (o = i.__key, Se(i) ? s = "text" : ve(i) && (s = "element")), o !== null && s !== null ? e.set(o, a, s) : (a = t.getIndexWithinParent(), a === -1 && (a = n.getChildrenSize()), e.set(n.__key, a, "element"));
}
function UC(e, t, n, r, i) {
  e.type === "text" ? (e.key = n, t || (e.offset += i)) : e.offset > r.getIndexWithinParent() && (e.offset -= 1);
}
function xJ(e, t, n, r, i, o, a) {
  const s = r.anchorNode, l = r.focusNode, c = r.anchorOffset, f = r.focusOffset, d = document.activeElement;
  if (i.has("collaboration") && d !== o || d !== null && YR(d)) return;
  if (!we(t)) return void (e !== null && Pg(n, s, l) && r.removeAllRanges());
  const p = t.anchor, m = t.focus, y = p.key, g = m.key, v = Lp(n, y), x = Lp(n, g), w = p.offset, S = m.offset, A = t.format, _ = t.style, O = t.isCollapsed();
  let P = v, C = x, k = !1;
  if (p.type === "text") {
    P = Rp(v);
    const F = p.getNode();
    k = F.getFormat() !== A || F.getStyle() !== _;
  } else we(e) && e.anchor.type === "text" && (k = !0);
  var I, $, N, D, j;
  if (m.type === "text" && (C = Rp(x)), P !== null && C !== null && (O && (e === null || k || we(e) && (e.format !== A || e.style !== _)) && (I = A, $ = _, N = w, D = y, j = performance.now(), h2 = [I, $, N, D, j]), c !== w || f !== S || s !== P || l !== C || r.type === "Range" && O || (d !== null && o.contains(d) || o.focus({ preventScroll: !0 }), p.type === "element"))) {
    try {
      r.setBaseAndExtent(P, w, C, S);
    } catch {
    }
    if (!i.has("skip-scroll-into-view") && t.isCollapsed() && o !== null && o === document.activeElement) {
      const F = t instanceof qs && t.anchor.type === "element" ? P.childNodes[w] || null : r.rangeCount > 0 ? r.getRangeAt(0) : null;
      if (F !== null) {
        let W;
        if (F instanceof Text) {
          const z = document.createRange();
          z.selectNode(F), W = z.getBoundingClientRect();
        } else W = F.getBoundingClientRect();
        (function(z, H, U) {
          const V = U.ownerDocument, Y = V.defaultView;
          if (Y === null) return;
          let { top: Q, bottom: ne } = H, re = 0, ce = 0, oe = U;
          for (; oe !== null; ) {
            const fe = oe === V.body;
            if (fe) re = 0, ce = Ng(z).innerHeight;
            else {
              const ee = oe.getBoundingClientRect();
              re = ee.top, ce = ee.bottom;
            }
            let ae = 0;
            if (Q < re ? ae = -(re - Q) : ne > ce && (ae = ne - ce), ae !== 0) if (fe) Y.scrollBy(0, ae);
            else {
              const ee = oe.scrollTop;
              oe.scrollTop += ae;
              const se = oe.scrollTop - ee;
              Q -= se, ne -= se;
            }
            if (fe) break;
            oe = Mg(oe);
          }
        })(n, W, o);
      }
    }
    ex = !0;
  }
}
function _b(e) {
  let t = e;
  e.isCollapsed() || t.removeText();
  const n = Ne();
  we(n) && (t = n), we(t) || _e(161);
  const r = t.anchor;
  let i = r.getNode(), o = r.offset;
  for (; !Cl(i); ) [i, o] = wJ(i, o);
  return o;
}
function wJ(e, t) {
  const n = e.getParent();
  if (!n) {
    const i = Ro();
    return ir().append(i), i.select(), [ir(), 0];
  }
  if (Se(e)) {
    const i = e.splitText(t);
    if (i.length === 0) return [n, e.getIndexWithinParent()];
    const o = t === 0 ? 0 : 1;
    return [n, i[0].getIndexWithinParent() + o];
  }
  if (!ve(e) || t === 0) return [n, e.getIndexWithinParent()];
  const r = e.getChildAtIndex(t);
  if (r) {
    const i = new qs(Wa(e.__key, t, "element"), Wa(e.__key, t, "element"), 0, ""), o = e.insertNewAfter(i);
    o && o.append(r, ...r.getNextSiblings());
  }
  return [n, e.getIndexWithinParent() + 1];
}
let Dn = null, In = null, Ar = !1, Sb = !1, fp = 0;
const HC = { characterData: !0, childList: !0, subtree: !0 };
function bd() {
  return Ar || Dn !== null && Dn._readOnly;
}
function wr() {
  Ar && _e(13);
}
function A2() {
  fp > 99 && _e(14);
}
function qo() {
  return Dn === null && _e(195, T2()), Dn;
}
function mn() {
  return In === null && _e(196, T2()), In;
}
function T2() {
  let e = 0;
  const t = /* @__PURE__ */ new Set(), n = Fg.version;
  if (typeof window < "u") for (const i of document.querySelectorAll("[contenteditable]")) {
    const o = Cg(i);
    if (d_(o)) e++;
    else if (o) {
      let a = String(o.constructor.version || "<0.17.1");
      a === n && (a += " (separately built, likely a bundler configuration issue)"), t.add(a);
    }
  }
  let r = ` Detected on the page: ${e} compatible editor(s) with version ${n}`;
  return t.size && (r += ` and incompatible editors with versions ${Array.from(t).join(", ")}`), r;
}
function _J() {
  return In;
}
function KC(e, t, n) {
  const r = t.__type, i = function(s, l) {
    const c = s._nodes.get(l);
    return c === void 0 && _e(30, l), c;
  }(e, r);
  let o = n.get(r);
  o === void 0 && (o = Array.from(i.transforms), n.set(r, o));
  const a = o.length;
  for (let s = 0; s < a && (o[s](t), t.isAttached()); s++) ;
}
function GC(e, t) {
  return e !== void 0 && e.__key !== t && e.isAttached();
}
function P2(e, t) {
  const n = e.type, r = t.get(n);
  r === void 0 && _e(17, n);
  const i = r.klass;
  e.type !== i.getType() && _e(18, i.name);
  const o = i.importJSON(e), a = e.children;
  if (ve(o) && Array.isArray(a)) for (let s = 0; s < a.length; s++) {
    const l = P2(a[s], t);
    o.append(l);
  }
  return o;
}
function YC(e, t, n) {
  const r = Dn, i = Ar, o = In;
  Dn = t, Ar = !0, In = e;
  try {
    return n();
  } finally {
    Dn = r, Ar = i, In = o;
  }
}
function Aa(e, t) {
  const n = e._pendingEditorState, r = e._rootElement, i = e._headless || r === null;
  if (n === null) return;
  const o = e._editorState, a = o._selection, s = n._selection, l = e._dirtyType !== Ls, c = Dn, f = Ar, d = In, p = e._updating, m = e._observer;
  let y = null;
  if (e._pendingEditorState = null, e._editorState = n, !i && l && m !== null) {
    In = e, Dn = n, Ar = !1, e._updating = !0;
    try {
      const O = e._dirtyType, P = e._dirtyElements, C = e._dirtyLeaves;
      m.disconnect(), y = uJ(o, n, e, O, P, C);
    } catch (O) {
      if (O instanceof Error && e._onError(O), Sb) throw O;
      return N2(e, null, r, n), GR(e), e._dirtyType = nc, Sb = !0, Aa(e, o), void (Sb = !1);
    } finally {
      m.observe(r, HC), e._updating = p, Dn = c, Ar = f, In = d;
    }
  }
  n._readOnly || (n._readOnly = !0);
  const g = e._dirtyLeaves, v = e._dirtyElements, x = e._normalizedNodes, w = e._updateTags, S = e._deferred;
  l && (e._dirtyType = Ls, e._cloneNotNeeded.clear(), e._dirtyLeaves = /* @__PURE__ */ new Set(), e._dirtyElements = /* @__PURE__ */ new Map(), e._normalizedNodes = /* @__PURE__ */ new Set(), e._updateTags = /* @__PURE__ */ new Set()), function(O, P) {
    const C = O._decorators;
    let k = O._pendingDecorators || C;
    const I = P._nodeMap;
    let $;
    for ($ in k) I.has($) || (k === C && (k = ZR(O)), delete k[$]);
  }(e, n);
  const A = i ? null : no(e._window);
  if (e._editable && A !== null && (l || s === null || s.dirty)) {
    In = e, Dn = n;
    try {
      if (m !== null && m.disconnect(), l || s === null || s.dirty) {
        const O = e._blockCursorElement;
        O !== null && y_(O, e, r), xJ(a, s, e, A, w, r);
      }
      iJ(e, r, s), m !== null && m.observe(r, HC);
    } finally {
      In = d, Dn = c;
    }
  }
  y !== null && function(O, P, C, k, I) {
    const $ = Array.from(O._listeners.mutation), N = $.length;
    for (let D = 0; D < N; D++) {
      const [j, F] = $[D], W = P.get(F);
      W !== void 0 && j(W, { dirtyLeaves: k, prevEditorState: I, updateTags: C });
    }
  }(e, y, w, g, o), we(s) || s === null || a !== null && a.is(s) || e.dispatchCommand(G1, void 0);
  const _ = e._pendingDecorators;
  _ !== null && (e._decorators = _, e._pendingDecorators = null, Qu("decorator", e, !0, _)), function(O, P, C) {
    const k = xC(P), I = xC(C);
    k !== I && Qu("textcontent", O, !0, I);
  }(e, t || o, n), Qu("update", e, !0, { dirtyElements: v, dirtyLeaves: g, editorState: n, normalizedNodes: x, prevEditorState: t || o, tags: w }), function(O, P) {
    if (O._deferred = [], P.length !== 0) {
      const C = O._updating;
      O._updating = !0;
      try {
        for (let k = 0; k < P.length; k++) P[k]();
      } finally {
        O._updating = C;
      }
    }
  }(e, S), function(O) {
    const P = O._updates;
    if (P.length !== 0) {
      const C = P.shift();
      if (C) {
        const [k, I] = C;
        E2(O, k, I);
      }
    }
  }(e);
}
function Qu(e, t, n, ...r) {
  const i = t._updating;
  t._updating = n;
  try {
    const o = Array.from(t._listeners[e]);
    for (let a = 0; a < o.length; a++) o[a].apply(null, r);
  } finally {
    t._updating = i;
  }
}
function C2(e, t, n) {
  if (e._updating === !1 || In !== e) {
    let i = !1;
    return e.update(() => {
      i = C2(e, t, n);
    }), i;
  }
  const r = h_(e);
  for (let i = 4; i >= 0; i--) for (let o = 0; o < r.length; o++) {
    const a = r[o]._commands.get(t);
    if (a !== void 0) {
      const s = a[i];
      if (s !== void 0) {
        const l = Array.from(s), c = l.length;
        for (let f = 0; f < c; f++) if (l[f](n, e) === !0) return !0;
      }
    }
  }
  return !1;
}
function qC(e, t) {
  const n = e._updates;
  let r = t || !1;
  for (; n.length !== 0; ) {
    const i = n.shift();
    if (i) {
      const [o, a] = i;
      let s, l;
      if (a !== void 0) {
        if (s = a.onUpdate, l = a.tag, a.skipTransforms && (r = !0), a.discrete) {
          const c = e._pendingEditorState;
          c === null && _e(191), c._flushSync = !0;
        }
        s && e._deferred.push(s), l && e._updateTags.add(l);
      }
      o();
    }
  }
  return r;
}
function E2(e, t, n) {
  const r = e._updateTags;
  let i, o, a = !1, s = !1;
  n !== void 0 && (i = n.onUpdate, o = n.tag, o != null && r.add(o), a = n.skipTransforms || !1, s = n.discrete || !1), i && e._deferred.push(i);
  const l = e._editorState;
  let c = e._pendingEditorState, f = !1;
  (c === null || c._readOnly) && (c = e._pendingEditorState = new Bg(new Map((c || l)._nodeMap)), f = !0), c._flushSync = s;
  const d = Dn, p = Ar, m = In, y = e._updating;
  Dn = c, Ar = !1, e._updating = !0, In = e;
  try {
    f && (e._headless ? l._selection !== null && (c._selection = l._selection.clone()) : c._selection = function(w) {
      const S = w.getEditorState()._selection, A = no(w._window);
      return we(S) || S == null ? w_(S, A, w, null) : S.clone();
    }(e));
    const v = e._compositionKey;
    t(), a = qC(e, a), function(w, S) {
      const A = S.getEditorState()._selection, _ = w._selection;
      if (we(_)) {
        const O = _.anchor, P = _.focus;
        let C;
        if (O.type === "text" && (C = O.getNode(), C.selectionTransform(A, _)), P.type === "text") {
          const k = P.getNode();
          C !== k && k.selectionTransform(A, _);
        }
      }
    }(c, e), e._dirtyType !== Ls && (a ? function(w, S) {
      const A = S._dirtyLeaves, _ = w._nodeMap;
      for (const O of A) {
        const P = _.get(O);
        Se(P) && P.isAttached() && P.isSimpleText() && !P.isUnmergeable() && vC(P);
      }
    }(c, e) : function(w, S) {
      const A = S._dirtyLeaves, _ = S._dirtyElements, O = w._nodeMap, P = Oa(), C = /* @__PURE__ */ new Map();
      let k = A, I = k.size, $ = _, N = $.size;
      for (; I > 0 || N > 0; ) {
        if (I > 0) {
          S._dirtyLeaves = /* @__PURE__ */ new Set();
          for (const D of k) {
            const j = O.get(D);
            Se(j) && j.isAttached() && j.isSimpleText() && !j.isUnmergeable() && vC(j), j !== void 0 && GC(j, P) && KC(S, j, C), A.add(D);
          }
          if (k = S._dirtyLeaves, I = k.size, I > 0) {
            fp++;
            continue;
          }
        }
        S._dirtyLeaves = /* @__PURE__ */ new Set(), S._dirtyElements = /* @__PURE__ */ new Map();
        for (const D of $) {
          const j = D[0], F = D[1];
          if (j !== "root" && !F) continue;
          const W = O.get(j);
          W !== void 0 && GC(W, P) && KC(S, W, C), _.set(j, F);
        }
        k = S._dirtyLeaves, I = k.size, $ = S._dirtyElements, N = $.size, fp++;
      }
      S._dirtyLeaves = A, S._dirtyElements = _;
    }(c, e), qC(e), function(w, S, A, _) {
      const O = w._nodeMap, P = S._nodeMap, C = [];
      for (const [k] of _) {
        const I = P.get(k);
        I !== void 0 && (I.isAttached() || (ve(I) && i2(I, k, O, P, C, _), O.has(k) || _.delete(k), C.push(k)));
      }
      for (const k of C) P.delete(k);
      for (const k of A) {
        const I = P.get(k);
        I === void 0 || I.isAttached() || (O.has(k) || A.delete(k), P.delete(k));
      }
    }(l, c, e._dirtyLeaves, e._dirtyElements)), v !== e._compositionKey && (c._flushSync = !0);
    const x = c._selection;
    if (we(x)) {
      const w = c._nodeMap, S = x.anchor.key, A = x.focus.key;
      w.get(S) !== void 0 && w.get(A) !== void 0 || _e(19);
    } else Rg(x) && x._nodes.size === 0 && (c._selection = null);
  } catch (v) {
    return v instanceof Error && e._onError(v), e._pendingEditorState = l, e._dirtyType = nc, e._cloneNotNeeded.clear(), e._dirtyLeaves = /* @__PURE__ */ new Set(), e._dirtyElements.clear(), void Aa(e);
  } finally {
    Dn = d, Ar = p, In = m, e._updating = y, fp = 0;
  }
  e._dirtyType !== Ls || function(v, x) {
    const w = x.getEditorState()._selection, S = v._selection;
    if (S !== null) {
      if (S.dirty || !S.is(w)) return !0;
    } else if (w !== null) return !0;
    return !1;
  }(c, e) ? c._flushSync ? (c._flushSync = !1, Aa(e)) : f && JZ(() => {
    Aa(e);
  }) : (c._flushSync = !1, f && (r.clear(), e._deferred = [], e._pendingEditorState = null));
}
function Fr(e, t, n) {
  e._updating ? e._updates.push([t, n]) : E2(e, t, n);
}
class Lg extends Ig {
  constructor(t) {
    super(t), this.__first = null, this.__last = null, this.__size = 0, this.__format = 0, this.__style = "", this.__indent = 0, this.__dir = null;
  }
  afterCloneFrom(t) {
    super.afterCloneFrom(t), this.__first = t.__first, this.__last = t.__last, this.__size = t.__size, this.__indent = t.__indent, this.__format = t.__format, this.__style = t.__style, this.__dir = t.__dir;
  }
  getFormat() {
    return this.getLatest().__format;
  }
  getFormatType() {
    const t = this.getFormat();
    return zZ[t] || "";
  }
  getStyle() {
    return this.getLatest().__style;
  }
  getIndent() {
    return this.getLatest().__indent;
  }
  getChildren() {
    const t = [];
    let n = this.getFirstChild();
    for (; n !== null; ) t.push(n), n = n.getNextSibling();
    return t;
  }
  getChildrenKeys() {
    const t = [];
    let n = this.getFirstChild();
    for (; n !== null; ) t.push(n.__key), n = n.getNextSibling();
    return t;
  }
  getChildrenSize() {
    return this.getLatest().__size;
  }
  isEmpty() {
    return this.getChildrenSize() === 0;
  }
  isDirty() {
    const t = mn()._dirtyElements;
    return t !== null && t.has(this.__key);
  }
  isLastChild() {
    const t = this.getLatest(), n = this.getParentOrThrow().getLastChild();
    return n !== null && n.is(t);
  }
  getAllTextNodes() {
    const t = [];
    let n = this.getFirstChild();
    for (; n !== null; ) {
      if (Se(n) && t.push(n), ve(n)) {
        const r = n.getAllTextNodes();
        t.push(...r);
      }
      n = n.getNextSibling();
    }
    return t;
  }
  getFirstDescendant() {
    let t = this.getFirstChild();
    for (; ve(t); ) {
      const n = t.getFirstChild();
      if (n === null) break;
      t = n;
    }
    return t;
  }
  getLastDescendant() {
    let t = this.getLastChild();
    for (; ve(t); ) {
      const n = t.getLastChild();
      if (n === null) break;
      t = n;
    }
    return t;
  }
  getDescendantByIndex(t) {
    const n = this.getChildren(), r = n.length;
    if (t >= r) {
      const o = n[r - 1];
      return ve(o) && o.getLastDescendant() || o || null;
    }
    const i = n[t];
    return ve(i) && i.getFirstDescendant() || i || null;
  }
  getFirstChild() {
    const t = this.getLatest().__first;
    return t === null ? null : $n(t);
  }
  getFirstChildOrThrow() {
    const t = this.getFirstChild();
    return t === null && _e(45, this.__key), t;
  }
  getLastChild() {
    const t = this.getLatest().__last;
    return t === null ? null : $n(t);
  }
  getLastChildOrThrow() {
    const t = this.getLastChild();
    return t === null && _e(96, this.__key), t;
  }
  getChildAtIndex(t) {
    const n = this.getChildrenSize();
    let r, i;
    if (t < n / 2) {
      for (r = this.getFirstChild(), i = 0; r !== null && i <= t; ) {
        if (i === t) return r;
        r = r.getNextSibling(), i++;
      }
      return null;
    }
    for (r = this.getLastChild(), i = n - 1; r !== null && i >= t; ) {
      if (i === t) return r;
      r = r.getPreviousSibling(), i--;
    }
    return null;
  }
  getTextContent() {
    let t = "";
    const n = this.getChildren(), r = n.length;
    for (let i = 0; i < r; i++) {
      const o = n[i];
      t += o.getTextContent(), ve(o) && i !== r - 1 && !o.isInline() && (t += zo);
    }
    return t;
  }
  getTextContentSize() {
    let t = 0;
    const n = this.getChildren(), r = n.length;
    for (let i = 0; i < r; i++) {
      const o = n[i];
      t += o.getTextContentSize(), ve(o) && i !== r - 1 && !o.isInline() && (t += zo.length);
    }
    return t;
  }
  getDirection() {
    return this.getLatest().__dir;
  }
  hasFormat(t) {
    if (t !== "") {
      const n = mC[t];
      return !!(this.getFormat() & n);
    }
    return !1;
  }
  select(t, n) {
    wr();
    const r = Ne();
    let i = t, o = n;
    const a = this.getChildrenSize();
    if (!this.canBeEmpty()) {
      if (t === 0 && n === 0) {
        const l = this.getFirstChild();
        if (Se(l) || ve(l)) return l.select(0, 0);
      } else if (!(t !== void 0 && t !== a || n !== void 0 && n !== a)) {
        const l = this.getLastChild();
        if (Se(l) || ve(l)) return l.select();
      }
    }
    i === void 0 && (i = a), o === void 0 && (o = a);
    const s = this.__key;
    return we(r) ? (r.anchor.set(s, i, "element"), r.focus.set(s, o, "element"), r.dirty = !0, r) : O2(s, i, s, o, "element", "element");
  }
  selectStart() {
    const t = this.getFirstDescendant();
    return t ? t.selectStart() : this.select();
  }
  selectEnd() {
    const t = this.getLastDescendant();
    return t ? t.selectEnd() : this.select();
  }
  clear() {
    const t = this.getWritable();
    return this.getChildren().forEach((n) => n.remove()), t;
  }
  append(...t) {
    return this.splice(this.getChildrenSize(), 0, t);
  }
  setDirection(t) {
    const n = this.getWritable();
    return n.__dir = t, n;
  }
  setFormat(t) {
    return this.getWritable().__format = t !== "" ? mC[t] : 0, this;
  }
  setStyle(t) {
    return this.getWritable().__style = t || "", this;
  }
  setIndent(t) {
    return this.getWritable().__indent = t, this;
  }
  splice(t, n, r) {
    const i = r.length, o = this.getChildrenSize(), a = this.getWritable(), s = a.__key, l = [], c = [], f = this.getChildAtIndex(t + n);
    let d = null, p = o - n + i;
    if (t !== 0) if (t === o) d = this.getLastChild();
    else {
      const y = this.getChildAtIndex(t);
      y !== null && (d = y.getPreviousSibling());
    }
    if (n > 0) {
      let y = d === null ? this.getFirstChild() : d.getNextSibling();
      for (let g = 0; g < n; g++) {
        y === null && _e(100);
        const v = y.getNextSibling(), x = y.__key;
        Ms(y.getWritable()), c.push(x), y = v;
      }
    }
    let m = d;
    for (let y = 0; y < i; y++) {
      const g = r[y];
      m !== null && g.is(m) && (d = m = m.getPreviousSibling());
      const v = g.getWritable();
      v.__parent === s && p--, Ms(v);
      const x = g.__key;
      if (m === null) a.__first = x, v.__prev = null;
      else {
        const w = m.getWritable();
        w.__next = x, v.__prev = w.__key;
      }
      g.__key === s && _e(76), v.__parent = s, l.push(x), m = g;
    }
    if (t + n === o)
      m !== null && (m.getWritable().__next = null, a.__last = m.__key);
    else if (f !== null) {
      const y = f.getWritable();
      if (m !== null) {
        const g = m.getWritable();
        y.__prev = m.__key, g.__next = f.__key;
      } else y.__prev = null;
    }
    if (a.__size = p, c.length) {
      const y = Ne();
      if (we(y)) {
        const g = new Set(c), v = new Set(l), { anchor: x, focus: w } = y;
        XC(x, g, v) && Up(x, x.getNode(), this, d, f), XC(w, g, v) && Up(w, w.getNode(), this, d, f), p !== 0 || this.canBeEmpty() || gd(this) || this.remove();
      }
    }
    return a;
  }
  exportJSON() {
    return { children: [], direction: this.getDirection(), format: this.getFormatType(), indent: this.getIndent(), type: "element", version: 1 };
  }
  insertNewAfter(t, n) {
    return null;
  }
  canIndent() {
    return !0;
  }
  collapseAtStart(t) {
    return !1;
  }
  excludeFromCopy(t) {
    return !1;
  }
  canReplaceWith(t) {
    return !0;
  }
  canInsertAfter(t) {
    return !0;
  }
  canBeEmpty() {
    return !0;
  }
  canInsertTextBefore() {
    return !0;
  }
  canInsertTextAfter() {
    return !0;
  }
  isInline() {
    return !1;
  }
  isShadowRoot() {
    return !1;
  }
  canMergeWith(t) {
    return !1;
  }
  extractWithChild(t, n, r) {
    return !1;
  }
  canMergeWhenEmpty() {
    return !1;
  }
}
function ve(e) {
  return e instanceof Lg;
}
function XC(e, t, n) {
  let r = e.getNode();
  for (; r; ) {
    const i = r.__key;
    if (t.has(i) && !n.has(i)) return !0;
    r = r.getParent();
  }
  return !1;
}
class k2 extends Ig {
  constructor(t) {
    super(t);
  }
  decorate(t, n) {
    _e(47);
  }
  isIsolated() {
    return !1;
  }
  isInline() {
    return !0;
  }
  isKeyboardSelectable() {
    return !0;
  }
}
function Ht(e) {
  return e instanceof k2;
}
class xd extends Lg {
  static getType() {
    return "root";
  }
  static clone() {
    return new xd();
  }
  constructor() {
    super("root"), this.__cachedText = null;
  }
  getTopLevelElementOrThrow() {
    _e(51);
  }
  getTextContent() {
    const t = this.__cachedText;
    return !bd() && mn()._dirtyType !== Ls || t === null ? super.getTextContent() : t;
  }
  remove() {
    _e(52);
  }
  replace(t) {
    _e(53);
  }
  insertBefore(t) {
    _e(54);
  }
  insertAfter(t) {
    _e(55);
  }
  updateDOM(t, n) {
    return !1;
  }
  append(...t) {
    for (let n = 0; n < t.length; n++) {
      const r = t[n];
      ve(r) || Ht(r) || _e(56);
    }
    return super.append(...t);
  }
  static importJSON(t) {
    const n = ir();
    return n.setFormat(t.format), n.setIndent(t.indent), n.setDirection(t.direction), n;
  }
  exportJSON() {
    return { children: [], direction: this.getDirection(), format: this.getFormatType(), indent: this.getIndent(), type: "root", version: 1 };
  }
  collapseAtStart() {
    return !0;
  }
}
function ur(e) {
  return e instanceof xd;
}
function __() {
  return new Bg(/* @__PURE__ */ new Map([["root", new xd()]]));
}
function M2(e) {
  const t = e.exportJSON(), n = e.constructor;
  if (t.type !== n.getType() && _e(130, n.name), ve(e)) {
    const r = t.children;
    Array.isArray(r) || _e(59, n.name);
    const i = e.getChildren();
    for (let o = 0; o < i.length; o++) {
      const a = M2(i[o]);
      r.push(a);
    }
  }
  return t;
}
class Bg {
  constructor(t, n) {
    this._nodeMap = t, this._selection = n || null, this._flushSync = !1, this._readOnly = !1;
  }
  isEmpty() {
    return this._nodeMap.size === 1 && this._selection === null;
  }
  read(t, n) {
    return YC(n && n.editor || null, this, t);
  }
  clone(t) {
    const n = new Bg(this._nodeMap, t === void 0 ? this._selection : t);
    return n._readOnly = !0, n;
  }
  toJSON() {
    return YC(null, this, () => ({ root: M2(ir()) }));
  }
}
class SJ extends Lg {
  static getType() {
    return "artificial";
  }
  createDOM(t) {
    return document.createElement("div");
  }
}
class Lc extends Lg {
  constructor(t) {
    super(t), this.__textFormat = 0, this.__textStyle = "";
  }
  static getType() {
    return "paragraph";
  }
  getTextFormat() {
    return this.getLatest().__textFormat;
  }
  setTextFormat(t) {
    const n = this.getWritable();
    return n.__textFormat = t, n;
  }
  hasTextFormat(t) {
    const n = Io[t];
    return !!(this.getTextFormat() & n);
  }
  getTextStyle() {
    return this.getLatest().__textStyle;
  }
  setTextStyle(t) {
    const n = this.getWritable();
    return n.__textStyle = t, n;
  }
  static clone(t) {
    return new Lc(t.__key);
  }
  afterCloneFrom(t) {
    super.afterCloneFrom(t), this.__textFormat = t.__textFormat, this.__textStyle = t.__textStyle;
  }
  createDOM(t) {
    const n = document.createElement("p"), r = qu(t.theme, "paragraph");
    return r !== void 0 && n.classList.add(...r), n;
  }
  updateDOM(t, n, r) {
    return !1;
  }
  static importDOM() {
    return { p: (t) => ({ conversion: OJ, priority: 0 }) };
  }
  exportDOM(t) {
    const { element: n } = super.exportDOM(t);
    if (n && v_(n)) {
      this.isEmpty() && n.append(document.createElement("br"));
      const r = this.getFormatType();
      n.style.textAlign = r;
      const i = this.getDirection();
      i && (n.dir = i);
      const o = this.getIndent();
      o > 0 && (n.style.textIndent = 20 * o + "px");
    }
    return { element: n };
  }
  static importJSON(t) {
    const n = Ro();
    return n.setFormat(t.format), n.setIndent(t.indent), n.setDirection(t.direction), n.setTextFormat(t.textFormat), n;
  }
  exportJSON() {
    return { ...super.exportJSON(), textFormat: this.getTextFormat(), textStyle: this.getTextStyle(), type: "paragraph", version: 1 };
  }
  insertNewAfter(t, n) {
    const r = Ro();
    r.setTextFormat(t.format), r.setTextStyle(t.style);
    const i = this.getDirection();
    return r.setDirection(i), r.setFormat(this.getFormatType()), r.setStyle(this.getTextStyle()), this.insertAfter(r, n), r;
  }
  collapseAtStart() {
    const t = this.getChildren();
    if (t.length === 0 || Se(t[0]) && t[0].getTextContent().trim() === "") {
      if (this.getNextSibling() !== null) return this.selectNext(), this.remove(), !0;
      if (this.getPreviousSibling() !== null) return this.selectPrevious(), this.remove(), !0;
    }
    return !1;
  }
}
function OJ(e) {
  const t = Ro();
  if (e.style) {
    t.setFormat(e.style.textAlign);
    const n = parseInt(e.style.textIndent, 10) / 20;
    n > 0 && t.setIndent(n);
  }
  return { node: t };
}
function Ro() {
  return $g(new Lc());
}
function ix(e) {
  return e instanceof Lc;
}
const nn = 0, rc = 1;
function N2(e, t, n, r) {
  const i = e._keyToDOMMap;
  i.clear(), e._editorState = __(), e._pendingEditorState = r, e._compositionKey = null, e._dirtyType = Ls, e._cloneNotNeeded.clear(), e._dirtyLeaves = /* @__PURE__ */ new Set(), e._dirtyElements.clear(), e._normalizedNodes = /* @__PURE__ */ new Set(), e._updateTags = /* @__PURE__ */ new Set(), e._updates = [], e._blockCursorElement = null;
  const o = e._observer;
  o !== null && (o.disconnect(), e._observer = null), t !== null && (t.textContent = ""), n !== null && (n.textContent = "", i.set("root", n));
}
function AJ(e) {
  const t = e || {}, n = _J(), r = t.theme || {}, i = e === void 0 ? n : t.parentEditor || null, o = t.disableEvents || !1, a = __(), s = t.namespace || (i !== null ? i._config.namespace : e2()), l = t.editorState, c = [xd, jc, yd, vd, Lc, SJ, ...t.nodes || []], { onError: f, html: d } = t, p = t.editable === void 0 || t.editable;
  let m;
  if (e === void 0 && n !== null) m = n._nodes;
  else {
    m = /* @__PURE__ */ new Map();
    for (let g = 0; g < c.length; g++) {
      let v = c[g], x = null, w = null;
      if (typeof v != "function") {
        const O = v;
        v = O.replace, x = O.with, w = O.withKlass || null;
      }
      const S = v.getType(), A = v.transform(), _ = /* @__PURE__ */ new Set();
      A !== null && _.add(A), m.set(S, { exportDOM: d && d.export ? d.export.get(v) : void 0, klass: v, replace: x, replaceWithKlass: w, transforms: _ });
    }
  }
  const y = new Fg(a, i, m, { disableEvents: o, namespace: s, theme: r }, f || console.error, function(g, v) {
    const x = /* @__PURE__ */ new Map(), w = /* @__PURE__ */ new Set(), S = (A) => {
      Object.keys(A).forEach((_) => {
        let O = x.get(_);
        O === void 0 && (O = [], x.set(_, O)), O.push(A[_]);
      });
    };
    return g.forEach((A) => {
      const _ = A.klass.importDOM;
      if (_ == null || w.has(_)) return;
      w.add(_);
      const O = _.call(A.klass);
      O !== null && S(O);
    }), v && S(v), x;
  }(m, d ? d.import : void 0), p);
  return l !== void 0 && (y._pendingEditorState = l, y._dirtyType = nc), y;
}
class Fg {
  constructor(t, n, r, i, o, a, s) {
    this._parentEditor = n, this._rootElement = null, this._editorState = t, this._pendingEditorState = null, this._compositionKey = null, this._deferred = [], this._keyToDOMMap = /* @__PURE__ */ new Map(), this._updates = [], this._updating = !1, this._listeners = { decorator: /* @__PURE__ */ new Set(), editable: /* @__PURE__ */ new Set(), mutation: /* @__PURE__ */ new Map(), root: /* @__PURE__ */ new Set(), textcontent: /* @__PURE__ */ new Set(), update: /* @__PURE__ */ new Set() }, this._commands = /* @__PURE__ */ new Map(), this._config = i, this._nodes = r, this._decorators = {}, this._pendingDecorators = null, this._dirtyType = Ls, this._cloneNotNeeded = /* @__PURE__ */ new Set(), this._dirtyLeaves = /* @__PURE__ */ new Set(), this._dirtyElements = /* @__PURE__ */ new Map(), this._normalizedNodes = /* @__PURE__ */ new Set(), this._updateTags = /* @__PURE__ */ new Set(), this._observer = null, this._key = e2(), this._onError = o, this._htmlConversions = a, this._editable = s, this._headless = n !== null && n._headless, this._window = null, this._blockCursorElement = null;
  }
  isComposing() {
    return this._compositionKey != null;
  }
  registerUpdateListener(t) {
    const n = this._listeners.update;
    return n.add(t), () => {
      n.delete(t);
    };
  }
  registerEditableListener(t) {
    const n = this._listeners.editable;
    return n.add(t), () => {
      n.delete(t);
    };
  }
  registerDecoratorListener(t) {
    const n = this._listeners.decorator;
    return n.add(t), () => {
      n.delete(t);
    };
  }
  registerTextContentListener(t) {
    const n = this._listeners.textcontent;
    return n.add(t), () => {
      n.delete(t);
    };
  }
  registerRootListener(t) {
    const n = this._listeners.root;
    return t(this._rootElement, null), n.add(t), () => {
      t(null, this._rootElement), n.delete(t);
    };
  }
  registerCommand(t, n, r) {
    r === void 0 && _e(35);
    const i = this._commands;
    i.has(t) || i.set(t, [/* @__PURE__ */ new Set(), /* @__PURE__ */ new Set(), /* @__PURE__ */ new Set(), /* @__PURE__ */ new Set(), /* @__PURE__ */ new Set()]);
    const o = i.get(t);
    o === void 0 && _e(36, String(t));
    const a = o[r];
    return a.add(n), () => {
      a.delete(n), o.every((s) => s.size === 0) && i.delete(t);
    };
  }
  registerMutationListener(t, n, r) {
    const i = this.resolveRegisteredNodeAfterReplacements(this.getRegisteredNode(t)).klass, o = this._listeners.mutation;
    o.set(n, i);
    const a = r && r.skipInitialization;
    return a === void 0 || a || this.initializeMutationListener(n, i), () => {
      o.delete(n);
    };
  }
  getRegisteredNode(t) {
    const n = this._nodes.get(t.getType());
    return n === void 0 && _e(37, t.name), n;
  }
  resolveRegisteredNodeAfterReplacements(t) {
    for (; t.replaceWithKlass; ) t = this.getRegisteredNode(t.replaceWithKlass);
    return t;
  }
  initializeMutationListener(t, n) {
    const r = this._editorState, i = sJ(r).get(n.getType());
    if (!i) return;
    const o = /* @__PURE__ */ new Map();
    for (const a of i.keys()) o.set(a, "created");
    o.size > 0 && t(o, { dirtyLeaves: /* @__PURE__ */ new Set(), prevEditorState: r, updateTags: /* @__PURE__ */ new Set(["registerMutationListener"]) });
  }
  registerNodeTransformToKlass(t, n) {
    const r = this.getRegisteredNode(t);
    return r.transforms.add(n), r;
  }
  registerNodeTransform(t, n) {
    const r = this.registerNodeTransformToKlass(t, n), i = [r], o = r.replaceWithKlass;
    if (o != null) {
      const l = this.registerNodeTransformToKlass(o, n);
      i.push(l);
    }
    var a, s;
    return a = this, s = t.getType(), Fr(a, () => {
      const l = qo();
      if (l.isEmpty()) return;
      if (s === "root") return void ir().markDirty();
      const c = l._nodeMap;
      for (const [, f] of c) f.markDirty();
    }, a._pendingEditorState === null ? { tag: "history-merge" } : void 0), () => {
      i.forEach((l) => l.transforms.delete(n));
    };
  }
  hasNode(t) {
    return this._nodes.has(t.getType());
  }
  hasNodes(t) {
    return t.every(this.hasNode.bind(this));
  }
  dispatchCommand(t, n) {
    return Ae(this, t, n);
  }
  getDecorators() {
    return this._decorators;
  }
  getRootElement() {
    return this._rootElement;
  }
  getKey() {
    return this._key;
  }
  setRootElement(t) {
    const n = this._rootElement;
    if (t !== n) {
      const r = qu(this._config.theme, "root"), i = this._pendingEditorState || this._editorState;
      if (this._rootElement = t, N2(this, n, t, i), n !== null && (this._config.disableEvents || fJ(n), r != null && n.classList.remove(...r)), t !== null) {
        const o = function(s) {
          const l = s.ownerDocument;
          return l && l.defaultView || null;
        }(t), a = t.style;
        a.userSelect = "text", a.whiteSpace = "pre-wrap", a.wordBreak = "break-word", t.setAttribute("data-lexical-editor", "true"), this._window = o, this._dirtyType = nc, GR(this), this._updateTags.add("history-merge"), Aa(this), this._config.disableEvents || function(s, l) {
          const c = s.ownerDocument, f = zp.get(c);
          (f === void 0 || f < 1) && c.addEventListener("selectionchange", y2), zp.set(c, (f || 0) + 1), s.__lexicalEditor = l;
          const d = g2(s);
          for (let p = 0; p < Q0.length; p++) {
            const [m, y] = Q0[p], g = typeof y == "function" ? (v) => {
              $C(v) || (NC(v), (l.isEditable() || m === "click") && y(v, l));
            } : (v) => {
              if ($C(v)) return;
              NC(v);
              const x = l.isEditable();
              switch (m) {
                case "cut":
                  return x && Ae(l, t_, v);
                case "copy":
                  return Ae(l, e_, v);
                case "paste":
                  return x && Ae(l, Y1, v);
                case "dragstart":
                  return x && Ae(l, FR, v);
                case "dragover":
                  return x && Ae(l, OZ, v);
                case "dragend":
                  return x && Ae(l, AZ, v);
                case "focus":
                  return x && Ae(l, CZ, v);
                case "blur":
                  return x && Ae(l, EZ, v);
                case "drop":
                  return x && Ae(l, BR, v);
              }
            };
            s.addEventListener(m, g), d.push(() => {
              s.removeEventListener(m, g);
            });
          }
        }(t, this), r != null && t.classList.add(...r);
      } else this._editorState = i, this._pendingEditorState = null, this._window = null;
      Qu("root", this, !1, t, n);
    }
  }
  getElementByKey(t) {
    return this._keyToDOMMap.get(t) || null;
  }
  getEditorState() {
    return this._editorState;
  }
  setEditorState(t, n) {
    t.isEmpty() && _e(38), KR(this);
    const r = this._pendingEditorState, i = this._updateTags, o = n !== void 0 ? n.tag : null;
    r === null || r.isEmpty() || (o != null && i.add(o), Aa(this)), this._pendingEditorState = t, this._dirtyType = nc, this._dirtyElements.set("root", !1), this._compositionKey = null, o != null && i.add(o), Aa(this);
  }
  parseEditorState(t, n) {
    return function(r, i, o) {
      const a = __(), s = Dn, l = Ar, c = In, f = i._dirtyElements, d = i._dirtyLeaves, p = i._cloneNotNeeded, m = i._dirtyType;
      i._dirtyElements = /* @__PURE__ */ new Map(), i._dirtyLeaves = /* @__PURE__ */ new Set(), i._cloneNotNeeded = /* @__PURE__ */ new Set(), i._dirtyType = 0, Dn = a, Ar = !1, In = i;
      try {
        const y = i._nodes;
        P2(r.root, y), o && o(), a._readOnly = !0;
      } catch (y) {
        y instanceof Error && i._onError(y);
      } finally {
        i._dirtyElements = f, i._dirtyLeaves = d, i._cloneNotNeeded = p, i._dirtyType = m, Dn = s, Ar = l, In = c;
      }
      return a;
    }(typeof t == "string" ? JSON.parse(t) : t, this, n);
  }
  read(t) {
    return Aa(this), this.getEditorState().read(t, { editor: this });
  }
  update(t, n) {
    Fr(this, t, n);
  }
  focus(t, n = {}) {
    const r = this._rootElement;
    r !== null && (r.setAttribute("autocapitalize", "off"), Fr(this, () => {
      const i = Ne(), o = ir();
      i !== null ? i.dirty = !0 : o.getChildrenSize() !== 0 && (n.defaultSelection === "rootStart" ? o.selectStart() : o.selectEnd());
    }, { onUpdate: () => {
      r.removeAttribute("autocapitalize"), t && t();
    }, tag: "focus" }), this._pendingEditorState === null && r.removeAttribute("autocapitalize"));
  }
  blur() {
    const t = this._rootElement;
    t !== null && t.blur();
    const n = no(this._window);
    n !== null && n.removeAllRanges();
  }
  isEditable() {
    return this._editable;
  }
  setEditable(t) {
    this._editable !== t && (this._editable = t, Qu("editable", this, !0, t));
  }
  toJSON() {
    return { editorState: this._editorState.toJSON() };
  }
}
Fg.version = "0.17.1+prod.esm";
const $2 = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0, TJ = $2 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect, Fh = { tag: "history-merge" };
function PJ({ initialConfig: e, children: t }) {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const { theme: r, namespace: i, nodes: o, onError: a, editorState: s, html: l } = e, c = yZ(null, r), f = AJ({ editable: e.editable, html: l, namespace: i, nodes: o, onError: (d) => a(d, f), theme: r });
    return function(d, p) {
      if (p !== null) {
        if (p === void 0) d.update(() => {
          const m = ir();
          if (m.isEmpty()) {
            const y = Ro();
            m.append(y);
            const g = $2 ? document.activeElement : null;
            (Ne() !== null || g !== null && g === d.getRootElement()) && y.select();
          }
        }, Fh);
        else if (p !== null) switch (typeof p) {
          case "string": {
            const m = d.parseEditorState(p);
            d.setEditorState(m, Fh);
            break;
          }
          case "object":
            d.setEditorState(p, Fh);
            break;
          case "function":
            d.update(() => {
              ir().isEmpty() && p(d);
            }, Fh);
        }
      }
    }(f, s), [f, c];
  }, []);
  return TJ(() => {
    const r = e.editable, [i] = n;
    i.setEditable(r === void 0 || r);
  }, []), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(NR.Provider, { value: n, children: t });
}
const CJ = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function EJ(e) {
  return { initialValueFn: () => e.isEditable(), subscribe: (t) => e.registerEditableListener(t) };
}
function kJ() {
  return function(e) {
    const [t] = Gr(), n = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => e(t), [t, e]), r = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(n.initialValueFn()), [i, o] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(r.current);
    return CJ(() => {
      const { initialValueFn: a, subscribe: s } = n, l = a();
      return r.current !== l && (r.current = l, o(l)), s((c) => {
        r.current = c, o(c);
      });
    }, [n, e]), i;
  }(EJ);
}
function MJ() {
  return ir().getTextContent();
}
function NJ(e, t = !0) {
  if (e) return !1;
  let n = MJ();
  return t && (n = n.trim()), n === "";
}
function $J(e) {
  if (!NJ(e, !1)) return !1;
  const t = ir().getChildren(), n = t.length;
  if (n > 1) return !1;
  for (let r = 0; r < n; r++) {
    const i = t[r];
    if (Ht(i)) return !1;
    if (ve(i)) {
      if (!ix(i) || i.__indent !== 0) return !1;
      const o = i.getChildren(), a = o.length;
      for (let s = 0; s < a; s++) {
        const l = o[r];
        if (!Se(l)) return !1;
      }
    }
  }
  return !0;
}
function D2(e) {
  return () => $J(e);
}
function DJ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
DJ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
function IJ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
IJ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
function RJ(e, t) {
  const n = e.getStartEndPoints();
  if (t.isSelected(e) && !t.isSegmented() && !t.isToken() && n !== null) {
    const [r, i] = n, o = e.isBackward(), a = r.getNode(), s = i.getNode(), l = t.is(a), c = t.is(s);
    if (l || c) {
      const [f, d] = rx(e), p = a.is(s), m = t.is(o ? s : a), y = t.is(o ? a : s);
      let g, v = 0;
      return p ? (v = f > d ? d : f, g = f > d ? f : d) : m ? (v = o ? d : f, g = void 0) : y && (v = 0, g = o ? f : d), t.__text = t.__text.slice(v, g), t;
    }
  }
  return t;
}
function ZC(e, t) {
  const n = U0(e.focus, t);
  return Ht(n) && !n.isIsolated() || ve(n) && !n.isInline() && !n.canBeEmpty();
}
function jJ(e, t, n, r) {
  e.modify(t ? "extend" : "move", n, r);
}
function LJ(e) {
  const t = e.anchor.getNode();
  return (ur(t) ? t : t.getParentOrThrow()).getDirection() === "rtl";
}
function JC(e, t, n) {
  const r = LJ(e);
  jJ(e, t, n ? !r : r, "character");
}
function BJ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
BJ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
const I2 = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0, FJ = I2 && "documentMode" in document ? document.documentMode : null;
!(!I2 || !("InputEvent" in window) || FJ) && "getTargetRanges" in new window.InputEvent("input");
function Uo(...e) {
  return () => {
    for (let t = e.length - 1; t >= 0; t--) e[t]();
    e.length = 0;
  };
}
function WJ(e, t) {
  return e !== null && Object.getPrototypeOf(e).constructor.name === t.name;
}
function zJ(e) {
  const t = window.location.origin, n = (r) => {
    if (r.origin !== t) return;
    const i = e.getRootElement();
    if (document.activeElement !== i) return;
    const o = r.data;
    if (typeof o == "string") {
      let a;
      try {
        a = JSON.parse(o);
      } catch {
        return;
      }
      if (a && a.protocol === "nuanria_messaging" && a.type === "request") {
        const s = a.payload;
        if (s && s.functionId === "makeChanges") {
          const l = s.args;
          if (l) {
            const [c, f, d, p, m, y] = l;
            e.update(() => {
              const g = Ne();
              if (we(g)) {
                const v = g.anchor;
                let x = v.getNode(), w = 0, S = 0;
                if (Se(x) && c >= 0 && f >= 0 && (w = c, S = c + f, g.setTextNodeRange(x, w, x, S)), w === S && d === "" || (g.insertRawText(d), x = v.getNode()), Se(x)) {
                  w = p, S = p + m;
                  const A = x.getTextContentSize();
                  w = w > A ? A : w, S = S > A ? A : S, g.setTextNodeRange(x, w, x, S);
                }
                r.stopImmediatePropagation();
              }
            });
          }
        }
      }
    }
  };
  return window.addEventListener("message", n, !0), () => {
    window.removeEventListener("message", n, !0);
  };
}
function VJ(e, t) {
  if (typeof document > "u" || typeof window > "u" && global.window === void 0) throw new Error("To use $generateHtmlFromNodes in headless mode please initialize a headless browser implementation such as JSDom before calling this function.");
  const n = document.createElement("div"), r = ir().getChildren();
  for (let i = 0; i < r.length; i++)
    R2(e, r[i], n, t);
  return n.innerHTML;
}
function R2(e, t, n, r = null) {
  let i = r === null || t.isSelected(r);
  const o = ve(t) && t.excludeFromCopy("html");
  let a = t;
  if (r !== null) {
    let m = r2(t);
    m = Se(m) && r !== null ? RJ(r, m) : m, a = m;
  }
  const s = ve(a) ? a.getChildren() : [], l = e._nodes.get(a.getType());
  let c;
  c = l && l.exportDOM !== void 0 ? l.exportDOM(e, a) : a.exportDOM(e);
  const { element: f, after: d } = c;
  if (!f) return !1;
  const p = document.createDocumentFragment();
  for (let m = 0; m < s.length; m++) {
    const y = s[m], g = R2(e, y, p, r);
    !i && ve(t) && g && t.extractWithChild(y, r, "html") && (i = !0);
  }
  if (i && !o) {
    if (v_(f) && f.append(p), n.append(f), d) {
      const m = d.call(a, f);
      m && f.replaceWith(m);
    }
  } else n.append(p);
  return i;
}
function UJ(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
var HJ = UJ(function(e) {
  const t = new URLSearchParams();
  t.append("code", e);
  for (let n = 1; n < arguments.length; n++) t.append("v", arguments[n]);
  throw Error(`Minified Lexical error #${e}; visit https://lexical.dev/docs/error?${t} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`);
});
function KJ(e, t = Ne()) {
  return t == null && HJ(166), we(t) && t.isCollapsed() || t.getNodes().length === 0 ? "" : VJ(e, t);
}
function QC(e, t) {
  const n = e.getData("text/plain") || e.getData("text/uri-list");
  n != null && t.insertRawText(n);
}
const Bc = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0, GJ = Bc && "documentMode" in document ? document.documentMode : null, YJ = !(!Bc || !("InputEvent" in window) || GJ) && "getTargetRanges" in new window.InputEvent("input"), qJ = Bc && /Version\/[\d.]+.*Safari/.test(navigator.userAgent), XJ = Bc && /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream, ZJ = Bc && /^(?=.*Chrome).*/i.test(navigator.userAgent), JJ = Bc && /AppleWebKit\/[\d.]+/.test(navigator.userAgent) && !ZJ;
function eE(e, t) {
  t.update(() => {
    if (e !== null) {
      const n = WJ(e, KeyboardEvent) ? null : e.clipboardData, r = Ne();
      if (r !== null && n != null) {
        e.preventDefault();
        const i = KJ(t);
        i !== null && n.setData("text/html", i), n.setData("text/plain", r.getTextContent());
      }
    }
  });
}
function QJ(e) {
  return Uo(e.registerCommand(ks, (t) => {
    const n = Ne();
    return !!we(n) && (n.deleteCharacter(t), !0);
  }, nn), e.registerCommand(bf, (t) => {
    const n = Ne();
    return !!we(n) && (n.deleteWord(t), !0);
  }, nn), e.registerCommand(xf, (t) => {
    const n = Ne();
    return !!we(n) && (n.deleteLine(t), !0);
  }, nn), e.registerCommand(Kl, (t) => {
    const n = Ne();
    if (!we(n)) return !1;
    if (typeof t == "string") n.insertText(t);
    else {
      const r = t.dataTransfer;
      if (r != null) QC(r, n);
      else {
        const i = t.data;
        i && n.insertText(i);
      }
    }
    return !0;
  }, nn), e.registerCommand(F0, () => {
    const t = Ne();
    return !!we(t) && (t.removeText(), !0);
  }, nn), e.registerCommand(Hl, (t) => {
    const n = Ne();
    return !!we(n) && (n.insertLineBreak(t), !0);
  }, nn), e.registerCommand(B0, () => {
    const t = Ne();
    return !!we(t) && (t.insertLineBreak(), !0);
  }, nn), e.registerCommand(J1, (t) => {
    const n = Ne();
    if (!we(n)) return !1;
    const r = t, i = r.shiftKey;
    return !!ZC(n, !0) && (r.preventDefault(), JC(n, i, !0), !0);
  }, nn), e.registerCommand(Z1, (t) => {
    const n = Ne();
    if (!we(n)) return !1;
    const r = t, i = r.shiftKey;
    return !!ZC(n, !1) && (r.preventDefault(), JC(n, i, !1), !0);
  }, nn), e.registerCommand(Q1, (t) => {
    const n = Ne();
    return !!we(n) && (t.preventDefault(), e.dispatchCommand(ks, !0));
  }, nn), e.registerCommand(jR, (t) => {
    const n = Ne();
    return !!we(n) && (t.preventDefault(), e.dispatchCommand(ks, !1));
  }, nn), e.registerCommand(wf, (t) => {
    const n = Ne();
    if (!we(n)) return !1;
    if (t !== null) {
      if ((XJ || qJ || JJ) && YJ) return !1;
      t.preventDefault();
    }
    return e.dispatchCommand(Hl, !1);
  }, nn), e.registerCommand(W0, () => (nJ(), !0), nn), e.registerCommand(e_, (t) => {
    const n = Ne();
    return !!we(n) && (eE(t, e), !0);
  }, nn), e.registerCommand(t_, (t) => {
    const n = Ne();
    return !!we(n) && (function(r, i) {
      eE(r, i), i.update(() => {
        const o = Ne();
        we(o) && o.removeText();
      });
    }(t, e), !0);
  }, nn), e.registerCommand(Y1, (t) => {
    const n = Ne();
    return !!we(n) && (function(r, i) {
      r.preventDefault(), i.update(() => {
        const o = Ne(), { clipboardData: a } = r;
        a != null && we(o) && QC(a, o);
      }, { tag: "paste" });
    }(t, e), !0);
  }, nn), e.registerCommand(BR, (t) => {
    const n = Ne();
    return !!we(n) && (t.preventDefault(), !0);
  }, nn), e.registerCommand(FR, (t) => {
    const n = Ne();
    return !!we(n) && (t.preventDefault(), !0);
  }, nn));
}
const ox = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function tE(e) {
  return e.getEditorState().read(D2(e.isComposing()));
}
function eQ({ contentEditable: e, placeholder: t = null, ErrorBoundary: n }) {
  const [r] = Gr(), i = function(o, a) {
    const [s, l] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => o.getDecorators());
    return ox(() => o.registerDecoratorListener((c) => {
      (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.flushSync)(() => {
        l(c);
      });
    }), [o]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      l(o.getDecorators());
    }, [o]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
      const c = [], f = Object.keys(s);
      for (let d = 0; d < f.length; d++) {
        const p = f[d], m = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(a, { onError: (g) => o._onError(g), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.Suspense, { fallback: null, children: s[p] }) }), y = o.getElementByKey(p);
        y !== null && c.push((0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)(m, y, p));
      }
      return c;
    }, [a, s, o]);
  }(r, n);
  return function(o) {
    ox(() => Uo(QJ(o), zJ(o)), [o]);
  }(r), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [e, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(tQ, { content: t }), i] });
}
function tQ({ content: e }) {
  const [t] = Gr(), n = function(i) {
    const [o, a] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => tE(i));
    return ox(() => {
      function s() {
        const l = tE(i);
        a(l);
      }
      return s(), Uo(i.registerUpdateListener(() => {
        s();
      }), i.registerEditableListener(() => {
        s();
      }));
    }, [i]), o;
  }(t), r = kJ();
  return n ? typeof e == "function" ? e(r) : e : null;
}
const j2 = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function nQ({ editor: e, ariaActiveDescendant: t, ariaAutoComplete: n, ariaControls: r, ariaDescribedBy: i, ariaExpanded: o, ariaLabel: a, ariaLabelledBy: s, ariaMultiline: l, ariaOwns: c, ariaRequired: f, autoCapitalize: d, className: p, id: m, role: y = "textbox", spellCheck: g = !0, style: v, tabIndex: x, "data-testid": w, ...S }, A) {
  const [_, O] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(e.isEditable()), P = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((k) => {
    k && k.ownerDocument && k.ownerDocument.defaultView ? e.setRootElement(k) : e.setRootElement(null);
  }, [e]), C = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => /* @__PURE__ */ function(...k) {
    return (I) => {
      k.forEach(($) => {
        typeof $ == "function" ? $(I) : $ != null && ($.current = I);
      });
    };
  }(A, P), [P, A]);
  return j2(() => (O(e.isEditable()), e.registerEditableListener((k) => {
    O(k);
  })), [e]), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...S, "aria-activedescendant": _ ? t : void 0, "aria-autocomplete": _ ? n : "none", "aria-controls": _ ? r : void 0, "aria-describedby": i, "aria-expanded": _ && y === "combobox" ? !!o : void 0, "aria-label": a, "aria-labelledby": s, "aria-multiline": l, "aria-owns": _ ? c : void 0, "aria-readonly": !_ || void 0, "aria-required": f, autoCapitalize: d, className: p, contentEditable: _, "data-testid": w, id: m, ref: C, role: _ ? y : void 0, spellCheck: g, style: v, tabIndex: x });
}
const rQ = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(nQ);
function nE(e) {
  return e.getEditorState().read(D2(e.isComposing()));
}
const iQ = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(oQ);
function oQ(e, t) {
  const { placeholder: n, ...r } = e, [i] = Gr();
  return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(rQ, { editor: i, ...r, ref: t }), n != null && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(aQ, { editor: i, content: n })] });
}
function aQ({ content: e, editor: t }) {
  const n = function(a) {
    const [s, l] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => nE(a));
    return j2(() => {
      function c() {
        const f = nE(a);
        l(f);
      }
      return c(), Uo(a.registerUpdateListener(() => {
        c();
      }), a.registerEditableListener(() => {
        c();
      }));
    }, [a]), s;
  }(t), [r, i] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(t.isEditable());
  if ((0,react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect)(() => (i(t.isEditable()), t.registerEditableListener((a) => {
    i(a);
  })), [t]), !n) return null;
  let o = null;
  return typeof e == "function" ? o = e(r) : e !== null && (o = e), o === null ? null : (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "aria-hidden": !0, children: o });
}
const Wh = 0, ax = 1, sx = 2, Oi = 0, sQ = 1, rE = 2, lQ = 3, cQ = 4;
function uQ(e, t, n, r, i) {
  if (e === null || n.size === 0 && r.size === 0 && !i) return Oi;
  const o = t._selection, a = e._selection;
  if (i) return sQ;
  if (!(we(o) && we(a) && a.isCollapsed() && o.isCollapsed())) return Oi;
  const s = function(x, w, S) {
    const A = x._nodeMap, _ = [];
    for (const O of w) {
      const P = A.get(O);
      P !== void 0 && _.push(P);
    }
    for (const [O, P] of S) {
      if (!P) continue;
      const C = A.get(O);
      C === void 0 || ur(C) || _.push(C);
    }
    return _;
  }(t, n, r);
  if (s.length === 0) return Oi;
  if (s.length > 1) {
    const x = t._nodeMap, w = x.get(o.anchor.key), S = x.get(a.anchor.key);
    return w && S && !e._nodeMap.has(w.__key) && Se(w) && w.__text.length === 1 && o.anchor.offset === 1 ? rE : Oi;
  }
  const l = s[0], c = e._nodeMap.get(l.__key);
  if (!Se(c) || !Se(l) || c.__mode !== l.__mode) return Oi;
  const f = c.__text, d = l.__text;
  if (f === d) return Oi;
  const p = o.anchor, m = a.anchor;
  if (p.key !== m.key || p.type !== "text") return Oi;
  const y = p.offset, g = m.offset, v = d.length - f.length;
  return v === 1 && g === y - 1 ? rE : v === -1 && g === y + 1 ? lQ : v === -1 && g === y ? cQ : Oi;
}
function fQ(e, t) {
  let n = Date.now(), r = Oi;
  return (i, o, a, s, l, c) => {
    const f = Date.now();
    if (c.has("historic")) return r = Oi, n = f, sx;
    const d = uQ(i, o, s, l, e.isComposing()), p = (() => {
      const m = a === null || a.editor === e, y = c.has("history-push");
      if (!y && m && c.has("history-merge")) return Wh;
      if (i === null) return ax;
      const g = o._selection;
      return s.size > 0 || l.size > 0 ? y === !1 && d !== Oi && d === r && f < n + t && m || s.size === 1 && function(v, x, w) {
        const S = x._nodeMap.get(v), A = w._nodeMap.get(v), _ = x._selection, O = w._selection;
        return !(we(_) && we(O) && _.anchor.type === "element" && _.focus.type === "element" && O.anchor.type === "text" && O.focus.type === "text" || !Se(S) || !Se(A) || S.__parent !== A.__parent) && JSON.stringify(x.read(() => S.exportJSON())) === JSON.stringify(w.read(() => A.exportJSON()));
      }(Array.from(s)[0], i, o) ? Wh : ax : g !== null ? Wh : sx;
    })();
    return n = f, r = d, p;
  };
}
function iE(e) {
  e.undoStack = [], e.redoStack = [], e.current = null;
}
function dQ(e, t, n) {
  const r = fQ(e, n);
  return Uo(e.registerCommand(q1, () => (function(o, a) {
    const s = a.redoStack, l = a.undoStack;
    if (l.length !== 0) {
      const c = a.current, f = l.pop();
      c !== null && (s.push(c), o.dispatchCommand(Rh, !0)), l.length === 0 && o.dispatchCommand(jh, !1), a.current = f || null, f && f.editor.setEditorState(f.editorState, { tag: "historic" });
    }
  }(e, t), !0), nn), e.registerCommand(X1, () => (function(o, a) {
    const s = a.redoStack, l = a.undoStack;
    if (s.length !== 0) {
      const c = a.current;
      c !== null && (l.push(c), o.dispatchCommand(jh, !0));
      const f = s.pop();
      s.length === 0 && o.dispatchCommand(Rh, !1), a.current = f || null, f && f.editor.setEditorState(f.editorState, { tag: "historic" });
    }
  }(e, t), !0), nn), e.registerCommand(TZ, () => (iE(t), !1), nn), e.registerCommand(PZ, () => (iE(t), e.dispatchCommand(Rh, !1), e.dispatchCommand(jh, !1), !0), nn), e.registerUpdateListener(({ editorState: o, prevEditorState: a, dirtyLeaves: s, dirtyElements: l, tags: c }) => {
    const f = t.current, d = t.redoStack, p = t.undoStack, m = f === null ? null : f.editorState;
    if (f !== null && o === m) return;
    const y = r(a, o, f, s, l, c);
    if (y === ax) d.length !== 0 && (t.redoStack = [], e.dispatchCommand(Rh, !1)), f !== null && (p.push({ ...f }), e.dispatchCommand(jh, !0));
    else if (y === sx) return;
    t.current = { editor: e, editorState: o };
  }));
}
function hQ() {
  return { current: null, redoStack: [], undoStack: [] };
}
function pQ({ delay: e, externalHistoryState: t }) {
  const [n] = Gr();
  return function(r, i, o = 1e3) {
    const a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => i || hQ(), [i]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => dQ(r, a, o), [o, r, a]);
  }(n, t, e), null;
}
function lx(e, t) {
  return lx = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(n, r) {
    return n.__proto__ = r, n;
  }, lx(e, t);
}
var oE = { error: null }, mQ = function(e) {
  var t, n;
  function r() {
    for (var o, a = arguments.length, s = new Array(a), l = 0; l < a; l++) s[l] = arguments[l];
    return (o = e.call.apply(e, [this].concat(s)) || this).state = oE, o.resetErrorBoundary = function() {
      for (var c, f = arguments.length, d = new Array(f), p = 0; p < f; p++) d[p] = arguments[p];
      o.props.onReset == null || (c = o.props).onReset.apply(c, d), o.reset();
    }, o;
  }
  n = e, (t = r).prototype = Object.create(n.prototype), t.prototype.constructor = t, lx(t, n), r.getDerivedStateFromError = function(o) {
    return { error: o };
  };
  var i = r.prototype;
  return i.reset = function() {
    this.setState(oE);
  }, i.componentDidCatch = function(o, a) {
    var s, l;
    (s = (l = this.props).onError) == null || s.call(l, o, a);
  }, i.componentDidUpdate = function(o, a) {
    var s, l, c, f, d = this.state.error, p = this.props.resetKeys;
    d !== null && a.error !== null && ((c = o.resetKeys) === void 0 && (c = []), (f = p) === void 0 && (f = []), c.length !== f.length || c.some(function(m, y) {
      return !Object.is(m, f[y]);
    })) && ((s = (l = this.props).onResetKeysChange) == null || s.call(l, o.resetKeys, p), this.reset());
  }, i.render = function() {
    var o = this.state.error, a = this.props, s = a.fallbackRender, l = a.FallbackComponent, c = a.fallback;
    if (o !== null) {
      var f = { error: o, resetErrorBoundary: this.resetErrorBoundary };
      if (react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(c)) return c;
      if (typeof s == "function") return s(f);
      if (l) return react__WEBPACK_IMPORTED_MODULE_1__.createElement(l, f);
      throw new Error("react-error-boundary requires either a fallback, fallbackRender, or FallbackComponent prop");
    }
    return this.props.children;
  }, r;
}(react__WEBPACK_IMPORTED_MODULE_1__.Component);
function gQ({ children: e, onError: t }) {
  return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(mQ, { fallback: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { style: { border: "1px solid #f00", color: "#f00", padding: "8px" }, children: "An error was thrown." }), onError: t, children: e });
}
const yQ = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect;
function vQ({ ignoreHistoryMergeTagChange: e = !0, ignoreSelectionChange: t = !1, onChange: n }) {
  const [r] = Gr();
  return yQ(() => {
    if (n) return r.registerUpdateListener(({ editorState: i, dirtyElements: o, dirtyLeaves: a, prevEditorState: s, tags: l }) => {
      t && o.size === 0 && a.size === 0 || e && l.has("history-merge") || s.isEmpty() || n(i, r, l);
    });
  }, [r, e, t, n]), null;
}
function bQ({ editorRef: e }) {
  const [t] = Gr();
  return react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    typeof e == "function" ? e(t) : typeof e == "object" && (e.current = t);
  }, [t]), null;
}
const xQ = "w-full [&>p]:w-full [&>p]:m-0", wQ = "focus-within:ring-2 focus-within:ring-offset-2 hover:outline-border-strong hover:focus-within:outline-focus-border focus-within:outline-focus-border focus-within:ring-focus transition-[color,outline,box-shadow] duration-150 ease-in-out outline outline-1 outline-field-border", _Q = "bg-field-secondary-background outline-field-border-disabled hover:outline-field-border-disabled [&_p]:text-badge-color-disabled cursor-not-allowed", SQ = {
  sm: "px-3 py-1.5 rounded [&_.editor-content>p]:text-xs [&_.editor-content>p]:font-normal [&_.pointer-events-none]:text-xs [&_.pointer-events-none]:font-normal [&_.editor-content>p]:content-center [&_.editor-content>p]:min-h-5",
  md: "px-3.5 py-2 rounded-md [&_.editor-content>p]:text-sm [&_.editor-content>p]:font-normal [&_.pointer-events-none]:text-sm [&_.pointer-events-none]:font-normal [&_.editor-content>p]:content-center [&_.editor-content>p]:min-h-6",
  lg: "px-4 py-2.5 rounded-md [&_.editor-content>p]:text-base [&_.editor-content>p]:font-normal [&_.pointer-events-none]:text-base [&_.pointer-events-none]:font-normal [&_.editor-content>p]:content-center [&_.editor-content>p]:min-h-7"
}, OQ = "absolute inset-x-0 top-full mt-2 mx-0 mb-0 w-full h-auto overflow-y-auto overflow-x-hidden z-10 bg-background-primary border border-solid border-border-subtle shadow-lg", AQ = {
  sm: "p-1.5 rounded-md max-h-[10.75rem]",
  md: "p-2 rounded-lg max-h-[13.5rem]",
  lg: "p-2 rounded-lg max-h-[13.5rem]"
}, TQ = "m-0 text-text-primary cursor-pointer", PQ = {
  sm: "p-1.5 rounded text-xs leading-5 font-normal",
  md: "p-2 rounded-md text-sm leading-6 font-normal",
  lg: "p-2 rounded-md text-base leading-6 font-normal"
}, CQ = "bg-button-tertiary-hover", aE = "startTransition", EQ = typeof window < "u" && window.document !== void 0 && window.document.createElement !== void 0 ? react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_1__.useEffect, sE = (e) => {
  const t = document.getElementById("typeahead-menu");
  if (!t) return;
  const n = t.getBoundingClientRect();
  n.top + n.height > window.innerHeight && t.scrollIntoView({ block: "center" }), n.top < 0 && t.scrollIntoView({ block: "center" }), e.scrollIntoView({ block: "nearest" });
};
function lE(e, t) {
  const n = e.getBoundingClientRect(), r = t.getBoundingClientRect();
  return n.top > r.top && n.top < r.bottom;
}
function kQ(e, t, n, r) {
  const [i] = Gr();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (t != null && e != null) {
      const o = i.getRootElement(), a = o != null ? function(d, p) {
        let m = getComputedStyle(d);
        const y = m.position === "absolute", g = /(auto|scroll)/;
        if (m.position === "fixed") return document.body;
        for (let v = d; v = v.parentElement; ) if (m = getComputedStyle(v), (!y || m.position !== "static") && g.test(m.overflow + m.overflowY + m.overflowX)) return v;
        return document.body;
      }(o) : document.body;
      let s = !1, l = lE(t, a);
      const c = function() {
        s || (window.requestAnimationFrame(function() {
          n(), s = !1;
        }), s = !0);
        const d = lE(t, a);
        d !== l && (l = d, r != null && r(d));
      }, f = new ResizeObserver(n);
      return window.addEventListener("resize", n), document.addEventListener("scroll", c, { capture: !0, passive: !0 }), f.observe(t), () => {
        f.unobserve(t), window.removeEventListener("resize", n), document.removeEventListener("scroll", c, !0);
      };
    }
  }, [t, i, r, n, e]);
}
const cE = bZ();
function MQ({ close: e, editor: t, anchorElementRef: n, resolution: r, options: i, menuRenderFn: o, onSelectOption: a, shouldSplitNodeWithQuery: s = !1, commandPriority: l = rc }) {
  const [c, f] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), d = r.match && r.match.matchingString;
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    f(0);
  }, [d]);
  const p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((y) => {
    t.update(() => {
      const g = r.match != null && s ? function(v) {
        const x = Ne();
        if (!we(x) || !x.isCollapsed()) return null;
        const w = x.anchor;
        if (w.type !== "text") return null;
        const S = w.getNode();
        if (!S.isSimpleText()) return null;
        const A = w.offset, _ = S.getTextContent().slice(0, A), O = v.replaceableString.length, P = A - function(k, I, $) {
          let N = $;
          for (let D = N; D <= I.length; D++) k.substr(-D) === I.substr(0, D) && (N = D);
          return N;
        }(_, v.matchingString, O);
        if (P < 0) return null;
        let C;
        return P === 0 ? [C] = S.splitText(A) : [, C] = S.splitText(P, A), C;
      }(r.match) : null;
      a(y, g, e, r.match ? r.match.matchingString : "");
    });
  }, [t, s, r.match, a, e]), m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((y) => {
    const g = t.getRootElement();
    g !== null && (g.setAttribute("aria-activedescendant", "typeahead-item-" + y), f(y));
  }, [t]);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => () => {
    const y = t.getRootElement();
    y !== null && y.removeAttribute("aria-activedescendant");
  }, [t]), EQ(() => {
    i === null ? f(null) : c === null && m(0);
  }, [i, c, m]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => Uo(t.registerCommand(cE, ({ option: y }) => !(!y.ref || y.ref.current == null) && (sE(y.ref.current), !0), l)), [t, m, l]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => Uo(t.registerCommand(IR, (y) => {
    const g = y;
    if (i !== null && i.length && c !== null) {
      const v = c !== i.length - 1 ? c + 1 : 0;
      m(v);
      const x = i[v];
      x.ref != null && x.ref.current && t.dispatchCommand(cE, { index: v, option: x }), g.preventDefault(), g.stopImmediatePropagation();
    }
    return !0;
  }, l), t.registerCommand(DR, (y) => {
    const g = y;
    if (i !== null && i.length && c !== null) {
      const v = c !== 0 ? c - 1 : i.length - 1;
      m(v);
      const x = i[v];
      x.ref != null && x.ref.current && sE(x.ref.current), g.preventDefault(), g.stopImmediatePropagation();
    }
    return !0;
  }, l), t.registerCommand(RR, (y) => {
    const g = y;
    return g.preventDefault(), g.stopImmediatePropagation(), e(), !0;
  }, l), t.registerCommand(LR, (y) => {
    const g = y;
    return i !== null && c !== null && i[c] != null && (g.preventDefault(), g.stopImmediatePropagation(), p(i[c]), !0);
  }, l), t.registerCommand(wf, (y) => i !== null && c !== null && i[c] != null && (y !== null && (y.preventDefault(), y.stopImmediatePropagation()), p(i[c]), !0), l)), [p, e, t, i, c, m, l]), o(n, (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({ options: i, selectOptionAndCleanUp: p, selectedIndex: c, setHighlightedIndex: f }), [p, c, i]), r.match ? r.match.matchingString : "");
}
function NQ({ options: e, onQueryChange: t, onSelectOption: n, onOpen: r, onClose: i, menuRenderFn: o, triggerFn: a, anchorClassName: s, commandPriority: l = rc, parent: c }) {
  const [f] = Gr(), [d, p] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), m = function(v, x, w, S = document.body) {
    const [A] = Gr(), _ = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(document.createElement("div")), O = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
      _.current.style.top = _.current.style.bottom;
      const C = A.getRootElement(), k = _.current, I = k.firstChild;
      if (C !== null && v !== null) {
        const { left: $, top: N, width: D, height: j } = v.getRect(), F = _.current.offsetHeight;
        if (k.style.top = `${N + window.pageYOffset + F + 3}px`, k.style.left = `${$ + window.pageXOffset}px`, k.style.height = `${j}px`, k.style.width = `${D}px`, I !== null) {
          I.style.top = `${N}`;
          const W = I.getBoundingClientRect(), z = W.height, H = W.width, U = C.getBoundingClientRect();
          $ + H > U.right && (k.style.left = `${U.right - H + window.pageXOffset}px`), (N + z > window.innerHeight || N + z > U.bottom) && N - U.top > z + j && (k.style.top = N - z + window.pageYOffset - j + "px");
        }
        k.isConnected || (w != null && (k.className = w), k.setAttribute("aria-label", "Typeahead menu"), k.setAttribute("id", "typeahead-menu"), k.setAttribute("role", "listbox"), k.style.display = "block", k.style.position = "absolute", S.append(k)), _.current = k, C.setAttribute("aria-controls", "typeahead-menu");
      }
    }, [A, v, w, S]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      const C = A.getRootElement();
      if (v !== null) return O(), () => {
        C !== null && C.removeAttribute("aria-controls");
        const k = _.current;
        k !== null && k.isConnected && k.remove();
      };
    }, [A, O, v]);
    const P = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((C) => {
      v !== null && (C || x(null));
    }, [v, x]);
    return kQ(v, _.current, O, P), _;
  }(d, p, s, c), y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    p(null), i != null && d !== null && i();
  }, [i, d]), g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((v) => {
    p(v), r != null && d === null && r(v);
  }, [r, d]);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const v = f.registerUpdateListener(() => {
      f.getEditorState().read(() => {
        const x = f._window || window, w = x.document.createRange(), S = Ne(), A = function(P) {
          let C = null;
          return P.getEditorState().read(() => {
            const k = Ne();
            we(k) && (C = function(I) {
              const $ = I.anchor;
              if ($.type !== "text") return null;
              const N = $.getNode();
              if (!N.isSimpleText()) return null;
              const D = $.offset;
              return N.getTextContent().slice(0, D);
            }(k));
          }), C;
        }(f);
        if (!we(S) || !S.isCollapsed() || A === null || w === null) return void y();
        const _ = a(A, f);
        if (t(_ ? _.matchingString : null), _ !== null && !function(P, C) {
          return C === 0 && P.getEditorState().read(() => {
            const k = Ne();
            if (we(k)) {
              const I = k.anchor.getNode().getPreviousSibling();
              return Se(I) && I.isTextEntity();
            }
            return !1;
          });
        }(f, _.leadOffset) && function(C, k, I) {
          const $ = I.getSelection();
          if ($ === null || !$.isCollapsed) return !1;
          const N = $.anchorNode, D = C, j = $.anchorOffset;
          if (N == null || j == null) return !1;
          try {
            k.setStart(N, D), k.setEnd(N, j);
          } catch {
            return !1;
          }
          return !0;
        }(_.leadOffset, w, x) !== null)
          return O = () => g({ getRect: () => w.getBoundingClientRect(), match: _ }), void (aE in react__WEBPACK_IMPORTED_MODULE_1__ ? react__WEBPACK_IMPORTED_MODULE_1__[aE](O) : O());
        var O;
        y();
      });
    });
    return () => {
      v();
    };
  }, [f, a, t, d, y, g]), d === null || f === null ? null : (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MQ, { close: y, resolution: d, editor: f, anchorElementRef: m, options: e, menuRenderFn: o, shouldSplitNodeWithQuery: !0, onSelectOption: n, commandPriority: l });
}
const $Q = (e) => {
  switch (e) {
    case "sm":
      return "xs";
    case "md":
      return "sm";
    case "lg":
      return "md";
    default:
      return "sm";
  }
}, DQ = ({
  data: e,
  by: t,
  size: n,
  nodeKey: r
}) => {
  const [i] = Gr(), o = !i.isEditable(), a = (f) => {
    f.stopPropagation(), f.preventDefault(), !o && i.update(() => {
      const d = $n(r);
      d && d.remove();
    });
  };
  let s = e;
  typeof e == "object" && (s = e[t]);
  const l = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (f) => {
      const d = $n(r);
      if (!d || !d.isSelected())
        return !1;
      let p = !1;
      const m = d.getPreviousSibling();
      return ve(m) && (m.selectEnd(), p = !0), Se(m) && (m.select(), p = !0), Ht(m) && (m.selectNext(), p = !0), m === null && (d.selectPrevious(), p = !0), p && f.preventDefault(), p;
    },
    [r]
  ), c = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (f) => {
      const d = $n(r);
      if (!d || !d.isSelected())
        return !1;
      let p = !1;
      const m = d.getNextSibling();
      return ve(m) && (m.selectStart(), p = !0), Se(m) && (m.select(0, 0), p = !0), Ht(m) && (m.selectPrevious(), p = !0), m === null && (d.selectNext(), p = !0), p && f.preventDefault(), p;
    },
    [r]
  );
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const f = Uo(
      i.registerCommand(
        J1,
        l,
        rc
      ),
      i.registerCommand(
        Z1,
        c,
        rc
      )
    );
    return () => {
      f();
    };
  }, [i, l, c]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    mg,
    {
      className: "inline-flex mr-0.5",
      type: "rounded",
      size: $Q(n),
      label: s,
      icon: null,
      closable: !0,
      onClose: a,
      disabled: o
    }
  );
};
class ic extends k2 {
  constructor(n, r, i, o) {
    super(o);
    ha(this, "__data");
    ha(this, "__by");
    ha(this, "__size");
    this.__data = n, this.__by = r, this.__size = i;
  }
  static getType() {
    return "mention";
  }
  static clone(n) {
    return new ic(n.__data, n.__by, n.__size, n.__key);
  }
  static importJSON(n) {
    return L2(
      n.data,
      n.by,
      n.size
    );
  }
  createDOM() {
    return document.createElement("span");
  }
  updateDOM() {
    return !1;
  }
  exportDOM() {
    return { element: document.createElement("span") };
  }
  exportJSON() {
    return {
      type: ic.getType(),
      data: this.__data,
      by: this.__by,
      size: this.__size,
      version: 1
    };
  }
  decorate() {
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      DQ,
      {
        data: this.__data,
        by: this.__by,
        size: this.__size,
        nodeKey: this.__key
      }
    );
  }
}
const L2 = (e, t, n) => new ic(e, t, n), IQ = (e) => e instanceof ic;
class RQ {
  constructor(t) {
    ha(this, "data");
    ha(this, "key");
    ha(this, "ref");
    ha(this, "setRefElement");
    this.initData = t, this.key = "", this.data = t, this.ref = { current: null }, this.setRefElement = (n) => {
      this.ref.current = n;
    };
  }
}
const Ob = /* @__PURE__ */ new Map();
function jQ(e, t, n = "name") {
  const [r, i] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (t === null) {
      i([]);
      return;
    }
    const o = Ob.get(t);
    if (o !== null) {
      if (o !== void 0) {
        i(o);
        return;
      }
      Ob.set(t, null), LQ.search(
        e,
        t,
        (a) => {
          Ob.set(t, a), i(a);
        },
        n
      );
    }
  }, [t]), r;
}
const LQ = {
  search(e, t, n, r) {
    setTimeout(() => {
      if (!Array.isArray(e))
        return [];
      const i = e.filter(
        (o) => {
          var s;
          if (typeof o == "string")
            return o.toLowerCase().includes(t.toLowerCase());
          const a = (s = o == null ? void 0 : o[r]) == null ? void 0 : s.toString();
          return a ? a.toLowerCase().includes(t.toLowerCase()) : !1;
        }
      );
      n(i);
    }, 500);
  }
}, Hp = ({ size: e, className: t, children: n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "ul",
  {
    role: "menu",
    className: K(
      OQ,
      AQ[e],
      t
    ),
    children: n
  }
);
Hp.displayName = "EditorCombobox";
const B2 = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({ size: e, children: t, selected: n = !1, className: r, ...i }, o) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "li",
    {
      role: "option",
      ref: o,
      className: K(
        TQ,
        PQ[e],
        n && CQ,
        r
      ),
      ...i,
      children: t
    }
  )
);
B2.displayName = "EditorCombobox.Item";
Hp.Item = B2;
const BQ = ({
  optionsArray: e,
  by: t = "name",
  size: n = "md",
  trigger: r = "@",
  // Default trigger value
  menuComponent: i = Hp,
  menuItemComponent: o = Hp.Item,
  autoSpace: a = !0
}) => {
  const s = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(!1), l = `\\.,\\+\\*\\?\\$\\@\\|#{}\\(\\)\\^\\-\\[\\]\\\\/!%'"~=<>_:;`, c = [r].join(""), f = "[^" + c + l + "\\s]", d = "(?:\\.[ |$]| |[" + l + "]|)", p = 75, m = new RegExp(
    `(^|\\s|\\()([${c}]((?:${f}${d}){0,${p}}))$`
  ), y = 50, g = new RegExp(
    `(^|\\s|\\()([${c}]((?:${f}){0,${y}}))$`
  ), v = (k) => {
    let I = m.exec(k);
    if (I === null && (I = g.exec(k)), I !== null) {
      const $ = I[1], N = I[3];
      if (N.length >= 0)
        return {
          leadOffset: I.index + $.length,
          matchingString: N,
          replaceableString: I[2]
        };
    }
    return null;
  }, [x] = Gr(), [w, S] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), A = jQ(e, w, t), _ = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (k, I, $) => {
      x.update(() => {
        const N = L2(
          k.data,
          t,
          n
        );
        I && I.replace(N), $();
      });
    },
    [x]
  ), O = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => A.map((k) => new RQ(k)), [x, A]), P = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (k) => {
      if (!a)
        return !1;
      const { key: I, ctrlKey: $, metaKey: N } = k;
      if ($ || N || I === " " || I.length > 1 || s.current)
        return s.current && (s.current = !1), !1;
      const D = Ne(), { focus: j, anchor: F } = D, [W] = D.getNodes();
      if (!F || !j || (F == null ? void 0 : F.key) !== (j == null ? void 0 : j.key) || (F == null ? void 0 : F.offset) !== (j == null ? void 0 : j.offset) || !W)
        return !1;
      if (IQ(W)) {
        const z = Vn(" ");
        return W.insertAfter(z), !0;
      }
      return !1;
    },
    [x, r, a]
  ), C = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(
    (k) => {
      const { key: I } = k;
      return I === "Backspace" ? (s.current = !0, !0) : !1;
    },
    [s]
  );
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (x)
      return Uo(
        x.registerCommand(
          $R,
          P,
          rc
        ),
        x.registerCommand(
          Q1,
          C,
          rc
        )
      );
  }, [x, P]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    NQ,
    {
      onQueryChange: S,
      onSelectOption: _,
      triggerFn: v,
      options: O,
      menuRenderFn: (k, { selectedIndex: I, selectOptionAndCleanUp: $, setHighlightedIndex: N }) => k.current && (O != null && O.length) ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(i, { size: n, children: O.map((D, j) => {
        var F;
        return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          o,
          {
            ref: D.ref,
            size: n,
            selected: j === I,
            onMouseEnter: () => {
              N(j);
            },
            onClick: () => $(D),
            children: typeof D.data == "string" ? D.data : (F = D.data) == null ? void 0 : F[t]
          },
          j
        );
      }) }) : null
    }
  );
}, FQ = {
  ltr: "ltr",
  rtl: "rtl",
  paragraph: "editor-paragraph",
  quote: "editor-quote",
  heading: {
    h1: "editor-heading-h1",
    h2: "editor-heading-h2",
    h3: "editor-heading-h3",
    h4: "editor-heading-h4",
    h5: "editor-heading-h5",
    h6: "editor-heading-h6"
  },
  list: {
    nested: {
      listitem: "editor-nested-listitem"
    },
    ol: "editor-list-ol",
    ul: "editor-list-ul",
    listitem: "editor-listItem",
    listitemChecked: "editor-listItemChecked",
    listitemUnchecked: "editor-listItemUnchecked"
  },
  hashtag: "editor-hashtag",
  image: "editor-image",
  link: "editor-link",
  text: {
    bold: "editor-textBold",
    code: "editor-textCode",
    italic: "editor-textItalic",
    strikethrough: "editor-textStrikethrough",
    subscript: "editor-textSubscript",
    superscript: "editor-textSuperscript",
    underline: "editor-textUnderline",
    underlineStrikethrough: "editor-textUnderlineStrikethrough"
  },
  code: "editor-code",
  codeHighlight: {
    atrule: "editor-tokenAttr",
    attr: "editor-tokenAttr",
    boolean: "editor-tokenProperty",
    builtin: "editor-tokenSelector",
    cdata: "editor-tokenComment",
    char: "editor-tokenSelector",
    class: "editor-tokenFunction",
    "class-name": "editor-tokenFunction",
    comment: "editor-tokenComment",
    constant: "editor-tokenProperty",
    deleted: "editor-tokenProperty",
    doctype: "editor-tokenComment",
    entity: "editor-tokenOperator",
    function: "editor-tokenFunction",
    important: "editor-tokenVariable",
    inserted: "editor-tokenSelector",
    keyword: "editor-tokenAttr",
    namespace: "editor-tokenVariable",
    number: "editor-tokenProperty",
    operator: "editor-tokenOperator",
    prolog: "editor-tokenComment",
    property: "editor-tokenProperty",
    punctuation: "editor-tokenPunctuation",
    regex: "editor-tokenVariable",
    selector: "editor-tokenSelector",
    string: "editor-tokenSelector",
    symbol: "editor-tokenProperty",
    tag: "editor-tokenProperty",
    url: "editor-tokenOperator",
    variable: "editor-tokenVariable"
  }
}, WQ = ({ content: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    "aria-hidden": "true",
    className: "pointer-events-none absolute inset-0 flex items-center justify-start text-field-placeholder w-full",
    children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "truncate", children: e })
  }
);
function zQ(e) {
  console.error(e);
}
const VQ = `{
    "root": {
        "children": [
            {
                "children": [],
                "direction": null,
                "format": "",
                "indent": 0,
                "type": "paragraph",
                "version": 1,
                "textFormat": 0,
                "textStyle": ""
            }
        ],
        "direction": null,
        "format": "",
        "indent": 0,
        "type": "root",
        "version": 1
    }
}`, UQ = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    defaultValue: e = "",
    placeholder: t = "Press @ to view variable suggestions",
    onChange: n,
    size: r = "md",
    autoFocus: i = !1,
    options: o,
    by: a = "name",
    trigger: s = "@",
    menuComponent: l,
    menuItemComponent: c,
    className: f,
    wrapperClassName: d,
    disabled: p = !1,
    autoSpaceAfterMention: m = !1
  }, y) => {
    const g = {
      namespace: "Editor",
      editorTheme: FQ,
      onError: zQ,
      nodes: [ic],
      editorState: e || VQ,
      editable: !p
    }, v = (S, A) => {
      typeof n == "function" && n(S, A);
    };
    let x, w;
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(l) && (x = l), (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(c) && (w = c), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "div",
      {
        className: K(
          "relative w-full",
          wQ,
          SQ[r],
          p && _Q,
          d
        ),
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(PJ, { initialConfig: g, children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "relative w-full [&_p]:m-0", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            eQ,
            {
              contentEditable: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                iQ,
                {
                  className: K(
                    "editor-content focus-visible:outline-none outline-none",
                    xQ,
                    f
                  )
                }
              ),
              placeholder: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WQ, { content: t }),
              ErrorBoundary: gQ
            }
          ) }),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(pQ, {}),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            BQ,
            {
              menuComponent: x,
              menuItemComponent: w,
              size: r,
              by: a,
              optionsArray: o,
              trigger: s,
              autoSpace: m
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            vQ,
            {
              onChange: v,
              ignoreSelectionChange: !0
            }
          ),
          y && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(bQ, { editorRef: y }),
          i && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(vZ, {})
        ] })
      }
    );
  }
);
UQ.displayName = "EditorInput";
const HQ = (e, t, n, r) => {
  const i = `absolute rounded-full transition-colors duration-500 ${n[r].dot}`;
  return e === "dot" ? K(
    i,
    n[r].dot,
    t ? "bg-brand-primary-600" : "bg-text-tertiary"
  ) : e === "number" ? K(
    i,
    n[r].dot,
    t ? "text-brand-primary-600" : "text-text-tertiary",
    "flex items-center justify-center"
  ) : e === "icon" ? K(
    i,
    t ? "text-brand-primary-600" : "text-text-tertiary",
    "flex items-center justify-center"
  ) : "";
}, KQ = (e, t, n) => K(
  "relative flex items-center rounded-full justify-center transition-colors z-10 duration-500 ring-1",
  e ? "ring-brand-primary-600" : "ring-border-subtle",
  t[n].ring
), GQ = (e, t) => K(
  "rounded-full text-brand-primary-600 transition-colors duration-300",
  e[t].dot,
  e[t].ring
), YQ = {
  sm: {
    dot: "size-2.5",
    ring: "size-5",
    numberIcon: "size-5 text-tiny",
    icon: "size-5",
    label: "text-xs"
  },
  md: {
    dot: "size-3",
    ring: "size-6",
    numberIcon: "size-6 text-sm",
    icon: "size-6",
    label: "text-sm"
  },
  lg: {
    dot: "size-3.5",
    ring: "size-7",
    numberIcon: "size-7 text-md",
    icon: "size-7",
    label: "text-sm"
  }
}, qQ = ({
  variant: e = "dot",
  size: t = "sm",
  type: n = "inline",
  currentStep: r = 1,
  children: i,
  className: o,
  lineClassName: a = "min-w-10",
  ...s
}) => {
  const l = react__WEBPACK_IMPORTED_MODULE_1__.Children.count(i);
  r === -1 && (r = l + 1);
  const c = react__WEBPACK_IMPORTED_MODULE_1__.Children.map(i, (f, d) => {
    const p = d + 1 < r, m = d + 1 === r, y = d + 1 === l, g = {
      isCompleted: p,
      isCurrent: m,
      sizeClasses: YQ,
      size: t,
      variant: e,
      type: n,
      isLast: y,
      index: d,
      lineClassName: a
    };
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(f) ? react__WEBPACK_IMPORTED_MODULE_1__.cloneElement(f, g) : f }, d);
  });
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex w-full",
        o,
        n === "inline" ? "items-center justify-between" : ""
      ),
      ...s,
      children: c
    }
  );
}, F2 = ({
  labelText: e = "",
  icon: t = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(nD, {}),
  isCurrent: n,
  isCompleted: r,
  className: i,
  type: o,
  variant: a,
  sizeClasses: s,
  size: l,
  isLast: c,
  index: f,
  lineClassName: d,
  ...p
}) => {
  const m = XQ(
    a,
    r,
    n,
    s,
    l,
    t,
    f
  ), y = {
    lg: "left-[calc(50%+14px)] right-[calc(-50%+14px)]",
    md: "left-[calc(50%+12px)] right-[calc(-50%+12px)]",
    sm: "left-[calc(50%+10px)] right-[calc(-50%+10px)]"
  }, g = {
    lg: "top-3.5",
    md: "top-3",
    sm: "top-2.5"
  }, v = () => {
    if (e) {
      const w = K(
        s[l].label,
        "text-text-tertiary",
        n ? "text-brand-primary-600" : "",
        "break-word",
        // max width for inline and stack
        o === "stack" ? "mt-2 transform max-w-xs" : "mx-2 max-w-32"
      );
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: w, children: e });
    }
    return null;
  }, x = () => {
    if (!c) {
      const w = K(
        "block",
        r ? "border-brand-primary-600" : "border-border-subtle",
        d
      );
      return o === "stack" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          className: K(
            "relative",
            "flex",
            "border-solid",
            "border-y",
            "absolute",
            r ? "border-brand-primary-600" : "border-border-subtle",
            g[l],
            y[l]
          ),
          children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "block" })
        }
      ) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "flex-1", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "span",
        {
          className: K(
            "mr-2 border-y border-solid",
            !e && "ml-2",
            w
          )
        }
      ) });
    }
    return null;
  };
  return o === "stack" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "relative flex-1 justify-center", children: [
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        className: K("flex items-center flex-col", i),
        ...p,
        children: [
          m,
          v()
        ]
      }
    ),
    x()
  ] }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("flex items-center", i), ...p, children: [
      m,
      v()
    ] }),
    x()
  ] });
};
F2.displayName = "ProgressSteps.Step";
const XQ = (e, t, n, r, i, o, a) => {
  if (t)
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(sd, { className: GQ(r, i) });
  const s = KQ(!!n, r, i), l = HQ(
    e,
    n,
    r,
    i
  );
  let c = null;
  return e === "number" ? c = a + 1 : e === "icon" && o && (c = o), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: s, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: l, children: c }) });
};
qQ.Step = F2;
const rke = ({
  variant: e = "rectangular",
  // rectangular, circular
  className: t,
  ...n
}) => {
  const r = {
    circular: "rounded-full bg-gray-200 ",
    rectangular: "rounded-md bg-gray-200"
  }[e], i = {
    circular: "size-10",
    rectangular: "w-96 h-3"
  }[e];
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        r,
        "animate-pulse",
        i,
        t
      ),
      ...n
    }
  );
}, W2 = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), z2 = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(W2), Ha = ({ size: e = "md", children: t, className: n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(W2.Provider, { value: { size: e }, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("flex flex-col bg-background-primary p-2", n), children: t }) });
Ha.displayName = "Menu";
const V2 = ({
  heading: e,
  arrow: t = !1,
  showArrowOnHover: n = !1,
  // Prop to toggle hover-based arrow display
  open: r = !0,
  onClick: i,
  children: o,
  className: a
}) => {
  const [s, l] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(r), [c, f] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), { size: d } = z2(), p = "text-text-primary bg-transparent cursor-pointer flex justify-between items-center gap-1", m = {
    sm: "text-xs",
    md: "text-sm"
  }[d ?? "md"], y = {
    sm: "size-4",
    md: "size-5"
  }[d ?? "md"], g = () => {
    l(!s), i && i(!s);
  }, v = {
    open: { rotate: 180 },
    closed: { rotate: 0 }
  }, x = {
    open: { height: "auto", opacity: 1 },
    closed: { height: 0, opacity: 0 }
  }, w = {
    visible: { opacity: 1 },
    hidden: { opacity: 0 }
  }, S = () => n ? s || c ? "visible" : "hidden" : "visible";
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [
    !!e && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        role: "button",
        tabIndex: 0,
        onClick: g,
        onKeyDown: (A) => {
          (A.key === "Enter" || A.key === " ") && g();
        },
        onMouseEnter: () => n && f(!0),
        onMouseLeave: () => n && f(!1),
        className: K(
          p,
          m,
          e ? "p-1" : "p-0",
          a
        ),
        "aria-expanded": s,
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "text-text-tertiary", children: e }),
          t && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            An.span,
            {
              className: "flex items-center text-border-strong",
              initial: "hidden",
              animate: S(),
              exit: "hidden",
              variants: w,
              transition: { duration: 0.15 },
              children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                An.span,
                {
                  className: "inline-flex p-1",
                  variants: v,
                  animate: s ? "open" : "closed",
                  transition: { duration: 0.15 },
                  children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
                    Xw,
                    {
                      className: K("shrink-0", y)
                    }
                  )
                }
              )
            }
          )
        ]
      }
    ),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { initial: !1, children: s && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      An.ul,
      {
        role: "menu",
        variants: x,
        initial: "closed",
        animate: "open",
        exit: "closed",
        transition: { duration: 0.3, ease: "easeInOut" },
        className: "overflow flex gap-0.5 flex-col m-0 bg-white rounded p-0",
        children: o
      }
    ) })
  ] });
};
V2.displayName = "Menu.List";
const U2 = ({
  disabled: e = !1,
  active: t,
  onClick: n,
  children: r,
  className: i
}) => {
  const { size: o } = z2(), a = "flex p-1 gap-1 items-center bg-transparent border-none rounded text-text-secondary cursor-pointer m-0", s = {
    sm: "[&>svg]:size-4 [&>svg]:m-1 [&>*:not(svg)]:mx-1 [&>*:not(svg)]:my-0.5 text-sm",
    md: "[&>svg]:size-5 [&>svg]:m-1.5 [&>*:not(svg)]:m-1 text-base"
  }[o ?? "md"];
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "li",
    {
      role: "menuitem",
      tabIndex: 0,
      onClick: n,
      onKeyDown: (p) => {
        (p.key === "Enter" || p.key === " ") && (n == null || n());
      },
      className: K(
        a,
        s,
        "hover:bg-background-secondary hover:text-text-primary",
        e ? "text-text-disabled hover:text-text-disabled cursor-not-allowed hover:bg-transparent" : "",
        t ? "text-icon-primary [&>svg]:text-icon-interactive bg-background-secondary" : "",
        "transition-colors duration-300 ease-in-out",
        i
      ),
      children: r
    }
  );
};
U2.displayName = "Menu.Item";
const H2 = ({
  variant: e = "solid",
  className: t
}) => {
  const n = {
    solid: "border-solid",
    dashed: "border-dashed",
    dotted: "border-dotted",
    double: "border-double",
    hidden: "border-hidden",
    none: "border-none"
  }[e];
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: "m-0 p-0 list-none", role: "separator", "aria-hidden": "true", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "hr",
    {
      className: K(
        "w-full border-0 border-t border-border-subtle",
        n,
        t
      )
    }
  ) });
};
H2.displayName = "Menu.Separator";
Ha.List = V2;
Ha.Item = U2;
Ha.Separator = H2;
const K2 = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
  isCollapsed: !1,
  setIsCollapsed: () => {
  },
  collapsible: !0
}), G2 = ({
  children: e,
  className: t,
  onCollapseChange: n,
  collapsible: r = !0,
  borderOn: i = !0,
  ...o
}) => {
  const a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), [s, l] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => {
    const c = ju.get("sidebar-collapsed"), f = window.innerWidth < 1280;
    return c || f;
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    n && n(s);
  }, [s, n]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const c = () => {
      const f = window.innerWidth < 1280;
      if (!r)
        l(!1), ju.remove("sidebar-collapsed");
      else if (f)
        l(!0), ju.set("sidebar-collapsed", !0);
      else {
        const d = ju.get("sidebar-collapsed");
        l(d || !1);
      }
    };
    return window.addEventListener("resize", c), c(), () => {
      window.removeEventListener("resize", c);
    };
  }, [r]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    K2.Provider,
    {
      value: { isCollapsed: s, setIsCollapsed: l, collapsible: r },
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          ref: a,
          className: K(
            "h-full overflow-auto w-72 px-4 py-4 gap-4 flex flex-col bg-background-primary",
            i && "border-0 border-r border-solid border-border-subtle",
            "transition-all duration-200",
            s && "w-16 px-2",
            t
          ),
          ...o,
          children: e
        }
      )
    }
  );
};
G2.displayName = "Sidebar";
const Y2 = ({ children: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "space-y-2", children: e });
Y2.displayName = "Sidebar.Header";
const q2 = ({ children: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("space-y-4 grow items-start"), children: e });
q2.displayName = "Sidebar.Body";
const X2 = ({ children: e }) => {
  const { isCollapsed: t, setIsCollapsed: n, collapsible: r } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(K2);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "space-y-4", children: [
    e,
    r && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "button",
      {
        className: K(
          "bg-transparent w-full border-0 p-0 m-0 flex items-center gap-2 text-base cursor-pointer",
          t && "justify-center"
        ),
        onClick: () => {
          n(!t), ju.set("sidebar-collapsed", !t);
        },
        "aria-label": t ? "Expand sidebar" : "Collapse sidebar",
        children: t ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(f1, { title: "Expand", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(tK, { className: "size-5" }) }) }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(eK, { className: "size-5" }),
          " Collapse"
        ] })
      }
    )
  ] });
};
X2.displayName = "Sidebar.Footer";
const Z2 = ({ children: e, className: t }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("w-full", t), children: e });
Z2.displayName = "Sidebar.Item";
const ike = Object.assign(G2, {
  Header: Y2,
  Body: q2,
  Footer: X2,
  Item: Z2
}), cx = {
  sm: {
    text: "text-sm",
    separator: "text-sm",
    separatorIconSize: 16
  },
  md: {
    text: "text-base",
    separator: "text-base",
    separatorIconSize: 18
  }
}, wd = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({ sizes: cx.sm }), Xs = ({ children: e, size: t = "sm" }) => {
  const n = cx[t] || cx.sm;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(wd.Provider, { value: { sizes: n }, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("nav", { className: "flex m-0", "aria-label": "Breadcrumb", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { className: "m-0 inline-flex items-center space-x-1 md:space-x-1", children: e }) }) });
};
Xs.displayName = "Breadcrumb";
const J2 = ({ children: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: e });
J2.displayName = "Breadcrumb.List";
const Q2 = ({ children: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: "m-0 inline-flex items-center gap-2", children: e });
Q2.displayName = "Breadcrumb.Item";
const ej = ({
  href: e,
  children: t,
  className: n,
  as: r = "a",
  ...i
}) => {
  const { sizes: o } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wd);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    r,
    {
      href: e,
      className: K(
        o.text,
        "px-1 font-medium no-underline text-text-tertiary hover:text-text-primary hover:underline",
        "focus:outline-none focus:ring-1 focus:ring-border-interactive focus:border-border-interactive focus:rounded-sm",
        "transition-all duration-200",
        n
      ),
      ...i,
      children: t
    }
  );
};
ej.displayName = "Breadcrumb.Link";
const tj = ({ type: e }) => {
  const { sizes: t } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wd), n = {
    slash: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: K("mx-1", t.separator), children: "/" }),
    arrow: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Zw, { size: t.separatorIconSize })
  };
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "li",
    {
      role: "separator",
      className: "flex items-center text-text-tertiary mx-2 p-0 list-none",
      "aria-hidden": "true",
      children: n[e] || n.arrow
    }
  );
};
tj.displayName = "Breadcrumb.Separator";
const nj = () => {
  const { sizes: e } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wd);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    XH,
    {
      className: "mt-[2px] cursor-pointer text-text-tertiary hover:text-text-primary",
      size: e.separatorIconSize + 4
    }
  );
};
nj.displayName = "Breadcrumb.Ellipsis";
const rj = ({ children: e }) => {
  const { sizes: t } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(wd);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: K(t.text, "font-medium text-text-primary"), children: e });
};
rj.displayName = "Breadcrumb.Page";
Xs.List = J2;
Xs.Item = Q2;
Xs.Link = ej;
Xs.Separator = tj;
Xs.Ellipsis = nj;
Xs.Page = rj;
const ij = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), Wg = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(ij), oj = {
  open: {
    opacity: 1
  },
  exit: {
    opacity: 0
  }
}, aj = { duration: 0.2 }, Xo = ({
  open: e,
  setOpen: t,
  children: n,
  trigger: r = null,
  className: i,
  exitOnClickOutside: o = !1,
  exitOnEsc: a = !0,
  design: s = "simple",
  scrollLock: l = !0
}) => {
  const c = e !== void 0 && t !== void 0, [f, d] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), p = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), m = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => c ? e : f,
    [e, f]
  ), g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => c ? t : d,
    [d, d]
  ), v = () => {
    y || g(!0);
  }, x = () => {
    y && g(!1);
  }, w = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    var _;
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(r) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(r, {
      onClick: cf(v, (_ = r == null ? void 0 : r.props) == null ? void 0 : _.onClick)
    }) : typeof r == "function" ? r({ onClick: v }) : null;
  }, [r, v, x]), S = (_) => {
    switch (_.key) {
      case "Escape":
        a && x();
        break;
    }
  }, A = (_) => {
    o && p.current && !p.current.contains(_.target) && x();
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => (window.addEventListener("keydown", S), document.addEventListener("mousedown", A), () => {
    window.removeEventListener("keydown", S), document.removeEventListener("mousedown", A);
  }), [y]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!l)
      return;
    const _ = document.querySelector("html");
    return y && _ && (_.style.overflow = "hidden"), () => {
      _ && (_.style.overflow = "");
    };
  }, [y]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
    w(),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      ij.Provider,
      {
        value: {
          open: y,
          setOpen: g,
          handleClose: x,
          design: s,
          dialogContainerRef: m,
          dialogRef: p
        },
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "div",
          {
            ref: m,
            className: K(
              "fixed z-999999 w-0 h-0 overflow-visible",
              i
            ),
            children: n
          }
        )
      }
    )
  ] });
};
Xo.displayName = "Dialog";
const sj = ({
  children: e,
  className: t
}) => {
  const { open: n, handleClose: r, dialogRef: i } = Wg();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { children: n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    An.div,
    {
      className: "fixed inset-0 overflow-y-auto",
      initial: "exit",
      animate: "open",
      exit: "exit",
      variants: oj,
      role: "dialog",
      transition: aj,
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "flex items-center justify-center min-h-full", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        "div",
        {
          ref: i,
          className: K(
            "flex flex-col gap-5 w-120 h-fit bg-background-primary border border-solid border-border-subtle rounded-xl shadow-soft-shadow-2xl my-5 overflow-hidden",
            t
          ),
          children: typeof e == "function" ? e({ close: r }) : e
        }
      ) })
    }
  ) });
};
sj.displayName = "Dialog.Panel";
const lj = ({
  className: e,
  ...t
}) => {
  const { open: n, dialogContainerRef: r } = Wg();
  return r != null && r.current ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)(
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { children: n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      An.div,
      {
        className: K(
          "fixed inset-0 -z-10 bg-background-inverse/90",
          e
        ),
        ...t,
        initial: "exit",
        animate: "open",
        exit: "exit",
        variants: oj,
        transition: aj
      }
    ) }),
    r.current
  ) }) : null;
};
lj.displayName = "Dialog.Backdrop";
const cj = ({
  children: e,
  className: t,
  ...n
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("space-y-2 px-5 pt-5 pb-1", t), ...n, children: e });
cj.displayName = "Dialog.Header";
const uj = ({
  children: e,
  as: t = "h3",
  className: n,
  ...r
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  t,
  {
    className: K(
      "text-base font-semibold text-text-primary m-0 p-0",
      n
    ),
    ...r,
    children: e
  }
);
uj.displayName = "Dialog.Title";
const fj = ({
  children: e,
  as: t = "p",
  className: n,
  ...r
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  t,
  {
    className: K(
      "text-sm font-normal text-text-secondary my-0 ml-0 mr-1 p-0",
      n
    ),
    ...r,
    children: e
  }
);
fj.displayName = "Dialog.Description";
const ZQ = ({
  className: e,
  ...t
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "button",
  {
    className: K(
      "bg-transparent inline-flex justify-center items-center border-0 p-1 m-0 cursor-pointer focus:outline-none outline-none shadow-none",
      e
    ),
    "aria-label": "Close dialog",
    ...t,
    children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, { className: "size-4 text-text-primary shrink-0" })
  }
), dj = ({
  children: e,
  as: t = react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
  ...n
}) => {
  const { handleClose: r } = Wg();
  return e ? t === react__WEBPACK_IMPORTED_MODULE_1__.Fragment ? typeof e == "function" ? e({
    close: r
  }) : (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(e, {
    onClick: r
  }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(t, { ...n, onClick: r, children: e }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ZQ, { onClick: r, ...n });
};
dj.displayName = "Dialog.CloseButton";
const hj = ({
  children: e,
  className: t,
  ...n
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("px-5", t), ...n, children: e });
hj.displayName = "Dialog.Body";
const pj = ({
  children: e,
  className: t
}) => {
  const { design: n, handleClose: r } = Wg(), i = () => e ? typeof e == "function" ? e({ close: r }) : e : null;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "p-4 flex justify-end gap-3",
        {
          "bg-background-secondary": n === "footer-divided"
        },
        t
      ),
      children: i()
    }
  );
};
pj.displayName = "Dialog.Footer";
Xo.Panel = sj;
Xo.Title = uj;
Xo.Description = fj;
Xo.CloseButton = dj;
Xo.Header = cj;
Xo.Body = hj;
Xo.Footer = pj;
Xo.Backdrop = lj;
const _d = ({
  children: e,
  gap: t = "lg",
  className: n,
  ...r
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    className: K(
      "w-full box-border flex items-center justify-between bg-background-primary p-5 min-h-16",
      Jm(t),
      n
    ),
    ...r,
    children: e
  }
);
_d.displayName = "Topbar";
const mj = ({ gap: e = "sm", children: t, className: n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("flex items-center", Jm(e), n), children: t });
mj.displayName = "Topbar.Left";
const gj = ({
  gap: e = "md",
  children: t,
  align: n = "center",
  className: r
}) => {
  const i = {
    left: "justify-start",
    center: "justify-center",
    right: "justify-end"
  }[n];
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex items-center grow",
        Jm(e),
        i,
        r
      ),
      children: t
    }
  );
};
gj.displayName = "Topbar.Middle";
const yj = ({ gap: e = "sm", children: t, className: n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("flex items-center", Jm(e), n), children: t });
yj.displayName = "Topbar.Right";
const vj = ({ children: e, className: t }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    className: K("flex items-center [&>svg]:block h-full", t),
    children: e
  }
);
vj.displayName = "Topbar.Item";
_d.Left = mj;
_d.Middle = gj;
_d.Right = yj;
_d.Item = vj;
const JQ = (e) => {
  if (!e)
    return { error: "Element not found." };
  const t = e.getBoundingClientRect(), n = window.innerWidth, r = n / 2, i = t.right < r, o = t.left > r;
  return {
    isLeft: i,
    isRight: o,
    isCenter: !i && !o,
    elementRect: {
      left: t.left,
      right: t.right,
      width: t.width
    },
    viewport: {
      width: n,
      center: r
    }
  };
}, bj = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), QQ = bj.Provider, xj = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(bj), eee = (e) => {
  const t = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)({ width: 0, height: 0 });
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    e.current && (t.current.width = e.current.offsetWidth, t.current.height = e.current.offsetHeight);
  }, []), t.current;
}, tee = (e, t, n) => {
  if (!e || !t)
    return {
      open: () => ({}),
      closed: () => ({})
    };
  const r = e == null ? void 0 : e.getBoundingClientRect(), i = t == null ? void 0 : t.getBoundingClientRect(), o = n ? (r == null ? void 0 : r.x) - (i == null ? void 0 : i.x) + (r == null ? void 0 : r.width) / 2 : (i == null ? void 0 : i.width) - ((i == null ? void 0 : i.right) - (r == null ? void 0 : r.x)) + (r == null ? void 0 : r.width) / 2, a = (r == null ? void 0 : r.y) - (i == null ? void 0 : i.y) + (r == null ? void 0 : r.height) / 2, s = (r == null ? void 0 : r.width) / 2;
  return {
    open: (l = 1e3) => ({
      clipPath: `circle(${l * 2 + 200}px at ${o}px ${a}px)`,
      background: "rgb(255, 255, 255, 1)",
      transition: {
        type: "spring",
        stiffness: 20,
        restDelta: 2,
        background: {
          duration: 0
        }
      }
    }),
    closed: {
      clipPath: `circle(${s}px at ${o}px ${a}px)`,
      background: "rgb(255, 255, 255, 0)",
      transition: {
        delay: 0.5,
        type: "spring",
        stiffness: 400,
        damping: 40,
        background: {
          duration: 0,
          delay: 1e3
        }
      }
    }
  };
}, Ab = (e) => (
  // @ts-expect-error Framer Motion types are not compatible with SVGPathElement
  /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    An.path,
    {
      className: "stroke-icon-primary",
      fill: "transparent",
      strokeWidth: "3",
      strokeLinecap: "round",
      ...e
    }
  )
), wj = ({ className: e }) => {
  const { toggleOpen: t, setTriggerRef: n } = xj();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    Hn,
    {
      ref: n,
      className: K(
        "relative z-[1] rounded-full hover:shadow-sm focus:[box-shadow:none] pointer-events-auto bg-background-primary",
        e
      ),
      variant: "ghost",
      size: "xs",
      onClick: t,
      "aria-label": "Toggle menu",
      icon: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
        An.svg,
        {
          className: "shrink-0 stroke-icon-primary",
          width: "23",
          height: "23",
          variants: {
            open: {
              viewBox: "0 0 20 20"
            },
            closed: {
              viewBox: "0 0 23 18"
            }
          },
          children: [
            /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              Ab,
              {
                variants: {
                  closed: { d: "M 2 2.5 L 20 2.5" },
                  open: { d: "M 3 16.5 L 17 2.5" }
                }
              }
            ),
            /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              Ab,
              {
                d: "M 2 9.423 L 20 9.423",
                variants: {
                  closed: { opacity: 1 },
                  open: { opacity: 0 }
                },
                transition: { duration: 0.1 }
              }
            ),
            /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
              Ab,
              {
                variants: {
                  closed: { d: "M 2 16.346 L 20 16.346" },
                  open: { d: "M 3 2.5 L 17 16.346" }
                }
              }
            )
          ]
        }
      )
    }
  );
}, nee = {
  open: {
    transition: { staggerChildren: 0.07, delayChildren: 0.2 }
  },
  closed: {
    transition: { staggerChildren: 0.05, staggerDirection: -1 }
  }
}, _j = ({
  tag: e = "a",
  active: t,
  icon: n,
  iconPosition: r = "left",
  className: i,
  children: o,
  ...a
}) => {
  var f;
  let s = null, l = null;
  const c = n && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(n) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(n, {
    key: "left-icon",
    className: K(
      "size-5",
      t ? "text-brand-800" : "text-icon-secondary",
      ((f = n.props) == null ? void 0 : f.className) ?? ""
    )
  }) : null;
  switch (r) {
    case "left":
      s = c;
      break;
    case "right":
      l = c;
      break;
    default:
      s = null, l = null;
      break;
  }
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(iee, { children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    e,
    {
      className: K(
        "w-full no-underline hover:no-underline text-text-primary text-lg font-medium flex items-center gap-2 px-2.5 py-1.5 rounded-md hover:bg-background-secondary hover:text-text-primary focus:outline-none focus:shadow-none transition ease-in-out duration-150",
        t ? "text-text-primary bg-background-secondary" : "text-text-secondary",
        i
      ),
      ...a,
      children: [
        !!s && s,
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "contents", children: o }),
        !!l && l
      ]
    }
  ) });
}, ree = {
  open: {
    y: 0,
    opacity: 1,
    transition: {
      y: { stiffness: 1e3, velocity: -100 }
    }
  },
  closed: {
    y: 50,
    opacity: 0,
    transition: {
      y: { stiffness: 1e3 }
    }
  }
}, iee = ({ children: e }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  An.li,
  {
    className: "m-0 p-0 flex items-center justify-start w-full",
    variants: ree,
    whileHover: { scale: 1.05 },
    whileTap: { scale: 0.95 },
    children: e
  }
), Sj = ({ children: e, className: t }) => {
  const { triggerRef: n, triggerOnRight: r, triggerOnLeft: i } = xj(), [o, a] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  return n ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    An.div,
    {
      ref: a,
      className: K(
        "absolute top-0 bottom-0 w-80 h-screen",
        r ? "right-0" : "left-0",
        t
      ),
      children: [
        o && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          An.div,
          {
            className: K(
              "bg-background-primary shadow-lg absolute top-0 bottom-0 w-80 border-y-0 border-l-0 border-r border-solid border-border-subtle",
              r ? "right-0" : "left-0"
            ),
            variants: tee(
              n,
              o,
              i ?? !1
            )
          }
        ),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          An.ul,
          {
            variants: nee,
            className: K(
              "relative mt-14 mb-0 w-full px-5 pb-5 pt-2 flex flex-col items-start justify-start gap-0.5",
              t
            ),
            children: e
          }
        )
      ]
    }
  ) : null;
}, zg = ({ className: e, children: t }) => {
  const [n, r] = KX(!1, !0), [i, o] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null), a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), { height: s } = eee(a), { isRight: l = !1, isLeft: c = !0 } = JQ(i);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(QQ, { value: {
    isOpen: n,
    toggleOpen: r,
    setTriggerRef: (p) => {
      (0,react__WEBPACK_IMPORTED_MODULE_1__.startTransition)(() => {
        o(p);
      });
    },
    triggerRef: i,
    triggerOnRight: l,
    triggerOnLeft: c
  }, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("size-6 z-[1]", e), children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    An.nav,
    {
      className: "h-full",
      initial: !1,
      animate: n ? "open" : "closed",
      custom: s,
      variants: {
        open: {
          pointerEvents: "auto"
        },
        closed: {
          pointerEvents: "none"
        }
      },
      ref: a,
      children: t
    }
  ) }) });
};
zg.displayName = "HamburgerMenu";
wj.displayName = "HamburgerMenu.Toggle";
Sj.displayName = "HamburgerMenu.Options";
_j.displayName = "HamburgerMenu.Option";
zg.Options = Sj;
zg.Option = _j;
zg.Toggle = wj;
var Kp = { exports: {} };
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
Kp.exports;
(function(e, t) {
  (function() {
    var n, r = "4.17.21", i = 200, o = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", a = "Expected a function", s = "Invalid `variable` option passed into `_.template`", l = "__lodash_hash_undefined__", c = 500, f = "__lodash_placeholder__", d = 1, p = 2, m = 4, y = 1, g = 2, v = 1, x = 2, w = 4, S = 8, A = 16, _ = 32, O = 64, P = 128, C = 256, k = 512, I = 30, $ = "...", N = 800, D = 16, j = 1, F = 2, W = 3, z = 1 / 0, H = 9007199254740991, U = 17976931348623157e292, V = NaN, Y = 4294967295, Q = Y - 1, ne = Y >>> 1, re = [
      ["ary", P],
      ["bind", v],
      ["bindKey", x],
      ["curry", S],
      ["curryRight", A],
      ["flip", k],
      ["partial", _],
      ["partialRight", O],
      ["rearg", C]
    ], ce = "[object Arguments]", oe = "[object Array]", fe = "[object AsyncFunction]", ae = "[object Boolean]", ee = "[object Date]", se = "[object DOMException]", ge = "[object Error]", X = "[object Function]", $e = "[object GeneratorFunction]", de = "[object Map]", ke = "[object Number]", it = "[object Null]", lt = "[object Object]", Xn = "[object Promise]", Ie = "[object Proxy]", ct = "[object RegExp]", Oe = "[object Set]", Ge = "[object String]", Zt = "[object Symbol]", mt = "[object Undefined]", en = "[object WeakMap]", Yr = "[object WeakSet]", Cn = "[object ArrayBuffer]", yn = "[object DataView]", mr = "[object Float32Array]", tt = "[object Float64Array]", Kt = "[object Int8Array]", St = "[object Int16Array]", jn = "[object Int32Array]", qr = "[object Uint8Array]", lo = "[object Uint8ClampedArray]", un = "[object Uint16Array]", Pr = "[object Uint32Array]", fn = /\b__p \+= '';/g, Xr = /\b(__p \+=) '' \+/g, yt = /(__e\(.*?\)|\b__t\)) \+\n'';/g, Rd = /&(?:amp|lt|gt|quot|#39);/g, jd = /[&<>"']/g, Ey = RegExp(Rd.source), nu = RegExp(jd.source), ru = /<%-([\s\S]+?)%>/g, Ez = /<%([\s\S]+?)%>/g, WS = /<%=([\s\S]+?)%>/g, kz = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, Mz = /^\w*$/, Nz = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g, ky = /[\\^$.*+?()[\]{}|]/g, $z = RegExp(ky.source), My = /^\s+/, Dz = /\s/, Iz = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, Rz = /\{\n\/\* \[wrapped with (.+)\] \*/, jz = /,? & /, Lz = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g, Bz = /[()=,{}\[\]\/\s]/, Fz = /\\(\\)?/g, Wz = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g, zS = /\w*$/, zz = /^[-+]0x[0-9a-f]+$/i, Vz = /^0b[01]+$/i, Uz = /^\[object .+?Constructor\]$/, Hz = /^0o[0-7]+$/i, Kz = /^(?:0|[1-9]\d*)$/, Gz = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g, Ld = /($^)/, Yz = /['\n\r\u2028\u2029\\]/g, Bd = "\\ud800-\\udfff", qz = "\\u0300-\\u036f", Xz = "\\ufe20-\\ufe2f", Zz = "\\u20d0-\\u20ff", VS = qz + Xz + Zz, US = "\\u2700-\\u27bf", HS = "a-z\\xdf-\\xf6\\xf8-\\xff", Jz = "\\xac\\xb1\\xd7\\xf7", Qz = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", e5 = "\\u2000-\\u206f", t5 = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", KS = "A-Z\\xc0-\\xd6\\xd8-\\xde", GS = "\\ufe0e\\ufe0f", YS = Jz + Qz + e5 + t5, Ny = "['’]", n5 = "[" + Bd + "]", qS = "[" + YS + "]", Fd = "[" + VS + "]", XS = "\\d+", r5 = "[" + US + "]", ZS = "[" + HS + "]", JS = "[^" + Bd + YS + XS + US + HS + KS + "]", $y = "\\ud83c[\\udffb-\\udfff]", i5 = "(?:" + Fd + "|" + $y + ")", QS = "[^" + Bd + "]", Dy = "(?:\\ud83c[\\udde6-\\uddff]){2}", Iy = "[\\ud800-\\udbff][\\udc00-\\udfff]", al = "[" + KS + "]", eO = "\\u200d", tO = "(?:" + ZS + "|" + JS + ")", o5 = "(?:" + al + "|" + JS + ")", nO = "(?:" + Ny + "(?:d|ll|m|re|s|t|ve))?", rO = "(?:" + Ny + "(?:D|LL|M|RE|S|T|VE))?", iO = i5 + "?", oO = "[" + GS + "]?", a5 = "(?:" + eO + "(?:" + [QS, Dy, Iy].join("|") + ")" + oO + iO + ")*", s5 = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", l5 = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", aO = oO + iO + a5, c5 = "(?:" + [r5, Dy, Iy].join("|") + ")" + aO, u5 = "(?:" + [QS + Fd + "?", Fd, Dy, Iy, n5].join("|") + ")", f5 = RegExp(Ny, "g"), d5 = RegExp(Fd, "g"), Ry = RegExp($y + "(?=" + $y + ")|" + u5 + aO, "g"), h5 = RegExp([
      al + "?" + ZS + "+" + nO + "(?=" + [qS, al, "$"].join("|") + ")",
      o5 + "+" + rO + "(?=" + [qS, al + tO, "$"].join("|") + ")",
      al + "?" + tO + "+" + nO,
      al + "+" + rO,
      l5,
      s5,
      XS,
      c5
    ].join("|"), "g"), p5 = RegExp("[" + eO + Bd + VS + GS + "]"), m5 = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/, g5 = [
      "Array",
      "Buffer",
      "DataView",
      "Date",
      "Error",
      "Float32Array",
      "Float64Array",
      "Function",
      "Int8Array",
      "Int16Array",
      "Int32Array",
      "Map",
      "Math",
      "Object",
      "Promise",
      "RegExp",
      "Set",
      "String",
      "Symbol",
      "TypeError",
      "Uint8Array",
      "Uint8ClampedArray",
      "Uint16Array",
      "Uint32Array",
      "WeakMap",
      "_",
      "clearTimeout",
      "isFinite",
      "parseInt",
      "setTimeout"
    ], y5 = -1, Ft = {};
    Ft[mr] = Ft[tt] = Ft[Kt] = Ft[St] = Ft[jn] = Ft[qr] = Ft[lo] = Ft[un] = Ft[Pr] = !0, Ft[ce] = Ft[oe] = Ft[Cn] = Ft[ae] = Ft[yn] = Ft[ee] = Ft[ge] = Ft[X] = Ft[de] = Ft[ke] = Ft[lt] = Ft[ct] = Ft[Oe] = Ft[Ge] = Ft[en] = !1;
    var It = {};
    It[ce] = It[oe] = It[Cn] = It[yn] = It[ae] = It[ee] = It[mr] = It[tt] = It[Kt] = It[St] = It[jn] = It[de] = It[ke] = It[lt] = It[ct] = It[Oe] = It[Ge] = It[Zt] = It[qr] = It[lo] = It[un] = It[Pr] = !0, It[ge] = It[X] = It[en] = !1;
    var v5 = {
      // Latin-1 Supplement block.
      À: "A",
      Á: "A",
      Â: "A",
      Ã: "A",
      Ä: "A",
      Å: "A",
      à: "a",
      á: "a",
      â: "a",
      ã: "a",
      ä: "a",
      å: "a",
      Ç: "C",
      ç: "c",
      Ð: "D",
      ð: "d",
      È: "E",
      É: "E",
      Ê: "E",
      Ë: "E",
      è: "e",
      é: "e",
      ê: "e",
      ë: "e",
      Ì: "I",
      Í: "I",
      Î: "I",
      Ï: "I",
      ì: "i",
      í: "i",
      î: "i",
      ï: "i",
      Ñ: "N",
      ñ: "n",
      Ò: "O",
      Ó: "O",
      Ô: "O",
      Õ: "O",
      Ö: "O",
      Ø: "O",
      ò: "o",
      ó: "o",
      ô: "o",
      õ: "o",
      ö: "o",
      ø: "o",
      Ù: "U",
      Ú: "U",
      Û: "U",
      Ü: "U",
      ù: "u",
      ú: "u",
      û: "u",
      ü: "u",
      Ý: "Y",
      ý: "y",
      ÿ: "y",
      Æ: "Ae",
      æ: "ae",
      Þ: "Th",
      þ: "th",
      ß: "ss",
      // Latin Extended-A block.
      Ā: "A",
      Ă: "A",
      Ą: "A",
      ā: "a",
      ă: "a",
      ą: "a",
      Ć: "C",
      Ĉ: "C",
      Ċ: "C",
      Č: "C",
      ć: "c",
      ĉ: "c",
      ċ: "c",
      č: "c",
      Ď: "D",
      Đ: "D",
      ď: "d",
      đ: "d",
      Ē: "E",
      Ĕ: "E",
      Ė: "E",
      Ę: "E",
      Ě: "E",
      ē: "e",
      ĕ: "e",
      ė: "e",
      ę: "e",
      ě: "e",
      Ĝ: "G",
      Ğ: "G",
      Ġ: "G",
      Ģ: "G",
      ĝ: "g",
      ğ: "g",
      ġ: "g",
      ģ: "g",
      Ĥ: "H",
      Ħ: "H",
      ĥ: "h",
      ħ: "h",
      Ĩ: "I",
      Ī: "I",
      Ĭ: "I",
      Į: "I",
      İ: "I",
      ĩ: "i",
      ī: "i",
      ĭ: "i",
      į: "i",
      ı: "i",
      Ĵ: "J",
      ĵ: "j",
      Ķ: "K",
      ķ: "k",
      ĸ: "k",
      Ĺ: "L",
      Ļ: "L",
      Ľ: "L",
      Ŀ: "L",
      Ł: "L",
      ĺ: "l",
      ļ: "l",
      ľ: "l",
      ŀ: "l",
      ł: "l",
      Ń: "N",
      Ņ: "N",
      Ň: "N",
      Ŋ: "N",
      ń: "n",
      ņ: "n",
      ň: "n",
      ŋ: "n",
      Ō: "O",
      Ŏ: "O",
      Ő: "O",
      ō: "o",
      ŏ: "o",
      ő: "o",
      Ŕ: "R",
      Ŗ: "R",
      Ř: "R",
      ŕ: "r",
      ŗ: "r",
      ř: "r",
      Ś: "S",
      Ŝ: "S",
      Ş: "S",
      Š: "S",
      ś: "s",
      ŝ: "s",
      ş: "s",
      š: "s",
      Ţ: "T",
      Ť: "T",
      Ŧ: "T",
      ţ: "t",
      ť: "t",
      ŧ: "t",
      Ũ: "U",
      Ū: "U",
      Ŭ: "U",
      Ů: "U",
      Ű: "U",
      Ų: "U",
      ũ: "u",
      ū: "u",
      ŭ: "u",
      ů: "u",
      ű: "u",
      ų: "u",
      Ŵ: "W",
      ŵ: "w",
      Ŷ: "Y",
      ŷ: "y",
      Ÿ: "Y",
      Ź: "Z",
      Ż: "Z",
      Ž: "Z",
      ź: "z",
      ż: "z",
      ž: "z",
      Ĳ: "IJ",
      ĳ: "ij",
      Œ: "Oe",
      œ: "oe",
      ŉ: "'n",
      ſ: "s"
    }, b5 = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    }, x5 = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    }, w5 = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    }, _5 = parseFloat, S5 = parseInt, sO = typeof _commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__.c == "object" && _commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__.c && _commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__.c.Object === Object && _commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__.c, O5 = typeof self == "object" && self && self.Object === Object && self, Ln = sO || O5 || Function("return this")(), jy = t && !t.nodeType && t, Za = jy && !0 && e && !e.nodeType && e, lO = Za && Za.exports === jy, Ly = lO && sO.process, Zr = function() {
      try {
        var Z = Za && Za.require && Za.require("util").types;
        return Z || Ly && Ly.binding && Ly.binding("util");
      } catch {
      }
    }(), cO = Zr && Zr.isArrayBuffer, uO = Zr && Zr.isDate, fO = Zr && Zr.isMap, dO = Zr && Zr.isRegExp, hO = Zr && Zr.isSet, pO = Zr && Zr.isTypedArray;
    function Cr(Z, ue, ie) {
      switch (ie.length) {
        case 0:
          return Z.call(ue);
        case 1:
          return Z.call(ue, ie[0]);
        case 2:
          return Z.call(ue, ie[0], ie[1]);
        case 3:
          return Z.call(ue, ie[0], ie[1], ie[2]);
      }
      return Z.apply(ue, ie);
    }
    function A5(Z, ue, ie, Te) {
      for (var He = -1, gt = Z == null ? 0 : Z.length; ++He < gt; ) {
        var vn = Z[He];
        ue(Te, vn, ie(vn), Z);
      }
      return Te;
    }
    function Jr(Z, ue) {
      for (var ie = -1, Te = Z == null ? 0 : Z.length; ++ie < Te && ue(Z[ie], ie, Z) !== !1; )
        ;
      return Z;
    }
    function T5(Z, ue) {
      for (var ie = Z == null ? 0 : Z.length; ie-- && ue(Z[ie], ie, Z) !== !1; )
        ;
      return Z;
    }
    function mO(Z, ue) {
      for (var ie = -1, Te = Z == null ? 0 : Z.length; ++ie < Te; )
        if (!ue(Z[ie], ie, Z))
          return !1;
      return !0;
    }
    function ia(Z, ue) {
      for (var ie = -1, Te = Z == null ? 0 : Z.length, He = 0, gt = []; ++ie < Te; ) {
        var vn = Z[ie];
        ue(vn, ie, Z) && (gt[He++] = vn);
      }
      return gt;
    }
    function Wd(Z, ue) {
      var ie = Z == null ? 0 : Z.length;
      return !!ie && sl(Z, ue, 0) > -1;
    }
    function By(Z, ue, ie) {
      for (var Te = -1, He = Z == null ? 0 : Z.length; ++Te < He; )
        if (ie(ue, Z[Te]))
          return !0;
      return !1;
    }
    function Gt(Z, ue) {
      for (var ie = -1, Te = Z == null ? 0 : Z.length, He = Array(Te); ++ie < Te; )
        He[ie] = ue(Z[ie], ie, Z);
      return He;
    }
    function oa(Z, ue) {
      for (var ie = -1, Te = ue.length, He = Z.length; ++ie < Te; )
        Z[He + ie] = ue[ie];
      return Z;
    }
    function Fy(Z, ue, ie, Te) {
      var He = -1, gt = Z == null ? 0 : Z.length;
      for (Te && gt && (ie = Z[++He]); ++He < gt; )
        ie = ue(ie, Z[He], He, Z);
      return ie;
    }
    function P5(Z, ue, ie, Te) {
      var He = Z == null ? 0 : Z.length;
      for (Te && He && (ie = Z[--He]); He--; )
        ie = ue(ie, Z[He], He, Z);
      return ie;
    }
    function Wy(Z, ue) {
      for (var ie = -1, Te = Z == null ? 0 : Z.length; ++ie < Te; )
        if (ue(Z[ie], ie, Z))
          return !0;
      return !1;
    }
    var C5 = zy("length");
    function E5(Z) {
      return Z.split("");
    }
    function k5(Z) {
      return Z.match(Lz) || [];
    }
    function gO(Z, ue, ie) {
      var Te;
      return ie(Z, function(He, gt, vn) {
        if (ue(He, gt, vn))
          return Te = gt, !1;
      }), Te;
    }
    function zd(Z, ue, ie, Te) {
      for (var He = Z.length, gt = ie + (Te ? 1 : -1); Te ? gt-- : ++gt < He; )
        if (ue(Z[gt], gt, Z))
          return gt;
      return -1;
    }
    function sl(Z, ue, ie) {
      return ue === ue ? z5(Z, ue, ie) : zd(Z, yO, ie);
    }
    function M5(Z, ue, ie, Te) {
      for (var He = ie - 1, gt = Z.length; ++He < gt; )
        if (Te(Z[He], ue))
          return He;
      return -1;
    }
    function yO(Z) {
      return Z !== Z;
    }
    function vO(Z, ue) {
      var ie = Z == null ? 0 : Z.length;
      return ie ? Uy(Z, ue) / ie : V;
    }
    function zy(Z) {
      return function(ue) {
        return ue == null ? n : ue[Z];
      };
    }
    function Vy(Z) {
      return function(ue) {
        return Z == null ? n : Z[ue];
      };
    }
    function bO(Z, ue, ie, Te, He) {
      return He(Z, function(gt, vn, Mt) {
        ie = Te ? (Te = !1, gt) : ue(ie, gt, vn, Mt);
      }), ie;
    }
    function N5(Z, ue) {
      var ie = Z.length;
      for (Z.sort(ue); ie--; )
        Z[ie] = Z[ie].value;
      return Z;
    }
    function Uy(Z, ue) {
      for (var ie, Te = -1, He = Z.length; ++Te < He; ) {
        var gt = ue(Z[Te]);
        gt !== n && (ie = ie === n ? gt : ie + gt);
      }
      return ie;
    }
    function Hy(Z, ue) {
      for (var ie = -1, Te = Array(Z); ++ie < Z; )
        Te[ie] = ue(ie);
      return Te;
    }
    function $5(Z, ue) {
      return Gt(ue, function(ie) {
        return [ie, Z[ie]];
      });
    }
    function xO(Z) {
      return Z && Z.slice(0, OO(Z) + 1).replace(My, "");
    }
    function Er(Z) {
      return function(ue) {
        return Z(ue);
      };
    }
    function Ky(Z, ue) {
      return Gt(ue, function(ie) {
        return Z[ie];
      });
    }
    function iu(Z, ue) {
      return Z.has(ue);
    }
    function wO(Z, ue) {
      for (var ie = -1, Te = Z.length; ++ie < Te && sl(ue, Z[ie], 0) > -1; )
        ;
      return ie;
    }
    function _O(Z, ue) {
      for (var ie = Z.length; ie-- && sl(ue, Z[ie], 0) > -1; )
        ;
      return ie;
    }
    function D5(Z, ue) {
      for (var ie = Z.length, Te = 0; ie--; )
        Z[ie] === ue && ++Te;
      return Te;
    }
    var I5 = Vy(v5), R5 = Vy(b5);
    function j5(Z) {
      return "\\" + w5[Z];
    }
    function L5(Z, ue) {
      return Z == null ? n : Z[ue];
    }
    function ll(Z) {
      return p5.test(Z);
    }
    function B5(Z) {
      return m5.test(Z);
    }
    function F5(Z) {
      for (var ue, ie = []; !(ue = Z.next()).done; )
        ie.push(ue.value);
      return ie;
    }
    function Gy(Z) {
      var ue = -1, ie = Array(Z.size);
      return Z.forEach(function(Te, He) {
        ie[++ue] = [He, Te];
      }), ie;
    }
    function SO(Z, ue) {
      return function(ie) {
        return Z(ue(ie));
      };
    }
    function aa(Z, ue) {
      for (var ie = -1, Te = Z.length, He = 0, gt = []; ++ie < Te; ) {
        var vn = Z[ie];
        (vn === ue || vn === f) && (Z[ie] = f, gt[He++] = ie);
      }
      return gt;
    }
    function Vd(Z) {
      var ue = -1, ie = Array(Z.size);
      return Z.forEach(function(Te) {
        ie[++ue] = Te;
      }), ie;
    }
    function W5(Z) {
      var ue = -1, ie = Array(Z.size);
      return Z.forEach(function(Te) {
        ie[++ue] = [Te, Te];
      }), ie;
    }
    function z5(Z, ue, ie) {
      for (var Te = ie - 1, He = Z.length; ++Te < He; )
        if (Z[Te] === ue)
          return Te;
      return -1;
    }
    function V5(Z, ue, ie) {
      for (var Te = ie + 1; Te--; )
        if (Z[Te] === ue)
          return Te;
      return Te;
    }
    function cl(Z) {
      return ll(Z) ? H5(Z) : C5(Z);
    }
    function yi(Z) {
      return ll(Z) ? K5(Z) : E5(Z);
    }
    function OO(Z) {
      for (var ue = Z.length; ue-- && Dz.test(Z.charAt(ue)); )
        ;
      return ue;
    }
    var U5 = Vy(x5);
    function H5(Z) {
      for (var ue = Ry.lastIndex = 0; Ry.test(Z); )
        ++ue;
      return ue;
    }
    function K5(Z) {
      return Z.match(Ry) || [];
    }
    function G5(Z) {
      return Z.match(h5) || [];
    }
    var Y5 = function Z(ue) {
      ue = ue == null ? Ln : ul.defaults(Ln.Object(), ue, ul.pick(Ln, g5));
      var ie = ue.Array, Te = ue.Date, He = ue.Error, gt = ue.Function, vn = ue.Math, Mt = ue.Object, Yy = ue.RegExp, q5 = ue.String, Qr = ue.TypeError, Ud = ie.prototype, X5 = gt.prototype, fl = Mt.prototype, Hd = ue["__core-js_shared__"], Kd = X5.toString, Ot = fl.hasOwnProperty, Z5 = 0, AO = function() {
        var u = /[^.]+$/.exec(Hd && Hd.keys && Hd.keys.IE_PROTO || "");
        return u ? "Symbol(src)_1." + u : "";
      }(), Gd = fl.toString, J5 = Kd.call(Mt), Q5 = Ln._, e3 = Yy(
        "^" + Kd.call(Ot).replace(ky, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
      ), Yd = lO ? ue.Buffer : n, sa = ue.Symbol, qd = ue.Uint8Array, TO = Yd ? Yd.allocUnsafe : n, Xd = SO(Mt.getPrototypeOf, Mt), PO = Mt.create, CO = fl.propertyIsEnumerable, Zd = Ud.splice, EO = sa ? sa.isConcatSpreadable : n, ou = sa ? sa.iterator : n, Ja = sa ? sa.toStringTag : n, Jd = function() {
        try {
          var u = rs(Mt, "defineProperty");
          return u({}, "", {}), u;
        } catch {
        }
      }(), t3 = ue.clearTimeout !== Ln.clearTimeout && ue.clearTimeout, n3 = Te && Te.now !== Ln.Date.now && Te.now, r3 = ue.setTimeout !== Ln.setTimeout && ue.setTimeout, Qd = vn.ceil, eh = vn.floor, qy = Mt.getOwnPropertySymbols, i3 = Yd ? Yd.isBuffer : n, kO = ue.isFinite, o3 = Ud.join, a3 = SO(Mt.keys, Mt), bn = vn.max, Zn = vn.min, s3 = Te.now, l3 = ue.parseInt, MO = vn.random, c3 = Ud.reverse, Xy = rs(ue, "DataView"), au = rs(ue, "Map"), Zy = rs(ue, "Promise"), dl = rs(ue, "Set"), su = rs(ue, "WeakMap"), lu = rs(Mt, "create"), th = su && new su(), hl = {}, u3 = is(Xy), f3 = is(au), d3 = is(Zy), h3 = is(dl), p3 = is(su), nh = sa ? sa.prototype : n, cu = nh ? nh.valueOf : n, NO = nh ? nh.toString : n;
      function L(u) {
        if (tn(u) && !Ye(u) && !(u instanceof ut)) {
          if (u instanceof ei)
            return u;
          if (Ot.call(u, "__wrapped__"))
            return $A(u);
        }
        return new ei(u);
      }
      var pl = /* @__PURE__ */ function() {
        function u() {
        }
        return function(h) {
          if (!Jt(h))
            return {};
          if (PO)
            return PO(h);
          u.prototype = h;
          var b = new u();
          return u.prototype = n, b;
        };
      }();
      function rh() {
      }
      function ei(u, h) {
        this.__wrapped__ = u, this.__actions__ = [], this.__chain__ = !!h, this.__index__ = 0, this.__values__ = n;
      }
      L.templateSettings = {
        /**
         * Used to detect `data` property values to be HTML-escaped.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        escape: ru,
        /**
         * Used to detect code to be evaluated.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        evaluate: Ez,
        /**
         * Used to detect `data` property values to inject.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        interpolate: WS,
        /**
         * Used to reference the data object in the template text.
         *
         * @memberOf _.templateSettings
         * @type {string}
         */
        variable: "",
        /**
         * Used to import variables into the compiled template.
         *
         * @memberOf _.templateSettings
         * @type {Object}
         */
        imports: {
          /**
           * A reference to the `lodash` function.
           *
           * @memberOf _.templateSettings.imports
           * @type {Function}
           */
          _: L
        }
      }, L.prototype = rh.prototype, L.prototype.constructor = L, ei.prototype = pl(rh.prototype), ei.prototype.constructor = ei;
      function ut(u) {
        this.__wrapped__ = u, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = Y, this.__views__ = [];
      }
      function m3() {
        var u = new ut(this.__wrapped__);
        return u.__actions__ = gr(this.__actions__), u.__dir__ = this.__dir__, u.__filtered__ = this.__filtered__, u.__iteratees__ = gr(this.__iteratees__), u.__takeCount__ = this.__takeCount__, u.__views__ = gr(this.__views__), u;
      }
      function g3() {
        if (this.__filtered__) {
          var u = new ut(this);
          u.__dir__ = -1, u.__filtered__ = !0;
        } else
          u = this.clone(), u.__dir__ *= -1;
        return u;
      }
      function y3() {
        var u = this.__wrapped__.value(), h = this.__dir__, b = Ye(u), T = h < 0, M = b ? u.length : 0, B = EV(0, M, this.__views__), G = B.start, q = B.end, J = q - G, he = T ? q : G - 1, me = this.__iteratees__, ye = me.length, xe = 0, Ce = Zn(J, this.__takeCount__);
        if (!b || !T && M == J && Ce == J)
          return nA(u, this.__actions__);
        var Re = [];
        e:
          for (; J-- && xe < Ce; ) {
            he += h;
            for (var et = -1, je = u[he]; ++et < ye; ) {
              var ot = me[et], ft = ot.iteratee, Nr = ot.type, sr = ft(je);
              if (Nr == F)
                je = sr;
              else if (!sr) {
                if (Nr == j)
                  continue e;
                break e;
              }
            }
            Re[xe++] = je;
          }
        return Re;
      }
      ut.prototype = pl(rh.prototype), ut.prototype.constructor = ut;
      function Qa(u) {
        var h = -1, b = u == null ? 0 : u.length;
        for (this.clear(); ++h < b; ) {
          var T = u[h];
          this.set(T[0], T[1]);
        }
      }
      function v3() {
        this.__data__ = lu ? lu(null) : {}, this.size = 0;
      }
      function b3(u) {
        var h = this.has(u) && delete this.__data__[u];
        return this.size -= h ? 1 : 0, h;
      }
      function x3(u) {
        var h = this.__data__;
        if (lu) {
          var b = h[u];
          return b === l ? n : b;
        }
        return Ot.call(h, u) ? h[u] : n;
      }
      function w3(u) {
        var h = this.__data__;
        return lu ? h[u] !== n : Ot.call(h, u);
      }
      function _3(u, h) {
        var b = this.__data__;
        return this.size += this.has(u) ? 0 : 1, b[u] = lu && h === n ? l : h, this;
      }
      Qa.prototype.clear = v3, Qa.prototype.delete = b3, Qa.prototype.get = x3, Qa.prototype.has = w3, Qa.prototype.set = _3;
      function co(u) {
        var h = -1, b = u == null ? 0 : u.length;
        for (this.clear(); ++h < b; ) {
          var T = u[h];
          this.set(T[0], T[1]);
        }
      }
      function S3() {
        this.__data__ = [], this.size = 0;
      }
      function O3(u) {
        var h = this.__data__, b = ih(h, u);
        if (b < 0)
          return !1;
        var T = h.length - 1;
        return b == T ? h.pop() : Zd.call(h, b, 1), --this.size, !0;
      }
      function A3(u) {
        var h = this.__data__, b = ih(h, u);
        return b < 0 ? n : h[b][1];
      }
      function T3(u) {
        return ih(this.__data__, u) > -1;
      }
      function P3(u, h) {
        var b = this.__data__, T = ih(b, u);
        return T < 0 ? (++this.size, b.push([u, h])) : b[T][1] = h, this;
      }
      co.prototype.clear = S3, co.prototype.delete = O3, co.prototype.get = A3, co.prototype.has = T3, co.prototype.set = P3;
      function uo(u) {
        var h = -1, b = u == null ? 0 : u.length;
        for (this.clear(); ++h < b; ) {
          var T = u[h];
          this.set(T[0], T[1]);
        }
      }
      function C3() {
        this.size = 0, this.__data__ = {
          hash: new Qa(),
          map: new (au || co)(),
          string: new Qa()
        };
      }
      function E3(u) {
        var h = gh(this, u).delete(u);
        return this.size -= h ? 1 : 0, h;
      }
      function k3(u) {
        return gh(this, u).get(u);
      }
      function M3(u) {
        return gh(this, u).has(u);
      }
      function N3(u, h) {
        var b = gh(this, u), T = b.size;
        return b.set(u, h), this.size += b.size == T ? 0 : 1, this;
      }
      uo.prototype.clear = C3, uo.prototype.delete = E3, uo.prototype.get = k3, uo.prototype.has = M3, uo.prototype.set = N3;
      function es(u) {
        var h = -1, b = u == null ? 0 : u.length;
        for (this.__data__ = new uo(); ++h < b; )
          this.add(u[h]);
      }
      function $3(u) {
        return this.__data__.set(u, l), this;
      }
      function D3(u) {
        return this.__data__.has(u);
      }
      es.prototype.add = es.prototype.push = $3, es.prototype.has = D3;
      function vi(u) {
        var h = this.__data__ = new co(u);
        this.size = h.size;
      }
      function I3() {
        this.__data__ = new co(), this.size = 0;
      }
      function R3(u) {
        var h = this.__data__, b = h.delete(u);
        return this.size = h.size, b;
      }
      function j3(u) {
        return this.__data__.get(u);
      }
      function L3(u) {
        return this.__data__.has(u);
      }
      function B3(u, h) {
        var b = this.__data__;
        if (b instanceof co) {
          var T = b.__data__;
          if (!au || T.length < i - 1)
            return T.push([u, h]), this.size = ++b.size, this;
          b = this.__data__ = new uo(T);
        }
        return b.set(u, h), this.size = b.size, this;
      }
      vi.prototype.clear = I3, vi.prototype.delete = R3, vi.prototype.get = j3, vi.prototype.has = L3, vi.prototype.set = B3;
      function $O(u, h) {
        var b = Ye(u), T = !b && os(u), M = !b && !T && da(u), B = !b && !T && !M && vl(u), G = b || T || M || B, q = G ? Hy(u.length, q5) : [], J = q.length;
        for (var he in u)
          (h || Ot.call(u, he)) && !(G && // Safari 9 has enumerable `arguments.length` in strict mode.
          (he == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
          M && (he == "offset" || he == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
          B && (he == "buffer" || he == "byteLength" || he == "byteOffset") || // Skip index properties.
          mo(he, J))) && q.push(he);
        return q;
      }
      function DO(u) {
        var h = u.length;
        return h ? u[lv(0, h - 1)] : n;
      }
      function F3(u, h) {
        return yh(gr(u), ts(h, 0, u.length));
      }
      function W3(u) {
        return yh(gr(u));
      }
      function Jy(u, h, b) {
        (b !== n && !bi(u[h], b) || b === n && !(h in u)) && fo(u, h, b);
      }
      function uu(u, h, b) {
        var T = u[h];
        (!(Ot.call(u, h) && bi(T, b)) || b === n && !(h in u)) && fo(u, h, b);
      }
      function ih(u, h) {
        for (var b = u.length; b--; )
          if (bi(u[b][0], h))
            return b;
        return -1;
      }
      function z3(u, h, b, T) {
        return la(u, function(M, B, G) {
          h(T, M, b(M), G);
        }), T;
      }
      function IO(u, h) {
        return u && ji(h, En(h), u);
      }
      function V3(u, h) {
        return u && ji(h, vr(h), u);
      }
      function fo(u, h, b) {
        h == "__proto__" && Jd ? Jd(u, h, {
          configurable: !0,
          enumerable: !0,
          value: b,
          writable: !0
        }) : u[h] = b;
      }
      function Qy(u, h) {
        for (var b = -1, T = h.length, M = ie(T), B = u == null; ++b < T; )
          M[b] = B ? n : $v(u, h[b]);
        return M;
      }
      function ts(u, h, b) {
        return u === u && (b !== n && (u = u <= b ? u : b), h !== n && (u = u >= h ? u : h)), u;
      }
      function ti(u, h, b, T, M, B) {
        var G, q = h & d, J = h & p, he = h & m;
        if (b && (G = M ? b(u, T, M, B) : b(u)), G !== n)
          return G;
        if (!Jt(u))
          return u;
        var me = Ye(u);
        if (me) {
          if (G = MV(u), !q)
            return gr(u, G);
        } else {
          var ye = Jn(u), xe = ye == X || ye == $e;
          if (da(u))
            return oA(u, q);
          if (ye == lt || ye == ce || xe && !M) {
            if (G = J || xe ? {} : OA(u), !q)
              return J ? xV(u, V3(G, u)) : bV(u, IO(G, u));
          } else {
            if (!It[ye])
              return M ? u : {};
            G = NV(u, ye, q);
          }
        }
        B || (B = new vi());
        var Ce = B.get(u);
        if (Ce)
          return Ce;
        B.set(u, G), QA(u) ? u.forEach(function(je) {
          G.add(ti(je, h, b, je, u, B));
        }) : ZA(u) && u.forEach(function(je, ot) {
          G.set(ot, ti(je, h, b, ot, u, B));
        });
        var Re = he ? J ? bv : vv : J ? vr : En, et = me ? n : Re(u);
        return Jr(et || u, function(je, ot) {
          et && (ot = je, je = u[ot]), uu(G, ot, ti(je, h, b, ot, u, B));
        }), G;
      }
      function U3(u) {
        var h = En(u);
        return function(b) {
          return RO(b, u, h);
        };
      }
      function RO(u, h, b) {
        var T = b.length;
        if (u == null)
          return !T;
        for (u = Mt(u); T--; ) {
          var M = b[T], B = h[M], G = u[M];
          if (G === n && !(M in u) || !B(G))
            return !1;
        }
        return !0;
      }
      function jO(u, h, b) {
        if (typeof u != "function")
          throw new Qr(a);
        return yu(function() {
          u.apply(n, b);
        }, h);
      }
      function fu(u, h, b, T) {
        var M = -1, B = Wd, G = !0, q = u.length, J = [], he = h.length;
        if (!q)
          return J;
        b && (h = Gt(h, Er(b))), T ? (B = By, G = !1) : h.length >= i && (B = iu, G = !1, h = new es(h));
        e:
          for (; ++M < q; ) {
            var me = u[M], ye = b == null ? me : b(me);
            if (me = T || me !== 0 ? me : 0, G && ye === ye) {
              for (var xe = he; xe--; )
                if (h[xe] === ye)
                  continue e;
              J.push(me);
            } else B(h, ye, T) || J.push(me);
          }
        return J;
      }
      var la = uA(Ri), LO = uA(tv, !0);
      function H3(u, h) {
        var b = !0;
        return la(u, function(T, M, B) {
          return b = !!h(T, M, B), b;
        }), b;
      }
      function oh(u, h, b) {
        for (var T = -1, M = u.length; ++T < M; ) {
          var B = u[T], G = h(B);
          if (G != null && (q === n ? G === G && !Mr(G) : b(G, q)))
            var q = G, J = B;
        }
        return J;
      }
      function K3(u, h, b, T) {
        var M = u.length;
        for (b = Ze(b), b < 0 && (b = -b > M ? 0 : M + b), T = T === n || T > M ? M : Ze(T), T < 0 && (T += M), T = b > T ? 0 : tT(T); b < T; )
          u[b++] = h;
        return u;
      }
      function BO(u, h) {
        var b = [];
        return la(u, function(T, M, B) {
          h(T, M, B) && b.push(T);
        }), b;
      }
      function Bn(u, h, b, T, M) {
        var B = -1, G = u.length;
        for (b || (b = DV), M || (M = []); ++B < G; ) {
          var q = u[B];
          h > 0 && b(q) ? h > 1 ? Bn(q, h - 1, b, T, M) : oa(M, q) : T || (M[M.length] = q);
        }
        return M;
      }
      var ev = fA(), FO = fA(!0);
      function Ri(u, h) {
        return u && ev(u, h, En);
      }
      function tv(u, h) {
        return u && FO(u, h, En);
      }
      function ah(u, h) {
        return ia(h, function(b) {
          return go(u[b]);
        });
      }
      function ns(u, h) {
        h = ua(h, u);
        for (var b = 0, T = h.length; u != null && b < T; )
          u = u[Li(h[b++])];
        return b && b == T ? u : n;
      }
      function WO(u, h, b) {
        var T = h(u);
        return Ye(u) ? T : oa(T, b(u));
      }
      function or(u) {
        return u == null ? u === n ? mt : it : Ja && Ja in Mt(u) ? CV(u) : WV(u);
      }
      function nv(u, h) {
        return u > h;
      }
      function G3(u, h) {
        return u != null && Ot.call(u, h);
      }
      function Y3(u, h) {
        return u != null && h in Mt(u);
      }
      function q3(u, h, b) {
        return u >= Zn(h, b) && u < bn(h, b);
      }
      function rv(u, h, b) {
        for (var T = b ? By : Wd, M = u[0].length, B = u.length, G = B, q = ie(B), J = 1 / 0, he = []; G--; ) {
          var me = u[G];
          G && h && (me = Gt(me, Er(h))), J = Zn(me.length, J), q[G] = !b && (h || M >= 120 && me.length >= 120) ? new es(G && me) : n;
        }
        me = u[0];
        var ye = -1, xe = q[0];
        e:
          for (; ++ye < M && he.length < J; ) {
            var Ce = me[ye], Re = h ? h(Ce) : Ce;
            if (Ce = b || Ce !== 0 ? Ce : 0, !(xe ? iu(xe, Re) : T(he, Re, b))) {
              for (G = B; --G; ) {
                var et = q[G];
                if (!(et ? iu(et, Re) : T(u[G], Re, b)))
                  continue e;
              }
              xe && xe.push(Re), he.push(Ce);
            }
          }
        return he;
      }
      function X3(u, h, b, T) {
        return Ri(u, function(M, B, G) {
          h(T, b(M), B, G);
        }), T;
      }
      function du(u, h, b) {
        h = ua(h, u), u = CA(u, h);
        var T = u == null ? u : u[Li(ri(h))];
        return T == null ? n : Cr(T, u, b);
      }
      function zO(u) {
        return tn(u) && or(u) == ce;
      }
      function Z3(u) {
        return tn(u) && or(u) == Cn;
      }
      function J3(u) {
        return tn(u) && or(u) == ee;
      }
      function hu(u, h, b, T, M) {
        return u === h ? !0 : u == null || h == null || !tn(u) && !tn(h) ? u !== u && h !== h : Q3(u, h, b, T, hu, M);
      }
      function Q3(u, h, b, T, M, B) {
        var G = Ye(u), q = Ye(h), J = G ? oe : Jn(u), he = q ? oe : Jn(h);
        J = J == ce ? lt : J, he = he == ce ? lt : he;
        var me = J == lt, ye = he == lt, xe = J == he;
        if (xe && da(u)) {
          if (!da(h))
            return !1;
          G = !0, me = !1;
        }
        if (xe && !me)
          return B || (B = new vi()), G || vl(u) ? wA(u, h, b, T, M, B) : TV(u, h, J, b, T, M, B);
        if (!(b & y)) {
          var Ce = me && Ot.call(u, "__wrapped__"), Re = ye && Ot.call(h, "__wrapped__");
          if (Ce || Re) {
            var et = Ce ? u.value() : u, je = Re ? h.value() : h;
            return B || (B = new vi()), M(et, je, b, T, B);
          }
        }
        return xe ? (B || (B = new vi()), PV(u, h, b, T, M, B)) : !1;
      }
      function eV(u) {
        return tn(u) && Jn(u) == de;
      }
      function iv(u, h, b, T) {
        var M = b.length, B = M, G = !T;
        if (u == null)
          return !B;
        for (u = Mt(u); M--; ) {
          var q = b[M];
          if (G && q[2] ? q[1] !== u[q[0]] : !(q[0] in u))
            return !1;
        }
        for (; ++M < B; ) {
          q = b[M];
          var J = q[0], he = u[J], me = q[1];
          if (G && q[2]) {
            if (he === n && !(J in u))
              return !1;
          } else {
            var ye = new vi();
            if (T)
              var xe = T(he, me, J, u, h, ye);
            if (!(xe === n ? hu(me, he, y | g, T, ye) : xe))
              return !1;
          }
        }
        return !0;
      }
      function VO(u) {
        if (!Jt(u) || RV(u))
          return !1;
        var h = go(u) ? e3 : Uz;
        return h.test(is(u));
      }
      function tV(u) {
        return tn(u) && or(u) == ct;
      }
      function nV(u) {
        return tn(u) && Jn(u) == Oe;
      }
      function rV(u) {
        return tn(u) && Sh(u.length) && !!Ft[or(u)];
      }
      function UO(u) {
        return typeof u == "function" ? u : u == null ? br : typeof u == "object" ? Ye(u) ? GO(u[0], u[1]) : KO(u) : dT(u);
      }
      function ov(u) {
        if (!gu(u))
          return a3(u);
        var h = [];
        for (var b in Mt(u))
          Ot.call(u, b) && b != "constructor" && h.push(b);
        return h;
      }
      function iV(u) {
        if (!Jt(u))
          return FV(u);
        var h = gu(u), b = [];
        for (var T in u)
          T == "constructor" && (h || !Ot.call(u, T)) || b.push(T);
        return b;
      }
      function av(u, h) {
        return u < h;
      }
      function HO(u, h) {
        var b = -1, T = yr(u) ? ie(u.length) : [];
        return la(u, function(M, B, G) {
          T[++b] = h(M, B, G);
        }), T;
      }
      function KO(u) {
        var h = wv(u);
        return h.length == 1 && h[0][2] ? TA(h[0][0], h[0][1]) : function(b) {
          return b === u || iv(b, u, h);
        };
      }
      function GO(u, h) {
        return Sv(u) && AA(h) ? TA(Li(u), h) : function(b) {
          var T = $v(b, u);
          return T === n && T === h ? Dv(b, u) : hu(h, T, y | g);
        };
      }
      function sh(u, h, b, T, M) {
        u !== h && ev(h, function(B, G) {
          if (M || (M = new vi()), Jt(B))
            oV(u, h, G, b, sh, T, M);
          else {
            var q = T ? T(Av(u, G), B, G + "", u, h, M) : n;
            q === n && (q = B), Jy(u, G, q);
          }
        }, vr);
      }
      function oV(u, h, b, T, M, B, G) {
        var q = Av(u, b), J = Av(h, b), he = G.get(J);
        if (he) {
          Jy(u, b, he);
          return;
        }
        var me = B ? B(q, J, b + "", u, h, G) : n, ye = me === n;
        if (ye) {
          var xe = Ye(J), Ce = !xe && da(J), Re = !xe && !Ce && vl(J);
          me = J, xe || Ce || Re ? Ye(q) ? me = q : an(q) ? me = gr(q) : Ce ? (ye = !1, me = oA(J, !0)) : Re ? (ye = !1, me = aA(J, !0)) : me = [] : vu(J) || os(J) ? (me = q, os(q) ? me = nT(q) : (!Jt(q) || go(q)) && (me = OA(J))) : ye = !1;
        }
        ye && (G.set(J, me), M(me, J, T, B, G), G.delete(J)), Jy(u, b, me);
      }
      function YO(u, h) {
        var b = u.length;
        if (b)
          return h += h < 0 ? b : 0, mo(h, b) ? u[h] : n;
      }
      function qO(u, h, b) {
        h.length ? h = Gt(h, function(B) {
          return Ye(B) ? function(G) {
            return ns(G, B.length === 1 ? B[0] : B);
          } : B;
        }) : h = [br];
        var T = -1;
        h = Gt(h, Er(De()));
        var M = HO(u, function(B, G, q) {
          var J = Gt(h, function(he) {
            return he(B);
          });
          return { criteria: J, index: ++T, value: B };
        });
        return N5(M, function(B, G) {
          return vV(B, G, b);
        });
      }
      function aV(u, h) {
        return XO(u, h, function(b, T) {
          return Dv(u, T);
        });
      }
      function XO(u, h, b) {
        for (var T = -1, M = h.length, B = {}; ++T < M; ) {
          var G = h[T], q = ns(u, G);
          b(q, G) && pu(B, ua(G, u), q);
        }
        return B;
      }
      function sV(u) {
        return function(h) {
          return ns(h, u);
        };
      }
      function sv(u, h, b, T) {
        var M = T ? M5 : sl, B = -1, G = h.length, q = u;
        for (u === h && (h = gr(h)), b && (q = Gt(u, Er(b))); ++B < G; )
          for (var J = 0, he = h[B], me = b ? b(he) : he; (J = M(q, me, J, T)) > -1; )
            q !== u && Zd.call(q, J, 1), Zd.call(u, J, 1);
        return u;
      }
      function ZO(u, h) {
        for (var b = u ? h.length : 0, T = b - 1; b--; ) {
          var M = h[b];
          if (b == T || M !== B) {
            var B = M;
            mo(M) ? Zd.call(u, M, 1) : fv(u, M);
          }
        }
        return u;
      }
      function lv(u, h) {
        return u + eh(MO() * (h - u + 1));
      }
      function lV(u, h, b, T) {
        for (var M = -1, B = bn(Qd((h - u) / (b || 1)), 0), G = ie(B); B--; )
          G[T ? B : ++M] = u, u += b;
        return G;
      }
      function cv(u, h) {
        var b = "";
        if (!u || h < 1 || h > H)
          return b;
        do
          h % 2 && (b += u), h = eh(h / 2), h && (u += u);
        while (h);
        return b;
      }
      function nt(u, h) {
        return Tv(PA(u, h, br), u + "");
      }
      function cV(u) {
        return DO(bl(u));
      }
      function uV(u, h) {
        var b = bl(u);
        return yh(b, ts(h, 0, b.length));
      }
      function pu(u, h, b, T) {
        if (!Jt(u))
          return u;
        h = ua(h, u);
        for (var M = -1, B = h.length, G = B - 1, q = u; q != null && ++M < B; ) {
          var J = Li(h[M]), he = b;
          if (J === "__proto__" || J === "constructor" || J === "prototype")
            return u;
          if (M != G) {
            var me = q[J];
            he = T ? T(me, J, q) : n, he === n && (he = Jt(me) ? me : mo(h[M + 1]) ? [] : {});
          }
          uu(q, J, he), q = q[J];
        }
        return u;
      }
      var JO = th ? function(u, h) {
        return th.set(u, h), u;
      } : br, fV = Jd ? function(u, h) {
        return Jd(u, "toString", {
          configurable: !0,
          enumerable: !1,
          value: Rv(h),
          writable: !0
        });
      } : br;
      function dV(u) {
        return yh(bl(u));
      }
      function ni(u, h, b) {
        var T = -1, M = u.length;
        h < 0 && (h = -h > M ? 0 : M + h), b = b > M ? M : b, b < 0 && (b += M), M = h > b ? 0 : b - h >>> 0, h >>>= 0;
        for (var B = ie(M); ++T < M; )
          B[T] = u[T + h];
        return B;
      }
      function hV(u, h) {
        var b;
        return la(u, function(T, M, B) {
          return b = h(T, M, B), !b;
        }), !!b;
      }
      function lh(u, h, b) {
        var T = 0, M = u == null ? T : u.length;
        if (typeof h == "number" && h === h && M <= ne) {
          for (; T < M; ) {
            var B = T + M >>> 1, G = u[B];
            G !== null && !Mr(G) && (b ? G <= h : G < h) ? T = B + 1 : M = B;
          }
          return M;
        }
        return uv(u, h, br, b);
      }
      function uv(u, h, b, T) {
        var M = 0, B = u == null ? 0 : u.length;
        if (B === 0)
          return 0;
        h = b(h);
        for (var G = h !== h, q = h === null, J = Mr(h), he = h === n; M < B; ) {
          var me = eh((M + B) / 2), ye = b(u[me]), xe = ye !== n, Ce = ye === null, Re = ye === ye, et = Mr(ye);
          if (G)
            var je = T || Re;
          else he ? je = Re && (T || xe) : q ? je = Re && xe && (T || !Ce) : J ? je = Re && xe && !Ce && (T || !et) : Ce || et ? je = !1 : je = T ? ye <= h : ye < h;
          je ? M = me + 1 : B = me;
        }
        return Zn(B, Q);
      }
      function QO(u, h) {
        for (var b = -1, T = u.length, M = 0, B = []; ++b < T; ) {
          var G = u[b], q = h ? h(G) : G;
          if (!b || !bi(q, J)) {
            var J = q;
            B[M++] = G === 0 ? 0 : G;
          }
        }
        return B;
      }
      function eA(u) {
        return typeof u == "number" ? u : Mr(u) ? V : +u;
      }
      function kr(u) {
        if (typeof u == "string")
          return u;
        if (Ye(u))
          return Gt(u, kr) + "";
        if (Mr(u))
          return NO ? NO.call(u) : "";
        var h = u + "";
        return h == "0" && 1 / u == -z ? "-0" : h;
      }
      function ca(u, h, b) {
        var T = -1, M = Wd, B = u.length, G = !0, q = [], J = q;
        if (b)
          G = !1, M = By;
        else if (B >= i) {
          var he = h ? null : OV(u);
          if (he)
            return Vd(he);
          G = !1, M = iu, J = new es();
        } else
          J = h ? [] : q;
        e:
          for (; ++T < B; ) {
            var me = u[T], ye = h ? h(me) : me;
            if (me = b || me !== 0 ? me : 0, G && ye === ye) {
              for (var xe = J.length; xe--; )
                if (J[xe] === ye)
                  continue e;
              h && J.push(ye), q.push(me);
            } else M(J, ye, b) || (J !== q && J.push(ye), q.push(me));
          }
        return q;
      }
      function fv(u, h) {
        return h = ua(h, u), u = CA(u, h), u == null || delete u[Li(ri(h))];
      }
      function tA(u, h, b, T) {
        return pu(u, h, b(ns(u, h)), T);
      }
      function ch(u, h, b, T) {
        for (var M = u.length, B = T ? M : -1; (T ? B-- : ++B < M) && h(u[B], B, u); )
          ;
        return b ? ni(u, T ? 0 : B, T ? B + 1 : M) : ni(u, T ? B + 1 : 0, T ? M : B);
      }
      function nA(u, h) {
        var b = u;
        return b instanceof ut && (b = b.value()), Fy(h, function(T, M) {
          return M.func.apply(M.thisArg, oa([T], M.args));
        }, b);
      }
      function dv(u, h, b) {
        var T = u.length;
        if (T < 2)
          return T ? ca(u[0]) : [];
        for (var M = -1, B = ie(T); ++M < T; )
          for (var G = u[M], q = -1; ++q < T; )
            q != M && (B[M] = fu(B[M] || G, u[q], h, b));
        return ca(Bn(B, 1), h, b);
      }
      function rA(u, h, b) {
        for (var T = -1, M = u.length, B = h.length, G = {}; ++T < M; ) {
          var q = T < B ? h[T] : n;
          b(G, u[T], q);
        }
        return G;
      }
      function hv(u) {
        return an(u) ? u : [];
      }
      function pv(u) {
        return typeof u == "function" ? u : br;
      }
      function ua(u, h) {
        return Ye(u) ? u : Sv(u, h) ? [u] : NA(vt(u));
      }
      var pV = nt;
      function fa(u, h, b) {
        var T = u.length;
        return b = b === n ? T : b, !h && b >= T ? u : ni(u, h, b);
      }
      var iA = t3 || function(u) {
        return Ln.clearTimeout(u);
      };
      function oA(u, h) {
        if (h)
          return u.slice();
        var b = u.length, T = TO ? TO(b) : new u.constructor(b);
        return u.copy(T), T;
      }
      function mv(u) {
        var h = new u.constructor(u.byteLength);
        return new qd(h).set(new qd(u)), h;
      }
      function mV(u, h) {
        var b = h ? mv(u.buffer) : u.buffer;
        return new u.constructor(b, u.byteOffset, u.byteLength);
      }
      function gV(u) {
        var h = new u.constructor(u.source, zS.exec(u));
        return h.lastIndex = u.lastIndex, h;
      }
      function yV(u) {
        return cu ? Mt(cu.call(u)) : {};
      }
      function aA(u, h) {
        var b = h ? mv(u.buffer) : u.buffer;
        return new u.constructor(b, u.byteOffset, u.length);
      }
      function sA(u, h) {
        if (u !== h) {
          var b = u !== n, T = u === null, M = u === u, B = Mr(u), G = h !== n, q = h === null, J = h === h, he = Mr(h);
          if (!q && !he && !B && u > h || B && G && J && !q && !he || T && G && J || !b && J || !M)
            return 1;
          if (!T && !B && !he && u < h || he && b && M && !T && !B || q && b && M || !G && M || !J)
            return -1;
        }
        return 0;
      }
      function vV(u, h, b) {
        for (var T = -1, M = u.criteria, B = h.criteria, G = M.length, q = b.length; ++T < G; ) {
          var J = sA(M[T], B[T]);
          if (J) {
            if (T >= q)
              return J;
            var he = b[T];
            return J * (he == "desc" ? -1 : 1);
          }
        }
        return u.index - h.index;
      }
      function lA(u, h, b, T) {
        for (var M = -1, B = u.length, G = b.length, q = -1, J = h.length, he = bn(B - G, 0), me = ie(J + he), ye = !T; ++q < J; )
          me[q] = h[q];
        for (; ++M < G; )
          (ye || M < B) && (me[b[M]] = u[M]);
        for (; he--; )
          me[q++] = u[M++];
        return me;
      }
      function cA(u, h, b, T) {
        for (var M = -1, B = u.length, G = -1, q = b.length, J = -1, he = h.length, me = bn(B - q, 0), ye = ie(me + he), xe = !T; ++M < me; )
          ye[M] = u[M];
        for (var Ce = M; ++J < he; )
          ye[Ce + J] = h[J];
        for (; ++G < q; )
          (xe || M < B) && (ye[Ce + b[G]] = u[M++]);
        return ye;
      }
      function gr(u, h) {
        var b = -1, T = u.length;
        for (h || (h = ie(T)); ++b < T; )
          h[b] = u[b];
        return h;
      }
      function ji(u, h, b, T) {
        var M = !b;
        b || (b = {});
        for (var B = -1, G = h.length; ++B < G; ) {
          var q = h[B], J = T ? T(b[q], u[q], q, b, u) : n;
          J === n && (J = u[q]), M ? fo(b, q, J) : uu(b, q, J);
        }
        return b;
      }
      function bV(u, h) {
        return ji(u, _v(u), h);
      }
      function xV(u, h) {
        return ji(u, _A(u), h);
      }
      function uh(u, h) {
        return function(b, T) {
          var M = Ye(b) ? A5 : z3, B = h ? h() : {};
          return M(b, u, De(T, 2), B);
        };
      }
      function ml(u) {
        return nt(function(h, b) {
          var T = -1, M = b.length, B = M > 1 ? b[M - 1] : n, G = M > 2 ? b[2] : n;
          for (B = u.length > 3 && typeof B == "function" ? (M--, B) : n, G && ar(b[0], b[1], G) && (B = M < 3 ? n : B, M = 1), h = Mt(h); ++T < M; ) {
            var q = b[T];
            q && u(h, q, T, B);
          }
          return h;
        });
      }
      function uA(u, h) {
        return function(b, T) {
          if (b == null)
            return b;
          if (!yr(b))
            return u(b, T);
          for (var M = b.length, B = h ? M : -1, G = Mt(b); (h ? B-- : ++B < M) && T(G[B], B, G) !== !1; )
            ;
          return b;
        };
      }
      function fA(u) {
        return function(h, b, T) {
          for (var M = -1, B = Mt(h), G = T(h), q = G.length; q--; ) {
            var J = G[u ? q : ++M];
            if (b(B[J], J, B) === !1)
              break;
          }
          return h;
        };
      }
      function wV(u, h, b) {
        var T = h & v, M = mu(u);
        function B() {
          var G = this && this !== Ln && this instanceof B ? M : u;
          return G.apply(T ? b : this, arguments);
        }
        return B;
      }
      function dA(u) {
        return function(h) {
          h = vt(h);
          var b = ll(h) ? yi(h) : n, T = b ? b[0] : h.charAt(0), M = b ? fa(b, 1).join("") : h.slice(1);
          return T[u]() + M;
        };
      }
      function gl(u) {
        return function(h) {
          return Fy(uT(cT(h).replace(f5, "")), u, "");
        };
      }
      function mu(u) {
        return function() {
          var h = arguments;
          switch (h.length) {
            case 0:
              return new u();
            case 1:
              return new u(h[0]);
            case 2:
              return new u(h[0], h[1]);
            case 3:
              return new u(h[0], h[1], h[2]);
            case 4:
              return new u(h[0], h[1], h[2], h[3]);
            case 5:
              return new u(h[0], h[1], h[2], h[3], h[4]);
            case 6:
              return new u(h[0], h[1], h[2], h[3], h[4], h[5]);
            case 7:
              return new u(h[0], h[1], h[2], h[3], h[4], h[5], h[6]);
          }
          var b = pl(u.prototype), T = u.apply(b, h);
          return Jt(T) ? T : b;
        };
      }
      function _V(u, h, b) {
        var T = mu(u);
        function M() {
          for (var B = arguments.length, G = ie(B), q = B, J = yl(M); q--; )
            G[q] = arguments[q];
          var he = B < 3 && G[0] !== J && G[B - 1] !== J ? [] : aa(G, J);
          if (B -= he.length, B < b)
            return yA(
              u,
              h,
              fh,
              M.placeholder,
              n,
              G,
              he,
              n,
              n,
              b - B
            );
          var me = this && this !== Ln && this instanceof M ? T : u;
          return Cr(me, this, G);
        }
        return M;
      }
      function hA(u) {
        return function(h, b, T) {
          var M = Mt(h);
          if (!yr(h)) {
            var B = De(b, 3);
            h = En(h), b = function(q) {
              return B(M[q], q, M);
            };
          }
          var G = u(h, b, T);
          return G > -1 ? M[B ? h[G] : G] : n;
        };
      }
      function pA(u) {
        return po(function(h) {
          var b = h.length, T = b, M = ei.prototype.thru;
          for (u && h.reverse(); T--; ) {
            var B = h[T];
            if (typeof B != "function")
              throw new Qr(a);
            if (M && !G && mh(B) == "wrapper")
              var G = new ei([], !0);
          }
          for (T = G ? T : b; ++T < b; ) {
            B = h[T];
            var q = mh(B), J = q == "wrapper" ? xv(B) : n;
            J && Ov(J[0]) && J[1] == (P | S | _ | C) && !J[4].length && J[9] == 1 ? G = G[mh(J[0])].apply(G, J[3]) : G = B.length == 1 && Ov(B) ? G[q]() : G.thru(B);
          }
          return function() {
            var he = arguments, me = he[0];
            if (G && he.length == 1 && Ye(me))
              return G.plant(me).value();
            for (var ye = 0, xe = b ? h[ye].apply(this, he) : me; ++ye < b; )
              xe = h[ye].call(this, xe);
            return xe;
          };
        });
      }
      function fh(u, h, b, T, M, B, G, q, J, he) {
        var me = h & P, ye = h & v, xe = h & x, Ce = h & (S | A), Re = h & k, et = xe ? n : mu(u);
        function je() {
          for (var ot = arguments.length, ft = ie(ot), Nr = ot; Nr--; )
            ft[Nr] = arguments[Nr];
          if (Ce)
            var sr = yl(je), $r = D5(ft, sr);
          if (T && (ft = lA(ft, T, M, Ce)), B && (ft = cA(ft, B, G, Ce)), ot -= $r, Ce && ot < he) {
            var sn = aa(ft, sr);
            return yA(
              u,
              h,
              fh,
              je.placeholder,
              b,
              ft,
              sn,
              q,
              J,
              he - ot
            );
          }
          var xi = ye ? b : this, vo = xe ? xi[u] : u;
          return ot = ft.length, q ? ft = zV(ft, q) : Re && ot > 1 && ft.reverse(), me && J < ot && (ft.length = J), this && this !== Ln && this instanceof je && (vo = et || mu(vo)), vo.apply(xi, ft);
        }
        return je;
      }
      function mA(u, h) {
        return function(b, T) {
          return X3(b, u, h(T), {});
        };
      }
      function dh(u, h) {
        return function(b, T) {
          var M;
          if (b === n && T === n)
            return h;
          if (b !== n && (M = b), T !== n) {
            if (M === n)
              return T;
            typeof b == "string" || typeof T == "string" ? (b = kr(b), T = kr(T)) : (b = eA(b), T = eA(T)), M = u(b, T);
          }
          return M;
        };
      }
      function gv(u) {
        return po(function(h) {
          return h = Gt(h, Er(De())), nt(function(b) {
            var T = this;
            return u(h, function(M) {
              return Cr(M, T, b);
            });
          });
        });
      }
      function hh(u, h) {
        h = h === n ? " " : kr(h);
        var b = h.length;
        if (b < 2)
          return b ? cv(h, u) : h;
        var T = cv(h, Qd(u / cl(h)));
        return ll(h) ? fa(yi(T), 0, u).join("") : T.slice(0, u);
      }
      function SV(u, h, b, T) {
        var M = h & v, B = mu(u);
        function G() {
          for (var q = -1, J = arguments.length, he = -1, me = T.length, ye = ie(me + J), xe = this && this !== Ln && this instanceof G ? B : u; ++he < me; )
            ye[he] = T[he];
          for (; J--; )
            ye[he++] = arguments[++q];
          return Cr(xe, M ? b : this, ye);
        }
        return G;
      }
      function gA(u) {
        return function(h, b, T) {
          return T && typeof T != "number" && ar(h, b, T) && (b = T = n), h = yo(h), b === n ? (b = h, h = 0) : b = yo(b), T = T === n ? h < b ? 1 : -1 : yo(T), lV(h, b, T, u);
        };
      }
      function ph(u) {
        return function(h, b) {
          return typeof h == "string" && typeof b == "string" || (h = ii(h), b = ii(b)), u(h, b);
        };
      }
      function yA(u, h, b, T, M, B, G, q, J, he) {
        var me = h & S, ye = me ? G : n, xe = me ? n : G, Ce = me ? B : n, Re = me ? n : B;
        h |= me ? _ : O, h &= ~(me ? O : _), h & w || (h &= ~(v | x));
        var et = [
          u,
          h,
          M,
          Ce,
          ye,
          Re,
          xe,
          q,
          J,
          he
        ], je = b.apply(n, et);
        return Ov(u) && EA(je, et), je.placeholder = T, kA(je, u, h);
      }
      function yv(u) {
        var h = vn[u];
        return function(b, T) {
          if (b = ii(b), T = T == null ? 0 : Zn(Ze(T), 292), T && kO(b)) {
            var M = (vt(b) + "e").split("e"), B = h(M[0] + "e" + (+M[1] + T));
            return M = (vt(B) + "e").split("e"), +(M[0] + "e" + (+M[1] - T));
          }
          return h(b);
        };
      }
      var OV = dl && 1 / Vd(new dl([, -0]))[1] == z ? function(u) {
        return new dl(u);
      } : Bv;
      function vA(u) {
        return function(h) {
          var b = Jn(h);
          return b == de ? Gy(h) : b == Oe ? W5(h) : $5(h, u(h));
        };
      }
      function ho(u, h, b, T, M, B, G, q) {
        var J = h & x;
        if (!J && typeof u != "function")
          throw new Qr(a);
        var he = T ? T.length : 0;
        if (he || (h &= ~(_ | O), T = M = n), G = G === n ? G : bn(Ze(G), 0), q = q === n ? q : Ze(q), he -= M ? M.length : 0, h & O) {
          var me = T, ye = M;
          T = M = n;
        }
        var xe = J ? n : xv(u), Ce = [
          u,
          h,
          b,
          T,
          M,
          me,
          ye,
          B,
          G,
          q
        ];
        if (xe && BV(Ce, xe), u = Ce[0], h = Ce[1], b = Ce[2], T = Ce[3], M = Ce[4], q = Ce[9] = Ce[9] === n ? J ? 0 : u.length : bn(Ce[9] - he, 0), !q && h & (S | A) && (h &= ~(S | A)), !h || h == v)
          var Re = wV(u, h, b);
        else h == S || h == A ? Re = _V(u, h, q) : (h == _ || h == (v | _)) && !M.length ? Re = SV(u, h, b, T) : Re = fh.apply(n, Ce);
        var et = xe ? JO : EA;
        return kA(et(Re, Ce), u, h);
      }
      function bA(u, h, b, T) {
        return u === n || bi(u, fl[b]) && !Ot.call(T, b) ? h : u;
      }
      function xA(u, h, b, T, M, B) {
        return Jt(u) && Jt(h) && (B.set(h, u), sh(u, h, n, xA, B), B.delete(h)), u;
      }
      function AV(u) {
        return vu(u) ? n : u;
      }
      function wA(u, h, b, T, M, B) {
        var G = b & y, q = u.length, J = h.length;
        if (q != J && !(G && J > q))
          return !1;
        var he = B.get(u), me = B.get(h);
        if (he && me)
          return he == h && me == u;
        var ye = -1, xe = !0, Ce = b & g ? new es() : n;
        for (B.set(u, h), B.set(h, u); ++ye < q; ) {
          var Re = u[ye], et = h[ye];
          if (T)
            var je = G ? T(et, Re, ye, h, u, B) : T(Re, et, ye, u, h, B);
          if (je !== n) {
            if (je)
              continue;
            xe = !1;
            break;
          }
          if (Ce) {
            if (!Wy(h, function(ot, ft) {
              if (!iu(Ce, ft) && (Re === ot || M(Re, ot, b, T, B)))
                return Ce.push(ft);
            })) {
              xe = !1;
              break;
            }
          } else if (!(Re === et || M(Re, et, b, T, B))) {
            xe = !1;
            break;
          }
        }
        return B.delete(u), B.delete(h), xe;
      }
      function TV(u, h, b, T, M, B, G) {
        switch (b) {
          case yn:
            if (u.byteLength != h.byteLength || u.byteOffset != h.byteOffset)
              return !1;
            u = u.buffer, h = h.buffer;
          case Cn:
            return !(u.byteLength != h.byteLength || !B(new qd(u), new qd(h)));
          case ae:
          case ee:
          case ke:
            return bi(+u, +h);
          case ge:
            return u.name == h.name && u.message == h.message;
          case ct:
          case Ge:
            return u == h + "";
          case de:
            var q = Gy;
          case Oe:
            var J = T & y;
            if (q || (q = Vd), u.size != h.size && !J)
              return !1;
            var he = G.get(u);
            if (he)
              return he == h;
            T |= g, G.set(u, h);
            var me = wA(q(u), q(h), T, M, B, G);
            return G.delete(u), me;
          case Zt:
            if (cu)
              return cu.call(u) == cu.call(h);
        }
        return !1;
      }
      function PV(u, h, b, T, M, B) {
        var G = b & y, q = vv(u), J = q.length, he = vv(h), me = he.length;
        if (J != me && !G)
          return !1;
        for (var ye = J; ye--; ) {
          var xe = q[ye];
          if (!(G ? xe in h : Ot.call(h, xe)))
            return !1;
        }
        var Ce = B.get(u), Re = B.get(h);
        if (Ce && Re)
          return Ce == h && Re == u;
        var et = !0;
        B.set(u, h), B.set(h, u);
        for (var je = G; ++ye < J; ) {
          xe = q[ye];
          var ot = u[xe], ft = h[xe];
          if (T)
            var Nr = G ? T(ft, ot, xe, h, u, B) : T(ot, ft, xe, u, h, B);
          if (!(Nr === n ? ot === ft || M(ot, ft, b, T, B) : Nr)) {
            et = !1;
            break;
          }
          je || (je = xe == "constructor");
        }
        if (et && !je) {
          var sr = u.constructor, $r = h.constructor;
          sr != $r && "constructor" in u && "constructor" in h && !(typeof sr == "function" && sr instanceof sr && typeof $r == "function" && $r instanceof $r) && (et = !1);
        }
        return B.delete(u), B.delete(h), et;
      }
      function po(u) {
        return Tv(PA(u, n, RA), u + "");
      }
      function vv(u) {
        return WO(u, En, _v);
      }
      function bv(u) {
        return WO(u, vr, _A);
      }
      var xv = th ? function(u) {
        return th.get(u);
      } : Bv;
      function mh(u) {
        for (var h = u.name + "", b = hl[h], T = Ot.call(hl, h) ? b.length : 0; T--; ) {
          var M = b[T], B = M.func;
          if (B == null || B == u)
            return M.name;
        }
        return h;
      }
      function yl(u) {
        var h = Ot.call(L, "placeholder") ? L : u;
        return h.placeholder;
      }
      function De() {
        var u = L.iteratee || jv;
        return u = u === jv ? UO : u, arguments.length ? u(arguments[0], arguments[1]) : u;
      }
      function gh(u, h) {
        var b = u.__data__;
        return IV(h) ? b[typeof h == "string" ? "string" : "hash"] : b.map;
      }
      function wv(u) {
        for (var h = En(u), b = h.length; b--; ) {
          var T = h[b], M = u[T];
          h[b] = [T, M, AA(M)];
        }
        return h;
      }
      function rs(u, h) {
        var b = L5(u, h);
        return VO(b) ? b : n;
      }
      function CV(u) {
        var h = Ot.call(u, Ja), b = u[Ja];
        try {
          u[Ja] = n;
          var T = !0;
        } catch {
        }
        var M = Gd.call(u);
        return T && (h ? u[Ja] = b : delete u[Ja]), M;
      }
      var _v = qy ? function(u) {
        return u == null ? [] : (u = Mt(u), ia(qy(u), function(h) {
          return CO.call(u, h);
        }));
      } : Fv, _A = qy ? function(u) {
        for (var h = []; u; )
          oa(h, _v(u)), u = Xd(u);
        return h;
      } : Fv, Jn = or;
      (Xy && Jn(new Xy(new ArrayBuffer(1))) != yn || au && Jn(new au()) != de || Zy && Jn(Zy.resolve()) != Xn || dl && Jn(new dl()) != Oe || su && Jn(new su()) != en) && (Jn = function(u) {
        var h = or(u), b = h == lt ? u.constructor : n, T = b ? is(b) : "";
        if (T)
          switch (T) {
            case u3:
              return yn;
            case f3:
              return de;
            case d3:
              return Xn;
            case h3:
              return Oe;
            case p3:
              return en;
          }
        return h;
      });
      function EV(u, h, b) {
        for (var T = -1, M = b.length; ++T < M; ) {
          var B = b[T], G = B.size;
          switch (B.type) {
            case "drop":
              u += G;
              break;
            case "dropRight":
              h -= G;
              break;
            case "take":
              h = Zn(h, u + G);
              break;
            case "takeRight":
              u = bn(u, h - G);
              break;
          }
        }
        return { start: u, end: h };
      }
      function kV(u) {
        var h = u.match(Rz);
        return h ? h[1].split(jz) : [];
      }
      function SA(u, h, b) {
        h = ua(h, u);
        for (var T = -1, M = h.length, B = !1; ++T < M; ) {
          var G = Li(h[T]);
          if (!(B = u != null && b(u, G)))
            break;
          u = u[G];
        }
        return B || ++T != M ? B : (M = u == null ? 0 : u.length, !!M && Sh(M) && mo(G, M) && (Ye(u) || os(u)));
      }
      function MV(u) {
        var h = u.length, b = new u.constructor(h);
        return h && typeof u[0] == "string" && Ot.call(u, "index") && (b.index = u.index, b.input = u.input), b;
      }
      function OA(u) {
        return typeof u.constructor == "function" && !gu(u) ? pl(Xd(u)) : {};
      }
      function NV(u, h, b) {
        var T = u.constructor;
        switch (h) {
          case Cn:
            return mv(u);
          case ae:
          case ee:
            return new T(+u);
          case yn:
            return mV(u, b);
          case mr:
          case tt:
          case Kt:
          case St:
          case jn:
          case qr:
          case lo:
          case un:
          case Pr:
            return aA(u, b);
          case de:
            return new T();
          case ke:
          case Ge:
            return new T(u);
          case ct:
            return gV(u);
          case Oe:
            return new T();
          case Zt:
            return yV(u);
        }
      }
      function $V(u, h) {
        var b = h.length;
        if (!b)
          return u;
        var T = b - 1;
        return h[T] = (b > 1 ? "& " : "") + h[T], h = h.join(b > 2 ? ", " : " "), u.replace(Iz, `{
/* [wrapped with ` + h + `] */
`);
      }
      function DV(u) {
        return Ye(u) || os(u) || !!(EO && u && u[EO]);
      }
      function mo(u, h) {
        var b = typeof u;
        return h = h ?? H, !!h && (b == "number" || b != "symbol" && Kz.test(u)) && u > -1 && u % 1 == 0 && u < h;
      }
      function ar(u, h, b) {
        if (!Jt(b))
          return !1;
        var T = typeof h;
        return (T == "number" ? yr(b) && mo(h, b.length) : T == "string" && h in b) ? bi(b[h], u) : !1;
      }
      function Sv(u, h) {
        if (Ye(u))
          return !1;
        var b = typeof u;
        return b == "number" || b == "symbol" || b == "boolean" || u == null || Mr(u) ? !0 : Mz.test(u) || !kz.test(u) || h != null && u in Mt(h);
      }
      function IV(u) {
        var h = typeof u;
        return h == "string" || h == "number" || h == "symbol" || h == "boolean" ? u !== "__proto__" : u === null;
      }
      function Ov(u) {
        var h = mh(u), b = L[h];
        if (typeof b != "function" || !(h in ut.prototype))
          return !1;
        if (u === b)
          return !0;
        var T = xv(b);
        return !!T && u === T[0];
      }
      function RV(u) {
        return !!AO && AO in u;
      }
      var jV = Hd ? go : Wv;
      function gu(u) {
        var h = u && u.constructor, b = typeof h == "function" && h.prototype || fl;
        return u === b;
      }
      function AA(u) {
        return u === u && !Jt(u);
      }
      function TA(u, h) {
        return function(b) {
          return b == null ? !1 : b[u] === h && (h !== n || u in Mt(b));
        };
      }
      function LV(u) {
        var h = wh(u, function(T) {
          return b.size === c && b.clear(), T;
        }), b = h.cache;
        return h;
      }
      function BV(u, h) {
        var b = u[1], T = h[1], M = b | T, B = M < (v | x | P), G = T == P && b == S || T == P && b == C && u[7].length <= h[8] || T == (P | C) && h[7].length <= h[8] && b == S;
        if (!(B || G))
          return u;
        T & v && (u[2] = h[2], M |= b & v ? 0 : w);
        var q = h[3];
        if (q) {
          var J = u[3];
          u[3] = J ? lA(J, q, h[4]) : q, u[4] = J ? aa(u[3], f) : h[4];
        }
        return q = h[5], q && (J = u[5], u[5] = J ? cA(J, q, h[6]) : q, u[6] = J ? aa(u[5], f) : h[6]), q = h[7], q && (u[7] = q), T & P && (u[8] = u[8] == null ? h[8] : Zn(u[8], h[8])), u[9] == null && (u[9] = h[9]), u[0] = h[0], u[1] = M, u;
      }
      function FV(u) {
        var h = [];
        if (u != null)
          for (var b in Mt(u))
            h.push(b);
        return h;
      }
      function WV(u) {
        return Gd.call(u);
      }
      function PA(u, h, b) {
        return h = bn(h === n ? u.length - 1 : h, 0), function() {
          for (var T = arguments, M = -1, B = bn(T.length - h, 0), G = ie(B); ++M < B; )
            G[M] = T[h + M];
          M = -1;
          for (var q = ie(h + 1); ++M < h; )
            q[M] = T[M];
          return q[h] = b(G), Cr(u, this, q);
        };
      }
      function CA(u, h) {
        return h.length < 2 ? u : ns(u, ni(h, 0, -1));
      }
      function zV(u, h) {
        for (var b = u.length, T = Zn(h.length, b), M = gr(u); T--; ) {
          var B = h[T];
          u[T] = mo(B, b) ? M[B] : n;
        }
        return u;
      }
      function Av(u, h) {
        if (!(h === "constructor" && typeof u[h] == "function") && h != "__proto__")
          return u[h];
      }
      var EA = MA(JO), yu = r3 || function(u, h) {
        return Ln.setTimeout(u, h);
      }, Tv = MA(fV);
      function kA(u, h, b) {
        var T = h + "";
        return Tv(u, $V(T, VV(kV(T), b)));
      }
      function MA(u) {
        var h = 0, b = 0;
        return function() {
          var T = s3(), M = D - (T - b);
          if (b = T, M > 0) {
            if (++h >= N)
              return arguments[0];
          } else
            h = 0;
          return u.apply(n, arguments);
        };
      }
      function yh(u, h) {
        var b = -1, T = u.length, M = T - 1;
        for (h = h === n ? T : h; ++b < h; ) {
          var B = lv(b, M), G = u[B];
          u[B] = u[b], u[b] = G;
        }
        return u.length = h, u;
      }
      var NA = LV(function(u) {
        var h = [];
        return u.charCodeAt(0) === 46 && h.push(""), u.replace(Nz, function(b, T, M, B) {
          h.push(M ? B.replace(Fz, "$1") : T || b);
        }), h;
      });
      function Li(u) {
        if (typeof u == "string" || Mr(u))
          return u;
        var h = u + "";
        return h == "0" && 1 / u == -z ? "-0" : h;
      }
      function is(u) {
        if (u != null) {
          try {
            return Kd.call(u);
          } catch {
          }
          try {
            return u + "";
          } catch {
          }
        }
        return "";
      }
      function VV(u, h) {
        return Jr(re, function(b) {
          var T = "_." + b[0];
          h & b[1] && !Wd(u, T) && u.push(T);
        }), u.sort();
      }
      function $A(u) {
        if (u instanceof ut)
          return u.clone();
        var h = new ei(u.__wrapped__, u.__chain__);
        return h.__actions__ = gr(u.__actions__), h.__index__ = u.__index__, h.__values__ = u.__values__, h;
      }
      function UV(u, h, b) {
        (b ? ar(u, h, b) : h === n) ? h = 1 : h = bn(Ze(h), 0);
        var T = u == null ? 0 : u.length;
        if (!T || h < 1)
          return [];
        for (var M = 0, B = 0, G = ie(Qd(T / h)); M < T; )
          G[B++] = ni(u, M, M += h);
        return G;
      }
      function HV(u) {
        for (var h = -1, b = u == null ? 0 : u.length, T = 0, M = []; ++h < b; ) {
          var B = u[h];
          B && (M[T++] = B);
        }
        return M;
      }
      function KV() {
        var u = arguments.length;
        if (!u)
          return [];
        for (var h = ie(u - 1), b = arguments[0], T = u; T--; )
          h[T - 1] = arguments[T];
        return oa(Ye(b) ? gr(b) : [b], Bn(h, 1));
      }
      var GV = nt(function(u, h) {
        return an(u) ? fu(u, Bn(h, 1, an, !0)) : [];
      }), YV = nt(function(u, h) {
        var b = ri(h);
        return an(b) && (b = n), an(u) ? fu(u, Bn(h, 1, an, !0), De(b, 2)) : [];
      }), qV = nt(function(u, h) {
        var b = ri(h);
        return an(b) && (b = n), an(u) ? fu(u, Bn(h, 1, an, !0), n, b) : [];
      });
      function XV(u, h, b) {
        var T = u == null ? 0 : u.length;
        return T ? (h = b || h === n ? 1 : Ze(h), ni(u, h < 0 ? 0 : h, T)) : [];
      }
      function ZV(u, h, b) {
        var T = u == null ? 0 : u.length;
        return T ? (h = b || h === n ? 1 : Ze(h), h = T - h, ni(u, 0, h < 0 ? 0 : h)) : [];
      }
      function JV(u, h) {
        return u && u.length ? ch(u, De(h, 3), !0, !0) : [];
      }
      function QV(u, h) {
        return u && u.length ? ch(u, De(h, 3), !0) : [];
      }
      function e4(u, h, b, T) {
        var M = u == null ? 0 : u.length;
        return M ? (b && typeof b != "number" && ar(u, h, b) && (b = 0, T = M), K3(u, h, b, T)) : [];
      }
      function DA(u, h, b) {
        var T = u == null ? 0 : u.length;
        if (!T)
          return -1;
        var M = b == null ? 0 : Ze(b);
        return M < 0 && (M = bn(T + M, 0)), zd(u, De(h, 3), M);
      }
      function IA(u, h, b) {
        var T = u == null ? 0 : u.length;
        if (!T)
          return -1;
        var M = T - 1;
        return b !== n && (M = Ze(b), M = b < 0 ? bn(T + M, 0) : Zn(M, T - 1)), zd(u, De(h, 3), M, !0);
      }
      function RA(u) {
        var h = u == null ? 0 : u.length;
        return h ? Bn(u, 1) : [];
      }
      function t4(u) {
        var h = u == null ? 0 : u.length;
        return h ? Bn(u, z) : [];
      }
      function n4(u, h) {
        var b = u == null ? 0 : u.length;
        return b ? (h = h === n ? 1 : Ze(h), Bn(u, h)) : [];
      }
      function r4(u) {
        for (var h = -1, b = u == null ? 0 : u.length, T = {}; ++h < b; ) {
          var M = u[h];
          T[M[0]] = M[1];
        }
        return T;
      }
      function jA(u) {
        return u && u.length ? u[0] : n;
      }
      function i4(u, h, b) {
        var T = u == null ? 0 : u.length;
        if (!T)
          return -1;
        var M = b == null ? 0 : Ze(b);
        return M < 0 && (M = bn(T + M, 0)), sl(u, h, M);
      }
      function o4(u) {
        var h = u == null ? 0 : u.length;
        return h ? ni(u, 0, -1) : [];
      }
      var a4 = nt(function(u) {
        var h = Gt(u, hv);
        return h.length && h[0] === u[0] ? rv(h) : [];
      }), s4 = nt(function(u) {
        var h = ri(u), b = Gt(u, hv);
        return h === ri(b) ? h = n : b.pop(), b.length && b[0] === u[0] ? rv(b, De(h, 2)) : [];
      }), l4 = nt(function(u) {
        var h = ri(u), b = Gt(u, hv);
        return h = typeof h == "function" ? h : n, h && b.pop(), b.length && b[0] === u[0] ? rv(b, n, h) : [];
      });
      function c4(u, h) {
        return u == null ? "" : o3.call(u, h);
      }
      function ri(u) {
        var h = u == null ? 0 : u.length;
        return h ? u[h - 1] : n;
      }
      function u4(u, h, b) {
        var T = u == null ? 0 : u.length;
        if (!T)
          return -1;
        var M = T;
        return b !== n && (M = Ze(b), M = M < 0 ? bn(T + M, 0) : Zn(M, T - 1)), h === h ? V5(u, h, M) : zd(u, yO, M, !0);
      }
      function f4(u, h) {
        return u && u.length ? YO(u, Ze(h)) : n;
      }
      var d4 = nt(LA);
      function LA(u, h) {
        return u && u.length && h && h.length ? sv(u, h) : u;
      }
      function h4(u, h, b) {
        return u && u.length && h && h.length ? sv(u, h, De(b, 2)) : u;
      }
      function p4(u, h, b) {
        return u && u.length && h && h.length ? sv(u, h, n, b) : u;
      }
      var m4 = po(function(u, h) {
        var b = u == null ? 0 : u.length, T = Qy(u, h);
        return ZO(u, Gt(h, function(M) {
          return mo(M, b) ? +M : M;
        }).sort(sA)), T;
      });
      function g4(u, h) {
        var b = [];
        if (!(u && u.length))
          return b;
        var T = -1, M = [], B = u.length;
        for (h = De(h, 3); ++T < B; ) {
          var G = u[T];
          h(G, T, u) && (b.push(G), M.push(T));
        }
        return ZO(u, M), b;
      }
      function Pv(u) {
        return u == null ? u : c3.call(u);
      }
      function y4(u, h, b) {
        var T = u == null ? 0 : u.length;
        return T ? (b && typeof b != "number" && ar(u, h, b) ? (h = 0, b = T) : (h = h == null ? 0 : Ze(h), b = b === n ? T : Ze(b)), ni(u, h, b)) : [];
      }
      function v4(u, h) {
        return lh(u, h);
      }
      function b4(u, h, b) {
        return uv(u, h, De(b, 2));
      }
      function x4(u, h) {
        var b = u == null ? 0 : u.length;
        if (b) {
          var T = lh(u, h);
          if (T < b && bi(u[T], h))
            return T;
        }
        return -1;
      }
      function w4(u, h) {
        return lh(u, h, !0);
      }
      function _4(u, h, b) {
        return uv(u, h, De(b, 2), !0);
      }
      function S4(u, h) {
        var b = u == null ? 0 : u.length;
        if (b) {
          var T = lh(u, h, !0) - 1;
          if (bi(u[T], h))
            return T;
        }
        return -1;
      }
      function O4(u) {
        return u && u.length ? QO(u) : [];
      }
      function A4(u, h) {
        return u && u.length ? QO(u, De(h, 2)) : [];
      }
      function T4(u) {
        var h = u == null ? 0 : u.length;
        return h ? ni(u, 1, h) : [];
      }
      function P4(u, h, b) {
        return u && u.length ? (h = b || h === n ? 1 : Ze(h), ni(u, 0, h < 0 ? 0 : h)) : [];
      }
      function C4(u, h, b) {
        var T = u == null ? 0 : u.length;
        return T ? (h = b || h === n ? 1 : Ze(h), h = T - h, ni(u, h < 0 ? 0 : h, T)) : [];
      }
      function E4(u, h) {
        return u && u.length ? ch(u, De(h, 3), !1, !0) : [];
      }
      function k4(u, h) {
        return u && u.length ? ch(u, De(h, 3)) : [];
      }
      var M4 = nt(function(u) {
        return ca(Bn(u, 1, an, !0));
      }), N4 = nt(function(u) {
        var h = ri(u);
        return an(h) && (h = n), ca(Bn(u, 1, an, !0), De(h, 2));
      }), $4 = nt(function(u) {
        var h = ri(u);
        return h = typeof h == "function" ? h : n, ca(Bn(u, 1, an, !0), n, h);
      });
      function D4(u) {
        return u && u.length ? ca(u) : [];
      }
      function I4(u, h) {
        return u && u.length ? ca(u, De(h, 2)) : [];
      }
      function R4(u, h) {
        return h = typeof h == "function" ? h : n, u && u.length ? ca(u, n, h) : [];
      }
      function Cv(u) {
        if (!(u && u.length))
          return [];
        var h = 0;
        return u = ia(u, function(b) {
          if (an(b))
            return h = bn(b.length, h), !0;
        }), Hy(h, function(b) {
          return Gt(u, zy(b));
        });
      }
      function BA(u, h) {
        if (!(u && u.length))
          return [];
        var b = Cv(u);
        return h == null ? b : Gt(b, function(T) {
          return Cr(h, n, T);
        });
      }
      var j4 = nt(function(u, h) {
        return an(u) ? fu(u, h) : [];
      }), L4 = nt(function(u) {
        return dv(ia(u, an));
      }), B4 = nt(function(u) {
        var h = ri(u);
        return an(h) && (h = n), dv(ia(u, an), De(h, 2));
      }), F4 = nt(function(u) {
        var h = ri(u);
        return h = typeof h == "function" ? h : n, dv(ia(u, an), n, h);
      }), W4 = nt(Cv);
      function z4(u, h) {
        return rA(u || [], h || [], uu);
      }
      function V4(u, h) {
        return rA(u || [], h || [], pu);
      }
      var U4 = nt(function(u) {
        var h = u.length, b = h > 1 ? u[h - 1] : n;
        return b = typeof b == "function" ? (u.pop(), b) : n, BA(u, b);
      });
      function FA(u) {
        var h = L(u);
        return h.__chain__ = !0, h;
      }
      function H4(u, h) {
        return h(u), u;
      }
      function vh(u, h) {
        return h(u);
      }
      var K4 = po(function(u) {
        var h = u.length, b = h ? u[0] : 0, T = this.__wrapped__, M = function(B) {
          return Qy(B, u);
        };
        return h > 1 || this.__actions__.length || !(T instanceof ut) || !mo(b) ? this.thru(M) : (T = T.slice(b, +b + (h ? 1 : 0)), T.__actions__.push({
          func: vh,
          args: [M],
          thisArg: n
        }), new ei(T, this.__chain__).thru(function(B) {
          return h && !B.length && B.push(n), B;
        }));
      });
      function G4() {
        return FA(this);
      }
      function Y4() {
        return new ei(this.value(), this.__chain__);
      }
      function q4() {
        this.__values__ === n && (this.__values__ = eT(this.value()));
        var u = this.__index__ >= this.__values__.length, h = u ? n : this.__values__[this.__index__++];
        return { done: u, value: h };
      }
      function X4() {
        return this;
      }
      function Z4(u) {
        for (var h, b = this; b instanceof rh; ) {
          var T = $A(b);
          T.__index__ = 0, T.__values__ = n, h ? M.__wrapped__ = T : h = T;
          var M = T;
          b = b.__wrapped__;
        }
        return M.__wrapped__ = u, h;
      }
      function J4() {
        var u = this.__wrapped__;
        if (u instanceof ut) {
          var h = u;
          return this.__actions__.length && (h = new ut(this)), h = h.reverse(), h.__actions__.push({
            func: vh,
            args: [Pv],
            thisArg: n
          }), new ei(h, this.__chain__);
        }
        return this.thru(Pv);
      }
      function Q4() {
        return nA(this.__wrapped__, this.__actions__);
      }
      var eU = uh(function(u, h, b) {
        Ot.call(u, b) ? ++u[b] : fo(u, b, 1);
      });
      function tU(u, h, b) {
        var T = Ye(u) ? mO : H3;
        return b && ar(u, h, b) && (h = n), T(u, De(h, 3));
      }
      function nU(u, h) {
        var b = Ye(u) ? ia : BO;
        return b(u, De(h, 3));
      }
      var rU = hA(DA), iU = hA(IA);
      function oU(u, h) {
        return Bn(bh(u, h), 1);
      }
      function aU(u, h) {
        return Bn(bh(u, h), z);
      }
      function sU(u, h, b) {
        return b = b === n ? 1 : Ze(b), Bn(bh(u, h), b);
      }
      function WA(u, h) {
        var b = Ye(u) ? Jr : la;
        return b(u, De(h, 3));
      }
      function zA(u, h) {
        var b = Ye(u) ? T5 : LO;
        return b(u, De(h, 3));
      }
      var lU = uh(function(u, h, b) {
        Ot.call(u, b) ? u[b].push(h) : fo(u, b, [h]);
      });
      function cU(u, h, b, T) {
        u = yr(u) ? u : bl(u), b = b && !T ? Ze(b) : 0;
        var M = u.length;
        return b < 0 && (b = bn(M + b, 0)), Oh(u) ? b <= M && u.indexOf(h, b) > -1 : !!M && sl(u, h, b) > -1;
      }
      var uU = nt(function(u, h, b) {
        var T = -1, M = typeof h == "function", B = yr(u) ? ie(u.length) : [];
        return la(u, function(G) {
          B[++T] = M ? Cr(h, G, b) : du(G, h, b);
        }), B;
      }), fU = uh(function(u, h, b) {
        fo(u, b, h);
      });
      function bh(u, h) {
        var b = Ye(u) ? Gt : HO;
        return b(u, De(h, 3));
      }
      function dU(u, h, b, T) {
        return u == null ? [] : (Ye(h) || (h = h == null ? [] : [h]), b = T ? n : b, Ye(b) || (b = b == null ? [] : [b]), qO(u, h, b));
      }
      var hU = uh(function(u, h, b) {
        u[b ? 0 : 1].push(h);
      }, function() {
        return [[], []];
      });
      function pU(u, h, b) {
        var T = Ye(u) ? Fy : bO, M = arguments.length < 3;
        return T(u, De(h, 4), b, M, la);
      }
      function mU(u, h, b) {
        var T = Ye(u) ? P5 : bO, M = arguments.length < 3;
        return T(u, De(h, 4), b, M, LO);
      }
      function gU(u, h) {
        var b = Ye(u) ? ia : BO;
        return b(u, _h(De(h, 3)));
      }
      function yU(u) {
        var h = Ye(u) ? DO : cV;
        return h(u);
      }
      function vU(u, h, b) {
        (b ? ar(u, h, b) : h === n) ? h = 1 : h = Ze(h);
        var T = Ye(u) ? F3 : uV;
        return T(u, h);
      }
      function bU(u) {
        var h = Ye(u) ? W3 : dV;
        return h(u);
      }
      function xU(u) {
        if (u == null)
          return 0;
        if (yr(u))
          return Oh(u) ? cl(u) : u.length;
        var h = Jn(u);
        return h == de || h == Oe ? u.size : ov(u).length;
      }
      function wU(u, h, b) {
        var T = Ye(u) ? Wy : hV;
        return b && ar(u, h, b) && (h = n), T(u, De(h, 3));
      }
      var _U = nt(function(u, h) {
        if (u == null)
          return [];
        var b = h.length;
        return b > 1 && ar(u, h[0], h[1]) ? h = [] : b > 2 && ar(h[0], h[1], h[2]) && (h = [h[0]]), qO(u, Bn(h, 1), []);
      }), xh = n3 || function() {
        return Ln.Date.now();
      };
      function SU(u, h) {
        if (typeof h != "function")
          throw new Qr(a);
        return u = Ze(u), function() {
          if (--u < 1)
            return h.apply(this, arguments);
        };
      }
      function VA(u, h, b) {
        return h = b ? n : h, h = u && h == null ? u.length : h, ho(u, P, n, n, n, n, h);
      }
      function UA(u, h) {
        var b;
        if (typeof h != "function")
          throw new Qr(a);
        return u = Ze(u), function() {
          return --u > 0 && (b = h.apply(this, arguments)), u <= 1 && (h = n), b;
        };
      }
      var Ev = nt(function(u, h, b) {
        var T = v;
        if (b.length) {
          var M = aa(b, yl(Ev));
          T |= _;
        }
        return ho(u, T, h, b, M);
      }), HA = nt(function(u, h, b) {
        var T = v | x;
        if (b.length) {
          var M = aa(b, yl(HA));
          T |= _;
        }
        return ho(h, T, u, b, M);
      });
      function KA(u, h, b) {
        h = b ? n : h;
        var T = ho(u, S, n, n, n, n, n, h);
        return T.placeholder = KA.placeholder, T;
      }
      function GA(u, h, b) {
        h = b ? n : h;
        var T = ho(u, A, n, n, n, n, n, h);
        return T.placeholder = GA.placeholder, T;
      }
      function YA(u, h, b) {
        var T, M, B, G, q, J, he = 0, me = !1, ye = !1, xe = !0;
        if (typeof u != "function")
          throw new Qr(a);
        h = ii(h) || 0, Jt(b) && (me = !!b.leading, ye = "maxWait" in b, B = ye ? bn(ii(b.maxWait) || 0, h) : B, xe = "trailing" in b ? !!b.trailing : xe);
        function Ce(sn) {
          var xi = T, vo = M;
          return T = M = n, he = sn, G = u.apply(vo, xi), G;
        }
        function Re(sn) {
          return he = sn, q = yu(ot, h), me ? Ce(sn) : G;
        }
        function et(sn) {
          var xi = sn - J, vo = sn - he, hT = h - xi;
          return ye ? Zn(hT, B - vo) : hT;
        }
        function je(sn) {
          var xi = sn - J, vo = sn - he;
          return J === n || xi >= h || xi < 0 || ye && vo >= B;
        }
        function ot() {
          var sn = xh();
          if (je(sn))
            return ft(sn);
          q = yu(ot, et(sn));
        }
        function ft(sn) {
          return q = n, xe && T ? Ce(sn) : (T = M = n, G);
        }
        function Nr() {
          q !== n && iA(q), he = 0, T = J = M = q = n;
        }
        function sr() {
          return q === n ? G : ft(xh());
        }
        function $r() {
          var sn = xh(), xi = je(sn);
          if (T = arguments, M = this, J = sn, xi) {
            if (q === n)
              return Re(J);
            if (ye)
              return iA(q), q = yu(ot, h), Ce(J);
          }
          return q === n && (q = yu(ot, h)), G;
        }
        return $r.cancel = Nr, $r.flush = sr, $r;
      }
      var OU = nt(function(u, h) {
        return jO(u, 1, h);
      }), AU = nt(function(u, h, b) {
        return jO(u, ii(h) || 0, b);
      });
      function TU(u) {
        return ho(u, k);
      }
      function wh(u, h) {
        if (typeof u != "function" || h != null && typeof h != "function")
          throw new Qr(a);
        var b = function() {
          var T = arguments, M = h ? h.apply(this, T) : T[0], B = b.cache;
          if (B.has(M))
            return B.get(M);
          var G = u.apply(this, T);
          return b.cache = B.set(M, G) || B, G;
        };
        return b.cache = new (wh.Cache || uo)(), b;
      }
      wh.Cache = uo;
      function _h(u) {
        if (typeof u != "function")
          throw new Qr(a);
        return function() {
          var h = arguments;
          switch (h.length) {
            case 0:
              return !u.call(this);
            case 1:
              return !u.call(this, h[0]);
            case 2:
              return !u.call(this, h[0], h[1]);
            case 3:
              return !u.call(this, h[0], h[1], h[2]);
          }
          return !u.apply(this, h);
        };
      }
      function PU(u) {
        return UA(2, u);
      }
      var CU = pV(function(u, h) {
        h = h.length == 1 && Ye(h[0]) ? Gt(h[0], Er(De())) : Gt(Bn(h, 1), Er(De()));
        var b = h.length;
        return nt(function(T) {
          for (var M = -1, B = Zn(T.length, b); ++M < B; )
            T[M] = h[M].call(this, T[M]);
          return Cr(u, this, T);
        });
      }), kv = nt(function(u, h) {
        var b = aa(h, yl(kv));
        return ho(u, _, n, h, b);
      }), qA = nt(function(u, h) {
        var b = aa(h, yl(qA));
        return ho(u, O, n, h, b);
      }), EU = po(function(u, h) {
        return ho(u, C, n, n, n, h);
      });
      function kU(u, h) {
        if (typeof u != "function")
          throw new Qr(a);
        return h = h === n ? h : Ze(h), nt(u, h);
      }
      function MU(u, h) {
        if (typeof u != "function")
          throw new Qr(a);
        return h = h == null ? 0 : bn(Ze(h), 0), nt(function(b) {
          var T = b[h], M = fa(b, 0, h);
          return T && oa(M, T), Cr(u, this, M);
        });
      }
      function NU(u, h, b) {
        var T = !0, M = !0;
        if (typeof u != "function")
          throw new Qr(a);
        return Jt(b) && (T = "leading" in b ? !!b.leading : T, M = "trailing" in b ? !!b.trailing : M), YA(u, h, {
          leading: T,
          maxWait: h,
          trailing: M
        });
      }
      function $U(u) {
        return VA(u, 1);
      }
      function DU(u, h) {
        return kv(pv(h), u);
      }
      function IU() {
        if (!arguments.length)
          return [];
        var u = arguments[0];
        return Ye(u) ? u : [u];
      }
      function RU(u) {
        return ti(u, m);
      }
      function jU(u, h) {
        return h = typeof h == "function" ? h : n, ti(u, m, h);
      }
      function LU(u) {
        return ti(u, d | m);
      }
      function BU(u, h) {
        return h = typeof h == "function" ? h : n, ti(u, d | m, h);
      }
      function FU(u, h) {
        return h == null || RO(u, h, En(h));
      }
      function bi(u, h) {
        return u === h || u !== u && h !== h;
      }
      var WU = ph(nv), zU = ph(function(u, h) {
        return u >= h;
      }), os = zO(/* @__PURE__ */ function() {
        return arguments;
      }()) ? zO : function(u) {
        return tn(u) && Ot.call(u, "callee") && !CO.call(u, "callee");
      }, Ye = ie.isArray, VU = cO ? Er(cO) : Z3;
      function yr(u) {
        return u != null && Sh(u.length) && !go(u);
      }
      function an(u) {
        return tn(u) && yr(u);
      }
      function UU(u) {
        return u === !0 || u === !1 || tn(u) && or(u) == ae;
      }
      var da = i3 || Wv, HU = uO ? Er(uO) : J3;
      function KU(u) {
        return tn(u) && u.nodeType === 1 && !vu(u);
      }
      function GU(u) {
        if (u == null)
          return !0;
        if (yr(u) && (Ye(u) || typeof u == "string" || typeof u.splice == "function" || da(u) || vl(u) || os(u)))
          return !u.length;
        var h = Jn(u);
        if (h == de || h == Oe)
          return !u.size;
        if (gu(u))
          return !ov(u).length;
        for (var b in u)
          if (Ot.call(u, b))
            return !1;
        return !0;
      }
      function YU(u, h) {
        return hu(u, h);
      }
      function qU(u, h, b) {
        b = typeof b == "function" ? b : n;
        var T = b ? b(u, h) : n;
        return T === n ? hu(u, h, n, b) : !!T;
      }
      function Mv(u) {
        if (!tn(u))
          return !1;
        var h = or(u);
        return h == ge || h == se || typeof u.message == "string" && typeof u.name == "string" && !vu(u);
      }
      function XU(u) {
        return typeof u == "number" && kO(u);
      }
      function go(u) {
        if (!Jt(u))
          return !1;
        var h = or(u);
        return h == X || h == $e || h == fe || h == Ie;
      }
      function XA(u) {
        return typeof u == "number" && u == Ze(u);
      }
      function Sh(u) {
        return typeof u == "number" && u > -1 && u % 1 == 0 && u <= H;
      }
      function Jt(u) {
        var h = typeof u;
        return u != null && (h == "object" || h == "function");
      }
      function tn(u) {
        return u != null && typeof u == "object";
      }
      var ZA = fO ? Er(fO) : eV;
      function ZU(u, h) {
        return u === h || iv(u, h, wv(h));
      }
      function JU(u, h, b) {
        return b = typeof b == "function" ? b : n, iv(u, h, wv(h), b);
      }
      function QU(u) {
        return JA(u) && u != +u;
      }
      function e6(u) {
        if (jV(u))
          throw new He(o);
        return VO(u);
      }
      function t6(u) {
        return u === null;
      }
      function n6(u) {
        return u == null;
      }
      function JA(u) {
        return typeof u == "number" || tn(u) && or(u) == ke;
      }
      function vu(u) {
        if (!tn(u) || or(u) != lt)
          return !1;
        var h = Xd(u);
        if (h === null)
          return !0;
        var b = Ot.call(h, "constructor") && h.constructor;
        return typeof b == "function" && b instanceof b && Kd.call(b) == J5;
      }
      var Nv = dO ? Er(dO) : tV;
      function r6(u) {
        return XA(u) && u >= -H && u <= H;
      }
      var QA = hO ? Er(hO) : nV;
      function Oh(u) {
        return typeof u == "string" || !Ye(u) && tn(u) && or(u) == Ge;
      }
      function Mr(u) {
        return typeof u == "symbol" || tn(u) && or(u) == Zt;
      }
      var vl = pO ? Er(pO) : rV;
      function i6(u) {
        return u === n;
      }
      function o6(u) {
        return tn(u) && Jn(u) == en;
      }
      function a6(u) {
        return tn(u) && or(u) == Yr;
      }
      var s6 = ph(av), l6 = ph(function(u, h) {
        return u <= h;
      });
      function eT(u) {
        if (!u)
          return [];
        if (yr(u))
          return Oh(u) ? yi(u) : gr(u);
        if (ou && u[ou])
          return F5(u[ou]());
        var h = Jn(u), b = h == de ? Gy : h == Oe ? Vd : bl;
        return b(u);
      }
      function yo(u) {
        if (!u)
          return u === 0 ? u : 0;
        if (u = ii(u), u === z || u === -z) {
          var h = u < 0 ? -1 : 1;
          return h * U;
        }
        return u === u ? u : 0;
      }
      function Ze(u) {
        var h = yo(u), b = h % 1;
        return h === h ? b ? h - b : h : 0;
      }
      function tT(u) {
        return u ? ts(Ze(u), 0, Y) : 0;
      }
      function ii(u) {
        if (typeof u == "number")
          return u;
        if (Mr(u))
          return V;
        if (Jt(u)) {
          var h = typeof u.valueOf == "function" ? u.valueOf() : u;
          u = Jt(h) ? h + "" : h;
        }
        if (typeof u != "string")
          return u === 0 ? u : +u;
        u = xO(u);
        var b = Vz.test(u);
        return b || Hz.test(u) ? S5(u.slice(2), b ? 2 : 8) : zz.test(u) ? V : +u;
      }
      function nT(u) {
        return ji(u, vr(u));
      }
      function c6(u) {
        return u ? ts(Ze(u), -H, H) : u === 0 ? u : 0;
      }
      function vt(u) {
        return u == null ? "" : kr(u);
      }
      var u6 = ml(function(u, h) {
        if (gu(h) || yr(h)) {
          ji(h, En(h), u);
          return;
        }
        for (var b in h)
          Ot.call(h, b) && uu(u, b, h[b]);
      }), rT = ml(function(u, h) {
        ji(h, vr(h), u);
      }), Ah = ml(function(u, h, b, T) {
        ji(h, vr(h), u, T);
      }), f6 = ml(function(u, h, b, T) {
        ji(h, En(h), u, T);
      }), d6 = po(Qy);
      function h6(u, h) {
        var b = pl(u);
        return h == null ? b : IO(b, h);
      }
      var p6 = nt(function(u, h) {
        u = Mt(u);
        var b = -1, T = h.length, M = T > 2 ? h[2] : n;
        for (M && ar(h[0], h[1], M) && (T = 1); ++b < T; )
          for (var B = h[b], G = vr(B), q = -1, J = G.length; ++q < J; ) {
            var he = G[q], me = u[he];
            (me === n || bi(me, fl[he]) && !Ot.call(u, he)) && (u[he] = B[he]);
          }
        return u;
      }), m6 = nt(function(u) {
        return u.push(n, xA), Cr(iT, n, u);
      });
      function g6(u, h) {
        return gO(u, De(h, 3), Ri);
      }
      function y6(u, h) {
        return gO(u, De(h, 3), tv);
      }
      function v6(u, h) {
        return u == null ? u : ev(u, De(h, 3), vr);
      }
      function b6(u, h) {
        return u == null ? u : FO(u, De(h, 3), vr);
      }
      function x6(u, h) {
        return u && Ri(u, De(h, 3));
      }
      function w6(u, h) {
        return u && tv(u, De(h, 3));
      }
      function _6(u) {
        return u == null ? [] : ah(u, En(u));
      }
      function S6(u) {
        return u == null ? [] : ah(u, vr(u));
      }
      function $v(u, h, b) {
        var T = u == null ? n : ns(u, h);
        return T === n ? b : T;
      }
      function O6(u, h) {
        return u != null && SA(u, h, G3);
      }
      function Dv(u, h) {
        return u != null && SA(u, h, Y3);
      }
      var A6 = mA(function(u, h, b) {
        h != null && typeof h.toString != "function" && (h = Gd.call(h)), u[h] = b;
      }, Rv(br)), T6 = mA(function(u, h, b) {
        h != null && typeof h.toString != "function" && (h = Gd.call(h)), Ot.call(u, h) ? u[h].push(b) : u[h] = [b];
      }, De), P6 = nt(du);
      function En(u) {
        return yr(u) ? $O(u) : ov(u);
      }
      function vr(u) {
        return yr(u) ? $O(u, !0) : iV(u);
      }
      function C6(u, h) {
        var b = {};
        return h = De(h, 3), Ri(u, function(T, M, B) {
          fo(b, h(T, M, B), T);
        }), b;
      }
      function E6(u, h) {
        var b = {};
        return h = De(h, 3), Ri(u, function(T, M, B) {
          fo(b, M, h(T, M, B));
        }), b;
      }
      var k6 = ml(function(u, h, b) {
        sh(u, h, b);
      }), iT = ml(function(u, h, b, T) {
        sh(u, h, b, T);
      }), M6 = po(function(u, h) {
        var b = {};
        if (u == null)
          return b;
        var T = !1;
        h = Gt(h, function(B) {
          return B = ua(B, u), T || (T = B.length > 1), B;
        }), ji(u, bv(u), b), T && (b = ti(b, d | p | m, AV));
        for (var M = h.length; M--; )
          fv(b, h[M]);
        return b;
      });
      function N6(u, h) {
        return oT(u, _h(De(h)));
      }
      var $6 = po(function(u, h) {
        return u == null ? {} : aV(u, h);
      });
      function oT(u, h) {
        if (u == null)
          return {};
        var b = Gt(bv(u), function(T) {
          return [T];
        });
        return h = De(h), XO(u, b, function(T, M) {
          return h(T, M[0]);
        });
      }
      function D6(u, h, b) {
        h = ua(h, u);
        var T = -1, M = h.length;
        for (M || (M = 1, u = n); ++T < M; ) {
          var B = u == null ? n : u[Li(h[T])];
          B === n && (T = M, B = b), u = go(B) ? B.call(u) : B;
        }
        return u;
      }
      function I6(u, h, b) {
        return u == null ? u : pu(u, h, b);
      }
      function R6(u, h, b, T) {
        return T = typeof T == "function" ? T : n, u == null ? u : pu(u, h, b, T);
      }
      var aT = vA(En), sT = vA(vr);
      function j6(u, h, b) {
        var T = Ye(u), M = T || da(u) || vl(u);
        if (h = De(h, 4), b == null) {
          var B = u && u.constructor;
          M ? b = T ? new B() : [] : Jt(u) ? b = go(B) ? pl(Xd(u)) : {} : b = {};
        }
        return (M ? Jr : Ri)(u, function(G, q, J) {
          return h(b, G, q, J);
        }), b;
      }
      function L6(u, h) {
        return u == null ? !0 : fv(u, h);
      }
      function B6(u, h, b) {
        return u == null ? u : tA(u, h, pv(b));
      }
      function F6(u, h, b, T) {
        return T = typeof T == "function" ? T : n, u == null ? u : tA(u, h, pv(b), T);
      }
      function bl(u) {
        return u == null ? [] : Ky(u, En(u));
      }
      function W6(u) {
        return u == null ? [] : Ky(u, vr(u));
      }
      function z6(u, h, b) {
        return b === n && (b = h, h = n), b !== n && (b = ii(b), b = b === b ? b : 0), h !== n && (h = ii(h), h = h === h ? h : 0), ts(ii(u), h, b);
      }
      function V6(u, h, b) {
        return h = yo(h), b === n ? (b = h, h = 0) : b = yo(b), u = ii(u), q3(u, h, b);
      }
      function U6(u, h, b) {
        if (b && typeof b != "boolean" && ar(u, h, b) && (h = b = n), b === n && (typeof h == "boolean" ? (b = h, h = n) : typeof u == "boolean" && (b = u, u = n)), u === n && h === n ? (u = 0, h = 1) : (u = yo(u), h === n ? (h = u, u = 0) : h = yo(h)), u > h) {
          var T = u;
          u = h, h = T;
        }
        if (b || u % 1 || h % 1) {
          var M = MO();
          return Zn(u + M * (h - u + _5("1e-" + ((M + "").length - 1))), h);
        }
        return lv(u, h);
      }
      var H6 = gl(function(u, h, b) {
        return h = h.toLowerCase(), u + (b ? lT(h) : h);
      });
      function lT(u) {
        return Iv(vt(u).toLowerCase());
      }
      function cT(u) {
        return u = vt(u), u && u.replace(Gz, I5).replace(d5, "");
      }
      function K6(u, h, b) {
        u = vt(u), h = kr(h);
        var T = u.length;
        b = b === n ? T : ts(Ze(b), 0, T);
        var M = b;
        return b -= h.length, b >= 0 && u.slice(b, M) == h;
      }
      function G6(u) {
        return u = vt(u), u && nu.test(u) ? u.replace(jd, R5) : u;
      }
      function Y6(u) {
        return u = vt(u), u && $z.test(u) ? u.replace(ky, "\\$&") : u;
      }
      var q6 = gl(function(u, h, b) {
        return u + (b ? "-" : "") + h.toLowerCase();
      }), X6 = gl(function(u, h, b) {
        return u + (b ? " " : "") + h.toLowerCase();
      }), Z6 = dA("toLowerCase");
      function J6(u, h, b) {
        u = vt(u), h = Ze(h);
        var T = h ? cl(u) : 0;
        if (!h || T >= h)
          return u;
        var M = (h - T) / 2;
        return hh(eh(M), b) + u + hh(Qd(M), b);
      }
      function Q6(u, h, b) {
        u = vt(u), h = Ze(h);
        var T = h ? cl(u) : 0;
        return h && T < h ? u + hh(h - T, b) : u;
      }
      function e8(u, h, b) {
        u = vt(u), h = Ze(h);
        var T = h ? cl(u) : 0;
        return h && T < h ? hh(h - T, b) + u : u;
      }
      function t8(u, h, b) {
        return b || h == null ? h = 0 : h && (h = +h), l3(vt(u).replace(My, ""), h || 0);
      }
      function n8(u, h, b) {
        return (b ? ar(u, h, b) : h === n) ? h = 1 : h = Ze(h), cv(vt(u), h);
      }
      function r8() {
        var u = arguments, h = vt(u[0]);
        return u.length < 3 ? h : h.replace(u[1], u[2]);
      }
      var i8 = gl(function(u, h, b) {
        return u + (b ? "_" : "") + h.toLowerCase();
      });
      function o8(u, h, b) {
        return b && typeof b != "number" && ar(u, h, b) && (h = b = n), b = b === n ? Y : b >>> 0, b ? (u = vt(u), u && (typeof h == "string" || h != null && !Nv(h)) && (h = kr(h), !h && ll(u)) ? fa(yi(u), 0, b) : u.split(h, b)) : [];
      }
      var a8 = gl(function(u, h, b) {
        return u + (b ? " " : "") + Iv(h);
      });
      function s8(u, h, b) {
        return u = vt(u), b = b == null ? 0 : ts(Ze(b), 0, u.length), h = kr(h), u.slice(b, b + h.length) == h;
      }
      function l8(u, h, b) {
        var T = L.templateSettings;
        b && ar(u, h, b) && (h = n), u = vt(u), h = Ah({}, h, T, bA);
        var M = Ah({}, h.imports, T.imports, bA), B = En(M), G = Ky(M, B), q, J, he = 0, me = h.interpolate || Ld, ye = "__p += '", xe = Yy(
          (h.escape || Ld).source + "|" + me.source + "|" + (me === WS ? Wz : Ld).source + "|" + (h.evaluate || Ld).source + "|$",
          "g"
        ), Ce = "//# sourceURL=" + (Ot.call(h, "sourceURL") ? (h.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++y5 + "]") + `
`;
        u.replace(xe, function(je, ot, ft, Nr, sr, $r) {
          return ft || (ft = Nr), ye += u.slice(he, $r).replace(Yz, j5), ot && (q = !0, ye += `' +
__e(` + ot + `) +
'`), sr && (J = !0, ye += `';
` + sr + `;
__p += '`), ft && (ye += `' +
((__t = (` + ft + `)) == null ? '' : __t) +
'`), he = $r + je.length, je;
        }), ye += `';
`;
        var Re = Ot.call(h, "variable") && h.variable;
        if (!Re)
          ye = `with (obj) {
` + ye + `
}
`;
        else if (Bz.test(Re))
          throw new He(s);
        ye = (J ? ye.replace(fn, "") : ye).replace(Xr, "$1").replace(yt, "$1;"), ye = "function(" + (Re || "obj") + `) {
` + (Re ? "" : `obj || (obj = {});
`) + "var __t, __p = ''" + (q ? ", __e = _.escape" : "") + (J ? `, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
` : `;
`) + ye + `return __p
}`;
        var et = fT(function() {
          return gt(B, Ce + "return " + ye).apply(n, G);
        });
        if (et.source = ye, Mv(et))
          throw et;
        return et;
      }
      function c8(u) {
        return vt(u).toLowerCase();
      }
      function u8(u) {
        return vt(u).toUpperCase();
      }
      function f8(u, h, b) {
        if (u = vt(u), u && (b || h === n))
          return xO(u);
        if (!u || !(h = kr(h)))
          return u;
        var T = yi(u), M = yi(h), B = wO(T, M), G = _O(T, M) + 1;
        return fa(T, B, G).join("");
      }
      function d8(u, h, b) {
        if (u = vt(u), u && (b || h === n))
          return u.slice(0, OO(u) + 1);
        if (!u || !(h = kr(h)))
          return u;
        var T = yi(u), M = _O(T, yi(h)) + 1;
        return fa(T, 0, M).join("");
      }
      function h8(u, h, b) {
        if (u = vt(u), u && (b || h === n))
          return u.replace(My, "");
        if (!u || !(h = kr(h)))
          return u;
        var T = yi(u), M = wO(T, yi(h));
        return fa(T, M).join("");
      }
      function p8(u, h) {
        var b = I, T = $;
        if (Jt(h)) {
          var M = "separator" in h ? h.separator : M;
          b = "length" in h ? Ze(h.length) : b, T = "omission" in h ? kr(h.omission) : T;
        }
        u = vt(u);
        var B = u.length;
        if (ll(u)) {
          var G = yi(u);
          B = G.length;
        }
        if (b >= B)
          return u;
        var q = b - cl(T);
        if (q < 1)
          return T;
        var J = G ? fa(G, 0, q).join("") : u.slice(0, q);
        if (M === n)
          return J + T;
        if (G && (q += J.length - q), Nv(M)) {
          if (u.slice(q).search(M)) {
            var he, me = J;
            for (M.global || (M = Yy(M.source, vt(zS.exec(M)) + "g")), M.lastIndex = 0; he = M.exec(me); )
              var ye = he.index;
            J = J.slice(0, ye === n ? q : ye);
          }
        } else if (u.indexOf(kr(M), q) != q) {
          var xe = J.lastIndexOf(M);
          xe > -1 && (J = J.slice(0, xe));
        }
        return J + T;
      }
      function m8(u) {
        return u = vt(u), u && Ey.test(u) ? u.replace(Rd, U5) : u;
      }
      var g8 = gl(function(u, h, b) {
        return u + (b ? " " : "") + h.toUpperCase();
      }), Iv = dA("toUpperCase");
      function uT(u, h, b) {
        return u = vt(u), h = b ? n : h, h === n ? B5(u) ? G5(u) : k5(u) : u.match(h) || [];
      }
      var fT = nt(function(u, h) {
        try {
          return Cr(u, n, h);
        } catch (b) {
          return Mv(b) ? b : new He(b);
        }
      }), y8 = po(function(u, h) {
        return Jr(h, function(b) {
          b = Li(b), fo(u, b, Ev(u[b], u));
        }), u;
      });
      function v8(u) {
        var h = u == null ? 0 : u.length, b = De();
        return u = h ? Gt(u, function(T) {
          if (typeof T[1] != "function")
            throw new Qr(a);
          return [b(T[0]), T[1]];
        }) : [], nt(function(T) {
          for (var M = -1; ++M < h; ) {
            var B = u[M];
            if (Cr(B[0], this, T))
              return Cr(B[1], this, T);
          }
        });
      }
      function b8(u) {
        return U3(ti(u, d));
      }
      function Rv(u) {
        return function() {
          return u;
        };
      }
      function x8(u, h) {
        return u == null || u !== u ? h : u;
      }
      var w8 = pA(), _8 = pA(!0);
      function br(u) {
        return u;
      }
      function jv(u) {
        return UO(typeof u == "function" ? u : ti(u, d));
      }
      function S8(u) {
        return KO(ti(u, d));
      }
      function O8(u, h) {
        return GO(u, ti(h, d));
      }
      var A8 = nt(function(u, h) {
        return function(b) {
          return du(b, u, h);
        };
      }), T8 = nt(function(u, h) {
        return function(b) {
          return du(u, b, h);
        };
      });
      function Lv(u, h, b) {
        var T = En(h), M = ah(h, T);
        b == null && !(Jt(h) && (M.length || !T.length)) && (b = h, h = u, u = this, M = ah(h, En(h)));
        var B = !(Jt(b) && "chain" in b) || !!b.chain, G = go(u);
        return Jr(M, function(q) {
          var J = h[q];
          u[q] = J, G && (u.prototype[q] = function() {
            var he = this.__chain__;
            if (B || he) {
              var me = u(this.__wrapped__), ye = me.__actions__ = gr(this.__actions__);
              return ye.push({ func: J, args: arguments, thisArg: u }), me.__chain__ = he, me;
            }
            return J.apply(u, oa([this.value()], arguments));
          });
        }), u;
      }
      function P8() {
        return Ln._ === this && (Ln._ = Q5), this;
      }
      function Bv() {
      }
      function C8(u) {
        return u = Ze(u), nt(function(h) {
          return YO(h, u);
        });
      }
      var E8 = gv(Gt), k8 = gv(mO), M8 = gv(Wy);
      function dT(u) {
        return Sv(u) ? zy(Li(u)) : sV(u);
      }
      function N8(u) {
        return function(h) {
          return u == null ? n : ns(u, h);
        };
      }
      var $8 = gA(), D8 = gA(!0);
      function Fv() {
        return [];
      }
      function Wv() {
        return !1;
      }
      function I8() {
        return {};
      }
      function R8() {
        return "";
      }
      function j8() {
        return !0;
      }
      function L8(u, h) {
        if (u = Ze(u), u < 1 || u > H)
          return [];
        var b = Y, T = Zn(u, Y);
        h = De(h), u -= Y;
        for (var M = Hy(T, h); ++b < u; )
          h(b);
        return M;
      }
      function B8(u) {
        return Ye(u) ? Gt(u, Li) : Mr(u) ? [u] : gr(NA(vt(u)));
      }
      function F8(u) {
        var h = ++Z5;
        return vt(u) + h;
      }
      var W8 = dh(function(u, h) {
        return u + h;
      }, 0), z8 = yv("ceil"), V8 = dh(function(u, h) {
        return u / h;
      }, 1), U8 = yv("floor");
      function H8(u) {
        return u && u.length ? oh(u, br, nv) : n;
      }
      function K8(u, h) {
        return u && u.length ? oh(u, De(h, 2), nv) : n;
      }
      function G8(u) {
        return vO(u, br);
      }
      function Y8(u, h) {
        return vO(u, De(h, 2));
      }
      function q8(u) {
        return u && u.length ? oh(u, br, av) : n;
      }
      function X8(u, h) {
        return u && u.length ? oh(u, De(h, 2), av) : n;
      }
      var Z8 = dh(function(u, h) {
        return u * h;
      }, 1), J8 = yv("round"), Q8 = dh(function(u, h) {
        return u - h;
      }, 0);
      function eH(u) {
        return u && u.length ? Uy(u, br) : 0;
      }
      function tH(u, h) {
        return u && u.length ? Uy(u, De(h, 2)) : 0;
      }
      return L.after = SU, L.ary = VA, L.assign = u6, L.assignIn = rT, L.assignInWith = Ah, L.assignWith = f6, L.at = d6, L.before = UA, L.bind = Ev, L.bindAll = y8, L.bindKey = HA, L.castArray = IU, L.chain = FA, L.chunk = UV, L.compact = HV, L.concat = KV, L.cond = v8, L.conforms = b8, L.constant = Rv, L.countBy = eU, L.create = h6, L.curry = KA, L.curryRight = GA, L.debounce = YA, L.defaults = p6, L.defaultsDeep = m6, L.defer = OU, L.delay = AU, L.difference = GV, L.differenceBy = YV, L.differenceWith = qV, L.drop = XV, L.dropRight = ZV, L.dropRightWhile = JV, L.dropWhile = QV, L.fill = e4, L.filter = nU, L.flatMap = oU, L.flatMapDeep = aU, L.flatMapDepth = sU, L.flatten = RA, L.flattenDeep = t4, L.flattenDepth = n4, L.flip = TU, L.flow = w8, L.flowRight = _8, L.fromPairs = r4, L.functions = _6, L.functionsIn = S6, L.groupBy = lU, L.initial = o4, L.intersection = a4, L.intersectionBy = s4, L.intersectionWith = l4, L.invert = A6, L.invertBy = T6, L.invokeMap = uU, L.iteratee = jv, L.keyBy = fU, L.keys = En, L.keysIn = vr, L.map = bh, L.mapKeys = C6, L.mapValues = E6, L.matches = S8, L.matchesProperty = O8, L.memoize = wh, L.merge = k6, L.mergeWith = iT, L.method = A8, L.methodOf = T8, L.mixin = Lv, L.negate = _h, L.nthArg = C8, L.omit = M6, L.omitBy = N6, L.once = PU, L.orderBy = dU, L.over = E8, L.overArgs = CU, L.overEvery = k8, L.overSome = M8, L.partial = kv, L.partialRight = qA, L.partition = hU, L.pick = $6, L.pickBy = oT, L.property = dT, L.propertyOf = N8, L.pull = d4, L.pullAll = LA, L.pullAllBy = h4, L.pullAllWith = p4, L.pullAt = m4, L.range = $8, L.rangeRight = D8, L.rearg = EU, L.reject = gU, L.remove = g4, L.rest = kU, L.reverse = Pv, L.sampleSize = vU, L.set = I6, L.setWith = R6, L.shuffle = bU, L.slice = y4, L.sortBy = _U, L.sortedUniq = O4, L.sortedUniqBy = A4, L.split = o8, L.spread = MU, L.tail = T4, L.take = P4, L.takeRight = C4, L.takeRightWhile = E4, L.takeWhile = k4, L.tap = H4, L.throttle = NU, L.thru = vh, L.toArray = eT, L.toPairs = aT, L.toPairsIn = sT, L.toPath = B8, L.toPlainObject = nT, L.transform = j6, L.unary = $U, L.union = M4, L.unionBy = N4, L.unionWith = $4, L.uniq = D4, L.uniqBy = I4, L.uniqWith = R4, L.unset = L6, L.unzip = Cv, L.unzipWith = BA, L.update = B6, L.updateWith = F6, L.values = bl, L.valuesIn = W6, L.without = j4, L.words = uT, L.wrap = DU, L.xor = L4, L.xorBy = B4, L.xorWith = F4, L.zip = W4, L.zipObject = z4, L.zipObjectDeep = V4, L.zipWith = U4, L.entries = aT, L.entriesIn = sT, L.extend = rT, L.extendWith = Ah, Lv(L, L), L.add = W8, L.attempt = fT, L.camelCase = H6, L.capitalize = lT, L.ceil = z8, L.clamp = z6, L.clone = RU, L.cloneDeep = LU, L.cloneDeepWith = BU, L.cloneWith = jU, L.conformsTo = FU, L.deburr = cT, L.defaultTo = x8, L.divide = V8, L.endsWith = K6, L.eq = bi, L.escape = G6, L.escapeRegExp = Y6, L.every = tU, L.find = rU, L.findIndex = DA, L.findKey = g6, L.findLast = iU, L.findLastIndex = IA, L.findLastKey = y6, L.floor = U8, L.forEach = WA, L.forEachRight = zA, L.forIn = v6, L.forInRight = b6, L.forOwn = x6, L.forOwnRight = w6, L.get = $v, L.gt = WU, L.gte = zU, L.has = O6, L.hasIn = Dv, L.head = jA, L.identity = br, L.includes = cU, L.indexOf = i4, L.inRange = V6, L.invoke = P6, L.isArguments = os, L.isArray = Ye, L.isArrayBuffer = VU, L.isArrayLike = yr, L.isArrayLikeObject = an, L.isBoolean = UU, L.isBuffer = da, L.isDate = HU, L.isElement = KU, L.isEmpty = GU, L.isEqual = YU, L.isEqualWith = qU, L.isError = Mv, L.isFinite = XU, L.isFunction = go, L.isInteger = XA, L.isLength = Sh, L.isMap = ZA, L.isMatch = ZU, L.isMatchWith = JU, L.isNaN = QU, L.isNative = e6, L.isNil = n6, L.isNull = t6, L.isNumber = JA, L.isObject = Jt, L.isObjectLike = tn, L.isPlainObject = vu, L.isRegExp = Nv, L.isSafeInteger = r6, L.isSet = QA, L.isString = Oh, L.isSymbol = Mr, L.isTypedArray = vl, L.isUndefined = i6, L.isWeakMap = o6, L.isWeakSet = a6, L.join = c4, L.kebabCase = q6, L.last = ri, L.lastIndexOf = u4, L.lowerCase = X6, L.lowerFirst = Z6, L.lt = s6, L.lte = l6, L.max = H8, L.maxBy = K8, L.mean = G8, L.meanBy = Y8, L.min = q8, L.minBy = X8, L.stubArray = Fv, L.stubFalse = Wv, L.stubObject = I8, L.stubString = R8, L.stubTrue = j8, L.multiply = Z8, L.nth = f4, L.noConflict = P8, L.noop = Bv, L.now = xh, L.pad = J6, L.padEnd = Q6, L.padStart = e8, L.parseInt = t8, L.random = U6, L.reduce = pU, L.reduceRight = mU, L.repeat = n8, L.replace = r8, L.result = D6, L.round = J8, L.runInContext = Z, L.sample = yU, L.size = xU, L.snakeCase = i8, L.some = wU, L.sortedIndex = v4, L.sortedIndexBy = b4, L.sortedIndexOf = x4, L.sortedLastIndex = w4, L.sortedLastIndexBy = _4, L.sortedLastIndexOf = S4, L.startCase = a8, L.startsWith = s8, L.subtract = Q8, L.sum = eH, L.sumBy = tH, L.template = l8, L.times = L8, L.toFinite = yo, L.toInteger = Ze, L.toLength = tT, L.toLower = c8, L.toNumber = ii, L.toSafeInteger = c6, L.toString = vt, L.toUpper = u8, L.trim = f8, L.trimEnd = d8, L.trimStart = h8, L.truncate = p8, L.unescape = m8, L.uniqueId = F8, L.upperCase = g8, L.upperFirst = Iv, L.each = WA, L.eachRight = zA, L.first = jA, Lv(L, function() {
        var u = {};
        return Ri(L, function(h, b) {
          Ot.call(L.prototype, b) || (u[b] = h);
        }), u;
      }(), { chain: !1 }), L.VERSION = r, Jr(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(u) {
        L[u].placeholder = L;
      }), Jr(["drop", "take"], function(u, h) {
        ut.prototype[u] = function(b) {
          b = b === n ? 1 : bn(Ze(b), 0);
          var T = this.__filtered__ && !h ? new ut(this) : this.clone();
          return T.__filtered__ ? T.__takeCount__ = Zn(b, T.__takeCount__) : T.__views__.push({
            size: Zn(b, Y),
            type: u + (T.__dir__ < 0 ? "Right" : "")
          }), T;
        }, ut.prototype[u + "Right"] = function(b) {
          return this.reverse()[u](b).reverse();
        };
      }), Jr(["filter", "map", "takeWhile"], function(u, h) {
        var b = h + 1, T = b == j || b == W;
        ut.prototype[u] = function(M) {
          var B = this.clone();
          return B.__iteratees__.push({
            iteratee: De(M, 3),
            type: b
          }), B.__filtered__ = B.__filtered__ || T, B;
        };
      }), Jr(["head", "last"], function(u, h) {
        var b = "take" + (h ? "Right" : "");
        ut.prototype[u] = function() {
          return this[b](1).value()[0];
        };
      }), Jr(["initial", "tail"], function(u, h) {
        var b = "drop" + (h ? "" : "Right");
        ut.prototype[u] = function() {
          return this.__filtered__ ? new ut(this) : this[b](1);
        };
      }), ut.prototype.compact = function() {
        return this.filter(br);
      }, ut.prototype.find = function(u) {
        return this.filter(u).head();
      }, ut.prototype.findLast = function(u) {
        return this.reverse().find(u);
      }, ut.prototype.invokeMap = nt(function(u, h) {
        return typeof u == "function" ? new ut(this) : this.map(function(b) {
          return du(b, u, h);
        });
      }), ut.prototype.reject = function(u) {
        return this.filter(_h(De(u)));
      }, ut.prototype.slice = function(u, h) {
        u = Ze(u);
        var b = this;
        return b.__filtered__ && (u > 0 || h < 0) ? new ut(b) : (u < 0 ? b = b.takeRight(-u) : u && (b = b.drop(u)), h !== n && (h = Ze(h), b = h < 0 ? b.dropRight(-h) : b.take(h - u)), b);
      }, ut.prototype.takeRightWhile = function(u) {
        return this.reverse().takeWhile(u).reverse();
      }, ut.prototype.toArray = function() {
        return this.take(Y);
      }, Ri(ut.prototype, function(u, h) {
        var b = /^(?:filter|find|map|reject)|While$/.test(h), T = /^(?:head|last)$/.test(h), M = L[T ? "take" + (h == "last" ? "Right" : "") : h], B = T || /^find/.test(h);
        M && (L.prototype[h] = function() {
          var G = this.__wrapped__, q = T ? [1] : arguments, J = G instanceof ut, he = q[0], me = J || Ye(G), ye = function(ot) {
            var ft = M.apply(L, oa([ot], q));
            return T && xe ? ft[0] : ft;
          };
          me && b && typeof he == "function" && he.length != 1 && (J = me = !1);
          var xe = this.__chain__, Ce = !!this.__actions__.length, Re = B && !xe, et = J && !Ce;
          if (!B && me) {
            G = et ? G : new ut(this);
            var je = u.apply(G, q);
            return je.__actions__.push({ func: vh, args: [ye], thisArg: n }), new ei(je, xe);
          }
          return Re && et ? u.apply(this, q) : (je = this.thru(ye), Re ? T ? je.value()[0] : je.value() : je);
        });
      }), Jr(["pop", "push", "shift", "sort", "splice", "unshift"], function(u) {
        var h = Ud[u], b = /^(?:push|sort|unshift)$/.test(u) ? "tap" : "thru", T = /^(?:pop|shift)$/.test(u);
        L.prototype[u] = function() {
          var M = arguments;
          if (T && !this.__chain__) {
            var B = this.value();
            return h.apply(Ye(B) ? B : [], M);
          }
          return this[b](function(G) {
            return h.apply(Ye(G) ? G : [], M);
          });
        };
      }), Ri(ut.prototype, function(u, h) {
        var b = L[h];
        if (b) {
          var T = b.name + "";
          Ot.call(hl, T) || (hl[T] = []), hl[T].push({ name: h, func: b });
        }
      }), hl[fh(n, x).name] = [{
        name: "wrapper",
        func: n
      }], ut.prototype.clone = m3, ut.prototype.reverse = g3, ut.prototype.value = y3, L.prototype.at = K4, L.prototype.chain = G4, L.prototype.commit = Y4, L.prototype.next = q4, L.prototype.plant = Z4, L.prototype.reverse = J4, L.prototype.toJSON = L.prototype.valueOf = L.prototype.value = Q4, L.prototype.first = L.prototype.head, ou && (L.prototype[ou] = X4), L;
    }, ul = Y5();
    Za ? ((Za.exports = ul)._ = ul, jy._ = ul) : Ln._ = ul;
  }).call(_commonjsHelpers_DaMA6jEr_js__WEBPACK_IMPORTED_MODULE_3__.c);
})(Kp, Kp.exports);
var oee = Kp.exports;
const ux = {
  sm: "text-xs [&>svg]:size-4 rounded",
  md: "text-sm [&>svg]:size-5 rounded-md",
  lg: "text-base [&>svg]:size-6 rounded-md"
}, Xi = {
  input: {
    sm: "py-1.5 px-2 rounded",
    md: "p-2.5 rounded-md",
    lg: "p-3 rounded-md"
  },
  content: {
    sm: "p-1.5",
    md: "p-1.5",
    lg: "p-2"
  },
  title: {
    sm: "p-2 text-xs",
    md: "p-2 text-sm",
    lg: "p-2 text-sm"
  },
  item: {
    sm: "text-sm text-text-secondary rounded",
    md: "text-base text-text-secondary rounded-md",
    lg: "text-base text-text-secondary rounded-md"
  },
  icon: {
    sm: "p-1 text-sm [&>svg]:size-4 text-icon-secondary",
    md: "p-2 text-base [&>svg]:size-5 text-icon-secondary",
    lg: "p-2 text-base [&>svg]:size-5 text-icon-secondary"
  },
  dialog: {
    sm: "mt-1 rounded-md",
    md: "mt-1.5 rounded-lg",
    lg: "mt-1.5 rounded-lg"
  },
  slashIcon: {
    sm: "px-2 py-0.5",
    md: "px-3 py-1",
    lg: "px-3.5 py-1"
  }
}, aee = {
  primary: "bg-field-primary-background outline outline-1 outline-field-border hover:outline-border-strong",
  secondary: "bg-field-secondary-background outline outline-1 outline-field-border hover:outline-border-strong",
  ghost: "bg-field-secondary-background outline outline-1 outline-transparent"
}, see = "text-icon-secondary group-hover:text-icon-primary group-focus-within:text-icon-primary", uE = {
  ghost: "cursor-not-allowed text-text-disabled placeholder:text-text-disabled",
  primary: "border-border-disabled hover:border-border-disabled bg-field-background-disabled cursor-not-allowed text-text-disabled placeholder:text-text-disabled",
  secondary: "border-border-disabled hover:border-border-disabled cursor-not-allowed text-text-disabled placeholder:text-text-disabled"
}, Oj = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), Zs = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(Oj), Zo = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    className: e,
    size: t = "sm",
    open: n = !1,
    onOpenChange: r = () => {
    },
    loading: i = !1,
    ...o
  }, a) => {
    const [s, l] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(""), [c, f] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(i ?? !1), { refs: d, floatingStyles: p, context: m } = dg({
      open: n,
      onOpenChange: r,
      placement: "bottom-start",
      whileElementsMounted: ig,
      middleware: [
        og(t === "sm" ? 4 : 6),
        ag({ padding: 10 }),
        SD({
          apply({ rects: x, elements: w, availableHeight: S }) {
            w.floating.style.maxHeight = `${S}px`, w.floating.style.width = `${x.reference.width}px`, w.floating.style.fontFamily = window.getComputedStyle(
              w.reference
            ).fontFamily;
          }
        })
      ]
    }), y = fg(m), { getReferenceProps: g, getFloatingProps: v } = hg([
      y
    ]);
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      const x = FH(), w = (S) => {
        const _ = x === "Mac OS" ? S.metaKey : S.ctrlKey;
        if (S.key === "/" && _ && (S.preventDefault(), d.reference && d.reference.current)) {
          const O = d.reference.current instanceof HTMLElement ? d.reference.current.querySelector("input") : null;
          O && O.focus();
        }
      };
      return window.addEventListener("keydown", w), () => {
        window.removeEventListener("keydown", w);
      };
    }, [d.reference]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      Oj.Provider,
      {
        value: {
          size: t,
          open: n,
          onOpenChange: r,
          refs: d,
          floatingStyles: p,
          context: m,
          getReferenceProps: g,
          getFloatingProps: v,
          searchTerm: s,
          setSearchTerm: l,
          isLoading: c,
          setIsLoading: f
        },
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "div",
          {
            className: K(
              "searchbox-wrapper box-border relative w-full",
              e
            ),
            ...o,
            ref: a
          }
        )
      }
    );
  }
);
Zo.displayName = "SearchBox";
const Aj = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({
    className: e,
    type: t = "text",
    placeholder: n = "Search...",
    variant: r = "primary",
    disabled: i = !1,
    onChange: o = () => {
    },
    ...a
  }, s) => {
    const {
      size: l,
      onOpenChange: c,
      refs: f,
      getReferenceProps: d,
      searchTerm: p,
      setSearchTerm: m
    } = Zs(), y = l === "lg" ? "sm" : "xs", g = (v) => {
      const x = v.target.value;
      m(x), o(x), typeof c == "function" && (x.trim() ? c(!0) : c(!1));
    };
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        ref: f.setReference,
        className: K(
          "w-full group relative flex justify-center items-center gap-1.5 focus-within:z-10 transition-colors ease-in-out duration-150",
          aee[r],
          Xi.input[l],
          i ? uE[r] : "focus-within:ring-2 focus-within:ring-focus focus-within:ring-offset-2 focus-within:border-focus-border focus-within:hover:border-focus-border"
        ),
        ...d,
        children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "span",
            {
              className: K(
                ux[l],
                i ? "text-icon-disabled" : see,
                "flex justify-center items-center"
              ),
              children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(rD, {})
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "input",
            {
              type: t,
              ref: s,
              className: K(
                ux[l],
                "flex-grow font-medium bg-transparent border-none outline-none border-transparent focus:ring-0 py-0",
                i ? uE[r] : [
                  "text-field-placeholder focus-within:text-field-input group-hover:text-field-input",
                  "placeholder:text-field-placeholder"
                ],
                e
              ),
              disabled: i,
              value: p,
              onChange: g,
              placeholder: n,
              ...oee.omit(a, [
                "size",
                "open",
                "onOpenChange",
                "loading"
              ])
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            mg,
            {
              label: "⌘/",
              size: y,
              type: "rounded",
              variant: "neutral"
            }
          )
        ]
      }
    );
  }
);
Aj.displayName = "SearchBox.Input";
const Tj = ({
  className: e,
  dropdownPortalRoot: t = null,
  // Root element where the dropdown will be rendered.
  dropdownPortalId: n = "",
  // Id of the dropdown portal where the dropdown will be rendered.
  children: r,
  ...i
}) => {
  const { size: o, open: a, refs: s, floatingStyles: l, getFloatingProps: c } = Zs();
  return a ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ug, { id: n, root: t, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      ref: s.setFloating,
      style: {
        ...l
      },
      className: K(
        "bg-background-primary rounded-md border border-solid border-border-subtle shadow-soft-shadow-lg overflow-y-auto text-wrap",
        Xi.dialog[o],
        e
      ),
      ...c(),
      ...i,
      children: r
    }
  ) }) : null;
};
Tj.displayName = "SearchBox.Content";
const Pj = ({
  filter: e = !0,
  children: t
}) => {
  const { searchTerm: n, isLoading: r } = Zs();
  if (!e)
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: t });
  const i = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(t).map((o) => {
    if (react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(o) && o.type === O_) {
      const a = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(
        o.props.children
      ).filter(
        (s) => react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(s) && typeof s.props.children == "string" && s.props.children.toLowerCase().includes(n.toLowerCase())
      );
      return a.length > 0 ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(o, {
        children: a
      }) : null;
    }
    return o;
  }).filter(Boolean);
  return r ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(A_, {}) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: i.some(
    (o) => react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(o) && o.type !== T_
  ) ? i : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(S_, {}) });
};
Pj.displayName = "SearchBox.List";
const S_ = ({
  children: e = "No results found."
}) => {
  const { size: t } = Zs();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex justify-center items-center",
        Xi.item[t],
        "text-text-tertiary p-4"
      ),
      children: e
    }
  );
};
S_.displayName = "SearchBox.Empty";
const O_ = ({ heading: e, children: t }) => {
  const { size: n } = Zs();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
    "div",
    {
      className: K(
        Xi.content[n],
        Xi.item[n]
      ),
      children: [
        e && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "div",
          {
            className: K(
              Xi.title[n],
              "text-text-secondary"
            ),
            children: e
          }
        ),
        t
      ]
    }
  );
};
O_.displayName = "SearchBox.Group";
const Cj = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({ className: e, icon: t, children: n, ...r }, i) => {
    const { size: o } = Zs();
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(
      "div",
      {
        ref: i,
        className: K(
          "flex items-center justify-start gap-1 p-1 hover:bg-background-secondary focus:bg-background-secondary cursor-pointer",
          Xi.item[o]
        ),
        ...r,
        children: [
          t && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "span",
            {
              className: K(
                Xi.icon[o],
                "flex items-center justify-center"
              ),
              children: t
            }
          ),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
            "span",
            {
              className: K(
                "flex-grow p-1 font-normal cursor-pointer",
                Xi.item[o],
                e
              ),
              children: n
            }
          )
        ]
      }
    );
  }
);
Cj.displayName = "SearchBox.Item";
const A_ = ({
  loadingIcon: e = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(d1, {})
}) => {
  const { size: t } = Zs(), n = react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(e) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(e, { size: t }) : e;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex justify-center p-4",
        ux[t],
        Xi.item[t]
      ),
      children: n
    }
  );
};
A_.displayName = "SearchBox.Loading";
const T_ = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ className: e, ...t }, n) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "hr",
  {
    ref: n,
    className: K(
      "border-0 border-t border-border-subtle border-solid m-0",
      e
    ),
    ...t
  }
));
T_.displayName = "SearchBox.Separator";
Zo.Input = Aj;
Zo.Loading = A_;
Zo.Separator = T_;
Zo.Content = Tj;
Zo.List = Pj;
Zo.Empty = S_;
Zo.Group = O_;
Zo.Item = Cj;
const Ej = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), kj = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(Ej), Js = ({
  placement: e = "bottom",
  offset: t = 10,
  boundary: n = "clippingAncestors",
  children: r,
  className: i
}) => {
  const [o, a] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), { refs: s, floatingStyles: l, context: c } = dg({
    open: o,
    onOpenChange: a,
    placement: e,
    strategy: "absolute",
    middleware: [
      og(t),
      ag({ boundary: n }),
      _D({ boundary: n })
    ],
    whileElementsMounted: ig
  }), f = c1(c), d = fg(c), p = u1(c, { role: "menu" }), { getReferenceProps: m, getFloatingProps: y } = hg([
    f,
    d,
    p
  ]), { isMounted: g, styles: v } = ND(c, {
    duration: 150,
    initial: { opacity: 0, scale: 0.95 },
    open: { opacity: 1, scale: 1 },
    close: { opacity: 0, scale: 0.95 }
  }), x = () => a((S) => !S), w = () => a(!1);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    Ej.Provider,
    {
      value: {
        refs: s,
        handleClose: w,
        isMounted: g,
        styles: v,
        floatingStyles: l,
        getFloatingProps: y
      },
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: K("relative inline-block", i), children: [
        react__WEBPACK_IMPORTED_MODULE_1__.Children.map(r, (S) => {
          var A;
          return react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(S) && ((A = S == null ? void 0 : S.type) == null ? void 0 : A.displayName) === "DropdownMenu.Trigger" ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(S, {
            ref: s.setReference,
            onClick: x,
            ...m()
          }) : null;
        }),
        react__WEBPACK_IMPORTED_MODULE_1__.Children.map(r, (S) => {
          var A;
          return react__WEBPACK_IMPORTED_MODULE_1__.isValidElement(S) && ((A = S == null ? void 0 : S.type) == null ? void 0 : A.displayName) === "DropdownMenu.Portal" ? S : null;
        })
      ] })
    }
  );
};
Js.displayName = "DropdownMenu";
const Mj = ({
  children: e,
  className: t,
  root: n,
  id: r
}) => {
  const { refs: i, floatingStyles: o, getFloatingProps: a, isMounted: s, styles: l } = kj();
  return s && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ug, { id: r, root: n, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      ref: i.setFloating,
      className: t,
      style: {
        ...o,
        ...l
      },
      ...a(),
      children: react__WEBPACK_IMPORTED_MODULE_1__.Children.map(e, (c) => {
        var f;
        return ((f = c == null ? void 0 : c.type) == null ? void 0 : f.displayName) === "DropdownMenu.Content" ? c : null;
      })
    }
  ) });
};
Mj.displayName = "DropdownMenu.Portal";
const Nj = react__WEBPACK_IMPORTED_MODULE_1__.forwardRef(({ children: e, className: t, ...n }, r) => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e) ? react__WEBPACK_IMPORTED_MODULE_1__.cloneElement(e, {
  className: K(t, e.props.className),
  ref: r,
  ...n
}) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    ref: r,
    className: K("cursor-pointer", t),
    role: "button",
    tabIndex: 0,
    ...n,
    children: e
  }
));
Nj.displayName = "DropdownMenu.Trigger";
const $j = ({
  children: e,
  className: t,
  ...n
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    className: K(
      "border border-solid border-border-subtle rounded-md shadow-lg overflow-hidden",
      t
    ),
    children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ha, { ...n, children: e })
  }
);
$j.displayName = "DropdownMenu.Content";
const Dj = (e) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ha.List, { ...e });
Dj.displayName = "DropdownMenu.List";
const Ij = ({
  children: e,
  as: t = Ha.Item,
  ...n
}) => {
  var i;
  const { handleClose: r } = kj();
  return e ? t === react__WEBPACK_IMPORTED_MODULE_1__.Fragment && (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(e, {
    onClick: cf(
      (i = e.props) == null ? void 0 : i.onClick,
      r
    )
  }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    t,
    {
      ...n,
      className: K("px-2", n.className),
      onClick: cf(n.onClick, r),
      children: e
    }
  ) : null;
};
Ij.displayName = "DropdownMenu.Item";
const Rj = (e) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ha.Separator, { ...e });
Rj.displayName = "DropdownMenu.Separator";
Js.Trigger = Nj;
Js.Content = $j;
Js.List = Dj;
Js.Item = Ij;
Js.Separator = Rj;
Js.Portal = Mj;
const lee = {
  left: {
    open: {
      x: 0
    },
    exit: {
      x: "-100%"
    }
  },
  right: {
    open: {
      x: 0
    },
    exit: {
      x: "100%"
    }
  }
}, jj = ({ children: e, className: t }) => {
  const { open: n, position: r, handleClose: i, drawerRef: o, transitionDuration: a } = Vg();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { children: n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: "fixed inset-0", children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "flex items-center justify-center h-full",
        {
          "justify-start": r === "left",
          "justify-end": r === "right"
        }
      ),
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        An.div,
        {
          ref: o,
          className: K(
            "flex flex-col w-120 h-full bg-background-primary shadow-2xl my-5 overflow-hidden",
            t
          ),
          initial: "exit",
          animate: "open",
          exit: "exit",
          variants: lee[r],
          transition: a,
          children: typeof e == "function" ? e({ close: i }) : e
        }
      )
    }
  ) }) });
};
jj.displayName = "Drawer.Panel";
const Lj = ({ children: e, className: t, ...n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: K("space-y-2 px-5 pt-5 pb-4", t), ...n, children: e });
Lj.displayName = "Drawer.Header";
const Bj = ({
  children: e,
  as: t = "h3",
  className: n,
  ...r
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  t,
  {
    className: K(
      "text-base font-semibold text-text-primary m-0 p-0",
      n
    ),
    ...r,
    children: e
  }
);
Bj.displayName = "Drawer.Title";
const Fj = ({
  children: e,
  as: t = "p",
  className: n,
  ...r
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  t,
  {
    className: K(
      "text-sm font-normal text-text-secondary my-0 ml-0 mr-1 p-0",
      n
    ),
    ...r,
    children: e
  }
);
Fj.displayName = "Drawer.Description";
const Wj = ({ children: e, className: t, ...n }) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "div",
  {
    className: K(
      "px-5 pb-4 pt-2 flex flex-col flex-1 overflow-y-auto overflow-x-hidden",
      t
    ),
    ...n,
    children: e
  }
);
Wj.displayName = "Drawer.Body";
const zj = ({ children: e, className: t }) => {
  const { design: n, handleClose: r } = Vg(), i = () => e ? typeof e == "function" ? e({ close: r }) : e : null;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "div",
    {
      className: K(
        "px-5 py-4 flex justify-end gap-3 mt-auto",
        {
          "bg-background-secondary": n === "footer-divided",
          "border-t border-b-0 border-x-0 border-solid border-border-subtle": n === "footer-bordered"
        },
        t
      ),
      children: i()
    }
  );
};
zj.displayName = "Drawer.Footer";
const fE = ({
  className: e,
  ...t
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "button",
  {
    className: K(
      "bg-transparent inline-flex justify-center items-center border-0 p-1 m-0 cursor-pointer focus:outline-none outline-none shadow-none",
      e
    ),
    "aria-label": "Close drawer",
    ...t,
    children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)($a, { className: "size-4 text-text-primary shrink-0" })
  }
), Vj = ({
  children: e,
  as: t = react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
  ...n
}) => {
  const { handleClose: r } = Vg();
  return e ? t === react__WEBPACK_IMPORTED_MODULE_1__.Fragment ? typeof e == "function" ? e({ close: r }) : (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(e) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(e, {
    onClick: r
  }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(fE, { onClick: r, ...n }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(t, { ...n, onClick: r, children: e }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(fE, { onClick: r, ...n });
};
Vj.displayName = "Drawer.CloseButton";
const cee = {
  open: {
    opacity: 1
  },
  exit: {
    opacity: 0
  }
}, Uj = ({ className: e, ...t }) => {
  const { open: n, drawerContainerRef: r, transitionDuration: i } = Vg();
  return r != null && r.current ? !!r.current && (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)(
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Ys, { children: n && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      An.div,
      {
        className: K(
          "fixed inset-0 -z-10 bg-background-inverse/90",
          e
        ),
        ...t,
        initial: "exit",
        animate: "open",
        exit: "exit",
        variants: cee,
        transition: i
      }
    ) }),
    r.current
  ) : null;
};
Uj.displayName = "Drawer.Backdrop";
const uee = 0.2, Hj = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({}), Vg = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(Hj), Jo = ({
  open: e,
  setOpen: t,
  children: n,
  trigger: r,
  className: i,
  exitOnClickOutside: o = !1,
  exitOnEsc: a = !0,
  design: s = "simple",
  position: l = "right",
  transitionDuration: c = uee,
  scrollLock: f = !0
}) => {
  const d = e !== void 0 && t !== void 0, [p, m] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!1), y = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), g = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null), v = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => d ? e : p,
    [e, p]
  ), x = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(
    () => d ? t : m,
    [m, m]
  ), w = () => {
    v || x(!0);
  }, S = () => {
    v && x(!1);
  }, A = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(r) ? (0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(r, {
    onClick: cf(w, r.props.onClick)
  }) : typeof r == "function" ? r({ onClick: w }) : null, [r, w, S]), _ = (P) => {
    switch (P.key) {
      case "Escape":
        a && S();
        break;
    }
  }, O = (P) => {
    o && y.current && !y.current.contains(P.target) && S();
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => (window.addEventListener("keydown", _), document.addEventListener("mousedown", O), () => {
    window.removeEventListener("keydown", _), document.removeEventListener("mousedown", O);
  }), [v]), (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!f)
      return;
    const P = document.querySelector("html");
    return v && P && (P.style.overflow = "hidden"), () => {
      P && (P.style.overflow = "");
    };
  }, [v]), /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
    A(),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      Hj.Provider,
      {
        value: {
          open: v,
          setOpen: x,
          handleClose: S,
          design: s,
          position: l,
          drawerContainerRef: g,
          drawerRef: y,
          transitionDuration: { duration: c }
        },
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          "div",
          {
            className: K(
              "fixed z-auto w-0 h-0 overflow-visible",
              i
            ),
            ref: g,
            role: "dialog",
            "aria-modal": "true",
            "aria-label": "drawer",
            children: n
          }
        )
      }
    )
  ] });
};
Jo.displayName = "Drawer";
Jo.Panel = jj;
Jo.Header = Lj;
Jo.Title = Bj;
Jo.Description = Fj;
Jo.Body = Wj;
Jo.CloseButton = Vj;
Jo.Footer = zj;
Jo.Backdrop = Uj;
const Ug = {
  xs: {
    general: "text-xs min-w-6 h-6",
    ellipse: "text-xs min-w-6",
    icon: "size-4"
  },
  sm: {
    general: "text-xs min-w-8 h-8",
    ellipse: "text-xs min-w-8",
    icon: "size-4"
  },
  md: {
    general: "text-sm min-w-10 h-10",
    ellipse: "text-sm min-w-10",
    icon: "size-5"
  },
  lg: {
    general: "text-base min-w-12 h-12",
    ellipse: "text-base min-w-12",
    icon: "size-6"
  }
}, Fs = {
  general: "group disabled:border-field-border-disabled opacity-50",
  text: "group-disabled:text-field-color-disabled"
}, Kj = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
  size: "sm",
  disabled: !1
}), Sd = () => (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(Kj), Fc = ({
  size: e = "sm",
  disabled: t = !1,
  children: n,
  className: r,
  ...i
}) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Kj.Provider, { value: { size: e, disabled: t }, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "nav",
  {
    role: "navigation",
    "aria-label": "pagination",
    className: K(
      "flex w-full justify-center box-border m-0",
      r
    ),
    ...i,
    children: n
  }
) });
Fc.displayName = "Pagination";
const Gj = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ className: e, ...t }, n) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
  "ul",
  {
    ref: n,
    className: K(
      "m-0 p-0 w-full flex justify-center flex-row items-center gap-1",
      "list-none",
      e
    ),
    ...t
  }
));
Gj.displayName = "Pagination.Content";
const Yj = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(
  ({ isActive: e = !1, className: t, children: n, ...r }, i) => {
    const { disabled: o } = Sd();
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
      "li",
      {
        ref: i,
        className: K("flex", o && Fs.general),
        children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
          P_,
          {
            isActive: e,
            disabled: o,
            className: t,
            ...r,
            children: n
          }
        )
      }
    );
  }
);
Yj.displayName = "Pagination.Item";
const P_ = ({
  isActive: e = !1,
  tag: t = "a",
  children: n,
  className: r,
  ...i
}) => {
  const { size: o, disabled: a } = Sd(), s = (l) => l.preventDefault();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    Hn,
    {
      tag: t,
      size: o,
      variant: "ghost",
      className: K(
        "no-underline bg-transparent p-0 m-0 border-none",
        "flex justify-center items-center rounded text-button-secondary",
        "focus:outline focus:outline-1 focus:outline-border-subtle focus:bg-button-tertiary-hover",
        Ug[o].general,
        !a && e && "text-button-primary active:text-button-primary bg-brand-background-50",
        a && [
          Fs.general,
          Fs.text,
          "focus:ring-transparent cursor-not-allowed"
        ],
        r
      ),
      disabled: a,
      ...i,
      onClick: (l) => cf(
        i.onClick || (() => {
        }),
        a ? s : () => {
        }
      )(l),
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "px-1 flex", children: n })
    }
  );
}, qj = (e) => {
  const { size: t, disabled: n } = Sd();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "li",
    {
      className: K("flex", n && Fs.general),
      "aria-label": "Go to previous page",
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        P_,
        {
          className: K("[&>span]:flex [&>span]:items-center"),
          ...e,
          children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(eD, { className: K(Ug[t].icon) })
        }
      )
    }
  );
};
qj.displayName = "Pagination.Previous";
const Xj = (e) => {
  const { size: t, disabled: n } = Sd();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "li",
    {
      className: K("flex", n && Fs.general),
      "aria-label": "Go to next page",
      children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
        P_,
        {
          className: K("[&>span]:flex [&>span]:items-center"),
          ...e,
          children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Zw, { className: K(Ug[t].icon) })
        }
      )
    }
  );
};
Xj.displayName = "Pagination.Next";
const Zj = (e) => {
  const { size: t, disabled: n } = Sd();
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: K("flex", n && Fs.general), children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(
    "span",
    {
      className: K(
        "flex justify-center",
        Ug[t].ellipse,
        n && Fs.general
      ),
      ...e,
      children: "•••"
    }
  ) });
};
Zj.displayName = "Pagination.Ellipsis";
Fc.Content = Gj;
Fc.Item = Yj;
Fc.Previous = qj;
Fc.Next = Xj;
Fc.Ellipsis = Zj;
var Le;
(function(e) {
  e.Root = "root", e.Chevron = "chevron", e.Day = "day", e.DayButton = "day_button", e.CaptionLabel = "caption_label", e.Dropdowns = "dropdowns", e.Dropdown = "dropdown", e.DropdownRoot = "dropdown_root", e.Footer = "footer", e.MonthGrid = "month_grid", e.MonthCaption = "month_caption", e.MonthsDropdown = "months_dropdown", e.Month = "month", e.Months = "months", e.Nav = "nav", e.NextMonthButton = "button_next", e.PreviousMonthButton = "button_previous", e.Week = "week", e.Weeks = "weeks", e.Weekday = "weekday", e.Weekdays = "weekdays", e.WeekNumber = "week_number", e.WeekNumberHeader = "week_number_header", e.YearsDropdown = "years_dropdown";
})(Le || (Le = {}));
var Lt;
(function(e) {
  e.disabled = "disabled", e.hidden = "hidden", e.outside = "outside", e.focused = "focused", e.today = "today";
})(Lt || (Lt = {}));
var Ei;
(function(e) {
  e.range_end = "range_end", e.range_middle = "range_middle", e.range_start = "range_start", e.selected = "selected";
})(Ei || (Ei = {}));
const Jj = 6048e5, fee = 864e5, dE = Symbol.for("constructDateFrom");
function Tn(e, t) {
  return typeof e == "function" ? e(t) : e && typeof e == "object" && dE in e ? e[dE](t) : e instanceof Date ? new e.constructor(t) : new Date(t);
}
function Et(e, t) {
  return Tn(t || e, e);
}
function C_(e, t, n) {
  const r = Et(e, n == null ? void 0 : n.in);
  return isNaN(t) ? Tn(e, NaN) : (t && r.setDate(r.getDate() + t), r);
}
function E_(e, t, n) {
  const r = Et(e, n == null ? void 0 : n.in);
  if (isNaN(t)) return Tn(e, NaN);
  if (!t)
    return r;
  const i = r.getDate(), o = Tn(e, r.getTime());
  o.setMonth(r.getMonth() + t + 1, 0);
  const a = o.getDate();
  return i >= a ? o : (r.setFullYear(
    o.getFullYear(),
    o.getMonth(),
    i
  ), r);
}
let dee = {};
function Od() {
  return dee;
}
function Ws(e, t) {
  var s, l, c, f;
  const n = Od(), r = (t == null ? void 0 : t.weekStartsOn) ?? ((l = (s = t == null ? void 0 : t.locale) == null ? void 0 : s.options) == null ? void 0 : l.weekStartsOn) ?? n.weekStartsOn ?? ((f = (c = n.locale) == null ? void 0 : c.options) == null ? void 0 : f.weekStartsOn) ?? 0, i = Et(e, t == null ? void 0 : t.in), o = i.getDay(), a = (o < r ? 7 : 0) + o - r;
  return i.setDate(i.getDate() - a), i.setHours(0, 0, 0, 0), i;
}
function Tf(e, t) {
  return Ws(e, { ...t, weekStartsOn: 1 });
}
function Qj(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = n.getFullYear(), i = Tn(n, 0);
  i.setFullYear(r + 1, 0, 4), i.setHours(0, 0, 0, 0);
  const o = Tf(i), a = Tn(n, 0);
  a.setFullYear(r, 0, 4), a.setHours(0, 0, 0, 0);
  const s = Tf(a);
  return n.getTime() >= o.getTime() ? r + 1 : n.getTime() >= s.getTime() ? r : r - 1;
}
function hE(e) {
  const t = Et(e), n = new Date(
    Date.UTC(
      t.getFullYear(),
      t.getMonth(),
      t.getDate(),
      t.getHours(),
      t.getMinutes(),
      t.getSeconds(),
      t.getMilliseconds()
    )
  );
  return n.setUTCFullYear(t.getFullYear()), +e - +n;
}
function Ad(e, ...t) {
  const n = Tn.bind(
    null,
    t.find((r) => typeof r == "object")
  );
  return t.map(n);
}
function Wi(e, t) {
  const n = Et(e, t == null ? void 0 : t.in);
  return n.setHours(0, 0, 0, 0), n;
}
function eL(e, t, n) {
  const [r, i] = Ad(
    n == null ? void 0 : n.in,
    e,
    t
  ), o = Wi(r), a = Wi(i), s = +o - hE(o), l = +a - hE(a);
  return Math.round((s - l) / fee);
}
function hee(e, t) {
  const n = Qj(e, t), r = Tn(e, 0);
  return r.setFullYear(n, 0, 4), r.setHours(0, 0, 0, 0), Tf(r);
}
function pee(e, t, n) {
  return C_(e, t * 7, n);
}
function mee(e, t, n) {
  return E_(e, t * 12, n);
}
function gee(e, t) {
  let n, r = t == null ? void 0 : t.in;
  return e.forEach((i) => {
    !r && typeof i == "object" && (r = Tn.bind(null, i));
    const o = Et(i, r);
    (!n || n < o || isNaN(+o)) && (n = o);
  }), Tn(r, n || NaN);
}
function yee(e, t) {
  let n, r = t == null ? void 0 : t.in;
  return e.forEach((i) => {
    !r && typeof i == "object" && (r = Tn.bind(null, i));
    const o = Et(i, r);
    (!n || n > o || isNaN(+o)) && (n = o);
  }), Tn(r, n || NaN);
}
function pE(e) {
  return Tn(e, Date.now());
}
function vee(e, t, n) {
  const [r, i] = Ad(
    n == null ? void 0 : n.in,
    e,
    t
  );
  return +Wi(r) == +Wi(i);
}
function tL(e) {
  return e instanceof Date || typeof e == "object" && Object.prototype.toString.call(e) === "[object Date]";
}
function bee(e) {
  return !(!tL(e) && typeof e != "number" || isNaN(+Et(e)));
}
function xee(e, t, n) {
  const [r, i] = Ad(
    n == null ? void 0 : n.in,
    e,
    t
  ), o = r.getFullYear() - i.getFullYear(), a = r.getMonth() - i.getMonth();
  return o * 12 + a;
}
function nL(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = n.getMonth();
  return n.setFullYear(n.getFullYear(), r + 1, 0), n.setHours(23, 59, 59, 999), n;
}
function rL(e, t) {
  const n = Et(e, t == null ? void 0 : t.in);
  return n.setDate(1), n.setHours(0, 0, 0, 0), n;
}
function wee(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = n.getFullYear();
  return n.setFullYear(r + 1, 0, 0), n.setHours(23, 59, 59, 999), n;
}
function iL(e, t) {
  const n = Et(e, t == null ? void 0 : t.in);
  return n.setFullYear(n.getFullYear(), 0, 1), n.setHours(0, 0, 0, 0), n;
}
function k_(e, t) {
  var s, l, c, f;
  const n = Od(), r = (t == null ? void 0 : t.weekStartsOn) ?? ((l = (s = t == null ? void 0 : t.locale) == null ? void 0 : s.options) == null ? void 0 : l.weekStartsOn) ?? n.weekStartsOn ?? ((f = (c = n.locale) == null ? void 0 : c.options) == null ? void 0 : f.weekStartsOn) ?? 0, i = Et(e, t == null ? void 0 : t.in), o = i.getDay(), a = (o < r ? -7 : 0) + 6 - (o - r);
  return i.setDate(i.getDate() + a), i.setHours(23, 59, 59, 999), i;
}
function _ee(e, t) {
  return k_(e, { ...t, weekStartsOn: 1 });
}
const See = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
}, Oee = (e, t, n) => {
  let r;
  const i = See[e];
  return typeof i == "string" ? r = i : t === 1 ? r = i.one : r = i.other.replace("{{count}}", t.toString()), n != null && n.addSuffix ? n.comparison && n.comparison > 0 ? "in " + r : r + " ago" : r;
};
function Tb(e) {
  return (t = {}) => {
    const n = t.width ? String(t.width) : e.defaultWidth;
    return e.formats[n] || e.formats[e.defaultWidth];
  };
}
const Aee = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
}, Tee = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
}, Pee = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
}, Cee = {
  date: Tb({
    formats: Aee,
    defaultWidth: "full"
  }),
  time: Tb({
    formats: Tee,
    defaultWidth: "full"
  }),
  dateTime: Tb({
    formats: Pee,
    defaultWidth: "full"
  })
}, Eee = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
}, kee = (e, t, n, r) => Eee[e];
function Au(e) {
  return (t, n) => {
    const r = n != null && n.context ? String(n.context) : "standalone";
    let i;
    if (r === "formatting" && e.formattingValues) {
      const a = e.defaultFormattingWidth || e.defaultWidth, s = n != null && n.width ? String(n.width) : a;
      i = e.formattingValues[s] || e.formattingValues[a];
    } else {
      const a = e.defaultWidth, s = n != null && n.width ? String(n.width) : e.defaultWidth;
      i = e.values[s] || e.values[a];
    }
    const o = e.argumentCallback ? e.argumentCallback(t) : t;
    return i[o];
  };
}
const Mee = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
}, Nee = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
}, $ee = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec"
  ],
  wide: [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
  ]
}, Dee = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday"
  ]
}, Iee = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
}, Ree = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
}, jee = (e, t) => {
  const n = Number(e), r = n % 100;
  if (r > 20 || r < 10)
    switch (r % 10) {
      case 1:
        return n + "st";
      case 2:
        return n + "nd";
      case 3:
        return n + "rd";
    }
  return n + "th";
}, Lee = {
  ordinalNumber: jee,
  era: Au({
    values: Mee,
    defaultWidth: "wide"
  }),
  quarter: Au({
    values: Nee,
    defaultWidth: "wide",
    argumentCallback: (e) => e - 1
  }),
  month: Au({
    values: $ee,
    defaultWidth: "wide"
  }),
  day: Au({
    values: Dee,
    defaultWidth: "wide"
  }),
  dayPeriod: Au({
    values: Iee,
    defaultWidth: "wide",
    formattingValues: Ree,
    defaultFormattingWidth: "wide"
  })
};
function Tu(e) {
  return (t, n = {}) => {
    const r = n.width, i = r && e.matchPatterns[r] || e.matchPatterns[e.defaultMatchWidth], o = t.match(i);
    if (!o)
      return null;
    const a = o[0], s = r && e.parsePatterns[r] || e.parsePatterns[e.defaultParseWidth], l = Array.isArray(s) ? Fee(s, (d) => d.test(a)) : (
      // [TODO] -- I challenge you to fix the type
      Bee(s, (d) => d.test(a))
    );
    let c;
    c = e.valueCallback ? e.valueCallback(l) : l, c = n.valueCallback ? (
      // [TODO] -- I challenge you to fix the type
      n.valueCallback(c)
    ) : c;
    const f = t.slice(a.length);
    return { value: c, rest: f };
  };
}
function Bee(e, t) {
  for (const n in e)
    if (Object.prototype.hasOwnProperty.call(e, n) && t(e[n]))
      return n;
}
function Fee(e, t) {
  for (let n = 0; n < e.length; n++)
    if (t(e[n]))
      return n;
}
function Wee(e) {
  return (t, n = {}) => {
    const r = t.match(e.matchPattern);
    if (!r) return null;
    const i = r[0], o = t.match(e.parsePattern);
    if (!o) return null;
    let a = e.valueCallback ? e.valueCallback(o[0]) : o[0];
    a = n.valueCallback ? n.valueCallback(a) : a;
    const s = t.slice(i.length);
    return { value: a, rest: s };
  };
}
const zee = /^(\d+)(th|st|nd|rd)?/i, Vee = /\d+/i, Uee = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
}, Hee = {
  any: [/^b/i, /^(a|c)/i]
}, Kee = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
}, Gee = {
  any: [/1/i, /2/i, /3/i, /4/i]
}, Yee = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
}, qee = {
  narrow: [
    /^j/i,
    /^f/i,
    /^m/i,
    /^a/i,
    /^m/i,
    /^j/i,
    /^j/i,
    /^a/i,
    /^s/i,
    /^o/i,
    /^n/i,
    /^d/i
  ],
  any: [
    /^ja/i,
    /^f/i,
    /^mar/i,
    /^ap/i,
    /^may/i,
    /^jun/i,
    /^jul/i,
    /^au/i,
    /^s/i,
    /^o/i,
    /^n/i,
    /^d/i
  ]
}, Xee = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
}, Zee = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
}, Jee = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
}, Qee = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
}, ete = {
  ordinalNumber: Wee({
    matchPattern: zee,
    parsePattern: Vee,
    valueCallback: (e) => parseInt(e, 10)
  }),
  era: Tu({
    matchPatterns: Uee,
    defaultMatchWidth: "wide",
    parsePatterns: Hee,
    defaultParseWidth: "any"
  }),
  quarter: Tu({
    matchPatterns: Kee,
    defaultMatchWidth: "wide",
    parsePatterns: Gee,
    defaultParseWidth: "any",
    valueCallback: (e) => e + 1
  }),
  month: Tu({
    matchPatterns: Yee,
    defaultMatchWidth: "wide",
    parsePatterns: qee,
    defaultParseWidth: "any"
  }),
  day: Tu({
    matchPatterns: Xee,
    defaultMatchWidth: "wide",
    parsePatterns: Zee,
    defaultParseWidth: "any"
  }),
  dayPeriod: Tu({
    matchPatterns: Jee,
    defaultMatchWidth: "any",
    parsePatterns: Qee,
    defaultParseWidth: "any"
  })
}, Hg = {
  code: "en-US",
  formatDistance: Oee,
  formatLong: Cee,
  formatRelative: kee,
  localize: Lee,
  match: ete,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
function tte(e, t) {
  const n = Et(e, t == null ? void 0 : t.in);
  return eL(n, iL(n)) + 1;
}
function oL(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = +Tf(n) - +hee(n);
  return Math.round(r / Jj) + 1;
}
function aL(e, t) {
  var f, d, p, m;
  const n = Et(e, t == null ? void 0 : t.in), r = n.getFullYear(), i = Od(), o = (t == null ? void 0 : t.firstWeekContainsDate) ?? ((d = (f = t == null ? void 0 : t.locale) == null ? void 0 : f.options) == null ? void 0 : d.firstWeekContainsDate) ?? i.firstWeekContainsDate ?? ((m = (p = i.locale) == null ? void 0 : p.options) == null ? void 0 : m.firstWeekContainsDate) ?? 1, a = Tn((t == null ? void 0 : t.in) || e, 0);
  a.setFullYear(r + 1, 0, o), a.setHours(0, 0, 0, 0);
  const s = Ws(a, t), l = Tn((t == null ? void 0 : t.in) || e, 0);
  l.setFullYear(r, 0, o), l.setHours(0, 0, 0, 0);
  const c = Ws(l, t);
  return +n >= +s ? r + 1 : +n >= +c ? r : r - 1;
}
function nte(e, t) {
  var s, l, c, f;
  const n = Od(), r = (t == null ? void 0 : t.firstWeekContainsDate) ?? ((l = (s = t == null ? void 0 : t.locale) == null ? void 0 : s.options) == null ? void 0 : l.firstWeekContainsDate) ?? n.firstWeekContainsDate ?? ((f = (c = n.locale) == null ? void 0 : c.options) == null ? void 0 : f.firstWeekContainsDate) ?? 1, i = aL(e, t), o = Tn((t == null ? void 0 : t.in) || e, 0);
  return o.setFullYear(i, 0, r), o.setHours(0, 0, 0, 0), Ws(o, t);
}
function sL(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = +Ws(n, t) - +nte(n, t);
  return Math.round(r / Jj) + 1;
}
function At(e, t) {
  const n = e < 0 ? "-" : "", r = Math.abs(e).toString().padStart(t, "0");
  return n + r;
}
const ya = {
  // Year
  y(e, t) {
    const n = e.getFullYear(), r = n > 0 ? n : 1 - n;
    return At(t === "yy" ? r % 100 : r, t.length);
  },
  // Month
  M(e, t) {
    const n = e.getMonth();
    return t === "M" ? String(n + 1) : At(n + 1, 2);
  },
  // Day of the month
  d(e, t) {
    return At(e.getDate(), t.length);
  },
  // AM or PM
  a(e, t) {
    const n = e.getHours() / 12 >= 1 ? "pm" : "am";
    switch (t) {
      case "a":
      case "aa":
        return n.toUpperCase();
      case "aaa":
        return n;
      case "aaaaa":
        return n[0];
      case "aaaa":
      default:
        return n === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h(e, t) {
    return At(e.getHours() % 12 || 12, t.length);
  },
  // Hour [0-23]
  H(e, t) {
    return At(e.getHours(), t.length);
  },
  // Minute
  m(e, t) {
    return At(e.getMinutes(), t.length);
  },
  // Second
  s(e, t) {
    return At(e.getSeconds(), t.length);
  },
  // Fraction of second
  S(e, t) {
    const n = t.length, r = e.getMilliseconds(), i = Math.trunc(
      r * Math.pow(10, n - 3)
    );
    return At(i, t.length);
  }
}, _l = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
}, mE = {
  // Era
  G: function(e, t, n) {
    const r = e.getFullYear() > 0 ? 1 : 0;
    switch (t) {
      case "G":
      case "GG":
      case "GGG":
        return n.era(r, { width: "abbreviated" });
      case "GGGGG":
        return n.era(r, { width: "narrow" });
      case "GGGG":
      default:
        return n.era(r, { width: "wide" });
    }
  },
  // Year
  y: function(e, t, n) {
    if (t === "yo") {
      const r = e.getFullYear(), i = r > 0 ? r : 1 - r;
      return n.ordinalNumber(i, { unit: "year" });
    }
    return ya.y(e, t);
  },
  // Local week-numbering year
  Y: function(e, t, n, r) {
    const i = aL(e, r), o = i > 0 ? i : 1 - i;
    if (t === "YY") {
      const a = o % 100;
      return At(a, 2);
    }
    return t === "Yo" ? n.ordinalNumber(o, { unit: "year" }) : At(o, t.length);
  },
  // ISO week-numbering year
  R: function(e, t) {
    const n = Qj(e);
    return At(n, t.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function(e, t) {
    const n = e.getFullYear();
    return At(n, t.length);
  },
  // Quarter
  Q: function(e, t, n) {
    const r = Math.ceil((e.getMonth() + 1) / 3);
    switch (t) {
      case "Q":
        return String(r);
      case "QQ":
        return At(r, 2);
      case "Qo":
        return n.ordinalNumber(r, { unit: "quarter" });
      case "QQQ":
        return n.quarter(r, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return n.quarter(r, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return n.quarter(r, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function(e, t, n) {
    const r = Math.ceil((e.getMonth() + 1) / 3);
    switch (t) {
      case "q":
        return String(r);
      case "qq":
        return At(r, 2);
      case "qo":
        return n.ordinalNumber(r, { unit: "quarter" });
      case "qqq":
        return n.quarter(r, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return n.quarter(r, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return n.quarter(r, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function(e, t, n) {
    const r = e.getMonth();
    switch (t) {
      case "M":
      case "MM":
        return ya.M(e, t);
      case "Mo":
        return n.ordinalNumber(r + 1, { unit: "month" });
      case "MMM":
        return n.month(r, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return n.month(r, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return n.month(r, { width: "wide", context: "formatting" });
    }
  },
  // Stand-alone month
  L: function(e, t, n) {
    const r = e.getMonth();
    switch (t) {
      case "L":
        return String(r + 1);
      case "LL":
        return At(r + 1, 2);
      case "Lo":
        return n.ordinalNumber(r + 1, { unit: "month" });
      case "LLL":
        return n.month(r, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return n.month(r, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return n.month(r, { width: "wide", context: "standalone" });
    }
  },
  // Local week of year
  w: function(e, t, n, r) {
    const i = sL(e, r);
    return t === "wo" ? n.ordinalNumber(i, { unit: "week" }) : At(i, t.length);
  },
  // ISO week of year
  I: function(e, t, n) {
    const r = oL(e);
    return t === "Io" ? n.ordinalNumber(r, { unit: "week" }) : At(r, t.length);
  },
  // Day of the month
  d: function(e, t, n) {
    return t === "do" ? n.ordinalNumber(e.getDate(), { unit: "date" }) : ya.d(e, t);
  },
  // Day of year
  D: function(e, t, n) {
    const r = tte(e);
    return t === "Do" ? n.ordinalNumber(r, { unit: "dayOfYear" }) : At(r, t.length);
  },
  // Day of week
  E: function(e, t, n) {
    const r = e.getDay();
    switch (t) {
      case "E":
      case "EE":
      case "EEE":
        return n.day(r, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return n.day(r, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return n.day(r, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return n.day(r, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function(e, t, n, r) {
    const i = e.getDay(), o = (i - r.weekStartsOn + 8) % 7 || 7;
    switch (t) {
      case "e":
        return String(o);
      case "ee":
        return At(o, 2);
      case "eo":
        return n.ordinalNumber(o, { unit: "day" });
      case "eee":
        return n.day(i, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return n.day(i, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return n.day(i, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return n.day(i, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function(e, t, n, r) {
    const i = e.getDay(), o = (i - r.weekStartsOn + 8) % 7 || 7;
    switch (t) {
      case "c":
        return String(o);
      case "cc":
        return At(o, t.length);
      case "co":
        return n.ordinalNumber(o, { unit: "day" });
      case "ccc":
        return n.day(i, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return n.day(i, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return n.day(i, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return n.day(i, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function(e, t, n) {
    const r = e.getDay(), i = r === 0 ? 7 : r;
    switch (t) {
      case "i":
        return String(i);
      case "ii":
        return At(i, t.length);
      case "io":
        return n.ordinalNumber(i, { unit: "day" });
      case "iii":
        return n.day(r, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return n.day(r, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return n.day(r, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return n.day(r, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function(e, t, n) {
    const i = e.getHours() / 12 >= 1 ? "pm" : "am";
    switch (t) {
      case "a":
      case "aa":
        return n.dayPeriod(i, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return n.dayPeriod(i, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return n.dayPeriod(i, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return n.dayPeriod(i, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function(e, t, n) {
    const r = e.getHours();
    let i;
    switch (r === 12 ? i = _l.noon : r === 0 ? i = _l.midnight : i = r / 12 >= 1 ? "pm" : "am", t) {
      case "b":
      case "bb":
        return n.dayPeriod(i, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return n.dayPeriod(i, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return n.dayPeriod(i, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return n.dayPeriod(i, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function(e, t, n) {
    const r = e.getHours();
    let i;
    switch (r >= 17 ? i = _l.evening : r >= 12 ? i = _l.afternoon : r >= 4 ? i = _l.morning : i = _l.night, t) {
      case "B":
      case "BB":
      case "BBB":
        return n.dayPeriod(i, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return n.dayPeriod(i, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return n.dayPeriod(i, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function(e, t, n) {
    if (t === "ho") {
      let r = e.getHours() % 12;
      return r === 0 && (r = 12), n.ordinalNumber(r, { unit: "hour" });
    }
    return ya.h(e, t);
  },
  // Hour [0-23]
  H: function(e, t, n) {
    return t === "Ho" ? n.ordinalNumber(e.getHours(), { unit: "hour" }) : ya.H(e, t);
  },
  // Hour [0-11]
  K: function(e, t, n) {
    const r = e.getHours() % 12;
    return t === "Ko" ? n.ordinalNumber(r, { unit: "hour" }) : At(r, t.length);
  },
  // Hour [1-24]
  k: function(e, t, n) {
    let r = e.getHours();
    return r === 0 && (r = 24), t === "ko" ? n.ordinalNumber(r, { unit: "hour" }) : At(r, t.length);
  },
  // Minute
  m: function(e, t, n) {
    return t === "mo" ? n.ordinalNumber(e.getMinutes(), { unit: "minute" }) : ya.m(e, t);
  },
  // Second
  s: function(e, t, n) {
    return t === "so" ? n.ordinalNumber(e.getSeconds(), { unit: "second" }) : ya.s(e, t);
  },
  // Fraction of second
  S: function(e, t) {
    return ya.S(e, t);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function(e, t, n) {
    const r = e.getTimezoneOffset();
    if (r === 0)
      return "Z";
    switch (t) {
      case "X":
        return yE(r);
      case "XXXX":
      case "XX":
        return gs(r);
      case "XXXXX":
      case "XXX":
      default:
        return gs(r, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function(e, t, n) {
    const r = e.getTimezoneOffset();
    switch (t) {
      case "x":
        return yE(r);
      case "xxxx":
      case "xx":
        return gs(r);
      case "xxxxx":
      case "xxx":
      default:
        return gs(r, ":");
    }
  },
  // Timezone (GMT)
  O: function(e, t, n) {
    const r = e.getTimezoneOffset();
    switch (t) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + gE(r, ":");
      case "OOOO":
      default:
        return "GMT" + gs(r, ":");
    }
  },
  // Timezone (specific non-location)
  z: function(e, t, n) {
    const r = e.getTimezoneOffset();
    switch (t) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + gE(r, ":");
      case "zzzz":
      default:
        return "GMT" + gs(r, ":");
    }
  },
  // Seconds timestamp
  t: function(e, t, n) {
    const r = Math.trunc(+e / 1e3);
    return At(r, t.length);
  },
  // Milliseconds timestamp
  T: function(e, t, n) {
    return At(+e, t.length);
  }
};
function gE(e, t = "") {
  const n = e > 0 ? "-" : "+", r = Math.abs(e), i = Math.trunc(r / 60), o = r % 60;
  return o === 0 ? n + String(i) : n + String(i) + t + At(o, 2);
}
function yE(e, t) {
  return e % 60 === 0 ? (e > 0 ? "-" : "+") + At(Math.abs(e) / 60, 2) : gs(e, t);
}
function gs(e, t = "") {
  const n = e > 0 ? "-" : "+", r = Math.abs(e), i = At(Math.trunc(r / 60), 2), o = At(r % 60, 2);
  return n + i + t + o;
}
const vE = (e, t) => {
  switch (e) {
    case "P":
      return t.date({ width: "short" });
    case "PP":
      return t.date({ width: "medium" });
    case "PPP":
      return t.date({ width: "long" });
    case "PPPP":
    default:
      return t.date({ width: "full" });
  }
}, lL = (e, t) => {
  switch (e) {
    case "p":
      return t.time({ width: "short" });
    case "pp":
      return t.time({ width: "medium" });
    case "ppp":
      return t.time({ width: "long" });
    case "pppp":
    default:
      return t.time({ width: "full" });
  }
}, rte = (e, t) => {
  const n = e.match(/(P+)(p+)?/) || [], r = n[1], i = n[2];
  if (!i)
    return vE(e, t);
  let o;
  switch (r) {
    case "P":
      o = t.dateTime({ width: "short" });
      break;
    case "PP":
      o = t.dateTime({ width: "medium" });
      break;
    case "PPP":
      o = t.dateTime({ width: "long" });
      break;
    case "PPPP":
    default:
      o = t.dateTime({ width: "full" });
      break;
  }
  return o.replace("{{date}}", vE(r, t)).replace("{{time}}", lL(i, t));
}, ite = {
  p: lL,
  P: rte
}, ote = /^D+$/, ate = /^Y+$/, ste = ["D", "DD", "YY", "YYYY"];
function lte(e) {
  return ote.test(e);
}
function cte(e) {
  return ate.test(e);
}
function ute(e, t, n) {
  const r = fte(e, t, n);
  if (console.warn(r), ste.includes(e)) throw new RangeError(r);
}
function fte(e, t, n) {
  const r = e[0] === "Y" ? "years" : "days of the month";
  return `Use \`${e.toLowerCase()}\` instead of \`${e}\` (in \`${t}\`) for formatting ${r} to the input \`${n}\`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md`;
}
const dte = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g, hte = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g, pte = /^'([^]*?)'?$/, mte = /''/g, gte = /[a-zA-Z]/;
function Fn(e, t, n) {
  var f, d, p, m, y, g, v, x;
  const r = Od(), i = (n == null ? void 0 : n.locale) ?? r.locale ?? Hg, o = (n == null ? void 0 : n.firstWeekContainsDate) ?? ((d = (f = n == null ? void 0 : n.locale) == null ? void 0 : f.options) == null ? void 0 : d.firstWeekContainsDate) ?? r.firstWeekContainsDate ?? ((m = (p = r.locale) == null ? void 0 : p.options) == null ? void 0 : m.firstWeekContainsDate) ?? 1, a = (n == null ? void 0 : n.weekStartsOn) ?? ((g = (y = n == null ? void 0 : n.locale) == null ? void 0 : y.options) == null ? void 0 : g.weekStartsOn) ?? r.weekStartsOn ?? ((x = (v = r.locale) == null ? void 0 : v.options) == null ? void 0 : x.weekStartsOn) ?? 0, s = Et(e, n == null ? void 0 : n.in);
  if (!bee(s))
    throw new RangeError("Invalid time value");
  let l = t.match(hte).map((w) => {
    const S = w[0];
    if (S === "p" || S === "P") {
      const A = ite[S];
      return A(w, i.formatLong);
    }
    return w;
  }).join("").match(dte).map((w) => {
    if (w === "''")
      return { isToken: !1, value: "'" };
    const S = w[0];
    if (S === "'")
      return { isToken: !1, value: yte(w) };
    if (mE[S])
      return { isToken: !0, value: w };
    if (S.match(gte))
      throw new RangeError(
        "Format string contains an unescaped latin alphabet character `" + S + "`"
      );
    return { isToken: !1, value: w };
  });
  i.localize.preprocessor && (l = i.localize.preprocessor(s, l));
  const c = {
    firstWeekContainsDate: o,
    weekStartsOn: a,
    locale: i
  };
  return l.map((w) => {
    if (!w.isToken) return w.value;
    const S = w.value;
    (!(n != null && n.useAdditionalWeekYearTokens) && cte(S) || !(n != null && n.useAdditionalDayOfYearTokens) && lte(S)) && ute(S, t, String(e));
    const A = mE[S[0]];
    return A(s, S, i.localize, c);
  }).join("");
}
function yte(e) {
  const t = e.match(pte);
  return t ? t[1].replace(mte, "'") : e;
}
function vte(e, t) {
  const n = Et(e, t == null ? void 0 : t.in), r = n.getFullYear(), i = n.getMonth(), o = Tn(n, 0);
  return o.setFullYear(r, i + 1, 0), o.setHours(0, 0, 0, 0), o.getDate();
}
function fx(e, t) {
  return +Et(e) > +Et(t);
}
function dx(e, t) {
  return +Et(e) < +Et(t);
}
function bE(e, t) {
  return +Et(e) == +Et(t);
}
function bte(e, t, n) {
  const [r, i] = Ad(
    n == null ? void 0 : n.in,
    e,
    t
  );
  return r.getFullYear() === i.getFullYear() && r.getMonth() === i.getMonth();
}
function xte(e, t, n) {
  const [r, i] = Ad(
    n == null ? void 0 : n.in,
    e,
    t
  );
  return r.getFullYear() === i.getFullYear();
}
function xE(e, t, n) {
  return C_(e, -t, n);
}
function wte(e, t, n) {
  const r = Et(e, n == null ? void 0 : n.in), i = r.getFullYear(), o = r.getDate(), a = Tn(e, 0);
  a.setFullYear(i, t, 15), a.setHours(0, 0, 0, 0);
  const s = vte(a);
  return r.setMonth(t, Math.min(o, s)), r;
}
function _te(e, t, n) {
  const r = Et(e, n == null ? void 0 : n.in);
  return isNaN(+r) ? Tn(e, NaN) : (r.setFullYear(t), r);
}
function wE(e) {
  return Wi(Date.now(), e);
}
function _E(e) {
  const t = pE(e == null ? void 0 : e.in), n = t.getFullYear(), r = t.getMonth(), i = t.getDate(), o = pE(e == null ? void 0 : e.in);
  return o.setFullYear(n, r, i - 1), o.setHours(0, 0, 0, 0), o;
}
function Ste(e, t, n) {
  return E_(e, -t, n);
}
class Qo {
  /**
   * Creates an instance of DateLib.
   *
   * @param options The options for the date library.
   * @param overrides Overrides for the date library functions.
   */
  constructor(t, n) {
    this.Date = Date, this.addDays = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.addDays ? this.overrides.addDays(r, i) : C_(r, i);
    }, this.addMonths = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.addMonths ? this.overrides.addMonths(r, i) : E_(r, i);
    }, this.addWeeks = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.addWeeks ? this.overrides.addWeeks(r, i) : pee(r, i);
    }, this.addYears = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.addYears ? this.overrides.addYears(r, i) : mee(r, i);
    }, this.differenceInCalendarDays = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.differenceInCalendarDays ? this.overrides.differenceInCalendarDays(r, i) : eL(r, i);
    }, this.differenceInCalendarMonths = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.differenceInCalendarMonths ? this.overrides.differenceInCalendarMonths(r, i) : xee(r, i);
    }, this.endOfISOWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.endOfISOWeek ? this.overrides.endOfISOWeek(r) : _ee(r);
    }, this.endOfMonth = (r) => {
      var i;
      return (i = this.overrides) != null && i.endOfMonth ? this.overrides.endOfMonth(r) : nL(r);
    }, this.endOfWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.endOfWeek ? this.overrides.endOfWeek(r, this.options) : k_(r, this.options);
    }, this.endOfYear = (r) => {
      var i;
      return (i = this.overrides) != null && i.endOfYear ? this.overrides.endOfYear(r) : wee(r);
    }, this.format = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.format ? this.overrides.format(r, i, this.options) : Fn(r, i, this.options);
    }, this.getISOWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.getISOWeek ? this.overrides.getISOWeek(r) : oL(r);
    }, this.getWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.getWeek ? this.overrides.getWeek(r, this.options) : sL(r, this.options);
    }, this.isAfter = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.isAfter ? this.overrides.isAfter(r, i) : fx(r, i);
    }, this.isBefore = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.isBefore ? this.overrides.isBefore(r, i) : dx(r, i);
    }, this.isDate = (r) => {
      var i;
      return (i = this.overrides) != null && i.isDate ? this.overrides.isDate(r) : tL(r);
    }, this.isSameDay = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.isSameDay ? this.overrides.isSameDay(r, i) : vee(r, i);
    }, this.isSameMonth = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.isSameMonth ? this.overrides.isSameMonth(r, i) : bte(r, i);
    }, this.isSameYear = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.isSameYear ? this.overrides.isSameYear(r, i) : xte(r, i);
    }, this.max = (r) => {
      var i;
      return (i = this.overrides) != null && i.max ? this.overrides.max(r) : gee(r);
    }, this.min = (r) => {
      var i;
      return (i = this.overrides) != null && i.min ? this.overrides.min(r) : yee(r);
    }, this.setMonth = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.setMonth ? this.overrides.setMonth(r, i) : wte(r, i);
    }, this.setYear = (r, i) => {
      var o;
      return (o = this.overrides) != null && o.setYear ? this.overrides.setYear(r, i) : _te(r, i);
    }, this.startOfDay = (r) => {
      var i;
      return (i = this.overrides) != null && i.startOfDay ? this.overrides.startOfDay(r) : Wi(r);
    }, this.startOfISOWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.startOfISOWeek ? this.overrides.startOfISOWeek(r) : Tf(r);
    }, this.startOfMonth = (r) => {
      var i;
      return (i = this.overrides) != null && i.startOfMonth ? this.overrides.startOfMonth(r) : rL(r);
    }, this.startOfWeek = (r) => {
      var i;
      return (i = this.overrides) != null && i.startOfWeek ? this.overrides.startOfWeek(r, this.options) : Ws(r, this.options);
    }, this.startOfYear = (r) => {
      var i;
      return (i = this.overrides) != null && i.startOfYear ? this.overrides.startOfYear(r) : iL(r);
    }, this.options = { locale: Hg, ...t }, this.overrides = n;
  }
}
const Qs = new Qo();
function Ote(e, t, n = {}) {
  return Object.entries(e).filter(([, i]) => i === !0).reduce((i, [o]) => (n[o] ? i.push(n[o]) : t[Lt[o]] ? i.push(t[Lt[o]]) : t[Ei[o]] && i.push(t[Ei[o]]), i), [t[Le.Day]]);
}
function Ate(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("button", { ...e });
}
function Tte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", { ...e });
}
function Pte(e) {
  const { size: t = 24, orientation: n = "left", className: r } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    "svg",
    { className: r, width: t, height: t, viewBox: "0 0 24 24" },
    n === "up" && react__WEBPACK_IMPORTED_MODULE_1__.createElement("polygon", { points: "6.77 17 12.5 11.43 18.24 17 20 15.28 12.5 8 5 15.28" }),
    n === "down" && react__WEBPACK_IMPORTED_MODULE_1__.createElement("polygon", { points: "6.77 8 12.5 13.57 18.24 8 20 9.72 12.5 17 5 9.72" }),
    n === "left" && react__WEBPACK_IMPORTED_MODULE_1__.createElement("polygon", { points: "16 18.112 9.81111111 12 16 5.87733333 14.0888889 4 6 12 14.0888889 20" }),
    n === "right" && react__WEBPACK_IMPORTED_MODULE_1__.createElement("polygon", { points: "8 18.612 14.1888889 12.5 8 6.37733333 9.91111111 4.5 18 12.5 9.91111111 20.5" })
  );
}
function Cte(e) {
  const { day: t, modifiers: n, ...r } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("td", { ...r });
}
function Ete(e) {
  const { day: t, modifiers: n, ...r } = e, i = react__WEBPACK_IMPORTED_MODULE_1__.useRef(null);
  return react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
    var o;
    n.focused && ((o = i.current) == null || o.focus());
  }, [n.focused]), react__WEBPACK_IMPORTED_MODULE_1__.createElement("button", { ref: i, ...r });
}
function kte(e) {
  const { options: t, className: n, components: r, classNames: i, ...o } = e, a = [i[Le.Dropdown], n].join(" "), s = t == null ? void 0 : t.find(({ value: l }) => l === o.value);
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    "span",
    { "data-disabled": o.disabled, className: i[Le.DropdownRoot] },
    react__WEBPACK_IMPORTED_MODULE_1__.createElement(r.Select, { className: a, ...o }, t == null ? void 0 : t.map(({ value: l, label: c, disabled: f }) => react__WEBPACK_IMPORTED_MODULE_1__.createElement(r.Option, { key: l, value: l, disabled: f }, c))),
    react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      "span",
      { className: i[Le.CaptionLabel], "aria-hidden": !0 },
      s == null ? void 0 : s.label,
      react__WEBPACK_IMPORTED_MODULE_1__.createElement(r.Chevron, { orientation: "down", size: 18, className: i[Le.Chevron] })
    )
  );
}
function Mte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...e });
}
function Nte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...e });
}
function $te(e) {
  const { calendarMonth: t, displayIndex: n, ...r } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...r }, e.children);
}
function Dte(e) {
  const { calendarMonth: t, displayIndex: n, ...r } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...r });
}
function Ite(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("table", { ...e });
}
function Rte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...e });
}
const cL = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(void 0);
function Wc() {
  const e = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(cL);
  if (e === void 0)
    throw new Error("useDayPicker() must be used within a custom component.");
  return e;
}
function jte(e) {
  const { components: t } = Wc();
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(t.Dropdown, { ...e });
}
function Lte(e) {
  const { onPreviousClick: t, onNextClick: n, previousMonth: r, nextMonth: i, ...o } = e, { components: a, classNames: s, labels: { labelPrevious: l, labelNext: c } } = Wc();
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    "nav",
    { ...o },
    react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      a.PreviousMonthButton,
      { type: "button", className: s[Le.PreviousMonthButton], tabIndex: r ? void 0 : -1, disabled: r ? void 0 : !0, "aria-label": l(r), onClick: e.onPreviousClick },
      react__WEBPACK_IMPORTED_MODULE_1__.createElement(a.Chevron, { disabled: r ? void 0 : !0, className: s[Le.Chevron], orientation: "left" })
    ),
    react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      a.NextMonthButton,
      { type: "button", className: s[Le.NextMonthButton], tabIndex: i ? void 0 : -1, disabled: i ? void 0 : !0, "aria-label": c(i), onClick: e.onNextClick },
      react__WEBPACK_IMPORTED_MODULE_1__.createElement(a.Chevron, { disabled: i ? void 0 : !0, orientation: "right", className: s[Le.Chevron] })
    )
  );
}
function Bte(e) {
  const { components: t } = Wc();
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(t.Button, { ...e });
}
function Fte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("option", { ...e });
}
function Wte(e) {
  const { components: t } = Wc();
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(t.Button, { ...e });
}
function zte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { ...e });
}
function Vte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("select", { ...e });
}
function Ute(e) {
  const { week: t, ...n } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("tr", { ...n });
}
function Hte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("th", { ...e });
}
function Kte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    "thead",
    null,
    react__WEBPACK_IMPORTED_MODULE_1__.createElement("tr", { ...e })
  );
}
function Gte(e) {
  const { week: t, ...n } = e;
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("th", { ...n });
}
function Yte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("th", { ...e });
}
function qte(e) {
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement("tbody", { ...e });
}
function Xte(e) {
  const { components: t } = Wc();
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(t.Dropdown, { ...e });
}
const Zte = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Button: Ate,
  CaptionLabel: Tte,
  Chevron: Pte,
  Day: Cte,
  DayButton: Ete,
  Dropdown: kte,
  DropdownNav: Mte,
  Footer: Nte,
  Month: $te,
  MonthCaption: Dte,
  MonthGrid: Ite,
  Months: Rte,
  MonthsDropdown: jte,
  Nav: Lte,
  NextMonthButton: Bte,
  Option: Fte,
  PreviousMonthButton: Wte,
  Root: zte,
  Select: Vte,
  Week: Ute,
  WeekNumber: Gte,
  WeekNumberHeader: Yte,
  Weekday: Hte,
  Weekdays: Kte,
  Weeks: qte,
  YearsDropdown: Xte
}, Symbol.toStringTag, { value: "Module" }));
function Jte(e) {
  return {
    ...Zte,
    ...e
  };
}
function Qte(e) {
  const t = {
    "data-mode": e.mode ?? void 0,
    "data-required": "required" in e ? e.required : void 0,
    "data-multiple-months": e.numberOfMonths && e.numberOfMonths > 1 || void 0,
    "data-week-numbers": e.showWeekNumber || void 0
  };
  return Object.entries(e).forEach(([n, r]) => {
    n.startsWith("data-") && (t[n] = r);
  }), t;
}
function ene() {
  const e = {};
  for (const t in Le)
    e[Le[t]] = `rdp-${Le[t]}`;
  for (const t in Lt)
    e[Lt[t]] = `rdp-${Lt[t]}`;
  for (const t in Ei)
    e[Ei[t]] = `rdp-${Ei[t]}`;
  return e;
}
function uL(e, t, n) {
  return (n ?? new Qo(t)).format(e, "LLLL y");
}
const tne = uL;
function nne(e, t, n) {
  return (n ?? new Qo(t)).format(e, "d");
}
function rne(e, t) {
  var n;
  return (n = t.localize) == null ? void 0 : n.month(e);
}
function ine(e) {
  return e < 10 ? `0${e.toLocaleString()}` : `${e.toLocaleString()}`;
}
function one() {
  return "";
}
function ane(e, t, n) {
  return (n ?? new Qo(t)).format(e, "cccccc");
}
function fL(e) {
  return e.toString();
}
const sne = fL, lne = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  formatCaption: uL,
  formatDay: nne,
  formatMonthCaption: tne,
  formatMonthDropdown: rne,
  formatWeekNumber: ine,
  formatWeekNumberHeader: one,
  formatWeekdayName: ane,
  formatYearCaption: sne,
  formatYearDropdown: fL
}, Symbol.toStringTag, { value: "Module" }));
function cne(e) {
  return e != null && e.formatMonthCaption && !e.formatCaption && (e.formatCaption = e.formatMonthCaption), e != null && e.formatYearCaption && !e.formatYearDropdown && (e.formatYearDropdown = e.formatYearCaption), {
    ...lne,
    ...e
  };
}
function une(e, t, n, r, i) {
  if (!t || !n)
    return;
  const { addMonths: o, startOfMonth: a, isBefore: s } = i, l = e.getFullYear(), c = [];
  let f = t;
  for (; c.length < 12 && s(f, o(n, 1)); )
    c.push(f.getMonth()), f = o(f, 1);
  return c.sort((m, y) => m - y).map((m) => {
    const y = r.formatMonthDropdown(m, i.options.locale ?? Hg), g = i.Date ? new i.Date(l, m) : new Date(l, m), v = t && g < a(t) || n && g > a(n) || !1;
    return { value: m, label: y, disabled: v };
  });
}
function fne(e, t = {}, n = {}) {
  let r = { ...t == null ? void 0 : t[Le.Day] };
  return Object.entries(e).filter(([, i]) => i === !0).forEach(([i]) => {
    r = {
      ...r,
      ...n == null ? void 0 : n[i]
    };
  }), r;
}
const Pb = {}, zu = {};
function ef(e, t) {
  try {
    const r = (Pb[e] || (Pb[e] = new Intl.DateTimeFormat("en-GB", {
      timeZone: e,
      hour: "numeric",
      timeZoneName: "longOffset"
    }).format))(t).split("GMT")[1] || "";
    return r in zu ? zu[r] : SE(r, r.split(":"));
  } catch {
    if (e in zu) return zu[e];
    const n = e == null ? void 0 : e.match(dne);
    return n ? SE(e, n.slice(1)) : NaN;
  }
}
const dne = /([+-]\d\d):?(\d\d)?/;
function SE(e, t) {
  const n = +t[0], r = +(t[1] || 0);
  return zu[e] = n > 0 ? n * 60 + r : n * 60 - r;
}
class zi extends Date {
  //#region static
  constructor(...t) {
    super(), t.length > 1 && typeof t[t.length - 1] == "string" && (this.timeZone = t.pop()), this.internal = /* @__PURE__ */ new Date(), isNaN(ef(this.timeZone, this)) ? this.setTime(NaN) : t.length ? typeof t[0] == "number" && (t.length === 1 || t.length === 2 && typeof t[1] != "number") ? this.setTime(t[0]) : typeof t[0] == "string" ? this.setTime(+new Date(t[0])) : t[0] instanceof Date ? this.setTime(+t[0]) : (this.setTime(+new Date(...t)), dL(this), hx(this)) : this.setTime(Date.now());
  }
  static tz(t, ...n) {
    return n.length ? new zi(...n, t) : new zi(Date.now(), t);
  }
  //#endregion
  //#region time zone
  withTimeZone(t) {
    return new zi(+this, t);
  }
  getTimezoneOffset() {
    return -ef(this.timeZone, this);
  }
  //#endregion
  //#region time
  setTime(t) {
    return Date.prototype.setTime.apply(this, arguments), hx(this), +this;
  }
  //#endregion
  //#region date-fns integration
  [Symbol.for("constructDateFrom")](t) {
    return new zi(+new Date(t), this.timeZone);
  }
  //#endregion
}
const OE = /^(get|set)(?!UTC)/;
Object.getOwnPropertyNames(Date.prototype).forEach((e) => {
  if (!OE.test(e)) return;
  const t = e.replace(OE, "$1UTC");
  zi.prototype[t] && (e.startsWith("get") ? zi.prototype[e] = function() {
    return this.internal[t]();
  } : (zi.prototype[e] = function() {
    return Date.prototype[t].apply(this.internal, arguments), hne(this), +this;
  }, zi.prototype[t] = function() {
    return Date.prototype[t].apply(this, arguments), hx(this), +this;
  }));
});
function hx(e) {
  e.internal.setTime(+e), e.internal.setUTCMinutes(e.internal.getUTCMinutes() - e.getTimezoneOffset());
}
function hne(e) {
  Date.prototype.setFullYear.call(e, e.internal.getUTCFullYear(), e.internal.getUTCMonth(), e.internal.getUTCDate()), Date.prototype.setHours.call(e, e.internal.getUTCHours(), e.internal.getUTCMinutes(), e.internal.getUTCSeconds(), e.internal.getUTCMilliseconds()), dL(e);
}
function dL(e) {
  const t = ef(e.timeZone, e), n = /* @__PURE__ */ new Date(+e);
  n.setUTCHours(n.getUTCHours() - 1);
  const r = -(/* @__PURE__ */ new Date(+e)).getTimezoneOffset(), i = -(/* @__PURE__ */ new Date(+n)).getTimezoneOffset(), o = r - i, a = Date.prototype.getHours.apply(e) !== e.internal.getUTCHours();
  o && a && e.internal.setUTCMinutes(e.internal.getUTCMinutes() + o);
  const s = r - t;
  s && Date.prototype.setUTCMinutes.call(e, Date.prototype.getUTCMinutes.call(e) + s);
  const l = ef(e.timeZone, e), f = -(/* @__PURE__ */ new Date(+e)).getTimezoneOffset() - l, d = l !== t, p = f - s;
  if (d && p) {
    Date.prototype.setUTCMinutes.call(e, Date.prototype.getUTCMinutes.call(e) + p);
    const m = ef(e.timeZone, e), y = l - m;
    y && (e.internal.setUTCMinutes(e.internal.getUTCMinutes() + y), Date.prototype.setUTCMinutes.call(e, Date.prototype.getUTCMinutes.call(e) + y));
  }
}
class Vi extends zi {
  //#region static
  static tz(t, ...n) {
    return n.length ? new Vi(...n, t) : new Vi(Date.now(), t);
  }
  //#endregion
  //#region representation
  toISOString() {
    const [t, n, r] = this.tzComponents(), i = `${t}${n}:${r}`;
    return this.internal.toISOString().slice(0, -1) + i;
  }
  toString() {
    return `${this.toDateString()} ${this.toTimeString()}`;
  }
  toDateString() {
    const [t, n, r, i] = this.internal.toUTCString().split(" ");
    return `${t == null ? void 0 : t.slice(0, -1)} ${r} ${n} ${i}`;
  }
  toTimeString() {
    const t = this.internal.toUTCString().split(" ")[4], [n, r, i] = this.tzComponents();
    return `${t} GMT${n}${r}${i} (${pne(this.timeZone, this)})`;
  }
  toLocaleString(t, n) {
    return Date.prototype.toLocaleString.call(this, t, {
      ...n,
      timeZone: (n == null ? void 0 : n.timeZone) || this.timeZone
    });
  }
  toLocaleDateString(t, n) {
    return Date.prototype.toLocaleDateString.call(this, t, {
      ...n,
      timeZone: (n == null ? void 0 : n.timeZone) || this.timeZone
    });
  }
  toLocaleTimeString(t, n) {
    return Date.prototype.toLocaleTimeString.call(this, t, {
      ...n,
      timeZone: (n == null ? void 0 : n.timeZone) || this.timeZone
    });
  }
  //#endregion
  //#region private
  tzComponents() {
    const t = this.getTimezoneOffset(), n = t > 0 ? "-" : "+", r = String(Math.floor(Math.abs(t) / 60)).padStart(2, "0"), i = String(Math.abs(t) % 60).padStart(2, "0");
    return [n, r, i];
  }
  //#endregion
  withTimeZone(t) {
    return new Vi(+this, t);
  }
  //#region date-fns integration
  [Symbol.for("constructDateFrom")](t) {
    return new Vi(+new Date(t), this.timeZone);
  }
  //#endregion
}
function pne(e, t) {
  return new Intl.DateTimeFormat("en-GB", {
    timeZone: e,
    timeZoneName: "long"
  }).format(t).slice(12);
}
function mne(e, t, n) {
  const r = n ? Vi.tz(n) : e.Date ? new e.Date() : /* @__PURE__ */ new Date(), i = t ? e.startOfISOWeek(r) : e.startOfWeek(r), o = [];
  for (let a = 0; a < 7; a++) {
    const s = e.addDays(i, a);
    o.push(s);
  }
  return o;
}
function gne(e, t, n, r, i) {
  if (!t || !n)
    return;
  const { startOfMonth: o, startOfYear: a, endOfYear: s, addYears: l, isBefore: c, isSameYear: f } = i, d = e.getMonth(), p = a(t), m = s(n), y = [];
  let g = p;
  for (; c(g, m) || f(g, m); )
    y.push(g.getFullYear()), g = l(g, 1);
  return y.map((v) => {
    const x = i.Date ? new i.Date(v, d) : new Date(v, d), w = t && x < o(t) || d && n && x > o(n) || !1, S = r.formatYearDropdown(v);
    return {
      value: v,
      label: S,
      disabled: w
    };
  });
}
function hL(e, t, n) {
  return (n ?? new Qo(t)).format(e, "LLLL y");
}
const yne = hL;
function vne(e, t, n, r) {
  let i = (r ?? new Qo(n)).format(e, "PPPP");
  return t != null && t.today && (i = `Today, ${i}`), i;
}
function pL(e, t, n, r) {
  let i = (r ?? new Qo(n)).format(e, "PPPP");
  return t.today && (i = `Today, ${i}`), t.selected && (i = `${i}, selected`), i;
}
const bne = pL;
function xne() {
  return "";
}
function wne(e) {
  return "Choose the Month";
}
function _ne(e) {
  return "Go to the Next Month";
}
function Sne(e) {
  return "Go to the Previous Month";
}
function One(e, t, n) {
  return (n ?? new Qo(t)).format(e, "cccc");
}
function Ane(e, t) {
  return `Week ${e}`;
}
function Tne(e) {
  return "Week Number";
}
function Pne(e) {
  return "Choose the Year";
}
const Cne = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  labelCaption: yne,
  labelDay: bne,
  labelDayButton: pL,
  labelGrid: hL,
  labelGridcell: vne,
  labelMonthDropdown: wne,
  labelNav: xne,
  labelNext: _ne,
  labelPrevious: Sne,
  labelWeekNumber: Ane,
  labelWeekNumberHeader: Tne,
  labelWeekday: One,
  labelYearDropdown: Pne
}, Symbol.toStringTag, { value: "Module" })), px = 42;
function Ene(e, t, n, r) {
  const i = e[0], o = e[e.length - 1], { ISOWeek: a, fixedWeeks: s } = n ?? {}, { startOfWeek: l, endOfWeek: c, startOfISOWeek: f, endOfISOWeek: d, addDays: p, differenceInCalendarDays: m, differenceInCalendarMonths: y, isAfter: g, endOfMonth: v } = r, x = a ? f(i) : l(i), w = a ? d(v(o)) : c(v(o)), S = m(w, x), A = y(o, i) + 1, _ = [];
  for (let P = 0; P <= S; P++) {
    const C = p(x, P);
    if (t && g(C, t))
      break;
    _.push(C);
  }
  const O = px * A;
  if (s && _.length < O) {
    const P = O - _.length;
    for (let C = 0; C < P; C++) {
      const k = p(_[_.length - 1], 1);
      _.push(k);
    }
  }
  return _;
}
function kne(e) {
  const t = [];
  return e.reduce((n, r) => {
    const i = [], o = r.weeks.reduce((a, s) => [...a, ...s.days], i);
    return [...n, ...o];
  }, t);
}
function Mne(e, t, n, r) {
  const { numberOfMonths: i = 1 } = n, o = [];
  for (let a = 0; a < i; a++) {
    const s = r.addMonths(e, a);
    if (t && s > t)
      break;
    o.push(s);
  }
  return o;
}
function AE(e, t) {
  const { month: n, defaultMonth: r, today: i = e.timeZone ? Vi.tz(e.timeZone) : t.Date ? new t.Date() : /* @__PURE__ */ new Date(), numberOfMonths: o = 1, endMonth: a, startMonth: s } = e;
  let l = n || r || i;
  const { differenceInCalendarMonths: c, addMonths: f, startOfMonth: d } = t;
  if (a && c(a, l) < 0) {
    const p = -1 * (o - 1);
    l = f(a, p);
  }
  return s && c(l, s) < 0 && (l = s), d(l);
}
class mL {
  constructor(t, n, r = Qs) {
    this.date = t, this.displayMonth = n, this.outside = !!(n && !r.isSameMonth(t, n)), this.dateLib = r;
  }
  /**
   * Check if the day is the same as the given day: considering if it is in the
   * same display month.
   */
  isEqualTo(t) {
    return this.dateLib.isSameDay(t.date, this.date) && this.dateLib.isSameMonth(t.displayMonth, this.displayMonth);
  }
}
class Nne {
  constructor(t, n) {
    this.date = t, this.weeks = n;
  }
}
class $ne {
  constructor(t, n) {
    this.days = n, this.weekNumber = t;
  }
}
function Dne(e, t, n, r) {
  const { startOfWeek: i, endOfWeek: o, startOfISOWeek: a, endOfISOWeek: s, endOfMonth: l, addDays: c, getWeek: f, getISOWeek: d } = r, p = e.reduce((m, y) => {
    const g = n.ISOWeek ? a(y) : i(y), v = n.ISOWeek ? s(l(y)) : o(l(y)), x = t.filter((A) => A >= g && A <= v);
    if (n.fixedWeeks && x.length < px) {
      const A = t.filter((_) => {
        const O = px - x.length;
        return _ > v && _ <= c(v, O);
      });
      x.push(...A);
    }
    const w = x.reduce((A, _) => {
      const O = n.ISOWeek ? d(_) : f(_), P = A.find((k) => k.weekNumber === O), C = new mL(_, y, r);
      return P ? P.days.push(C) : A.push(new $ne(O, [C])), A;
    }, []), S = new Nne(y, w);
    return m.push(S), m;
  }, []);
  return n.reverseMonths ? p.reverse() : p;
}
function Ine(e, t) {
  var g;
  let { startMonth: n, endMonth: r } = e;
  const { startOfYear: i, startOfDay: o, startOfMonth: a, endOfMonth: s, addYears: l, endOfYear: c } = t, { fromYear: f, toYear: d, fromMonth: p, toMonth: m } = e;
  !n && p && (n = p), !n && f && (n = new Date(f, 0, 1)), !r && m && (r = m), !r && d && (r = new Date(d, 11, 31));
  const y = (g = e.captionLayout) == null ? void 0 : g.startsWith("dropdown");
  if (n)
    n = a(n);
  else if (f)
    n = new Date(f, 0, 1);
  else if (!n && y) {
    const v = e.today ?? (e.timeZone ? Vi.tz(e.timeZone) : t.Date ? new t.Date() : /* @__PURE__ */ new Date());
    n = i(l(v, -100));
  }
  if (r)
    r = s(r);
  else if (d)
    r = new Date(d, 11, 31);
  else if (!r && y) {
    const v = e.today ?? (e.timeZone ? Vi.tz(e.timeZone) : t.Date ? new t.Date() : /* @__PURE__ */ new Date());
    r = c(v);
  }
  return [
    n && o(n),
    r && o(r)
  ];
}
function Rne(e, t, n, r) {
  if (n.disableNavigation)
    return;
  const { pagedNavigation: i, numberOfMonths: o = 1 } = n, { startOfMonth: a, addMonths: s, differenceInCalendarMonths: l } = r, c = i ? o : 1, f = a(e);
  if (!t)
    return s(f, c);
  if (!(l(t, e) < o))
    return s(f, c);
}
function jne(e, t, n, r) {
  if (n.disableNavigation)
    return;
  const { pagedNavigation: i, numberOfMonths: o } = n, { startOfMonth: a, addMonths: s, differenceInCalendarMonths: l } = r, c = i ? o ?? 1 : 1, f = a(e);
  if (!t)
    return s(f, -c);
  if (!(l(f, t) <= 0))
    return s(f, -c);
}
function Lne(e) {
  const t = [];
  return e.reduce((n, r) => [...n, ...r.weeks], t);
}
function Kg(e, t) {
  const [n, r] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(e);
  return [t === void 0 ? n : t, r];
}
function Bne(e, t) {
  const [n, r] = Ine(e, t), { startOfMonth: i, endOfMonth: o } = t, a = AE(e, t), [s, l] = Kg(a, e.month ? i(e.month) : void 0);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const O = AE(e, t);
    l(O);
  }, [e.timeZone]);
  const c = Mne(s, r, e, t), f = Ene(c, e.endMonth ? o(e.endMonth) : void 0, e, t), d = Dne(c, f, e, t), p = Lne(d), m = kne(d), y = jne(s, n, e, t), g = Rne(s, r, e, t), { disableNavigation: v, onMonthChange: x } = e, w = (O) => p.some((P) => P.days.some((C) => C.isEqualTo(O))), S = (O) => {
    if (v)
      return;
    let P = i(O);
    n && P < i(n) && (P = i(n)), r && P > i(r) && (P = i(r)), l(P), x == null || x(P);
  };
  return {
    months: d,
    weeks: p,
    days: m,
    navStart: n,
    navEnd: r,
    previousMonth: y,
    nextMonth: g,
    goToMonth: S,
    goToDay: (O) => {
      w(O) || S(O.date);
    }
  };
}
function Fne(e, t, n, r) {
  let i, o = 0, a = !1;
  for (; o < e.length && !a; ) {
    const s = e[o], l = t(s);
    !l[Lt.disabled] && !l[Lt.hidden] && !l[Lt.outside] && (l[Lt.focused] || r != null && r.isEqualTo(s) || n(s.date) || l[Lt.today]) && (i = s, a = !0), o++;
  }
  return i || (i = e.find((s) => {
    const l = t(s);
    return !l[Lt.disabled] && !l[Lt.hidden] && !l[Lt.outside];
  })), i;
}
function Po(e, t, n = !1, r = Qs) {
  let { from: i, to: o } = e;
  const { differenceInCalendarDays: a, isSameDay: s } = r;
  return i && o ? (a(o, i) < 0 && ([i, o] = [o, i]), a(t, i) >= (n ? 1 : 0) && a(o, t) >= (n ? 1 : 0)) : !n && o ? s(o, t) : !n && i ? s(i, t) : !1;
}
function gL(e) {
  return !!(e && typeof e == "object" && "before" in e && "after" in e);
}
function M_(e) {
  return !!(e && typeof e == "object" && "from" in e);
}
function yL(e) {
  return !!(e && typeof e == "object" && "after" in e);
}
function vL(e) {
  return !!(e && typeof e == "object" && "before" in e);
}
function bL(e) {
  return !!(e && typeof e == "object" && "dayOfWeek" in e);
}
function xL(e, t) {
  return Array.isArray(e) && e.every(t.isDate);
}
function Co(e, t, n = Qs) {
  const r = Array.isArray(t) ? t : [t], { isSameDay: i, differenceInCalendarDays: o, isAfter: a } = n;
  return r.some((s) => {
    if (typeof s == "boolean")
      return s;
    if (n.isDate(s))
      return i(e, s);
    if (xL(s, n))
      return s.includes(e);
    if (M_(s))
      return Po(s, e, !1, n);
    if (bL(s))
      return Array.isArray(s.dayOfWeek) ? s.dayOfWeek.includes(e.getDay()) : s.dayOfWeek === e.getDay();
    if (gL(s)) {
      const l = o(s.before, e), c = o(s.after, e), f = l > 0, d = c < 0;
      return a(s.before, s.after) ? d && f : f || d;
    }
    return yL(s) ? o(e, s.after) > 0 : vL(s) ? o(s.before, e) > 0 : typeof s == "function" ? s(e) : !1;
  });
}
function Wne(e, t, n, r, i, o, a) {
  const { ISOWeek: s } = o, { addDays: l, addMonths: c, addYears: f, addWeeks: d, startOfISOWeek: p, endOfISOWeek: m, startOfWeek: y, endOfWeek: g, max: v, min: x } = a;
  let S = {
    day: l,
    week: d,
    month: c,
    year: f,
    startOfWeek: (A) => s ? p(A) : y(A),
    endOfWeek: (A) => s ? m(A) : g(A)
  }[e](n, t === "after" ? 1 : -1);
  return t === "before" && r ? S = v([r, S]) : t === "after" && i && (S = x([i, S])), S;
}
function wL(e, t, n, r, i, o, a, s = 0) {
  if (s > 365)
    return;
  const l = Wne(
    e,
    t,
    n.date,
    // should be refDay? or refDay.date?
    r,
    i,
    o,
    a
  ), c = !!(o.disabled && Co(l, o.disabled, a)), f = !!(o.hidden && Co(l, o.hidden, a)), d = l, p = new mL(l, d, a);
  return !c && !f ? p : wL(e, t, p, r, i, o, a, s + 1);
}
function zne(e, t, n, r, i) {
  const { autoFocus: o } = e, [a, s] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(), l = Fne(t.days, n, r || (() => !1), a), [c, f] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(o ? l : void 0);
  return {
    isFocusTarget: (g) => !!(l != null && l.isEqualTo(g)),
    setFocused: f,
    focused: c,
    blur: () => {
      s(c), f(void 0);
    },
    moveFocus: (g, v) => {
      if (!c)
        return;
      const x = wL(g, v, c, t.navStart, t.navEnd, e, i);
      x && (t.goToDay(x), f(x));
    }
  };
}
function Vne(e, t, n) {
  const { disabled: r, hidden: i, modifiers: o, showOutsideDays: a, today: s } = t, { isSameDay: l, isSameMonth: c, startOfMonth: f, isBefore: d, endOfMonth: p, isAfter: m } = n, y = t.startMonth && f(t.startMonth), g = t.endMonth && p(t.endMonth), v = {
    [Lt.focused]: [],
    [Lt.outside]: [],
    [Lt.disabled]: [],
    [Lt.hidden]: [],
    [Lt.today]: []
  }, x = {};
  for (const w of e) {
    const { date: S, displayMonth: A } = w, _ = !!(A && !c(S, A)), O = !!(y && d(S, y)), P = !!(g && m(S, g)), C = !!(r && Co(S, r, n)), k = !!(i && Co(S, i, n)) || O || P || !a && _, I = l(S, s ?? (t.timeZone ? Vi.tz(t.timeZone) : n.Date ? new n.Date() : /* @__PURE__ */ new Date()));
    _ && v.outside.push(w), C && v.disabled.push(w), k && v.hidden.push(w), I && v.today.push(w), o && Object.keys(o).forEach(($) => {
      const N = o == null ? void 0 : o[$];
      N && Co(S, N, n) && (x[$] ? x[$].push(w) : x[$] = [w]);
    });
  }
  return (w) => {
    const S = {
      [Lt.focused]: !1,
      [Lt.disabled]: !1,
      [Lt.hidden]: !1,
      [Lt.outside]: !1,
      [Lt.today]: !1
    }, A = {};
    for (const _ in v) {
      const O = v[_];
      S[_] = O.some((P) => P === w);
    }
    for (const _ in x)
      A[_] = x[_].some((O) => O === w);
    return {
      ...S,
      // custom modifiers should override all the previous ones
      ...A
    };
  };
}
function Une(e, t) {
  const { selected: n, required: r, onSelect: i } = e, [o, a] = Kg(n, i ? n : void 0), s = i ? n : o, { isSameDay: l } = t, c = (m) => (s == null ? void 0 : s.some((y) => l(y, m))) ?? !1, { min: f, max: d } = e;
  return {
    selected: s,
    select: (m, y, g) => {
      let v = [...s ?? []];
      if (c(m)) {
        if ((s == null ? void 0 : s.length) === f || r && (s == null ? void 0 : s.length) === 1)
          return;
        v = s == null ? void 0 : s.filter((x) => !l(x, m));
      } else
        (s == null ? void 0 : s.length) === d ? v = [m] : v = [...v, m];
      return i || a(v), i == null || i(v, m, y, g), v;
    },
    isSelected: c
  };
}
function Hne(e, t, n = 0, r = 0, i = !1, o = Qs) {
  const { from: a, to: s } = t || {}, { isSameDay: l, isAfter: c, isBefore: f } = o;
  let d;
  if (!a && !s)
    d = { from: e, to: n > 0 ? void 0 : e };
  else if (a && !s)
    l(a, e) ? i ? d = { from: a, to: void 0 } : d = void 0 : f(e, a) ? d = { from: e, to: a } : d = { from: a, to: e };
  else if (a && s)
    if (l(a, e) && l(s, e))
      i ? d = { from: a, to: s } : d = void 0;
    else if (l(a, e))
      d = { from: a, to: n > 0 ? void 0 : e };
    else if (l(s, e))
      d = { from: e, to: n > 0 ? void 0 : e };
    else if (f(e, a))
      d = { from: e, to: s };
    else if (c(e, a))
      d = { from: a, to: e };
    else if (c(e, s))
      d = { from: a, to: e };
    else
      throw new Error("Invalid range");
  if (d != null && d.from && (d != null && d.to)) {
    const p = o.differenceInCalendarDays(d.to, d.from);
    r > 0 && p > r ? d = { from: e, to: void 0 } : n > 1 && p < n && (d = { from: e, to: void 0 });
  }
  return d;
}
function Kne(e, t, n = Qs) {
  const r = Array.isArray(t) ? t : [t];
  let i = e.from;
  const o = n.differenceInCalendarDays(e.to, e.from), a = Math.min(o, 6);
  for (let s = 0; s <= a; s++) {
    if (r.includes(i.getDay()))
      return !0;
    i = n.addDays(i, 1);
  }
  return !1;
}
function TE(e, t, n = Qs) {
  return Po(e, t.from, !1, n) || Po(e, t.to, !1, n) || Po(t, e.from, !1, n) || Po(t, e.to, !1, n);
}
function Gne(e, t, n = Qs) {
  const r = Array.isArray(t) ? t : [t];
  if (r.filter((s) => typeof s != "function").some((s) => typeof s == "boolean" ? s : n.isDate(s) ? Po(e, s, !1, n) : xL(s, n) ? s.some((l) => Po(e, l, !1, n)) : M_(s) ? s.from && s.to ? TE(e, { from: s.from, to: s.to }, n) : !1 : bL(s) ? Kne(e, s.dayOfWeek, n) : gL(s) ? n.isAfter(s.before, s.after) ? TE(e, {
    from: n.addDays(s.after, 1),
    to: n.addDays(s.before, -1)
  }, n) : Co(e.from, s, n) || Co(e.to, s, n) : yL(s) || vL(s) ? Co(e.from, s, n) || Co(e.to, s, n) : !1))
    return !0;
  const a = r.filter((s) => typeof s == "function");
  if (a.length) {
    let s = e.from;
    const l = n.differenceInCalendarDays(e.to, e.from);
    for (let c = 0; c <= l; c++) {
      if (a.some((f) => f(s)))
        return !0;
      s = n.addDays(s, 1);
    }
  }
  return !1;
}
function Yne(e, t) {
  const { disabled: n, excludeDisabled: r, selected: i, required: o, onSelect: a } = e, [s, l] = Kg(i, a ? i : void 0), c = a ? i : s;
  return {
    selected: c,
    select: (p, m, y) => {
      const { min: g, max: v } = e, x = p ? Hne(p, c, g, v, o, t) : void 0;
      return r && n && (x != null && x.from) && x.to && Gne({ from: x.from, to: x.to }, n, t) && (x.from = p, x.to = void 0), a || l(x), a == null || a(x, p, m, y), x;
    },
    isSelected: (p) => c && Po(c, p, !1, t)
  };
}
function qne(e, t) {
  const { selected: n, required: r, onSelect: i } = e, [o, a] = Kg(n, i ? n : void 0), s = i ? n : o, { isSameDay: l } = t;
  return {
    selected: s,
    select: (d, p, m) => {
      let y = d;
      return !r && s && s && l(d, s) && (y = void 0), i || a(y), i == null || i(y, d, p, m), y;
    },
    isSelected: (d) => s ? l(s, d) : !1
  };
}
function Xne(e, t) {
  const n = qne(e, t), r = Une(e, t), i = Yne(e, t);
  switch (e.mode) {
    case "single":
      return n;
    case "multiple":
      return r;
    case "range":
      return i;
    default:
      return;
  }
}
function Zne(e) {
  const { components: t, formatters: n, labels: r, dateLib: i, locale: o, classNames: a } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const tt = { ...Hg, ...e.locale };
    return {
      dateLib: new Qo({
        locale: tt,
        weekStartsOn: e.weekStartsOn,
        firstWeekContainsDate: e.firstWeekContainsDate,
        useAdditionalWeekYearTokens: e.useAdditionalWeekYearTokens,
        useAdditionalDayOfYearTokens: e.useAdditionalDayOfYearTokens
      }, e.dateLib),
      components: Jte(e.components),
      formatters: cne(e.formatters),
      labels: { ...Cne, ...e.labels },
      locale: tt,
      classNames: { ...ene(), ...e.classNames }
    };
  }, [
    e.classNames,
    e.components,
    e.dateLib,
    e.firstWeekContainsDate,
    e.formatters,
    e.labels,
    e.locale,
    e.useAdditionalDayOfYearTokens,
    e.useAdditionalWeekYearTokens,
    e.weekStartsOn
  ]), { captionLayout: s, mode: l, onDayBlur: c, onDayClick: f, onDayFocus: d, onDayKeyDown: p, onDayMouseEnter: m, onDayMouseLeave: y, onNextClick: g, onPrevClick: v, showWeekNumber: x, styles: w } = e, { formatCaption: S, formatDay: A, formatMonthDropdown: _, formatWeekNumber: O, formatWeekNumberHeader: P, formatWeekdayName: C, formatYearDropdown: k } = n, I = Bne(e, i), { days: $, months: N, navStart: D, navEnd: j, previousMonth: F, nextMonth: W, goToMonth: z } = I, H = Vne($, e, i), { isSelected: U, select: V, selected: Y } = Xne(e, i) ?? {}, { blur: Q, focused: ne, isFocusTarget: re, moveFocus: ce, setFocused: oe } = zne(e, I, H, U ?? (() => !1), i), { labelDayButton: fe, labelGridcell: ae, labelGrid: ee, labelMonthDropdown: se, labelNav: ge, labelWeekday: X, labelWeekNumber: $e, labelWeekNumberHeader: de, labelYearDropdown: ke } = r, it = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => mne(i, e.ISOWeek, e.timeZone), [i, e.ISOWeek, e.timeZone]), lt = l !== void 0 || f !== void 0, Xn = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    F && (z(F), v == null || v(F));
  }, [F, z, v]), Ie = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    W && (z(W), g == null || g(W));
  }, [z, W, g]), ct = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    St.preventDefault(), St.stopPropagation(), oe(tt), V == null || V(tt.date, Kt, St), f == null || f(tt.date, Kt, St);
  }, [V, f, oe]), Oe = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    oe(tt), d == null || d(tt.date, Kt, St);
  }, [d, oe]), Ge = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    Q(), c == null || c(tt.date, Kt, St);
  }, [Q, c]), Zt = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    const jn = {
      ArrowLeft: ["day", e.dir === "rtl" ? "after" : "before"],
      ArrowRight: ["day", e.dir === "rtl" ? "before" : "after"],
      ArrowDown: ["week", "after"],
      ArrowUp: ["week", "before"],
      PageUp: [St.shiftKey ? "year" : "month", "before"],
      PageDown: [St.shiftKey ? "year" : "month", "after"],
      Home: ["startOfWeek", "before"],
      End: ["endOfWeek", "after"]
    };
    if (jn[St.key]) {
      St.preventDefault(), St.stopPropagation();
      const [qr, lo] = jn[St.key];
      ce(qr, lo);
    }
    p == null || p(tt.date, Kt, St);
  }, [ce, p, e.dir]), mt = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    m == null || m(tt.date, Kt, St);
  }, [m]), en = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((tt, Kt) => (St) => {
    y == null || y(tt.date, Kt, St);
  }, [y]), { className: Yr, style: Cn } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({
    className: [a[Le.Root], e.className].filter(Boolean).join(" "),
    style: { ...w == null ? void 0 : w[Le.Root], ...e.style }
  }), [a, e.className, e.style, w]), yn = Qte(e), mr = {
    dayPickerProps: e,
    selected: Y,
    select: V,
    isSelected: U,
    months: N,
    nextMonth: W,
    previousMonth: F,
    goToMonth: z,
    getModifiers: H,
    components: t,
    classNames: a,
    styles: w,
    labels: r,
    formatters: n
  };
  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    cL.Provider,
    { value: mr },
    react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      t.Root,
      { className: Yr, style: Cn, dir: e.dir, id: e.id, lang: e.lang, nonce: e.nonce, title: e.title, ...yn },
      react__WEBPACK_IMPORTED_MODULE_1__.createElement(
        t.Months,
        { className: a[Le.Months], style: w == null ? void 0 : w[Le.Months] },
        !e.hideNavigati