document.addEventListener("DOMContentLoaded", () => {
  const claw = document.getElementById("claw");
  const button = document.getElementById("drop-btn");
  const resultBox = document.getElementById("result");

  const prizes = [
    { name: "Small Toy", chance: 50 },
    { name: "Medium Toy", chance: 30 },
    { name: "Big Toy", chance: 15 },
    { name: "Jackpot", chance: 5 },
  ];

  function playGame() {
    let rand = Math.floor(Math.random() * 100) + 1;
    let cumulative = 0;
    for (let prize of prizes) {
      cumulative += prize.chance;
      if (rand <= cumulative) return { won: true, prize: prize.name };
    }
    return { won: false, prize: null };
  }

  button.addEventListener("click", () => {
    claw.classList.add("dropping");
    resultBox.innerHTML = "🎯 Dropping...";

    setTimeout(() => {
      claw.classList.remove("dropping");
      const result = playGame();
      if (result.won) {
        resultBox.innerHTML = "🎉 You won: " + result.prize;
      } else {
        resultBox.innerHTML = "😢 Try again!";
      }
    }, 2000);
  });
});
