register_activation_hook(__FILE__, function () {
    if (!get_option('claw_game_prizes')) {
        $prizes = [
            ['name' => 'Small Toy', 'chance' => 50, 'count' => 10],
            ['name' => 'Medium Toy', 'chance' => 30, 'count' => 5],
            ['name' => 'Big Toy', 'chance' => 15, 'count' => 2],
            ['name' => 'Jackpot', 'chance' => 5, 'count' => 1],
        ];
        update_option('claw_game_prizes', $prizes);
    }
});


add_action('wp_ajax_claw_play', 'claw_play');
add_action('wp_ajax_nopriv_claw_play', 'claw_play');

function claw_play() {
    $prizes = get_option('claw_game_prizes');

    $random = rand(1, 100);
    $cumulative = 0;
    $prizeWon = null;

    foreach ($prizes as &$prize) {
        if ($prize['count'] > 0) { // only consider available prizes
            $cumulative += $prize['chance'];
            if ($random <= $cumulative) {
                $prizeWon = $prize['name'];
                $prize['count'] -= 1; // reduce stock
                break;
            }
        }
    }

    // Save updated stock
    update_option('claw_game_prizes', $prizes);

    wp_send_json([
        'won' => $prizeWon !== null,
        'prize' => $prizeWon,
        'prizes_left' => $prizes // return updated stock for display
    ]);
}
