document.addEventListener("DOMContentLoaded", () => {
  const claw = document.getElementById("claw");
  const button = document.getElementById("drop-btn");
  const resultBox = document.getElementById("result");

  button.addEventListener("click", () => {
    claw.classList.add("dropping");
    resultBox.innerHTML = "🎯 Dropping...";

    setTimeout(() => {
      claw.classList.remove("dropping");

      fetch(ajaxurl, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "action=claw_play"
      })
      .then(res => res.json())
      .then(data => {
        if (data.won) {
          resultBox.innerHTML = "🎉 You won: " + data.prize;
        } else {
          resultBox.innerHTML = "😢 Try again!";
        }

        // Show stock left
        let stock = "<h4>🎁 Prizes Left:</h4><ul>";
        data.prizes_left.forEach(p => {
          stock += `<li>${p.name}: ${p.count}</li>`;
        });
        stock += "</ul>";
        resultBox.innerHTML += stock;
      });
    }, 2000);
  });
});
