jQuery(document).ready(function($) {
    function sortDropdowns() {
        $("select[name='candidate[]']").each(function() {
            let select = $(this);
            let options = select.find("option").toArray();

            options.sort((a, b) => {
                let textA = $(a).text().toUpperCase();
                let textB = $(b).text().toUpperCase();
                return textA.localeCompare(textB);
            });

            select.empty().append(options);
        });
    }

    function updateDropdowns() {
        let selectedValues = new Set();

        // Collect selected values from all dropdowns
        $("select[name='candidate[]']").each(function() {
            if ($(this).val()) {
                selectedValues.add($(this).val());
            }
        });

        // Disable already selected values in other dropdowns
        $("select[name='candidate[]']").each(function() {
            let currentDropdown = $(this);
            let currentValue = currentDropdown.val();

            currentDropdown.find("option").each(function() {
                let optionValue = $(this).val();

                if (optionValue !== "" && selectedValues.has(optionValue) && optionValue !== currentValue) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        });
    }

    // Sort dropdown options on page load
    sortDropdowns();

    // Attach event listener to each dropdown to update on change
    $("select[name='candidate[]']").on("change", updateDropdowns);

    $("#survey-form").on("submit", function(event) {
        event.preventDefault();

        var candidates = []; 

        // Loop through all dropdowns and get selected values
        $("select[name='candidate[]']").each(function() {
            var selectedValue = $(this).val();
            if (selectedValue) {
                candidates.push(parseInt(selectedValue, 10)); // Convert to integer
            }
        });

        var email = $("#email").val();
        var remarks = $("#remarks").val() || "No comments provided"; // Default value

        if (candidates.length === 0 || !email) {
            alert("Please select at least one candidate and enter your email.");
            return false; // Stop execution
        }

        $.ajax({
            url: ajax_object.ajax_url,
            type: "POST",
            dataType: "json",
            data: {
                action: "submit_vote", 
                "candidateId[]": candidates, // Send as an array
                email: email,
                remarks: remarks
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data); // Show success message
                    window.location.href = "/thank-you";
                } else {
                    alert("Error: " + response.data);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log("AJAX Error:", textStatus, errorThrown);
                console.log("Response Text:", jqXHR.responseText);
                alert("There was an error submitting your vote.");
            }
        });

        return false; // Prevent form from reloading
    });
});
