<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

function enqueue_survey_scripts() {
    wp_enqueue_script('survey-script', get_stylesheet_directory_uri() . '/surveyData.js', array('jquery'), null, true);
    
    wp_localize_script('survey-script', 'ajax_object', array(
        'ajax_url' => admin_url('admin-ajax.php')
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_survey_scripts');

function survey_api_data() {
    $api_url1 = "http://192.168.102.106:3021/candidate/getCandidate";

    $response = wp_remote_get($api_url1);

    if (is_wp_error($response)) {
        return 'Something went wrong!';
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if ($data === null) {
        return 'Invalid API response!';
    }

    return $data;
}

add_action('wp_ajax_fetch_api_data', 'survey_api_data');
add_action('wp_ajax_nopriv_fetch_api_data', 'survey_api_data');

function top_candidate_short() { 
    $top = survey_api_data();
    if (is_string($top)) {
        return $top;
    }

    // Ensure $top is an array before sorting
    if (!is_array($top)) {
        return 'No candidates available.';
    }

    // Sort candidates in descending order based on total votes
    usort($top, function ($a, $b) {
        return $b['total_votes'] - $a['total_votes'];
    });

    $top = array_slice($top, 0, 12);
    $columns = 3; 
    $rows = ceil(count($top) / $columns);

    $output = '<div style="display: flex; gap: 20px;color: white;">';

    for ($col = 0; $col < $columns; $col++) {
        $output .= '<div style="flex: 1;">'; 
        for ($row = 0; $row < $rows; $row++) {
            $index = $row + ($col * $rows);
            if (isset($top[$index]) && $top[$index]['total_votes'] <= 100) {
                $output .= '<div>' . ($index + 1) . '. ' . esc_html($top[$index]['name']) . '</div>';
            }
        }
        $output .= '</div>';
    }

    $output .= '</div>';
    return $output;
}
add_shortcode('top_candidate', 'top_candidate_short');

function survey_short() {
    $survey = survey_api_data();

    if (is_string($survey)) {
        return $survey;
    }

    $output = '<div><form id="survey-form" action="" method="POST"><div>';

    if (!empty($survey)) {
        for ($i = 1; $i <= 12; $i++) {
            $output .= '<select name="candidate[]" class="candidate-dropdown" id="candidate-dropdown-' . $i . '">
                        <option value="" disabled selected>' . $i . '. Select Candidate</option>';
    
            foreach ($survey as $candidate) {
                $output .= '<option value="' . esc_html($candidate['candidateId']) . '">' . esc_html($candidate['name']) . '</option>';
            }
            $output .= '</select>';
        }
    } else {
        $output .= '<p>No data available.</p>';
    }
    
    $output .= '</div><div>
        <input type="email" id="email" name="email" placeholder="Enter your email" required><br>
        <input type="text" id="remarks" name="remarks" placeholder="Enter remarks"><br>
        <input type="submit" value="Submit" id="submit"></div>
    </form></div>';

    return $output;
}
add_shortcode('survey_api', 'survey_short');

function submit_vote_to_api() {

    // Ensure candidateId is an array
    $candidateIds = is_array($_POST['candidateId']) ? $_POST['candidateId'] : explode(',', $_POST['candidateId']);
    $candidateIds = array_map('intval', $candidateIds); // Convert to integers
    $email = sanitize_email($_POST['email']);
    $remarks = isset($_POST['remarks']) ? sanitize_textarea_field($_POST['remarks']) : "No comments provided";

    $api_url = "http://192.168.102.106:3021/vote/addVote/";

    $body = json_encode(array(
        'candidateId' => $candidateIds , 
        'email'        => $email,
        'remarks'      => $remarks,
    ));

    $response = wp_remote_post($api_url, array(
        'method'    => 'POST',
        'body'      => $body,
        'headers'   => array(
            'Content-Type' => 'application/json',
            'Accept'       => 'application/json',
        ),
        'timeout'   => 15,
    ));

    // Get the response status and body
    $status_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);

    // Log the response
    error_log('API Status Code: ' . $status_code);
    error_log('API Response: ' . print_r($response_body, true));

    if (is_wp_error($response)) {
        wp_send_json_error("Error: Failed to connect to API.");
    }

    $result = json_decode($response_body, true);
    
    if (!isset($result['success']) || !$result['success']) {
        if($status_code == 400 ) {
            wp_send_json_error("API response error: " . print_r($result, true));
        } else {
            wp_send_json_success("Vote successfully submitted");
        }
    }

}

add_action('wp_ajax_submit_vote', 'submit_vote_to_api');
add_action('wp_ajax_nopriv_submit_vote', 'submit_vote_to_api');




