<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Token extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-token';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Token', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title', [
                'label' => esc_html__('Sub Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tabs_option',
            [
                'label' => esc_html__('Tabs', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'active',
            [
                'label' => esc_html__('Active', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'xpress-core'),
                'label_off' => esc_html__('Hide', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'image', [
                'label' => esc_html__('Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__('Add Tab Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            't_text', [
                'label' => esc_html__('Token Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            't_content', [
                'label' => esc_html__('Token Content', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_option',
            [
                'label' => esc_html__('Button', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_gradient',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .sec-title__subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Sub Title Gradient Color', 'xpress-core'),
                    ]
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .sec-title__subtitle',
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title__title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .sec-title__title',
            ]
        );
        $this->add_control(
            'tab_style',
            [
                'label' => esc_html__('Tab Style', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'tab-c',
            [
                'label' => esc_html__('Tab Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token__tab .nav-item .nav-link' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_active-c',
            [
                'label' => esc_html__('Tab Active Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token__tab .nav-item .nav-link.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tab_gradient_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .token__tab .nav-item .nav-link::before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Tab Border Gradient Color', 'xpress-core'),
                    ]
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .token__tab .nav-item .nav-link',
            ]
        );

        $this->add_control(
            'price_sytle',
            [
                'label' => esc_html__('Price Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('Price Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token__info h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .token__info h2',
            ]
        );
        $this->add_control(
            't_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Content Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token__info p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .token__info p',
            ]
        );

        $this->add_control(
            'button_hr',
            [
                'label' => esc_html__('Button', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label' => esc_html__('Button BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .thm-btn',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="row align-items-center mt-none-30">
            <div class="col-lg-5 mt-30">
                <div class="token__content wow fadeInLeft">
                    <div class="sec-title mb-20">
                        <?php if (!empty($settings['sub_title'])): ?>
                            <h5 class="sec-title__subtitle"><?php echo esc_html($settings['sub_title']); ?></h5>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])): ?>
                            <h2 class="sec-title__title"><?php echo esc_html($settings['title']); ?></h2>
                        <?php endif; ?>
                    </div>
                    <ul class="nav nav-tabs token__tab" id="myTab" role="tablist">
                        <?php foreach ($settings['tabs'] as $tab): ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if ('yes' == $tab['active']) {
                                    echo esc_attr('active');
                                } ?>" id="<?php echo $tab['_id'] ?>-tab" data-bs-toggle="tab"
                                        data-bs-target="#<?php echo $tab['_id'] ?>"
                                        type="button" role="tab" aria-controls="<?php echo $tab['_id'] ?>"
                                        aria-selected="true"><?php echo esc_html($tab['title']); ?>
                                </button>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="token__info mt-40">
                        <?php if (!empty($settings['t_text'])): ?>
                            <h2><?php echo esc_html($settings['t_text']); ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['t_content'])): ?>
                            <p><?php echo wp_kses($settings['t_content'], true); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['btn_text'])): ?>
                            <div class="token-btn mt-40">
                                <a class="thm-btn" href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo esc_html($settings['btn_text']); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-7 mt-30">
                <div class="tab-content wow fadeInRight" data-wow-delay="100ms" id="myTabContent">
                    <?php foreach ($settings['tabs'] as $tab): ?>
                        <div class="tab-pane fade show <?php if ('yes' == $tab['active']) {
                            echo esc_attr('active');
                        } ?>" id="<?php echo $tab['_id'] ?>" role="tabpanel"
                             aria-labelledby="<?php echo $tab['_id'] ?>-tab">
                            <div class="token__img">
                                <?php echo wp_get_attachment_image($tab['image']['id'], 'full'); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Token());