<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Token_Info extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-token-info';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Token Info', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title_option',
            [
                'label' => esc_html__('Section Title', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sub_title', [
                'label' => esc_html__('Sub Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_option',
            [
                'label' => esc_html__('Image', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image', [
                'label' => esc_html__('Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape1', [
                'label' => esc_html__('Shape 1', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape2', [
                'label' => esc_html__('Shape 2', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->start_controls_tabs(
            'content_tabs'
        );

        $this->start_controls_tab(
            'left_tab',
            [
                'label' => esc_html__( 'Left', 'xpress-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'dot_color',
            [
                'label' => esc_html__('Dot Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}:before' => 'background-color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'lists1',
            [
                'label' => esc_html__('Add List Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'right_tab',
            [
                'label' => esc_html__( 'Right', 'xpress-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'dot_color',
            [
                'label' => esc_html__('Dot Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}:before' => 'background-color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'lists2',
            [
                'label' => esc_html__('Add List Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_gradient',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .sec-title__subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Sub Title Gradient Color', 'xpress-core'),
                    ]
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .sec-title__subtitle',
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title__title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .sec-title__title',
            ]
        );

        $this->add_control(
            'token_info_style',
            [
                'label' => esc_html__('Token Info Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__('Box BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token-info__list li' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            't_title_color',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token-info__list li h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_title_typography',
                'selector' => '{{WRAPPER}} .token-info__list li h4',
            ]
        );
        $this->add_control(
            't_content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            't_content_color',
            [
                'label' => esc_html__('Content Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .token-info__list li span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_content_typography',
                'selector' => '{{WRAPPER}} .token-info__list li span',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="token-info pos-rel pt-200 pb-150">
            <div class="container">
                <div class="row">
                    <div class="col-xl-8 offset-xl-4">
                        <div class="token-info__title sec-title mb-95 text-center text-xl-start">
                            <?php if (!empty($settings['sub_title'])): ?>
                                <h5 class="sec-title__subtitle"><?php echo esc_html($settings['sub_title']); ?></h5>
                            <?php endif;
                            if (!empty($settings['title'])): ?>
                                <h2 class="sec-title__title"><?php echo wp_kses($settings['title'], true); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4">
                        <?php if (!empty($settings['image']['id'])): ?>
                            <div class="token-info__img">
                                <?php echo wp_get_attachment_image($settings['image']['id'], 'full') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-8">
                        <div class="token-info--info-wrap ul_li">
                            <ul class="token-info__list token-info--start">
                                <?php foreach ($settings['lists1'] as $list): ?>
                                    <li class="elementor-repeater-item-<?php echo esc_attr( $list['_id'] )?>">
                                        <h4><?php echo esc_html($list['title']); ?></h4>
                                        <span><?php echo esc_html($list['content']); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <ul class="token-info__list token-info--end">
                                <?php foreach ($settings['lists2'] as $list): ?>
                                    <li class="elementor-repeater-item-<?php echo esc_attr( $list['_id'] )?>">
                                        <h4><?php echo esc_html($list['title']); ?></h4>
                                        <span><?php echo esc_html($list['content']); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="token-info__shape">
                <?php if ($settings['shape1']['id']): ?>
                    <div class="shape shape--1">
                        <?php echo wp_get_attachment_image($settings['shape1']['id'], 'full') ?>
                    </div>
                <?php endif; ?>
                <?php if ($settings['shape2']['id']): ?>
                    <div class="shape shape--2">
                        <?php echo wp_get_attachment_image($settings['shape2']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Token_Info());