<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Team_Two extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-team-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Team Two', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'avatar', [
                'label' => esc_html__('Avatar', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'desig', [
                'label' => esc_html__('Designation', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'socials',
            [
                'label' => esc_html__('Socials Profiles', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'facebook',
            [
                'label' => esc_html__('Facebook', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'twitter',
            [
                'label' => esc_html__('Twitter', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'linkedin',
            [
                'label' => esc_html__('Instagram', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'instagram',
            [
                'label' => esc_html__('Instagram', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'lists',
            [
                'label' => esc_html__('Add Team Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ],
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => esc_html__('Border Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__item' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .team__wrap' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_color',
            [
                'label' => esc_html__('Background Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_hover_color',
            [
                'label' => esc_html__('Background Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Name',
            [
                'label' => esc_html__('Name Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Name Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__info h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .team__info h3',
            ]
        );
        $this->add_control(
            'desig_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'desig_color',
            [
                'label' => esc_html__('Designation Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__info span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desig_typography',
                'selector' => '{{WRAPPER}} .team__info span',
            ]
        );
        $this->add_control(
            'social_style',
            [
                'label' => esc_html__('Social Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'social_color',
            [
                'label' => esc_html__('Social Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__social-link li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_bg_color',
            [
                'label' => esc_html__('Social BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__social-link li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_plus_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'social_plus_color',
            [
                'label' => esc_html__('Social Plus BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team__social .h-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="team__wrap ul_li">
            <?php
            foreach ($settings['lists'] as $list):
                ?>
                <div class="team__item">
                    <?php if (!empty($list['avatar']['id'])): ?>
                        <div class="avatar">
                            <?php echo wp_get_attachment_image($list['avatar']['id'], 'medium'); ?>
                        </div>
                    <?php endif; ?>
                    <div class="team__info text-center mb-20">
                        <?php if (!empty($list['name'])): ?>
                            <h3><?php echo esc_html($list['name']); ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($list['desig'])): ?>
                            <span><?php echo esc_html($list['desig']); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="team__social ul_li_center">
                        <ul class="team__social-link link-left ul_li">
                            <?php if (!empty($list['facebook']['url'])): ?>
                                <li><a href="<?php echo esc_url($list['facebook']['url']); ?>"><i
                                                class="fab fa-facebook-f"></i></a></li>
                            <?php endif;
                            if (!empty($list['twitter']['url'])): ?>
                                <li><a href="<?php echo esc_url($list['twitter']['url']); ?>"><i
                                                class="fab fa-twitter"></i></a></li>
                            <?php endif; ?>
                        </ul>
                        <span class="h-icon"><i class="far fa-plus"></i></span>
                        <ul class="team__social-link link-right ul_li">
                            <?php if (!empty($list['linkedin']['url'])): ?>
                                <li><a href="<?php echo esc_url($list['linkedin']['url']); ?>"><i
                                                class="fab fa-linkedin-in"></i></a></li>
                            <?php endif;
                            if (!empty($list['instagram']['url'])): ?>
                                <li><a href="<?php echo esc_url($list['instagram']['url']); ?>"><i
                                                class="fab fa-instagram"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Coindox_Team_Two());