<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Roadmap extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-roadmap';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Roadmap', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'line_shape_img',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .roadmap__list::before',
                'fields_options' => [
                    'background' => [
                        'label' => 'Line Shape Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_img',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .roadmap__list-inner',
                'fields_options' => [
                    'background' => [
                        'label' => 'Background Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_img2',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .roadmap__list-box:nth-child(even) .roadmap__list-inner',
                'fields_options' => [
                    'background' => [
                        'label' => 'Background Image 2'
                    ],
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'list', [
                'label' => esc_html__('List', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'lists',
            [
                'label' => esc_html__('Add List', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__list-inner h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .roadmap__list-inner h3',
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'list_color',
            [
                'label' => esc_html__('List Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__list-inner ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'list_typography',
                'selector' => '{{WRAPPER}} .roadmap__list-inner ul li',
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="roadmap__list pos-rel">
            <?php
            foreach ($settings['lists'] as $list):
            ?>
            <div class="roadmap__list-box">
                <div class="roadmap__list-inner">
                    <?php if (!empty($list['icon']['id'])): ?>
                        <div class="icon">
                            <?php echo wp_get_attachment_image($list['icon']['id'], 'thumbnail'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($list['title'])): ?>
                        <h3><?php echo wp_kses($list['title'], true); ?></h3>
                    <?php endif; ?>

                    <?php $features_list = $list['list'];
                    if(!empty($features_list)){
                        $features_list = explode("\n", ($features_list));
                        ?>
                        <ul class="list-unstyled">
                            <?php foreach($features_list as $features): ?>
                                <li><span><?php echo wp_kses($features, true); ?></span></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php
    }

}


Plugin::instance()->widgets_manager->register(new Coindox_Roadmap());