<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Roadmap_Two extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-roadmap-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Roadmap Two', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'shape_img', [
                'label' => esc_html__('Line Shape', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'start_date', [
                'label' => esc_html__('Start Date', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'end_date', [
                'label' => esc_html__('End Date', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'list', [
                'label' => esc_html__('List', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'year', [
                'label' => esc_html__('Year', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'item_color',
            [
                'label' => esc_html__('Item Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} svg path' => 'fill: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'lists',
            [
                'label' => esc_html__('Add List', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'year-box-styl',
            [
                'label' => esc_html__('Year Box Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'year_box_bg-c',
            [
                'label' => esc_html__('Year Box BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__year .year' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'year_title-c',
            [
                'label' => esc_html__('Year Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__year .year' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'year_title_typography',
                'selector' => '{{WRAPPER}} .roadmap__year .year',
            ]
        );

        $this->add_control(
            'icon_style',
            [
                'label' => esc_html__('Icon Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'xpress-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .roadmap__head .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border-c',
            [
                'label' => esc_html__('Border Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__head .icon' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .roadmap__item::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_style',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__head h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .roadmap__head h3',
            ]
        );
        $this->add_control(
            'lsit_hr',
            [
                'label' => esc_html__('List', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'list_color',
            [
                'label' => esc_html__('List Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .roadmap__info li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'list_typography',
                'selector' => '{{WRAPPER}} .roadmap__info li',
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="roadmap__wrap ul_li_between">
            <?php
            foreach ($settings['lists'] as $list):
                ?>
                <div class="roadmap__item">
                    <div class="roadmap__head ul_li">
                        <div class="icon elementor-repeater-item-<?php echo esc_attr( $list['_id'] )?>">
                            <?php \Elementor\Icons_Manager::render_icon($list['icon'], ['aria-hidden' => 'true']); ?>
                        </div>
                        <?php if (!empty($list['title'])): ?>
                            <h3><?php echo esc_html($list['title']); ?></h3>
                        <?php endif; ?>
                    </div>

                    <?php
                    $features_list = $list['list'];
                    if (!empty($features_list)) {
                        $features_list = explode("\n", ($features_list));
                        ?>
                        <ul class="roadmap__info list-unstyled">
                            <?php foreach ($features_list as $features): ?>
                                <li><?php echo wp_kses($features, true); ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php
                    }
                    ?>
                    <?php if (!empty($list['year'])): ?>
                        <span class="number elementor-repeater-item-<?php echo esc_attr( $list['_id'] )?>"><?php echo wp_kses($list['year'], true); ?></span>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
            <?php if (!empty($settings['shape_img']['id'])): ?>
                <div class="roadmap__shape">
                    <?php echo wp_get_attachment_image($settings['shape_img']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
            <div class="roadmap__year">
                <?php if (!empty($settings['start_date'])): ?>
                    <h3 class="year year--start"><?php echo esc_html($settings['start_date']); ?></h3>
                <?php endif; ?>
                <?php if (!empty($settings['end_date'])): ?>
                    <h3 class="year year--end"><?php echo esc_html($settings['end_date']); ?></h3>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }

}


Plugin::instance()->widgets_manager->register(new Coindox_Roadmap_Two());