<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Hero_Three extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-hero-three';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Hero Three', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'hero_content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_options',
            [
                'label' => esc_html__('Button Options', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_1', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link1',
            [
                'label' => esc_html__('Link', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_2',
            [
                'label' => esc_html__('Button 2', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_2', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link2',
            [
                'label' => esc_html__('Link', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'token_progress_option',
            [
                'label' => esc_html__('Token Progress', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'top_content',
            [
                'label' => esc_html__('Top Content', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'lists',
            [
                'label' => esc_html__('Add Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->add_control(
            'token_progress_width',
            [
                'label' => esc_html__('Token Progress Width', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 100,
                'step' => 1,
                'default' => 75,
            ]
        );
        $this->add_control(
            'bottom_content',
            [
                'label' => esc_html__('Bottom Content', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'lists_bottom',
            [
                'label' => esc_html__('Add Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'right_option',
            [
                'label' => esc_html__('Right Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'explore_causes_text', [
                'label' => esc_html__('Explore Causes', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'due_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'start_date', [
                'label' => esc_html__('Start Date Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'due_date',
            [
                'label' => esc_html__('Due Date', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DATE_TIME,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'image_option',
            [
                'label' => esc_html__('Image', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image', [
                'label' => esc_html__('Background Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'shape_option',
            [
                'label' => esc_html__('Shape', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'shape1', [
                'label' => esc_html__('Shape 1', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape2', [
                'label' => esc_html__('Shape 2', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape3', [
                'label' => esc_html__('Shape 3', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'coin_image_option',
            [
                'label' => esc_html__('Coin Image', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'coin1', [
                'label' => esc_html__('Coin 1', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'coin2', [
                'label' => esc_html__('Coin 2', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'coin3', [
                'label' => esc_html__('Coin 3', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'coin4', [
                'label' => esc_html__('Coin 4', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'coin5', [
                'label' => esc_html__('Coin 5', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'coin6', [
                'label' => esc_html__('Coin 6', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__content .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_clr_gradient',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .hero__content .title span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Title Gradient Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ttile_typography',
                'selector' => '{{WRAPPER}} .hero__content .title',
            ]
        );
        $this->add_control(
            'button_hr',
            [
                'label' => esc_html__('Button One', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Button BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_hover_color',
            [
                'label' => esc_html__('Button Hover BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .thm-btn',
            ]
        );
        $this->add_control(
            'button_dark_hr',
            [
                'label' => esc_html__('Button Dark', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_dark_bg_color',
            [
                'label' => esc_html__('Button BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn--dark' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn2_bg_hover_color',
            [
                'label' => esc_html__('Button Hover BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn--dark:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'progress_style',
            [
                'label' => esc_html__('Progress Style', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'progress_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .hero__progress .progress-bar',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Progress Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'pt_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'progress_title_color',
            [
                'label' => esc_html__('Progress Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__progress .progress-title span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .hero__progress ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_title_typography',
                'selector' => '
                        {{WRAPPER}} .hero__progress .progress-title span,
                        {{WRAPPER}} .hero__progress ul li',
            ]
        );
        $this->add_control(
            'explore_causes_title_hr',
            [
                'label' => esc_html__('Explore Causes', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'explore_causes_title_color',
            [
                'label' => esc_html__('Explore Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__explore span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'explore_causes_title_typography',
                'selector' => '  {{WRAPPER}} .hero__explore span',
            ]
        );
        $this->add_control(
            'ico_start_title_hr',
            [
                'label' => esc_html__('Ico Start Title', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'ico_start_title_color',
            [
                'label' => esc_html__('Ico Start Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__countdown h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ico_start_title_typography',
                'selector' => '  {{WRAPPER}} .hero__countdown h6',
            ]
        );
        $this->add_control(
            'ico_date_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'countdown_bg_color',
            [
                'label' => esc_html__('Countdown BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__countdown .countdown .single' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'count_number_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'count_number_color',
            [
                'label' => esc_html__('Countdown Number Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__countdown .countdown .single h1' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_number_typography',
                'selector' => '{{WRAPPER}} .hero__countdown .countdown .single h1',
            ]
        );
        $this->add_control(
            'count_title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'count_title_color',
            [
                'label' => esc_html__('Countdown Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__countdown .countdown .single p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_title_typography',
                'selector' => '{{WRAPPER}} .hero__countdown .countdown .single p',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <section class="hero hero__ico pos-rel">
            <div class="hero__bg" <?php if (!empty($settings['bg_image']['url'])): ?>
                 style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>"></div>
            <div class="container">
                <div class="row">
                    <div class="col-lg-7">
                        <div class="hero__content">
                            <?php if (!empty($settings['title'])): ?>
                                <h1 class="title mb-45"><?php echo wp_kses($settings['title'], true); ?></h1>
                            <?php endif; ?>
                            <div class="btns">
                                <?php if (!empty($settings['btn_1'])): ?>
                                    <a class="thm-btn"
                                       href="<?php echo esc_url($settings['btn_link1']['url']); ?>"><?php echo esc_html($settings['btn_1']); ?></a>
                                <?php endif; ?>
                                <?php if (!empty($settings['btn_2'])): ?>
                                    <a class="thm-btn thm-btn--dark"
                                       href="<?php echo esc_url($settings['btn_link2']['url']); ?>"><?php echo esc_html($settings['btn_2']); ?></a>
                                <?php endif; ?>
                            </div>
                            <div class="hero__progress mt-50">
                                <div class="progress-title ul_li_between">
                                    <?php foreach ($settings['lists'] as $list): ?>
                                        <span><?php echo wp_kses($list['title'], true); ?></span>
                                    <?php endforeach; ?>
                                </div>
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" style="width: 75%;" aria-valuenow="75"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <ul class="ul_li_between">
                                    <?php foreach ($settings['lists_bottom'] as $list): ?>
                                        <li><?php echo wp_kses($list['title'], true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="hero__explore-wrap text-center">
                            <?php if (!empty($settings['explore_causes_text'])): ?>
                                <div class="hero__explore text-center">
                                    <div class="scroll-down"></div>
                                    <span><?php echo esc_html($settings['explore_causes_text']); ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="hero__countdown">
                                <?php if (!empty($settings['start_date'])): ?>
                                    <h6 class="text-center"><?php echo esc_html($settings['start_date']); ?></h6>
                                <?php endif; ?>
                                <div class="countdown ul_li_center"
                                     data-countdown="<?php echo esc_attr($settings['due_date']); ?>"></div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="hero__shape">
                <?php if (!empty($settings['shape1']['id'])): ?>
                    <div class="shape shape--1">
                        <?php echo wp_get_attachment_image($settings['shape1']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['shape2']['id'])): ?>
                    <div class="shape shape--2">
                        <?php echo wp_get_attachment_image($settings['shape2']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['shape3']['id'])): ?>
                    <div class="shape shape--3">
                        <?php echo wp_get_attachment_image($settings['shape3']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="hero__coin">
                <?php if (!empty($settings['coin1']['id'])): ?>
                    <div class="coin coin--1">
                        <?php echo wp_get_attachment_image($settings['coin1']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['coin2']['id'])): ?>
                    <div class="coin coin--2">
                        <?php echo wp_get_attachment_image($settings['coin2']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['coin3']['id'])): ?>
                    <div class="coin coin--3">
                        <?php echo wp_get_attachment_image($settings['coin3']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['coin4']['id'])): ?>
                    <div class="coin coin--4">
                        <?php echo wp_get_attachment_image($settings['coin4']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['coin5']['id'])): ?>
                    <div class="coin coin--5">
                        <?php echo wp_get_attachment_image($settings['coin5']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['coin6']['id'])): ?>
                    <div class="coin coin--6">
                        <?php echo wp_get_attachment_image($settings['coin6']['id'], 'thumbnail'); ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Coindox_Hero_Three());