<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Hero_one extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-hero-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Hero One', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'bg_image_option',
            [
                'label' => esc_html__('Image', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'hero_content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'content', [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'hero_btn_option',
            [
                'label' => esc_html__('Button', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_1', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link1',
            [
                'label' => esc_html__('Link', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .blc-btn::before',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img_hover',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .blc-btn::after',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image Hover'
                    ],
                ],
            ]
        );
        $this->add_control(
            'button_2',
            [
                'label' => esc_html__('Button 2', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_2', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link2',
            [
                'label' => esc_html__('Link', 'xprss-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img2',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .blc-btn--white::before',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img_hover2',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .blc-btn--white::after',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image Hover'
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'feature_option',
            [
                'label' => esc_html__('Feature', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'lists',
            [
                'label' => esc_html__('Add Feature', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blockchain-hero__content .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'fttile_typography',
                'selector' => '{{WRAPPER}} .blockchain-hero__content .title',
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Content Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .hero__content p',
            ]
        );

        $this->add_control(
            'form_style',
            [
                'label' => esc_html__('Form Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'form_text_color',
            [
                'label' => esc_html__('Form Text Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__form input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Form BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__form input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'form_typography',
                'selector' => '{{WRAPPER}} .hero__form input',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'form_border_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .hero__form::before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Form Border Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'form_btn_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__form button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .hero__form button',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Gradient Color', 'xpress-core'),
                        'separator' => 'before',
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .hero__form button',
            ]
        );
        $this->add_control(
            'list_style',
            [
                'label' => esc_html__('List Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'list_color',
            [
                'label' => esc_html__('List Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'list_icon_color',
            [
                'label' => esc_html__('List Icon Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero__list li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'list_icon__bg_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .hero__list li i::after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Icon BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'list_typography',
                'selector' => '{{WRAPPER}} .hero__list li',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'gradient_bg_option',
            [
                'label' => esc_html__('Gradient Color', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'gradient_bg_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .hero__img-bg',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Gradient BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="hero hero__blockchain pos-rel bg_img" <?php if (!empty($settings['bg_image']['url'])): ?>
                 style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="blockchain-hero__content">
                            <?php if (!empty($settings['title'])): ?>
                                <h1 class="title text-80 mb-35 -tracking-2/4"><?php echo wp_kses($settings['title'], true); ?></h1>
                            <?php endif; ?>

                            <?php if (!empty($settings['content'])): ?>
                                <p class="mb-50 text-20 leading-30"><?php echo wp_kses($settings['content'], true); ?></p>
                            <?php endif; ?>
                            <div class="btns">
                                <?php if (!empty($settings['btn_1'])): ?>
                                    <a class="blc-btn" href="<?php echo esc_url($settings['btn_link1']['url']); ?>"><?php echo esc_html($settings['btn_1']); ?></a>
                                <?php endif; ?>
                                <?php if (!empty($settings['btn_2'])): ?>
                                    <a class="blc-btn blc-btn--white" href="<?php echo esc_url($settings['btn_link2']['url']); ?>"><?php echo esc_html($settings['btn_2']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="hero__blockchain-icon pos-rel">
                            <?php
                            $i = 0;
                            foreach ($settings['lists'] as $list):
                                $i++;
                            ?>
                            <div class="icon ul_li icon--<?php echo esc_attr($i); ?> absolute">
                                <?php if(!empty($list['title'])): ?>
                                <span class="text-white mr-5"><?php echo esc_html($list['title']); ?></span>
                                <?php endif; ?>
                                <?php echo wp_get_attachment_image($list['icon']['id'], 'full'); ?>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Coindox_Hero_one());