<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Faq_Tabs extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-faq-tabs';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('FAQ Tabs', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'xpress-core'),
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'ttl',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'xpress-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'template',
            [
                'type' => Controls_Manager::SELECT2,
                'options' => $this->template_select(),
                'multiple' => false,
                'label' => esc_html__('Template', 'thepack'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'lists',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta-box-styl',
            [
                'label' => esc_html__('Title Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'sec_title_option',
            [
                'label' => esc_html__('Section Title Style', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'sec_title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btc-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_border_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .border-left::before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Title Border Color', 'xpress-core'),
                    ]
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sec_title_typography',
                'selector' => '{{WRAPPER}} .btc-title',
            ]
        );

        $this->add_control(
            'tab_title_hr',
            [
                'label' => esc_html__('Tab Title', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq__nav li .nav-link' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_active-c',
            [
                'label' => esc_html__('Title Active Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq__nav li .nav-link.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .faq__nav li .nav-link',
            ]
        );

        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $nav = '';
        $out = '';
        $i = 0;
        foreach ($settings['lists'] as $a) {
            $i++;
            $id = 'd-' . $i;
            if ($i == '1') {
                $aria_true = 'true';
                $collapse_show = 'show active';

                $nav_active = 'active';
            } else {
                $aria_true = 'false';
                $collapse_show = '';

                $nav_active = '';
            }
            $nav .= '
      <li class="nav-item" role="presentation">
        <button class="nav-link ' . $nav_active . '" id="' . $id . '-tab" data-bs-toggle="tab" data-bs-target="#' . $id . '" type="button" role="tab" aria-controls="' . $id . '" aria-selected="' . $aria_true . '">' . $a['ttl'] . '</button>
      </li>    
    ';
            $out .= '
      <div class="tab-pane animated fadeInUp ' . $collapse_show . '" id="' . $id . '" role="tabpanel" aria-labelledby="' . $id . '-tab">
        ' . $this->render_template($a['template']) . '
      </div>
      ';
        }
        ?>
        <div class="row mb-20 align-items-end">
            <?php if (!empty($settings['title'])): ?>
                <div class="col-lg-6 col-md-5 mb-30">
                    <h2 class="btc-title border-left"><?php echo esc_html($settings['title']); ?></h2>
                </div>
            <?php endif; ?>
            <div class="col-lg-6 col-md-7 mb-20">
                <ul class="nav faq__nav ul_li_right nav-tabs" id="myTab" role="tablist">
                    <?php echo $nav; ?>
                </ul>
            </div>
        </div>
        <div class="faq__btc-wrap">
            <div class="tab-content" id="myTabContent">
                <?php echo $out; ?>
            </div>
        </div>
        <?php
    }

    protected function template_select()
    {
        $type = 'elementor_library';
        global $post;
        $args = array('numberposts' => -1, 'post_type' => $type,);
        $posts = get_posts($args);
        $categories = array(
            '' => __('Select', 'xpress-core'),
        );
        foreach ($posts as $pn_cat) {
            $categories[$pn_cat->ID] = get_the_title($pn_cat->ID);
        }
        return $categories;
    }

    protected function render_template($id)
    {
        return Plugin::instance()->frontend->get_builder_content_for_display($id);
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Faq_Tabs());