<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Advantages_Table extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-advantages-table';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Advantages Table', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_img',
                'label' => esc_html__('Background Image', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .advantages-table',
                'fields_options' => [
                    'background' => [
                        'label' => 'Background Image'
                    ],
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'th', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'thead',
            [
                'label' => esc_html__('Add Table Head', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ th }}}',
            ],
        );

        $this->add_control(
            'tabledata_hr',
            [
                'label' => esc_html__('Table Data', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'td', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'badge_active', [
                'label' => esc_html__('Badge Active Icon', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'badge_deactive', [
                'label' => esc_html__('Badge Deactive Icon', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'active',
            [
                'label' => esc_html__('Active', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'xpress-core'),
                'label_off' => esc_html__('No', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
            'active2',
            [
                'label' => esc_html__('Active 2', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'xpress-core'),
                'label_off' => esc_html__('No', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
            'active3',
            [
                'label' => esc_html__('Active 3', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'xpress-core'),
                'label_off' => esc_html__('No', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
            'active4',
            [
                'label' => esc_html__('Active 4', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'xpress-core'),
                'label_off' => esc_html__('No', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tbody',
            [
                'label' => esc_html__('Add Table Content', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ td }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'color_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_style',
            [
                'label' => esc_html__('Heading Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__('Heading Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-option__item .heading' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'selector' => '{{WRAPPER}} .user-option__item .heading',
            ]
        );

        $this->add_control(
            'list_style',
            [
                'label' => esc_html__('List Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-option__list li h4' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .user-option__list li h4',
            ]
        );
        $this->add_control(
            't_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Content Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-option__list li p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'list_typography',
                'selector' => '{{WRAPPER}} .user-option__list li p',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <table class="advantages-table table-responsive">
            <thead>
            <tr>
                <?php foreach ($settings['thead'] as $item): ?>
                    <th><?php echo esc_html($item['th']); ?></th>
                <?php endforeach; ?>
            </tr>
            </thead>
            <tbody>
            <?php
            foreach ($settings['tbody'] as $item):
                ?>
                <tr>
                    <td><?php echo esc_html($item['td']); ?></td>
                    <td>
                        <?php if ($item['active'] == true) { ?>
                            <img src="<?php echo esc_url($item['badge_active']['url']); ?>" alt="">
                        <?php } else { ?>
                            <img src="<?php echo esc_url($item['badge_deactive']['url']); ?>" alt="">
                        <?php } ?>
                    </td>
                    <td>
                        <?php if ($item['active2'] == true) { ?>
                            <img src="<?php echo esc_url($item['badge_active']['url']); ?>" alt="">
                        <?php } else { ?>
                            <img src="<?php echo esc_url($item['badge_deactive']['url']); ?>" alt="">
                        <?php } ?>
                    </td>
                    <td>
                        <?php if ($item['active3'] == true) { ?>
                            <img src="<?php echo esc_url($item['badge_active']['url']); ?>" alt="">
                        <?php } else { ?>
                            <img src="<?php echo esc_url($item['badge_deactive']['url']); ?>" alt="">
                        <?php } ?>
                    </td>
                    <td>
                        <?php if ($item['active4'] == true) { ?>
                            <img src="<?php echo esc_url($item['badge_active']['url']); ?>" alt="">
                        <?php } else { ?>
                            <img src="<?php echo esc_url($item['badge_deactive']['url']); ?>" alt="">
                        <?php } ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Coindox_Advantages_Table());