<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_About_Image extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-about-image';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About Image', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content Title', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'xpress-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'xpress-core'),
                    'style_2' => __('Style 2', 'xpress-core'),
                ],
                'default' => 'style_1',
            ]
        );
        $this->add_control(
            'img1', [
                'label' => esc_html__('Image 1', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'img2', [
                'label' => esc_html__('Image 2', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'img3', [
                'label' => esc_html__('Image 3', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'img4', [
                'label' => esc_html__('Image 3', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition' => [
                    'design_style' => 'style_2',
                ],
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if (!empty($settings['design_style']) and $settings['design_style'] == 'style_2'): ?>
        <div class="solution__img pos-rel">
            <?php echo wp_get_attachment_image($settings['img1']['id'], 'full'); ?>
            <div class="solution__img-sml">
                <?php if (!empty($settings['img2']['id'])): ?>
                    <div class="circle circle--1">
                        <div data-parallax='{"x" : -60}'>
                            <?php echo wp_get_attachment_image($settings['img2']['id'], 'full'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['img3']['id'])): ?>
                    <div class="circle circle--2">
                        <div data-parallax='{"x" : 60}'>
                            <?php echo wp_get_attachment_image($settings['img3']['id'], 'full'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['img4']['id'])): ?>
                    <div class="circle circle--3">
                        <div data-parallax='{"y" : -60}'>
                            <?php echo wp_get_attachment_image($settings['img4']['id'], 'full'); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="solution__icon">
                <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']); ?>
            </div>
        </div>
    <?php else: ?>
        <div class="blc-about__img pos-rel text-center">
            <?php echo wp_get_attachment_image($settings['img1']['id'], 'full'); ?>
            <?php if (!empty($settings['img2']['id'])): ?>
                <div class="shape shape--1">
                    <div data-parallax='{"y" : 60}'>
                        <?php echo wp_get_attachment_image($settings['img2']['id'], 'full'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['img3']['id'])): ?>
                <div class="shape shape--2">
                    <div data-parallax='{"y" : -60}'>
                        <?php echo wp_get_attachment_image($settings['img3']['id'], 'full'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="icon">
                <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']); ?>
            </div>
        </div>
    <?php
    endif;
    }
}

Plugin::instance()->widgets_manager->register(new Coindox_About_Image());