<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Header_Three extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'coindox-header-3';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Header Three', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_hf_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'logoop',
            [
                'label' => esc_html__('Logo Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'logo', [
                'label' => esc_html__('Logo', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_responsive_control(
            'logo_max_width',
            [
                'label' => esc_html__('Max Width', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5000,
                    ]
                ],

                'selectors' => [
                    '{{WRAPPER}} .header__logo img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'menu_select',
            [
                'label' => esc_html__('Menu Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose-menu',
            [
                'label' => esc_html__('Choose menu', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => coindox_menu_selector(),
                'multiple' => false
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'language_option',
            [
                'label' => esc_html__('Language Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'language_enable',
            [
                'label' => esc_html__('Enable or Disable Language', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'xpress-core'),
                'label_off' => esc_html__('Hide', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'language_img', [
                'label' => esc_html__('Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'language_label', [
                'label' => esc_html__('Language Label', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'ENGLISH', 'xpress-core' ),
                'condition' => [
                    'language_enable' => 'yes',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'img', [
                'label' => esc_html__('Image', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'label', [
                'label' => esc_html__('Language Label', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'EN', 'xpress-core' ),
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'languages',
            [
                'label' => esc_html__('Add language Item', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => [
                    'language_enable' => 'yes',
                ],
            ],
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'account_option',
            [
                'label' => esc_html__('Account Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'account_enable',
            [
                'label' => esc_html__('Enable or Disable Account', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'xpress-core'),
                'label_off' => esc_html__('Hide', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'account_icon',
            [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-user',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'account_label', [
                'label' => esc_html__('Account Label', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'Login', 'xpress-core' ),
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'account_link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'top_bar_style',
            [
                'label' => esc_html__('Top Bar Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'top__style',
            [
                'label' => esc_html__('Top Bar Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'gd-thumb-shape',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .header__top',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Top Bar BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'header-info-styl',
            [
                'label' => esc_html__('Info Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'info-c',
            [
                'label' => esc_html__('Info Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__top-info' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_typography',
                'selector' => '{{WRAPPER}} .header__top-info',
            ]
        );
        $this->add_control(
            'link-styl',
            [
                'label' => esc_html__('Link Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'link-c',
            [
                'label' => esc_html__('Link Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__links li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link_hover-c',
            [
                'label' => esc_html__('Link Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__links li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'selector' => '{{WRAPPER}} .header__links li a',
            ]
        );
        $this->add_control(
            'social-styl',
            [
                'label' => esc_html__('Social Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'social-icon-c',
            [
                'label' => esc_html__('Social Icon Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__social li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social-hover-icon-c',
            [
                'label' => esc_html__('Social Icon Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__social li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'menu_bar_style',
            [
                'label' => esc_html__('Menu Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu-c',
            [
                'label' => esc_html__('Menu Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'menu-hover-c',
            [
                'label' => esc_html__('Menu Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li .submenu li:hover > a, .main-menu ul li .submenu li.active > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'menu_typography',
                'selector' => '{{WRAPPER}} .main-menu ul li a',
            ]
        );

        $this->add_control(
            'language_style',
            [
                'label' => esc_html__('Language Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'lang_color',
            [
                'label' => esc_html__('Language Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__account a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'lang_typography',
                'selector' => '{{WRAPPER}} .header__account a',
            ]
        );
        $this->add_control(
            'lang-hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'lang_sub_color',
            [
                'label' => esc_html__('Language List Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__account .lang_sub_list li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'lang_list_typography',
                'selector' => '{{WRAPPER}} .header__account .lang_sub_list li a',
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Button BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .thm-btn',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sticky_header_enable = coindox_option('sticky_header_enable');

        ?>

        <header class="site-header header--transparent ico-header">
            <div class="header__main-wrap <?php if ($sticky_header_enable == true): ?> stricky <?php endif; ?>">
                <div class="container mxw_1640">
                    <div class="header__main ul_li_between">
                        <div class="header__left ul_li">
                            <div class="header__logo">
                                <a href="<?php if (!empty($settings['logolink']['url'])) {
                                    echo esc_url($settings['logolink']['url']);
                                } else {
                                    echo esc_url(home_url('/'));
                                } ?>"><img src="<?php echo esc_url($settings['logo']['url']); ?>" alt=""></a>
                            </div>
                        </div>
                        <div class="main-menu__wrap ul_li navbar navbar-expand-xl">
                            <nav class="main-menu collapse navbar-collapse">
                                <?php
                                echo str_replace(['sub-menu'], ['submenu'], wp_nav_menu(array(
                                    'echo' => false,
                                    'menu' => $settings['choose-menu'],
                                    'menu_id' => 'main-nav',
                                    'container' => false,
                                    'fallback_cb' => 'Coindox_Bootstrap_Navwalker::fallback',
                                )));
                                ?>
                            </nav>
                        </div>
                        <div class="header__action ul_li">
                            <div class="d-lg-none">
                                <a class="header__bar hamburger_menu" href="javascript:void(0);">
                                    <div class="header__bar-icon">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </a>
                            </div>
                            <?php if ($settings['language_enable'] == 'yes'): ?>
                                <div class="header__language">
                                    <div class="dropdown">
                                        <button class="dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <img src="<?php echo esc_url($settings['language_img']['url']); ?>" alt=""><?php echo esc_html($settings['language_label']); ?> <i class="fas fa-chevron-down"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <?php
                                            foreach ($settings['languages'] as $item):
                                                ?>
                                                <a class="dropdown-item" href="<?php echo esc_url($item['link']['url']); ?>"><img src="<?php echo esc_url($item['img']['url']); ?>" alt=""><?php echo esc_html($item['label']); ?></a>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['account_enable'] == 'yes'): ?>
                                <div class="header__account">
                                    <a href="<?php echo esc_url($settings['account_link']['url']); ?>"><span><?php \Elementor\Icons_Manager::render_icon( $settings['account_icon'], [ 'aria-hidden' => 'true' ] ); ?><?php echo esc_html($settings['account_label']); ?></span></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <aside class="slide-bar">
            <div class="close-mobile-menu">
                <a class="tx-close" href="javascript:void(0);"></a>
            </div>

            <!-- side-mobile-menu start -->
            <nav class="side-mobile-menu">
                <div class="header__logo mb-30">
                    <a href="<?php if (!empty($settings['logolink']['url'])) {
                        echo esc_url($settings['logolink']['url']);
                    } else {
                        echo esc_url(home_url('/'));
                    } ?>"><img src="<?php echo esc_url($settings['logo']['url']); ?>" alt=""></a>
                </div>

                <?php
                coindox_moble_search();
                ?>
                <?php
                echo str_replace(['menu-item-has-children'], ['dropdown'], wp_nav_menu(array(
                    'echo' => false,
                    'menu' => $settings['choose-menu'],
                    'menu_id' => 'mobile-menu-active',
                    'link_before' => '<span>', 'link_after' => '</span>',
                    'container' => false,
                    'fallback_cb' => 'Coindox_Bootstrap_Navwalker::fallback',
                )));
                ?>
            </nav>
            <!-- side-mobile-menu end -->
        </aside>
        <div class="body-overlay"></div>
        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Header_Three());