<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Footer_Three extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'coindox-footer-3';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer Three', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_hf_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'contact_option',
            [
                'label' => esc_html__('Contact ', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'c_title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'c_shortcode', [
                'label' => esc_html__('Shortcode', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'newsletter_option',
            [
                'label' => esc_html__('Newsletter', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'n_text', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'n_content', [
                'label' => esc_html__('Content', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'n_shortcode', [
                'label' => esc_html__('Shortcode', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'documents_option',
            [
                'label' => esc_html__('Documents', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'd_title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'documents',
            [
                'label' => esc_html__('Add document', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'logo_and_social',
            [
                'label' => esc_html__('Logo & Social', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'logo',
            [
                'label' => esc_html__('Logo', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'socials',
            [
                'label' => esc_html__('Add Social Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'copyright_option',
            [
                'label' => esc_html__('Copyright & Links', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'copyright_text', [
                'label' => esc_html__('Copyright Text', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'l_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'label', [
                'label' => esc_html__('Link Lablel', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'links',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_option',
            [
                'label' => esc_html__('Image & Shape', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            's_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'shape1',
            [
                'label' => esc_html__('Shape 1', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape2',
            [
                'label' => esc_html__('Shape 2', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape3',
            [
                'label' => esc_html__('Shape 3', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape4',
            [
                'label' => esc_html__('Shape 4', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape5',
            [
                'label' => esc_html__('Shape 5', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape6',
            [
                'label' => esc_html__('Shape 6', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape7',
            [
                'label' => esc_html__('Shape 7', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'list_style',
            [
                'label' => esc_html__('List Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'list_color',
            [
                'label' => esc_html__('List Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__top li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'list_icon_c',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .footer__top li i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Icon Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'list_icon_bg_c',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .footer__top li i::after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Icon BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'list_typography',
                'selector' => '{{WRAPPER}} .footer__top li',
            ]
        );
        $this->add_control(
            'list_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'list_border_color',
            [
                'label' => esc_html__('Border Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__top' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .footer__top li:nth-child(2)::before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .footer__top li:nth-child(2)::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__('Widget Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'widget_heading_color',
            [
                'label' => esc_html__('Heading Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget .widget-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'widget_heading_typography',
                'selector' => '{{WRAPPER}} .footer__widget .widget-title',
            ]
        );
        $this->add_control(
            'widget_link_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'widget_link_color',
            [
                'label' => esc_html__('Widget Link Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'widget_link_hover_color',
            [
                'label' => esc_html__('Widget Link Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'widget_link_typography',
                'selector' => '{{WRAPPER}} .footer__widget ul li a',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'copyright_style',
            [
                'label' => esc_html__('Copyright Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'copyright-bg-c',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .footer__copyright',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Copyright BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'copyright_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'copyright_text_color',
            [
                'label' => esc_html__('Copyright Text Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__copyright-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'copyright_text_typography',
                'selector' => '{{WRAPPER}} .footer__copyright-text',
            ]
        );
        $this->add_control(
            'b_social_options',
            [
                'label' => esc_html__('Social Options', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'b_social_color',
            [
                'label' => esc_html__('Social Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__social li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'b_social_hover_color',
            [
                'label' => esc_html__('Social Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__social li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

        <section class="ico-contact pos-rel">
            <div class="container">
                <div class="ico-contact__wrap">
                    <?php if (!empty($settings['c_title'])): ?>
                        <h2 class="title"><?php echo esc_html($settings['c_title']) ?></h2>
                    <?php endif; ?>

                    <?php echo do_shortcode($settings['c_shortcode']); ?>

                    <div class="ico-contact__shape-img">
                        <?php if (!empty($settings['shape1']['id'])): ?>
                            <div class="shape shape--1">
                                <div data-parallax='{"y" : -50}'>
                                    <?php echo wp_get_attachment_image($settings['shape1']['id'], 'full'); ?>
                                </div>
                            </div>
                        <?php endif;
                        if (!empty($settings['shape2']['id'])): ?>
                            <div class="shape shape--2">
                                <div data-parallax='{"y" : 60}'>
                                    <?php echo wp_get_attachment_image($settings['shape2']['id'], 'full'); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="ico-contact__shape">
                <?php if (!empty($settings['shape3']['id'])): ?>
                    <div class="shape shape--1">
                        <?php echo wp_get_attachment_image($settings['shape3']['id'], 'full'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['shape4']['id'])): ?>
                    <div class="shape shape--2">
                        <?php echo wp_get_attachment_image($settings['shape4']['id'], 'full'); ?>
                    </div>
                <?php endif;
                if (!empty($settings['shape5']['id'])): ?>
                    <div class="shape shape--3">
                        <?php echo wp_get_attachment_image($settings['shape5']['id'], 'full'); ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>

        <footer class="site-footer footer__ico pos-rel" <?php if (!empty($settings['bg_image']['url'])): ?>
                style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
            <div class="container">
                <div class="row mt-none-30">
                    <div class="col-lg-4 mt-30">
                        <div class="footer__widget footer__subscribe">
                            <?php if (!empty($settings['n_text'])): ?>
                                <h2><?php echo esc_html($settings['n_text']); ?></h2>
                            <?php endif; ?>

                            <?php if (!empty($settings['n_content'])): ?>
                                <p><?php echo wp_kses($settings['n_content'], true); ?></p>
                            <?php endif; ?>

                            <?php echo do_shortcode($settings['n_shortcode']); ?>
                        </div>
                    </div>
                    <div class="col-lg-8 mt-30">
                        <div class="footer__widget text-lg-end">
                            <?php if (!empty($settings['d_title'])): ?>
                                <h2><?php echo esc_html($settings['d_title']); ?></h2>
                            <?php endif; ?>
                            <div class="footer__document ul_li_right">
                                <?php
                                foreach ($settings['documents'] as $document):
                                    ?>
                                    <a href="<?php echo esc_url($document['link']['url']); ?>"
                                       class="footer__document-item text-center">
                                        <div class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon($document['icon'], ['aria-hidden' => 'true']); ?>
                                        </div>
                                        <span class="title"><i
                                                    class="fas fa-cloud-download-alt"></i><?php echo esc_html($document['title']); ?></span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer__bottom ul_li_between mt-50">
                    <?php if (!empty($settings['logo']['url'])): ?>
                        <div class="footer__logo mt-20">
                            <a href="<?php echo home_url('/'); ?>"><img
                                        src="<?php echo esc_url($settings['logo']['url']); ?>" alt="logo"></a>
                        </div>
                    <?php endif; ?>
                    <ul class="footer__social ul_li mt-20">
                        <?php foreach ($settings['socials'] as $item): ?>
                            <li>
                                <a href="<?php echo esc_url($item['link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <div class="footer__copyright mt-35">
                <div class="container">
                    <div class="footer__copyright-inner ul_li_between">
                        <?php if (!empty($settings['copyright_text'])): ?>
                            <div class="footer__copyright-text mt-15">
                                <?php echo esc_html($settings['copyright_text']); ?>
                            </div>
                        <?php endif; ?>
                        <ul class="footer__links ul_li_right mt-15">
                            <?php
                            foreach ($settings['links'] as $link):
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($link['link']['url']); ?>"><?php echo esc_html($link['label']); ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="footer__icon-shape">
                <?php if (!empty($settings['shape6']['id'])): ?>
                    <div class="icon icon--1">
                        <div data-parallax='{"x" : -80}'>
                            <?php echo wp_get_attachment_image($settings['shape6']['id'], 'full'); ?>
                        </div>
                    </div>
                <?php endif;
                if (!empty($settings['shape7']['id'])): ?>
                    <div class="icon icon--2">
                        <div data-parallax='{"x" : 80}'>
                            <?php echo wp_get_attachment_image($settings['shape7']['id'], 'full'); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </footer>

        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Footer_Three());