<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Header_Two extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'coindox-header-2';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Header Two', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_hf_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'logoop',
            [
                'label' => esc_html__('Logo Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'logo', [
                'label' => esc_html__('Logo', 'xpress-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_responsive_control(
            'logo_max_width',
            [
                'label' => esc_html__('Max Width', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5000,
                    ]
                ],

                'selectors' => [
                    '{{WRAPPER}} .header__logo img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'menu_select',
            [
                'label' => esc_html__('Menu Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose-menu',
            [
                'label' => esc_html__('Choose menu', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => coindox_menu_selector(),
                'multiple' => false
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'account_option',
            [
                'label' => esc_html__('Account Option', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'account_enable',
            [
                'label' => esc_html__('Enable or Disable Account', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'xpress-core'),
                'label_off' => esc_html__('Hide', 'xpress-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'account_icon',
            [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-user',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'account_label', [
                'label' => esc_html__('Account Label', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'Login', 'xpress-core' ),
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'account_link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'condition' => [
                    'account_enable' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'menu_bar_style',
            [
                'label' => esc_html__('Menu Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'men-hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'menu-c',
            [
                'label' => esc_html__('Menu Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'menu-hover-c',
            [
                'label' => esc_html__('Menu Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-menu ul li a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .main-menu ul li .submenu li:hover > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .main-menu ul li .main-menu ul li .submenu li.active > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'menu_typography',
                'selector' => '{{WRAPPER}} .main-menu ul li a',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'menu-hover-bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .main-menu > ul > li > a span::before, .main-menu > ul > li > a span::after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Menu Hover Border Color', 'xpress-core'),
                        'description' => esc_html__('Top Bar BG Color', 'xpress-core'),
                        'separator' => 'before',
                    ]
                ]
            ]
        );

        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .header__action .login',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Menu Hover Border Color', 'xpress-core'),
                        'description' => esc_html__('Top Bar BG Color', 'xpress-core'),
                        'separator' => 'before',
                    ]
                ]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header__action .login' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .header__action .login' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .header__action .login',
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sticky_header_enable = coindox_option('sticky_header_enable');
        ?>
        <header class="site-header header--transparent btc-header">
            <div class="header-area stricky">
                <div class="container">
                    <div class="header-wrap ul_li_between">
                        <div class="header__logo">
                            <a href="<?php if (!empty($settings['logolink']['url'])) {
                                echo esc_url($settings['logolink']['url']);
                            } else {
                                echo esc_url(home_url('/'));
                            } ?>"><img src="<?php echo esc_url($settings['logo']['url']); ?>" alt=""></a>
                        </div>
                        <div class="header__action ul_li">
                            <?php if ($settings['account_enable'] == 'yes'): ?>
                                <a class="login" href="<?php echo esc_url($settings['account_link']['url']); ?>"><span><?php \Elementor\Icons_Manager::render_icon( $settings['account_icon'], [ 'aria-hidden' => 'true' ] ); ?></span><?php echo esc_html($settings['account_label']); ?></a>
                            <?php endif; ?>
                            <a class="header__bar hamburger_menu" href="javascript:void(0);">
                                <div class="header__bar-icon">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <aside class="slide-bar slide-bar-bitcoin">
            <div class="close-mobile-menu">
                <a class="tx-close" href="javascript:void(0);"></a>
            </div>

            <!-- side-mobile-menu start -->
            <nav class="side-mobile-menu">
                <div class="header__logo mb-30">
                    <a href="<?php if (!empty($settings['logolink']['url'])) {
                        echo esc_url($settings['logolink']['url']);
                    } else {
                        echo esc_url(home_url('/'));
                    } ?>"><img src="<?php echo esc_url($settings['logo']['url']); ?>" alt=""></a>
                </div>

                <?php
                coindox_moble_search();
                ?>
                <?php
                echo str_replace(['menu-item-has-children'], ['dropdown'], wp_nav_menu(array(
                    'echo' => false,
                    'menu' => $settings['choose-menu'],
                    'menu_id' => 'mobile-menu-active',
                    'link_before' => '<span>', 'link_after' => '</span>',
                    'container' => false,
                    'fallback_cb' => 'Coindox_Bootstrap_Navwalker::fallback',
                )));
                ?>
            </nav>
            <!-- side-mobile-menu end -->
        </aside>
        <div class="body-overlay"></div>

        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Header_Two());