<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Footer_Two extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'coindox-footer-2';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer Two', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_hf_widgets'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'wdiget_1',
            [
                'label' => esc_html__('Widget 1', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'logo',
            [
                'label' => esc_html__('Logo', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            's_title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('QUICK CONTACT', 'xpress-core'),
                'label_block' => true,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'socials',
            [
                'label' => esc_html__('Add Social Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_2',
            [
                'label' => esc_html__('Widget 2', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title2', [
                'label' => esc_html__('Heading', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_links2',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_3',
            [
                'label' => esc_html__('Widget 3', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title3', [
                'label' => esc_html__('Heading', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_links3',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'copyright_option',
            [
                'label' => esc_html__('Copyright', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'copyright_text', [
                'label' => esc_html__('Copyright Text', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'footer_text', [
                'label' => esc_html__('Copyright Text Right', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'top_style',
            [
                'label' => esc_html__('Top Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bg_color',
            [
                'label' => esc_html__('Background Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-style-two' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'padding',
            [
                'label' => esc_html__('Padding', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-style-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_style',
            [
                'label' => esc_html__('Ttile Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_grd_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .crm-title__heading',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Title Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_title_typography',
                'selector' => '{{WRAPPER}} .crm-title__heading',
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Button Padding', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .crm-community .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_color',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .crm-community .thm-btn',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'btn_color-2',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .crm-community .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography2',
                'selector' => '{{WRAPPER}} .crm-community .thm-btn',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_area_style',
            [
                'label' => esc_html__('Content Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'content_area_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'cta_heading_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'cta_heading_color',
            [
                'label' => esc_html__('Cta Heading Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cta_heading_typography',
                'selector' => '{{WRAPPER}} .footer__cta .title',
            ]
        );
        $this->add_control(
            'cta_title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'cta_title_color',
            [
                'label' => esc_html__('Cta Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cta_title_typography',
                'selector' => '{{WRAPPER}} .footer__cta h4',
            ]
        );

        $this->add_control(
            'newsletter_style',
            [
                'label' => esc_html__('Newsletter Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'input_bg_color',
            [
                'label' => esc_html__('Input Background Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__newsletter input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'input_color',
            [
                'label' => esc_html__('Input Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__newsletter input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'selector' => '{{WRAPPER}} .footer__newsletter input',
            ]
        );
        $this->add_control(
            'form_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'gd-btn-c',
                'types' => ['gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .footer__newsletter button',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__newsletter button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .footer__newsletter button',
            ]
        );

        $this->add_control(
            'cta_number',
            [
                'label' => esc_html__('Cta Number', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'cta_number_color',
            [
                'label' => esc_html__('CTA Number Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta .cta-number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cta_bg_color',
            [
                'label' => esc_html__('CTA BG Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta .cta-number' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cta_number_typography',
                'selector' => '{{WRAPPER}} .footer__cta .cta-number',
            ]
        );

        $this->add_control(
            'social_options',
            [
                'label' => esc_html__('Social Options', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'social_color',
            [
                'label' => esc_html__('Social Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-social li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_bg_color',
            [
                'label' => esc_html__('Background Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-social li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link_options',
            [
                'label' => esc_html__('Link Options', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'link_color',
            [
                'label' => esc_html__('Link Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-link li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link_hover_color',
            [
                'label' => esc_html__('Link Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-link li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'selector' => '{{WRAPPER}} .footer__cta-link li a',
            ]
        );

        $this->add_control(
            'bottom_border_option',
            [
                'label' => esc_html__('Bottom Border Options', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'border_border_color',
            [
                'label' => esc_html__('Border Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-area' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'copyright_style',
            [
                'label' => esc_html__('Copyright Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'copyright_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'copyright_text_color',
            [
                'label' => esc_html__('Copyright Text Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__copyright-btc' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'copyright_text_typography',
                'selector' => '{{WRAPPER}} .footer__copyright-btc',
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

        <footer class="site-footer footer__btc pt-100">
            <div class="container">
                <div class="row mt-none-30 pb-100">
                    <div class="col-lg-4 col-md-6 mt-30">
                        <div class="footer__btc-about pl-40">
                            <a href="<?php echo esc_url(home_url( '/' )); ?>" class="footer__logo">
                                <img src="<?php echo esc_url($settings['logo']['url']); ?>" alt="logo">
                            </a>

                            <div class="footer__btc-social mt-110">
                                <?php if (!empty($settings['s_title'])): ?>
                                    <span><?php echo esc_html($settings['s_title']); ?></span>
                                <?php endif; ?>
                                <ul class="footer__social ul_li">
                                    <?php
                                    foreach ($settings['socials'] as $social):
                                        ?>
                                        <li>
                                            <a href="<?php echo esc_url($social['link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social['icon'], ['aria-hidden' => 'true']); ?></a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-30">
                        <div class="footer__widget-btc">
                            <?php if (!empty($settings['w_title2'])): ?>
                                <h3><?php echo esc_html($settings['w_title2']); ?></h3>
                            <?php endif; ?>
                            <ul class="footer__btc-links list-unstyled">
                                <?php
                                foreach ($settings['w_links2'] as $w_link):
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($w_link['link']['url']); ?>"><?php echo esc_html($w_link['title']); ?></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-30">
                        <div class="footer__widget-btc">
                            <?php if (!empty($settings['w_title3'])): ?>
                                <h3><?php echo esc_html($settings['w_title3']); ?></h3>
                            <?php endif; ?>
                            <ul class="footer__btc-links list-unstyled">
                                <?php
                                foreach ($settings['w_links3'] as $w_link):
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($w_link['link']['url']); ?>"><?php echo esc_html($w_link['title']); ?></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="footer__copyright-btc ul_li_between">
                    <?php if (!empty($settings['copyright_text'])): ?>
                        <div class="copyright-text mt-15">
                            <?php echo esc_html($settings['copyright_text']); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($settings['footer_text'])): ?>
                        <div class="footer-text mt-15">
                            <?php echo esc_html($settings['footer_text']); ?>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </footer>
        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Footer_Two());