<?php

/**
 * Elementor Single Widget
 * @package xpress-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Coindox_Footer_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'coindox-footer-1';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer One', 'xpress-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'xpress-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['coindox_hf_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'bg_image_option',
            [
                'label' => esc_html__('Image', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'newsletter_option',
            [
                'label' => esc_html__('Newsletter', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'n_title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Get regular updates', 'xpress-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shortcode', [
                'label' => esc_html__('Newsletter Shortcode', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .footer__newsletter-form button::before',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_img_hover',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .footer__newsletter-form button::after',
                'fields_options' => [
                    'background' => [
                        'label' => 'Button BG Image Hover'
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_1',
            [
                'label' => esc_html__('Widget 1', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title1', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'w_btn', [
                'label' => esc_html__('Button Text', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_icon',
            [
                'label' => esc_html__( 'Icon', 'xpress-core' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'w_btn_link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_2',
            [
                'label' => esc_html__('Widget 2', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title2', [
                'label' => esc_html__('Heading', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_links2',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_3',
            [
                'label' => esc_html__('Widget 3', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title3', [
                'label' => esc_html__('Heading', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_links3',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wdiget_4',
            [
                'label' => esc_html__('Widget 4', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'w_title4', [
                'label' => esc_html__('Heading', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'xpress-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_links4',
            [
                'label' => esc_html__('Add Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ],
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'copyright_option',
            [
                'label' => esc_html__('Copyright', 'xpress-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'copyright_text', [
                'label' => esc_html__('Copyright Text', 'xpress-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'xpress-core'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Link', 'xpress-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'f_socials',
            [
                'label' => esc_html__('Add Social Links', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_option',
            [
                'label' => esc_html__('Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'newsletter_style',
            [
                'label' => esc_html__('Newsletter Style', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'n_title_color',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title__title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'n_title_typography',
                'selector' => '{{WRAPPER}} .sec-title__title',
            ]
        );
        $this->add_control(
            'i_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'input_color',
            [
                'label' => esc_html__('Input Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__newsletter-form input' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'selector' => '{{WRAPPER}} .footer__newsletter-form input',
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__newsletter-form button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .footer__newsletter-form button',
            ]
        );

        $this->add_control(
            'bottom_border_option',
            [
                'label' => esc_html__('Bottom Border Options', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'border_border_color',
            [
                'label' => esc_html__('Border Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__cta-area' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__('Widget Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'community_widget_options',
            [
                'label' => esc_html__('Community Widget Options', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'gradient_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .footer__widget-community',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Community BG Color', 'xpress-core'),
                    ]
                ]
            ]
        );

        $this->add_control(
            'c_title_color',
            [
                'label' => esc_html__('Title Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget-community h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'c_title_typography',
                'selector' => '{{WRAPPER}} .footer__widget-community h3',
            ]
        );
        $this->add_control(
            'community_button',
            [
                'label' => esc_html__('Community Button', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'c_btn_color',
            [
                'label' => esc_html__('Button Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget-community a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'c_btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget-community a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'w_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'widget_heading_color',
            [
                'label' => esc_html__('Heading Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'widget_heading_typography',
                'selector' => '{{WRAPPER}} .footer__widget h3',
            ]
        );
        $this->add_control(
            'widget_link_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'widget_link_color',
            [
                'label' => esc_html__('Widget Link Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget-links li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'widget_link_hover_color',
            [
                'label' => esc_html__('Widget Link Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__widget-links li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'widget_link_typography',
                'selector' => '{{WRAPPER}} .footer__widget-links li a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'copyright_style',
            [
                'label' => esc_html__('Copyright Style', 'xpress-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'copyright_text_color',
            [
                'label' => esc_html__('Copyright Text Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__copyright-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'copyright_text_typography',
                'selector' => '{{WRAPPER}} .footer__copyright-text',
            ]
        );
        $this->add_control(
            'b_social_options',
            [
                'label' => esc_html__('Social Options', 'xpress-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'b_social_color',
            [
                'label' => esc_html__('Social Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer__copyright-blc .footer__social li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'b_social_hover_color',
            [
                'label' => esc_html__('Social Hover Color', 'xpress-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ..footer__copyright-blc .footer__social li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'social_bg_img',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .footer__copyright-blc .footer__social li a::before',
                'fields_options' => [
                    'background' => [
                        'label' => 'Social BG Image'
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'social_img_hover',
                'label' => esc_html__('Background', 'xpress-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .footer__copyright-blc .footer__social li a::after',
                'fields_options' => [
                    'background' => [
                        'label' => 'Social Image Hover'
                    ],
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

        <footer class="site-footer footer__blockchain pos-rel pt-95 bg_img" <?php if (!empty($settings['bg_image']['url'])): ?>
                style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
            <div class="container">
                <div class="footer__newsletter ul_li_between mt-none-30">
                    <?php if (!empty($settings['n_title'])): ?>
                        <div class="sec-title style2 mt-30">
                            <h2 class="sec-title__title text-50"><?php echo esc_html($settings['n_title']); ?></h2>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['shortcode'])): ?>
                        <div class="footer__newsletter-form mt-30">
                            <?php echo do_shortcode($settings['shortcode']); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="row mt-none-30 pb-70">
                    <div class="col-lg-4 col-md-6 col-sm-6 mt-30">
                        <div class="footer__widget">
                            <div class="footer__widget-community text-center">
                                <?php if (!empty($settings['w_title1'])): ?>
                                    <h3><?php echo wp_kses($settings['w_title1'], true); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($settings['w_btn'])): ?>
                                    <a href="<?php echo esc_url($settings['w_btn_link']['url']) ?>"><span><?php \Elementor\Icons_Manager::render_icon( $settings['w_icon'], [ 'aria-hidden' => 'true' ] ); ?></span><?php echo esc_html($settings['w_btn']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mt-30">
                        <div class="footer__widget">
                            <?php if (!empty($settings['w_title2'])): ?>
                                <h3><?php echo esc_html($settings['w_title2']); ?></h3>
                            <?php endif; ?>
                            <ul class="footer__widget-links list-unstyled">
                                <?php
                                foreach ($settings['w_links2'] as $w_link):
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($w_link['link']['url']); ?>"><?php echo esc_html($w_link['title']); ?></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mt-30">
                        <div class="footer__widget">
                            <?php if (!empty($settings['w_title3'])): ?>
                                <h3><?php echo esc_html($settings['w_title3']); ?></h3>
                            <?php endif; ?>
                            <ul class="footer__widget-links list-unstyled">
                                <?php
                                foreach ($settings['w_links3'] as $w_link):
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($w_link['link']['url']); ?>"><?php echo esc_html($w_link['title']); ?></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6 mt-30">
                        <div class="footer__widget">
                            <?php if (!empty($settings['w_title4'])): ?>
                                <h3><?php echo esc_html($settings['w_title4']); ?></h3>
                            <?php endif; ?>
                            <ul class="footer__widget-links list-unstyled">
                                <?php
                                foreach ($settings['w_links4'] as $w_link):
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($w_link['link']['url']); ?>"><?php echo esc_html($w_link['title']); ?></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="footer__copyright-blc ul_li_between">
                    <?php if (!empty($settings['copyright_text'])): ?>
                        <div class="footer__copyright-text mt-15">
                            <?php echo esc_html($settings['copyright_text']); ?>
                        </div>
                    <?php endif; ?>
                    <ul class="footer__social ul_li mt-15">
                        <?php
                        foreach ($settings['f_socials'] as $social):
                            ?>
                            <li>
                                <a href="<?php echo esc_url($social['link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social['icon'], ['aria-hidden' => 'true']); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </footer>
        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Coindox_Footer_One());